/*
 *  
 *  $Id: controladorenviohl7.h 3787 2011-04-29 06:38:01Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladorhl7.h>
#include <wx/thread.h>

class wxSQLite3Database;
class wxCriticalSection;

namespace GIL {
	namespace HL7 {
		class EXTAPI ControladorEnvioHl7:  protected wxThread
		{
		public:
			static void FreeInstance();
			static void Arrancar();
			static bool EstaArrancado();
			void Abortar();
			bool EstaAbortado();

		protected:
			static ControladorEnvioHl7* m_pInstance;
			static wxCriticalSection m_criticalSection;

			ControladorEnvioHl7();
			~ControladorEnvioHl7();

			virtual void* Entry();

			/* Envia el mensaje por MLLP */
			void EnviarMensajeMLLP(const std::string& msg, const std::string& url, bool procesarACK=true, const std::string& msgControlId="") const;

			bool ProcesarMensajes();
			
			bool m_Abortado;
		};
	}
}
