/*
 *  
 *  $Id: toolwindowlevellight.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/aui/aui.h>
#include <wx/stattext.h>
#include <wx/combobox.h>
#include <wx/valtext.h>
#include <wx/textctrl.h>

#include <api/api.h>
#include <api/globals.h>
#include <api/inotificadoresherramientas.h>

#include "toolwindowlevellight.h"
#include <api/iwidgetsmanager.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <eventos/eventosginkgo.h>

#define COMBO_WINDOW_LEVEL 6051
#define RESETEAR_WINDOWLEVEL 6052
#define COMBO_WINDOW_LEVEL_PREDEFINIDO 6053
#define TEXTCTRL_WLW_MANUAL 6054
#define TEXTCTRL_WLL_MANUAL 6055
#define WWTEXT 6056
#define WLTEXT 6057

namespace LightVisualizator {
	namespace GUI {
		class HerramientaOpcionesWindowLevelGUI : public AUI_NAMESPACE wxAuiToolBar {
		public:
			HerramientaOpcionesWindowLevelGUI(wxWindow* pParent, LightVisualizator::ToolWindowLevelLight* pHerramienta):AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize, AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE | AUI_NAMESPACE wxAUI_TB_HORZ_TEXT )
			{
				m_labelUserDefined = _Std("User Defined");

				m_pHerramienta = pHerramienta;

				SetToolBitmapSize( wxSize( 16,16 ) );

				AddLabel(wxID_ANY, _("Profile"), 35);

				m_pComboBox = new wxComboBox(this,COMBO_WINDOW_LEVEL, _("DICOM Window/Level"), wxDefaultPosition, wxDefaultSize, 0, NULL, wxCB_DROPDOWN|wxCB_READONLY );
				AddControl( m_pComboBox, _("DICOM Window/Level"));
				AddSeparator();


				AddLabel(wxID_ANY, _(" WW"), 20);
				m_textCtrlWW = new wxTextCtrl( this, TEXTCTRL_WLW_MANUAL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER|wxTE_PROCESS_TAB );
				AddControl( m_textCtrlWW, _("Manual Window/Level"));
				m_textCtrlWW->SetValidator( wxTextValidator( wxFILTER_NUMERIC ) );
				AddLabel(wxID_ANY, _(" WL"), 20);
				m_textCtrlWL = new wxTextCtrl( this, TEXTCTRL_WLL_MANUAL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER|wxTE_PROCESS_TAB );
				AddControl( m_textCtrlWL, _("Manual Window/Level"));
				m_textCtrlWL->SetValidator( wxTextValidator( wxFILTER_NUMERIC ) );

				AddSeparator();
				AddTool( RESETEAR_WINDOWLEVEL, _("Reset"), GinkgoResourcesManager::BarraWindowLevel::GetIcoReset(), _("Reset Window/Level") );

				Realize();
				m_opcionPersonal = -1;

				Layout();

				// Connect Events
				this->Connect( COMBO_WINDOW_LEVEL, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnComboBoxChanged ) );
				m_textCtrlWL->Connect( wxEVT_CHAR, wxKeyEventHandler( HerramientaOpcionesWindowLevelGUI::OnChar ), NULL, this );
				m_textCtrlWW->Connect( wxEVT_CHAR, wxKeyEventHandler( HerramientaOpcionesWindowLevelGUI::OnChar ), NULL, this );
				this->Connect( TEXTCTRL_WLW_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Connect( TEXTCTRL_WLL_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Connect( RESETEAR_WINDOWLEVEL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnBResetearClick ) );
			}

			~HerramientaOpcionesWindowLevelGUI(){
				// Disconnect Events
				m_textCtrlWL->Disconnect( wxEVT_CHAR, wxKeyEventHandler( HerramientaOpcionesWindowLevelGUI::OnChar ), NULL, this );
				m_textCtrlWW->Disconnect( wxEVT_CHAR, wxKeyEventHandler( HerramientaOpcionesWindowLevelGUI::OnChar ), NULL, this );
				this->Disconnect( RESETEAR_WINDOWLEVEL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnBResetearClick ) );
				this->Disconnect( COMBO_WINDOW_LEVEL, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnComboBoxChanged ) );
				this->Disconnect( TEXTCTRL_WLW_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Disconnect( TEXTCTRL_WLL_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
			}

			virtual void OnBResetearClick( wxCommandEvent&  ){
				m_pHerramienta->Resetear();
			}

			virtual void OnChar(wxKeyEvent &event) {
				if (event.GetKeyCode() == WXK_TAB) {
					if (event.GetEventObject() == m_textCtrlWL) {
						m_textCtrlWW->SetFocus();
					} else {
						m_textCtrlWL->SetFocus();
					}
				} else {
					event.Skip(true);
				}
			}

			virtual void OnComboBoxChanged( wxCommandEvent&  ){
				wxString wLStr, wWStr;
				GNC::GCS::IContractWindowLevel::WindowLevel selectedWL;

				selectedWL=((*m_pListaWindowLevels)[m_pComboBox->GetCurrentSelection()]);
				m_pHerramienta->SetWindowLevel((*m_pListaWindowLevels)[m_pComboBox->GetCurrentSelection()]);
				wWStr << selectedWL.m_window;
				wLStr << selectedWL.m_level;
				m_textCtrlWW->SetValue(wWStr);
				m_textCtrlWL->SetValue(wLStr);
			}

			virtual void OnTextEntered1( wxCommandEvent&  ){
				double newWindowWidth = 0.0f;
				double newWindowLevel = 0.0f;
				double newWindowWidthClamped = newWindowWidth;
				double newWindowLevelClamped = newWindowLevel;

				wxString strW, strL;

				m_textCtrlWW->GetValue().ToDouble(&newWindowWidth);
				m_textCtrlWL->GetValue().ToDouble(&newWindowLevel);

				m_pHerramienta->ClampWindowLevel(newWindowWidth, newWindowLevel, newWindowWidthClamped, newWindowLevelClamped);

				if (newWindowWidth != newWindowWidthClamped)
				{
					m_textCtrlWW->SetValue(wxString::Format(wxT("%.2f"), newWindowWidthClamped));
				}
				if (newWindowLevel != newWindowLevelClamped)
				{
					m_textCtrlWL->SetValue(wxString::Format(wxT("%.2f"), newWindowLevelClamped));
				}

				ModificarOpcionPersonal(newWindowWidthClamped, newWindowLevelClamped);
			}

			void ConfigurarCombo(GNC::GCS::IContractWindowLevel::ListaWindowLevels* pListaWindowLevels, const std::string& m_labelCurrent, double window, double level){
				m_pListaWindowLevels = pListaWindowLevels;
				m_pComboBox->Clear();
				m_opcionPersonal = -1;

				if((*m_pListaWindowLevels).size()>0){
					int i=0;
					int seleccionado = -1;
					for(GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
						wxString str;
						if((*it).m_type == GNC::GCS::IContractWindowLevel::WindowLevel::TWLT_USER_DEFINED){
							str = wxString::Format(wxT("User defined: %.2f/%.2f"),(*it).m_window,(*it).m_level);
						} else {
							str = wxString::FromUTF8((*it).m_label.c_str()) + wxString::Format(wxT(": %.2f/%.2f"),(*it).m_window,(*it).m_level);
						}
						m_pComboBox->AppendString( str );
						if((*it).m_label == m_labelCurrent){
							seleccionado = i;
							if((*it).m_type == GNC::GCS::IContractWindowLevel::WindowLevel::TWLT_USER_DEFINED){
								m_opcionPersonal = i;
							}
						}
					}
					if(seleccionado!=-1){
						m_textCtrlWW->SetValue(wxString::Format(wxT("%.2f"), window));
						m_textCtrlWL->SetValue(wxString::Format(wxT("%.2f"), level));
						m_pComboBox->SetSelection(seleccionado);
					} else {
						ModificarOpcionPersonal(window,level);
					}
				} else {
					ModificarOpcionPersonal(window,level);
				}
			}


			void AddWindowLevelPersonal(double window, double level)
			{
				//si no esta ya pues se añade
				wxString str = wxString::FromUTF8(m_labelUserDefined.c_str());
				str += wxString::Format(wxT(": %.2f/%.2f"),window,level);
				m_pComboBox->AppendString(str);
				m_opcionPersonal = m_pComboBox->GetCount() - 1;
				m_pComboBox->SetSelection(m_opcionPersonal);
				GNC::GCS::IContractWindowLevel::WindowLevel wl(m_labelUserDefined, window, level,GNC::GCS::IContractWindowLevel::WindowLevel::TWLT_USER_DEFINED);
				(*m_pListaWindowLevels).push_back(wl);
				m_pHerramienta->SetWindowLevel(wl);
			}

			void SetWindowLevel(double window, double level) {
				int i=0;
				int seleccionado = -1;
				for(GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
					if((*it).m_window == window && (*it).m_level == level){
						seleccionado = i;
						break;
					}
				}
				if(seleccionado!=-1){
					m_pComboBox->SetSelection(seleccionado);
				} else {
					ModificarOpcionPersonal(window, level);
				}
				CambiaWLTextControls(window,level);
			}

			void ModificarOpcionPersonal(double window, double level) {
				//primero se busca
				if(m_opcionPersonal == -1){
					int i = 0;
					for(GNC::GCS::IContractWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
						if((*it).m_type == GNC::GCS::IContractWindowLevel::WindowLevel::TWLT_USER_DEFINED) {
							m_opcionPersonal = i;
							m_pComboBox->SetSelection(m_opcionPersonal);
							break;
						}
					}
				}
				//si sigue siendo -1 se agrega
				if(m_opcionPersonal == -1) {
					AddWindowLevelPersonal(window,level);
				} else {
					wxString str = wxString::FromUTF8(m_labelUserDefined.c_str());
					wxString strW;
					wxString strL;
					str += wxString::Format(wxT(": %.2f/%.2f"),window,level);
					strW << window;
					strL << level;
					m_pComboBox->SetString(m_opcionPersonal,str);
					m_pComboBox->SetSelection(m_opcionPersonal);
					m_textCtrlWW->SetValue(strW);
					m_textCtrlWL->SetValue(strL);
					(*m_pListaWindowLevels)[m_opcionPersonal].m_window = window;
					(*m_pListaWindowLevels)[m_opcionPersonal].m_level = level;
					m_pHerramienta->SetWindowLevel((*m_pListaWindowLevels)[m_opcionPersonal]);
				}
			}

			void CambiaWLTextControls(double window,double level)
			{
				wxString strW;
				wxString strL;

				strW << window;
				strL << level;

				m_textCtrlWW->SetValue(strW);
				m_textCtrlWL->SetValue(strL);
			}

			LightVisualizator::ToolWindowLevelLight* m_pHerramienta;
			wxComboBox* m_pComboBox;
			wxTextCtrl* m_textCtrlWW;
			wxTextCtrl* m_textCtrlWL;
			wxStaticText* m_staticTextWW;
			wxStaticText* m_staticTextWL;
			int m_opcionPersonal;
			GNC::GCS::IContractWindowLevel::ListaWindowLevels* m_pListaWindowLevels;
			std::string m_labelUserDefined;

		};
	}
}

//----------------------------------------------------------------------

LightVisualizator::ToolWindowLevelLight::ToolWindowLevelLight()
{

	m_Descripcion = _Std("Window/Level");

	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoWindowLevel();
}

LightVisualizator::ToolWindowLevelLight::~ToolWindowLevelLight()
{
}


//region "Realizacion de la interfaz IHerramienta"

void LightVisualizator::ToolWindowLevelLight::CrearPaneles( wxPanel* panel )
{
	m_pAbstractPanelHerramientaOpciones = new LightVisualizator::GUI::HerramientaOpcionesWindowLevelGUI(panel,this);
}

void LightVisualizator::ToolWindowLevelLight::ConectarContratoFalso(bool activar) {
	if (TContratableWindowLevel::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
}

void LightVisualizator::ToolWindowLevelLight::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWindowLevel::EstablecerVistaActiva(pVista);
	GTRACE("GNC::TContratableWindowLevel::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void LightVisualizator::ToolWindowLevelLight::ConectarContratos(bool activar)
{
	// Recorrido de los contratos.
	if (TContratableWindowLevel::m_pListaActiva == NULL) {
		return;
	}

	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();

	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end(); itWindowLevel++) {
		TContratoWindowLevel* pCWL = (*itWindowLevel);
		if (activar) {
			GTRACE("ToolWindowLevelLight: Conectando contratos de vista " << pCW->GetViewerActivo() );
			// Subscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
			// Usamos de Id de grupo el valor del puntero de la herramienta, que es unico y no cambia
			((LightVisualizator::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->ConfigurarCombo(&pCWL->m_listaWindowLevels, pCWL->m_labelCurrent, pCWL->CurrentWindow, pCWL->CurrentLevel);
			GNC::GCS::ControladorEventos::Instance()->Registrar(this, GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva));
		}
		else {
			GTRACE( "ToolWindowLevelLight: Desconectando contratos de vista " << pCW->GetViewerActivo() );
			GNC::GCS::ControladorEventos::Instance()->DesRegistrar(this);
		}
	}
}

//endregion

void LightVisualizator::ToolWindowLevelLight::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	if (Conectada()) {
		if (evt->GetCodigoEvento() == ginkgoEVT_Core_ModificacionImagen) {
			GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de modificación de imagen: Evento = " << evt << std::endl;
					return;
				}
				if (pEvt->GetTipo() == GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado) {
					//se actualiza el combo
					// Recorrido de los contratos.
					TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();

					for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end(); itWindowLevel++) {
						TContratoWindowLevel* pCWL = (*itWindowLevel);
						((LightVisualizator::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->ConfigurarCombo(&pCWL->m_listaWindowLevels, pCWL->m_labelCurrent, pCWL->CurrentWindow, pCWL->CurrentLevel);
					}
				}
		}
	}
}

//region "metodos propios de la herramienta window/level"

void LightVisualizator::ToolWindowLevelLight::ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel) {
	clampedWindow = window;
	clampedLevel = level;
}


void LightVisualizator::ToolWindowLevelLight::SetWindowLevel(const GNC::GCS::IContractWindowLevel::WindowLevel& wl){
	if(Habilitada()){
		wxString wLStr, wWStr;
		for (TContratableWindowLevel::IteradorListaContratos itWL = TContratableWindowLevel::m_pListaActiva->begin(); itWL != TContratableWindowLevel::m_pListaActiva->end(); itWL++) {
			TContratoWindowLevel* pCWL = (*itWL);
			pCWL->m_labelCurrent = wl.m_label;
			pCWL->AutoWindowLevel = false;
			pCWL->CurrentWindow = wl.m_window;
			pCWL->CurrentLevel = wl.m_level;
		}
		
		GTRACE("LightVisualizator::ToolWindowLevelLight::Resetear()");
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
		pEvt->SetWindow(wl.m_window);
		pEvt->SetLevel(wl.m_level);
		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);
	}
}

void LightVisualizator::ToolWindowLevelLight::Resetear() {
	GTRACE("LightVisualizator::ToolWindowLevelLight::Resetear()");
	for (TContratableWindowLevel::IteradorListaContratos itWL = TContratableWindowLevel::m_pListaActiva->begin(); itWL != TContratableWindowLevel::m_pListaActiva->end(); itWL++) {
			TContratoWindowLevel* pCWL = (*itWL);
			pCWL->AutoWindowLevel = true;
			GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
			pEvt->EnableResetWindowLevel();
			GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);
			((LightVisualizator::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->SetWindowLevel(pCWL->CurrentWindow, pCWL->CurrentLevel);
	}
}

//endregion


