/*
 *  
 *  $Id: toolwindowlevel.h 4835 2012-04-13 07:18:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <export/itoolwindowlevel.h>
#include <widgets/wwindowlevel.h>
#include <api/icontroladoreventos.h>
#include <api/api.h>

#include <map>

namespace GNC {

	class EXTAPI ToolWindowLevel : public GNC::GCS::IToolWindowLevel, public GNC::GCS::Widgets::Observadores::IObservadorWindowLevel {

	public:
		typedef std::map<TContractWidgets*, GNC::GCS::IContractWindowLevel::WindowLevel> ListaWindowLevelsIniciales;

		ToolWindowLevel();
		virtual ~ToolWindowLevel();

		//region "Realización de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );
		virtual bool AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent);
		//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

		//region "Realización de la interfaz IHerramienta"
		virtual void OnStart();
		virtual void OnAjuste(TVector& start, TVector& stop);
		virtual void OnEnd();
		//endregion

		//region "metodos propios de la herramienta window/level"
		virtual void ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel);

		void SetWindowLevel(const std::string& label);
		virtual void SetWindowLevel(double window, double level);
		void Resetear();
		void AutoCalcule();
		//endregion

	protected:
		GNC::GCS::Widgets::WWindowLevelBuilder*  m_pWindowLevelBuilder;
		ListaWindowLevelsIniciales m_WindowLevelInicial;

	};
}
