/*
 *  
 *  $Id: herramientaangulo.h 4506 2012-01-11 11:21:21Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/iherramientaangulo.h>
#include <api/api.h>

namespace GNC {

	namespace GCS {
		namespace Widgets {
			class WAnguloBuilder;
		}
	}

	class EXTAPI HerramientaAngulo : public GNC::GCS::IHerramientaAngulo {
	public:

		typedef enum TipoAngulo {
			TA_Normal,
			TA_Cobb
		} TipoAngulo;

		HerramientaAngulo();
		~HerramientaAngulo();

		wxXmlNode* Serializar(GNC::GCS::IVista* pVista, long vid, const std::string nombreMedicoSerializa);

		void Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo);

		/*Devuelve el cursor de la herramienta*/
		virtual wxCursor GetCursor();

		void SetTipo(TipoAngulo tipo);

//region "Realizacionn de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );
		bool AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent);
		wxBitmap GetIcono();

//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

//region "Eventos refinados desde los paneles"

//endregion

	protected:
		GNC::GCS::Widgets::WAnguloBuilder* m_pAnguloBuilder;
		TipoAngulo                         m_TipoAngulo;
	};
}
