/*
 *  
 *  $Id: paneltags.h 4336 2011-10-26 11:57:07Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "paneltagsbase.h"
#include <api/controllers/ipacscontroller.h>
#include <export/iherramientapaneltags.h>
#include <wx/propgrid/propgrid.h>
#include <wx/propgrid/advprops.h>

class PanelCustomPASI;

namespace GNC {
	namespace GUI {

		class PanelTags : public PanelTagsBase, public GNC::GCS::IPanelHerramientaTags {
		public:
			PanelTags(wxWindow* pPadre);
			virtual ~PanelTags();

			virtual bool IsVisiblePanelTags();
			virtual void MostrarOcultarPanelTags();
			virtual void SetEstudio(GnkPtr<GNC::GCS::IContextoEstudio> pEstudio);


			void OnPropertyChanged(wxPropertyGridEvent& event) ;
			void OnPropertyChanging(wxPropertyGridEvent& event) ;
			virtual void OnClose(wxCloseEvent &event);

			wxPGProperty* CreatePropertyGroup(const wxString& label);
			void InsertTagInGroup(wxPGProperty* prop, const std::string& key, wxPGPropArg idPadre);

		private:
			void SetTags(GIL::DICOM::TipoJerarquia& base, wxPGPropArg idPadre, GIL::DICOM::IDICOMManager*	pDICOMManager) ;

			wxPGProperty* identificationGroup;
			wxPGProperty* patientGroup;
			wxPGProperty* acquisitionGroup;
			wxPGProperty* relationshipGroup;
			wxPGProperty* imagePresentationGroup;
			wxPGProperty* textGroup;
			wxPGProperty* otherGroup;
		};
	}
}
