/*
*  
*  $Id: itoolwindowlevel.h 4468 2011-12-09 10:02:00Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"

namespace GNC {
	namespace GCS {

		class EXTAPI IToolWindowLevel: public IHerramienta, public GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>, public GNC::GCS::IContratable<GNC::GCS::IContractWindowLevel> {
		public:
			typedef GNC::GCS::IContratoWidgets                   TContractWidgets;
			typedef GNC::GCS::IContratable<TContractWidgets>     TContractableWidgets;
			typedef GNC::GCS::IContractWindowLevel               TContratoWindowLevel;
			typedef GNC::GCS::IContratable<TContratoWindowLevel> TContratableWindowLevel;

			static const IHerramienta::UID ID = HCore_WindowLevel;
			IToolWindowLevel() : IHerramienta(HCore_WindowLevel,TFamiliaVisualizacion,"CoreWindowLevel") {};
			virtual ~IToolWindowLevel() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContratableWindowLevel::ValidaContrato(pVista) && TContractableWidgets::ValidaContrato(pVista);
			}
		};
	}
}
