/*
*  
*  $Id: exporttodicomdircommand.h 4508 2012-01-11 12:53:39Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <yasper/yasper.h>

#include <api/api.h>
#include <api/dicom/idicom.h>
#include <api/icomando.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GADAPI {
	class ExportToDicomDirCommand;

	class EXTAPI ExportToDicomDirCommandParams : public GNC::GCS::IComandoParams {
	public:
		typedef std::list<std::string> TListOfUIDs;
		ExportToDicomDirCommandParams(const TListOfUIDs& seriesList, const TListOfUIDs& diagnosticList, const std::string& destinationPath, const GIL::DICOM::TipoJerarquia& anonymized, bool includeGinkgo){
			m_seriesList = seriesList;
			m_diagnosticList = diagnosticList;
			m_destinationPath = destinationPath;
			m_hasError = false;
			m_anonymized = anonymized;
			m_includeGinkgoTags = includeGinkgo;
		}

		virtual ~ExportToDicomDirCommandParams() {}

		TListOfUIDs m_seriesList;
		TListOfUIDs m_diagnosticList;
		std::string m_destinationPath;
		GIL::DICOM::TipoJerarquia m_anonymized;
		bool m_includeGinkgoTags;

		std::string m_Error;
		bool m_hasError;
	};

	class EXTAPI ExportToDicomDirCommand : public GNC::GCS::IComando {
	public:

		ExportToDicomDirCommand(ExportToDicomDirCommandParams* pParams);

    protected:

		virtual void Execute();
		virtual void Update();

	protected:

		ExportToDicomDirCommandParams* m_pExportacionParams;
	};
}
