/*
*  
*  $Id: comandocarga.h 4158 2011-09-19 13:25:20Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <api/icontroladorvistas.h>
#include <yasper/yasper.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GADAPI {
	class ComandoCarga;

	class ComandoCargaParams : public GNC::GCS::IComandoParams, public GNC::GCS::IObservadorVistas {
	public:
		ComandoCargaParams(GNC::GCS::IVista* pVista, GnkPtr<GIL::IModeloIntegracion>& modeloIntegracion, const std::string& uidEstudioDiagnostico, const bool loadFirst);

		virtual ~ComandoCargaParams();

		virtual void OnVistaDestruida(GNC::GCS::IVista* pVista);

		GNC::GCS::IVista*               IVista;
		GnkPtr<GIL::IModeloIntegracion> ModeloIntegracion;
		std::string                     UIDEstudioDiagnostico;
		ComandoCarga*                   Padre;
		bool									  LoadFirst;

	};

	class ComandoCarga : public GNC::GCS::IComando {
	public:

		ComandoCarga(ComandoCargaParams* pParams);

    protected:

		virtual void Execute();
		virtual void Update();

	protected:

		ComandoCargaParams* CargaParams;
		std::string         Error;

	};
}
