/*
 *  
 *  $Id: icontroladorherramientas.h 4687 2012-02-10 13:35:07Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <map>
#include "iherramienta.h"
#include "icontrato.h"
#include <api/iexception.h>


class wxXmlNode;

namespace GNC {
	namespace GCS {

		class ControladorHerramientasException : public GNC::GCS::IException {
		public:
			ControladorHerramientasException(const std::string& msg) throw() : GNC::GCS::IException(msg, "GNC", false) {}
		};

		class IControladorHerramientas {
		public:

			typedef enum TBoton {
				CH_Izq,
				CH_Der
			} TBoton;

			typedef std::list<IHerramienta*> ListaHerramientas;
			typedef std::map<int,ListaHerramientas> TMapaSubConjuntosHerramientas;
			typedef std::map<IHerramienta::TFamiliasHerramientas,TMapaSubConjuntosHerramientas> TMapaHerramientasOrdenadas;

			IControladorHerramientas()
			{
			}

			~IControladorHerramientas()
			{
			}

//region "Interfaz de controlador de herramientas"

			/* Registra una herramienta */
			virtual void RegistrarHerramienta(IHerramienta* herramienta) = 0;

			/* Des-Registra una herramienta */
			virtual void DesRegistrarHerramienta(IHerramienta* herramienta) = 0;

			/* Obtiene la referencia concreta a una herramienta. */
			virtual IHerramienta* ObtenerHerramienta(IHerramienta::UID id) = 0;

			/* Refresca el estado de las herramientas */
			virtual void RefrescarHerramientas() = 0;

			/*Devuelve las herramientas registradas*/
			ListaHerramientas GetHerramientas();

			/*Devuelve las herramientas registradas ordenadas por categorias y subcategorias*/
			TMapaHerramientasOrdenadas GetHerramientasOrdenadas();

			/*Desserializa el xml y lo asocia a los contratos de la vista que se le pasa como parametro en la posicion indicada*/
			virtual void Deserializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& sopInstanceUID) = 0;

			/*Serializa las herramientas asociadas a la vista y posicion que se le pasa como parametro y lo agrega al nodo*/
			virtual void Serializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& nombreMedicoSerializa, const std::string& sopInstanceUID) = 0;

//endregion


//region "Helpers para obtener referencias a herramientas concretas"
			/* Obtiene una herramienta concreta basándose en su id.
			 * Si ocurre un error, devuelve una excepcion de tipo ControladorHerramientasException */
			template <typename TipoConcreto> TipoConcreto* ObtenerHerramientaConcreta(IHerramienta::UID id) {
				TipoConcreto* pHerramientaConcreta = NULL;
				IHerramienta* pHerramientaAbstracta = ObtenerHerramienta(id);
				if (pHerramientaAbstracta != NULL) {
					pHerramientaConcreta = dynamic_cast<TipoConcreto*>(pHerramientaAbstracta);
					if (pHerramientaConcreta == NULL) {
						throw ControladorHerramientasException("Error: Tipo de herramienta incompatible");
					}
				}
				return pHerramientaConcreta;
			}

//endregion
		};
	}
}
