// W32_PROJECT.H : classes for Win32 user interface.

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef W32_PROJECT_H
#define W32_PROJECT_H

//#include "ghemicalconfig2.h"

class w32_project;

/*################################################################################################*/

#include <ghemical/model.h>

#include "project.h"

#include <vector>
using namespace std;

/*################################################################################################*/

/**	This will contain w32-dependent aspects of the "##project" class.
*/

class w32_project : public project
{
	protected:
	
	public:
	
	w32_project(void);
	void DoSafeStart(void);
	
	virtual ~w32_project(void);
	
	static oglview_wcl * GetClient(HWND);
	
	void ThreadLock(void);			// virtual
	void ThreadUnlock(void);		// virtual
	bool SetProgress(double, double*);	// virtual
	
#ifdef ENABLE_THREADS
	
	protected:
	
//	w32_progress_dialog * pd;
	void * pd;
	
	public:
	
	void CreateProgressDialog(const char *, bool, int, int);	// virtual
	void DestroyProgressDialog(void);				// virtual
	
#endif	// ENABLE_THREADS
	
	void GeomOptGetParam(geomopt_param &);		// virtual
	void MolDynGetParam(moldyn_param &);		// virtual
	
// the GUI threading model is explained here:
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
// the "main thread" of the program handles gtk_main() loop and callbacks.
// in ProcessCommandString() a single "sub-thread" can be started for certain
// operations, if the program is compiled with ENABLE_THREADS set. therefore all
// operations in the process_job_XXX() methods below must be made thread-safe.
	
	void start_job_GeomOpt(jobinfo_GeomOpt *);		// virtual
	static void process_job_GeomOpt(void *);
	
	void start_job_MolDyn(jobinfo_MolDyn *);		// virtual
	static void process_job_MolDyn(void *);
	
	void start_job_RandomSearch(jobinfo_RandomSearch *);	// virtual
	static void process_job_RandomSearch(void *);
	
	// w32-implementations of creation/removal of views.
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	base_wnd * CreateGraphicsWnd(bool);	// virtual
	void DestroyGraphicsWnd(base_wnd *);	// virtual
	
	base_wnd * CreatePlot1DWnd(bool);			// virtual
	base_wnd * CreatePlot2DWnd(bool);			// virtual
	base_wnd * CreateEnergyLevelDiagramWnd(bool);		// virtual
	base_wnd * CreateReactionCoordinatePlotWnd(bool);	// virtual
	base_wnd * CreateGenericProteinChainWnd(bool);		// virtual
	void DestroyPlottingWnd(base_wnd *);			// virtual
	
	void Message(const char *);		// virtual
	void WarningMessage(const char *);	// virtual
	void ErrorMessage(const char *);	// virtual
	bool Question(const char *);		// virtual
	void PrintToLog(const char *);		// virtual
	
// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here
	
	static void popup_FileImport(HWND);
	static void popup_FileExport(HWND);
	static void popup_FileExportGraphic(HWND);
	static void popup_FileSaveAs(HWND);
	static void popup_FileExtra1(HWND);
	static void popup_FileExtra2(HWND);
	
	static void popup_SelectAll(HWND);
	static void popup_SelectNone(HWND);
	static void popup_InvertSelection(HWND);
	
	static void popup_HideSelected(HWND);
	static void popup_ShowSelected(HWND);
	static void popup_LockSelected(HWND);
	static void popup_UnlockSelected(HWND);
	static void popup_DeleteSelected(HWND);
	
	static void popup_SelectModeAtom(HWND data);
	static void popup_SelectModeResidue(HWND data);
	static void popup_SelectModeChain(HWND data);
	static void popup_SelectModeMolecule(HWND data);
	
	static void popup_ViewsNewELD(HWND);
	static void popup_ViewsNewSSC(HWND);
	
	static void popup_RModeBallStick(HWND);
	static void popup_RModeVanDerWaals(HWND);
	static void popup_RModeCylinders(HWND);
	static void popup_RModeWireframe(HWND);
	static void popup_RModeNothing(HWND);
	
	static void popup_CModeElement(HWND);
	static void popup_CModeSecStruct(HWND);
	static void popup_CModeHydPhob(HWND);
	
	static void popup_LModeIndex(HWND);
	static void popup_LModeElement(HWND);
	static void popup_LModeFCharge(HWND);
	static void popup_LModePCharge(HWND);
	static void popup_LModeAtomType(HWND);
	static void popup_LModeBuilderID(HWND);
	static void popup_LModeBondType(HWND);
	static void popup_LModeResidue(HWND);
	static void popup_LModeSecStruct(HWND);
	static void popup_LModeNothing(HWND);
	
	static void popup_ObjRibbon(HWND);
	static void popup_ObjEPlane(HWND);
	static void popup_ObjEVolume(HWND);
	static void popup_ObjESurface(HWND);
	static void popup_ObjEVDWSurface(HWND);
	static void popup_ObjEDPlane(HWND);
	static void popup_ObjEDSurface(HWND);
	static void popup_ObjMOPlane(HWND);
	static void popup_ObjMOVolume(HWND);
	static void popup_ObjMOSurface(HWND);
	static void popup_ObjMODPlane(HWND);
	static void popup_ObjMODVolume(HWND);
	static void popup_ObjMODSurface(HWND);
	
	static void popup_ObjectsDeleteCurrent(HWND);
	
	static void popup_CompSetup(HWND);
	static void popup_CompEnergy(HWND);
	static void popup_CompGeomOpt(HWND);
	static void popup_CompMolDyn(HWND);
	static void popup_CompRandomSearch(HWND);
	static void popup_CompSystematicSearch(HWND);
	static void popup_CompMonteCarloSearch(HWND);
	static void popup_CompTorsionEnergyPlot1D(HWND);
	static void popup_CompTorsionEnergyPlot2D(HWND);
	static void popup_CompPopAnaElectrostatic(HWND);
	static void popup_CompTransitionStateSearch(HWND);
	static void popup_CompStationaryStateSearch(HWND);
	static void popup_CompFormula(HWND);
	
static void popup_CompSetFormalCharge(HWND);	// under construction...
static void popup_CompCreateRS(HWND);		// under construction...
static void popup_CompCycleRS(HWND);		// under construction...
	
	static void popup_TrajView(HWND);
	static void popup_SetOrbital(HWND);
	
	static void popup_HAdd(HWND);
	static void popup_HRemove(HWND);
	
	static void popup_SolvateBox(HWND);
	static void popup_SolvateSphere(HWND);
	
	static void popup_BuilderAmino(HWND);
	static void popup_BuilderNucleic(HWND);
	
	static void popup_Center(HWND);
	static void popup_ClearAll(HWND);
	
	static void popup_EnterCommand(HWND);
};

/*################################################################################################*/

#endif	// W32_PROJECT_H

// eof
