// GTK_PROJECT.H : classes for gtk/bonobo user interface.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef GTK_PROJECT_H
#define GTK_PROJECT_H

//#include "ghemicalconfig2.h"

class gtk_project;

/*################################################################################################*/

#include <ghemical/model.h>

#include "project.h"
#include "gtk_views.h"

#include "gtk_dialog.h"
#include "glade/progress_dialog.h"

#include <gtk/gtk.h>

#ifdef ENABLE_BONOBO
#include <bonobo.h>
#endif	// ENABLE_BONOBO

#include <vector>
using namespace std;

#define FILENAME_FILTER	"*.gpr"

/*################################################################################################*/

/**	This will contain gtk-dependent aspects of the "##project" class.

	BONOBO-docs???
*/

class gtk_project : public project
{
	protected:
	
#ifdef ENABLE_BONOBO
	BonoboControl * control;
#endif	// ENABLE_BONOBO
	
	GtkWidget * paned_widget;
	
	GtkWidget * notebook_widget;
	
	GtkTextBuffer * txt_buffer;
	GtkTextMark * end_mark;
	
	GtkWidget * scroll_widget;
	GtkWidget * txt_widget;
	
	readpdb_mdata * importpdb_mdata;		// temporary?!?!?!
	
	friend class gtk_ogl_view;
	friend class gtk_view;
	
	public:
	
	friend class gtk_project_view;
	friend class gtk_graphics_view;
	
friend class gtk_plot1d_view;
friend class gtk_plot2d_view;
friend class gtk_rcp_view;
friend class gtk_eld_view;
friend class gtk_ssc_view;
	
	friend class gtk_class_factory;
	
	friend class file_open_dialog;
	friend class file_save_dialog;
	
	friend class importpdb_dialog;		// importpdb_mdata
	
	public:
	
	gtk_project(gtk_class_factory &);
	virtual ~gtk_project(void);
	
#ifdef ENABLE_BONOBO
	BonoboControl * GetControl(void);
#endif	// ENABLE_BONOBO
	
	GtkWidget * GetWidget(void);
	
	void ThreadLock(void);			// virtual
	void ThreadUnlock(void);		// virtual
	bool SetProgress(double, double*);	// virtual
	
#ifdef ENABLE_THREADS
	
	protected:
	
	progress_dialog * pd;
	
	public:
	
	void CreateProgressDialog(const char *, bool, int, int);	// virtual
	void DestroyProgressDialog(void);				// virtual
	
#endif	// ENABLE_THREADS
	
	void Message(const char *);		// virtual
	void WarningMessage(const char *);	// virtual
	void ErrorMessage(const char *);	// virtual
	bool Question(const char *);		// virtual
	
	void PrintToLog(const char *);			// virtual
	void UpdateAllWindowTitles(void);		// virtual
	
	void MakeLibraryWidgets(GtkMenuItem *, const char *, int);
	
	void GeomOptGetParam(geomopt_param &);	// virtual
	void MolDynGetParam(moldyn_param &);	// virtual
	
	// the popup-menu callbacks are here...
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	static void popup_FileOpen(GtkWidget *, gpointer);
	static void popup_FileClose(GtkWidget *, gpointer);
	static void popup_FileImport(GtkWidget *, gpointer);
	static void popup_FileExport(GtkWidget *, gpointer);
	static void popup_FileExportGraphic(GtkWidget *, gpointer);
	static void popup_FileSaveAs(GtkWidget *, gpointer);
	static void popup_FileExtra1(GtkWidget *, gpointer);
	static void popup_FileExtra2(GtkWidget *, gpointer);
	
	static void popup_SelectAll(GtkWidget *, gpointer);
	static void popup_SelectNone(GtkWidget *, gpointer);
	static void popup_InvertSelection(GtkWidget *, gpointer);
	static void popup_DeleteSelection(GtkWidget *, gpointer);
	
	static void popup_SelectModeAtom(GtkWidget *, gpointer data);
	static void popup_SelectModeResidue(GtkWidget *, gpointer data);
	static void popup_SelectModeChain(GtkWidget *, gpointer data);
	static void popup_SelectModeMolecule(GtkWidget *, gpointer data);
	
	static void popup_ViewsNewELD(GtkWidget *, gpointer);
	static void popup_ViewsNewSSC(GtkWidget *, gpointer);
	
	static void popup_RModeBallStick(GtkWidget *, gpointer);
	static void popup_RModeVanDerWaals(GtkWidget *, gpointer);
	static void popup_RModeCylinders(GtkWidget *, gpointer);
	static void popup_RModeWireframe(GtkWidget *, gpointer);
	static void popup_RModeNothing(GtkWidget *, gpointer);
	
	static void popup_CModeElement(GtkWidget *, gpointer);
	static void popup_CModeSecStruct(GtkWidget *, gpointer);
	static void popup_CModeHydPhob(GtkWidget *, gpointer);
	
	static void popup_LModeIndex(GtkWidget *, gpointer);
	static void popup_LModeElement(GtkWidget *, gpointer);
	static void popup_LModeFCharge(GtkWidget *, gpointer);
	static void popup_LModePCharge(GtkWidget *, gpointer);
	static void popup_LModeAtomType(GtkWidget *, gpointer);
	static void popup_LModeBuilderID(GtkWidget *, gpointer);
	static void popup_LModeBondType(GtkWidget *, gpointer);
	static void popup_LModeResidue(GtkWidget *, gpointer);
	static void popup_LModeSecStruct(GtkWidget *, gpointer);
	static void popup_LModeNothing(GtkWidget *, gpointer);
	
	static void popup_ObjRibbon(GtkWidget *, gpointer);
	static void popup_ObjEPlane(GtkWidget *, gpointer);
	static void popup_ObjEVolume(GtkWidget *, gpointer);
	static void popup_ObjESurface(GtkWidget *, gpointer);
	static void popup_ObjEVDWSurface(GtkWidget *, gpointer);
	static void popup_ObjEDPlane(GtkWidget *, gpointer);
	static void popup_ObjEDSurface(GtkWidget *, gpointer);
	static void popup_ObjMOPlane(GtkWidget *, gpointer);
	static void popup_ObjMOVolume(GtkWidget *, gpointer);
	static void popup_ObjMOSurface(GtkWidget *, gpointer);
	static void popup_ObjMODPlane(GtkWidget *, gpointer);
	static void popup_ObjMODVolume(GtkWidget *, gpointer);
	static void popup_ObjMODSurface(GtkWidget *, gpointer);
	
	static void popup_ObjectsDeleteCurrent(GtkWidget *, gpointer);
	
	static void popup_CompSetup(GtkWidget *, gpointer);
	static void popup_CompEnergy(GtkWidget *, gpointer);
	static void popup_CompGeomOpt(GtkWidget *, gpointer);
	static void popup_CompMolDyn(GtkWidget *, gpointer);
	static void popup_CompRandomSearch(GtkWidget *, gpointer);
	static void popup_CompSystematicSearch(GtkWidget *, gpointer);
	static void popup_CompMonteCarloSearch(GtkWidget *, gpointer);
	static void popup_CompTorsionEnergyPlot1D(GtkWidget *, gpointer);
	static void popup_CompTorsionEnergyPlot2D(GtkWidget *, gpointer);
	static void popup_CompPopAnaElectrostatic(GtkWidget *, gpointer);
	static void popup_CompTransitionStateSearch(GtkWidget *, gpointer);
	static void popup_CompStationaryStateSearch(GtkWidget *, gpointer);
	static void popup_CompFormula(GtkWidget *, gpointer);
static void popup_CompSetFormalCharge(GtkWidget *, gpointer);
static void popup_CompCreateRS(GtkWidget *, gpointer);
static void popup_CompCycleRS(GtkWidget *, gpointer);
	
	static void popup_TrajView(GtkWidget *, gpointer);
	static void popup_SetOrbital(GtkWidget *, gpointer);
	
	static void popup_HAdd(GtkWidget *, gpointer);
	static void popup_HRemove(GtkWidget *, gpointer);
	static void popup_SolvateBox(GtkWidget *, gpointer);
	static void popup_SolvateSphere(GtkWidget *, gpointer);
	static void popup_Clear(GtkWidget *, gpointer);
	static void popup_Library(GtkWidget *, gpointer);
	static void popup_BuilderAmino(GtkWidget *, gpointer);
	static void popup_BuilderNucleic(GtkWidget *, gpointer);
	static void popup_Center(GtkWidget *, gpointer);
	static void popup_EnterCommand(GtkWidget *, gpointer);
};

/*################################################################################################*/

#endif	// GTK_PROJECT_H

// eof
