// GTK_PROJECT.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "gtk_project.h"	// config.h is here -> we get ENABLE-macros here...

#include "project.h"
#include "appdefine.h"

#include <ghemical/geomopt.h>
#include <ghemical/moldyn.h>

#include <ghemical/eng1_qm.h>
#include <ghemical/eng1_mm.h>
#include <ghemical/eng1_sf.h>

#include "color.h"

#include "plane.h"
#include "surface.h"
#include "ribbon.h"

#include "file_import_dialog.h"
#include "file_export_dialog.h"

#include "geomopt_dialog.h"
#include "moldyn_dialog.h"

#include "setup_dialog.h"
#include "progress_dialog.h"

#include "gtk_graphics_view.h"

#include <sys/stat.h>	// for stat
#include <dirent.h>	// for scandir

#include <glade/glade.h>

#include <strstream>
using namespace std;

/*################################################################################################*/

gtk_project::gtk_project(gtk_class_factory & p2) : project(p2)
{
	// only the control_factory() function from main.cpp should call this?!?!?!
	// only the control_factory() function from main.cpp should call this?!?!?!
	// only the control_factory() function from main.cpp should call this?!?!?!
	
	importpdb_mdata = NULL;		// temporary?!?!?!
	
	char buffer[1024];
	GetFullProjectFileName(buffer, 1024);
	
	// the viewing widget is a vertically paned widget; it contains the notebook and the text log.
	
	paned_widget = gtk_vpaned_new();
	
	notebook_widget = gtk_notebook_new();
	
	txt_widget = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(txt_widget), false);
	
	txt_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(txt_widget));
	GtkTextIter txt_iter; gtk_text_buffer_get_end_iter(txt_buffer, & txt_iter);
	end_mark = gtk_text_buffer_create_mark(txt_buffer, NULL, & txt_iter, FALSE);	// right_gravity!
	
	scroll_widget = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scroll_widget), GTK_WIDGET(txt_widget));
	
	gtk_widget_show(txt_widget);
	
	gtk_paned_add1(GTK_PANED(paned_widget), GTK_WIDGET(notebook_widget));
	gtk_paned_add2(GTK_PANED(paned_widget), GTK_WIDGET(scroll_widget));

	gtk_widget_show(notebook_widget);
	gtk_widget_show(scroll_widget);
	
	gtk_widget_show(paned_widget);
	
	// always add a project view and a graphics view by default.
	// add the project view first so that the graphics view remains on top...
	
	CreateProjectView();
	AddGraphicsView(NULL, false);
	
	PrintToLog("A new project created.\n");
	
#ifdef ENABLE_BONOBO
	control = NULL;
#endif	// ENABLE_BONOBO
	
#ifdef ENABLE_THREADS
	pd = NULL;
#endif	// ENABLE_THREADS
	
/*	GtkMenuItem * mi = GTK_MENU_ITEM(build_submenu[1].widget);
	MakeLibraryWidgets(mi, "library/", 1);	*/
}

gtk_project::~gtk_project(void)
{
	// check the graphics_view_vector for any "detached" views, and call gtk_widget_destroy for them.
	// the "attached" views, the ones that are linked to the GtkNotebook, will be destroyed with the notebook.
	// ok, this is a bit ugly solution, but see gtk_graphics_view::popup_ViewsAttachDetach() for more comments...
	
// THIS IS BAD!!!!!!!!!!!!!!!!!!
// THIS IS BAD!!!!!!!!!!!!!!!!!!
// THIS IS BAD!!!!!!!!!!!!!!!!!!

	for (i32u n1 = 0;n1 < graphics_view_vector.size();n1++)
	{
		gtk_graphics_view * gv = dynamic_cast<gtk_graphics_view *>(graphics_view_vector[n1]);
		if (gv != NULL && gv->detached != NULL) gtk_widget_destroy(GTK_WIDGET(gv->detached));
	}
	
#ifdef ENABLE_THREADS
	if (pd != NULL) cout << "MEM-LEAK pd" << endl;
#endif	// ENABLE_THREADS

}

#ifdef ENABLE_BONOBO

BonoboControl * gtk_project::GetControl(void)
{
	if (!control) control = bonobo_control_new(paned_widget);
	return control;
}

#endif	// ENABLE_BONOBO

GtkWidget * gtk_project::GetWidget(void)
{
	return paned_widget;
}

void gtk_project::ThreadLock(void)
{
#ifdef ENABLE_THREADS
	gdk_threads_enter();
#endif	// ENABLE_THREADS
}

void gtk_project::ThreadUnlock(void)
{
#ifdef ENABLE_THREADS
	gdk_threads_leave();
#endif	// ENABLE_THREADS
}

bool gtk_project::SetProgress(double progress, double * graphdata)
{
#ifdef ENABLE_THREADS
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pd->progressbar_job), progress);
	
	if (graphdata != NULL)
	{
		int f = (pd->g_fill % pd->g_sz);
		for (int i = 0;i < pd->g_n;i++)
		{
			pd->g_data[i * pd->g_sz + f] = graphdata[i];
		}
		
		pd->g_fill++;
		
		gtk_widget_queue_draw_area(pd->drawingarea_job, 0, 0, pd->da_w, pd->da_h);
	}
	
	return pd->cancel;
#else	// ENABLE_THREADS
	return false;
#endif	// ENABLE_THREADS
}

#ifdef ENABLE_THREADS

void gtk_project::CreateProgressDialog(const char * title, bool show_pbar, int graphs_n, int graphs_s)
{
	pd = new progress_dialog(title, show_pbar, graphs_n, graphs_s);
}

void gtk_project::DestroyProgressDialog(void)
{
	gtk_widget_destroy(pd->dialog);
	delete pd; pd = NULL;
}

#endif	// ENABLE_THREADS

// Print the message (no problems).
void gtk_project::Message(const char * msg)
{
	GtkWidget * message_dialog = gtk_message_dialog_new(NULL,
	GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", msg);
	
	gtk_dialog_run(GTK_DIALOG(message_dialog));
	gtk_widget_destroy(message_dialog);
}

// Print the message (lower severity).
void gtk_project::WarningMessage(const char * msg)
{
	GtkWidget * message_dialog = gtk_message_dialog_new(NULL,
	GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, "%s", msg);
	
	gtk_dialog_run(GTK_DIALOG(message_dialog));
	gtk_widget_destroy(message_dialog);
}

// Print the message (higher severity).
void gtk_project::ErrorMessage(const char * msg)
{
	GtkWidget * message_dialog = gtk_message_dialog_new(NULL,
	GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", msg);
	
	gtk_dialog_run(GTK_DIALOG(message_dialog));
	gtk_widget_destroy(message_dialog);
}

// Print the message and wait for a yes/no response.
bool gtk_project::Question(const char * msg)
{
	GtkWidget * question_dialog = gtk_message_dialog_new(NULL,
	GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", msg);
	
	gint response = gtk_dialog_run(GTK_DIALOG(question_dialog));
	gtk_widget_destroy(question_dialog);
	
	switch (response)
	{
		case GTK_RESPONSE_YES:
		return true;
		
		default:
		return false;
	}
}

void gtk_project::PrintToLog(const char * message)
{
	GtkTextIter txt_iter;
	gtk_text_buffer_get_iter_at_mark(txt_buffer, & txt_iter, end_mark);
	
	gtk_text_buffer_insert(txt_buffer, & txt_iter, message, -1);
	
	gtk_text_view_scroll_mark_onscreen(GTK_TEXT_VIEW(txt_widget), end_mark);
}

void gtk_project::UpdateAllWindowTitles()
{
	// mdi_child_name and view titles are somewhat different issues now; check this!!!
	// we should change mdi_child_name when the project name changes, but this function is for setting the view titles.
	
	char buffer[1024];
	GetProjectFileName(buffer, 1024, true);
	
	//gnome_mdi_child_set_name(GNOME_MDI_CHILD(child), buffer);
	project::UpdateAllWindowTitles();
}

void gtk_project::MakeLibraryWidgets(GtkMenuItem * menu, const char * directory_path, int recursion)
{
  struct stat stat_buf;

  if ( stat(directory_path, &stat_buf) == 0 && S_ISDIR(stat_buf.st_mode) )
    {
      struct dirent *namelist;
      DIR *dirList;
      GtkWidget *library_item;

       if (( dirList = opendir(directory_path) ))
	 {
//	   char *filename = new char[1024];		// OLD
	   while (( namelist = readdir(dirList) ))
	     {
	       char *filename = new char[1024];		// a new string for each item???
	       
	       strncpy(filename, directory_path, 512);
	       strncat(filename, namelist->d_name, 511);
	       
	       if ( namelist->d_name[0] != '.' &&
		    stat(filename, &stat_buf) == 0 &&
		    strstr(namelist->d_name, ".gpr") != NULL)
		 {
		   library_item = gtk_menu_item_new_with_label(namelist->d_name);
		   
		   // we pass the string "filename" here as user data.
		   // "filename" must be unique for each item, and it must stay in memory.
		   
		   gtk_signal_connect(GTK_OBJECT(library_item), "activate",
				      GTK_SIGNAL_FUNC(popup_Library),
				      filename);
		   
		   gtk_object_set_user_data(GTK_OBJECT(library_item), 
					    (project *) this);

		   gtk_widget_show(library_item);

		   gtk_menu_append(GTK_MENU(menu->submenu),
				   library_item);
		 }
	       else if ( namelist->d_name[0] != '.' &&
			 stat(filename, &stat_buf) == 0 &&
			 S_ISDIR(stat_buf.st_mode) &&
			 recursion != 0)
		 {
		   library_item = gtk_menu_item_new_with_label(namelist->d_name);
		   gtk_menu_item_set_submenu(GTK_MENU_ITEM(library_item),
					     gtk_menu_new());

		   gtk_widget_show(library_item);
		   
		   gtk_menu_append(GTK_MENU(menu->submenu),
				   library_item);
		   
		   strcat(filename, "/");
		   MakeLibraryWidgets(GTK_MENU_ITEM(library_item), filename, recursion-1);
		 }
	// this would be the correct place to delete the string, if it were temporary.
	// however, we must retain the strings in memory because we will use them later, so this will create a (small) memory leak.
	// we should either store the strings to a static block of memory, or someway arrange the memory release when program stops.
//	   delete [] filename;		// can't do this, or we might use freed (and possibly overwritten) memory later...
	     }
//	   delete [] filename;		// OLD
	   closedir(dirList);
	 }

     }
}

void gtk_project::GeomOptGetParam(geomopt_param & param)
{
	new geomopt_dialog(& param);		// the object will call delete itself...
	
	// the above dialog is a modal one; we will return from the function only after the dialog is closed.
	cout << "now returning from gtk_project::GeomOptGetParam()." << endl;
}

void gtk_project::MolDynGetParam(moldyn_param & param)
{
	new moldyn_dialog(& param);		// the object will call delete itself...
	
	// the above dialog is a modal one; we will return from the function only after the dialog is closed.
	cout << "now returning from gtk_project::MolDynGetParam()." << endl;
}

// the popup-menu callbacks are here...
// the popup-menu callbacks are here...
// the popup-menu callbacks are here...

void gtk_project::popup_FileOpen(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new file_open_dialog(prj);	// will call delete itself...
}

void gtk_project::popup_FileClose(GtkWidget *, gpointer data)
{
	// gtk_graphics_view * gv = GetGV((GtkWidget *) data);
	
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	// apparently, it is not necessary to call gnome_mdi_remove_view() for the view here...
	
	//gnome_mdi_remove_child(gnome_mdi_app::mdi, GNOME_MDI_CHILD(gv->prj->child), FALSE);
}

void gtk_project::popup_FileImport(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new file_import_dialog(prj);		// will call delete itself...
}

void gtk_project::popup_FileExport(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new file_export_dialog(prj);		// will call delete itself...
}

void gtk_project::popup_FileExportGraphic(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new file_save_graphics_dialog(prj);	// will call delete itself...
}

void gtk_project::popup_FileSaveAs(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new file_save_dialog(prj);		// will call delete itself...
}

void gtk_project::popup_FileExtra1(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) new importpdb_dialog(prj);		// will call delete itself???
}

void gtk_project::popup_FileExtra2(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (prj->importpdb_mdata == NULL)
		{
			prj->Message("Please import a PDB file first;\nSee File/ExtraTools/ImportPDB...");
			return;
		}
		
prj->Message("sorry, this is under construction now...");
//		prj->aa2sf_ConvertAll(prj->importpdb_mdata);
//		prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_SelectAll(GtkWidget *, gpointer data)
{
	gtk_graphics_view::GetGV((GtkWidget *) data)->prj->SelectAll();
}

void gtk_project::popup_SelectNone(GtkWidget *, gpointer data)
{
	gtk_graphics_view::GetGV((GtkWidget *) data)->prj->SelectAll();		// should call the base class function to prevent the flash!!!
	gtk_graphics_view::GetGV((GtkWidget *) data)->prj->InvertSelection();
}

void gtk_project::popup_InvertSelection(GtkWidget *, gpointer data)
{
	gtk_graphics_view::GetGV((GtkWidget *) data)->prj->InvertSelection();
}

void gtk_project::popup_DeleteSelection(GtkWidget *, gpointer data)
{
	gtk_graphics_view::GetGV((GtkWidget *) data)->prj->DeleteSelection();
}

void gtk_project::popup_SelectModeAtom(GtkWidget *, gpointer data)
{
	ogl_view::select_mode = select_tool::Atom;
cout << "select_mode = atm" << endl;
}

void gtk_project::popup_SelectModeResidue(GtkWidget *, gpointer data)
{
	ogl_view::select_mode = select_tool::Residue;
cout << "select_mode = res" << endl;
}

void gtk_project::popup_SelectModeChain(GtkWidget *, gpointer data)
{
	ogl_view::select_mode = select_tool::Chain;
cout << "select_mode = chn" << endl;
}

void gtk_project::popup_SelectModeMolecule(GtkWidget *, gpointer data)
{
	ogl_view::select_mode = select_tool::Molecule;
cout << "select_mode = mol" << endl;
}

void gtk_project::popup_ViewsNewELD(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->AddEnergyLevelDiagramView(true);
	}
}

void gtk_project::popup_ViewsNewSSC(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->AddSecondaryStructureConstraintsView(true);
	}
}

void gtk_project::popup_RModeBallStick(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_BALL_AND_STICK; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_RModeVanDerWaals(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_VAN_DER_WAALS; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_RModeCylinders(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_CYLINDERS; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_RModeWireframe(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_WIREFRAME; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_RModeNothing(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_NOTHING; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_CModeElement(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & project::cm_element; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_CModeSecStruct(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & project::cm_secstruct; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_CModeHydPhob(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->colormode = & project::cm_hydphob; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeIndex(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_INDEX; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeElement(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_ELEMENT; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeFCharge(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_F_CHARGE; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModePCharge(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_P_CHARGE; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeAtomType(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_ATOMTYPE; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeBuilderID(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_BUILDER_ID; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeBondType(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_BONDTYPE; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeResidue(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_RESIDUE; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeSecStruct(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_SEC_STRUCT; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_LModeNothing(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->label = LABEL_NOTHING; gv->prj->UpdateAllGraphicsViews();
}

void gtk_project::popup_ObjRibbon(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->ref_civ) prj->UpdateChains();
		vector<chn_info> & ci_vector = (* prj->ref_civ);
		for (i32u n1 = 0;n1 < ci_vector.size();n1++)
		{
			if (ci_vector[n1].GetType() != chn_info::amino_acid) continue;
			if (ci_vector[n1].GetLength() < 3) continue;
			
			if (ci_vector[n1].GetSecStrStates() == NULL) DefineSecondaryStructure(prj);
			
			prj->AddObject(new ribbon(prj, gv->colormode, n1, 4));		// min. order is 2!!!
		}
		
		prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_ObjEPlane(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane esp rb1 138.0 AUTO 1.0 50 1 0.75";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjEVolume(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend esp rb2 138.0 0.0 1.0 25 0.50";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjESurface(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf2 esp unity red blue +35.0 -35.0 1.0 0.0 2.0 50 0 0 0.50";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjEVDWSurface(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 vdws esp rb1 1.0 70.0 AUTO 2.0 50 1 1 0.65";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjEDPlane(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane eldens rb1 0.05 0.0 0.75 50 1 0.75";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjEDSurface(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 eldens unity red 0.01 1.0 0.0 1.5 50 0 0 0.65";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMOPlane(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane mo rb1 0.05 0.0 0.75 50 1 0.75";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMOVolume(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend mo rb2 0.025 0.0 1.5 25 0.50";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMOSurface(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf2 mo unity red blue +0.025 -0.025 1.0 0.0 1.5 50 0 0 0.50";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMODPlane(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane mod rb1 0.005 0.0 0.75 50 1 0.75";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMODVolume(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend mod rb2 0.0025 0.0 1.5 25 0.35";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjMODSurface(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 mod unity red 0.0025 1.0 0.0 1.5 50 0 0 0.65";
			new command_dialog(prj, gv, command);
		}
	}
}

void gtk_project::popup_ObjectsDeleteCurrent(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gv->prj->DoDeleteCurrentObject();
}

void gtk_project::popup_CompSetup(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	
	new setup_dialog(prj);		// will call delete itself...
}

void gtk_project::popup_CompEnergy(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) prj->DoEnergy();
}

void gtk_project::popup_CompGeomOpt(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		setup * su = prj->GetCurrentSetup();
		static jobinfo_GeomOpt ji;
		
		ji.prj = prj;
		ji.go = geomopt_param(su);
		
		prj->start_job_GeomOpt(& ji);
	}
}

void gtk_project::popup_CompMolDyn(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		setup * su = prj->GetCurrentSetup();
		static jobinfo_MolDyn ji;
		
		ji.prj = prj;
		ji.md = moldyn_param(su);
		
		prj->start_job_MolDyn(& ji);
	}
}

void gtk_project::popup_CompRandomSearch(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "random_search 100 250";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompSystematicSearch(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "systematic_search 6 250";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompMonteCarloSearch(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "montecarlo_search 10 100 250";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompTorsionEnergyPlot1D(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letters A-D with atom indices that define the torsion.\n\nALSO NOTE: structure refinement is always done using molecular mechanics (optsteps).");
		
		static const char command[] = "make_plot1 A B C D 36 0.0 360.0 250";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompTorsionEnergyPlot2D(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letters A-D and I-L with atom indices that define the torsions.\n\nALSO NOTE: structure refinement is always done using molecular mechanics (optsteps).");
		
		static const char command[] = "make_plot2 A B C D 36 0.0 360.0 I J K L 36 0.0 360.0 250";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompPopAnaElectrostatic(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "population_analysis_ESP";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompTransitionStateSearch(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "transition_state_search 10.0 500.0";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompStationaryStateSearch(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "stationary_state_search 100";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompFormula(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj) prj->DoFormula();
}

void gtk_project::popup_CompSetFormalCharge(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "set_formal_charge X +0";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_CompCreateRS(GtkWidget *, gpointer data)	// todo : this is only for testing?!?!?!?
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		if (prj->GetRS() == NULL) prj->CreateRS();
	}
}

void gtk_project::popup_CompCycleRS(GtkWidget *, gpointer data)	// todo : this is only for testing?!?!?!?
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj && prj->GetRS() != NULL)
	{
	//	prj->GetRS()->CycleStructures();
		prj->UpdateAllGraphicsViews();
	}
	else cout << "ERROR" << endl;
}

void gtk_project::popup_TrajView(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (!prj->GetTrajectoryFile())
	{
		if (prj) new trajfile_dialog(prj);	// will call delete itself...
	}
	else prj->ErrorMessage("Trajectory already open?!?!?!");
}

void gtk_project::popup_SetOrbital(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letter X with the orbital index that will become the current orbital.");
		
		static const char command[] = "set_current_orbital X";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_HAdd(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->AddH();
		prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_HRemove(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->RemoveH();
		prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_SolvateBox(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "solvate_box 3.0 3.0 3.0";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_SolvateSphere(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		static const char command[] = "solvate_sphere 1.2 1.6";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_Clear(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj && 
	    prj->Question("Are you sure you want to clear everything?"))
	{
	  prj->ClearModel();
	  prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_Library(GtkWidget *item, gpointer data)
{
  project * prj1 = (project *) gtk_object_get_user_data(GTK_OBJECT(item));
  gtk_project * prj = dynamic_cast<gtk_project *>(prj1);
  
  static char buffer[256];
  g_snprintf(buffer, 256, "%s", data);
  cout << "preparing to open a library file : " << buffer << endl;	// just for debugging...
  
  bool open = prj->IsEmpty();	// open, not insert
  
  ifstream ifile;
  ifile.open(buffer, ios::in);
  ReadGPR(* prj, ifile, true);
  
  // This should probably go into the prjiew class 
  // that is, the prjiew::ReadGPR() should override 
  // the model::ReadGPR() and the rest
  	
  if (!open)	// we append this file to the current project
    {
      if (prj->selected_object != NULL)
	{
	  prj->selected_object = NULL;
	}
    }
	
  ifile.close();
}

void gtk_project::popup_BuilderAmino(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the default sequence AAA with the sequence to be built.");
		
		static const char command[] = "build_amino AAA";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_BuilderNucleic(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the default sequence AGTCaguc with the sequence to be built.");
		
		static const char command[] = "build_nucleic AGTCaguc";
		new command_dialog(prj, gv, command);
	}
}

void gtk_project::popup_Center(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		prj->CenterCRDSet(0, true);
		
		// Which is the current Coord Set?
		// usually it's 0, but it could be any/all. the crdset-system is not yet in GUI...
		
		// 2001-06-18 TH: yes, this is not quite ready. but i guess in the end we will
		// move ALL crd-sets...
		
// sometimes this centering won't work, if the camera won't point to the origo.
// so, here we try to turn it there. ANY EFFECTS TO LIGHTS, ETC??????

	//	for (i32u n1 = 0;n1 < prj->camera_vector.size();n1++)
	//	{
			// rotation or translation???
			// translation would affect less to lights (since it's accurate)????
	//	}
		
		prj->UpdateAllGraphicsViews();
	}
}

void gtk_project::popup_EnterCommand(GtkWidget *, gpointer data)
{
	gtk_graphics_view * gv = gtk_graphics_view::GetGV((GtkWidget *) data);
	gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	if (prj)
	{
		new command_dialog(prj, gv, NULL);
	}
}

/*################################################################################################*/

// eof
