with Agcc; use Agcc;
with Agcc.Trees;
with C; use C;

package body Ortho_Ident is
   function Get_Identifier (Str : String) return O_Ident
   is
      Str_Nul : String := Str & Nul;
   begin
      return Get_Identifier (Str_Nul'Address);
   end Get_Identifier;

   function Get_String (Id : O_Ident) return String
   is
      use Agcc.Trees;
      Str : C_Str_Len;
   begin
      Str.Len := Get_IDENTIFIER_LENGTH (Id);
      Str.Str := To_C_String (Get_IDENTIFIER_POINTER (Id));
      return Image (Str);
   end Get_String;

   function Is_Equal (Id : O_Ident; Str : String) return Boolean
   is
      S : C_String;
   begin
      if Get_IDENTIFIER_LENGTH (Id) /= Str'Length then
         return False;
      end if;
      S := To_C_String (Get_IDENTIFIER_POINTER (Id));
      return S.all (1 .. Str'Length) = Str;
   end Is_Equal;

end Ortho_Ident;

