with Agcc.Trees; use Agcc.Trees;
with System;
with Agcc.Hwint; use Agcc.Hwint;

package Agcc.Toplev is
   procedure Rest_Of_Decl_Compilation (Decl : Tree;
                                       Asmspec : System.Address;
                                       Top_Level : C_Bool;
                                       At_End : C_Bool);
   procedure Rest_Of_Type_Compilation (Decl : Tree; Toplevel : C_Bool);
   procedure Rest_Of_Compilation (Decl : Tree);

   function Exact_Log2_Wide (X : HOST_WIDE_INT) return Integer;
   function Floor_Log2_Wide (X : HOST_WIDE_INT) return Integer;

   procedure Error (Msg : System.Address);

   procedure Announce_Function (Func : Tree);

   function Toplev_Main (Argc : Integer; Argv : System.Address)
     return Integer;
private
   pragma Import (C, Rest_Of_Decl_Compilation);
   pragma Import (C, Rest_Of_Type_Compilation);
   pragma Import (C, Rest_Of_Compilation);

   pragma Import (C, Exact_Log2_Wide);
   pragma Import (C, Floor_Log2_Wide);

   pragma Import (C, Error);

   pragma Import (C, Announce_Function);
   pragma Import (C, Toplev_Main);
end Agcc.Toplev;
