package Ortho_Front is
   type String_Acc is access String;
   type String_Acc_Array is array (Natural range <>) of String_Acc;

   --  Called before decode_option.
   --  This procedure can only do internal initializations.  It cannot call
   --  ortho subprograms.
   procedure Init;

   --  An ortho back-end decodes the command line.  Unknown options may
   --  be decoded by the user, with this function.
   --  When an ortho back-end encounter an unknown option, it fills ARGS (0)
   --  with this option and args (1 .. ) with the remaining of the command
   --  line.
   --  DECODE_OPTION must return the number of argument used, ie:
   --  0 if ARGS (0) is an unknown option,
   --  1 if ARGS (0) is a known option without argument,
   --  2 if ARGS (0) is a known option with one argument
   --  ...
   function Decode_Option (Args : String_Acc_Array) return Natural;

   --  Start to parse file FILENAME.
   --  Return False in case of error.
   function Parse (Filename : String_Acc) return Boolean;
end Ortho_Front;
