package body Iir_Chain_Handling is
   procedure Build_Init (Last : out Iir) is
   begin
      Last := Null_Iir;
   end Build_Init;

   procedure Build_Init (Last : out Iir; Parent : Iir)
   is
      El : Iir;
   begin
      El := Get_Chain_Start (Parent);
      if El /= Null_Iir then
         loop
            Last := El;
            El := Get_Chain (El);
            exit when El = Null_Iir;
         end loop;
      else
         Last := Null_Iir;
      end if;
   end Build_Init;

   procedure Append (Last : in out Iir; Parent : Iir; El : Iir) is
   begin
      if Last = Null_Iir then
         Set_Chain_Start (Parent, El);
      else
         Set_Chain (Last, El);
      end if;
      Last := El;
   end Append;

   procedure Append_Subchain (Last : in out Iir; Parent : Iir; Els : Iir)
   is
      El : Iir;
   begin
      if Last = Null_Iir then
         Set_Chain_Start (Parent, Els);
      else
         Set_Chain (Last, Els);
      end if;
      El := Els;
      loop
         Set_Parent (El, Parent);
         Last := El;
         El := Get_Chain (El);
         exit when El = Null_Iir;
      end loop;
   end Append_Subchain;
end Iir_Chain_Handling;

