with GNAT.OS_Lib; use GNAT.OS_Lib;

package Ghdlmain is
   type Command_Type;

   type Command_Acc is access all Command_Type'Class;

   type Command_Type is abstract tagged record
      Next : Command_Acc;
   end record;

   --  Return TRUE iff CMD handle action ACTION.
   function Decode_Command (Cmd : Command_Type; Name : String) return Boolean
     is abstract;

   --  Initialize the command, before decoding actions.
   procedure Init (Cmd : in out Command_Type);

   --  Option_OK: OPTION is handled.
   --  Option_Bad: OPTION is unknown.
   --  Option_Arg_Req: OPTION requires an argument.  Must be set only when
   --     ARG = "", the manager will recall Decode_Option.
   --  Option_Arg: OPTION used the argument.
   type Option_Res is
     (Option_Bad, Option_Ok, Option_Arg, Option_Arg_Req, Option_End);
   procedure Decode_Option (Cmd : in out Command_Type;
                            Option : String;
                            Arg : String;
                            Res : out Option_Res);

   --  Get a one-line help for the command.
   function Get_Short_Help (Cmd : Command_Type) return String
     is abstract;

   --  Disp detailled help.
   procedure Disp_Long_Help (Cmd : Command_Type);

   --  Perform the action.
   procedure Perform_Action (Cmd : in out Command_Type; Args : Argument_List)
     is abstract;

   --  Register a command.
   procedure Register_Command (Cmd : Command_Acc);

   --  Disp MSG on the standard output with the command name.
   procedure Error (Msg : String);

   --  May be raise by perform_action if the arguments are bad.
   Option_Error : exception;

   --  Action failed.
   Compile_Error : exception;

   procedure Main;

   procedure Register_Commands;
end Ghdlmain;
