with System;
with Interfaces.C;

package Agcc is
   pragma Pure (Agcc);

   subtype Chars is System.Address;
   NULL_Chars : Chars renames System.Null_Address;

   Nul : constant Character := Character'Val (0);

   --  Names size_t.
   type Size_T is new Interfaces.C.size_t;

   --  Ada representation of boolean type in C.
   --  Never compare with C_TRUE, since in C any value different from 0 is
   --  considered as true.
   type C_Bool is new Integer;
   pragma Convention (C, C_Bool);

   subtype C_Boolean is C_Bool range 0 .. 1;

   C_False : constant C_Bool := 0;
   C_True : constant C_Bool := 1;

   function "+" (B : C_Bool) return Boolean;
   pragma Inline ("+");
end Agcc;
