/* $Id: search.c,v 1.8 2003/02/16 20:09:03 thrull Exp $ */

/*
 * (C) Copyright 2001-2002 Igor Popik. Released under terms GPL license.
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>

#include "search.h"
#include "http.h"
#include "support.h"
#include "net.h"
#include "interface.h"
#include "gg.h"

extern GGStatus status;
extern GGConfig config;

extern GtkWidget *wyniki_szukaj;
extern GList *watches;

GList *wyniki_kontakty = NULL;
static gint found;

void gg_search_free(GGSearch *s)
{
    if (!s) return;
    g_free(s->first_name);
    g_free(s->last_name);
    g_free(s->gender);
    g_free(s->nick);
    g_free(s->city);
    g_free(s->agemin);
    g_free(s->agemax);
    g_free(s->uin);
    g_free(s);
}

void gg_search(GGSearch * s)
{
	gg_search50_t req;
	
	if (!(req = gg_search50_new()))
	    return;
	
	if (s->uin && *s->uin) {
	    gg_search50_add(req, GG_SEARCH50_UIN, s->uin);
	} else {
	    if (s->first_name && *s->first_name)
		gg_search50_add(req, GG_SEARCH50_FIRSTNAME, s->first_name);
	    if (s->last_name && *s->last_name)
		gg_search50_add(req, GG_SEARCH50_LASTNAME, s->last_name);
	    if (s->nick && *s->nick)
		gg_search50_add(req, GG_SEARCH50_NICKNAME, s->nick);
	    if ((s->agemin && *s->agemin) || (s->agemax && *s->agemax)) {
		struct tm *tm;
		time_t t;
		gchar *buf = NULL;
		
		time(&t);
		tm = localtime(&t);
		
		if (*s->agemin && *s->agemax) 
		    buf = g_strdup_printf("%d %d", 1900 + tm->tm_year - atoi(s->agemin), 1900 + tm->tm_year - atoi(s->agemax));
		else if (*s->agemin) 
		    buf = g_strdup_printf("%d", 1900 + tm->tm_year - atoi(s->agemin));
		else 
		    buf = g_strdup_printf("%d", 1900 + tm->tm_year - atoi(s->agemax));
		
		gg_search50_add(req, GG_SEARCH50_BIRTHYEAR, buf);
		g_free(buf);
	    }
	    if (s->city && *s->city)
		gg_search50_add(req, GG_SEARCH50_CITY, s->city);
	    if (s->gender) {
		if (!strcasecmp("Kobieta",s->gender)) {
		    gg_search50_add(req, GG_SEARCH50_GENDER, GG_SEARCH50_GENDER_FEMALE);
		} else if (!strcasecmp("Mczyzna",s->gender)) {
		    gg_search50_add(req, GG_SEARCH50_GENDER, GG_SEARCH50_GENDER_MALE);
		}
	    }
	    if (s->start) {
		gchar *buf = g_strdup_printf("%d", s->start);
		gg_search50_add(req, GG_SEARCH50_START, buf);
		g_free(buf);
	    }
	}

	if (s->active_only) {
	    gg_search50_add(req, GG_SEARCH50_ACTIVE, GG_SEARCH50_ACTIVE_TRUE);
	}
	
	if (gg_search50(req) == -1) {
	    show_error_dialog ("Nie znaleziono nikogo speniajcego podane kryteria");
	}
	gg_search50_free(req);
}

static void abort_search()
{
	g_warning("abort_search()");

	if (!found) {
	    show_error_dialog ("Nie znaleziono nikogo speniajcego podane kryteria");
	}
}

void gg_search_get_res(GGCmd *cmd)
{
    gg_search50_t res;
    int ret;

    if (wyniki_szukaj == NULL || !GTK_IS_WIDGET(wyniki_szukaj)) {
    	wyniki_szukaj = create_wyniki_szukaj();
    	gtk_widget_show(wyniki_szukaj);
//	return;
    }
    
    if (!(res = gg_search50_new())) {
	g_print("// gg_search50_handle_reply() unable to allocate reply\n");
	return;
    }
    ret = gg_search50_handle_reply(res, cmd->data, cmd->datalen);
    if (!ret) {
	int i, count = gg_search50_count(res);
	if (!count) {
	    abort_search();
	} else {
	    GtkWidget *wyniki_lista;
	    GGSearch *s;
	    gchar *line[4];
	    gint row;
	    
	    if (wyniki_szukaj == NULL || !GTK_IS_WIDGET(wyniki_szukaj)) {
		gg_search50_free(res);
		g_warning("Wyniki szukaj! %p", (gpointer) wyniki_szukaj);
		return;
	    }
	    wyniki_lista = lookup_widget(wyniki_szukaj, "wyniki_lista");
	    g_return_if_fail(wyniki_lista != NULL);
	    
	    s = gtk_object_get_data(GTK_OBJECT(wyniki_szukaj), "search_data");

	    if (!s) {
		s = g_new0(GGSearch, 1);
		gtk_widget_ref(wyniki_szukaj);
		gtk_object_set_data_full(GTK_OBJECT(wyniki_szukaj), "search_data", s, (GtkDestroyNotify)gtk_widget_unref);
	    }

	    gtk_clist_clear(GTK_CLIST(wyniki_lista));
	    if (wyniki_kontakty) {
		GList *tmplist;
		while (tmplist) {
		    GGContact *k = tmplist->data;
		    free_contact(k);
		    tmplist = tmplist->next;
		}
		g_list_free(wyniki_kontakty);
		wyniki_kontakty = NULL;
	    }
	    g_print("Znaleziono %d osb\n", count);

	    if (count < 5) {
		GtkWidget *wiecej;
		
		wiecej = lookup_widget(wyniki_szukaj, "wiecej");
		g_return_if_fail(wiecej != NULL); 
		gtk_widget_set_sensitive(wiecej, FALSE);
	    }
	    
	    for (i = 0;i<count; i++) {
		GGContact *k;
		const gchar *val;
		
		k = g_new0(GGContact, 1);
		val = gg_search50_get(res, i, GG_SEARCH50_STATUS);
		if (!val) {
		    abort_search();
		    break;
		}
		k->status = atoi(val);
		k->uin = atoi(gg_search50_get(res, i, GG_SEARCH50_UIN));
		k->first_name = g_strdup(gg_search50_get(res, i, GG_SEARCH50_FIRSTNAME));
		k->last_name = g_strdup(gg_search50_get(res, i, GG_SEARCH50_LASTNAME));
		k->nick = g_strdup(gg_search50_get(res, i, GG_SEARCH50_NICKNAME));

		wyniki_kontakty = g_list_append(wyniki_kontakty, k);
		line[0] = g_strdup_printf("%d", k->uin);
		line[1] = g_strdup_printf("%s %s%s%s", k->first_name, (k->nick) ? "(": "", (k->nick) ? k->nick : "", (k->nick) ? ")": "");
		line[2] = g_strdup(gg_search50_get(res, i, GG_SEARCH50_BIRTHYEAR));
		line[3] = g_strdup(gg_search50_get(res, i, GG_SEARCH50_CITY));
		
		if (line[3] && line[3][0])
		    cp_to_iso(line[3]);
		if (line[1] && line[1][0])
		    cp_to_iso(line[1]);
		
		row = gtk_clist_append(GTK_CLIST(wyniki_lista), line);
		gtk_clist_set_row_data(GTK_CLIST(wyniki_lista), row, k);
		gg_change_find_kontakt_status(wyniki_lista, k);
		s->start = k->uin;
	    }     
	}
	gg_search50_free(res);
    }
}

void gg_http_search_get_res(GGWatch * r)
{
}
