#%define dbhost			localhost
%define dbname			gforge
%define dbuser			gforge

%if %{?hostname:0}%{!?hostname:1}
	%define hostname `hostname`
%endif
%if %{?sitename:0}%{!?sitename:1}
	%define sitename MyForge
%endif
%if %{?adminemail:0}%{!?adminemail:1}
	%if "%hostname" == "localhost"
		%define adminemail root@localhost.localdomain
	%else
		%define adminemail root@%hostname
	%endif
%endif
%{!?release:%define release 1}

%define gfuser			gforge
%define gfgroup			gforge

Summary: FusionForge Collaborative Development Environment
Name: fusionforge
Version: 4.8.2
Release: %{release}
BuildArch: noarch
License: GPL
Group: Development/Tools
Source0: %{name}-%{version}.tar.bz2
URL: http://www.gforge.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root

Patch1000: gforge-4.0-deb_rpm.patch

AutoReqProv: off
Requires: /bin/sh, /bin/bash
Requires: perl, perl-DBI, perl-HTML-Parser, perl-Text-Autoformat, perl-Mail-Sendmail
Requires: cronolog
Requires: php-jpgraph php-gd
#update sys_path_to_jpgraph in gforge.conf if you remove this line
#Requires: /var/www/jpgraph/jpgraph.php
#Requires: libnss-pgsql >= 1.4
Requires: mailman
Requires: gettext
 
BuildRequires: perl

# RedHat specific - distribution specific (fc = Fedora Core (or RHEL4 and Centos 4) - rh9 = RHL 9 - el3 = RHEL 3 or CentOS 3)
%if "%{_vendor}" == "redhat"
	%if %{?dist:0}%{!?dist:1}
		%define dist fc
	%endif
	
	%define httpduser		apache
	%define httpdgroup		apache
	%define httpddir		httpd

Requires: httpd
Requires: perl-DBD-Pg, php-pgsql
	
	%if "%{dist}" == "fc" 
Requires: php-mbstring
	%endif
	%if "%{dist}" == "el3"
Requires: rh-postgresql, rh-postgresql-server
		%define postgresqlservice rhdb
	%else
Requires: postgresql, postgresql-server
		%define postgresqlservice postgresql
	%endif
	
	%define startpostgresql() service %postgresqlservice status | grep '(pid' >/dev/null 2>&1 || service %postgresqlservice start
	%define reloadpostgresql() service %postgresqlservice reload
	%define gracefulhttpd() service httpd graceful >/dev/null 2>&1
%endif

# SuSE specific
%if "%{_vendor}" == "suse"
	%define httpduser		wwwrun
	%define httpdgroup		www
	%define httpddir		apache2
	
Requires: postgresql, postgresql-server
Requires: pgperl, jpeg
Requires: php5
Requires: php5-pgsql, php5-mbstring

		# Start the postgresql service if needed
		%define startpostgresql() /etc/init.d/postgresql status | grep 'running' >/dev/null 2>&1 || /etc/init.d/postgresql start
		%define reloadpostgresql() /etc/init.d/postgresql reload >/dev/null 2>&1
		%define gracefulhttpd() /etc/init.d/httpd graceful >/dev/null 2>&1
%endif

# Mandrake specific
%if "%{_vendor}" == "MandrakeSoft"
	%define httpduser		apache
	%define httpdgroup		apache
	%define httpddir		httpd
	%define postgresqlservice postgresql
	
Requires: php-mbstring, webserver
Requires: postgresql, postgresql-server
Requires: perl-DBD-Pg, php-pgsql

	%define startpostgresql() service %postgresqlservice status | grep '(pid' >/dev/null 2>&1 || service %postgresqlservice start
	%define reloadpostgresql() service %postgresqlservice reload
	%define gracefulhttpd() service httpd graceful >/dev/null 2>&1
%endif

Provides: gforge = %{Version}

%description
FusionForge provides many tools to aid collaboration in a
development project, such as bug-tracking, task management,
mailing-lists, SCM repository, forums, support request helper,
web/FTP hosting, release management, etc. All these services are
integrated into one web site and managed through a web interface.

# Macro for generating an environment variable (%1) with %2 random characters
%define randstr() %1=`perl -e 'for ($i = 0, $bit = "!", $key = ""; $i < %2; $i++) {while ($bit !~ /^[0-9A-Za-z]$/) { $bit = chr(rand(90) + 32); } $key .= $bit; $bit = "!"; } print "$key";'`

# Change password for admin user
%define changepassword() echo "UPDATE users SET user_pw='%1', email='%{adminemail}' WHERE user_name='admin'" | su -l postgres -s /bin/sh -c "psql %dbname" >/dev/null 2>&1

%define GFORGE_DIR		%{_datadir}/gforge
%define GFORGE_CONF_DIR		%{_sysconfdir}/gforge
%define GFORGE_LANG_DIR         %{_datadir}/locale
%define GFORGE_LIB_DIR		%{GFORGE_DIR}/lib
%define GFORGE_DB_DIR		%{GFORGE_DIR}/db
%define GFORGE_BIN_DIR		%{GFORGE_DIR}/bin
%define PLUGINS_LIB_DIR		%{GFORGE_DIR}/plugins
%define PLUGINS_CONF_DIR	%{GFORGE_CONF_DIR}/plugins
#%define CACHE_DIR		/var/cache/gforge
%define UPLOAD_DIR		/var/lib/gforge/upload
%define SCM_TARBALLS_DIR	/var/lib/gforge/scmtarballs
%define SCM_SNAPSHOTS_DIR	/var/lib/gforge/scmsnapshots
%define CROND_DIR		/%{_sysconfdir}/cron.d
%define HTTPD_CONF_DIR		/%{_sysconfdir}/%{httpddir}
%define SBIN_DIR		%{_sbindir}

%prep
%setup
%patch1000 -p1

%build

%install
# cleaning build environment
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

# creating required directories
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_CONF_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_LANG_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_BIN_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_LIB_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{UPLOAD_DIR}
#install -m 755 -d $RPM_BUILD_ROOT/%{CACHE_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{SCM_TARBALLS_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{SCM_SNAPSHOTS_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{PLUGINS_LIB_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{SBIN_DIR}
install -m 755 -d $RPM_BUILD_ROOT/%{HTTPD_CONF_DIR}/conf.d
install -m 755 -d $RPM_BUILD_ROOT/%{CROND_DIR}

# installing gforge
for i in common cronjobs etc rpm-specific utils www ; do
	cp -rp $i $RPM_BUILD_ROOT/%{GFORGE_DIR}/
done
#create a repository to link the plugins web pages
install -m 755 -d $RPM_BUILD_ROOT/%{GFORGE_DIR}/www/plugins

install -m 750 setup $RPM_BUILD_ROOT/%{GFORGE_DIR}/
chmod 755 $RPM_BUILD_ROOT/%{GFORGE_DIR}/utils/fill-in-the-blanks.pl
chmod 755 $RPM_BUILD_ROOT/%{GFORGE_DIR}/www/scm/viewvc/bin/cgi/viewvc.cgi

cp -rp db/. $RPM_BUILD_ROOT/%{GFORGE_DB_DIR}/
cp -p deb-specific/sf-2.6-complete.sql $RPM_BUILD_ROOT/%{GFORGE_DB_DIR}/

for i in deb-specific/sqlhelper.pm deb-specific/sqlparser.pm utils/include.pl ; do
	cp -p $i $RPM_BUILD_ROOT/%{GFORGE_LIB_DIR}/
done
for i in db-upgrade.pl register-plugin unregister-plugin register-theme unregister-theme install-db.sh; do
	install -m 755 deb-specific/$i $RPM_BUILD_ROOT/%{GFORGE_BIN_DIR}/
done

# configuring apache
## use post install setup script instead
install -m 644 rpm-specific/httpd.d/gforge.conf $RPM_BUILD_ROOT/%{HTTPD_CONF_DIR}/conf.d/gforge.conf

# configuring GForge
install -m 600 rpm-specific/conf/gforge.conf $RPM_BUILD_ROOT/%{GFORGE_CONF_DIR}/
install -m 750 rpm-specific/scripts/gforge-config $RPM_BUILD_ROOT/%{SBIN_DIR}/

#install *.mo
cp -rp locales/* $RPM_BUILD_ROOT/%{GFORGE_LANG_DIR}/

# setting crontab
install -m 664 cron.d/fusionforge $RPM_BUILD_ROOT/%{CROND_DIR}/

%pre
%startpostgresql
if ! id -u %gfuser >/dev/null 2>&1; then
	groupadd -r %{gfgroup}
	useradd -r -g %{gfgroup} -d %{GFORGE_DIR} -s /bin/bash -c "GForge User" %{gfuser}
fi

%post
if [ "$1" -eq "1" ]; then

	# TODO : USE install-db.sh
	# creating the database
	%startpostgresql
	su -l postgres -s /bin/sh -c "createdb -E UNICODE %{dbname} >/dev/null 2>&1"
	su -l postgres -s /bin/sh -c "createlang plpgsql %{dbname} >/dev/null 2>&1"

	# generating and updating site admin password
	%randstr SITEADMIN_PASSWORD 8
	
	# updating admin_password in gforge.conf
	perl -pi -e "
		s#^admin_password=.*#admin_password="$SITEADMIN_PASSWORD"#g" %{GFORGE_CONF_DIR}/gforge.conf
	
	SITEADMIN_PASSWORD=`echo -n $SITEADMIN_PASSWORD | md5sum | awk '{print $1}'`

	# creating gforge database user
	%randstr GFORGEDATABASE_PASSWORD 8

	su -l postgres -c "psql -c \"CREATE USER %{dbuser} WITH PASSWORD '$GFORGEDATABASE_PASSWORD' NOCREATEUSER\" %{dbname} >/dev/null 2>&1"
	su -l postgres -c "psql -c \"CREATE USER gforge_nss WITH PASSWORD '$GFORGEDATABASE_PASSWORD' NOCREATEUSER\" %{dbname} >/dev/null 2>&1"
	su -l postgres -c "psql -c \"CREATE USER gforge_mta WITH PASSWORD '$GFORGEDATABASE_PASSWORD' NOCREATEUSER\" %{dbname} >/dev/null 2>&1"
	
	# replacing variables in configuration files
        perl -pi -e "
                s/DB_HOST/"%{dbhost}"/g;
                s/DB_NAME/"%{dbname}"/g;
                s/DB_USER/"%{dbuser}"/g;
                s/DB_PASSWORD/"$GFORGEDATABASE_PASSWORD"/g;
                s/SYSTEM_NAME/"%{sitename}"/g;
                s/RANDOM_ID/"$SESSID"/g;
                s/HOST_NAME/"%{hostname}"/g" %{GFORGE_CONF_DIR}/gforge.conf

        #admin email
        adminemail=$(echo "%{adminemail}"| sed 's|@|\\\@|g')
        perl -pi -e "
                s/SERVER_ADMIN/"$adminemail"/g" %{GFORGE_CONF_DIR}/gforge.conf
	
	# updating PostgreSQL configuration
	#if ! grep -i '^ *host.*%{dbname}.*' /var/lib/pgsql/data/pg_hba.conf >/dev/null 2>&1; then
	#	echo 'host %{dbname} %{dbuser} 127.0.0.1 255.255.255.255 md5' >> /var/lib/pgsql/data/pg_hba.conf
 	#	echo 'local %{dbname} gforge_mta md5md5md5md5md5' >> /var/lib/pgsql/data/pg_hba.conf
	#	echo 'local %{dbname} gforge_nss trust' >> /var/lib/pgsql/data/pg_hba.conf
	#	%reloadpostgresql
	#fi

	%{GFORGE_BIN_DIR}/install-db.sh configure-files
        mv /var/lib/pgsql/data/pg_hba.conf /var/lib/pgsql/data/pg_hba.conf-orig
        mv /var/lib/pgsql/data/pg_hba.conf.gforge-new /var/lib/pgsql/data/pg_hba.conf
        %reloadpostgresql

	# adding "noreply" alias
	for i in /etc/postfix/aliases /etc/mail/aliases /etc/aliases ; do
		if [ -f $i ]; then
			if ! grep -i '^ *noreply:' $i >/dev/null 2>&1; then
				echo 'noreply: /dev/null' >> $i
				newaliases
			fi
			break
		fi
	done

	# generating random session ID
	%randstr SESSID 32

 	#path of jpgraph.php
 	path_jpgraph=$(rpm -ql php-jpgraph | grep jpgraph.php | sed 's/\(.*\)jpgraph.php/\1/')
 	perl -pi -e "
		s#^sys_path_to_jpgraph=.*#sys_path_to_jpgraph=$path_jpgraph#g" %{GFORGE_CONF_DIR}/gforge.conf
 	
 	#wrong 20list http template for mailman on rpm
 	rm -f %{GFORGE_CONF_DIR}/httpd.d/20list
 	
 	perl -pi -e "
 		s#^GFORGE_CONF_DIR=.*#GFORGE_CONF_DIR="%{GFORGE_CONF_DIR}"#g" %{SBIN_DIR}/gforge-config
 
 	## plugins installs apache templates in GFORGE_CONF_DIR
 	ln -s %{GFORGE_DIR}/etc/httpd.d %{GFORGE_CONF_DIR}/httpd.d
	
	# initializing configuration
	%{SBIN_DIR}/gforge-config
	
	# creating the database
	su -l %{gfuser} -c "%{GFORGE_BIN_DIR}/db-upgrade.pl 2>&1" | grep -v ^NOTICE
	su -l postgres -c "psql -c 'UPDATE groups SET register_time=EXTRACT(EPOCH FROM NOW());' %{dbname} >/dev/null 2>&1"
	%changepassword $SITEADMIN_PASSWORD
	
	%gracefulhttpd
	
	if ! id -u anonymous >/dev/null 2>&1; then
 		useradd -m -s /bin/false anonymous
 	fi
 
 	# [ ! -f /usr/bin/php4 ] && ln -s /usr/bin/php /usr/bin/php4
 	
 	CHROOT=`grep '^gforge_chroot=' %{GFORGE_CONF_DIR}/gforge.conf | sed 's/.*=\s*\(.*\)/\1/'`
 	if [ ! -d $CHROOT ] ; then
		mkdir -p $CHROOT
	fi
	
	GROUPS_DIR=`grep '^groupdir=' %{GFORGE_CONF_DIR}/gforge.conf | sed 's/.*=\s*\(.*\)/\1/'`
	if [ ! -d ${CHROOT}${GROUPS_DIR} ] ; then
                mkdir -p ${CHROOT}${GROUPS_DIR}
        fi	

	ln -s %{GFORGE_DIR}/www/env.inc.php %{PLUGINS_LIB_DIR}/env.inc.php
	
	#if not the env.inc.php include-path isn't correct //not necessary if no more /usr/share/gforge
        #ln -s %{PLUGINS_LIB_DIR} %{GFORGE_DIR}/plugins

else
	# upgrading database
	su -l %{gfuser} -c "%{GFORGE_BIN_DIR}/db-upgrade.pl 2>&1" | grep -v ^NOTICE

	# updating configuration
	%{SBIN_DIR}/gforge-config || :
	
fi

%preun

%postun
if [ "$1" -eq "0" ]; then
	# dropping gforge users
	su -l postgres -s /bin/sh -c "dropuser %{dbuser} >/dev/null 2>&1 ; dropuser gforge_nss >/dev/null 2>&1 ; dropuser gforge_mta >/dev/null 2>&1"
	
	for file in local.pl httpd.secrets local.inc httpd.conf httpd.vhosts database.inc ; do
		rm -f %{GFORGE_CONF_DIR}/$file
	done
	# Remove PostgreSQL access
	if grep -i '^ *host.*%{dbname}.*' /var/lib/pgsql/data/pg_hba.conf >/dev/null 2>&1; then
		perl -ni -e 'm@^ *host.*%{dbname}.*@ or print;' /var/lib/pgsql/data/pg_hba.conf >/dev/null 2>&1
		perl -ni -e 'm@^ *local.*%{dbname}.*@ or print;' /var/lib/pgsql/data/pg_hba.conf >/dev/null 2>&1
	fi
	# Remove user/group
	if id -u %{gfuser} >/dev/null 2>&1; then
		userdel %{gfuser} >/dev/null 2>&1
		groupdel %{gfgroup} >/dev/null 2>&1
	fi
	
	if ! id -u anonymous >/dev/null 2>&1; then
 		userdel anonymous 2>/dev/null || :
 	fi
 
 	#[ -L /usr/bin/php4 ] && rm -f /usr/bin/php4

fi

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS AUTHORS.sourceforge COPYING ChangeLog INSTALL README*
%doc docs/*
%attr(0660, %{httpduser}, gforge) %config(noreplace) %{GFORGE_CONF_DIR}/gforge.conf
%attr(0750, root, root) %{SBIN_DIR}/gforge-config
%attr(0640, %{httpduser}, %{httpdgroup}) %config(noreplace) %{HTTPD_CONF_DIR}/conf.d/gforge.conf
%attr(0644, root, root) %{CROND_DIR}/fusionforge
%attr(0775, %{httpduser}, %{httpdgroup}) %dir %{UPLOAD_DIR}
#%attr(0775, %{httpduser}, %{httpdgroup}) %dir %{CACHE_DIR}
%{GFORGE_DIR}
%{GFORGE_LANG_DIR}
%{GFORGE_CONF_DIR}
%{SCM_TARBALLS_DIR}
%{SCM_SNAPSHOTS_DIR}

%changelog
* Wed Jun 29 2005 Open Wide <guillaume.smet@openwide.fr>
- fixed Xavier's patch
- added Mandrake support based on patch [#1194] by Kevin R. Bulgrien
* Wed Apr 27 2005 Rameau Xavier <xrameau@gmail.com> (for e-LaSer : http://www.e-laser.fr)
- Adding specification for SuSE Linux Enterprise Server 9 (in .spec)
- Moving all static definitions to global variables (in .spec)
* Thu Mar 03 2005 Guillaume Smet <guillaume-gforge@smet.org>
- removed useless stuff thanks to Christian's work on db-upgrade.pl
- s/refresh.sh/gforge-config to improve consistency with debian packaging
- it's better to display the output of db-upgrade.pl
* Sun Feb 20 2005 Guillaume Smet <guillaume-gforge@smet.org>
- added a dependency on gforge-lib-jpgraph
- added gforge-4.1-project_task_sql.patch
* Sat Feb 19 2005 Guillaume Smet <guillaume-gforge@smet.org>
- 4.1
- forced the vhost on port 80
- modified the db-upgrade.pl patch to keep nss stuff
- detects if tcpip_socket is set to true before installing the RPM
- fixed dependencies problem for RH9 and RHEL3
- creates gforge_nss and gforge_mta postgresql users
- drops created postgresql users on uninstall
- replaced -f test with ls
* Fri Jan 28 2005 Thales Information Systems <guillaume.smet@openwide.fr>
- fixed default values for release, sitename and hostname
- fixed remaining issues on upgrade
* Thu Jan 27 2005 Thales Information Systems <guillaume.smet@openwide.fr>
- it's now possible to add custom stuff in /etc/gforge/custom/
* Thu Dec 30 2004 Guillaume Smet <guillaume-gforge@smet.org>
- added Allow from all in vhost config
* Wed Dec 29 2004 Guillaume Smet <guillaume-gforge@smet.org>
- added the magic_quotes_gpc On in vhost as the default value for FC3 is now Off
* Sat Dec 25 2004 Guillaume Smet <guillaume-gforge@smet.org>
- it's now possible to add specific language files in the RPM
* Fri Dec 03 2004 Dassault Aviation <guillaume.smet@openwide.fr>
- fixed the vhost configuration
- fixed the default crontab
- the crontab is now a config file and is not replaced on update
- added refresh.sh in /etc/gforge/ to refresh the configuration easily
* Wed Nov 03 2004 Guillaume Smet <guillaume-gforge@smet.org>
- new RPM packaging
