/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  attributes.inl - Pango::Attibute inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Pango::Attribute
 */

inline PangoAttribute*
GFC::Pango::Attribute::pango_attribute() const
{
	return attr_;
}

inline GFC::Pango::Attribute::operator PangoAttribute* () const
{
	return this ? attr_ : 0;
}

inline GFC::Pango::AttrType
GFC::Pango::Attribute::type() const
{
	return (AttrType)attr_->klass->type;
}

inline bool
GFC::Pango::Attribute::is_language() const
{
	return attr_->klass->type == PANGO_ATTR_LANGUAGE;
}

inline bool
GFC::Pango::Attribute::is_family() const
{
	return attr_->klass->type == PANGO_ATTR_FAMILY;
}

inline bool
GFC::Pango::Attribute::is_foreground() const
{
	return attr_->klass->type == PANGO_ATTR_FOREGROUND;
}

inline bool
GFC::Pango::Attribute::is_background() const
{
	return attr_->klass->type == PANGO_ATTR_BACKGROUND;
}

inline bool
GFC::Pango::Attribute::is_size() const
{
	return attr_->klass->type == PANGO_ATTR_SIZE;
}

inline bool
GFC::Pango::Attribute::is_style() const
{
	return attr_->klass->type == PANGO_ATTR_STYLE;
}

inline bool
GFC::Pango::Attribute::is_weight() const
{
	return attr_->klass->type == PANGO_ATTR_WEIGHT;
}

inline bool
GFC::Pango::Attribute::is_variant() const
{
	return attr_->klass->type == PANGO_ATTR_VARIANT;
}

inline bool
GFC::Pango::Attribute::is_stretch() const
{
	return attr_->klass->type == PANGO_ATTR_STRETCH;
}

inline bool
GFC::Pango::Attribute::is_underline() const
{
	return attr_->klass->type == PANGO_ATTR_UNDERLINE;
}

inline bool
GFC::Pango::Attribute::is_strikethrough() const
{
	return attr_->klass->type == PANGO_ATTR_STRIKETHROUGH;
}

inline bool
GFC::Pango::Attribute::is_rise() const
{
	return attr_->klass->type == PANGO_ATTR_RISE;
}

inline bool
GFC::Pango::Attribute::is_font_description() const
{
	return attr_->klass->type == PANGO_ATTR_FONT_DESC;
}

inline bool
GFC::Pango::Attribute::is_shape() const
{
	return attr_->klass->type == PANGO_ATTR_SHAPE;
}

inline bool
GFC::Pango::Attribute::is_scale() const
{
	return attr_->klass->type == PANGO_ATTR_SCALE;
}

inline unsigned int
GFC::Pango::Attribute::start_index() const
{
	return attr_->start_index;
}

inline unsigned int
GFC::Pango::Attribute::end_index() const
{
	return attr_->end_index;
}

inline void
GFC::Pango::Attribute::set_start_index(unsigned int start)
{
	attr_->start_index = start;
}

inline void
GFC::Pango::Attribute::set_end_index(unsigned int end)
{
	attr_->end_index = end;
}

/*  Pango::AttrString
 */

inline PangoAttrString*
GFC::Pango::AttrString::pango_attr_string() const
{
	return reinterpret_cast<PangoAttrString*>(attr_);
}

/*  Pango::AttrLanguage
 */

inline PangoAttrLanguage*
GFC::Pango::AttrLanguage::pango_attr_language() const
{
	return reinterpret_cast<PangoAttrLanguage*>(attr_);
}

inline PangoLanguage*
GFC::Pango::AttrLanguage::get_language() const
{
	return pango_attr_language()->value;
}

inline void
GFC::Pango::AttrLanguage::set_language(PangoLanguage *language)
{
	pango_attr_language()->value = language;
}

/*  Pango::AttrColor
 */

inline PangoAttrColor*
GFC::Pango::AttrColor::pango_attr_color() const
{
	return reinterpret_cast<PangoAttrColor*>(attr_);
}

inline unsigned short
GFC::Pango::AttrColor::red() const
{
	return pango_attr_color()->color.red;
}

inline unsigned short
GFC::Pango::AttrColor::green() const
{
	return pango_attr_color()->color.green;
}

inline unsigned short
GFC::Pango::AttrColor::blue() const
{
	return pango_attr_color()->color.blue;
}

inline void
GFC::Pango::AttrColor::set_red(unsigned short value)
{
	pango_attr_color()->color.red = value;
}

inline void
GFC::Pango::AttrColor::set_green(unsigned short value)
{
	pango_attr_color()->color.green = value;
}

inline void
GFC::Pango::AttrColor::set_blue(unsigned short value)
{
	pango_attr_color()->color.blue = value;
}

/*  Pango::AttrInt
 */

inline PangoAttrInt*
GFC::Pango::AttrInt::pango_attr_int() const
{
	return reinterpret_cast<PangoAttrInt*>(attr_);
}

inline int
GFC::Pango::AttrInt::value() const
{
	return pango_attr_int()->value;
}

inline void
GFC::Pango::AttrInt::set_value(int value)
{
	pango_attr_int()->value = value;
}

/*  Pango::AttrFontDesc
 */

inline PangoAttrFontDesc*
GFC::Pango::AttrFontDesc::pango_attr_font_desc() const
{
	return reinterpret_cast<PangoAttrFontDesc*>(attr_);
}

/*  Pango::AttrShape
 */
inline PangoAttrShape*
GFC::Pango::AttrShape::pango_attr_shape() const
{
	return reinterpret_cast<PangoAttrShape*>(attr_);
}

/*  Pango::AttrFloat
 */

inline PangoAttrFloat*
GFC::Pango::AttrFloat::pango_attr_float() const
{
	return reinterpret_cast<PangoAttrFloat*>(attr_);
}

inline double
GFC::Pango::AttrFloat::value() const
{
	return pango_attr_float()->value;
}

inline void
GFC::Pango::AttrFloat::set_value(double value)
{
	pango_attr_float()->value = value;
}

/*  Pango::AttrStipple
 */

inline GdkPangoAttrStipple*
GFC::Pango::AttrStipple::gdk_pango_attr_stipple() const
{
	return reinterpret_cast<GdkPangoAttrStipple*>(attr_);
}

/*  Pango::AttrEmbossed
 */

inline GdkPangoAttrEmbossed*
GFC::Pango::AttrEmbossed::gdk_pango_attr_embossed() const
{
	return reinterpret_cast<GdkPangoAttrEmbossed*>(attr_);
}

inline bool
GFC::Pango::AttrEmbossed::embossed() const
{
	return gdk_pango_attr_embossed()->embossed != 0;
}

/*  Pango::AttrIterator
 */

inline PangoAttrIterator*
GFC::Pango::AttrIterator::pango_attr_iterator() const
{
	return iterator_;
}

inline void
GFC::Pango::AttrIterator::range(int *start, int *end) const
{
	pango_attr_iterator_range(iterator_, start, end);
}

inline bool
GFC::Pango::AttrIterator::next()
{
	return pango_attr_iterator_next(iterator_);
}

/*  Pango::AttrList
 */

inline PangoAttrList*
GFC::Pango::AttrList::pango_attr_list() const
{
	return reinterpret_cast<PangoAttrList*>(boxed_);
}

inline GFC::Pango::AttrList::operator PangoAttrList* () const
{
	return this ? pango_attr_list() : 0;
}

