/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  spinbuttonsignals.cc - Gtk::SpinButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "spinbutton.hh"
#include "spinbuttonsignals.hh"
#include "private/spinbuttonclass.hh"

using namespace GFC;

/*  Gtk::SpinButtonSignals
 */

Gtk::SpinButtonSignals::SpinButtonSignals(SpinButton *spin_button)
: EntrySignals(spin_button)
{
	Gtk::SpinButtonClass::init(GTK_SPIN_BUTTON_GET_CLASS(spin_button->gtk_spin_button()));
}

Gtk::SpinButtonSignals::~SpinButtonSignals()
{
}

int
Gtk::SpinButtonSignals::on_input(double *new_value)
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	gint result = 0;
	if (g_class->input)
		result = g_class->input((GtkSpinButton*)instance_, new_value);
	return result;
}

int
Gtk::SpinButtonSignals::on_output()
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	gint result = 0;
	if (g_class->output)
		result = g_class->output((GtkSpinButton*)instance_);
	return result;
}

void
Gtk::SpinButtonSignals::on_value_changed()
{
	GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(instance_);
	if (g_class->value_changed)
		g_class->value_changed((GtkSpinButton*)instance_);
}

/*  Gtk::SpinButtonClass
 */

void
Gtk::SpinButtonClass::init(GtkSpinButtonClass *g_class)
{
	g_class->input = &input_proxy;
	g_class->output = &output_proxy;
	g_class->value_changed = &value_changed_proxy;
}

GtkSpinButtonClass*
Gtk::SpinButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_SPIN_BUTTON_GET_CLASS(instance));
	return static_cast<GtkSpinButtonClass*>(ptr);
}

GType
Gtk::SpinButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SPIN_BUTTON);
	}
	return type;
}

void*
Gtk::SpinButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

gint
Gtk::SpinButtonClass::input_proxy(GtkSpinButton *spin_button, gdouble *new_value)
{
	gint result = 0;
	void *ptr = g_object_get_qdata((GObject*)spin_button, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<SpinButtonSignals*>(ptr)->on_input(new_value);
	else
	{
		GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(spin_button);
		if (g_class->input)
			result = g_class->input(spin_button, new_value);
	}
	return result;
}

gint
Gtk::SpinButtonClass::output_proxy(GtkSpinButton *spin_button)
{
	gint result = 0;
	void *ptr = g_object_get_qdata((GObject*)spin_button, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<SpinButtonSignals*>(ptr)->on_output();
	else
	{
		GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(spin_button);
		if (g_class->output)
			result = g_class->output(spin_button);
	}
	return result;
}

void
Gtk::SpinButtonClass::value_changed_proxy(GtkSpinButton *spin_button)
{
	void *ptr = g_object_get_qdata((GObject*)spin_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<SpinButtonSignals*>(ptr)->on_value_changed();
	else
	{
		GtkSpinButtonClass *g_class = SpinButtonClass::get_parent_class(spin_button);
		if (g_class->value_changed)
			g_class->value_changed(spin_button);
	}
}

