/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  layoutsignals.cc - Gtk::Layout virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "layout.hh"
#include "layoutsignals.hh"
#include "private/layoutclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::LayoutSignals
 */

Gtk::LayoutSignals::LayoutSignals(Layout *layout)
: ContainerSignals(layout)
{
	Gtk::LayoutClass::init(GTK_LAYOUT_GET_CLASS(layout->gtk_layout()));
}

Gtk::LayoutSignals::~LayoutSignals()
{
}

void
Gtk::LayoutSignals::on_set_scroll_adjustments(Adjustment *hadjustment, Adjustment *vadjustment)
{
	GtkLayoutClass *g_class = LayoutClass::get_parent_class(instance_);
	if (g_class->set_scroll_adjustments)
		g_class->set_scroll_adjustments((GtkLayout*)instance_, *hadjustment, *vadjustment);
}

/*  Gtk::LayoutClass
 */

void
Gtk::LayoutClass::init(GtkLayoutClass *g_class)
{
	g_class->set_scroll_adjustments = &set_scroll_adjustments_proxy;
}

GtkLayoutClass*
Gtk::LayoutClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_LAYOUT_GET_CLASS(instance));
	return static_cast<GtkLayoutClass*>(ptr);
}

GType
Gtk::LayoutClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_LAYOUT);
	}
	return type;
}

void*
Gtk::LayoutClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::LayoutClass::set_scroll_adjustments_proxy(GtkLayout *layout, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment)
{
	void *ptr = g_object_get_qdata((GObject*)layout, G::ObjectSignals::quark());
	if (ptr)
	{
		Adjustment *tmp_hadjustment = G::Object::wrap<Adjustment>(hadjustment);
		Adjustment *tmp_vadjustment = G::Object::wrap<Adjustment>(vadjustment);
		static_cast<LayoutSignals*>(ptr)->on_set_scroll_adjustments(tmp_hadjustment, tmp_vadjustment);
	}
	else
	{
		GtkLayoutClass *g_class = LayoutClass::get_parent_class(layout);
		if (g_class->set_scroll_adjustments)
			g_class->set_scroll_adjustments(layout, hadjustment, vadjustment);
	}
}

