/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  image.inl - Gtk::Image inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkImage*
GFC::Gtk::Image::gtk_image() const
{
	return reinterpret_cast<GtkImage*>(instance_);
}

inline GFC::Gtk::Image::operator GtkImage* () const
{
	return this ? gtk_image() : 0;
}

inline GFC::Gtk::ImageType
GFC::Gtk::Image::get_storage_type() const
{
	return (ImageType)gtk_image_get_storage_type(gtk_image());
}

inline void
GFC::Gtk::Image::set(const char *filename)
{
	gtk_image_set_from_file(gtk_image(), filename);
}

inline void
GFC::Gtk::Image::reset()
{
	gtk_image_set_from_pixbuf(gtk_image(), 0);
}

