/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  comboboxsignals.cc - Gtk::ComboBox virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "combobox.hh"
#include "comboboxsignals.hh"
#include "private/comboboxclass.hh"

using namespace GFC;

/*  Gtk::ComboBoxSignals
 */

Gtk::ComboBoxSignals::ComboBoxSignals(ComboBox *combo_box)
: ContainerSignals(combo_box)
{
	Gtk::ComboBoxClass::init(GTK_COMBO_BOX_GET_CLASS(combo_box->gtk_combo_box()));
}

Gtk::ComboBoxSignals::~ComboBoxSignals()
{
}

void
Gtk::ComboBoxSignals::on_changed()
{
	GtkComboBoxClass *g_class = ComboBoxClass::get_parent_class(instance_);
	if (g_class->changed)
		g_class->changed((GtkComboBox*)instance_);
}

/*  Gtk::ComboBoxClass
 */

void
Gtk::ComboBoxClass::init(GtkComboBoxClass *g_class)
{
	g_class->changed = &changed_proxy;
}

GtkComboBoxClass*
Gtk::ComboBoxClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_COMBO_BOX_GET_CLASS(instance));
	return static_cast<GtkComboBoxClass*>(ptr);
}

GType
Gtk::ComboBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_COMBO_BOX);
	}
	return type;
}

void*
Gtk::ComboBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ComboBoxClass::changed_proxy(GtkComboBox *combo_box)
{
	void *ptr = g_object_get_qdata((GObject*)combo_box, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ComboBoxSignals*>(ptr)->on_changed();
	else
	{
		GtkComboBoxClass *g_class = ComboBoxClass::get_parent_class(combo_box);
		if (g_class->changed)
			g_class->changed(combo_box);
	}
}

