/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  accelgroupsignals.cc - Gtk::AccelGroup virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "accelgroup.hh"
#include "accelgroupsignals.hh"
#include "private/accelgroupclass.hh"

using namespace GFC;

/*  Gtk::AccelGroupSignals
 */

Gtk::AccelGroupSignals::AccelGroupSignals(AccelGroup *group)
: G::ObjectSignals(group)
{
	Gtk::AccelGroupClass::init(GTK_ACCEL_GROUP_GET_CLASS(group->gtk_accel_group()));
}

Gtk::AccelGroupSignals::~AccelGroupSignals()
{
}

void
Gtk::AccelGroupSignals::on_accel_changed(const AccelKey& accel_key, GClosure *accel_closure)
{
	GtkAccelGroupClass *g_class = AccelGroupClass::get_parent_class(instance_);
	if (g_class->accel_changed)
		g_class->accel_changed((GtkAccelGroup*)instance_, accel_key.key(), (GdkModifierType)accel_key.mods(), accel_closure);
}

/*  Gtk::AccelGroupClass
 */

void
Gtk::AccelGroupClass::init(GtkAccelGroupClass *g_class)
{
	g_class->accel_changed = &accel_changed_proxy;
}

GtkAccelGroupClass*
Gtk::AccelGroupClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ACCEL_GROUP_GET_CLASS(instance));
	return static_cast<GtkAccelGroupClass*>(ptr);
}

GType
Gtk::AccelGroupClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ACCEL_GROUP);
	}
	return type;
}

void*
Gtk::AccelGroupClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::AccelGroupClass::accel_changed_proxy(GtkAccelGroup *accel_group, guint keyval, GdkModifierType modifier, GClosure *accel_closure)
{
	void *ptr = g_object_get_qdata((GObject*)accel_group, G::ObjectSignals::quark());
	if (ptr)
	{
		AccelKey accel_key(keyval, (Gdk::ModifierTypeField)modifier);
		static_cast<AccelGroupSignals*>(ptr)->on_accel_changed(accel_key, accel_closure);
	}
	else
	{
		GtkAccelGroupClass *g_class = AccelGroupClass::get_parent_class(accel_group);
		if (g_class->accel_changed)
			g_class->accel_changed(accel_group, keyval, modifier, accel_closure);
	}
}

