<?php
/*************************************************************************************
 * autoit.php
 * --------
 * Author: big_daddy (robert.i.anthony@gmail.com)
 * Copyright: (c) 2006 and to GESHi ;)
 * Release Version: 1.0.8.1
 * Date Started: 2006/01/26
 *
 * AutoIT language file for GeSHi.
 *
 * CHANGES
 * -------
 * Release 1.0.8.1 (2008/09/15)
 * - Updated on 22.03.2008 By Tlem (tlem@tuxolem.fr)
 * - The link on functions will now correctly re-direct to
 * - http://www.autoitscript.com/autoit3/docs/functions/{FNAME}.htm
 * - Updated whith au3.api (09.02.2008).
 * - Updated - 16 Mai 2008 - v3.2.12.0
 * - Updated - 12 June 2008 - v3.2.12.1
 * Release 1.0.7.20 (2006/01/26)
 * - First Release
 *
 * Current bugs & todo:
 * ----------
 * - doesn't highlight symbols (Please note that in 1.0.X these are not used. Hopefully they will be used in 1.2.X.)
 * - not sure how to get sendkeys to work " {!}, {SPACE} etc... "
 * - just copyied the regexp for variable from php so this HAVE to be checked and fixed to a better one ;)
 *
 * Reference: http://www.autoitscript.com/autoit3/docs/
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/

$language_data = array (
    'LANG_NAME' => 'AutoIt',
    'COMMENT_SINGLE' => array(';'),
    'COMMENT_MULTI' => array(
        '#comments-start' => '#comments-end',
        '#cs' => '#ce'),
    'COMMENT_REGEXP' => array(0 => '/(?<!#)#(\s.*)?$/m'),
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'QUOTEMARKS' => array("'", '"'),
    'ESCAPE_CHAR' => '',
    'KEYWORDS' => array(
        1 => array(
            'And', 'ByRef', 'Case',
            'Const', 'ContinueCase', 'ContinueLoop',
            'Default', 'Dim', 'Do',
            'Else', 'ElseIf', 'EndFunc',
            'EndIf', 'EndSelect', 'EndSwitch',
            'EndWith', 'Enum', 'Exit',
            'ExitLoop', 'False', 'For',
            'Func', 'Global', 'If',
            'In', 'Local', 'Next',
            'Not', 'Or', 'ReDim',
            'Return', 'Select', 'Step',
            'Switch', 'Then', 'To',
            'True', 'Until', 'WEnd',
            'While', 'With'
            ),
        2 => array(
            '@AppDataCommonDir', '@AppDataDir', '@AutoItExe',
            '@AutoItPID', '@AutoItUnicode', '@AutoItVersion',
            '@AutoItX64', '@COM_EventObj', '@CommonFilesDir',
            '@Compiled', '@ComputerName', '@ComSpec',
            '@CR', '@CRLF', '@DesktopCommonDir',
            '@DesktopDepth', '@DesktopDir', '@DesktopHeight',
            '@DesktopRefresh', '@DesktopWidth', '@DocumentsCommonDir',
            '@error', '@exitCode', '@exitMethod',
            '@extended', '@FavoritesCommonDir', '@FavoritesDir',
            '@GUI_CtrlHandle', '@GUI_CtrlId', '@GUI_DragFile',
            '@GUI_DragId', '@GUI_DropId', '@GUI_WinHandle',
            '@HomeDrive', '@HomePath', '@HomeShare',
            '@HotKeyPressed', '@HOUR', '@InetGetActive',
            '@InetGetBytesRead', '@IPAddress1', '@IPAddress2',
            '@IPAddress3', '@IPAddress4', '@KBLayout',
            '@LF', '@LogonDNSDomain', '@LogonDomain',
            '@LogonServer', '@MDAY', '@MIN',
            '@MON', '@MyDocumentsDir', '@NumParams',
            '@OSBuild', '@OSLang', '@OSServicePack',
            '@OSTYPE', '@OSVersion', '@ProcessorArch',
            '@ProgramFilesDir', '@ProgramsCommonDir', '@ProgramsDir',
            '@ScriptDir', '@ScriptFullPath', '@ScriptLineNumber',
            '@ScriptName', '@SEC', '@StartMenuCommonDir',
            '@StartMenuDir', '@StartupCommonDir', '@StartupDir',
            '@SW_DISABLE', '@SW_ENABLE', '@SW_HIDE',
            '@SW_LOCK', '@SW_MAXIMIZE', '@SW_MINIMIZE',
            '@SW_RESTORE', '@SW_SHOW', '@SW_SHOWDEFAULT',
            '@SW_SHOWMAXIMIZED', '@SW_SHOWMINIMIZED', '@SW_SHOWMINNOACTIVE',
            '@SW_SHOWNA', '@SW_SHOWNOACTIVATE', '@SW_SHOWNORMAL',
            '@SW_UNLOCK', '@SystemDir', '@TAB',
            '@TempDir', '@TRAY_ID', '@TrayIconFlashing',
            '@TrayIconVisible', '@UserName', '@UserProfileDir',
            '@WDAY', '@WindowsDir', '@WorkingDir',
            '@YDAY', '@YEAR'
            ),
        3 => array(
            'Abs', 'ACos', 'AdlibDisable',
            'AdlibEnable', 'Asc', 'AscW',
            'ASin', 'Assign', 'ATan',
            'AutoItSetOption', 'AutoItWinGetTitle', 'AutoItWinSetTitle',
            'Beep', 'Binary', 'BinaryLen',
            'BinaryMid', 'BinaryToString', 'BitAND',
            'BitNOT', 'BitOR', 'BitRotate',
            'BitShift', 'BitXOR', 'BlockInput',
            'Break', 'Call', 'CDTray',
            'Ceiling', 'Chr', 'ChrW',
            'ClipGet', 'ClipPut', 'ConsoleRead',
            'ConsoleWrite', 'ConsoleWriteError', 'ControlClick',
            'ControlCommand', 'ControlDisable', 'ControlEnable',
            'ControlFocus', 'ControlGetFocus', 'ControlGetHandle',
            'ControlGetPos', 'ControlGetText', 'ControlHide',
            'ControlListView', 'ControlMove', 'ControlSend',
            'ControlSetText', 'ControlShow', 'ControlTreeView',
            'Cos', 'Dec', 'DirCopy',
            'DirCreate', 'DirGetSize', 'DirMove',
            'DirRemove', 'DllCall', 'DllCallbackFree',
            'DllCallbackGetPtr', 'DllCallbackRegister', 'DllClose',
            'DllOpen', 'DllStructCreate', 'DllStructGetData',
            'DllStructGetPtr', 'DllStructGetSize', 'DllStructSetData',
            'DriveGetDrive', 'DriveGetFileSystem', 'DriveGetLabel',
            'DriveGetSerial', 'DriveGetType', 'DriveMapAdd',
            'DriveMapDel', 'DriveMapGet', 'DriveSetLabel',
            'DriveSpaceFree', 'DriveSpaceTotal', 'DriveStatus',
            'EnvGet', 'EnvSet', 'EnvUpdate',
            'Eval', 'Execute', 'Exp',
            'FileChangeDir', 'FileClose', 'FileCopy',
            'FileCreateNTFSLink', 'FileCreateShortcut', 'FileDelete',
            'FileExists', 'FileFindFirstFile', 'FileFindNextFile',
            'FileGetAttrib', 'FileGetLongName', 'FileGetShortcut',
            'FileGetShortName', 'FileGetSize', 'FileGetTime',
            'FileGetVersion', 'FileInstall', 'FileMove',
            'FileOpen', 'FileOpenDialog', 'FileRead',
            'FileReadLine', 'FileRecycle', 'FileRecycleEmpty',
            'FileSaveDialog', 'FileSelectFolder', 'FileSetAttrib',
            'FileSetTime', 'FileWrite', 'FileWriteLine',
            'Floor', 'FtpSetProxy', 'GUICreate',
            'GUICtrlCreateAvi', 'GUICtrlCreateButton', 'GUICtrlCreateCheckbox',
            'GUICtrlCreateCombo', 'GUICtrlCreateContextMenu', 'GUICtrlCreateDate',
            'GUICtrlCreateDummy', 'GUICtrlCreateEdit', 'GUICtrlCreateGraphic',
            'GUICtrlCreateGroup', 'GUICtrlCreateIcon', 'GUICtrlCreateInput',
            'GUICtrlCreateLabel', 'GUICtrlCreateList', 'GUICtrlCreateListView',
            'GUICtrlCreateListViewItem', 'GUICtrlCreateMenu', 'GUICtrlCreateMenuItem',
            'GUICtrlCreateMonthCal', 'GUICtrlCreateObj', 'GUICtrlCreatePic',
            'GUICtrlCreateProgress', 'GUICtrlCreateRadio', 'GUICtrlCreateSlider',
            'GUICtrlCreateTab', 'GUICtrlCreateTabItem', 'GUICtrlCreateTreeView',
            'GUICtrlCreateTreeViewItem', 'GUICtrlCreateUpdown', 'GUICtrlDelete',
            'GUICtrlGetHandle', 'GUICtrlGetState', 'GUICtrlRead',
            'GUICtrlRecvMsg', 'GUICtrlRegisterListViewSort', 'GUICtrlSendMsg',
            'GUICtrlSendToDummy', 'GUICtrlSetBkColor', 'GUICtrlSetColor',
            'GUICtrlSetCursor', 'GUICtrlSetData', 'GUICtrlSetFont',
            'GUICtrlSetDefColor', 'GUICtrlSetDefBkColor',
            'GUICtrlSetGraphic', 'GUICtrlSetImage', 'GUICtrlSetLimit',
            'GUICtrlSetOnEvent', 'GUICtrlSetPos', 'GUICtrlSetResizing',
            'GUICtrlSetState', 'GUICtrlSetStyle', 'GUICtrlSetTip',
            'GUIDelete', 'GUIGetCursorInfo', 'GUIGetMsg',
            'GUIGetStyle', 'GUIRegisterMsg', 'GUISetAccelerators()', 'GUISetBkColor',
            'GUISetCoord', 'GUISetCursor', 'GUISetFont',
            'GUISetHelp', 'GUISetIcon', 'GUISetOnEvent',
            'GUISetState', 'GUISetStyle', 'GUIStartGroup',
            'GUISwitch', 'Hex', 'HotKeySet',
            'HttpSetProxy', 'HWnd', 'InetGet',
            'InetGetSize', 'IniDelete', 'IniRead',
            'IniReadSection', 'IniReadSectionNames', 'IniRenameSection',
            'IniWrite', 'IniWriteSection', 'InputBox',
            'Int', 'IsAdmin', 'IsArray',
            'IsBinary', 'IsBool', 'IsDeclared',
            'IsDllStruct', 'IsFloat', 'IsHWnd',
            'IsInt', 'IsKeyword', 'IsNumber',
            'IsObj', 'IsPtr', 'IsString',
            'Log', 'MemGetStats', 'Mod',
            'MouseClick', 'MouseClickDrag', 'MouseDown',
            'MouseGetCursor', 'MouseGetPos', 'MouseMove',
            'MouseUp', 'MouseWheel', 'MsgBox',
            'Number', 'ObjCreate', 'ObjEvent',
            'ObjGet', 'ObjName', 'Opt',
            'Ping', 'PixelChecksum', 'PixelGetColor',
            'PixelSearch', 'PluginClose', 'PluginOpen',
            'ProcessClose', 'ProcessExists', 'ProcessGetStats',
            'ProcessList', 'ProcessSetPriority', 'ProcessWait',
            'ProcessWaitClose', 'ProgressOff', 'ProgressOn',
            'ProgressSet', 'Ptr', 'Random',
            'RegDelete', 'RegEnumKey', 'RegEnumVal',
            'RegRead', 'RegWrite', 'Round',
            'Run', 'RunAs', 'RunAsWait',
            'RunWait', 'Send', 'SendKeepActive',
            'SetError', 'SetExtended', 'ShellExecute',
            'ShellExecuteWait', 'Shutdown', 'Sin',
            'Sleep', 'SoundPlay', 'SoundSetWaveVolume',
            'SplashImageOn', 'SplashOff', 'SplashTextOn',
            'Sqrt', 'SRandom', 'StatusbarGetText',
            'StderrRead', 'StdinWrite', 'StdioClose',
            'StdoutRead', 'String', 'StringAddCR',
            'StringCompare', 'StringFormat', 'StringInStr',
            'StringIsAlNum', 'StringIsAlpha', 'StringIsASCII',
            'StringIsDigit', 'StringIsFloat', 'StringIsInt',
            'StringIsLower', 'StringIsSpace', 'StringIsUpper',
            'StringIsXDigit', 'StringLeft', 'StringLen',
            'StringLower', 'StringMid', 'StringRegExp',
            'StringRegExpReplace', 'StringReplace', 'StringRight',
            'StringSplit', 'StringStripCR', 'StringStripWS',
            'StringToBinary', 'StringTrimLeft', 'StringTrimRight',
            'StringUpper', 'Tan', 'TCPAccept',
            'TCPCloseSocket', 'TCPConnect', 'TCPListen',
            'TCPNameToIP', 'TCPRecv', 'TCPSend',
            'TCPShutdown', 'TCPStartup', 'TimerDiff',
            'TimerInit', 'ToolTip', 'TrayCreateItem',
            'TrayCreateMenu', 'TrayGetMsg', 'TrayItemDelete',
            'TrayItemGetHandle', 'TrayItemGetState', 'TrayItemGetText',
            'TrayItemSetOnEvent', 'TrayItemSetState', 'TrayItemSetText',
            'TraySetClick', 'TraySetIcon', 'TraySetOnEvent',
            'TraySetPauseIcon', 'TraySetState', 'TraySetToolTip',
            'TrayTip', 'UBound', 'UDPBind',
            'UDPCloseSocket', 'UDPOpen', 'UDPRecv',
            'UDPSend', 'UDPShutdown', 'UDPStartup',
            'VarGetType', 'WinActivate', 'WinActive',
            'WinClose', 'WinExists', 'WinFlash',
            'WinGetCaretPos', 'WinGetClassList', 'WinGetClientSize',
            'WinGetHandle', 'WinGetPos', 'WinGetProcess',
            'WinGetState', 'WinGetText', 'WinGetTitle',
            'WinKill', 'WinList', 'WinMenuSelectItem',
            'WinMinimizeAll', 'WinMinimizeAllUndo', 'WinMove',
            'WinSetOnTop', 'WinSetState', 'WinSetTitle',
            'WinSetTrans', 'WinWait', 'WinWaitActive',
            'WinWaitClose', 'WinWaitNotActive'
            ),
        4 => array(
            '_ArrayAdd', '_ArrayBinarySearch', '_ArrayConcatenate',
            '_ArrayDelete', '_ArrayDisplay', '_ArrayFindAll',
            '_ArrayInsert', '_ArrayMax', '_ArrayMaxIndex',
            '_ArrayMin', '_ArrayMinIndex', '_ArrayPop',
            '_ArrayPush', '_ArrayReverse', '_ArraySearch',
            '_ArraySort', '_ArraySwap', '_ArrayToClip',
            '_ArrayToString', '_ArrayTrim', '_ChooseColor',
            '_ChooseFont', '_ClipBoard_ChangeChain', '_ClipBoard_Close',
            '_ClipBoard_CountFormats', '_ClipBoard_Empty', '_ClipBoard_EnumFormats',
            '_ClipBoard_FormatStr', '_ClipBoard_GetData', '_ClipBoard_GetDataEx',
            '_ClipBoard_GetFormatName', '_ClipBoard_GetOpenWindow', '_ClipBoard_GetOwner',
            '_ClipBoard_GetPriorityFormat', '_ClipBoard_GetSequenceNumber', '_ClipBoard_GetViewer',
            '_ClipBoard_IsFormatAvailable', '_ClipBoard_Open', '_ClipBoard_RegisterFormat',
            '_ClipBoard_SetData', '_ClipBoard_SetDataEx', '_ClipBoard_SetViewer',
            '_ClipPutFile', '_ColorConvertHSLtoRGB', '_ColorConvertRGBtoHSL',
            '_ColorGetBlue', '_ColorGetGreen', '_ColorGetRed',
            '_Date_Time_CompareFileTime', '_Date_Time_DOSDateTimeToArray', '_Date_Time_DOSDateTimeToFileTime',
            '_Date_Time_DOSDateTimeToStr', '_Date_Time_DOSDateToArray', '_Date_Time_DOSDateToStr',
            '_Date_Time_DOSTimeToArray', '_Date_Time_DOSTimeToStr', '_Date_Time_EncodeFileTime',
            '_Date_Time_EncodeSystemTime', '_Date_Time_FileTimeToArray', '_Date_Time_FileTimeToDOSDateTime',
            '_Date_Time_FileTimeToLocalFileTime', '_Date_Time_FileTimeToStr', '_Date_Time_FileTimeToSystemTime',
            '_Date_Time_GetFileTime', '_Date_Time_GetLocalTime', '_Date_Time_GetSystemTime',
            '_Date_Time_GetSystemTimeAdjustment', '_Date_Time_GetSystemTimeAsFileTime', '_Date_Time_GetSystemTimes',
            '_Date_Time_GetTickCount', '_Date_Time_GetTimeZoneInformation', '_Date_Time_LocalFileTimeToFileTime',
            '_Date_Time_SetFileTime', '_Date_Time_SetLocalTime', '_Date_Time_SetSystemTime',
            '_Date_Time_SetSystemTimeAdjustment', '_Date_Time_SetTimeZoneInformation', '_Date_Time_SystemTimeToArray',
            '_Date_Time_SystemTimeToDateStr', '_Date_Time_SystemTimeToDateTimeStr', '_Date_Time_SystemTimeToFileTime',
            '_Date_Time_SystemTimeToTimeStr', '_Date_Time_SystemTimeToTzSpecificLocalTime', '_Date_Time_TzSpecificLocalTimeToSystemTime',
            '_DateAdd', '_DateDayOfWeek', '_DateDaysInMonth',
            '_DateDiff', '_DateIsLeapYear', '_DateIsValid',
            '_DateTimeFormat', '_DateTimeSplit', '_DateToDayOfWeek',
            '_DateToDayOfWeekISO', '_DateToDayValue', '_DateToMonth',
            '_DayValueToDate', '_DebugBugReportEnv', '_DebugOut',
            '_DebugSetup', '_Degree', '_EventLog__Backup',
            '_EventLog__Clear', '_EventLog__Close', '_EventLog__Count',
            '_EventLog__DeregisterSource', '_EventLog__Full', '_EventLog__Notify',
            '_EventLog__Oldest', '_EventLog__Open', '_EventLog__OpenBackup',
            '_EventLog__Read', '_EventLog__RegisterSource', '_EventLog__Report',
            '_FileCountLines', '_FileCreate', '_FileListToArray',
            '_FilePrint', '_FileReadToArray', '_FileWriteFromArray',
            '_FileWriteLog', '_FileWriteToLine', '_GDIPlus_ArrowCapCreate',
            '_GDIPlus_ArrowCapDispose', '_GDIPlus_ArrowCapGetFillState', '_GDIPlus_ArrowCapGetHeight',
            '_GDIPlus_ArrowCapGetMiddleInset', '_GDIPlus_ArrowCapGetWidth', '_GDIPlus_ArrowCapSetFillState',
            '_GDIPlus_ArrowCapSetHeight', '_GDIPlus_ArrowCapSetMiddleInset', '_GDIPlus_ArrowCapSetWidth',
            '_GDIPlus_BitmapCloneArea', '_GDIPlus_BitmapCreateFromFile', '_GDIPlus_BitmapCreateFromGraphics',
            '_GDIPlus_BitmapCreateFromHBITMAP', '_GDIPlus_BitmapCreateHBITMAPFromBitmap', '_GDIPlus_BitmapDispose',
            '_GDIPlus_BitmapLockBits', '_GDIPlus_BitmapUnlockBits', '_GDIPlus_BrushClone',
            '_GDIPlus_BrushCreateSolid', '_GDIPlus_BrushDispose', '_GDIPlus_BrushGetType',
            '_GDIPlus_CustomLineCapDispose', '_GDIPlus_Decoders', '_GDIPlus_DecodersGetCount',
            '_GDIPlus_DecodersGetSize', '_GDIPlus_Encoders', '_GDIPlus_EncodersGetCLSID',
            '_GDIPlus_EncodersGetCount', '_GDIPlus_EncodersGetParamList', '_GDIPlus_EncodersGetParamListSize',
            '_GDIPlus_EncodersGetSize', '_GDIPlus_FontCreate', '_GDIPlus_FontDispose',
            '_GDIPlus_FontFamilyCreate', '_GDIPlus_FontFamilyDispose', '_GDIPlus_GraphicsClear',
            '_GDIPlus_GraphicsCreateFromHDC', '_GDIPlus_GraphicsCreateFromHWND', '_GDIPlus_GraphicsDispose',
            '_GDIPlus_GraphicsDrawArc', '_GDIPlus_GraphicsDrawBezier', '_GDIPlus_GraphicsDrawClosedCurve',
            '_GDIPlus_GraphicsDrawCurve', '_GDIPlus_GraphicsDrawEllipse', '_GDIPlus_GraphicsDrawImage',
            '_GDIPlus_GraphicsDrawImageRect', '_GDIPlus_GraphicsDrawImageRectRect', '_GDIPlus_GraphicsDrawLine',
            '_GDIPlus_GraphicsDrawPie', '_GDIPlus_GraphicsDrawPolygon', '_GDIPlus_GraphicsDrawRect',
            '_GDIPlus_GraphicsDrawString', '_GDIPlus_GraphicsDrawStringEx', '_GDIPlus_GraphicsFillClosedCurve',
            '_GDIPlus_GraphicsFillEllipse', '_GDIPlus_GraphicsFillPie', '_GDIPlus_GraphicsFillRect',
            '_GDIPlus_GraphicsGetDC', '_GDIPlus_GraphicsGetSmoothingMode', '_GDIPlus_GraphicsMeasureString',
            '_GDIPlus_GraphicsReleaseDC', '_GDIPlus_GraphicsSetSmoothingMode', '_GDIPlus_GraphicsSetTransform',
            '_GDIPlus_ImageDispose', '_GDIPlus_ImageGetGraphicsContext', '_GDIPlus_ImageGetHeight',
            '_GDIPlus_ImageGetWidth', '_GDIPlus_ImageLoadFromFile', '_GDIPlus_ImageSaveToFile',
            '_GDIPlus_ImageSaveToFileEx', '_GDIPlus_MatrixCreate', '_GDIPlus_MatrixDispose',
            '_GDIPlus_MatrixRotate', '_GDIPlus_ParamAdd', '_GDIPlus_ParamInit',
            '_GDIPlus_PenCreate', '_GDIPlus_PenDispose', '_GDIPlus_PenGetAlignment',
            '_GDIPlus_PenGetColor', '_GDIPlus_PenGetCustomEndCap', '_GDIPlus_PenGetDashCap',
            '_GDIPlus_PenGetDashStyle', '_GDIPlus_PenGetEndCap', '_GDIPlus_PenGetWidth',
            '_GDIPlus_PenSetAlignment', '_GDIPlus_PenSetColor', '_GDIPlus_PenSetCustomEndCap',
            '_GDIPlus_PenSetDashCap', '_GDIPlus_PenSetDashStyle', '_GDIPlus_PenSetEndCap',
            '_GDIPlus_PenSetWidth', '_GDIPlus_RectFCreate', '_GDIPlus_Shutdown',
            '_GDIPlus_Startup', '_GDIPlus_StringFormatCreate', '_GDIPlus_StringFormatDispose',
            '_GetIP', '_GUICtrlAVI_Close', '_GUICtrlAVI_Create',
            '_GUICtrlAVI_Destroy', '_GUICtrlAVI_Open', '_GUICtrlAVI_OpenEx',
            '_GUICtrlAVI_Play', '_GUICtrlAVI_Seek', '_GUICtrlAVI_Show',
            '_GUICtrlAVI_Stop', '_GUICtrlButton_Click', '_GUICtrlButton_Create',
            '_GUICtrlButton_Destroy', '_GUICtrlButton_Enable', '_GUICtrlButton_GetCheck',
            '_GUICtrlButton_GetFocus', '_GUICtrlButton_GetIdealSize', '_GUICtrlButton_GetImage',
            '_GUICtrlButton_GetImageList', '_GUICtrlButton_GetState', '_GUICtrlButton_GetText',
            '_GUICtrlButton_GetTextMargin', '_GUICtrlButton_SetCheck', '_GUICtrlButton_SetFocus',
            '_GUICtrlButton_SetImage', '_GUICtrlButton_SetImageList', '_GUICtrlButton_SetSize',
            '_GUICtrlButton_SetState', '_GUICtrlButton_SetStyle', '_GUICtrlButton_SetText',
            '_GUICtrlButton_SetTextMargin', '_GUICtrlButton_Show', '_GUICtrlComboBox_AddDir',
            '_GUICtrlComboBox_AddString', '_GUICtrlComboBox_AutoComplete', '_GUICtrlComboBox_BeginUpdate',
            '_GUICtrlComboBox_Create', '_GUICtrlComboBox_DeleteString', '_GUICtrlComboBox_Destroy',
            '_GUICtrlComboBox_EndUpdate', '_GUICtrlComboBox_FindString', '_GUICtrlComboBox_FindStringExact',
            '_GUICtrlComboBox_GetComboBoxInfo', '_GUICtrlComboBox_GetCount', '_GUICtrlComboBox_GetCurSel',
            '_GUICtrlComboBox_GetDroppedControlRect', '_GUICtrlComboBox_GetDroppedControlRectEx', '_GUICtrlComboBox_GetDroppedState',
            '_GUICtrlComboBox_GetDroppedWidth', '_GUICtrlComboBox_GetEditSel', '_GUICtrlComboBox_GetEditText',
            '_GUICtrlComboBox_GetExtendedUI', '_GUICtrlComboBox_GetHorizontalExtent', '_GUICtrlComboBox_GetItemHeight',
            '_GUICtrlComboBox_GetLBText', '_GUICtrlComboBox_GetLBTextLen', '_GUICtrlComboBox_GetList',
            '_GUICtrlComboBox_GetListArray', '_GUICtrlComboBox_GetLocale', '_GUICtrlComboBox_GetLocaleCountry',
            '_GUICtrlComboBox_GetLocaleLang', '_GUICtrlComboBox_GetLocalePrimLang', '_GUICtrlComboBox_GetLocaleSubLang',
            '_GUICtrlComboBox_GetMinVisible', '_GUICtrlComboBox_GetTopIndex', '_GUICtrlComboBox_InitStorage',
            '_GUICtrlComboBox_InsertString', '_GUICtrlComboBox_LimitText', '_GUICtrlComboBox_ReplaceEditSel',
            '_GUICtrlComboBox_ResetContent', '_GUICtrlComboBox_SelectString', '_GUICtrlComboBox_SetCurSel',
            '_GUICtrlComboBox_SetDroppedWidth', '_GUICtrlComboBox_SetEditSel', '_GUICtrlComboBox_SetEditText',
            '_GUICtrlComboBox_SetExtendedUI', '_GUICtrlComboBox_SetHorizontalExtent', '_GUICtrlComboBox_SetItemHeight',
            '_GUICtrlComboBox_SetMinVisible', '_GUICtrlComboBox_SetTopIndex', '_GUICtrlComboBox_ShowDropDown',
            '_GUICtrlComboBoxEx_AddDir', '_GUICtrlComboBoxEx_AddString', '_GUICtrlComboBoxEx_BeginUpdate',
            '_GUICtrlComboBoxEx_Create', '_GUICtrlComboBoxEx_CreateSolidBitMap', '_GUICtrlComboBoxEx_DeleteString',
            '_GUICtrlComboBoxEx_Destroy', '_GUICtrlComboBoxEx_EndUpdate', '_GUICtrlComboBoxEx_FindStringExact',
            '_GUICtrlComboBoxEx_GetComboBoxInfo', '_GUICtrlComboBoxEx_GetComboControl', '_GUICtrlComboBoxEx_GetCount',
            '_GUICtrlComboBoxEx_GetCurSel', '_GUICtrlComboBoxEx_GetDroppedControlRect', '_GUICtrlComboBoxEx_GetDroppedControlRectEx',
            '_GUICtrlComboBoxEx_GetDroppedState', '_GUICtrlComboBoxEx_GetDroppedWidth', '_GUICtrlComboBoxEx_GetEditControl',
            '_GUICtrlComboBoxEx_GetEditSel', '_GUICtrlComboBoxEx_GetEditText', '_GUICtrlComboBoxEx_GetExtendedStyle',
            '_GUICtrlComboBoxEx_GetExtendedUI', '_GUICtrlComboBoxEx_GetImageList', '_GUICtrlComboBoxEx_GetItem',
            '_GUICtrlComboBoxEx_GetItemEx', '_GUICtrlComboBoxEx_GetItemHeight', '_GUICtrlComboBoxEx_GetItemImage',
            '_GUICtrlComboBoxEx_GetItemIndent', '_GUICtrlComboBoxEx_GetItemOverlayImage', '_GUICtrlComboBoxEx_GetItemParam',
            '_GUICtrlComboBoxEx_GetItemSelectedImage', '_GUICtrlComboBoxEx_GetItemText', '_GUICtrlComboBoxEx_GetItemTextLen',
            '_GUICtrlComboBoxEx_GetList', '_GUICtrlComboBoxEx_GetListArray', '_GUICtrlComboBoxEx_GetLocale',
            '_GUICtrlComboBoxEx_GetLocaleCountry', '_GUICtrlComboBoxEx_GetLocaleLang', '_GUICtrlComboBoxEx_GetLocalePrimLang',
            '_GUICtrlComboBoxEx_GetLocaleSubLang', '_GUICtrlComboBoxEx_GetMinVisible', '_GUICtrlComboBoxEx_GetTopIndex',
            '_GUICtrlComboBoxEx_InitStorage', '_GUICtrlComboBoxEx_InsertString', '_GUICtrlComboBoxEx_LimitText',
            '_GUICtrlComboBoxEx_ReplaceEditSel', '_GUICtrlComboBoxEx_ResetContent', '_GUICtrlComboBoxEx_SetCurSel',
            '_GUICtrlComboBoxEx_SetDroppedWidth', '_GUICtrlComboBoxEx_SetEditSel', '_GUICtrlComboBoxEx_SetEditText',
            '_GUICtrlComboBoxEx_SetExtendedStyle', '_GUICtrlComboBoxEx_SetExtendedUI', '_GUICtrlComboBoxEx_SetImageList',
            '_GUICtrlComboBoxEx_SetItem', '_GUICtrlComboBoxEx_SetItemEx', '_GUICtrlComboBoxEx_SetItemHeight',
            '_GUICtrlComboBoxEx_SetItemImage', '_GUICtrlComboBoxEx_SetItemIndent', '_GUICtrlComboBoxEx_SetItemOverlayImage',
            '_GUICtrlComboBoxEx_SetItemParam', '_GUICtrlComboBoxEx_SetItemSelectedImage', '_GUICtrlComboBoxEx_SetMinVisible',
            '_GUICtrlComboBoxEx_SetTopIndex', '_GUICtrlComboBoxEx_ShowDropDown', '_GUICtrlDTP_Create',
            '_GUICtrlDTP_Destroy', '_GUICtrlDTP_GetMCColor', '_GUICtrlDTP_GetMCFont',
            '_GUICtrlDTP_GetMonthCal', '_GUICtrlDTP_GetRange', '_GUICtrlDTP_GetRangeEx',
            '_GUICtrlDTP_GetSystemTime', '_GUICtrlDTP_GetSystemTimeEx', '_GUICtrlDTP_SetFormat',
            '_GUICtrlDTP_SetMCColor', '_GUICtrlDTP_SetMCFont', '_GUICtrlDTP_SetRange',
            '_GUICtrlDTP_SetRangeEx', '_GUICtrlDTP_SetSystemTime', '_GUICtrlDTP_SetSystemTimeEx',
            '_GUICtrlEdit_AppendText', '_GUICtrlEdit_BeginUpdate', '_GUICtrlEdit_CanUndo',
            '_GUICtrlEdit_CharFromPos', '_GUICtrlEdit_Create', '_GUICtrlEdit_Destroy',
            '_GUICtrlEdit_EmptyUndoBuffer', '_GUICtrlEdit_EndUpdate', '_GUICtrlEdit_Find',
            '_GUICtrlEdit_FmtLines', '_GUICtrlEdit_GetFirstVisibleLine', '_GUICtrlEdit_GetLimitText',
            '_GUICtrlEdit_GetLine', '_GUICtrlEdit_GetLineCount', '_GUICtrlEdit_GetMargins',
            '_GUICtrlEdit_GetModify', '_GUICtrlEdit_GetPasswordChar', '_GUICtrlEdit_GetRECT',
            '_GUICtrlEdit_GetRECTEx', '_GUICtrlEdit_GetSel', '_GUICtrlEdit_GetText',
            '_GUICtrlEdit_GetTextLen', '_GUICtrlEdit_HideBalloonTip', '_GUICtrlEdit_InsertText',
            '_GUICtrlEdit_LineFromChar', '_GUICtrlEdit_LineIndex', '_GUICtrlEdit_LineLength',
            '_GUICtrlEdit_LineScroll', '_GUICtrlEdit_PosFromChar', '_GUICtrlEdit_ReplaceSel',
            '_GUICtrlEdit_Scroll', '_GUICtrlEdit_SetLimitText', '_GUICtrlEdit_SetMargins',
            '_GUICtrlEdit_SetModify', '_GUICtrlEdit_SetPasswordChar', '_GUICtrlEdit_SetReadOnly',
            '_GUICtrlEdit_SetRECT', '_GUICtrlEdit_SetRECTEx', '_GUICtrlEdit_SetRECTNP',
            '_GUICtrlEdit_SetRectNPEx', '_GUICtrlEdit_SetSel', '_GUICtrlEdit_SetTabStops',
            '_GUICtrlEdit_SetText', '_GUICtrlEdit_ShowBalloonTip', '_GUICtrlEdit_Undo',
            '_GUICtrlHeader_AddItem', '_GUICtrlHeader_ClearFilter', '_GUICtrlHeader_ClearFilterAll',
            '_GUICtrlHeader_Create', '_GUICtrlHeader_CreateDragImage', '_GUICtrlHeader_DeleteItem',
            '_GUICtrlHeader_Destroy', '_GUICtrlHeader_EditFilter', '_GUICtrlHeader_GetBitmapMargin',
            '_GUICtrlHeader_GetImageList', '_GUICtrlHeader_GetItem', '_GUICtrlHeader_GetItemAlign',
            '_GUICtrlHeader_GetItemBitmap', '_GUICtrlHeader_GetItemCount', '_GUICtrlHeader_GetItemDisplay',
            '_GUICtrlHeader_GetItemFlags', '_GUICtrlHeader_GetItemFormat', '_GUICtrlHeader_GetItemImage',
            '_GUICtrlHeader_GetItemOrder', '_GUICtrlHeader_GetItemParam', '_GUICtrlHeader_GetItemRect',
            '_GUICtrlHeader_GetItemRectEx', '_GUICtrlHeader_GetItemText', '_GUICtrlHeader_GetItemWidth',
            '_GUICtrlHeader_GetOrderArray', '_GUICtrlHeader_GetUnicodeFormat', '_GUICtrlHeader_HitTest',
            '_GUICtrlHeader_InsertItem', '_GUICtrlHeader_Layout', '_GUICtrlHeader_OrderToIndex',
            '_GUICtrlHeader_SetBitmapMargin', '_GUICtrlHeader_SetFilterChangeTimeout', '_GUICtrlHeader_SetHotDivider',
            '_GUICtrlHeader_SetImageList', '_GUICtrlHeader_SetItem', '_GUICtrlHeader_SetItemAlign',
            '_GUICtrlHeader_SetItemBitmap', '_GUICtrlHeader_SetItemDisplay', '_GUICtrlHeader_SetItemFlags',
            '_GUICtrlHeader_SetItemFormat', '_GUICtrlHeader_SetItemImage', '_GUICtrlHeader_SetItemOrder',
            '_GUICtrlHeader_SetItemParam', '_GUICtrlHeader_SetItemText', '_GUICtrlHeader_SetItemWidth',
            '_GUICtrlHeader_SetOrderArray', '_GUICtrlHeader_SetUnicodeFormat', '_GUICtrlIpAddress_ClearAddress',
            '_GUICtrlIpAddress_Create', '_GUICtrlIpAddress_Destroy', '_GUICtrlIpAddress_Get',
            '_GUICtrlIpAddress_GetArray', '_GUICtrlIpAddress_GetEx', '_GUICtrlIpAddress_IsBlank',
            '_GUICtrlIpAddress_Set', '_GUICtrlIpAddress_SetArray', '_GUICtrlIpAddress_SetEx',
            '_GUICtrlIpAddress_SetFocus', '_GUICtrlIpAddress_SetFont', '_GUICtrlIpAddress_SetRange',
            '_GUICtrlIpAddress_ShowHide', '_GUICtrlListBox_AddFile', '_GUICtrlListBox_AddString',
            '_GUICtrlListBox_BeginUpdate', '_GUICtrlListBox_Create', '_GUICtrlListBox_DeleteString',
            '_GUICtrlListBox_Destroy', '_GUICtrlListBox_Dir', '_GUICtrlListBox_EndUpdate',
            '_GUICtrlListBox_FindInText', '_GUICtrlListBox_FindString', '_GUICtrlListBox_GetAnchorIndex',
            '_GUICtrlListBox_GetCaretIndex', '_GUICtrlListBox_GetCount', '_GUICtrlListBox_GetCurSel',
            '_GUICtrlListBox_GetHorizontalExtent', '_GUICtrlListBox_GetItemData', '_GUICtrlListBox_GetItemHeight',
            '_GUICtrlListBox_GetItemRect', '_GUICtrlListBox_GetItemRectEx', '_GUICtrlListBox_GetListBoxInfo',
            '_GUICtrlListBox_GetLocale', '_GUICtrlListBox_GetLocaleCountry', '_GUICtrlListBox_GetLocaleLang',
            '_GUICtrlListBox_GetLocalePrimLang', '_GUICtrlListBox_GetLocaleSubLang', '_GUICtrlListBox_GetSel',
            '_GUICtrlListBox_GetSelCount', '_GUICtrlListBox_GetSelItems', '_GUICtrlListBox_GetSelItemsText',
            '_GUICtrlListBox_GetText', '_GUICtrlListBox_GetTextLen', '_GUICtrlListBox_GetTopIndex',
            '_GUICtrlListBox_InitStorage', '_GUICtrlListBox_InsertString', '_GUICtrlListBox_ItemFromPoint',
            '_GUICtrlListBox_ReplaceString', '_GUICtrlListBox_ResetContent', '_GUICtrlListBox_SelectString',
            '_GUICtrlListBox_SelItemRange', '_GUICtrlListBox_SelItemRangeEx', '_GUICtrlListBox_SetAnchorIndex',
            '_GUICtrlListBox_SetCaretIndex', '_GUICtrlListBox_SetColumnWidth', '_GUICtrlListBox_SetCurSel',
            '_GUICtrlListBox_SetHorizontalExtent', '_GUICtrlListBox_SetItemData', '_GUICtrlListBox_SetItemHeight',
            '_GUICtrlListBox_SetLocale', '_GUICtrlListBox_SetSel', '_GUICtrlListBox_SetTabStops',
            '_GUICtrlListBox_SetTopIndex', '_GUICtrlListBox_Sort', '_GUICtrlListBox_SwapString',
            '_GUICtrlListBox_UpdateHScroll', '_GUICtrlListView_AddArray', '_GUICtrlListView_AddColumn',
            '_GUICtrlListView_AddItem', '_GUICtrlListView_AddSubItem', '_GUICtrlListView_ApproximateViewHeight',
            '_GUICtrlListView_ApproximateViewRect', '_GUICtrlListView_ApproximateViewWidth', '_GUICtrlListView_Arrange',
            '_GUICtrlListView_BeginUpdate', '_GUICtrlListView_CancelEditLabel', '_GUICtrlListView_ClickItem',
            '_GUICtrlListView_CopyItems', '_GUICtrlListView_Create', '_GUICtrlListView_CreateDragImage',
            '_GUICtrlListView_CreateSolidBitMap', '_GUICtrlListView_DeleteAllItems', '_GUICtrlListView_DeleteColumn',
            '_GUICtrlListView_DeleteItem', '_GUICtrlListView_DeleteItemsSelected', '_GUICtrlListView_Destroy',
            '_GUICtrlListView_DrawDragImage', '_GUICtrlListView_EditLabel', '_GUICtrlListView_EnableGroupView',
            '_GUICtrlListView_EndUpdate', '_GUICtrlListView_EnsureVisible', '_GUICtrlListView_FindInText',
            '_GUICtrlListView_FindItem', '_GUICtrlListView_FindNearest', '_GUICtrlListView_FindParam',
            '_GUICtrlListView_FindText', '_GUICtrlListView_GetBkColor', '_GUICtrlListView_GetBkImage',
            '_GUICtrlListView_GetCallbackMask', '_GUICtrlListView_GetColumn', '_GUICtrlListView_GetColumnCount',
            '_GUICtrlListView_GetColumnOrder', '_GUICtrlListView_GetColumnOrderArray', '_GUICtrlListView_GetColumnWidth',
            '_GUICtrlListView_GetCounterPage', '_GUICtrlListView_GetEditControl', '_GUICtrlListView_GetExtendedListViewStyle',
            '_GUICtrlListView_GetGroupInfo', '_GUICtrlListView_GetGroupViewEnabled', '_GUICtrlListView_GetHeader',
            '_GUICtrlListView_GetHotCursor', '_GUICtrlListView_GetHotItem', '_GUICtrlListView_GetHoverTime',
            '_GUICtrlListView_GetImageList', '_GUICtrlListView_GetISearchString', '_GUICtrlListView_GetItem',
            '_GUICtrlListView_GetItemChecked', '_GUICtrlListView_GetItemCount', '_GUICtrlListView_GetItemCut',
            '_GUICtrlListView_GetItemDropHilited', '_GUICtrlListView_GetItemEx', '_GUICtrlListView_GetItemFocused',
            '_GUICtrlListView_GetItemGroupID', '_GUICtrlListView_GetItemImage', '_GUICtrlListView_GetItemIndent',
            '_GUICtrlListView_GetItemParam', '_GUICtrlListView_GetItemPosition', '_GUICtrlListView_GetItemPositionX',
            '_GUICtrlListView_GetItemPositionY', '_GUICtrlListView_GetItemRect', '_GUICtrlListView_GetItemRectEx',
            '_GUICtrlListView_GetItemSelected', '_GUICtrlListView_GetItemSpacing', '_GUICtrlListView_GetItemSpacingX',
            '_GUICtrlListView_GetItemSpacingY', '_GUICtrlListView_GetItemState', '_GUICtrlListView_GetItemStateImage',
            '_GUICtrlListView_GetItemText', '_GUICtrlListView_GetItemTextArray', '_GUICtrlListView_GetItemTextString',
            '_GUICtrlListView_GetNextItem', '_GUICtrlListView_GetNumberOfWorkAreas', '_GUICtrlListView_GetOrigin',
            '_GUICtrlListView_GetOriginX', '_GUICtrlListView_GetOriginY', '_GUICtrlListView_GetOutlineColor',
            '_GUICtrlListView_GetSelectedColumn', '_GUICtrlListView_GetSelectedCount', '_GUICtrlListView_GetSelectedIndices',
            '_GUICtrlListView_GetSelectionMark', '_GUICtrlListView_GetStringWidth', '_GUICtrlListView_GetSubItemRect',
            '_GUICtrlListView_GetTextBkColor', '_GUICtrlListView_GetTextColor', '_GUICtrlListView_GetToolTips',
            '_GUICtrlListView_GetTopIndex', '_GUICtrlListView_GetUnicodeFormat', '_GUICtrlListView_GetView',
            '_GUICtrlListView_GetViewDetails', '_GUICtrlListView_GetViewLarge', '_GUICtrlListView_GetViewList',
            '_GUICtrlListView_GetViewRect', '_GUICtrlListView_GetViewSmall', '_GUICtrlListView_GetViewTile',
            '_GUICtrlListView_HideColumn', '_GUICtrlListView_HitTest', '_GUICtrlListView_InsertColumn',
            '_GUICtrlListView_InsertGroup', '_GUICtrlListView_InsertItem', '_GUICtrlListView_JustifyColumn',
            '_GUICtrlListView_MapIDToIndex', '_GUICtrlListView_MapIndexToID', '_GUICtrlListView_RedrawItems',
            '_GUICtrlListView_RegisterSortCallBack', '_GUICtrlListView_RemoveAllGroups', '_GUICtrlListView_RemoveGroup',
            '_GUICtrlListView_Scroll', '_GUICtrlListView_SetBkColor', '_GUICtrlListView_SetBkImage',
            '_GUICtrlListView_SetCallBackMask', '_GUICtrlListView_SetColumn', '_GUICtrlListView_SetColumnOrder',
            '_GUICtrlListView_SetColumnOrderArray', '_GUICtrlListView_SetColumnWidth', '_GUICtrlListView_SetExtendedListViewStyle',
            '_GUICtrlListView_SetGroupInfo', '_GUICtrlListView_SetHotItem', '_GUICtrlListView_SetHoverTime',
            '_GUICtrlListView_SetIconSpacing', '_GUICtrlListView_SetImageList', '_GUICtrlListView_SetItem',
            '_GUICtrlListView_SetItemChecked', '_GUICtrlListView_SetItemCount', '_GUICtrlListView_SetItemCut',
            '_GUICtrlListView_SetItemDropHilited', '_GUICtrlListView_SetItemEx', '_GUICtrlListView_SetItemFocused',
            '_GUICtrlListView_SetItemGroupID', '_GUICtrlListView_SetItemImage', '_GUICtrlListView_SetItemIndent',
            '_GUICtrlListView_SetItemParam', '_GUICtrlListView_SetItemPosition', '_GUICtrlListView_SetItemPosition32',
            '_GUICtrlListView_SetItemSelected', '_GUICtrlListView_SetItemState', '_GUICtrlListView_SetItemStateImage',
            '_GUICtrlListView_SetItemText', '_GUICtrlListView_SetOutlineColor', '_GUICtrlListView_SetSelectedColumn',
            '_GUICtrlListView_SetSelectionMark', '_GUICtrlListView_SetTextBkColor', '_GUICtrlListView_SetTextColor',
            '_GUICtrlListView_SetToolTips', '_GUICtrlListView_SetUnicodeFormat', '_GUICtrlListView_SetView',
            '_GUICtrlListView_SetWorkAreas', '_GUICtrlListView_SimpleSort', '_GUICtrlListView_SortItems',
            '_GUICtrlListView_SubItemHitTest', '_GUICtrlListView_UnRegisterSortCallBack', '_GUICtrlMenu_AddMenuItem',
            '_GUICtrlMenu_AppendMenu', '_GUICtrlMenu_CheckMenuItem', '_GUICtrlMenu_CheckRadioItem',
            '_GUICtrlMenu_CreateMenu', '_GUICtrlMenu_CreatePopup', '_GUICtrlMenu_DeleteMenu',
            '_GUICtrlMenu_DestroyMenu', '_GUICtrlMenu_DrawMenuBar', '_GUICtrlMenu_EnableMenuItem',
            '_GUICtrlMenu_FindItem', '_GUICtrlMenu_FindParent', '_GUICtrlMenu_GetItemBmp',
            '_GUICtrlMenu_GetItemBmpChecked', '_GUICtrlMenu_GetItemBmpUnchecked', '_GUICtrlMenu_GetItemChecked',
            '_GUICtrlMenu_GetItemCount', '_GUICtrlMenu_GetItemData', '_GUICtrlMenu_GetItemDefault',
            '_GUICtrlMenu_GetItemDisabled', '_GUICtrlMenu_GetItemEnabled', '_GUICtrlMenu_GetItemGrayed',
            '_GUICtrlMenu_GetItemHighlighted', '_GUICtrlMenu_GetItemID', '_GUICtrlMenu_GetItemInfo',
            '_GUICtrlMenu_GetItemRect', '_GUICtrlMenu_GetItemRectEx', '_GUICtrlMenu_GetItemState',
            '_GUICtrlMenu_GetItemStateEx', '_GUICtrlMenu_GetItemSubMenu', '_GUICtrlMenu_GetItemText',
            '_GUICtrlMenu_GetItemType', '_GUICtrlMenu_GetMenu', '_GUICtrlMenu_GetMenuBackground',
            '_GUICtrlMenu_GetMenuBarInfo', '_GUICtrlMenu_GetMenuContextHelpID', '_GUICtrlMenu_GetMenuData',
            '_GUICtrlMenu_GetMenuDefaultItem', '_GUICtrlMenu_GetMenuHeight', '_GUICtrlMenu_GetMenuInfo',
            '_GUICtrlMenu_GetMenuStyle', '_GUICtrlMenu_GetSystemMenu', '_GUICtrlMenu_InsertMenuItem',
            '_GUICtrlMenu_InsertMenuItemEx', '_GUICtrlMenu_IsMenu', '_GUICtrlMenu_LoadMenu',
            '_GUICtrlMenu_MapAccelerator', '_GUICtrlMenu_MenuItemFromPoint', '_GUICtrlMenu_RemoveMenu',
            '_GUICtrlMenu_SetItemBitmaps', '_GUICtrlMenu_SetItemBmp', '_GUICtrlMenu_SetItemBmpChecked',
            '_GUICtrlMenu_SetItemBmpUnchecked', '_GUICtrlMenu_SetItemChecked', '_GUICtrlMenu_SetItemData',
            '_GUICtrlMenu_SetItemDefault', '_GUICtrlMenu_SetItemDisabled', '_GUICtrlMenu_SetItemEnabled',
            '_GUICtrlMenu_SetItemGrayed', '_GUICtrlMenu_SetItemHighlighted', '_GUICtrlMenu_SetItemID',
            '_GUICtrlMenu_SetItemInfo', '_GUICtrlMenu_SetItemState', '_GUICtrlMenu_SetItemSubMenu',
            '_GUICtrlMenu_SetItemText', '_GUICtrlMenu_SetItemType', '_GUICtrlMenu_SetMenu',
            '_GUICtrlMenu_SetMenuBackground', '_GUICtrlMenu_SetMenuContextHelpID', '_GUICtrlMenu_SetMenuData',
            '_GUICtrlMenu_SetMenuDefaultItem', '_GUICtrlMenu_SetMenuHeight', '_GUICtrlMenu_SetMenuInfo',
            '_GUICtrlMenu_SetMenuStyle', '_GUICtrlMenu_TrackPopupMenu', '_GUICtrlMonthCal_Create',
            '_GUICtrlMonthCal_Destroy', '_GUICtrlMonthCal_GetColor', '_GUICtrlMonthCal_GetColorArray',
            '_GUICtrlMonthCal_GetCurSel', '_GUICtrlMonthCal_GetCurSelStr', '_GUICtrlMonthCal_GetFirstDOW',
            '_GUICtrlMonthCal_GetFirstDOWStr', '_GUICtrlMonthCal_GetMaxSelCount', '_GUICtrlMonthCal_GetMaxTodayWidth',
            '_GUICtrlMonthCal_GetMinReqHeight', '_GUICtrlMonthCal_GetMinReqRect', '_GUICtrlMonthCal_GetMinReqRectArray',
            '_GUICtrlMonthCal_GetMinReqWidth', '_GUICtrlMonthCal_GetMonthDelta', '_GUICtrlMonthCal_GetMonthRange',
            '_GUICtrlMonthCal_GetMonthRangeMax', '_GUICtrlMonthCal_GetMonthRangeMaxStr', '_GUICtrlMonthCal_GetMonthRangeMin',
            '_GUICtrlMonthCal_GetMonthRangeMinStr', '_GUICtrlMonthCal_GetMonthRangeSpan', '_GUICtrlMonthCal_GetRange',
            '_GUICtrlMonthCal_GetRangeMax', '_GUICtrlMonthCal_GetRangeMaxStr', '_GUICtrlMonthCal_GetRangeMin',
            '_GUICtrlMonthCal_GetRangeMinStr', '_GUICtrlMonthCal_GetSelRange', '_GUICtrlMonthCal_GetSelRangeMax',
            '_GUICtrlMonthCal_GetSelRangeMaxStr', '_GUICtrlMonthCal_GetSelRangeMin', '_GUICtrlMonthCal_GetSelRangeMinStr',
            '_GUICtrlMonthCal_GetToday', '_GUICtrlMonthCal_GetTodayStr', '_GUICtrlMonthCal_GetUnicodeFormat',
            '_GUICtrlMonthCal_HitTest', '_GUICtrlMonthCal_SetColor', '_GUICtrlMonthCal_SetCurSel',
            '_GUICtrlMonthCal_SetDayState', '_GUICtrlMonthCal_SetFirstDOW', '_GUICtrlMonthCal_SetMaxSelCount',
            '_GUICtrlMonthCal_SetMonthDelta', '_GUICtrlMonthCal_SetRange', '_GUICtrlMonthCal_SetSelRange',
            '_GUICtrlMonthCal_SetToday', '_GUICtrlMonthCal_SetUnicodeFormat', '_GUICtrlRebar_AddBand',
            '_GUICtrlRebar_AddToolBarBand', '_GUICtrlRebar_BeginDrag', '_GUICtrlRebar_Create',
            '_GUICtrlRebar_DeleteBand', '_GUICtrlRebar_Destroy', '_GUICtrlRebar_DragMove',
            '_GUICtrlRebar_EndDrag', '_GUICtrlRebar_GetBandBackColor', '_GUICtrlRebar_GetBandBorders',
            '_GUICtrlRebar_GetBandBordersEx', '_GUICtrlRebar_GetBandChildHandle', '_GUICtrlRebar_GetBandChildSize',
            '_GUICtrlRebar_GetBandCount', '_GUICtrlRebar_GetBandForeColor', '_GUICtrlRebar_GetBandHeaderSize',
            '_GUICtrlRebar_GetBandID', '_GUICtrlRebar_GetBandIdealSize', '_GUICtrlRebar_GetBandLength',
            '_GUICtrlRebar_GetBandLParam', '_GUICtrlRebar_GetBandMargins', '_GUICtrlRebar_GetBandMarginsEx',
            '_GUICtrlRebar_GetBandRect', '_GUICtrlRebar_GetBandRectEx', '_GUICtrlRebar_GetBandStyle',
            '_GUICtrlRebar_GetBandStyleBreak', '_GUICtrlRebar_GetBandStyleChildEdge', '_GUICtrlRebar_GetBandStyleFixedBMP',
            '_GUICtrlRebar_GetBandStyleFixedSize', '_GUICtrlRebar_GetBandStyleGripperAlways', '_GUICtrlRebar_GetBandStyleHidden',
            '_GUICtrlRebar_GetBandStyleHideTitle', '_GUICtrlRebar_GetBandStyleNoGripper', '_GUICtrlRebar_GetBandStyleTopAlign',
            '_GUICtrlRebar_GetBandStyleUseChevron', '_GUICtrlRebar_GetBandStyleVariableHeight', '_GUICtrlRebar_GetBandText',
            '_GUICtrlRebar_GetBarHeight', '_GUICtrlRebar_GetBKColor', '_GUICtrlRebar_GetColorScheme',
            '_GUICtrlRebar_GetRowCount', '_GUICtrlRebar_GetRowHeight', '_GUICtrlRebar_GetTextColor',
            '_GUICtrlRebar_GetToolTips', '_GUICtrlRebar_GetUnicodeFormat', '_GUICtrlRebar_HitTest',
            '_GUICtrlRebar_IDToIndex', '_GUICtrlRebar_MaximizeBand', '_GUICtrlRebar_MinimizeBand',
            '_GUICtrlRebar_MoveBand', '_GUICtrlRebar_SetBandBackColor', '_GUICtrlRebar_SetBandForeColor',
            '_GUICtrlRebar_SetBandHeaderSize', '_GUICtrlRebar_SetBandID', '_GUICtrlRebar_SetBandIdealSize',
            '_GUICtrlRebar_SetBandLength', '_GUICtrlRebar_SetBandLParam', '_GUICtrlRebar_SetBandStyle',
            '_GUICtrlRebar_SetBandStyleBreak', '_GUICtrlRebar_SetBandStyleChildEdge', '_GUICtrlRebar_SetBandStyleFixedBMP',
            '_GUICtrlRebar_SetBandStyleFixedSize', '_GUICtrlRebar_SetBandStyleGripperAlways', '_GUICtrlRebar_SetBandStyleHidden',
            '_GUICtrlRebar_SetBandStyleHideTitle', '_GUICtrlRebar_SetBandStyleNoGripper', '_GUICtrlRebar_SetBandStyleTopAlign',
            '_GUICtrlRebar_SetBandStyleUseChevron', '_GUICtrlRebar_SetBandStyleVariableHeight', '_GUICtrlRebar_SetBandText',
            '_GUICtrlRebar_SetBKColor', '_GUICtrlRebar_SetColorScheme', '_GUICtrlRebar_SetTextColor',
            '_GUICtrlRebar_SetToolTips', '_GUICtrlRebar_SetUnicodeFormat', '_GUICtrlRebar_ShowBand',
            '_GUICtrlSlider_ClearSel', '_GUICtrlSlider_ClearTics', '_GUICtrlSlider_Create',
            '_GUICtrlSlider_Destroy', '_GUICtrlSlider_GetBuddy', '_GUICtrlSlider_GetChannelRect',
            '_GUICtrlSlider_GetLineSize', '_GUICtrlSlider_GetNumTics', '_GUICtrlSlider_GetPageSize',
            '_GUICtrlSlider_GetPos', '_GUICtrlSlider_GetPTics', '_GUICtrlSlider_GetRange',
            '_GUICtrlSlider_GetRangeMax', '_GUICtrlSlider_GetRangeMin', '_GUICtrlSlider_GetSel',
            '_GUICtrlSlider_GetSelEnd', '_GUICtrlSlider_GetSelStart', '_GUICtrlSlider_GetThumbLength',
            '_GUICtrlSlider_GetThumbRect', '_GUICtrlSlider_GetThumbRectEx', '_GUICtrlSlider_GetTic',
            '_GUICtrlSlider_GetTicPos', '_GUICtrlSlider_GetToolTips', '_GUICtrlSlider_GetUnicodeFormat',
            '_GUICtrlSlider_SetBuddy', '_GUICtrlSlider_SetLineSize', '_GUICtrlSlider_SetPageSize',
            '_GUICtrlSlider_SetPos', '_GUICtrlSlider_SetRange', '_GUICtrlSlider_SetRangeMax',
            '_GUICtrlSlider_SetRangeMin', '_GUICtrlSlider_SetSel', '_GUICtrlSlider_SetSelEnd',
            '_GUICtrlSlider_SetSelStart', '_GUICtrlSlider_SetThumbLength', '_GUICtrlSlider_SetTic',
            '_GUICtrlSlider_SetTicFreq', '_GUICtrlSlider_SetTipSide', '_GUICtrlSlider_SetToolTips',
            '_GUICtrlSlider_SetUnicodeFormat', '_GUICtrlStatusBar_Create', '_GUICtrlStatusBar_Destroy',
            '_GUICtrlStatusBar_EmbedControl', '_GUICtrlStatusBar_GetBorders', '_GUICtrlStatusBar_GetBordersHorz',
            '_GUICtrlStatusBar_GetBordersRect', '_GUICtrlStatusBar_GetBordersVert', '_GUICtrlStatusBar_GetCount',
            '_GUICtrlStatusBar_GetHeight', '_GUICtrlStatusBar_GetIcon', '_GUICtrlStatusBar_GetParts',
            '_GUICtrlStatusBar_GetRect', '_GUICtrlStatusBar_GetRectEx', '_GUICtrlStatusBar_GetText',
            '_GUICtrlStatusBar_GetTextFlags', '_GUICtrlStatusBar_GetTextLength', '_GUICtrlStatusBar_GetTextLengthEx',
            '_GUICtrlStatusBar_GetTipText', '_GUICtrlStatusBar_GetUnicodeFormat', '_GUICtrlStatusBar_GetWidth',
            '_GUICtrlStatusBar_IsSimple', '_GUICtrlStatusBar_Resize', '_GUICtrlStatusBar_SetBkColor',
            '_GUICtrlStatusBar_SetIcon', '_GUICtrlStatusBar_SetMinHeight', '_GUICtrlStatusBar_SetParts',
            '_GUICtrlStatusBar_SetSimple', '_GUICtrlStatusBar_SetText', '_GUICtrlStatusBar_SetTipText',
            '_GUICtrlStatusBar_SetUnicodeFormat', '_GUICtrlStatusBar_ShowHide', '_GUICtrlTab_Create',
            '_GUICtrlTab_DeleteAllItems', '_GUICtrlTab_DeleteItem', '_GUICtrlTab_DeselectAll',
            '_GUICtrlTab_Destroy', '_GUICtrlTab_FindTab', '_GUICtrlTab_GetCurFocus',
            '_GUICtrlTab_GetCurSel', '_GUICtrlTab_GetDisplayRect', '_GUICtrlTab_GetDisplayRectEx',
            '_GUICtrlTab_GetExtendedStyle', '_GUICtrlTab_GetImageList', '_GUICtrlTab_GetItem',
            '_GUICtrlTab_GetItemCount', '_GUICtrlTab_GetItemImage', '_GUICtrlTab_GetItemParam',
            '_GUICtrlTab_GetItemRect', '_GUICtrlTab_GetItemRectEx', '_GUICtrlTab_GetItemState',
            '_GUICtrlTab_GetItemText', '_GUICtrlTab_GetRowCount', '_GUICtrlTab_GetToolTips',
            '_GUICtrlTab_GetUnicodeFormat', '_GUICtrlTab_HighlightItem', '_GUICtrlTab_HitTest',
            '_GUICtrlTab_InsertItem', '_GUICtrlTab_RemoveImage', '_GUICtrlTab_SetCurFocus',
            '_GUICtrlTab_SetCurSel', '_GUICtrlTab_SetExtendedStyle', '_GUICtrlTab_SetImageList',
            '_GUICtrlTab_SetItem', '_GUICtrlTab_SetItemImage', '_GUICtrlTab_SetItemParam',
            '_GUICtrlTab_SetItemSize', '_GUICtrlTab_SetItemState', '_GUICtrlTab_SetItemText',
            '_GUICtrlTab_SetMinTabWidth', '_GUICtrlTab_SetPadding', '_GUICtrlTab_SetToolTips',
            '_GUICtrlTab_SetUnicodeFormat', '_GUICtrlToolbar_AddBitmap', '_GUICtrlToolbar_AddButton',
            '_GUICtrlToolbar_AddButtonSep', '_GUICtrlToolbar_AddString', '_GUICtrlToolbar_ButtonCount',
            '_GUICtrlToolbar_CheckButton', '_GUICtrlToolbar_ClickAccel', '_GUICtrlToolbar_ClickButton',
            '_GUICtrlToolbar_ClickIndex', '_GUICtrlToolbar_CommandToIndex', '_GUICtrlToolbar_Create',
            '_GUICtrlToolbar_Customize', '_GUICtrlToolbar_DeleteButton', '_GUICtrlToolbar_Destroy',
            '_GUICtrlToolbar_EnableButton', '_GUICtrlToolbar_FindToolbar', '_GUICtrlToolbar_GetAnchorHighlight',
            '_GUICtrlToolbar_GetBitmapFlags', '_GUICtrlToolbar_GetButtonBitmap', '_GUICtrlToolbar_GetButtonInfo',
            '_GUICtrlToolbar_GetButtonInfoEx', '_GUICtrlToolbar_GetButtonParam', '_GUICtrlToolbar_GetButtonRect',
            '_GUICtrlToolbar_GetButtonRectEx', '_GUICtrlToolbar_GetButtonSize', '_GUICtrlToolbar_GetButtonState',
            '_GUICtrlToolbar_GetButtonStyle', '_GUICtrlToolbar_GetButtonText', '_GUICtrlToolbar_GetColorScheme',
            '_GUICtrlToolbar_GetDisabledImageList', '_GUICtrlToolbar_GetExtendedStyle', '_GUICtrlToolbar_GetHotImageList',
            '_GUICtrlToolbar_GetHotItem', '_GUICtrlToolbar_GetImageList', '_GUICtrlToolbar_GetInsertMark',
            '_GUICtrlToolbar_GetInsertMarkColor', '_GUICtrlToolbar_GetMaxSize', '_GUICtrlToolbar_GetMetrics',
            '_GUICtrlToolbar_GetPadding', '_GUICtrlToolbar_GetRows', '_GUICtrlToolbar_GetString',
            '_GUICtrlToolbar_GetStyle', '_GUICtrlToolbar_GetStyleAltDrag', '_GUICtrlToolbar_GetStyleCustomErase',
            '_GUICtrlToolbar_GetStyleFlat', '_GUICtrlToolbar_GetStyleList', '_GUICtrlToolbar_GetStyleRegisterDrop',
            '_GUICtrlToolbar_GetStyleToolTips', '_GUICtrlToolbar_GetStyleTransparent', '_GUICtrlToolbar_GetStyleWrapable',
            '_GUICtrlToolbar_GetTextRows', '_GUICtrlToolbar_GetToolTips', '_GUICtrlToolbar_GetUnicodeFormat',
            '_GUICtrlToolbar_HideButton', '_GUICtrlToolbar_HighlightButton', '_GUICtrlToolbar_HitTest',
            '_GUICtrlToolbar_IndexToCommand', '_GUICtrlToolbar_InsertButton', '_GUICtrlToolbar_InsertMarkHitTest',
            '_GUICtrlToolbar_IsButtonChecked', '_GUICtrlToolbar_IsButtonEnabled', '_GUICtrlToolbar_IsButtonHidden',
            '_GUICtrlToolbar_IsButtonHighlighted', '_GUICtrlToolbar_IsButtonIndeterminate', '_GUICtrlToolbar_IsButtonPressed',
            '_GUICtrlToolbar_LoadBitmap', '_GUICtrlToolbar_LoadImages', '_GUICtrlToolbar_MapAccelerator',
            '_GUICtrlToolbar_MoveButton', '_GUICtrlToolbar_PressButton', '_GUICtrlToolbar_SetAnchorHighlight',
            '_GUICtrlToolbar_SetBitmapSize', '_GUICtrlToolbar_SetButtonBitMap', '_GUICtrlToolbar_SetButtonInfo',
            '_GUICtrlToolbar_SetButtonInfoEx', '_GUICtrlToolbar_SetButtonParam', '_GUICtrlToolbar_SetButtonSize',
            '_GUICtrlToolbar_SetButtonState', '_GUICtrlToolbar_SetButtonStyle', '_GUICtrlToolbar_SetButtonText',
            '_GUICtrlToolbar_SetButtonWidth', '_GUICtrlToolbar_SetCmdID', '_GUICtrlToolbar_SetColorScheme',
            '_GUICtrlToolbar_SetDisabledImageList', '_GUICtrlToolbar_SetDrawTextFlags', '_GUICtrlToolbar_SetExtendedStyle',
            '_GUICtrlToolbar_SetHotImageList', '_GUICtrlToolbar_SetHotItem', '_GUICtrlToolbar_SetImageList',
            '_GUICtrlToolbar_SetIndent', '_GUICtrlToolbar_SetIndeterminate', '_GUICtrlToolbar_SetInsertMark',
            '_GUICtrlToolbar_SetInsertMarkColor', '_GUICtrlToolbar_SetMaxTextRows', '_GUICtrlToolbar_SetMetrics',
            '_GUICtrlToolbar_SetPadding', '_GUICtrlToolbar_SetParent', '_GUICtrlToolbar_SetRows',
            '_GUICtrlToolbar_SetStyle', '_GUICtrlToolbar_SetStyleAltDrag', '_GUICtrlToolbar_SetStyleCustomErase',
            '_GUICtrlToolbar_SetStyleFlat', '_GUICtrlToolbar_SetStyleList', '_GUICtrlToolbar_SetStyleRegisterDrop',
            '_GUICtrlToolbar_SetStyleToolTips', '_GUICtrlToolbar_SetStyleTransparent', '_GUICtrlToolbar_SetStyleWrapable',
            '_GUICtrlToolbar_SetToolTips', '_GUICtrlToolbar_SetUnicodeFormat', '_GUICtrlToolbar_SetWindowTheme',
            '_GUICtrlTreeView_Add', '_GUICtrlTreeView_AddChild', '_GUICtrlTreeView_AddChildFirst',
            '_GUICtrlTreeView_AddFirst', '_GUICtrlTreeView_BeginUpdate', '_GUICtrlTreeView_ClickItem',
            '_GUICtrlTreeView_Create', '_GUICtrlTreeView_CreateDragImage', '_GUICtrlTreeView_CreateSolidBitMap',
            '_GUICtrlTreeView_Delete', '_GUICtrlTreeView_DeleteAll', '_GUICtrlTreeView_DeleteChildren',
            '_GUICtrlTreeView_Destroy', '_GUICtrlTreeView_DisplayRect', '_GUICtrlTreeView_DisplayRectEx',
            '_GUICtrlTreeView_EditText', '_GUICtrlTreeView_EndEdit', '_GUICtrlTreeView_EndUpdate',
            '_GUICtrlTreeView_EnsureVisible', '_GUICtrlTreeView_Expand', '_GUICtrlTreeView_ExpandedOnce',
            '_GUICtrlTreeView_FindItem', '_GUICtrlTreeView_FindItemEx', '_GUICtrlTreeView_GetBkColor',
            '_GUICtrlTreeView_GetBold', '_GUICtrlTreeView_GetChecked', '_GUICtrlTreeView_GetChildCount',
            '_GUICtrlTreeView_GetChildren', '_GUICtrlTreeView_GetCount', '_GUICtrlTreeView_GetCut',
            '_GUICtrlTreeView_GetDropTarget', '_GUICtrlTreeView_GetEditControl', '_GUICtrlTreeView_GetExpanded',
            '_GUICtrlTreeView_GetFirstChild', '_GUICtrlTreeView_GetFirstItem', '_GUICtrlTreeView_GetFirstVisible',
            '_GUICtrlTreeView_GetFocused', '_GUICtrlTreeView_GetHeight', '_GUICtrlTreeView_GetImageIndex',
            '_GUICtrlTreeView_GetImageListIconHandle', '_GUICtrlTreeView_GetIndent', '_GUICtrlTreeView_GetInsertMarkColor',
            '_GUICtrlTreeView_GetISearchString', '_GUICtrlTreeView_GetItemByIndex', '_GUICtrlTreeView_GetItemHandle',
            '_GUICtrlTreeView_GetItemParam', '_GUICtrlTreeView_GetLastChild', '_GUICtrlTreeView_GetLineColor',
            '_GUICtrlTreeView_GetNext', '_GUICtrlTreeView_GetNextChild', '_GUICtrlTreeView_GetNextSibling',
            '_GUICtrlTreeView_GetNextVisible', '_GUICtrlTreeView_GetNormalImageList', '_GUICtrlTreeView_GetParentHandle',
            '_GUICtrlTreeView_GetParentParam', '_GUICtrlTreeView_GetPrev', '_GUICtrlTreeView_GetPrevChild',
            '_GUICtrlTreeView_GetPrevSibling', '_GUICtrlTreeView_GetPrevVisible', '_GUICtrlTreeView_GetScrollTime',
            '_GUICtrlTreeView_GetSelected', '_GUICtrlTreeView_GetSelectedImageIndex', '_GUICtrlTreeView_GetSelection',
            '_GUICtrlTreeView_GetSiblingCount', '_GUICtrlTreeView_GetState', '_GUICtrlTreeView_GetStateImageIndex',
            '_GUICtrlTreeView_GetStateImageList', '_GUICtrlTreeView_GetText', '_GUICtrlTreeView_GetTextColor',
            '_GUICtrlTreeView_GetToolTips', '_GUICtrlTreeView_GetTree', '_GUICtrlTreeView_GetUnicodeFormat',
            '_GUICtrlTreeView_GetVisible', '_GUICtrlTreeView_GetVisibleCount', '_GUICtrlTreeView_HitTest',
            '_GUICtrlTreeView_HitTestEx', '_GUICtrlTreeView_HitTestItem', '_GUICtrlTreeView_Index',
            '_GUICtrlTreeView_InsertItem', '_GUICtrlTreeView_IsFirstItem', '_GUICtrlTreeView_IsParent',
            '_GUICtrlTreeView_Level', '_GUICtrlTreeView_SelectItem', '_GUICtrlTreeView_SelectItemByIndex',
            '_GUICtrlTreeView_SetBkColor', '_GUICtrlTreeView_SetBold', '_GUICtrlTreeView_SetChecked',
            '_GUICtrlTreeView_SetCheckedByIndex', '_GUICtrlTreeView_SetChildren', '_GUICtrlTreeView_SetCut',
            '_GUICtrlTreeView_SetDropTarget', '_GUICtrlTreeView_SetFocused', '_GUICtrlTreeView_SetHeight',
            '_GUICtrlTreeView_SetIcon', '_GUICtrlTreeView_SetImageIndex', '_GUICtrlTreeView_SetIndent',
            '_GUICtrlTreeView_SetInsertMark', '_GUICtrlTreeView_SetInsertMarkColor', '_GUICtrlTreeView_SetItemHeight',
            '_GUICtrlTreeView_SetItemParam', '_GUICtrlTreeView_SetLineColor', '_GUICtrlTreeView_SetNormalImageList',
            '_GUICtrlTreeView_SetScrollTime', '_GUICtrlTreeView_SetSelected', '_GUICtrlTreeView_SetSelectedImageIndex',
            '_GUICtrlTreeView_SetState', '_GUICtrlTreeView_SetStateImageIndex', '_GUICtrlTreeView_SetStateImageList',
            '_GUICtrlTreeView_SetText', '_GUICtrlTreeView_SetTextColor', '_GUICtrlTreeView_SetToolTips',
            '_GUICtrlTreeView_SetUnicodeFormat', '_GUICtrlTreeView_Sort', '_GUIImageList_Add',
            '_GUIImageList_AddBitmap', '_GUIImageList_AddIcon', '_GUIImageList_AddMasked',
            '_GUIImageList_BeginDrag', '_GUIImageList_Copy', '_GUIImageList_Create',
            '_GUIImageList_Destroy', '_GUIImageList_DestroyIcon', '_GUIImageList_DragEnter',
            '_GUIImageList_DragLeave', '_GUIImageList_DragMove', '_GUIImageList_Draw',
            '_GUIImageList_DrawEx', '_GUIImageList_Duplicate', '_GUIImageList_EndDrag',
            '_GUIImageList_GetBkColor', '_GUIImageList_GetIcon', '_GUIImageList_GetIconHeight',
            '_GUIImageList_GetIconSize', '_GUIImageList_GetIconSizeEx', '_GUIImageList_GetIconWidth',
            '_GUIImageList_GetImageCount', '_GUIImageList_GetImageInfoEx', '_GUIImageList_Remove',
            '_GUIImageList_ReplaceIcon', '_GUIImageList_SetBkColor', '_GUIImageList_SetIconSize',
            '_GUIImageList_SetImageCount', '_GUIImageList_Swap', '_GUIScrollBars_EnableScrollBar',
            '_GUIScrollBars_GetScrollBarInfoEx', '_GUIScrollBars_GetScrollBarRect', '_GUIScrollBars_GetScrollBarRGState',
            '_GUIScrollBars_GetScrollBarXYLineButton', '_GUIScrollBars_GetScrollBarXYThumbBottom', '_GUIScrollBars_GetScrollBarXYThumbTop',
            '_GUIScrollBars_GetScrollInfo', '_GUIScrollBars_GetScrollInfoEx', '_GUIScrollBars_GetScrollInfoMax',
            '_GUIScrollBars_GetScrollInfoMin', '_GUIScrollBars_GetScrollInfoPage', '_GUIScrollBars_GetScrollInfoPos',
            '_GUIScrollBars_GetScrollInfoTrackPos', '_GUIScrollBars_GetScrollPos', '_GUIScrollBars_GetScrollRange',
            '_GUIScrollBars_Init', '_GUIScrollBars_ScrollWindow', '_GUIScrollBars_SetScrollInfo',
            '_GUIScrollBars_SetScrollInfoMax', '_GUIScrollBars_SetScrollInfoMin', '_GUIScrollBars_SetScrollInfoPage',
            '_GUIScrollBars_SetScrollInfoPos', '_GUIScrollBars_SetScrollRange', '_GUIScrollBars_ShowScrollBar',
            '_GUIToolTip_Activate', '_GUIToolTip_AddTool', '_GUIToolTip_AdjustRect',
            '_GUIToolTip_BitsToTTF', '_GUIToolTip_Create', '_GUIToolTip_DelTool',
            '_GUIToolTip_Destroy', '_GUIToolTip_EnumTools', '_GUIToolTip_GetBubbleHeight',
            '_GUIToolTip_GetBubbleSize', '_GUIToolTip_GetBubbleWidth', '_GUIToolTip_GetCurrentTool',
            '_GUIToolTip_GetDelayTime', '_GUIToolTip_GetMargin', '_GUIToolTip_GetMarginEx',
            '_GUIToolTip_GetMaxTipWidth', '_GUIToolTip_GetText', '_GUIToolTip_GetTipBkColor',
            '_GUIToolTip_GetTipTextColor', '_GUIToolTip_GetTitleBitMap', '_GUIToolTip_GetTitleText',
            '_GUIToolTip_GetToolCount', '_GUIToolTip_GetToolInfo', '_GUIToolTip_HitTest',
            '_GUIToolTip_NewToolRect', '_GUIToolTip_Pop', '_GUIToolTip_PopUp',
            '_GUIToolTip_SetDelayTime', '_GUIToolTip_SetMargin', '_GUIToolTip_SetMaxTipWidth',
            '_GUIToolTip_SetTipBkColor', '_GUIToolTip_SetTipTextColor', '_GUIToolTip_SetTitle',
            '_GUIToolTip_SetToolInfo', '_GUIToolTip_SetWindowTheme', '_GUIToolTip_ToolExists',
            '_GUIToolTip_ToolToArray', '_GUIToolTip_TrackActivate', '_GUIToolTip_TrackPosition',
            '_GUIToolTip_TTFToBits', '_GUIToolTip_Update', '_GUIToolTip_UpdateTipText',
            '_HexToString', '_IE_Example', '_IE_Introduction',
            '_IE_VersionInfo', '_IEAction', '_IEAttach',
            '_IEBodyReadHTML', '_IEBodyReadText', '_IEBodyWriteHTML',
            '_IECreate', '_IECreateEmbedded', '_IEDocGetObj',
            '_IEDocInsertHTML', '_IEDocInsertText', '_IEDocReadHTML',
            '_IEDocWriteHTML', '_IEErrorHandlerDeRegister', '_IEErrorHandlerRegister',
            '_IEErrorNotify', '_IEFormElementCheckBoxSelect', '_IEFormElementGetCollection',
            '_IEFormElementGetObjByName', '_IEFormElementGetValue', '_IEFormElementOptionSelect',
            '_IEFormElementRadioSelect', '_IEFormElementSetValue', '_IEFormGetCollection',
            '_IEFormGetObjByName', '_IEFormImageClick', '_IEFormReset',
            '_IEFormSubmit', '_IEFrameGetCollection', '_IEFrameGetObjByName',
            '_IEGetObjById', '_IEGetObjByName', '_IEHeadInsertEventScript',
            '_IEImgClick', '_IEImgGetCollection', '_IEIsFrameSet',
            '_IELinkClickByIndex', '_IELinkClickByText', '_IELinkGetCollection',
            '_IELoadWait', '_IELoadWaitTimeout', '_IENavigate',
            '_IEPropertyGet', '_IEPropertySet', '_IEQuit',
            '_IETableGetCollection', '_IETableWriteToArray', '_IETagNameAllGetCollection',
            '_IETagNameGetCollection', '_Iif', '_INetExplorerCapable',
            '_INetGetSource', '_INetMail', '_INetSmtpMail',
            '_IsPressed', '_MathCheckDiv', '_Max',
            '_MemGlobalAlloc', '_MemGlobalFree', '_MemGlobalLock',
            '_MemGlobalSize', '_MemGlobalUnlock', '_MemMoveMemory',
            '_MemMsgBox', '_MemShowError', '_MemVirtualAlloc',
            '_MemVirtualAllocEx', '_MemVirtualFree', '_MemVirtualFreeEx',
            '_Min', '_MouseTrap', '_NamedPipes_CallNamedPipe',
            '_NamedPipes_ConnectNamedPipe', '_NamedPipes_CreateNamedPipe', '_NamedPipes_CreatePipe',
            '_NamedPipes_DisconnectNamedPipe', '_NamedPipes_GetNamedPipeHandleState', '_NamedPipes_GetNamedPipeInfo',
            '_NamedPipes_PeekNamedPipe', '_NamedPipes_SetNamedPipeHandleState', '_NamedPipes_TransactNamedPipe',
            '_NamedPipes_WaitNamedPipe', '_Net_Share_ConnectionEnum', '_Net_Share_FileClose',
            '_Net_Share_FileEnum', '_Net_Share_FileGetInfo', '_Net_Share_PermStr',
            '_Net_Share_ResourceStr', '_Net_Share_SessionDel', '_Net_Share_SessionEnum',
            '_Net_Share_SessionGetInfo', '_Net_Share_ShareAdd', '_Net_Share_ShareCheck',
            '_Net_Share_ShareDel', '_Net_Share_ShareEnum', '_Net_Share_ShareGetInfo',
            '_Net_Share_ShareSetInfo', '_Net_Share_StatisticsGetSvr', '_Net_Share_StatisticsGetWrk',
            '_Now', '_NowCalc', '_NowCalcDate',
            '_NowDate', '_NowTime', '_PathFull',
            '_PathMake', '_PathSplit', '_ProcessGetName',
            '_ProcessGetPriority', '_Radian', '_ReplaceStringInFile',
            '_RunDOS', '_ScreenCapture_Capture', '_ScreenCapture_CaptureWnd',
            '_ScreenCapture_SaveImage', '_ScreenCapture_SetBMPFormat', '_ScreenCapture_SetJPGQuality',
            '_ScreenCapture_SetTIFColorDepth', '_ScreenCapture_SetTIFCompression', '_Security__AdjustTokenPrivileges',
            '_Security__GetAccountSid', '_Security__GetLengthSid', '_Security__GetTokenInformation',
            '_Security__ImpersonateSelf', '_Security__IsValidSid', '_Security__LookupAccountName',
            '_Security__LookupAccountSid', '_Security__LookupPrivilegeValue', '_Security__OpenProcessToken',
            '_Security__OpenThreadToken', '_Security__OpenThreadTokenEx', '_Security__SetPrivilege',
            '_Security__SidToStringSid', '_Security__SidTypeStr', '_Security__StringSidToSid',
            '_SendMessage', '_SendMessageA', '_SetDate',
            '_SetTime', '_Singleton', '_SoundClose',
            '_SoundLength', '_SoundOpen', '_SoundPause',
            '_SoundPlay', '_SoundPos', '_SoundResume',
            '_SoundSeek', '_SoundStatus', '_SoundStop',
            '_SQLite_Changes', '_SQLite_Close', '_SQLite_Display2DResult',
            '_SQLite_Encode', '_SQLite_ErrCode', '_SQLite_ErrMsg',
            '_SQLite_Escape', '_SQLite_Exec', '_SQLite_FetchData',
            '_SQLite_FetchNames', '_SQLite_GetTable', '_SQLite_GetTable2d',
            '_SQLite_LastInsertRowID', '_SQLite_LibVersion', '_SQLite_Open',
            '_SQLite_Query', '_SQLite_QueryFinalize', '_SQLite_QueryReset',
            '_SQLite_QuerySingleRow', '_SQLite_SaveMode', '_SQLite_SetTimeout',
            '_SQLite_Shutdown', '_SQLite_SQLiteExe', '_SQLite_Startup',
            '_SQLite_TotalChanges', '_StringAddComma', '_StringBetween',
            '_StringEncrypt', '_StringInsert', '_StringProper',
            '_StringRepeat', '_StringReverse', '_StringSplit',
            '_StringToHex', '_TCPIpToName', '_TempFile',
            '_TicksToTime', '_Timer_Diff', '_Timer_GetTimerID',
            '_Timer_Init', '_Timer_KillAllTimers', '_Timer_KillTimer',
            '_Timer_SetTimer', '_TimeToTicks', '_VersionCompare',
            '_viClose', '_viExecCommand', '_viFindGpib',
            '_viGpibBusReset', '_viGTL', '_viOpen',
            '_viSetAttribute', '_viSetTimeout', '_WeekNumberISO',
            '_WinAPI_AttachConsole', '_WinAPI_AttachThreadInput', '_WinAPI_Beep',
            '_WinAPI_BitBlt', '_WinAPI_CallNextHookEx', '_WinAPI_Check',
            '_WinAPI_ClientToScreen', '_WinAPI_CloseHandle', '_WinAPI_CommDlgExtendedError',
            '_WinAPI_CopyIcon', '_WinAPI_CreateBitmap', '_WinAPI_CreateCompatibleBitmap',
            '_WinAPI_CreateCompatibleDC', '_WinAPI_CreateEvent', '_WinAPI_CreateFile',
            '_WinAPI_CreateFont', '_WinAPI_CreateFontIndirect', '_WinAPI_CreateProcess',
            '_WinAPI_CreateSolidBitmap', '_WinAPI_CreateSolidBrush', '_WinAPI_CreateWindowEx',
            '_WinAPI_DefWindowProc', '_WinAPI_DeleteDC', '_WinAPI_DeleteObject',
            '_WinAPI_DestroyIcon', '_WinAPI_DestroyWindow', '_WinAPI_DrawEdge',
            '_WinAPI_DrawFrameControl', '_WinAPI_DrawIcon', '_WinAPI_DrawIconEx',
            '_WinAPI_DrawText', '_WinAPI_EnableWindow', '_WinAPI_EnumDisplayDevices',
            '_WinAPI_EnumWindows', '_WinAPI_EnumWindowsPopup', '_WinAPI_EnumWindowsTop',
            '_WinAPI_ExpandEnvironmentStrings', '_WinAPI_ExtractIconEx', '_WinAPI_FatalAppExit',
            '_WinAPI_FillRect', '_WinAPI_FindExecutable', '_WinAPI_FindWindow',
            '_WinAPI_FlashWindow', '_WinAPI_FlashWindowEx', '_WinAPI_FloatToInt',
            '_WinAPI_FlushFileBuffers', '_WinAPI_FormatMessage', '_WinAPI_FrameRect',
            '_WinAPI_FreeLibrary', '_WinAPI_GetAncestor', '_WinAPI_GetAsyncKeyState',
            '_WinAPI_GetClassName', '_WinAPI_GetClientHeight', '_WinAPI_GetClientRect',
            '_WinAPI_GetClientWidth', '_WinAPI_GetCurrentProcess', '_WinAPI_GetCurrentProcessID',
            '_WinAPI_GetCurrentThread', '_WinAPI_GetCurrentThreadId', '_WinAPI_GetCursorInfo',
            '_WinAPI_GetDC', '_WinAPI_GetDesktopWindow', '_WinAPI_GetDeviceCaps',
            '_WinAPI_GetDIBits', '_WinAPI_GetDlgCtrlID', '_WinAPI_GetDlgItem',
            '_WinAPI_GetFileSizeEx', '_WinAPI_GetFocus', '_WinAPI_GetForegroundWindow',
            '_WinAPI_GetIconInfo', '_WinAPI_GetLastError', '_WinAPI_GetLastErrorMessage',
            '_WinAPI_GetModuleHandle', '_WinAPI_GetMousePos', '_WinAPI_GetMousePosX',
            '_WinAPI_GetMousePosY', '_WinAPI_GetObject', '_WinAPI_GetOpenFileName',
            '_WinAPI_GetOverlappedResult', '_WinAPI_GetParent', '_WinAPI_GetProcessAffinityMask',
            '_WinAPI_GetSaveFileName', '_WinAPI_GetStdHandle', '_WinAPI_GetStockObject',
            '_WinAPI_GetSysColor', '_WinAPI_GetSysColorBrush', '_WinAPI_GetSystemMetrics',
            '_WinAPI_GetTextExtentPoint32', '_WinAPI_GetWindow', '_WinAPI_GetWindowDC',
            '_WinAPI_GetWindowHeight', '_WinAPI_GetWindowLong', '_WinAPI_GetWindowRect',
            '_WinAPI_GetWindowText', '_WinAPI_GetWindowThreadProcessId', '_WinAPI_GetWindowWidth',
            '_WinAPI_GetXYFromPoint', '_WinAPI_GlobalMemStatus', '_WinAPI_GUIDFromString',
            '_WinAPI_GUIDFromStringEx', '_WinAPI_HiWord', '_WinAPI_InProcess',
            '_WinAPI_IntToFloat', '_WinAPI_InvalidateRect', '_WinAPI_IsClassName',
            '_WinAPI_IsWindow', '_WinAPI_IsWindowVisible', '_WinAPI_LoadBitmap',
            '_WinAPI_LoadImage', '_WinAPI_LoadLibrary', '_WinAPI_LoadLibraryEx',
            '_WinAPI_LoadShell32Icon', '_WinAPI_LoadString', '_WinAPI_LocalFree',
            '_WinAPI_LoWord', '_WinAPI_MakeDWord', '_WinAPI_MAKELANGID',
            '_WinAPI_MAKELCID', '_WinAPI_MakeLong', '_WinAPI_MessageBeep',
            '_WinAPI_Mouse_Event', '_WinAPI_MoveWindow', '_WinAPI_MsgBox',
            '_WinAPI_MulDiv', '_WinAPI_MultiByteToWideChar', '_WinAPI_MultiByteToWideCharEx',
            '_WinAPI_OpenProcess', '_WinAPI_PointFromRect', '_WinAPI_PostMessage',
            '_WinAPI_PrimaryLangId', '_WinAPI_PtInRect', '_WinAPI_ReadFile',
            '_WinAPI_ReadProcessMemory', '_WinAPI_RectIsEmpty', '_WinAPI_RedrawWindow',
            '_WinAPI_RegisterWindowMessage', '_WinAPI_ReleaseCapture', '_WinAPI_ReleaseDC',
            '_WinAPI_ScreenToClient', '_WinAPI_SelectObject', '_WinAPI_SetBkColor',
            '_WinAPI_SetCapture', '_WinAPI_SetCursor', '_WinAPI_SetDefaultPrinter',
            '_WinAPI_SetDIBits', '_WinAPI_SetEvent', '_WinAPI_SetFocus',
            '_WinAPI_SetFont', '_WinAPI_SetHandleInformation', '_WinAPI_SetLastError',
            '_WinAPI_SetParent', '_WinAPI_SetProcessAffinityMask', '_WinAPI_SetSysColors',
            '_WinAPI_SetTextColor', '_WinAPI_SetWindowLong', '_WinAPI_SetWindowPos',
            '_WinAPI_SetWindowsHookEx', '_WinAPI_SetWindowText', '_WinAPI_ShowCursor',
            '_WinAPI_ShowError', '_WinAPI_ShowMsg', '_WinAPI_ShowWindow',
            '_WinAPI_StringFromGUID', '_WinAPI_SubLangId', '_WinAPI_SystemParametersInfo',
            '_WinAPI_TwipsPerPixelX', '_WinAPI_TwipsPerPixelY', '_WinAPI_UnhookWindowsHookEx',
            '_WinAPI_UpdateLayeredWindow', '_WinAPI_UpdateWindow', '_WinAPI_ValidateClassName',
            '_WinAPI_WaitForInputIdle', '_WinAPI_WaitForMultipleObjects', '_WinAPI_WaitForSingleObject',
            '_WinAPI_WideCharToMultiByte', '_WinAPI_WindowFromPoint', '_WinAPI_WriteConsole',
            '_WinAPI_WriteFile', '_WinAPI_WriteProcessMemory', '_WinNet_AddConnection',
            '_WinNet_AddConnection2', '_WinNet_AddConnection3', '_WinNet_CancelConnection',
            '_WinNet_CancelConnection2', '_WinNet_CloseEnum', '_WinNet_ConnectionDialog',
            '_WinNet_ConnectionDialog1', '_WinNet_DisconnectDialog', '_WinNet_DisconnectDialog1',
            '_WinNet_EnumResource', '_WinNet_GetConnection', '_WinNet_GetConnectionPerformance',
            '_WinNet_GetLastError', '_WinNet_GetNetworkInformation', '_WinNet_GetProviderName',
            '_WinNet_GetResourceInformation', '_WinNet_GetResourceParent', '_WinNet_GetUniversalName',
            '_WinNet_GetUser', '_WinNet_OpenEnum', '_WinNet_RestoreConnection',
            '_WinNet_UseConnection', '_Word_VersionInfo', '_WordAttach',
            '_WordCreate', '_WordDocAdd', '_WordDocAddLink',
            '_WordDocAddPicture', '_WordDocClose', '_WordDocFindReplace',
            '_WordDocGetCollection', '_WordDocLinkGetCollection', '_WordDocOpen',
            '_WordDocPrint', '_WordDocPropertyGet', '_WordDocPropertySet',
            '_WordDocSave', '_WordDocSaveAs', '_WordErrorHandlerDeRegister',
            '_WordErrorHandlerRegister', '_WordErrorNotify', '_WordMacroRun',
            '_WordPropertyGet', '_WordPropertySet', '_WordQuit'
            ),
        5 => array(
            '#ce', '#comments-end', '#comments-start',
            '#cs', '#include', '#include-once',
            '#NoTrayIcon', '#RequireAdmin'
            ),
        6 => array(
            '#AutoIt3Wrapper_Au3Check_Parameters', '#AutoIt3Wrapper_Au3Check_Stop_OnWarning', '#AutoIt3Wrapper_Change2CUI',
            '#AutoIt3Wrapper_Compression', '#AutoIt3Wrapper_cvsWrapper_Parameters', '#AutoIt3Wrapper_Icon',
            '#AutoIt3Wrapper_Outfile', '#AutoIt3Wrapper_Outfile_Type', '#AutoIt3Wrapper_Plugin_Funcs',
            '#AutoIt3Wrapper_Res_Comment', '#AutoIt3Wrapper_Res_Description', '#AutoIt3Wrapper_Res_Field',
            '#AutoIt3Wrapper_Res_File_Add', '#AutoIt3Wrapper_Res_Fileversion', '#AutoIt3Wrapper_Res_FileVersion_AutoIncrement',
            '#AutoIt3Wrapper_Res_Icon_Add', '#AutoIt3Wrapper_Res_Language', '#AutoIt3Wrapper_Res_LegalCopyright',
            '#AutoIt3Wrapper_res_requestedExecutionLevel', '#AutoIt3Wrapper_Res_SaveSource', '#AutoIt3Wrapper_Run_After',
            '#AutoIt3Wrapper_Run_Au3check', '#AutoIt3Wrapper_Run_Before', '#AutoIt3Wrapper_Run_cvsWrapper',
            '#AutoIt3Wrapper_Run_Debug_Mode', '#AutoIt3Wrapper_Run_Obfuscator', '#AutoIt3Wrapper_Run_Tidy',
            '#AutoIt3Wrapper_Tidy_Stop_OnError', '#AutoIt3Wrapper_UseAnsi', '#AutoIt3Wrapper_UseUpx',
            '#AutoIt3Wrapper_UseX64', '#AutoIt3Wrapper_Version', '#EndRegion',
            '#forceref', '#Obfuscator_Ignore_Funcs', '#Obfuscator_Ignore_Variables',
            '#Obfuscator_Parameters', '#Region', '#Tidy_Parameters'
            )
        ),
    'SYMBOLS' => array(
        '(', ')', '[', ']',
        '+', '-', '*', '/', '&', '^',
        '=', '+=', '-=', '*=', '/=', '&=',
        '==', '<', '<=', '>', '>=',
        ',', '.'
        ),
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        1 => false,
        2 => false,
        3 => false,
        4 => false,
        5 => false,
        6 => false
        ),
    'STYLES' => array(
        'KEYWORDS' => array(
            1 => 'color: #0000FF; font-weight: bold;',
            2 => 'color: #800000; font-weight: bold;',
            3 => 'color: #000080; font-style: italic; font-weight: bold;',
            4 => 'color: #0080FF; font-style: italic; font-weight: bold;',
            5 => 'color: #F000FF; font-style: italic;',
            6 => 'color: #A00FF0; font-style: italic;'
            ),
        'COMMENTS' => array(
            0 => 'font-style: italic; color: #009933;',
            'MULTI' => 'font-style: italic; color: #669900;'
            ),
        'ESCAPE_CHAR' => array(
            0 => ''
            ),
        'BRACKETS' => array(
            0 => 'color: #FF0000; font-weight: bold;'
            ),
        'STRINGS' => array(
            0 => 'font-weight: bold; color: #008080;'
            ),
        'NUMBERS' => array(
            0 => 'color: #AC00A9; font-style: italic; font-weight: bold;'
            ),
        'METHODS' => array(
            1 => 'color: #0000FF; font-style: italic; font-weight: bold;'
            ),
        'SYMBOLS' => array(
            0 => 'color: #FF0000; font-weight: bold;'
            ),
        'REGEXPS' => array(
            0 => 'font-weight: bold; color: #AA0000;'
            ),
        'SCRIPT' => array(
            )
        ),
    'URLS' => array(
        1 => 'http://www.autoitscript.com/autoit3/docs/keywords.htm',
        2 => 'http://www.autoitscript.com/autoit3/docs/macros.htm',
        3 => 'http://www.autoitscript.com/autoit3/docs/functions/{FNAME}.htm',
        4 => '',
        5 => '',
        6 => ''
        ),
    'OOLANG' => true,
    'OBJECT_SPLITTERS' => array(
        1 => '.'
        ),
    'REGEXPS' => array(
        //Variables
        0 => '[\\$%@]+[a-zA-Z_][a-zA-Z0-9_]*'
        ),
    'STRICT_MODE_APPLIES' => GESHI_MAYBE,
    'SCRIPT_DELIMITERS' => array(
        ),
    'HIGHLIGHT_STRICT_BLOCK' => array(
        0 => true,
        1 => true,
        2 => true,
        3 => true
        )
);

?>
