/*
    beer.c - Frontend for SAFT for X11
    Copyright (c) 1999  Martin Schulze <joey@infodrom.north.de>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#include <getopt.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include "main.h"
#include "nls.h"
#include "config.h"
#include "beer.h"

char progname[] = "Gerstensaft";
char version[] = "pre0.1";

struct s_conf config = { NULL };

int beer_exitcode = EXIT_OK;

static struct option long_options[] =
{
  {"help", no_argument, 0, 'h'},
  {0, 0, 0, 0}
};

void read_config ()
{
  char fname[1024];
  char buf[1024];
  char *cp, *xp;
  FILE *f;

  config.addrs = NULL; 
  snprintf(fname,sizeof(fname),"%s/.gerstensaft/history",getenv("HOME"));
  if ((f=fopen (fname,"r")) != NULL) {
    for (cp = fgets(buf, sizeof(buf)-1, f); cp != NULL;
	 cp = fgets(buf, sizeof(buf)-1, f) ) {
      if (strlen(buf) && !strncasecmp(buf, "Recipient ", 10)) {
	if (buf[strlen(buf)-1] == '\n')
	  buf[strlen(buf)-1] = '\0';
	cp += 10;
	xp = (char *)malloc (strlen(cp)+1);
	sprintf (xp, cp);
	config.addrs = g_list_insert_sorted (config.addrs, xp, (GCompareFunc)strcmp);
      }
      /* throw away superflous stuff */
      if (strlen(buf) == sizeof(buf)-1 && buf[sizeof(buf)-1] != '\n') {
	for (cp = fgets(buf, sizeof(buf)-1, f); cp != NULL && buf[strlen(buf)-1] != '\n';
	     cp = fgets(buf, sizeof(buf)-1, f) );
      }

    }
  fclose (f);
  }
}
extern int errno;
void write_history()
{
  char fname[1024];
  int i;
  FILE *f;

  if (!getenv("HOME"))
    return;

  snprintf(fname,sizeof(fname),"%s/.gerstensaft",getenv("HOME"));
  if (!is_dir (fname, NULL))
    mkdir (fname, 0700);

  snprintf(fname,sizeof(fname),"%s/.gerstensaft/history",getenv("HOME"));
  if (!g_list_length (config.addrs)) {
    unlink (fname);
    return;
  }

  if ((f=fopen (fname,"w")) != NULL) {
    for (i=0;i<g_list_length (config.addrs); i++)
      fprintf (f, "Recipient %s\n", (char *)g_list_nth (config.addrs, i)->data);
    fclose (f);
  }
}

void config_clear_history ()
{
  GList *elem;

  while (g_list_length (config.addrs)) {
    elem = g_list_nth (config.addrs, 0);
    free (elem->data);
    config.addrs = g_list_remove_link (config.addrs, elem);
    g_list_free (elem);
  }
  g_list_free (config.addrs);

  config.addrs = NULL;
}

void usage()
{
  printf ("%s %s\n", progname, version);
}

int main (int argc, char *argv[])
{
  char c;
  int longindex;

  bindtextdomain ("gerstensaft", LOCALE_DIR);
  textdomain ("gerstensaft");

  /* Pass arguments to GTK
   * --display
   * --debug-level
   * --no-xshm
   * --sync
   * --show-events
   * --no-show-events
   * --name
   * --class
   */
  gtk_init (&argc, &argv);

    optind = 0;
    while ( (c = getopt_long(argc, argv, "hv", long_options, &longindex)) != -1 ) {
      switch (c) {
      case 'h':
	usage();
	exit (beer_exitcode);
      case 'v':
	printf ("%s %s\n", progname, version);
	exit (beer_exitcode);
      } /* switch */
    } /* while */

    read_config ();

    main_window();
    gtk_main();

#ifdef DEBUG
    for (longindex=0;longindex<g_list_length (config.addrs); longindex++) {
      printf ("%d: %s\n", longindex, (char *)g_list_nth (config.addrs, longindex)->data);
    }
#endif

    write_history();
    config_clear_history();

#ifdef DEBUG
  printf ("return %d\n", beer_exitcode);
#endif

  return beer_exitcode;
}
