/*
 * 2006-11-11 -	Handy (?) module to help keep track of strings in UTF-8 ("display",
 *		the one used internally by GLib/GTK+) and whatever the local file-
 *		system uses. It's just a context, to help simplify the code. Should
 *		also handle the case when the external and internal representations
 *		are the same, which can happen.
*/

#if !defined CONVUTIL_H
#define	CONVUTIL_H

#include <glib.h>

/* These are here only so it can be conveniently put on the stack. Do not meddle with
 * these fields directly, because they are subtle and quick to corrupt filenames.
*/
typedef struct {
	const gchar	*in;
	gchar		*out;
} CItem;

typedef struct {
	CItem	item0;
	GSList	*items;
	gsize	size;
} Conv;

/* Initialize Conv to empty state. If you are going to immediately be using it, conv_begin()
 * is the way to go.
*/
extern void	conv_init(Conv *v);

/* Begin using a Conv, by adding the display (UTF-8) version of a string. Returns the string
 * converted to filesystem encoding, and stores the pair for later reference.
*/
extern gchar *	conv_begin(Conv *c, const gchar *display);

extern gchar *	conv_begin_reverse(Conv *c, const gchar *disk);

/* Adds another string, in display (UTF-8) format, and returns the filesystem version. */
extern gchar *	conv_add(Conv *c, const gchar *display);

/* Adds a string in filesystem encoding, and returns it in display encoding. */
extern gchar *	conv_add_reverse(Conv *, const gchar *disk);

/* Changes the string at the given index. If the index is out of bounds, does nothing. */
extern gchar *	conv_set(Conv *c, guint index, const gchar *display);

/* Returns the filesystem encoding version of a previously added string. */
extern gchar *	conv_get(const Conv *c, guint index);

/* Ends use of a Conv, freeing all the added strings. */
extern void	conv_end(Conv *c);

#endif		/* CONVUTIL_H */
