static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * This operation is a port of the Darktable Shadows Highlights filter        \n"
" * copyright (c) 2012--2015 Ulrich Pegelow.                                   \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (shadows, _(\"Shadows\"), 50.0)                               \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (highlights, _(\"Highlights\"), -50.0)                        \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (whitepoint, _(\"White point adjustment\"), 0.0)              \n"
"    value_range (-10.0, 10.0)                                                 \n"
"                                                                              \n"
"property_double (compress, _(\"Compress\"), 50.0)                             \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (shadows_ccorrect, _(\"Shadows color adjustment\"), 100.0)    \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (highlights_ccorrect, _(\"Highlights color adjustment\"), 50.0)\n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_COMPOSER                                                \n"
"#define GEGL_OP_NAME     shadows_highlights_correction                        \n"
"#define GEGL_OP_C_SOURCE shadows-highlights-correction.c                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include \"gegl-debug.h\"                                                     \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define SIGN(x) (((x) < 0) ? -1.f : 1.f)                                      \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *laba = babl_format (\"CIE Lab alpha float\");                   \n"
"  const Babl *lab  = babl_format (\"CIE Lab float\");                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  laba);                    \n"
"  gegl_operation_set_format (operation, \"aux\",    lab);                     \n"
"  gegl_operation_set_format (operation, \"output\", laba);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *aux_buf,                                        \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gfloat *src  = in_buf;                                                      \n"
"  gfloat *dst  = out_buf;                                                     \n"
"  gfloat *aux  = aux_buf;                                                     \n"
"                                                                              \n"
"  gfloat shadows    = 2.f * fminf (fmaxf (-1.0, (o->shadows / 100.f)), 1.f);  \n"
"  gfloat highlights = 2.f * fminf (fmaxf (-1.0, (o->highlights / 100.f)), 1.f);\n"
"  gfloat whitepoint = fmaxf (1.f - o->whitepoint / 100.f, 0.01f);             \n"
"  gfloat compress   = fminf (fmaxf (0, (o->compress / 100.f)), 0.99f);        \n"
"                                                                              \n"
"  gfloat shadows_ccorrect = (fminf (fmaxf (0.0f, (o->shadows_ccorrect / 100.f)), 1.f) - 0.5f)\n"
"                             * SIGN(shadows) + 0.5f;                          \n"
"                                                                              \n"
"  gfloat highlights_ccorrect = (fminf (fmaxf (0.0f, (o->highlights_ccorrect / 100.f)), 1.f) - 0.5f)\n"
"                                * SIGN(-highlights) + 0.5f;                   \n"
"                                                                              \n"
"  gfloat max[4] = { 1.0f, 1.0f, 1.0f, 1.0f };                                 \n"
"  gfloat min[4] = { 0.0f, -1.0f, -1.0f, 0.0f };                               \n"
"  gfloat lmin = 0.0f;                                                         \n"
"  gfloat lmax = max[0] + fabs(min[0]);                                        \n"
"  gfloat halfmax = lmax / 2.0;                                                \n"
"  gfloat doublemax = lmax * 2.0;                                              \n"
"  gfloat low_approximation = 0.01f;                                           \n"
"                                                                              \n"
"  if (!aux)                                                                   \n"
"    {                                                                         \n"
"      memcpy (out_buf, in_buf, sizeof (gfloat) * 4 * n_pixels);               \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      gfloat ta[3];                                                           \n"
"      gfloat tb[3];                                                           \n"
"      gfloat highlights2;                                                     \n"
"      gfloat highlights_xform;                                                \n"
"      gfloat shadows2;                                                        \n"
"      gfloat shadows_xform;                                                   \n"
"                                                                              \n"
"      ta[0] = src[0] / 100.f;                                                 \n"
"      ta[1] = src[1] / 128.f;                                                 \n"
"      ta[2] = src[2] / 128.f;                                                 \n"
"                                                                              \n"
"      tb[0] = (100.f - aux[0]) / 100.f;                                       \n"
"      tb[1] = 0.f;                                                            \n"
"      tb[2] = 0.f;                                                            \n"
"                                                                              \n"
"      ta[0] = ta[0] > 0.0f ? ta[0] / whitepoint : ta[0];                      \n"
"      tb[0] = tb[0] > 0.0f ? tb[0] / whitepoint : tb[0];                      \n"
"                                                                              \n"
"      highlights2 = highlights * highlights;                                  \n"
"      highlights_xform = CLAMP(1.0f - tb[0] / (1.0f - compress), 0.0f, 1.0f); \n"
"                                                                              \n"
"      while (highlights2 > 0.0f)                                              \n"
"        {                                                                     \n"
"          gfloat lref, href;                                                  \n"
"          gfloat chunk, optrans;                                              \n"
"                                                                              \n"
"          gfloat la = ta[0];                                                  \n"
"          gfloat lb = (tb[0] - halfmax) * SIGN(-highlights) * SIGN(lmax - la) + halfmax;\n"
"          lb = CLAMP(lb, lmin, lmax);                                         \n"
"          lref = copysignf(fabs(la) > low_approximation ? 1.0f / fabs(la) : 1.0f / low_approximation, la);\n"
"          href = copysignf(                                                   \n"
"              fabs(1.0f - la) > low_approximation ? 1.0f / fabs(1.0f - la) : 1.0f / low_approximation, 1.0f - la);\n"
"                                                                              \n"
"          chunk = highlights2 > 1.0f ? 1.0f : highlights2;                    \n"
"          optrans = chunk * highlights_xform;                                 \n"
"          highlights2 -= 1.0f;                                                \n"
"                                                                              \n"
"          ta[0] = la * (1.0 - optrans)                                        \n"
"                  + (la > halfmax ? lmax - (lmax - doublemax * (la - halfmax)) * (lmax - lb) : doublemax * la\n"
"                                                                                               * lb) * optrans;\n"
"                                                                              \n"
"          ta[1] = ta[1] * (1.0f - optrans)                                    \n"
"                  + (ta[1] + tb[1]) * (ta[0] * lref * (1.0f - highlights_ccorrect)\n"
"                                       + (1.0f - ta[0]) * href * highlights_ccorrect) * optrans;\n"
"                                                                              \n"
"          ta[2] = ta[2] * (1.0f - optrans)                                    \n"
"                  + (ta[2] + tb[2]) * (ta[0] * lref * (1.0f - highlights_ccorrect)\n"
"                                       + (1.0f - ta[0]) * href * highlights_ccorrect) * optrans;\n"
"        }                                                                     \n"
"                                                                              \n"
"    shadows2 = shadows * shadows;                                             \n"
"    shadows_xform = CLAMP(tb[0] / (1.0f - compress) - compress / (1.0f - compress), 0.0f, 1.0f);\n"
"                                                                              \n"
"    while (shadows2 > 0.0f)                                                   \n"
"      {                                                                       \n"
"        gfloat lref, href;                                                    \n"
"        gfloat chunk, optrans;                                                \n"
"                                                                              \n"
"        gfloat la = ta[0];                                                    \n"
"        gfloat lb = (tb[0] - halfmax) * SIGN(shadows) * SIGN(lmax - la) + halfmax;\n"
"        lref = copysignf(fabs(la) > low_approximation ? 1.0f / fabs(la) : 1.0f / low_approximation, la);\n"
"        href = copysignf(                                                     \n"
"            fabs(1.0f - la) > low_approximation ? 1.0f / fabs(1.0f - la) : 1.0f / low_approximation, 1.0f - la);\n"
"                                                                              \n"
"        chunk = shadows2 > 1.0f ? 1.0f : shadows2;                            \n"
"        optrans = chunk * shadows_xform;                                      \n"
"        shadows2 -= 1.0f;                                                     \n"
"                                                                              \n"
"        ta[0] = la * (1.0 - optrans)                                          \n"
"                + (la > halfmax ? lmax - (lmax - doublemax * (la - halfmax)) * (lmax - lb) : doublemax * la\n"
"                                                                                             * lb) * optrans;\n"
"                                                                              \n"
"        ta[1] = ta[1] * (1.0f - optrans)                                      \n"
"                + (ta[1] + tb[1]) * (ta[0] * lref * shadows_ccorrect          \n"
"                                     + (1.0f - ta[0]) * href * (1.0f - shadows_ccorrect)) * optrans;\n"
"                                                                              \n"
"        ta[2] = ta[2] * (1.0f - optrans)                                      \n"
"                + (ta[2] + tb[2]) * (ta[0] * lref * shadows_ccorrect          \n"
"                                     + (1.0f - ta[0]) * href * (1.0f - shadows_ccorrect)) * optrans;\n"
"      }                                                                       \n"
"                                                                              \n"
"      dst[0] = ta[0] * 100.f;                                                 \n"
"      dst[1] = ta[1] * 128.f;                                                 \n"
"      dst[2] = ta[2] * 128.f;                                                 \n"
"      dst[3] = src[3];                                                        \n"
"                                                                              \n"
"      src += 4;                                                               \n"
"      dst += 4;                                                               \n"
"      aux += 3;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"/*                                                                            \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"#include \"opencl/shadows-highlights-correction.cl.h\"                        \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               aux_tex,                                     \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  gfloat shadows    = 2.f * fminf (fmaxf (-1.0, (o->shadows / 100.f)), 1.f);  \n"
"  gfloat highlights = 2.f * fminf (fmaxf (-1.0, (o->highlights / 100.f)), 1.f);\n"
"  gfloat whitepoint = fmaxf (1.f - o->whitepoint / 100.f, 0.01f);             \n"
"  gfloat compress   = fminf (fmaxf (0, (o->compress / 100.f)), 0.99f);        \n"
"                                                                              \n"
"  gfloat shadows_ccorrect = (fminf (fmaxf (0.0f, (o->shadows_ccorrect / 100.f)), 1.f) - 0.5f)\n"
"                             * SIGN(shadows) + 0.5f;                          \n"
"                                                                              \n"
"  gfloat highlights_ccorrect = (fminf (fmaxf (0.0f, (o->highlights_ccorrect / 100.f)), 1.f) - 0.5f)\n"
"                                * SIGN(-highlights) + 0.5f;                   \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"shadows_highlights\", NULL};             \n"
"      cl_data = gegl_cl_compile_and_build (shadows_highlights_correction_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (aux_tex)? (void*)&aux_tex : NULL);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&shadows);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float), (void*)&highlights);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_float), (void*)&compress);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 6, sizeof(cl_float), (void*)&shadows_ccorrect);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 7, sizeof(cl_float), (void*)&highlights_ccorrect);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 8, sizeof(cl_float), (void*)&whitepoint);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"*/                                                                            \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *self)                                        \n"
"{                                                                             \n"
"  GeglRectangle  result  = { 0, 0, 0, 0 };                                    \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (self, \"input\");\n"
"                                                                              \n"
"  if (! in_rect)                                                              \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass              *operation_class;                           \n"
"  GeglOperationPointComposerClass *point_composer_class;                      \n"
"                                                                              \n"
"  operation_class      = GEGL_OPERATION_CLASS (klass);                        \n"
"  point_composer_class = GEGL_OPERATION_POINT_COMPOSER_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"                                                                              \n"
"  point_composer_class->process     = process;                                \n"
"                                                                              \n"
"  /*                                                                          \n"
"  point_composer_class->cl_process  = cl_process;                             \n"
"  operation_class->opencl_support   = TRUE;                                   \n"
"   */                                                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:shadows-highlights-correction\",                  \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Lighten shadows and darken highlights\"),            \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
