static const char* newsprint_cl_source =
"float cosf(a)                                                                 \n"
"{                                                                             \n"
"  return 1.0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"float sinf(a)                                                                 \n"
"{                                                                             \n"
"  return 0.0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"float fabsf(a)                                                                \n"
"{                                                                             \n"
"  return abs(a);                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"float fmodf(a,b)                                                              \n"
"{                                                                             \n"
"  return x - y * floor(x/y);                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"float spachromyze (                                                           \n"
"    float x,                                                                  \n"
"    float y,                                                                  \n"
"    float l,                                                                  \n"
"    float c,                                                                  \n"
"    float h,                                                                  \n"
"    int   pattern,                                                            \n"
"    float wavelength,                                                         \n"
"    float turbulence,                                                         \n"
"    float blocksize,                                                          \n"
"    float angleboost,                                                         \n"
"    float twist)                                                              \n"
"{                                                                             \n"
"  float aa  = 4.0;                                                            \n"
"  float acc = 0.0;                                                            \n"
"  float luminance  = l;                                                       \n"
"  float chroma     = c;                                                       \n"
"  float hue        = h;                                                       \n"
"                                                                              \n"
"  float part_white = luminance;                                               \n"
"  float offset     = chroma;                                                  \n"
"  float angle      = (1.0-(hue * angleboost) + twist);                        \n"
"                                                                              \n"
"  float width      = (wavelength * (1.0 - turbulence) +                       \n"
"                     (wavelength * offset) * turbulence);                     \n"
"                                                                              \n"
"  float vec0 = cosf (-angle * 3.14151 / 2.0);                                 \n"
"  float vec1 = sinf (-angle * 3.14151 / 2.0);                                 \n"
"  float aa_sq = aa * aa;                                                      \n"
"                                                                              \n"
"  for (float xi = 0.0; xi < 4.0; xi += 1.0)                                   \n"
"  {                                                                           \n"
"    float u = fmodf (x + xi/aa + 0.5 * width, blocksize * width);             \n"
"    for (float yi = 0.0; yi < 4.0; yi += 1.0)                                 \n"
"    {                                                                         \n"
"      float v = fmodf (y + yi/aa + 0.5 * width, blocksize * width);           \n"
"      float w = vec0 * u + vec1 * v;                                          \n"
"      float q = vec1 * u - vec0 * v;                                          \n"
"                                                                              \n"
"      float wperiod = fmodf (w, width);                                       \n"
"      float wphase  = (wperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      float qperiod = fmodf (q, width);                                       \n"
"      float qphase  = (qperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      if (pattern == 0) {      /* line */                                     \n"
"        if (fabsf (wphase) < part_white)                                      \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 1) { /* dot */                                      \n"
"        if (qphase * qphase + wphase * wphase <                               \n"
"          part_white * part_white * 2.0)                                      \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 2) { /* diamond */                                  \n"
"        if (fabsf(wphase) + fabsf(qphase) < (part_white*2.0) )                \n"
"          acc += 1.0 / aa_sq;                                                 \n"
"      }                                                                       \n"
"      else if (pattern == 3) { /* dot-to-diamond-to-dot */                    \n"
"          float ax = fabsf (wphase / 2.0) ;                                   \n"
"          float ay = fabsf (qphase / 2.0) ;                                   \n"
"          float v = 0.0;                                                      \n"
"                                                                              \n"
"          if  (ax + ay > 1.0)                                                 \n"
"          {                                                                   \n"
"            v = 2.0-((ay - 1.0) * (ay - 1.0) + (ax - 1.0) * (ax - 1.0));      \n"
"          }                                                                   \n"
"          else                                                                \n"
"          {                                                                   \n"
"            v = (ay * ay + ax * ax);                                          \n"
"          }                                                                   \n"
"          if (v < (part_white*part_white*part_white /2.0))                    \n"
"            acc = acc + 1.0 / aa_sq;                                          \n"
"      }                                                                       \n"
"    }                                                                         \n"
"  }                                                                           \n"
"  return acc;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"__kernel void gegl_spachromyzer (__global const float4     *in,               \n"
"                                 __global       float4     *out,              \n"
"                                 int   pattern,                               \n"
"                                 float wavelength,                            \n"
"                                 float turbulence,                            \n"
"                                 float blocksize,                             \n"
"                                 float angleboost,                            \n"
"                                 float twist)                                 \n"
"{                                                                             \n"
"  size_t roi_width = get_global_size(0);                                      \n"
"  size_t roi_x     = get_global_offset(0);                                    \n"
"  size_t roi_y     = get_global_offset(1);                                    \n"
"  size_t gidx      = get_global_id(0) - roi_x;                                \n"
"  size_t gidy      = get_global_id(1) - roi_y;                                \n"
"                                                                              \n"
"  float4 in_v  = in[gidx + gidy * roi_width];                                 \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  float gray = (in_v.x + in_v.z)/2.0;                                         \n"
"  gray = spachromyze(gidx, gidy, gray, 0, 0, pattern, wavelength, turbulence, blocksize, angleboost, twist);\n"
"                                                                              \n"
"  out_v = (float4) (gray, gray, gray, 1.0f);                                  \n"
"                                                                              \n"
"  out[gidx + gidy * roi_width] = out_v;                                       \n"
"}                                                                             \n"
;
