static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Michael Henning <drawoc@darkrefraction.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load\"))                                   \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"  description (_(\"URI for file to load\"))                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_NAME webp_load                                                \n"
"#define GEGL_OP_C_SOURCE webp-load.c                                          \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <webp/decode.h>                                                      \n"
"                                                                              \n"
"#define IO_BUFFER_SIZE 4096                                                   \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GFile *file;                                                                \n"
"  GInputStream *stream;                                                       \n"
"                                                                              \n"
"  WebPDecoderConfig *config;                                                  \n"
"  WebPIDecoder *decoder;                                                      \n"
"                                                                              \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  gint width;                                                                 \n"
"  gint height;                                                                \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"cleanup(GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p != NULL)                                                              \n"
"    {                                                                         \n"
"      g_clear_pointer (&p->decoder, (GDestroyNotify) WebPIDelete);            \n"
"                                                                              \n"
"      if (p->config != NULL)                                                  \n"
"        WebPFreeDecBuffer (&p->config->output);                               \n"
"                                                                              \n"
"      g_clear_pointer (&p->config, g_free);                                   \n"
"                                                                              \n"
"      if (p->stream != NULL)                                                  \n"
"        g_input_stream_close (G_INPUT_STREAM (p->stream), NULL, NULL);        \n"
"                                                                              \n"
"      g_clear_object (&p->stream);                                            \n"
"      g_clear_object (&p->file);                                              \n"
"                                                                              \n"
"      p->width = p->height = 0;                                               \n"
"      p->format = NULL;                                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gsize                                                                  \n"
"read_from_stream (GInputStream *stream,                                       \n"
"                  guchar **buffer,                                            \n"
"                  gsize size)                                                 \n"
"{                                                                             \n"
"  GError *error = NULL;                                                       \n"
"  gboolean success;                                                           \n"
"  gsize read;                                                                 \n"
"                                                                              \n"
"  *buffer = g_try_new (guchar, size);                                         \n"
"                                                                              \n"
"  g_assert (*buffer != NULL);                                                 \n"
"                                                                              \n"
"  success = g_input_stream_read_all (G_INPUT_STREAM (stream),                 \n"
"                                     (void *) *buffer, size, &read,           \n"
"                                     NULL, &error);                           \n"
"  if (!success || error != NULL)                                              \n"
"    {                                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      g_error_free (error);                                                   \n"
"      return -1;                                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return read;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gsize                                                                  \n"
"decode_from_stream (GInputStream *stream,                                     \n"
"                    WebPIDecoder *decoder)                                    \n"
"{                                                                             \n"
"  GError *error = NULL;                                                       \n"
"  const gsize size = IO_BUFFER_SIZE;                                          \n"
"  guchar *buffer;                                                             \n"
"  gsize read, total = 0;                                                      \n"
"  VP8StatusCode status;                                                       \n"
"  gboolean success;                                                           \n"
"                                                                              \n"
"  buffer = g_try_new (guchar, size);                                          \n"
"                                                                              \n"
"  g_assert (buffer != NULL);                                                  \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      success = g_input_stream_read_all (G_INPUT_STREAM (stream),             \n"
"                                         (void *) buffer, size, &read,        \n"
"                                         NULL, &error);                       \n"
"      if (!success || error != NULL)                                          \n"
"        {                                                                     \n"
"          g_warning (\"%s\", error->message);                                 \n"
"          g_error_free (error);                                               \n"
"          return -1;                                                          \n"
"        }                                                                     \n"
"      else if (read > 0)                                                      \n"
"        {                                                                     \n"
"          total += read;                                                      \n"
"                                                                              \n"
"          status = WebPIAppend (decoder, buffer, read);                       \n"
"          if (status != VP8_STATUS_OK && status != VP8_STATUS_SUSPENDED)      \n"
"            return -1;                                                        \n"
"          else if (status == VP8_STATUS_OK)                                   \n"
"            break;                                                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  while (success && read > 0);                                                \n"
"                                                                              \n"
"  return total;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"query_webp (GeglOperation *operation)                                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  g_return_val_if_fail (p->config != NULL, FALSE);                            \n"
"                                                                              \n"
"  if (p->config->input.has_alpha)                                             \n"
"    {                                                                         \n"
"      p->config->output.colorspace = MODE_RGBA;                               \n"
"      p->format = babl_format (\"R'G'B'A u8\");                               \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      p->config->output.colorspace = MODE_RGB;                                \n"
"      p->format = babl_format (\"R'G'B' u8\");                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->height = p->config->input.height;                                        \n"
"  p->width = p->config->input.width;                                          \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (o->user_data) ? o->user_data : g_new0 (Priv, 1);                 \n"
"  GError *error = NULL;                                                       \n"
"  GFile *file = NULL;                                                         \n"
"  guchar *buffer;                                                             \n"
"  gsize read;                                                                 \n"
"                                                                              \n"
"  g_assert (p != NULL);                                                       \n"
"                                                                              \n"
"  if (p->file != NULL && (o->uri || o->path))                                 \n"
"    {                                                                         \n"
"      if (o->uri && strlen (o->uri) > 0)                                      \n"
"        file = g_file_new_for_uri (o->uri);                                   \n"
"      else if (o->path && strlen (o->path) > 0)                               \n"
"        file = g_file_new_for_path (o->path);                                 \n"
"      if (file != NULL)                                                       \n"
"        {                                                                     \n"
"          if (!g_file_equal (p->file, file))                                  \n"
"            cleanup (operation);                                              \n"
"          g_object_unref (file);                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  o->user_data = (void*) p;                                                   \n"
"                                                                              \n"
"  if (p->config == NULL)                                                      \n"
"    {                                                                         \n"
"      p->stream = gegl_gio_open_input_stream (o->uri, o->path, &p->file, &error);\n"
"      if (p->stream == NULL)                                                  \n"
"        {                                                                     \n"
"          g_warning (\"%s\", error->message);                                 \n"
"          g_error_free (error);                                               \n"
"          cleanup (operation);                                                \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->config = g_try_new (WebPDecoderConfig, 1);                           \n"
"      p->decoder = WebPINewDecoder (&p->config->output);                      \n"
"                                                                              \n"
"      g_assert (p->config != NULL);                                           \n"
"                                                                              \n"
"      if (!WebPInitDecoderConfig (p->config))                                 \n"
"        {                                                                     \n"
"          g_warning (\"could not initialise WebP decoder configuration\");    \n"
"          cleanup (operation);                                                \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      read = read_from_stream (p->stream, &buffer, IO_BUFFER_SIZE);           \n"
"      if (WebPGetFeatures (buffer, read, &p->config->input) != VP8_STATUS_OK) \n"
"        {                                                                     \n"
"          g_warning (\"failed reading WebP image file\");                     \n"
"          cleanup (operation);                                                \n"
"          g_free (buffer);                                                    \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (!query_webp (operation))                                            \n"
"        {                                                                     \n"
"          g_warning (\"could not query WebP image file\");                    \n"
"          cleanup (operation);                                                \n"
"          g_free (buffer);                                                    \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"       WebPIAppend (p->decoder, buffer, read);                                \n"
"                                                                              \n"
"      g_free (buffer);                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", p->format);               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle result = { 0, 0, 0, 0 };                                      \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p->config != NULL)                                                      \n"
"    {                                                                         \n"
"      result.width = p->width;                                                \n"
"      result.height = p->height;                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p->config != NULL)                                                      \n"
"    {                                                                         \n"
"      if (p->decoder != NULL)                                                 \n"
"        {                                                                     \n"
"          if (decode_from_stream (p->stream, p->decoder) < 0)                 \n"
"            {                                                                 \n"
"              g_warning (\"failed decoding WebP image file\");                \n"
"              cleanup (operation);                                            \n"
"              return FALSE;                                                   \n"
"            }                                                                 \n"
"                                                                              \n"
"          g_input_stream_close (G_INPUT_STREAM (p->stream), NULL, NULL);      \n"
"          g_clear_object (&p->stream);                                        \n"
"                                                                              \n"
"          WebPIDelete (p->decoder);                                           \n"
"          p->decoder = NULL;                                                  \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_set (output, result, 0, p->format,                          \n"
"                       p->config->output.u.RGBA.rgba,                         \n"
"                       p->config->output.u.RGBA.stride);                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize(GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data != NULL)                                                   \n"
"    {                                                                         \n"
"      cleanup (GEGL_OPERATION (object));                                      \n"
"      if (o->user_data != NULL)                                               \n"
"        g_free (o->user_data);                                                \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS(klass)->finalize = finalize;                                 \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:webp-load\",                                     \n"
"    \"title\",        _(\"WebP File Loader\"),                                \n"
"    \"categories\"  , \"hidden\",                                             \n"
"    \"description\" , _(\"WebP image loader.\"),                              \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/webp\", \"gegl:webp-load\");                                      \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".webp\", \"gegl:webp-load\");                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
