static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_color  (color, _(\"Color\"),  \"rgba(0.0,0.0,0.0,1.0)\")             \n"
"  description(_(\"Color of paint to use for filling.\"))                      \n"
"                                                                              \n"
"property_double (opacity,  _(\"Opacity\"), 1.0)                               \n"
"  description(_(\"The fill opacity to use.\"))                                \n"
"  value_range (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"  /* XXX: replace with enum? */                                               \n"
"property_string (fill_rule,_(\"Fill rule.\"), \"nonzero\")                    \n"
"  description(_(\"how to determine what to fill (nonzero|evenodd)\"))         \n"
"                                                                              \n"
"property_string (transform,_(\"Transform\"), \"\")                            \n"
"  description (_(\"svg style description of transform.\"))                    \n"
"                                                                              \n"
"property_path (d, _(\"Vector\"), NULL)                                        \n"
"  description (_(\"A GeglVector representing the path of the stroke\"))       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     vector_fill                                          \n"
"#define GEGL_OP_C_SOURCE vector-fill.c                                        \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"                                                                              \n"
"/* the path api isn't public yet */                                           \n"
"#include \"property-types/gegl-path.h\"                                       \n"
"static void path_changed (GeglPath *path,                                     \n"
"                          const GeglRectangle *roi,                           \n"
"                          gpointer userdata);                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <cairo.h>                                                            \n"
"                                                                              \n"
"static void path_changed (GeglPath *path,                                     \n"
"                          const GeglRectangle *roi,                           \n"
"                          gpointer userdata)                                  \n"
"{                                                                             \n"
"  GeglProperties    *o   = GEGL_PROPERTIES (userdata);                        \n"
"  GeglRectangle rect;                                                         \n"
"  gdouble        x0, x1, y0, y1;                                              \n"
"                                                                              \n"
"  gegl_path_get_bounds(o->d, &x0, &x1, &y0, &y1);                             \n"
"  rect.x = x0 - 1;                                                            \n"
"  rect.y = y0 - 1;                                                            \n"
"  rect.width = x1 - x0 + 2;                                                   \n"
"  rect.height = y1 - y0 + 2;                                                  \n"
"                                                                              \n"
"  gegl_operation_invalidate (userdata, &rect, TRUE);                          \n"
"};                                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'aG'aB'aA float\"));\n"
"                                                                              \n"
"  if (o->transform && o->transform[0] != '\\0')                               \n"
"    {                                                                         \n"
"      GeglMatrix3 matrix;                                                     \n"
"      gegl_matrix3_parse_string (&matrix, o->transform);                      \n"
"      gegl_path_set_matrix (o->d, &matrix);                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties    *o       = GEGL_PROPERTIES (operation);                   \n"
"  GeglRectangle  defined = { 0, 0, 512, 512 };                                \n"
"  GeglRectangle *in_rect;                                                     \n"
"  gdouble        x0, x1, y0, y1;                                              \n"
"                                                                              \n"
"  in_rect =  gegl_operation_source_get_bounding_box (operation, \"input\");   \n"
"                                                                              \n"
"  gegl_path_get_bounds (o->d, &x0, &x1, &y0, &y1);                            \n"
"  defined.x      = x0;                                                        \n"
"  defined.y      = y0;                                                        \n"
"  defined.width  = x1 - x0;                                                   \n"
"  defined.height = y1 - y0;                                                   \n"
"                                                                              \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      gegl_rectangle_bounding_box (&defined, &defined, in_rect);              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return defined;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void gegl_path_cairo_play (GeglPath *path,                             \n"
"                                    cairo_t *cr);                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gboolean need_fill = FALSE;                                                 \n"
"  gdouble color[4] = {0, 0, 0, 0};                                            \n"
"                                                                              \n"
"  if (input)                                                                  \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, result, GEGL_ABYSS_NONE, output, result);      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_clear (output, result);                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  if (o->opacity > 0.0001 && o->color)                                        \n"
"    {                                                                         \n"
"      gegl_color_get_pixel (o->color, babl_format (\"R'G'B'A double\"), color);\n"
"      color[3] *= o->opacity;                                                 \n"
"      if (color[3] > 0.001)                                                   \n"
"        need_fill=TRUE;                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (need_fill)                                                              \n"
"    {                                                                         \n"
"      static GMutex mutex = { 0, };                                           \n"
"      cairo_t *cr;                                                            \n"
"      cairo_surface_t *surface;                                               \n"
"      guchar *data;                                                           \n"
"                                                                              \n"
"      g_mutex_lock (&mutex);                                                  \n"
"      data = gegl_buffer_linear_open (output, result, NULL, babl_format (\"cairo-ARGB32\"));\n"
"      surface = cairo_image_surface_create_for_data (data,                    \n"
"                                                     CAIRO_FORMAT_ARGB32,     \n"
"                                                     result->width,           \n"
"                                                     result->height,          \n"
"                                                     result->width * 4);      \n"
"                                                                              \n"
"      cr = cairo_create (surface);                                            \n"
"      cairo_translate (cr, -result->x, -result->y);                           \n"
"      if (g_str_equal (o->fill_rule, \"evenodd\"))                            \n"
"          cairo_set_fill_rule (cr, CAIRO_FILL_RULE_EVEN_ODD);                 \n"
"                                                                              \n"
"      gegl_path_cairo_play (o->d, cr);                                        \n"
"      cairo_set_source_rgba (cr, color[0], color[1], color[2], color[3]);     \n"
"      cairo_fill (cr);                                                        \n"
"      cairo_destroy (cr);                                                     \n"
"                                                                              \n"
"      gegl_buffer_linear_close (output, data);                                \n"
"      g_mutex_unlock (&mutex);                                                \n"
"    }                                                                         \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void foreach_cairo (const GeglPathItem *knot,                          \n"
"                           gpointer              cr)                          \n"
"{                                                                             \n"
"  switch (knot->type)                                                         \n"
"    {                                                                         \n"
"      case 'M':                                                               \n"
"        cairo_move_to (cr, knot->point[0].x, knot->point[0].y);               \n"
"        break;                                                                \n"
"      case 'L':                                                               \n"
"        cairo_line_to (cr, knot->point[0].x, knot->point[0].y);               \n"
"        break;                                                                \n"
"      case 'C':                                                               \n"
"        cairo_curve_to (cr, knot->point[0].x, knot->point[0].y,               \n"
"                            knot->point[1].x, knot->point[1].y,               \n"
"                            knot->point[2].x, knot->point[2].y);              \n"
"        break;                                                                \n"
"      case 'z':                                                               \n"
"        cairo_close_path (cr);                                                \n"
"        break;                                                                \n"
"      default:                                                                \n"
"        g_print (\"%s uh?:%c\\n\", G_STRLOC, knot->type);                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void gegl_path_cairo_play (GeglPath *path,                             \n"
"                                    cairo_t *cr)                              \n"
"{                                                                             \n"
"  gegl_path_foreach_flat (path, foreach_cairo, cr);                           \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglNode *detect (GeglOperation *operation,                            \n"
"                         gint           x,                                    \n"
"                         gint           y)                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  cairo_t *cr;                                                                \n"
"  cairo_surface_t *surface;                                                   \n"
"  gchar *data = \"     \";                                                    \n"
"  gboolean result = FALSE;                                                    \n"
"                                                                              \n"
"  surface = cairo_image_surface_create_for_data ((guchar*)data,               \n"
"                                                 CAIRO_FORMAT_ARGB32,         \n"
"                                                 1,1,4);                      \n"
"  cr = cairo_create (surface);                                                \n"
"  gegl_path_cairo_play (o->d, cr);                                            \n"
"                                                                              \n"
"  if (!result)                                                                \n"
"    {                                                                         \n"
"      if (o->d)                                                               \n"
"        {                                                                     \n"
"          gdouble r,g,b,a;                                                    \n"
"          gegl_color_get_rgba (o->color, &r,&g,&b,&a);                        \n"
"          if (a * o->opacity>0.8)                                             \n"
"            result = cairo_in_fill (cr, x, y);                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  cairo_destroy (cr);                                                         \n"
"                                                                              \n"
"  if (result)                                                                 \n"
"    return operation->node;                                                   \n"
"                                                                              \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  gchar                    *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:crop' width='200' height='200'/>\"                \n"
"    \"<node operation='gegl:over'>\"                                          \n"
"    \"<node operation='gegl:translate' x='40' y='40'/>\"                      \n"
"    \"<node operation='gegl:fill-path'>\"                                     \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='color'>rgb(0.0, 0.6, 1.0)</param>\"                    \n"
"    \"    <param name='d'>\"                                                  \n"
"    \"M0,50 C0,78 24,100 50,100 C77,100 100,78 100,50 C100,45 99,40 98,35 C82,35 66,35 50,35 C42,35 35,42 35,50 C35,58 42,65 50,65 C56,65 61,61 64,56 C67,51 75,55 73,60 C69,  69 60,75 50,75 C36,75 25,64 25,50 C25,36 36,25 50,25 L93,25 C83,9 67,0 49,0 C25,0 0,20 0,50   z\"\n"
"    \"                    </param>\"                                          \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:checkerboard' color1='rgb(0.25,0.25,0.25)' color2='rgb(0.75,0.75,0.75)'/>\"\n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->detect = detect;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:fill-path\",                                      \n"
"    \"title\",       _(\"Fill Path\"),                                        \n"
"    \"categories\" , \"render\",                                              \n"
"    \"description\", _(\"Renders a filled region\"),                          \n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#endif                                                                        \n"
;
