static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_object (buffer, _(\"Buffer location\"), GEGL_TYPE_BUFFER)            \n"
"    description(_(\"A pre-existing GeglBuffer to write incoming buffer data to.\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE write-buffer.c                                       \n"
"#define GEGL_OP_NAME     write_buffer                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include \"gegl/gegl-debug.h\"                                                \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    {                                                                         \n"
"      GeglBuffer *output = GEGL_BUFFER (o->buffer);                           \n"
"      const Babl *in_format = gegl_buffer_get_format (input);                 \n"
"      const Babl *out_format = gegl_buffer_get_format (output);               \n"
"                                                                              \n"
"      if (gegl_operation_use_opencl (operation)                               \n"
"          && gegl_cl_color_supported (in_format, out_format) == GEGL_CL_COLOR_CONVERT)\n"
"        {                                                                     \n"
"          size_t size;                                                        \n"
"          gboolean err;                                                       \n"
"          cl_int cl_err = 0;                                                  \n"
"                                                                              \n"
"          GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,      \n"
"                                                                 result,      \n"
"                                                                 out_format,  \n"
"                                                                 GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"          gint read = gegl_buffer_cl_iterator_add (i,                         \n"
"                                                   input,                     \n"
"                                                   result,                    \n"
"                                                   out_format,                \n"
"                                                   GEGL_CL_BUFFER_READ,       \n"
"                                                   GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"          gegl_cl_color_babl (out_format, &size);                             \n"
"                                                                              \n"
"          GEGL_NOTE (GEGL_DEBUG_OPENCL,                                       \n"
"                     \"write-buffer: \"                                       \n"
"                     \"%p %p %s %s {%d %d %d %d}\",                           \n"
"                     input,                                                   \n"
"                     output,                                                  \n"
"                     babl_get_name (in_format),                               \n"
"                     babl_get_name (out_format),                              \n"
"                     result->x,                                               \n"
"                     result->y,                                               \n"
"                     result->width,                                           \n"
"                     result->height);                                         \n"
"                                                                              \n"
"          while (gegl_buffer_cl_iterator_next (i, &err))                      \n"
"            {                                                                 \n"
"              if (err) break;                                                 \n"
"                                                                              \n"
"              cl_err = gegl_clEnqueueCopyBuffer (gegl_cl_get_command_queue (),\n"
"                                                 i->tex[read],                \n"
"                                                 i->tex[0],                   \n"
"                                                 0,                           \n"
"                                                 0,                           \n"
"                                                 i->size[0] * size,           \n"
"                                                 0,                           \n"
"                                                 NULL,                        \n"
"                                                 NULL);                       \n"
"                                                                              \n"
"              if (cl_err != CL_SUCCESS)                                       \n"
"                {                                                             \n"
"                  GEGL_NOTE (GEGL_DEBUG_OPENCL, \"Error: %s\", gegl_cl_errstring (cl_err));\n"
"                  break;                                                      \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (cl_err || err)                                                  \n"
"            gegl_buffer_copy (input, result, GEGL_ABYSS_NONE,                 \n"
"                              output, result);                                \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        gegl_buffer_copy (input, result, GEGL_ABYSS_NONE,                     \n"
"                          output, result);                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"dispose (GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->buffer)                                                              \n"
"    {                                                                         \n"
"      g_object_unref (o->buffer);                                             \n"
"      o->buffer = NULL;                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = FALSE;                                             \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->dispose = dispose;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:write-buffer\",                                   \n"
"    \"title\",       _(\"Write Buffer\"),                                     \n"
"    \"categories\" , \"programming:output\",                                  \n"
"    \"description\", _(\"Write input data into an existing GEGL buffer destination surface.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
