static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Thomas Manni <thomas.manni@free.fr>                         \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (clip_low, _(\"Clip low pixel values\"), TRUE)               \n"
"     description (_(\"Clip low pixel values\"))                               \n"
"                                                                              \n"
"property_double (low_limit, _(\"Low limit\"), 0.0)                            \n"
"    value_range (-G_MAXDOUBLE, 0.0)                                           \n"
"    ui_range    (-2.0, 0.0)                                                   \n"
"    description (_(\"Pixels values lower than this limit will be set to it\"))\n"
"                                                                              \n"
"property_boolean (clip_high, _(\"Clip high pixel values\"), TRUE)             \n"
"     description (_(\"Clip high pixel values\"))                              \n"
"                                                                              \n"
"property_double (high_limit, _(\"High limit\"), 1.0)                          \n"
"    value_range (1.0, G_MAXDOUBLE)                                            \n"
"    ui_range    (1.0, 3.0)                                                    \n"
"    description (_(\"Pixels values higher than this limit will be set to it\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     rgb_clip                                             \n"
"#define GEGL_OP_C_SOURCE rgb-clip.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *src_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const char *format     = \"RGB float\";                                     \n"
"                                                                              \n"
"  if (src_format)                                                             \n"
"    {                                                                         \n"
"      const Babl *model = babl_format_get_model (src_format);                 \n"
"                                                                              \n"
"      if (model == babl_model (\"RGB\"))                                      \n"
"        format = \"RGB float\";                                               \n"
"      else if (model == babl_model (\"RGBA\"))                                \n"
"        format = \"RGBA float\";                                              \n"
"      else if (model == babl_model (\"R'G'B'\"))                              \n"
"        format = \"R'G'B' float\";                                            \n"
"      else if (model == babl_model (\"R'G'B'A\"))                             \n"
"        format = \"R'G'B'A float\";                                           \n"
"      else if (babl_format_has_alpha (src_format))                            \n"
"        format = \"RGBA float\";                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (format));    \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (format));    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"  const Babl     *format    = gegl_operation_get_format (operation, \"input\");\n"
"  gboolean        has_alpha = babl_format_has_alpha (format);                 \n"
"  gint            n_components = has_alpha ? 4 : 3;                           \n"
"  gfloat *input  = in_buf;                                                    \n"
"  gfloat *output = out_buf;                                                   \n"
"                                                                              \n"
"  if (o->clip_low && o->clip_high)                                            \n"
"    {                                                                         \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          output[0] = CLAMP (input[0], o->low_limit, o->high_limit);          \n"
"          output[1] = CLAMP (input[1], o->low_limit, o->high_limit);          \n"
"          output[2] = CLAMP (input[2], o->low_limit, o->high_limit);          \n"
"                                                                              \n"
"          if (has_alpha)                                                      \n"
"            output[3] = input[3];                                             \n"
"                                                                              \n"
"          input  += n_components;                                             \n"
"          output += n_components;                                             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  else if (o->clip_high)                                                      \n"
"    {                                                                         \n"
"      while (n_pixels--)                                                      \n"
"          {                                                                   \n"
"            output[0] = input[0] > o->high_limit ? o->high_limit : input[0];  \n"
"            output[1] = input[1] > o->high_limit ? o->high_limit : input[1];  \n"
"            output[2] = input[2] > o->high_limit ? o->high_limit : input[2];  \n"
"                                                                              \n"
"            if (has_alpha)                                                    \n"
"              output[3] = input[3];                                           \n"
"                                                                              \n"
"            input  += n_components;                                           \n"
"            output += n_components;                                           \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  else if (o->clip_low)                                                       \n"
"    {                                                                         \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          output[0] = input[0] < o->low_limit ? o->low_limit : input[0];      \n"
"          output[1] = input[1] < o->low_limit ? o->low_limit : input[1];      \n"
"          output[2] = input[2] < o->low_limit ? o->low_limit : input[2];      \n"
"                                                                              \n"
"          if (has_alpha)                                                      \n"
"            output[3] = input[3];                                             \n"
"                                                                              \n"
"          input  += n_components;                                             \n"
"          output += n_components;                                             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglOperationClass  *operation_class;                                       \n"
"  GeglProperties      *o = GEGL_PROPERTIES (operation);                       \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (gegl_op_parent_class);              \n"
"                                                                              \n"
"  if (!o->clip_high && !o->clip_low)                                          \n"
"    {                                                                         \n"
"      gpointer in = gegl_operation_context_get_object (context, \"input\");   \n"
"      gegl_operation_context_take_object (context, \"output\",                \n"
"                                              g_object_ref (G_OBJECT (in)));  \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* chain up, which will create the needed buffers for our actual            \n"
"   * process function                                                         \n"
"   */                                                                         \n"
"  return operation_class->process (operation, context, output_prop, result,   \n"
"                                   gegl_operation_context_get_level (context));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->process = operation_process;                               \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:rgb-clip\",                                       \n"
"    \"title\",       _(\"Clip RGB\"),                                         \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Keep RGB pixels values inside a specific range\"),   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
