static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2008 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2013 Daniel Sabo                                                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (start_x, _(\"X1\"), 25.0)                                    \n"
"property_double (start_y, _(\"Y1\"), 25.0)                                    \n"
"property_double (end_x,   _(\"X2\"), 50.0)                                    \n"
"property_double (end_y,   _(\"Y2\"), 50.0)                                    \n"
"property_color  (start_color, _(\"Start Color\"), \"black\")                  \n"
"    description (_(\"The color at (x1, y1)\"))                                \n"
"property_color  (end_color, _(\"End Color\"), \"white\")                      \n"
"    description (_(\"The color at (x2, y2)\"))                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     radial_gradient                                      \n"
"#define GEGL_OP_C_SOURCE radial-gradient.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"dist (gfloat x1, gfloat y1, gfloat x2, gfloat y2)                             \n"
"{                                                                             \n"
"  gfloat dx = x1 - x2;                                                        \n"
"  gfloat dy = y1 - y2;                                                        \n"
"                                                                              \n"
"  return sqrtf (dx * dx + dy * dy);                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"  gfloat         *out_pixel = out_buf;                                        \n"
"  gfloat         color1[4];                                                   \n"
"  gfloat         color2[4];                                                   \n"
"  gfloat         length = dist (o->start_x, o->start_y, o->end_x, o->end_y);  \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->start_color, babl_format (\"R'G'B'A float\"), color1);\n"
"  gegl_color_get_pixel (o->end_color, babl_format (\"R'G'B'A float\"), color2);\n"
"                                                                              \n"
"  if (GEGL_FLOAT_IS_ZERO (length))                                            \n"
"    {                                                                         \n"
"      gegl_memset_pattern (out_buf, color2, sizeof(float) * 4, n_pixels);     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gint x, y;                                                              \n"
"      for (y = roi->y; y < roi->y + roi->height; ++y)                         \n"
"        {                                                                     \n"
"          for (x = roi->x; x < roi->x + roi->width; ++x)                      \n"
"            {                                                                 \n"
"              gint c;                                                         \n"
"              gfloat v = dist (x, y, o->start_x, o->start_y) / length;        \n"
"                                                                              \n"
"              if (v > 1.0f - GEGL_FLOAT_EPSILON)                              \n"
"                v = 1.0f;                                                     \n"
"                                                                              \n"
"              for (c = 0; c < 4; c++)                                         \n"
"                out_pixel[c] = color1[c] * v + color2[c] * (1.0f - v);        \n"
"                                                                              \n"
"              out_pixel += 4;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process       = process;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->no_cache         = TRUE;                                   \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:radial-gradient\",                               \n"
"    \"title\",        _(\"Radial Gradient\"),                                 \n"
"    \"categories\",   \"render:gradient\",                                    \n"
"    \"description\" , _(\"Radial gradient renderer\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
