static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (length, _(\"Length\"), 10.0)                                 \n"
"    description (_(\"Length of blur in pixels\"))                             \n"
"    value_range (0.0, 1000.0)                                                 \n"
"    ui_range    (0.0, 300.0)                                                  \n"
"    ui_gamma    (1.5)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_double (angle, _(\"Angle\"), 0.0)                                    \n"
"    description (_(\"Angle of blur in degrees\"))                             \n"
"    value_range (-180, 180)                                                   \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     motion_blur_linear                                   \n"
"#define GEGL_OP_C_SOURCE motion-blur-linear.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  gdouble                  theta   = o->angle * G_PI / 180.0;                 \n"
"  gdouble                  offset_x;                                          \n"
"  gdouble                  offset_y;                                          \n"
"                                                                              \n"
"  while (theta < 0.0)                                                         \n"
"    theta += 2 * G_PI;                                                        \n"
"                                                                              \n"
"  offset_x = fabs (o->length * cos (theta));                                  \n"
"  offset_y = fabs (o->length * sin (theta));                                  \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  = (gint) ceil (0.5 * offset_x);                             \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = (gint) ceil (0.5 * offset_y);                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/motion-blur-linear.cl.h\"                                   \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_motion_blur_linear (cl_mem                in_tex,                          \n"
"                       cl_mem                out_tex,                         \n"
"                       size_t                global_worksize,                 \n"
"                       const GeglRectangle  *roi,                             \n"
"                       const GeglRectangle  *src_rect,                        \n"
"                       gint                  num_steps,                       \n"
"                       gfloat                offset_x,                        \n"
"                       gfloat                offset_y)                        \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws[2];                                                        \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"motion_blur_linear\", NULL};             \n"
"      cl_data = gegl_cl_compile_and_build (motion_blur_linear_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  global_ws[0] = roi->width;                                                  \n"
"  global_ws[1] = roi->height;                                                 \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  1, sizeof(cl_int),   (void*)&src_rect->width);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  2, sizeof(cl_int),   (void*)&src_rect->height);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  3, sizeof(cl_int),   (void*)&src_rect->x);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  4, sizeof(cl_int),   (void*)&src_rect->y);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  5, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  6, sizeof(cl_int),   (void*)&roi->x);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  7, sizeof(cl_int),   (void*)&roi->y);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  8, sizeof(cl_int),   (void*)&num_steps);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0],  9, sizeof(cl_float), (void*)&offset_x);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 10, sizeof(cl_float), (void*)&offset_y);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, global_ws, NULL,                \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result,                                      \n"
"            const GeglRectangle *src_rect)                                    \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties              *o       = GEGL_PROPERTIES (operation);         \n"
"                                                                              \n"
"  GeglBufferClIterator *i;                                                    \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint        err;                                                            \n"
"  gdouble     theta     = o->angle * G_PI / 180.0;                            \n"
"  gint        num_steps = (gint)ceil(o->length) + 1;                          \n"
"  gfloat      offset_x;                                                       \n"
"  gfloat      offset_y;                                                       \n"
"  gint        read;                                                           \n"
"                                                                              \n"
"  while (theta < 0.0)                                                         \n"
"    theta += 2 * G_PI;                                                        \n"
"                                                                              \n"
"  offset_x = (gfloat) (o->length * cos (theta));                              \n"
"  offset_y = (gfloat) (o->length * sin (theta));                              \n"
"                                                                              \n"
"  i = gegl_buffer_cl_iterator_new (output,                                    \n"
"                                   result,                                    \n"
"                                   out_format,                                \n"
"                                   GEGL_CL_BUFFER_WRITE);                     \n"
"                                                                              \n"
"  read = gegl_buffer_cl_iterator_add_2 (i,                                    \n"
"                                        input,                                \n"
"                                        result,                               \n"
"                                        in_format,                            \n"
"                                        GEGL_CL_BUFFER_READ,                  \n"
"                                        op_area->left,                        \n"
"                                        op_area->right,                       \n"
"                                        op_area->top,                         \n"
"                                        op_area->bottom,                      \n"
"                                        GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err)                                                                \n"
"        return FALSE;                                                         \n"
"                                                                              \n"
"      err = cl_motion_blur_linear (i->tex[read],                              \n"
"                                   i->tex[0],                                 \n"
"                                   i->size[0],                                \n"
"                                   &i->roi[0],                                \n"
"                                   &i->roi[read],                             \n"
"                                   num_steps,                                 \n"
"                                   offset_x,                                  \n"
"                                   offset_y);                                 \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        return FALSE;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat *                                                        \n"
"get_pixel_color (gfloat              *in_buf,                                 \n"
"                 const GeglRectangle *rect,                                   \n"
"                 gint                 x,                                      \n"
"                 gint                 y)                                      \n"
"{                                                                             \n"
"  gint ix = x - rect->x;                                                      \n"
"  gint iy = y - rect->y;                                                      \n"
"                                                                              \n"
"  ix = CLAMP (ix, 0, rect->width  - 1);                                       \n"
"  iy = CLAMP (iy, 0, rect->height - 1);                                       \n"
"                                                                              \n"
"  return &in_buf[(iy * rect->width + ix) * 4];                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties              *o       = GEGL_PROPERTIES (operation);         \n"
"  GeglRectangle            src_rect;                                          \n"
"  gfloat                  *in_buf;                                            \n"
"  gfloat                  *out_buf;                                           \n"
"  gfloat                  *out_pixel;                                         \n"
"  gint                     x, y;                                              \n"
"                                                                              \n"
"  gdouble theta         = o->angle * G_PI / 180.0;                            \n"
"  gint    num_steps     = (gint) ceil (o->length) + 1;                        \n"
"  gfloat  inv_num_steps = 1.0f / num_steps;                                   \n"
"  gdouble offset_x;                                                           \n"
"  gdouble offset_y;                                                           \n"
"                                                                              \n"
"  while (theta < 0.0)                                                         \n"
"    theta += 2 * G_PI;                                                        \n"
"                                                                              \n"
"  offset_x = o->length * cos (theta);                                         \n"
"  offset_y = o->length * sin (theta);                                         \n"
"                                                                              \n"
"  src_rect = *roi;                                                            \n"
"  src_rect.x -= op_area->left;                                                \n"
"  src_rect.y -= op_area->top;                                                 \n"
"  src_rect.width += op_area->left + op_area->right;                           \n"
"  src_rect.height += op_area->top + op_area->bottom;                          \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, roi, &src_rect))                \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  in_buf = g_new (gfloat, src_rect.width * src_rect.height * 4);              \n"
"  out_buf = g_new0 (gfloat, roi->width * roi->height * 4);                    \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  gegl_buffer_get (input, &src_rect, 1.0, babl_format (\"RaGaBaA float\"),    \n"
"                   in_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"  for (y = 0; y < roi->height; ++y)                                           \n"
"    {                                                                         \n"
"      for (x = 0; x < roi->width; ++x)                                        \n"
"        {                                                                     \n"
"          gint   step;                                                        \n"
"          gint   c;                                                           \n"
"          gint   px = x+roi->x;                                               \n"
"          gint   py = y+roi->y;                                               \n"
"          gfloat sum[4] = {0,0,0,0};                                          \n"
"                                                                              \n"
"          for (step = 0; step < num_steps; ++step)                            \n"
"            {                                                                 \n"
"              gdouble t = num_steps == 1 ? 0.0 : step / (gdouble)(num_steps-1) - 0.5;\n"
"                                                                              \n"
"              /* get the interpolated pixel position for this step */         \n"
"              gdouble xx = px + t * offset_x;                                 \n"
"              gdouble yy = py + t * offset_y;                                 \n"
"              gint    ix = (gint) floor (xx);                                 \n"
"              gint    iy = (gint) floor (yy);                                 \n"
"              gdouble dx = xx - floor (xx);                                   \n"
"              gdouble dy = yy - floor (yy);                                   \n"
"                                                                              \n"
"              /* do bilinear interpolation to get a nice smooth result */     \n"
"              gfloat *pix0, *pix1, *pix2, *pix3;                              \n"
"              gfloat  mixy0[4];                                               \n"
"              gfloat  mixy1[4];                                               \n"
"                                                                              \n"
"              pix0 = get_pixel_color (in_buf, &src_rect, ix,     iy);         \n"
"              pix1 = get_pixel_color (in_buf, &src_rect, ix + 1, iy);         \n"
"              pix2 = get_pixel_color (in_buf, &src_rect, ix,     iy + 1);     \n"
"              pix3 = get_pixel_color (in_buf, &src_rect, ix + 1, iy + 1);     \n"
"                                                                              \n"
"              for (c = 0; c < 4; ++c)                                         \n"
"                {                                                             \n"
"                  mixy0[c] = dy * (pix2[c] - pix0[c]) + pix0[c];              \n"
"                  mixy1[c] = dy * (pix3[c] - pix1[c]) + pix1[c];              \n"
"                  sum[c] += dx * (mixy1[c] - mixy0[c]) + mixy0[c];            \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          for (c = 0; c < 4; ++c)                                             \n"
"            *out_pixel++ = sum[c] * inv_num_steps;                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, roi, 0, babl_format (\"RaGaBaA float\"),           \n"
"                   out_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (in_buf);                                                            \n"
"  g_free (out_buf);                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class = GEGL_OPERATION_FILTER_CLASS (klass);                         \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  filter_class->process           = process;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"                                 \"name\",        \"gegl:motion-blur-linear\",\n"
"                                 \"title\",       _(\"Linear Motion Blur\"),  \n"
"                                 \"compat-name\", \"gegl:motion-blur\",       \n"
"                                 \"categories\",  \"blur\",                   \n"
"                                 \"description\", _(\"Blur pixels in a direction, simulates blurring caused by moving camera in a straight line during exposure.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
