# Copyright (C) 2011 - Curtis Hovey <sinzui.is at verizon.net>
# This software is licensed under the MIT license (see the file COPYING).

import unittest

from gi.repository import GObject
from gi.repository import Gtk

from gdp.find import (
    find_params,
    FinderWorker,
    )


class TestCallback:

    def __init__(self):
        self.called = False

    def on_callback(self):
        self.called = True


class TestFinderWorker(unittest.TestCase):

    def makeTreeStore(self):
        return Gtk.TreeStore(
            GObject.TYPE_STRING, GObject.TYPE_STRING, GObject.TYPE_INT,
            GObject.TYPE_STRING, GObject.TYPE_STRING)

    def test__init__(self):
        params = find_params('./', 'snark', False, False, None)
        treestore = self.makeTreeStore()
        callback = TestCallback()
        worker = FinderWorker(treestore, params, callback)
        self.assertEqual(treestore, worker.treestore)
        self.assertEqual(params, worker.find_params)
        self.assertEqual(callback, worker.callback)
        self.assertEqual(None, worker.substitution)
        self.assertEqual(Gtk.IconTheme.get_default(), worker.theme)

    def test_pattern_simple(self):
        params = find_params('./', 'Snark(', False, False, None)
        treestore = self.makeTreeStore()
        callback = TestCallback()
        worker = FinderWorker(treestore, params, callback)
        self.assertEqual('(?i)Snark\\(', worker.pattern)

    def test_pattern_re(self):
        params = find_params('./', 'Snark(', True, False, None)
        treestore = self.makeTreeStore()
        callback = TestCallback()
        worker = FinderWorker(treestore, params, callback)
        self.assertEqual('(?i)Snark(', worker.pattern)

    def test_pattern_case(self):
        params = find_params('./', 'Snark(', False, True, None)
        treestore = self.makeTreeStore()
        callback = TestCallback()
        worker = FinderWorker(treestore, params, callback)
        self.assertEqual('Snark\\(', worker.pattern)
