#line 39 "../noweb/x_window.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/x_window.nw"
/* DO NOT read or edit this file ! Use ../noweb/x_window.nw instead */

#line 62 "../noweb/x_window.nw"
#include <config.h>

#include <stdio.h>

#include <libgeda/libgeda.h>

#include "../include/papersizes.h"
#include "../include/x_event.h"
#include "../include/i_vars.h"
#include "../include/globals.h"
#include "../include/prototype.h"

#line 78 "../noweb/x_window.nw"
/* global_wid always increments, it needs to be unique per gschem run */
static int num_windows = 0;
static int global_wid = 0;

/* head pointer to window structure, this points to all the windows that
   currently exist */
static TOPLEVEL *window_head = NULL;
static TOPLEVEL *window_tail = NULL;

#line 96 "../noweb/x_window.nw"
/* add to the end of the list */
TOPLEVEL *x_window_add(TOPLEVEL * w_head, TOPLEVEL * w_current)
{
  if (w_head == NULL) {
    w_current->prev = NULL;
    w_current->next = NULL;
    return (w_current);
  } else {
    w_current->prev = w_head;
    w_current->next = NULL;
    w_head->next = w_current;
    return (w_head->next);
  }
}


#line 122 "../noweb/x_window.nw"
void x_window_add_head()
{
  window_tail = window_head = (TOPLEVEL *) malloc(sizeof(TOPLEVEL));
  window_head->wid = -1;
}


#line 139 "../noweb/x_window.nw"
void x_window_free_head()
{
  free(window_head);
}


#line 155 "../noweb/x_window.nw"
/* deletes specified window from w_head list */
/* doesn't do the actual destroy though */
void x_window_delete(TOPLEVEL * w_head, TOPLEVEL * w_current)
{

  if (w_head == NULL || w_current == NULL) {
    /* error condition hack */
    return;
  }

  if (w_current->next)
    w_current->next->prev = w_current->prev;

  if (w_current->prev)
    w_current->prev->next = w_current->next;

  s_page_free_all(w_current, w_current->page_tail);
}


#line 185 "../noweb/x_window.nw"
void x_window_setup_world(TOPLEVEL * w_current)
{
  w_current->init_left = -45;
  w_current->init_top = -45;
  /* init_right and _bottom are set before this function is called */
  w_current->min_zoom = 0;
  w_current->max_zoom = 256;	/* was 128 */

#if 0				/* no longer used */
  if (w_current->display_width <= 800) {
    w_current->width = 672;
    w_current->height = 504;
  } else if (w_current->display_width <= 1024) {
    w_current->width = 800;
    w_current->height = 600;
  } else if (w_current->display_width <= 1280) {
    w_current->width = 1024;
    w_current->height = 768;
  } else if (w_current->display_width <= 1600) {
    w_current->width = 1280;
    w_current->height = 960;
  } else {
    w_current->width = 1600;
    w_current->height = 1200;
  }
#endif

  w_current->width = default_width;
  w_current->height = default_height;

  w_current->starting_width = w_current->width;

  w_current->win_width = w_current->width;
  w_current->win_height = w_current->height;

}


#line 233 "../noweb/x_window.nw"
void x_window_setup_rest(TOPLEVEL * w_current)
{
  w_current->num_untitled = 0;

  w_current->start_x = -1;
  w_current->start_y = -1;
  w_current->save_x = -1;
  w_current->save_y = -1;
  w_current->last_x = -1;
  w_current->last_y = -1;
  w_current->loc_x = -1;
  w_current->loc_y = -1;
  w_current->distance = -1;
  w_current->event_state = SELECT;
  w_current->inside_action = 0;
  w_current->snap = 1;
  w_current->grid = 1;

  w_current->show_hidden_text = 0;

  w_current->complex_rotate = 0;

  w_current->current_attribute = NULL;
  w_current->current_visible = -1;	/* not sure on these */
  w_current->current_show = -1;

  w_current->internal_basename = NULL;
  w_current->internal_clib = NULL;

  w_current->series_name = NULL;
  w_current->untitled_name = NULL;
  w_current->font_directory = NULL;
  w_current->scheme_directory = NULL;
  w_current->bitmap_directory = NULL;
  w_current->bus_ripper_symname = NULL;

  w_current->override_color = -1;
  w_current->inside_redraw = 0;

  w_current->FORCE_CONN_UPDATE = 0;
  w_current->ADDING_SEL = 0;
  w_current->REMOVING_SEL = 0;

  w_current->drawbounding_action_mode = FREE;
  w_current->last_drawb_mode = -1;
  w_current->CONTROLKEY = 0;
  w_current->SHIFTKEY = 0;
  w_current->last_callback = NULL;

  w_current->status_label = NULL;
  w_current->middle_label = NULL;
  w_current->filename_label = NULL;

  w_current->cswindow = NULL;
  w_current->aswindow = NULL;
  w_current->fowindow = NULL;
  w_current->sowindow = NULL;
  w_current->fswindow = NULL;

  w_current->tiwindow = NULL;
  w_current->tewindow = NULL;
  w_current->exwindow = NULL;
  w_current->aawindow = NULL;
  w_current->mawindow = NULL;
  w_current->aewindow = NULL;
  w_current->trwindow = NULL;
  w_current->tswindow = NULL;
  w_current->pswindow = NULL;
  w_current->pwindow = NULL;
  w_current->iwindow = NULL;
  w_current->abwindow = NULL;
  w_current->hkwindow = NULL;
  w_current->cowindow = NULL;
  w_current->clwindow = NULL;
  w_current->ltwindow = NULL;
  w_current->ftwindow = NULL;
  w_current->sewindow = NULL;
  w_current->fileselect[FILESELECT].xfwindow = NULL;
  w_current->fileselect[FILESELECT].directory = NULL;
  w_current->fileselect[FILESELECT].filename = NULL;
  x_fileselect_init_list_buffers(&w_current->fileselect[FILESELECT]);
  w_current->fileselect[COMPSELECT].xfwindow = NULL;
  w_current->fileselect[COMPSELECT].directory = NULL;
  w_current->fileselect[COMPSELECT].filename = NULL;
  x_fileselect_init_list_buffers(&w_current->fileselect[COMPSELECT]);

  w_current->coord_world = NULL;
  w_current->coord_screen = NULL;
  w_current->doing_pan = FALSE;
  /* w_current->preview = NULL;experimental widget */

  w_current->buffer_number = 0;
}


#line 338 "../noweb/x_window.nw"
void x_window_setup_colors(void)
{
  int ret;

  gdk_color_parse("black", &black);
  ret = gdk_color_alloc(colormap, &black);
  if (ret == 0) {
    fprintf(stderr, _("Could not allocate the color %s!\n"), _("black"));
    exit(-1);
  }

  gdk_color_parse("white", &white);
  ret = gdk_color_alloc(colormap, &white);
  if (ret == 0) {
    fprintf(stderr, _("Could not allocate the color %s!\n"), _("white"));
    exit(-1);
  }

  x_color_allocate_all();

#if 0
  gdk_color_parse("grey", &grey);
  ret = gdk_color_alloc(colormap, &grey);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color grey!\n");
    exit(-1);
  }

  gdk_color_parse("grey90", &grey90);
  ret = gdk_color_alloc(colormap, &grey90);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color grey90!\n");
    exit(-1);
  }

  gdk_color_parse("yellow", &yellow);
  ret = gdk_color_alloc(colormap, &yellow);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color yellow!\n");
    exit(-1);
  }

  gdk_color_parse("cyan", &cyan);
  ret = gdk_color_alloc(colormap, &cyan);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color cyan!\n");
    exit(-1);
  }

  gdk_color_parse("red", &red);
  ret = gdk_color_alloc(colormap, &red);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color red!\n");
    exit(-1);
  }

  gdk_color_parse("blue", &blue);
  ret = gdk_color_alloc(colormap, &blue);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color blue!\n");
    exit(-1);
  }

  gdk_color_parse("green", &green);
  ret = gdk_color_alloc(colormap, &green);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color green!\n");
    exit(-1);
  }

  gdk_color_parse("red3", &darkred);
  ret = gdk_color_alloc(colormap, &darkred);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkred!\n");
    exit(-1);
  }

  gdk_color_parse("blue3", &darkblue);
  ret = gdk_color_alloc(colormap, &darkblue);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkblue!\n");
    exit(-1);
  }

  gdk_color_parse("green3", &darkgreen);
  ret = gdk_color_alloc(colormap, &darkgreen);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkgreen!\n");
    exit(-1);
  }

  gdk_color_parse("cyan3", &darkcyan);
  ret = gdk_color_alloc(colormap, &darkcyan);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkcyan!\n");
    exit(-1);
  }

  gdk_color_parse("darkgrey", &darkgrey);
  ret = gdk_color_alloc(colormap, &darkgrey);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkgrey!\n");
    exit(-1);
  }

  gdk_color_parse("yellow3", &darkyellow);
  ret = gdk_color_alloc(colormap, &darkyellow);
  if (ret == 0) {
    fprintf(stderr, "Could not allocate the color darkyellow!\n");
    exit(-1);
  }
#endif
}


#line 463 "../noweb/x_window.nw"
void x_window_free_colors(TOPLEVEL * w_current)
{
  /* to be done later */
}


#line 479 "../noweb/x_window.nw"
void x_window_setup_gc(TOPLEVEL * w_current)
{
  GdkGCValues values;
  GdkGCValuesMask values_mask;

  w_current->gc = gdk_gc_new(w_current->window);

  if (w_current->gc == NULL) {
    fprintf(stderr, _("Couldn't allocate gc\n"));
    exit(-1);
  }

  values.foreground = white;
  values.background = black;

  values.function = GDK_XOR;
  values_mask = GDK_GC_FOREGROUND | GDK_GC_BACKGROUND | GDK_GC_FUNCTION;
  w_current->xor_gc = gdk_gc_new_with_values(w_current->window,
					     &values, values_mask);

  if (w_current->xor_gc == NULL) {
    fprintf(stderr, _("Couldn't allocate xor_gc\n"));
    exit(-1);
  }

  values.foreground = white;
  values.background = black;

  values.function = GDK_XOR;
  values_mask = GDK_GC_FOREGROUND | GDK_GC_BACKGROUND | GDK_GC_FUNCTION;
  w_current->outline_xor_gc = gdk_gc_new_with_values(w_current->window,
						     &values, values_mask);

  if (w_current->outline_xor_gc == NULL) {
    fprintf(stderr, _("Couldn't allocate outline_xor_gc\n"));
    exit(-1);
  }

  values.foreground = white;
  values.background = black;

  values.function = GDK_XOR;
  values.line_style = GDK_LINE_ON_OFF_DASH;
  values_mask = GDK_GC_FOREGROUND | GDK_GC_BACKGROUND |
      GDK_GC_LINE_STYLE | GDK_GC_FUNCTION;

  w_current->bounding_xor_gc = gdk_gc_new_with_values(w_current->window,
						      &values,
						      values_mask);

  if (w_current->bounding_xor_gc == NULL) {
    fprintf(stderr, _("Couldn't allocate bounding_xor_gc\n"));
    exit(-1);
  }

  w_current->bus_gc = gdk_gc_new(w_current->window);

  if (w_current->bus_gc == NULL) {
    fprintf(stderr, _("Couldn't allocate bus_gc\n"));
    exit(-1);
  }
}


#line 552 "../noweb/x_window.nw"
void x_window_free_gc(TOPLEVEL * w_current)
{
  gdk_gc_unref(w_current->gc);
  gdk_gc_unref(w_current->xor_gc);
  gdk_gc_unref(w_current->bounding_xor_gc);
  gdk_gc_unref(w_current->outline_xor_gc);
}


#line 571 "../noweb/x_window.nw"
void x_window_create_drawing(GtkWidget * drawbox, TOPLEVEL * w_current)
{
  /* drawing next */
  w_current->drawing_area = gtk_drawing_area_new();
  /* Set the size here.  Be sure that it has an aspect ratio of 1.333
   * We could calculate this based on root window size, but for now
   * lets just set it to:
   * Width = root_width*3/4   Height = Width/1.3333333333
   * 1.3333333 is the desired aspect ratio!
   */

  gtk_drawing_area_size(GTK_DRAWING_AREA(w_current->drawing_area),
			w_current->win_width, w_current->win_height);

  gtk_box_pack_start(GTK_BOX(drawbox), w_current->drawing_area,
		     TRUE, TRUE, 0);
  gtk_widget_show(w_current->drawing_area);

}


#line 603 "../noweb/x_window.nw"
void x_window_setup_draw_events(TOPLEVEL * w_current)
{

  /* is the configure event type missing here? hack */
  gtk_widget_set_events(w_current->drawing_area,
			GDK_EXPOSURE_MASK |
			GDK_POINTER_MOTION_MASK |
			GDK_BUTTON_PRESS_MASK |
			GDK_ENTER_NOTIFY_MASK |
			GDK_KEY_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  gtk_signal_connect(GTK_OBJECT(w_current->drawing_area),
		     "expose_event",
		     GTK_SIGNAL_FUNC(x_event_expose), w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->drawing_area),
		     "button_press_event",
		     (GtkSignalFunc) x_event_button_pressed, w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->drawing_area),
		     "button_release_event",
		     (GtkSignalFunc) x_event_button_released, w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->drawing_area),
		     "motion_notify_event",
		     (GtkSignalFunc) x_event_motion, w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->drawing_area),
		     "configure_event",
		     (GtkSignalFunc) x_event_configure, w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->main_window),
		     "enter_notify_event",
		     (GtkSignalFunc) x_event_enter, w_current);

  gtk_signal_connect(GTK_OBJECT(w_current->main_window),
		     "key_press_event",
		     (GtkSignalFunc) x_event_key_press, w_current);
}



#line 663 "../noweb/x_window.nw"
static GtkWidget *x_window_new_pixmap(char *filename, GdkWindow * window,
				      GdkColor * background)
{
  GtkWidget *wpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  pixmap = gdk_pixmap_create_from_xpm(window, &mask, background, filename);
#ifdef HAS_GTK22
  wpixmap = gtk_image_new_from_pixmap(pixmap, mask);
#else
  wpixmap = gtk_pixmap_new(pixmap, mask);
#endif

  return wpixmap;
}

#line 691 "../noweb/x_window.nw"
void x_window_create_main(TOPLEVEL * w_current)
{
  GtkWidget *label = NULL;
  GtkWidget *main_box = NULL;
  GtkWidget *menubar = NULL;
  GtkWidget *drawbox = NULL;
  GtkWidget *bottom_box = NULL;
  GtkWidget *toolbar = NULL;
  GtkWidget *handlebox = NULL;
  char *filename = NULL;

  /* used to signify that the window isn't mapped yet */
  w_current->window = NULL;

  w_current->main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_widget_set_name(w_current->main_window, "gschem");
  gtk_window_set_policy(GTK_WINDOW(w_current->main_window), TRUE, TRUE,
			TRUE);

  /* We want the widgets to flow around the drawing area, so we don't
   * set a size of the main window.  The drawing area's size is fixed,
   * see below
   */
  /* commented out so that window manager prompts for the location
   * gtk_widget_set_uposition (w_current->main_window, 0, 0);
   */

  /* I could not get the destroy signal to work. always got a: */
  /* Gdk-ERROR **: an x io error occurred */
  /* aborting... */
  /* message */
#if 0
  gtk_signal_connect(GTK_OBJECT(w_current->main_window), "destroy",
		     GTK_SIGNAL_FUNC(i_callback_destroy_wm), w_current);
#endif

  /* this should work fine */
  gtk_signal_connect(GTK_OBJECT(w_current->main_window), "delete_event",
		     GTK_SIGNAL_FUNC(i_callback_close_wm), w_current);

  /* Containers first */
  main_box = gtk_vbox_new(FALSE, 1);
  gtk_container_border_width(GTK_CONTAINER(main_box), 0);
  gtk_container_add(GTK_CONTAINER(w_current->main_window), main_box);
  gtk_widget_show(main_box);

  get_main_menu(w_current, &menubar);
  if (w_current->handleboxes) {
    handlebox = gtk_handle_box_new();
    gtk_box_pack_start(GTK_BOX(main_box), handlebox, FALSE, FALSE, 0);
    gtk_widget_show(handlebox);
    gtk_container_add(GTK_CONTAINER(handlebox), menubar);
  } else {
    gtk_box_pack_start(GTK_BOX(main_box), menubar, FALSE, FALSE, 0);
  }

  w_current->menubar = menubar;
  gtk_widget_show(menubar);
  gtk_widget_realize(w_current->main_window);

  if (w_current->handleboxes && w_current->toolbars) {
    handlebox = gtk_handle_box_new();
    gtk_box_pack_start(GTK_BOX(main_box), handlebox, FALSE, FALSE, 0);
  }

  if (w_current->toolbars) {
#ifdef HAS_GTK22
    toolbar = gtk_toolbar_new();
    gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar),
				GTK_ORIENTATION_HORIZONTAL);
    gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);
#else
    toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,
			      GTK_TOOLBAR_ICONS);
    gtk_container_set_border_width(GTK_CONTAINER(toolbar), 5);
    gtk_toolbar_set_space_size(GTK_TOOLBAR(toolbar), 5);
    gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
    gtk_toolbar_set_space_style(GTK_TOOLBAR(toolbar),
				GTK_TOOLBAR_SPACE_LINE);
#endif

    if (w_current->handleboxes) {
      gtk_container_add(GTK_CONTAINER(handlebox), toolbar);
    } else {
      gtk_box_pack_start(GTK_BOX(main_box), toolbar, FALSE, FALSE, 0);
    }

    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-new.xpm", NULL);
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), _("New"), _("New file"),
			    "toolbar/new", x_window_new_pixmap(filename,
							       w_current->
							       main_window->
							       window,
							       &w_current->
							       main_window->
							       style->
							       bg
							       [GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_file_new,
			    w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-open.xpm", NULL);
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), _("Open"),
			    _("Open file..."), "toolbar/open",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_file_open,
			    w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-save.xpm", NULL);
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), _("Save"),
			    _("Save file"), "toolbar/save",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_file_save,
			    w_current);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-undo.xpm", NULL);
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), _("Undo"),
			    _("Undo last operation"), "toolbar/undo",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_edit_undo,
			    w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-redo.xpm", NULL);
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), _("Redo"),
			    _("Redo last undo"), "toolbar/redo",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_edit_redo,
			    w_current);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-comp.xpm", NULL);
    /* not part of any radio button group */
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
			    _("Component"),
			    _
			    ("Add component...\nSelect library and component from list, move the mouse into main window, click to place\nRight mouse button to cancel"),
			    "toolbar/component",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc)
			    i_callback_toolbar_add_component, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-net.xpm", NULL);
    w_current->toolbar_net =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON, NULL,
				   _("Nets"),
				   _
				   ("Add nets mode\nRight mouse button to cancel"),
				   "toolbar/nets",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc)
				   i_callback_toolbar_add_net, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-bus.xpm", NULL);
    w_current->toolbar_bus =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_net, _("Bus"),
				   _
				   ("Add buses mode\nRight mouse button to cancel"),
				   "toolbar/bus",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc)
				   i_callback_toolbar_add_bus, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-text.xpm", NULL);
    /* not part of any radio button group */
    gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
			    _("Text"),
			    _("Add Text..."),
			    "toolbar/text",
			    x_window_new_pixmap(filename,
						w_current->main_window->
						window,
						&w_current->main_window->
						style->
						bg[GTK_STATE_NORMAL]),
			    (GtkSignalFunc) i_callback_toolbar_add_text,
			    w_current);

    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-select.xpm", NULL);
    w_current->toolbar_select =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_bus, _("Select"),
				   _("Select mode"), "toolbar/select",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc)
				   i_callback_toolbar_edit_select,
				   w_current);
    free(filename);

#if 0				/* out until they work */
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-edit.xpm", NULL);
    w_current->toolbar_edit =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_select, _("Edit"),
				   _("Edit mode"), "toolbar/edit",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-move.xpm", NULL);
    w_current->toolbar_edit =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_edit, _("Move"),
				   _("Move mode"), "toolbar/move",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-copy.xpm", NULL);
    w_current->toolbar_edit =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_edit, _("Copy"),
				   _("Copy mode"), "toolbar/copy",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-delete.xpm", NULL);
    w_current->toolbar_delete =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_edit, _("Delete"),
				   _("Delete mode"), "toolbar/delete",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-rotate.xpm", NULL);
    w_current->toolbar_rotate =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_delete, _("Rotate"),
				   _("Rotate mode"), "toolbar/rotate",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
    filename = u_basic_strdup_multiple(w_current->bitmap_directory,
				       PATH_SEPARATER_STRING,
				       "gschem-mirror.xpm", NULL);
    w_current->toolbar_mirror =
	gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
				   GTK_TOOLBAR_CHILD_RADIOBUTTON,
				   w_current->toolbar_rotate, _("Mirror"),
				   _("Mirror mode"), "toolbar/mirror",
				   x_window_new_pixmap(filename,
						       w_current->
						       main_window->window,
						       &w_current->
						       main_window->style->
						       bg
						       [GTK_STATE_NORMAL]),
				   (GtkSignalFunc) NULL, w_current);
    free(filename);
#endif

    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				 (w_current->toolbar_select), TRUE);
    gtk_widget_show(toolbar);
  }

  if (w_current->handleboxes) {
    gtk_widget_show(handlebox);
  }

  get_main_popup(w_current, &(w_current->popup_menu));

  drawbox = gtk_hbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(drawbox), 0);
  gtk_container_add(GTK_CONTAINER(main_box), drawbox);
  gtk_widget_show(drawbox);

  x_window_create_drawing(drawbox, w_current);
  x_window_setup_draw_events(w_current);

  if (w_current->scrollbars_flag == TRUE) {
    /* setup scroll bars */
    w_current->v_adjustment =
	gtk_adjustment_new(w_current->init_bottom,
			   0.0, w_current->init_bottom,
			   100.0, 100.0, 10.0);

    w_current->v_scrollbar =
	gtk_vscrollbar_new(GTK_ADJUSTMENT(w_current->v_adjustment));

    gtk_range_set_update_policy(GTK_RANGE(w_current->v_scrollbar),
				GTK_UPDATE_CONTINUOUS);

    gtk_box_pack_start(GTK_BOX(drawbox), w_current->v_scrollbar,
		       FALSE, FALSE, 0);

    gtk_signal_connect(GTK_OBJECT(w_current->v_adjustment),
		       "value_changed",
		       GTK_SIGNAL_FUNC(x_event_vschanged), w_current);

    gtk_widget_show(w_current->v_scrollbar);

    w_current->h_adjustment = gtk_adjustment_new(0.0, 0.0,
						 w_current->init_right,
						 100.0, 100.0, 10.0);

    w_current->h_scrollbar =
	gtk_hscrollbar_new(GTK_ADJUSTMENT(w_current->h_adjustment));

    gtk_range_set_update_policy(GTK_RANGE(w_current->h_scrollbar),
				GTK_UPDATE_CONTINUOUS);

    gtk_box_pack_start(GTK_BOX(main_box), w_current->h_scrollbar,
		       FALSE, FALSE, 0);

    gtk_signal_connect(GTK_OBJECT(w_current->h_adjustment),
		       "value_changed",
		       GTK_SIGNAL_FUNC(x_event_hschanged), w_current);

    gtk_widget_show(w_current->h_scrollbar);
  }

  /* bottom box */
  bottom_box = gtk_hbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(bottom_box), 1);
  gtk_box_pack_start(GTK_BOX(main_box), bottom_box, FALSE, FALSE, 0);
  gtk_widget_show(bottom_box);

  /*    label = gtk_label_new ("Mouse buttons:");
     gtk_box_pack_start (GTK_BOX (bottom_box), label, FALSE, FALSE, 10);
     gtk_widget_show (label);
   */

  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(bottom_box), label, FALSE, FALSE, 2);
  gtk_widget_show(label);

  w_current->left_label = gtk_label_new(_("Pick"));
  gtk_box_pack_start(GTK_BOX(bottom_box), w_current->left_label,
		     FALSE, FALSE, 0);
  gtk_widget_show(w_current->left_label);

  label = gtk_label_new("|");
  gtk_box_pack_start(GTK_BOX(bottom_box), label, FALSE, FALSE, 5);
  gtk_widget_show(label);

  if (w_current->middle_button == STROKE) {
#ifdef HAS_LIBSTROKE
    w_current->middle_label = gtk_label_new(_("Stroke"));
#else
    w_current->middle_label = gtk_label_new(_("none"));
#endif
  } else if (w_current->middle_button == ACTION) {
    w_current->middle_label = gtk_label_new(_("Action"));
  } else {
    w_current->middle_label = gtk_label_new(_("Repeat/none"));
  }

  gtk_box_pack_start(GTK_BOX(bottom_box), w_current->middle_label,
		     FALSE, FALSE, 0);
  gtk_widget_show(w_current->middle_label);

  label = gtk_label_new("|");
  gtk_box_pack_start(GTK_BOX(bottom_box), label, FALSE, FALSE, 5);
  gtk_widget_show(label);

  if (default_third_button == POPUP_ENABLED) {
    w_current->right_label = gtk_label_new(_("Menu/Cancel"));
  } else {
    w_current->right_label = gtk_label_new(_("Pan/Cancel"));
  }
  gtk_box_pack_start(GTK_BOX(bottom_box), w_current->right_label,
		     FALSE, FALSE, 0);
  gtk_widget_show(w_current->right_label);

  label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(bottom_box), label, FALSE, FALSE, 5);
  gtk_widget_show(label);

  w_current->filename_label = gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(bottom_box), w_current->filename_label,
		     FALSE, FALSE, 10);
  gtk_widget_show(w_current->filename_label);

  w_current->status_label = gtk_label_new(_("Select Mode"));
  gtk_box_pack_end(GTK_BOX(bottom_box), w_current->status_label, FALSE,
		   FALSE, 10);
  gtk_widget_show(w_current->status_label);

  gtk_widget_show(w_current->main_window);

  w_current->window = w_current->drawing_area->window;

  /* draw a black rectangle in drawing area just to make it look nice */
  /* don't do this now */
  /* gdk_draw_rectangle(window, main_window->style->black_gc, TRUE, 0, 0,
   *                            win_width, win_height);
   *
   */

  w_current->backingstore = gdk_pixmap_new(w_current->window,
					   w_current->drawing_area->
					   allocation.width,
					   w_current->drawing_area->
					   allocation.height, -1);
  x_window_setup_gc(w_current);
}


#line 1176 "../noweb/x_window.nw"
TOPLEVEL *x_window_create_new(void)
{
  TOPLEVEL *w_current = NULL;

  /* allocate new window structure */
  w_current = (TOPLEVEL *) malloc(sizeof(TOPLEVEL));

  /* do init var fill in */
  x_window_setup_rest(w_current);

  /* immediately setup user params */
  i_vars_set(w_current);

  w_current->wid = global_wid;

  /* make sure none of these events happen till we are done */
  w_current->DONT_DRAW_CONN = 1;
  w_current->DONT_RESIZE = 1;
  w_current->DONT_EXPOSE = 1;
  w_current->DONT_RECALC = 1;

  /* the default coord sizes */
  /* real ones set in rc file */
  w_current->init_right = default_init_right;
  w_current->init_bottom = default_init_bottom;

#if 1				/* X related stuff */
  w_current->display_height = gdk_screen_height();
  w_current->display_width = gdk_screen_width();
#endif

  x_window_setup_world(w_current);

#if 1				/* X related stuff */
  /* do X fill in first */
  x_window_create_main(w_current);
#endif

  /* Put head node on page list... be sure to free this somewhere hack */
  s_page_add_head(w_current);

  /* Now create a blank page */
  w_current->page_tail = s_page_add(w_current,
				    w_current->page_tail, "unknown");
  /* this is correct */

  s_page_setup(w_current->page_tail);

  /* setup page_current link */
  w_current->page_current = w_current->page_tail;

  /* Special case init */
  /* move this elsewhere eventually */
  /* w_current->page_current->object_parent=NULL; not this one */
  w_current->page_current->object_lastplace = NULL;
  w_current->page_current->object_selected = NULL;
  set_window(w_current, w_current->init_left, w_current->init_right,
	     w_current->init_top, w_current->init_bottom);

  o_undo_savestate(w_current, UNDO_ALL);
  i_update_menus(w_current);

  /* now update the scrollbars */
  w_current->DONT_REDRAW = 1;
  x_hscrollbar_update(w_current);
  x_vscrollbar_update(w_current);
  w_current->DONT_REDRAW = 0;

  global_wid++;
  num_windows++;

  window_tail = x_window_add(window_tail, w_current);

  /* renable the events */
  w_current->DONT_DRAW_CONN = 0;
  w_current->DONT_RESIZE = 0;
  w_current->DONT_EXPOSE = 0;
  w_current->DONT_RECALC = 0;

  return (w_current);
}


#line 1270 "../noweb/x_window.nw"
void x_window_close(TOPLEVEL * w_current)
{

  if (s_page_check_changed(w_current->page_head)) {
    exit_dialog(w_current);
    return;
  }
#if DEBUG
  o_conn_print_hash(w_current->page_current->conn_table);
#endif

  /* make sure window_tail stays correct and doesn't dangle */
  /* window_head can't dangle since it has a head node, which is */
  /* NEVER deallocated (only at the very end) */
  if (window_tail == w_current) {
    window_tail = w_current->prev;
  }

  /* close all the dialog boxes */
  if (w_current->fowindow)
    gtk_widget_destroy(w_current->fowindow);

  if (w_current->sowindow)
    gtk_widget_destroy(w_current->sowindow);

  if (w_current->fswindow)
    gtk_widget_destroy(w_current->fswindow);

  if (w_current->aswindow)
    gtk_widget_destroy(w_current->aswindow);

  if (w_current->cswindow)
    gtk_widget_destroy(w_current->cswindow);

  if (w_current->tiwindow)
    gtk_widget_destroy(w_current->tiwindow);

  if (w_current->tewindow)
    gtk_widget_destroy(w_current->tewindow);

  if (w_current->aawindow)
    gtk_widget_destroy(w_current->aawindow);

  if (w_current->mawindow)
    gtk_widget_destroy(w_current->mawindow);

  if (w_current->aewindow)
    gtk_widget_destroy(w_current->aewindow);

  if (w_current->trwindow)
    gtk_widget_destroy(w_current->trwindow);

  if (w_current->pswindow)
    gtk_widget_destroy(w_current->pswindow);

  if (w_current->exwindow)
    gtk_widget_destroy(w_current->exwindow);

  if (w_current->tswindow)
    gtk_widget_destroy(w_current->tswindow);

  if (w_current->abwindow)
    gtk_widget_destroy(w_current->abwindow);

  if (w_current->iwindow)
    gtk_widget_destroy(w_current->iwindow);

  if (w_current->pwindow)
    gtk_widget_destroy(w_current->pwindow);

  if (w_current->hkwindow)
    gtk_widget_destroy(w_current->hkwindow);

  if (w_current->cowindow)
    gtk_widget_destroy(w_current->cowindow);

  if (w_current->clwindow)
    gtk_widget_destroy(w_current->clwindow);

  if (w_current->ltwindow)
    gtk_widget_destroy(w_current->ltwindow);

  if (w_current->sewindow)
    gtk_widget_destroy(w_current->sewindow);

  if (w_current->fileselect[FILESELECT].xfwindow) {
    gtk_widget_destroy(w_current->fileselect[FILESELECT].xfwindow);
  }

  if (w_current->fileselect[COMPSELECT].xfwindow) {
    gtk_widget_destroy(w_current->fileselect[COMPSELECT].xfwindow);
  }

  x_fileselect_free_list_buffers(&w_current->fileselect[FILESELECT]);
  x_fileselect_free_list_buffers(&w_current->fileselect[COMPSELECT]);

  o_attrib_free_current(w_current);
  o_complex_free_filename(w_current);

  if (w_current->series_name) {
    free(w_current->series_name);
    w_current->series_name = NULL;
  }

  if (w_current->untitled_name) {
    free(w_current->untitled_name);
    w_current->untitled_name = NULL;
  }

  if (w_current->font_directory) {
    free(w_current->font_directory);
    w_current->font_directory = NULL;
  }

  if (w_current->scheme_directory) {
    free(w_current->scheme_directory);
    w_current->scheme_directory = NULL;
  }

  if (w_current->bitmap_directory) {
    free(w_current->bitmap_directory);
    w_current->bitmap_directory = NULL;
  }

  if (w_current->bus_ripper_symname) {
    free(w_current->bus_ripper_symname);
    w_current->bus_ripper_symname = NULL;
  }

  /* stuff that has to be done before we free w_current */
  if ((num_windows - 1) == 0) {
    /* free all fonts */
    o_text_freeallfonts(w_current);
    /* close the log file */
    s_log_close();
    /* free the buffers */
    o_buffer_free(w_current);
  }

  x_window_delete(window_head, w_current);
  if (w_current->backingstore) {
    gdk_pixmap_unref(w_current->backingstore);
  }

  x_window_free_gc(w_current);

  /* finally close the main window */
  gtk_widget_destroy(w_current->main_window);

  num_windows = num_windows - 1;

  free(w_current);

  /* just closed last window, so quit */
  if (num_windows == 0) {
    gschem_quit();
  }
}


#line 1441 "../noweb/x_window.nw"
void x_window_close_all()
{
  TOPLEVEL *w_current;
  TOPLEVEL *w_prev;

  w_current = window_tail;

  /* loop over all windows to close */
  /* going backwards */
  /* wid == -1 is the head and we are done. */
  while (w_current != NULL && w_current->wid != -1) {
    w_prev = w_current->prev;
    x_window_close(w_current);
    w_current = w_prev;
  }

  /* now free the head */
  /* only if all the windows are gone */

  if (window_head->next == NULL && num_windows == 0) {
    x_window_free_head();
  }
}


#line 1476 "../noweb/x_window.nw"
TOPLEVEL *x_window_get_ptr(int wid)
{
  TOPLEVEL *w_current;

  w_current = window_head;

  while (w_current != NULL) {
    if (w_current->wid == wid) {
      return (w_current);
    }

    w_current = w_current->next;
  }

  return (NULL);
}


#line 1504 "../noweb/x_window.nw"
/* GROSS! but this is required because clist widgets don't seem to allow you
 * pass data to callback functions, so I need to get w_current by searching
 * the entire window list for page_clist widget :(  If somebody knows a better
 * way of doing this, please let me know!
 */
TOPLEVEL *x_window_search_page_clist(GtkWidget * findme)
{
  TOPLEVEL *w_current;

  w_current = window_head;

  while (w_current != NULL) {
    if (w_current->page_clist == findme) {
      return (w_current);
    }

    w_current = w_current->next;
  }

  return (NULL);
}
