#line 22 "../noweb/gschem.nw"
/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/gschem.nw"
/* DO NOT read or edit this file ! Use ../noweb/gschem.nw instead */

#line 45 "../noweb/gschem.nw"
#include <config.h>

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/i_vars.h"
#include "../include/prototype.h"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#ifdef HAS_LIBSTROKE
/* libstroke prototype */
void stroke_init(void);
#endif

#line 79 "../noweb/gschem.nw"
void gschem_quit(void)
{
  s_clib_cache_free();
  s_clib_free();
  s_slib_free();
  s_menu_free();
  /* o_text_freeallfonts(); */
  s_attrib_free();
  s_papersizes_free();
  x_stroke_free_all();
  x_dialog_hotkeys_free_all();
  s_color_destroy_all();
  o_undo_cleanup();
  /* s_stroke_free(); no longer needed */

  free(default_series_name);
  free(default_untitled_name);
  free(default_font_directory);
  free(default_scheme_directory);
  free(default_bitmap_directory);
  free(default_bus_ripper_symname);

  /* x_window_free_head(); can't do this since it causes a
   * condition in which window_head->... is still being refered
   * after this */

  /* enable this to get more memory usage from glib */
  /* You also have to enable something in glib I think */
  /* g_mem_profile(); */


  x_log_free();
  gtk_main_quit();
}


#line 125 "../noweb/gschem.nw"
void main_prog(int argc, char *argv[])
{
  int i;
  char *cwd;
  TOPLEVEL *w_current;
  char *input_str = NULL;
  int argv_index;
  int first_page = 1;
  char *geda_data;

#if ENABLE_NLS
  gtk_set_locale();
  /* This must be the same for all locales */
  setlocale(LC_NUMERIC, "POSIX");
#endif

  gtk_init(&argc, &argv);
  visual = gdk_visual_get_system();

  argv_index = parse_commandline(argc, argv);
  cwd = getcwd(NULL, 1024);
#ifdef __MINGW32__
  u_basic_strip_trailing(cwd, PATH_SEPARATER_CHAR);
#endif

  libgeda_init();

  /* TODO: Probably the file name shuold be defined elsewhere */
  /* create log file right away even if logging is enabled */
  x_log_init(cwd, "gschem.log");
  s_log_init(cwd, "gschem.log");

#ifdef HAS_LIBSTROKE
  stroke_init();		/* libstroke function */
  /* s_stroke_init(); no longer needed libgeda function */
#endif

  s_log_message(_("gEDA/gschem version %s\n"), VERSION);
  s_log_message(_
		("gEDA/gschem comes with ABSOLUTELY NO WARRANTY; see COPYING for more details.\n"));
  s_log_message(_
		("This is free software, and you are welcome to redistribute it under certain\n"));
  s_log_message(_
		("conditions; please see the COPYING file for more details.\n\n"));

  if (!quiet_mode) {
    fprintf(stderr, _("gEDA/gschem version %s\n"), VERSION);
    fprintf(stderr,
	    _
	    ("gEDA/gschem comes with ABSOLUTELY NO WARRANTY; see COPYING for more details.\n"));
    fprintf(stderr,
	    _
	    ("This is free software, and you are welcome to redistribute it under certain\n"));
    fprintf(stderr,
	    _
	    ("conditions; please see the COPYING file for more details.\n\n"));
  }
#ifdef __MINGW32__
  fprintf(stderr, _("This is the MINGW32 port.\n"));
#endif

#if DEBUG
  fprintf(stderr, _("Current locale settings: %s\n"),
	  setlocale(LC_ALL, NULL));
#endif

  /* init global buffers */
  o_buffer_init();

  /* register guile (scheme) functions */
  g_register_funcs();

  s_clib_init();
  s_slib_init();
  s_menu_init();
  s_attrib_init();
  s_color_init();
  o_undo_init();

  geda_data = getenv("GEDADATA");
  if (geda_data == NULL) {
    fprintf(stderr,
	    _("You must set the GEDADATA environment variable!\n"));
    exit(-1);
  }


  g_rc_parse();


  input_str = g_strdup_printf("%s%cgschem.scm", default_scheme_directory,
			      PATH_SEPARATER_CHAR);
  if (g_read_file(input_str) != -1) {
    s_log_message(_("Read init scm file [%s]\n"), input_str);
  } else {
    /* TODO: These two messages are the same. Should be
     * integrated. */
    s_log_message(_("Failed to read init scm file [%s]\n"), input_str);
    fprintf(stderr, _("Failed to read init scm file [%s]\n"), input_str);
  }
  free(input_str);

  colormap = gdk_colormap_get_system();
  x_window_setup_colors();

  x_window_add_head();

  w_current = x_window_create_new();
  global_window_current = w_current;

  /* so we can call key funcs from guile */
  set_window_current_key(w_current);

  /* o_text_init(); goes away */
  o_text_init();

  x_repaint_background(w_current);

  i = argv_index;
  while (argv[i] != NULL) {
    if (first_page) {
      if (w_current->page_current->page_filename) {
	free(w_current->page_current->page_filename);
      }

      /* Page structure has already been created...
       * so, just set the filename and open the
       * schematic for the first page */

#ifdef __MINGW32__
      if (argv[i][1] == ':' && (argv[i][2] == PATH_SEPARATER_CHAR ||
				argv[i][2] == OTHER_PATH_SEPARATER_CHAR)) {
#else
      if (argv[i][0] == PATH_SEPARATER_CHAR) {
#endif
	w_current->page_current->page_filename =
	    u_basic_strdup_multiple(argv[i], NULL);
      } else {
	w_current->page_current->page_filename =
	    u_basic_strdup_multiple(cwd, PATH_SEPARATER_STRING, argv[i],
				    NULL);
      }

      if (!quiet_mode) {
	printf(_("Loading schematic [%s]\n"), argv[i]);
      }

      (void) f_open(w_current, w_current->page_current->page_filename);
      i_set_filename(w_current, w_current->page_current->page_filename);

      a_zoom_extents(w_current,
		     w_current->page_current->object_head,
		     A_PAN_DONT_REDRAW);
      o_undo_savestate(w_current, UNDO_ALL);

      first_page = 0;
    } else {
      /* Much simpler   */

      /* create new page, and only load if page not loaded */
      if (!s_page_new(w_current, argv[i])) {
	if (!quiet_mode) {
	  printf(_("Loading schematic [%s]\n"), argv[i]);
	}
	(void) f_open(w_current, w_current->page_current->page_filename);
	i_set_filename(w_current, w_current->page_current->page_filename);
	a_zoom_extents(w_current,
		       w_current->page_current->object_head,
		       A_PAN_DONT_REDRAW);
	o_undo_savestate(w_current, UNDO_ALL);
      }
    }
    i++;
  }

  free(cwd);

  if (argv[argv_index] == NULL) {
    if (w_current->page_current->page_filename) {
      free(w_current->page_current->page_filename);
    }

    getcwd(w_current->cwd, 256);
#ifdef __MINGW32__
    u_basic_strip_trailing(w_current->cwd, PATH_SEPARATER_CHAR);
#endif

    w_current->page_current->page_filename =
	malloc(sizeof(char) * (strlen(w_current->cwd) +
			       strlen(w_current->untitled_name) +
			       strlen("/_##########.sch") + 1));

    w_current->num_untitled++;
    sprintf(w_current->page_current->page_filename,
	    "%s%c%s_%d.sch",
	    w_current->cwd, PATH_SEPARATER_CHAR,
	    w_current->untitled_name, w_current->num_untitled);

    i_set_filename(w_current, w_current->page_current->page_filename);
  }

  x_scrollbars_update(w_current);
  o_redraw_all_fast(w_current);

#if DEBUG
  gh_eval_str("(display \"hello guile\n\")");
#endif

  if (w_current->scheme_directory == NULL) {
    fprintf(stderr, _("Scheme directory NOT set!\n"));
    exit(-1);
  }


  /* Execute a script if it exists */
  if (script_filename) {
    s_log_message(_("Executing guile script [%s]\n"), script_filename);
    g_read_file(script_filename);
  }

  /* open up log window on startup */
  if (w_current->log_window == MAP_ON_STARTUP) {
    x_log_setup_win(w_current);
  }

  /* enter main loop */
  gtk_main();
}


#line 375 "../noweb/gschem.nw"
int main(int argc, char *argv[])
{
#if ENABLE_NLS
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
#ifdef HAS_GTK22
  bind_textdomain_codeset(PACKAGE, "UTF-8");
#endif
#endif

  /* disable the deprecated warnings in guile 1.6.3 */
  /* Eventually the warnings will need to be fixed */
  if (getenv("GUILE_WARN_DEPRECATED") == NULL)
    putenv("GUILE_WARN_DEPRECATED=no");

  gh_enter(argc, argv, main_prog);
  return 0;
}
