/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  struct {int value; int mask;} yy405;
  IdList* yy432;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 589
#define YYNRULE 313
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor;

/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   292,  903,  124,  588,  409,  172,    2,  418,   61,   61,
 /*    10 */    61,   61,  519,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  210,  447,  212,  425,  431,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  210,
 /*    40 */   391,  388,  396,  451,   60,   59,  297,  435,  436,  432,
 /*    50 */   432,   62,   62,   61,   61,   61,   61,  263,   63,   63,
 /*    60 */    63,   63,   64,   64,   65,   65,   65,   66,  210,  292,
 /*    70 */   493,  494,  418,  489,  208,   82,   67,  420,   69,  154,
 /*    80 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*    90 */   210,   67,  462,   69,  154,  425,  431,  574,  264,   58,
 /*   100 */    64,   64,   65,   65,   65,   66,  210,  397,  398,  422,
 /*   110 */   422,  422,  292,   60,   59,  297,  435,  436,  432,  432,
 /*   120 */    62,   62,   61,   61,   61,   61,  317,   63,   63,   63,
 /*   130 */    63,   64,   64,   65,   65,   65,   66,  210,  425,  431,
 /*   140 */    94,   65,   65,   65,   66,  210,  396,  210,  414,   34,
 /*   150 */    56,  298,  442,  443,  410,  418,   60,   59,  297,  435,
 /*   160 */   436,  432,  432,   62,   62,   61,   61,   61,   61,  208,
 /*   170 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   180 */   210,  292,  372,  524,  295,  572,  113,  408,  522,  451,
 /*   190 */   331,  317,  407,   20,  244,  340,  519,  396,  478,  531,
 /*   200 */   505,  447,  212,  571,  570,  245,  530,  425,  431,  149,
 /*   210 */   150,  397,  398,  414,   41,  211,  151,  533,  488,  489,
 /*   220 */   418,  568,  569,  420,  292,   60,   59,  297,  435,  436,
 /*   230 */   432,  432,   62,   62,   61,   61,   61,   61,  317,   63,
 /*   240 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  210,
 /*   250 */   425,  431,  447,  333,  215,  422,  422,  422,  363,  299,
 /*   260 */   414,   41,  397,  398,  366,  567,  211,  292,   60,   59,
 /*   270 */   297,  435,  436,  432,  432,   62,   62,   61,   61,   61,
 /*   280 */    61,  396,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   290 */    65,   66,  210,  425,  431,  491,  300,  524,  474,   66,
 /*   300 */   210,  214,  474,  229,  411,  286,  534,   20,  449,  523,
 /*   310 */   168,   60,   59,  297,  435,  436,  432,  432,   62,   62,
 /*   320 */    61,   61,   61,   61,  474,   63,   63,   63,   63,   64,
 /*   330 */    64,   65,   65,   65,   66,  210,  209,  480,  317,   77,
 /*   340 */   292,  239,  300,   55,  484,  490,  397,  398,  181,  547,
 /*   350 */   494,  345,  348,  349,   67,  152,   69,  154,  339,  524,
 /*   360 */   414,   35,  350,  241,  221,  370,  425,  431,  579,   20,
 /*   370 */   164,  118,  243,  343,  248,  344,  176,  322,  442,  443,
 /*   380 */   414,    3,   80,  252,   60,   59,  297,  435,  436,  432,
 /*   390 */   432,   62,   62,   61,   61,   61,   61,  174,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  210,  292,
 /*   410 */   221,  550,  236,  487,  510,  353,  317,  118,  243,  343,
 /*   420 */   248,  344,  176,  181,  317,  532,  345,  348,  349,  252,
 /*   430 */   223,  415,  155,  464,  511,  425,  431,  350,  414,   34,
 /*   440 */   465,  211,  177,  175,  160,  525,  414,   34,  338,  549,
 /*   450 */   449,  323,  168,   60,   59,  297,  435,  436,  432,  432,
 /*   460 */    62,   62,   61,   61,   61,   61,  415,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  210,  292,  542,
 /*   480 */   335,  517,  504,  541,  456,  572,  302,   19,  331,  144,
 /*   490 */   317,  390,  317,  330,    2,  362,  457,  294,  483,  373,
 /*   500 */   269,  268,  252,  571,  425,  431,  589,  391,  388,  458,
 /*   510 */   208,  495,  414,   49,  414,   49,  303,  586,  894,  230,
 /*   520 */   894,  496,   60,   59,  297,  435,  436,  432,  432,   62,
 /*   530 */    62,   61,   61,   61,   61,  201,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  210,  292,  317,  181,
 /*   550 */   439,  255,  345,  348,  349,  370,  153,  583,  308,  251,
 /*   560 */   309,  452,   76,  350,   78,  382,  211,  426,  427,  415,
 /*   570 */   414,   27,  319,  425,  431,  440,    1,   22,  586,  893,
 /*   580 */   396,  893,  544,  478,  320,  263,  438,  438,  429,  430,
 /*   590 */   415,   60,   59,  297,  435,  436,  432,  432,   62,   62,
 /*   600 */    61,   61,   61,   61,  237,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  210,  292,  428,  583,  374,
 /*   620 */   224,   93,  517,    9,  159,  396,  557,  396,  456,   67,
 /*   630 */   396,   69,  154,  399,  400,  401,  320,  328,  438,  438,
 /*   640 */   457,  336,  425,  431,  361,  397,  398,  320,  433,  438,
 /*   650 */   438,  582,  291,  458,  238,  327,  318,  222,  546,  292,
 /*   660 */    60,   59,  297,  435,  436,  432,  432,   62,   62,   61,
 /*   670 */    61,   61,   61,  225,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  210,  425,  431,  482,  313,  392,
 /*   690 */   397,  398,  397,  398,  207,  397,  398,  825,  273,  517,
 /*   700 */   251,  200,  292,   60,   59,  297,  435,  436,  432,  432,
 /*   710 */    62,   62,   61,   61,   61,   61,  470,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  210,  425,  431,
 /*   730 */   171,  160,  263,  263,  304,  415,  276,  395,  274,  263,
 /*   740 */   517,  517,  263,  517,  192,  292,   60,   70,  297,  435,
 /*   750 */   436,  432,  432,   62,   62,   61,   61,   61,   61,  379,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   210,  425,  431,  384,  559,  305,  306,  251,  415,  320,
 /*   780 */   560,  438,  438,  561,  540,  360,  540,  387,  292,  196,
 /*   790 */    59,  297,  435,  436,  432,  432,   62,   62,   61,   61,
 /*   800 */    61,   61,  371,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  210,  425,  431,  396,  275,  251,  251,
 /*   820 */   172,  250,  418,  415,  386,  367,  178,  179,  180,  469,
 /*   830 */   311,  123,  156,    5,  297,  435,  436,  432,  432,   62,
 /*   840 */    62,   61,   61,   61,   61,  317,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,  210,   72,  324,  194,
 /*   860 */     4,  317,  263,  317,  296,  263,  415,  414,   28,  317,
 /*   870 */   257,  317,  321,   72,  324,  317,    4,  119,  165,  177,
 /*   880 */   296,  397,  398,  414,   23,  414,   32,  418,  321,  326,
 /*   890 */   421,  414,   53,  414,   52,  317,  158,  414,   98,  451,
 /*   900 */   317,  263,  317,  277,  317,  326,  378,  471,  261,  317,
 /*   910 */   259,   18,  478,  445,  445,  451,  317,  414,   96,   75,
 /*   920 */    74,  469,  414,  101,  414,  102,  414,  112,   73,  315,
 /*   930 */   316,  414,  114,  420,  294,   75,   74,  481,  414,   16,
 /*   940 */   381,  317,  279,  467,   73,  315,  316,   72,  324,  420,
 /*   950 */     4,  208,  317,  183,  296,  317,  186,  128,   84,  208,
 /*   960 */     8,  341,  321,  414,   99,  422,  422,  422,  423,  424,
 /*   970 */    11,  623,  380,  307,  414,   33,  413,  414,   97,  326,
 /*   980 */   412,  422,  422,  422,  423,  424,   11,  415,  413,  451,
 /*   990 */   415,  162,  412,  317,  499,  500,  226,  227,  228,  104,
 /*  1000 */   448,  476,  317,  173,  507,  317,  509,  508,  317,   75,
 /*  1010 */    74,  329,  205,   21,  281,  414,   24,  418,   73,  315,
 /*  1020 */   316,  282,  317,  420,  414,   54,  460,  414,  115,  317,
 /*  1030 */   414,  116,  502,  203,  147,  549,  514,  468,  128,  202,
 /*  1040 */   317,  473,  204,  317,  414,  117,  317,  477,  317,  584,
 /*  1050 */   317,  414,   25,  317,  249,  422,  422,  422,  423,  424,
 /*  1060 */    11,  506,  414,   36,  512,  414,   37,  317,  414,   26,
 /*  1070 */   414,   38,  414,   39,  526,  414,   40,  317,  254,  317,
 /*  1080 */   128,  317,  418,  317,  256,  377,  278,  268,  585,  414,
 /*  1090 */    42,  293,  317,  352,  317,  128,  208,  513,  258,  414,
 /*  1100 */    43,  414,   44,  414,   29,  414,   30,  545,  260,  128,
 /*  1110 */   317,  553,  317,  173,  414,   45,  414,   46,  317,  262,
 /*  1120 */   383,  554,  317,   91,  564,  317,   91,  317,  581,  189,
 /*  1130 */   290,  357,  414,   47,  414,   48,  267,  365,  368,  369,
 /*  1140 */   414,   31,  270,  271,  414,   10,  272,  414,   50,  414,
 /*  1150 */    51,  556,  566,  280,  283,  284,  578,  146,  419,  405,
 /*  1160 */   231,  505,  444,  325,  516,  463,  163,  446,  552,  394,
 /*  1170 */   466,  563,  246,  515,  518,  520,  402,  403,  404,    7,
 /*  1180 */   314,   84,  232,  334,  347,   83,  332,   57,  170,   79,
 /*  1190 */   213,  461,  125,   85,  337,  342,  492,  502,  497,  301,
 /*  1200 */   498,  416,  105,  219,  247,  218,  503,  501,  233,  220,
 /*  1210 */   287,  234,  527,  528,  235,  529,  417,  521,  354,  288,
 /*  1220 */   184,  121,  185,  240,  535,  475,  242,  356,  187,  479,
 /*  1230 */   188,  358,  537,   88,  190,  548,  364,  193,  132,  376,
 /*  1240 */   555,  375,  133,  134,  135,  310,  562,  138,  136,  575,
 /*  1250 */   576,  577,  580,  100,  393,  406,  217,  142,  624,  625,
 /*  1260 */   103,  141,  265,  166,  167,  434,   71,  453,  441,  437,
 /*  1270 */   450,  143,  538,  157,  120,  454,  161,  472,  455,  169,
 /*  1280 */   459,   81,    6,   12,   13,   92,   95,  126,  216,  127,
 /*  1290 */   111,  485,  486,   17,   86,  346,  106,  122,  253,  107,
 /*  1300 */    87,  108,  182,  245,  355,  145,  351,  536,  129,  359,
 /*  1310 */   312,  130,  543,  173,  539,  266,  191,  109,  289,  551,
 /*  1320 */   195,   14,  131,  198,  197,  558,  137,  199,  139,  140,
 /*  1330 */    15,  565,   89,   90,  573,  110,  385,  206,  148,  389,
 /*  1340 */   285,  587,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,   78,   79,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */     1,    2,   23,   58,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  147,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   185,  186,   88,   88,  110,   22,  217,   92,  219,  220,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,  217,  218,  219,  220,   42,   43,  238,  188,   46,
 /*   100 */    78,   79,   80,   81,   82,   83,   84,   88,   89,  124,
 /*   110 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,   80,   81,   82,   83,   84,   23,   84,  169,  170,
 /*   150 */    19,  164,  165,  166,   23,   23,   60,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  110,
 /*   170 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  123,  147,  150,  147,   21,  167,  168,   58,
 /*   190 */   211,  147,  156,  157,   92,  216,  176,   23,  147,  176,
 /*   200 */   177,   78,   79,  165,  166,  103,  183,   42,   43,   78,
 /*   210 */    79,   88,   89,  169,  170,  228,  180,  181,  169,   88,
 /*   220 */    88,   98,   99,   92,   16,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,  147,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   78,  209,  210,  124,  125,  126,  224,  208,
 /*   260 */   169,  170,   88,   89,  230,  227,  228,   16,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   23,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  160,   16,  147,  161,   83,
 /*   300 */    84,  210,  161,  153,  169,  158,  156,  157,  161,  162,
 /*   310 */   163,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,  161,   74,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  192,  200,  147,  131,
 /*   340 */    16,  200,   16,  199,   20,  169,   88,   89,   90,  185,
 /*   350 */   186,   93,   94,   95,  217,   22,  219,  220,  147,  147,
 /*   360 */   169,  170,  104,  200,   84,  147,   42,   43,  156,  157,
 /*   370 */    90,   91,   92,   93,   94,   95,   96,  164,  165,  166,
 /*   380 */   169,  170,  131,  103,   60,   61,   62,   63,   64,   65,
 /*   390 */    66,   67,   68,   69,   70,   71,   72,  155,   74,   75,
 /*   400 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   410 */    84,   11,  221,   20,   30,   16,  147,   91,   92,   93,
 /*   420 */    94,   95,   96,   90,  147,  181,   93,   94,   95,  103,
 /*   430 */   212,  189,  155,   27,   50,   42,   43,  104,  169,  170,
 /*   440 */    34,  228,   43,  201,  202,  181,  169,  170,  206,   49,
 /*   450 */   161,  162,  163,   60,   61,   62,   63,   64,   65,   66,
 /*   460 */    67,   68,   69,   70,   71,   72,  189,   74,   75,   76,
 /*   470 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   25,
 /*   480 */   211,  147,   20,   29,   12,  147,  102,   19,  211,   21,
 /*   490 */   147,  141,  147,  216,  144,   41,   24,   98,   20,   99,
 /*   500 */   100,  101,  103,  165,   42,   43,    0,    1,    2,   37,
 /*   510 */   110,   39,  169,  170,  169,  170,  182,   19,   20,  190,
 /*   520 */    22,   49,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  155,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,  147,   90,
 /*   550 */    20,   20,   93,   94,   95,  147,  155,   59,  215,  225,
 /*   560 */   215,   20,  130,  104,  132,  227,  228,   42,   43,  189,
 /*   570 */   169,  170,   16,   42,   43,   20,   19,   22,   19,   20,
 /*   580 */    23,   22,   18,  147,  106,  147,  108,  109,   63,   64,
 /*   590 */   189,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  147,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,   92,   59,   55,
 /*   620 */   212,   21,  147,   19,  147,   23,  188,   23,   12,  217,
 /*   630 */    23,  219,  220,    7,    8,    9,  106,  186,  108,  109,
 /*   640 */    24,  147,   42,   43,  208,   88,   89,  106,   92,  108,
 /*   650 */   109,  244,  245,   37,  147,   39,  147,  182,   94,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  145,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,   80,  142,  143,
 /*   690 */    88,   89,   88,   89,  148,   88,   89,  133,   14,  147,
 /*   700 */   225,  155,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  114,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */   201,  202,  147,  147,  182,  189,   52,  147,   54,  147,
 /*   740 */   147,  147,  147,  147,  155,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  213,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,  188,  188,  182,  182,  225,  189,  106,
 /*   780 */   188,  108,  109,  188,   99,  100,  101,  241,   16,  155,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,  213,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   23,  133,  225,  225,
 /*   820 */    21,  225,   23,  189,  239,  236,   99,  100,  101,   22,
 /*   830 */   242,  243,  155,  191,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  147,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,   22,
 /*   860 */    19,  147,  147,  147,   23,  147,  189,  169,  170,  147,
 /*   870 */    14,  147,   31,   16,   17,  147,   19,  147,   19,   43,
 /*   880 */    23,   88,   89,  169,  170,  169,  170,   88,   31,   48,
 /*   890 */   147,  169,  170,  169,  170,  147,   89,  169,  170,   58,
 /*   900 */   147,  147,  147,  188,  147,   48,  188,  114,   52,  147,
 /*   910 */    54,   19,  147,  124,  125,   58,  147,  169,  170,   78,
 /*   920 */    79,  114,  169,  170,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,  169,  170,   92,   98,   78,   79,   80,  169,  170,
 /*   940 */    91,  147,  188,   22,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,  147,  155,   23,  147,  155,   22,  121,  110,
 /*   960 */    68,   80,   31,  169,  170,  124,  125,  126,  127,  128,
 /*   970 */   129,  112,  123,  208,  169,  170,  107,  169,  170,   48,
 /*   980 */   111,  124,  125,  126,  127,  128,  129,  189,  107,   58,
 /*   990 */   189,    5,  111,  147,    7,    8,   10,   11,   12,   13,
 /*  1000 */   161,   20,  147,   22,  178,  147,   91,   92,  147,   78,
 /*  1010 */    79,  147,   26,   19,   28,  169,  170,   23,   87,   88,
 /*  1020 */    89,   35,  147,   92,  169,  170,  147,  169,  170,  147,
 /*  1030 */   169,  170,   97,   47,  113,   49,   20,  203,   22,   53,
 /*  1040 */   147,  147,   56,  147,  169,  170,  147,  147,  147,   20,
 /*  1050 */   147,  169,  170,  147,  147,  124,  125,  126,  127,  128,
 /*  1060 */   129,  147,  169,  170,  178,  169,  170,  147,  169,  170,
 /*  1070 */   169,  170,  169,  170,  147,  169,  170,  147,   20,  147,
 /*  1080 */    22,  147,   88,  147,  147,   99,  100,  101,   59,  169,
 /*  1090 */   170,  105,  147,   20,  147,   22,  110,  178,  147,  169,
 /*  1100 */   170,  169,  170,  169,  170,  169,  170,   20,  147,   22,
 /*  1110 */   147,   20,  147,   22,  169,  170,  169,  170,  147,  147,
 /*  1120 */   134,   20,  147,   22,   20,  147,   22,  147,   20,  232,
 /*  1130 */    22,  233,  169,  170,  169,  170,  147,  147,  147,  147,
 /*  1140 */   169,  170,  147,  147,  169,  170,  147,  169,  170,  169,
 /*  1150 */   170,  147,  147,  147,  147,  147,  147,  191,  161,  149,
 /*  1160 */   193,  177,  229,  223,  161,  172,    6,  229,  194,  146,
 /*  1170 */   172,  194,  172,  172,  172,  161,  146,  146,  146,   22,
 /*  1180 */   154,  121,  194,  118,  173,  119,  116,  120,  112,  130,
 /*  1190 */   222,  152,  152,   98,  115,   98,  171,   97,  171,   40,
 /*  1200 */   179,  189,   19,   84,  171,  226,  171,  173,  195,  226,
 /*  1210 */   174,  196,  171,  171,  197,  171,  198,  179,   15,  174,
 /*  1220 */   151,   60,  151,  204,  152,  205,  204,  152,  151,  205,
 /*  1230 */   152,   38,  152,  130,  151,  184,  152,  184,   19,   15,
 /*  1240 */   194,  152,  187,  187,  187,  152,  194,  184,  187,   33,
 /*  1250 */   152,  152,  137,  159,    1,   20,  175,  214,  112,  112,
 /*  1260 */   175,  214,  234,  112,  112,   92,   19,   11,   20,  107,
 /*  1270 */    20,   19,  235,   19,   32,   20,  112,  114,   20,   22,
 /*  1280 */    20,   22,  117,   22,  117,  237,  237,   19,   44,   20,
 /*  1290 */   240,   20,   20,  231,   19,   44,   19,  243,   20,   19,
 /*  1300 */    19,   19,   96,  103,   16,   21,   44,   17,   98,   36,
 /*  1310 */   246,   45,   45,   22,   51,  133,   98,   19,    5,    1,
 /*  1320 */   122,   19,  102,   14,  113,   17,  113,  115,  102,  122,
 /*  1330 */    19,  123,   68,   68,   20,   14,   57,  135,   19,    3,
 /*  1340 */   136,    4,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 389
static const short yy_shift_ofst[] = {
 /*     0 */    39,  841,  986,  -16,  841,  931,  931,  258,  123,  -36,
 /*    10 */    96,  931,  931,  931,  931,  931,  -45,  400,  174,   19,
 /*    20 */   132,  -54,  -54,   53,  165,  208,  251,  324,  393,  462,
 /*    30 */   531,  600,  643,  686,  643,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    50 */   643,  643,  729,  772,  772,  857,  931,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  931,  -61,  -61,    6,    6,
 /*   100 */   280,   22,   61,  399,  564,   19,   19,   19,   19,   19,
 /*   110 */    19,   19,  216,  132,   63,  -62,  -62,  -62,  131,  326,
 /*   120 */   472,  472,  498,  559,  506,  799,   19,  799,   19,   19,
 /*   130 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*   140 */    19,  849,   59,  -36,  -36,  -36,  -62,  -62,  -62,  -15,
 /*   150 */   -15,  333,  459,  478,  557,  530,  541,  616,  602,  793,
 /*   160 */   604,  607,  626,   19,   19,  881,   19,   19,  994,   19,
 /*   170 */    19,  807,   19,   19,  673,  807,   19,   19,  384,  384,
 /*   180 */   384,   19,   19,  673,   19,   19,  673,   19,  454,  685,
 /*   190 */    19,   19,  673,   19,   19,   19,  673,   19,   19,   19,
 /*   200 */   673,  673,   19,   19,   19,   19,   19,  468,  869,  921,
 /*   210 */   132,  789,  789,  432,  406,  406,  406,  836,  406,  132,
 /*   220 */   406,  132,  935,  837,  837, 1160, 1160, 1160, 1160, 1157,
 /*   230 */   -36, 1060, 1065, 1066, 1070, 1067, 1059, 1076, 1076, 1095,
 /*   240 */  1079, 1095, 1079, 1097, 1097, 1159, 1097, 1100, 1097, 1183,
 /*   250 */  1119, 1119, 1159, 1097, 1097, 1097, 1183, 1203, 1076, 1203,
 /*   260 */  1076, 1203, 1076, 1076, 1193, 1103, 1203, 1076, 1161, 1161,
 /*   270 */  1219, 1060, 1076, 1224, 1224, 1224, 1224, 1060, 1161, 1219,
 /*   280 */  1076, 1216, 1216, 1076, 1076, 1115,  -62,  -62,  -62,  -62,
 /*   290 */   -62,  -62,  525,  684,  727,  856,  859,  556,  555,  981,
 /*   300 */   102,  987,  915, 1016, 1058, 1073, 1087, 1091, 1101, 1104,
 /*   310 */   892, 1108, 1029, 1253, 1235, 1146, 1147, 1151, 1152, 1173,
 /*   320 */  1162, 1247, 1248, 1250, 1252, 1256, 1254, 1255, 1257, 1258,
 /*   330 */  1260, 1259, 1165, 1261, 1167, 1259, 1163, 1268, 1269, 1164,
 /*   340 */  1271, 1272, 1242, 1244, 1275, 1251, 1277, 1278, 1280, 1281,
 /*   350 */  1262, 1282, 1206, 1200, 1288, 1290, 1284, 1210, 1273, 1263,
 /*   360 */  1266, 1291, 1267, 1182, 1218, 1298, 1313, 1318, 1220, 1264,
 /*   370 */  1265, 1198, 1302, 1211, 1309, 1212, 1308, 1213, 1226, 1207,
 /*   380 */  1311, 1208, 1314, 1321, 1279, 1202, 1204, 1319, 1336, 1337,
};
#define YY_REDUCE_USE_DFLT (-165)
#define YY_REDUCE_MAX 291
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  277,  546,  137,  401,  -21,   44,   36,   38,  242,
 /*    10 */  -141,  191,   91,  269,  343,  345, -126,  589,  338,  150,
 /*    20 */   147,  -13,  213,  412,  412,  412,  412,  412,  412,  412,
 /*    30 */   412,  412,  412,  412,  412,  412,  412,  412,  412,  412,
 /*    40 */   412,  412,  412,  412,  412,  412,  412,  412,  412,  412,
 /*    50 */   412,  412,  412,  412,  412,  211,  698,  714,  716,  722,
 /*    60 */   724,  728,  748,  753,  755,  757,  762,  769,  794,  805,
 /*    70 */   808,  846,  855,  858,  861,  875,  882,  893,  896,  899,
 /*    80 */   901,  903,  906,  920,  930,  932,  934,  936,  945,  947,
 /*    90 */   963,  965,  971,  975,  978,  980,  412,  412,  412,  412,
 /*   100 */    20,  412,  412,   23,   34,  334,  475,  552,  593,  594,
 /*   110 */   585,  212,  412,  289,  412,  412,  412,  412,  135, -164,
 /*   120 */  -115,  164,  407,  407,  350,  141,   51,  163,  596,  -90,
 /*   130 */   436,  218,  765,  438,  586,  592,  595,  715,  718,  408,
 /*   140 */   754,  380,  634,  677,  798,  801,  144,  529,  588,   49,
 /*   150 */   176,  244,  264,  329,  457,  329,  329,  451,  477,  494,
 /*   160 */   507,  509,  528,  590,  730,  642,  509,  743,  839,  864,
 /*   170 */   879,  834,  894,  900,  329,  834,  907,  914,  826,  886,
 /*   180 */   919,  927,  937,  329,  951,  961,  329,  972,  897,  898,
 /*   190 */   989,  990,  329,  991,  992,  995,  329,  996,  999, 1004,
 /*   200 */   329,  329, 1005, 1006, 1007, 1008, 1009, 1010,  966,  967,
 /*   210 */   997,  933,  938,  940,  993,  998, 1000,  984, 1001, 1003,
 /*   220 */  1002, 1014, 1011,  974,  977, 1023, 1030, 1031, 1032, 1026,
 /*   230 */  1012,  988, 1013, 1015, 1017, 1018,  968, 1039, 1040, 1019,
 /*   240 */  1020, 1022, 1024, 1025, 1027, 1021, 1033, 1034, 1035, 1036,
 /*   250 */   979,  983, 1038, 1041, 1042, 1044, 1045, 1069, 1072, 1071,
 /*   260 */  1075, 1077, 1078, 1080, 1028, 1037, 1083, 1084, 1051, 1053,
 /*   270 */  1043, 1046, 1089, 1055, 1056, 1057, 1061, 1052, 1063, 1047,
 /*   280 */  1093, 1048, 1049, 1098, 1099, 1050, 1094, 1081, 1085, 1062,
 /*   290 */  1054, 1064,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   595,  820,  902,  710,  902,  820,  902,  902,  848,  714,
 /*    10 */   877,  818,  902,  902,  902,  902,  792,  902,  848,  902,
 /*    20 */   626,  848,  848,  743,  902,  902,  902,  902,  902,  902,
 /*    30 */   902,  902,  744,  902,  822,  817,  813,  815,  814,  821,
 /*    40 */   745,  734,  741,  748,  726,  861,  750,  751,  757,  758,
 /*    50 */   878,  876,  780,  779,  798,  902,  902,  902,  902,  902,
 /*    60 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    70 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    80 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*    90 */   902,  902,  902,  902,  902,  902,  782,  804,  781,  791,
 /*   100 */   619,  783,  784,  679,  614,  902,  902,  902,  902,  902,
 /*   110 */   902,  902,  785,  902,  786,  799,  800,  801,  902,  902,
 /*   120 */   902,  902,  902,  902,  595,  710,  902,  710,  902,  902,
 /*   130 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   140 */   902,  902,  902,  902,  902,  902,  704,  714,  895,  902,
 /*   150 */   902,  670,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   160 */   902,  902,  602,  600,  902,  702,  902,  902,  628,  902,
 /*   170 */   902,  712,  902,  902,  717,  718,  902,  902,  902,  902,
 /*   180 */   902,  902,  902,  616,  902,  902,  691,  902,  854,  902,
 /*   190 */   902,  902,  868,  902,  902,  902,  866,  902,  902,  902,
 /*   200 */   693,  753,  834,  902,  881,  883,  902,  902,  702,  711,
 /*   210 */   902,  902,  902,  816,  737,  737,  737,  649,  737,  902,
 /*   220 */   737,  902,  652,  747,  747,  599,  599,  599,  599,  669,
 /*   230 */   902,  747,  738,  740,  730,  742,  902,  719,  719,  727,
 /*   240 */   729,  727,  729,  681,  681,  666,  681,  652,  681,  826,
 /*   250 */   831,  831,  666,  681,  681,  681,  826,  611,  719,  611,
 /*   260 */   719,  611,  719,  719,  858,  860,  611,  719,  683,  683,
 /*   270 */   759,  747,  719,  690,  690,  690,  690,  747,  683,  759,
 /*   280 */   719,  880,  880,  719,  719,  888,  636,  654,  654,  863,
 /*   290 */   895,  900,  902,  902,  902,  902,  766,  902,  902,  902,
 /*   300 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   310 */   841,  902,  902,  902,  902,  771,  767,  902,  768,  902,
 /*   320 */   696,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   330 */   902,  819,  902,  731,  902,  739,  902,  902,  902,  902,
 /*   340 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   350 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   360 */   856,  857,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   370 */   902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
 /*   380 */   902,  902,  902,  902,  887,  902,  902,  890,  596,  902,
 /*   390 */   590,  593,  592,  594,  598,  601,  623,  624,  625,  603,
 /*   400 */   604,  605,  606,  607,  608,  609,  615,  617,  635,  637,
 /*   410 */   621,  639,  700,  701,  763,  694,  695,  699,  622,  774,
 /*   420 */   765,  769,  770,  772,  773,  787,  788,  790,  796,  803,
 /*   430 */   806,  789,  794,  795,  797,  802,  805,  697,  698,  809,
 /*   440 */   629,  630,  633,  634,  844,  846,  845,  847,  632,  631,
 /*   450 */   775,  778,  811,  812,  869,  870,  871,  872,  873,  807,
 /*   460 */   720,  810,  793,  732,  735,  736,  733,  703,  713,  722,
 /*   470 */   723,  724,  725,  708,  709,  715,  728,  761,  762,  716,
 /*   480 */   705,  706,  707,  808,  764,  776,  777,  640,  641,  771,
 /*   490 */   642,  643,  644,  682,  685,  686,  687,  645,  664,  667,
 /*   500 */   668,  646,  653,  647,  648,  655,  656,  657,  660,  661,
 /*   510 */   662,  663,  658,  659,  827,  828,  832,  830,  829,  650,
 /*   520 */   651,  665,  638,  627,  620,  671,  674,  675,  676,  677,
 /*   530 */   678,  680,  672,  673,  618,  610,  612,  721,  850,  859,
 /*   540 */   855,  851,  852,  853,  613,  823,  824,  684,  755,  756,
 /*   550 */   849,  862,  864,  760,  865,  867,  892,  688,  689,  692,
 /*   560 */   833,  874,  746,  749,  752,  754,  835,  836,  837,  838,
 /*   570 */   839,  842,  843,  840,  875,  879,  882,  884,  885,  886,
 /*   580 */   889,  891,  896,  897,  898,  901,  899,  597,  591,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE ids",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE ids",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT expr",
 /* 210 */ "expr ::= BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= nexprlist",
 /* 231 */ "exprlist ::=",
 /* 232 */ "nexprlist ::= nexprlist COMMA expr",
 /* 233 */ "nexprlist ::= expr",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "collate ::=",
 /* 243 */ "collate ::= COLLATE ids",
 /* 244 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ DELETE",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "nmnum ::= plus_num",
 /* 254 */ "nmnum ::= nm",
 /* 255 */ "plus_num ::= plus_opt number",
 /* 256 */ "minus_num ::= MINUS number",
 /* 257 */ "number ::= INTEGER|FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE|INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "when_clause ::=",
 /* 272 */ "when_clause ::= WHEN expr",
 /* 273 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 274 */ "trigger_cmd_list ::=",
 /* 275 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 278 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 279 */ "trigger_cmd ::= select",
 /* 280 */ "expr ::= RAISE LP IGNORE RP",
 /* 281 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 282 */ "raisetype ::= ROLLBACK",
 /* 283 */ "raisetype ::= ABORT",
 /* 284 */ "raisetype ::= FAIL",
 /* 285 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 286 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 287 */ "cmd ::= DETACH database_kw_opt expr",
 /* 288 */ "key_opt ::=",
 /* 289 */ "key_opt ::= KEY expr",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= REINDEX",
 /* 293 */ "cmd ::= REINDEX nm dbnm",
 /* 294 */ "cmd ::= ANALYZE",
 /* 295 */ "cmd ::= ANALYZE nm dbnm",
 /* 296 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 297 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 298 */ "add_column_fullname ::= fullname",
 /* 299 */ "kwcolumn_opt ::=",
 /* 300 */ "kwcolumn_opt ::= COLUMNKW",
 /* 301 */ "cmd ::= create_vtab",
 /* 302 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 303 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 304 */ "vtabarglist ::= vtabarg",
 /* 305 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 306 */ "vtabarg ::=",
 /* 307 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 308 */ "vtabargtoken ::= ANY",
 /* 309 */ "vtabargtoken ::= lp anylist RP",
 /* 310 */ "lp ::= LP",
 /* 311 */ "anylist ::=",
 /* 312 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155: /* select */
    case 189: /* oneselect */
    case 206: /* seltablist_paren */
{
#line 374 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy219));
#line 1289 "parse.c"
}
      break;
    case 169: /* term */
    case 170: /* expr */
    case 194: /* where_opt */
    case 196: /* having_opt */
    case 204: /* on_opt */
    case 210: /* sortitem */
    case 218: /* escape */
    case 221: /* case_operand */
    case 223: /* case_else */
    case 235: /* when_clause */
    case 238: /* key_opt */
{
#line 634 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy172));
#line 1306 "parse.c"
}
      break;
    case 174: /* idxlist_opt */
    case 182: /* idxlist */
    case 192: /* selcollist */
    case 195: /* groupby_opt */
    case 197: /* orderby_opt */
    case 199: /* sclp */
    case 209: /* sortlist */
    case 211: /* nexprlist */
    case 212: /* setlist */
    case 215: /* itemlist */
    case 216: /* exprlist */
    case 222: /* case_exprlist */
{
#line 892 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy174));
#line 1324 "parse.c"
}
      break;
    case 188: /* fullname */
    case 193: /* from */
    case 201: /* seltablist */
    case 202: /* stl_prefix */
{
#line 491 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy373));
#line 1334 "parse.c"
}
      break;
    case 205: /* using_opt */
    case 208: /* inscollist */
    case 214: /* inscollist_opt */
{
#line 508 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy432));
#line 1343 "parse.c"
}
      break;
    case 231: /* trigger_cmd_list */
    case 236: /* trigger_cmd */
{
#line 998 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy243));
#line 1351 "parse.c"
}
      break;
    case 233: /* trigger_event */
{
#line 984 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy370).b);
#line 1358 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 39 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1536 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 143, 1 },
  { 143, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 4: /* ecmd ::= SEMI */
      case 5: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* cmd ::= create_table create_table_args */
      case 28: /* columnlist ::= columnlist COMMA column */
      case 29: /* columnlist ::= column */
      case 37: /* type ::= */
      case 44: /* signed ::= plus_num */
      case 45: /* signed ::= minus_num */
      case 46: /* carglist ::= carglist carg */
      case 47: /* carglist ::= */
      case 48: /* carg ::= CONSTRAINT nm ccons */
      case 49: /* carg ::= ccons */
      case 55: /* ccons ::= NULL onconf */
      case 82: /* conslist ::= conslist COMMA tcons */
      case 83: /* conslist ::= conslist tcons */
      case 84: /* conslist ::= tcons */
      case 85: /* tcons ::= CONSTRAINT nm */
      case 258: /* plus_opt ::= PLUS */
      case 259: /* plus_opt ::= */
      case 269: /* foreach_clause ::= */
      case 270: /* foreach_clause ::= FOR EACH ROW */
      case 290: /* database_kw_opt ::= DATABASE */
      case 291: /* database_kw_opt ::= */
      case 299: /* kwcolumn_opt ::= */
      case 300: /* kwcolumn_opt ::= COLUMNKW */
      case 304: /* vtabarglist ::= vtabarg */
      case 305: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 307: /* vtabarg ::= vtabarg vtabargtoken */
      case 311: /* anylist ::= */
#line 91 "parse.y"
{
}
#line 1998 "parse.c"
        break;
      case 3: /* cmdx ::= cmd */
#line 94 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2003 "parse.c"
        break;
      case 6: /* explain ::= */
#line 97 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2008 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN */
#line 99 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2013 "parse.c"
        break;
      case 8: /* explain ::= EXPLAIN QUERY PLAN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2018 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 106 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 2023 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 112 "parse.y"
{yygotominor.yy46 = TK_IMMEDIATE;}
#line 2028 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 107: /* multiselect_op ::= UNION */
      case 109: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 117 "parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 2037 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 120 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2043 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 122 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2048 "parse.c"
        break;
      case 21: /* create_table ::= CREATE temp TABLE ifnotexists nm dbnm */
#line 127 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 2055 "parse.c"
        break;
      case 22: /* ifnotexists ::= */
      case 25: /* temp ::= */
      case 63: /* autoinc ::= */
      case 77: /* init_deferred_pred_opt ::= */
      case 79: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 90: /* defer_subclause_opt ::= */
      case 101: /* ifexists ::= */
      case 112: /* distinct ::= ALL */
      case 113: /* distinct ::= */
      case 213: /* between_op ::= BETWEEN */
      case 216: /* in_op ::= IN */
#line 131 "parse.y"
{yygotominor.yy46 = 0;}
#line 2070 "parse.c"
        break;
      case 23: /* ifnotexists ::= IF NOT EXISTS */
      case 24: /* temp ::= TEMP */
      case 64: /* autoinc ::= AUTOINCR */
      case 78: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 100: /* ifexists ::= IF EXISTS */
      case 111: /* distinct ::= DISTINCT */
      case 214: /* between_op ::= NOT BETWEEN */
      case 217: /* in_op ::= NOT IN */
#line 132 "parse.y"
{yygotominor.yy46 = 1;}
#line 2082 "parse.c"
        break;
      case 26: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 138 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2089 "parse.c"
        break;
      case 27: /* create_table_args ::= AS select */
#line 141 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy219);
}
#line 2097 "parse.c"
        break;
      case 30: /* column ::= columnid type carglist */
#line 153 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2105 "parse.c"
        break;
      case 31: /* columnid ::= nm */
#line 157 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2113 "parse.c"
        break;
      case 32: /* id ::= ID */
      case 33: /* ids ::= ID|STRING */
      case 34: /* nm ::= ID */
      case 35: /* nm ::= STRING */
      case 36: /* nm ::= JOIN_KW */
      case 39: /* typetoken ::= typename */
      case 42: /* typename ::= ids */
      case 119: /* as ::= AS nm */
      case 120: /* as ::= ids */
      case 131: /* dbnm ::= DOT nm */
      case 241: /* idxitem ::= nm */
      case 243: /* collate ::= COLLATE ids */
      case 253: /* nmnum ::= plus_num */
      case 254: /* nmnum ::= nm */
      case 255: /* plus_num ::= plus_opt number */
      case 256: /* minus_num ::= MINUS number */
      case 257: /* number ::= INTEGER|FLOAT */
#line 167 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2134 "parse.c"
        break;
      case 38: /* type ::= typetoken */
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2139 "parse.c"
        break;
      case 40: /* typetoken ::= typename LP signed RP */
#line 230 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z;
}
#line 2147 "parse.c"
        break;
      case 41: /* typetoken ::= typename LP signed COMMA signed RP */
#line 234 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z;
}
#line 2155 "parse.c"
        break;
      case 43: /* typename ::= typename ids */
#line 240 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2160 "parse.c"
        break;
      case 50: /* ccons ::= DEFAULT term */
      case 52: /* ccons ::= DEFAULT PLUS term */
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2166 "parse.c"
        break;
      case 51: /* ccons ::= DEFAULT LP expr RP */
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2171 "parse.c"
        break;
      case 53: /* ccons ::= DEFAULT MINUS term */
#line 254 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2179 "parse.c"
        break;
      case 54: /* ccons ::= DEFAULT id */
#line 258 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2187 "parse.c"
        break;
      case 56: /* ccons ::= NOT NULL onconf */
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2192 "parse.c"
        break;
      case 57: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2197 "parse.c"
        break;
      case 58: /* ccons ::= UNIQUE onconf */
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2202 "parse.c"
        break;
      case 59: /* ccons ::= CHECK LP expr RP */
#line 271 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2207 "parse.c"
        break;
      case 60: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2212 "parse.c"
        break;
      case 61: /* ccons ::= defer_subclause */
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2217 "parse.c"
        break;
      case 62: /* ccons ::= COLLATE ids */
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2222 "parse.c"
        break;
      case 65: /* refargs ::= */
#line 288 "parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2227 "parse.c"
        break;
      case 66: /* refargs ::= refargs refarg */
#line 289 "parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2232 "parse.c"
        break;
      case 67: /* refarg ::= MATCH nm */
#line 291 "parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2237 "parse.c"
        break;
      case 68: /* refarg ::= ON DELETE refact */
#line 292 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2242 "parse.c"
        break;
      case 69: /* refarg ::= ON UPDATE refact */
#line 293 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2247 "parse.c"
        break;
      case 70: /* refarg ::= ON INSERT refact */
#line 294 "parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2252 "parse.c"
        break;
      case 71: /* refact ::= SET NULL */
#line 296 "parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2257 "parse.c"
        break;
      case 72: /* refact ::= SET DEFAULT */
#line 297 "parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2262 "parse.c"
        break;
      case 73: /* refact ::= CASCADE */
#line 298 "parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2267 "parse.c"
        break;
      case 74: /* refact ::= RESTRICT */
#line 299 "parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2272 "parse.c"
        break;
      case 75: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 76: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 91: /* defer_subclause_opt ::= defer_subclause */
      case 93: /* onconf ::= ON CONFLICT resolvetype */
      case 95: /* orconf ::= OR resolvetype */
      case 96: /* resolvetype ::= raisetype */
      case 166: /* insert_cmd ::= INSERT orconf */
#line 301 "parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2283 "parse.c"
        break;
      case 80: /* conslist_opt ::= */
#line 311 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2288 "parse.c"
        break;
      case 81: /* conslist_opt ::= COMMA conslist */
#line 312 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2293 "parse.c"
        break;
      case 86: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2298 "parse.c"
        break;
      case 87: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2303 "parse.c"
        break;
      case 88: /* tcons ::= CHECK LP expr RP onconf */
#line 321 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2308 "parse.c"
        break;
      case 89: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2316 "parse.c"
        break;
      case 92: /* onconf ::= */
      case 94: /* orconf ::= */
#line 337 "parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2322 "parse.c"
        break;
      case 97: /* resolvetype ::= IGNORE */
#line 342 "parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2327 "parse.c"
        break;
      case 98: /* resolvetype ::= REPLACE */
      case 167: /* insert_cmd ::= REPLACE */
#line 343 "parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2333 "parse.c"
        break;
      case 99: /* cmd ::= DROP TABLE ifexists fullname */
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2340 "parse.c"
        break;
      case 102: /* cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select */
#line 357 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy219, yymsp[-6].minor.yy46, yymsp[-4].minor.yy46);
}
#line 2347 "parse.c"
        break;
      case 103: /* cmd ::= DROP VIEW ifexists fullname */
#line 360 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2354 "parse.c"
        break;
      case 104: /* cmd ::= select */
#line 367 "parse.y"
{
  SelectDest dest = {SRT_Callback, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy219, &dest, 0, 0, 0);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy219);
}
#line 2363 "parse.c"
        break;
      case 105: /* select ::= oneselect */
      case 128: /* seltablist_paren ::= select */
#line 378 "parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2369 "parse.c"
        break;
      case 106: /* select ::= select multiselect_op oneselect */
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy219);
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2382 "parse.c"
        break;
      case 108: /* multiselect_op ::= UNION ALL */
#line 391 "parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2387 "parse.c"
        break;
      case 110: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 395 "parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2394 "parse.c"
        break;
      case 114: /* sclp ::= selcollist COMMA */
      case 238: /* idxlist_opt ::= LP idxlist RP */
#line 416 "parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2400 "parse.c"
        break;
      case 115: /* sclp ::= */
      case 141: /* orderby_opt ::= */
      case 149: /* groupby_opt ::= */
      case 231: /* exprlist ::= */
      case 237: /* idxlist_opt ::= */
#line 417 "parse.y"
{yygotominor.yy174 = 0;}
#line 2409 "parse.c"
        break;
      case 116: /* selcollist ::= sclp expr as */
#line 418 "parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2416 "parse.c"
        break;
      case 117: /* selcollist ::= sclp STAR */
#line 421 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy174, p, 0);
}
#line 2424 "parse.c"
        break;
      case 118: /* selcollist ::= sclp nm DOT STAR */
#line 425 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174, pDot, 0);
}
#line 2434 "parse.c"
        break;
      case 121: /* as ::= */
#line 438 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2439 "parse.c"
        break;
      case 122: /* from ::= */
#line 450 "parse.y"
{yygotominor.yy373 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy373));}
#line 2444 "parse.c"
        break;
      case 123: /* from ::= FROM seltablist */
#line 451 "parse.y"
{
  yygotominor.yy373 = yymsp[0].minor.yy373;
  sqlite3SrcListShiftJoinType(yygotominor.yy373);
}
#line 2452 "parse.c"
        break;
      case 124: /* stl_prefix ::= seltablist joinop */
#line 459 "parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2460 "parse.c"
        break;
      case 125: /* stl_prefix ::= */
#line 463 "parse.y"
{yygotominor.yy373 = 0;}
#line 2465 "parse.c"
        break;
      case 126: /* seltablist ::= stl_prefix nm dbnm as on_opt using_opt */
#line 464 "parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-5].minor.yy373,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,0,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
}
#line 2472 "parse.c"
        break;
      case 127: /* seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt */
#line 469 "parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy373,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy219,yymsp[-1].minor.yy172,yymsp[0].minor.yy432);
  }
#line 2479 "parse.c"
        break;
      case 129: /* seltablist_paren ::= seltablist */
#line 480 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy373);
     yygotominor.yy219 = sqlite3SelectNew(pParse,0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2487 "parse.c"
        break;
      case 130: /* dbnm ::= */
#line 487 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2492 "parse.c"
        break;
      case 132: /* fullname ::= nm dbnm */
#line 492 "parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2497 "parse.c"
        break;
      case 133: /* joinop ::= COMMA|JOIN */
#line 496 "parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2502 "parse.c"
        break;
      case 134: /* joinop ::= JOIN_KW JOIN */
#line 497 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2507 "parse.c"
        break;
      case 135: /* joinop ::= JOIN_KW nm JOIN */
#line 498 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2512 "parse.c"
        break;
      case 136: /* joinop ::= JOIN_KW nm nm JOIN */
#line 500 "parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2517 "parse.c"
        break;
      case 137: /* on_opt ::= ON expr */
      case 145: /* sortitem ::= expr */
      case 152: /* having_opt ::= HAVING expr */
      case 159: /* where_opt ::= WHERE expr */
      case 174: /* expr ::= term */
      case 202: /* escape ::= ESCAPE expr */
      case 226: /* case_else ::= ELSE expr */
      case 228: /* case_operand ::= expr */
#line 504 "parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2529 "parse.c"
        break;
      case 138: /* on_opt ::= */
      case 151: /* having_opt ::= */
      case 158: /* where_opt ::= */
      case 203: /* escape ::= */
      case 227: /* case_else ::= */
      case 229: /* case_operand ::= */
#line 505 "parse.y"
{yygotominor.yy172 = 0;}
#line 2539 "parse.c"
        break;
      case 139: /* using_opt ::= USING LP inscollist RP */
      case 171: /* inscollist_opt ::= LP inscollist RP */
#line 509 "parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2545 "parse.c"
        break;
      case 140: /* using_opt ::= */
      case 170: /* inscollist_opt ::= */
#line 510 "parse.y"
{yygotominor.yy432 = 0;}
#line 2551 "parse.c"
        break;
      case 142: /* orderby_opt ::= ORDER BY sortlist */
      case 150: /* groupby_opt ::= GROUP BY nexprlist */
      case 230: /* exprlist ::= nexprlist */
#line 521 "parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2558 "parse.c"
        break;
      case 143: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 522 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy174,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2566 "parse.c"
        break;
      case 144: /* sortlist ::= sortitem sortorder */
#line 526 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy172,0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2574 "parse.c"
        break;
      case 146: /* sortorder ::= ASC */
      case 148: /* sortorder ::= */
#line 534 "parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2580 "parse.c"
        break;
      case 147: /* sortorder ::= DESC */
#line 535 "parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2585 "parse.c"
        break;
      case 153: /* limit_opt ::= */
#line 561 "parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2590 "parse.c"
        break;
      case 154: /* limit_opt ::= LIMIT expr */
#line 562 "parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2595 "parse.c"
        break;
      case 155: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 564 "parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2600 "parse.c"
        break;
      case 156: /* limit_opt ::= LIMIT expr COMMA expr */
#line 566 "parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2605 "parse.c"
        break;
      case 157: /* cmd ::= DELETE FROM fullname where_opt */
#line 570 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2610 "parse.c"
        break;
      case 160: /* cmd ::= UPDATE orconf fullname SET setlist where_opt */
#line 580 "parse.y"
{
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy174,"set list"); 
  sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);
}
#line 2618 "parse.c"
        break;
      case 161: /* setlist ::= setlist COMMA nm EQ expr */
#line 589 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy0);}
#line 2623 "parse.c"
        break;
      case 162: /* setlist ::= nm EQ expr */
#line 591 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy0);}
#line 2628 "parse.c"
        break;
      case 163: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 597 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2633 "parse.c"
        break;
      case 164: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 599 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2638 "parse.c"
        break;
      case 165: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 601 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy373, 0, 0, yymsp[-2].minor.yy432, yymsp[-5].minor.yy46);}
#line 2643 "parse.c"
        break;
      case 168: /* itemlist ::= itemlist COMMA expr */
      case 232: /* nexprlist ::= nexprlist COMMA expr */
#line 612 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2649 "parse.c"
        break;
      case 169: /* itemlist ::= expr */
      case 233: /* nexprlist ::= expr */
#line 614 "parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy172,0);}
#line 2655 "parse.c"
        break;
      case 172: /* inscollist ::= inscollist COMMA nm */
#line 624 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy432,&yymsp[0].minor.yy0);}
#line 2660 "parse.c"
        break;
      case 173: /* inscollist ::= nm */
#line 626 "parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2665 "parse.c"
        break;
      case 175: /* expr ::= LP expr RP */
#line 637 "parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2670 "parse.c"
        break;
      case 176: /* term ::= NULL */
      case 181: /* term ::= INTEGER|FLOAT|BLOB */
      case 182: /* term ::= STRING */
#line 638 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2677 "parse.c"
        break;
      case 177: /* expr ::= ID */
      case 178: /* expr ::= JOIN_KW */
#line 639 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2683 "parse.c"
        break;
      case 179: /* expr ::= nm DOT nm */
#line 641 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2692 "parse.c"
        break;
      case 180: /* expr ::= nm DOT nm DOT nm */
#line 646 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2703 "parse.c"
        break;
      case 183: /* expr ::= REGISTER */
#line 655 "parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2708 "parse.c"
        break;
      case 184: /* expr ::= VARIABLE */
#line 656 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2717 "parse.c"
        break;
      case 185: /* expr ::= expr COLLATE ids */
#line 661 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0);
}
#line 2724 "parse.c"
        break;
      case 186: /* expr ::= CAST LP expr AS typetoken RP */
#line 665 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2732 "parse.c"
        break;
      case 187: /* expr ::= ID LP distinct exprlist RP */
#line 670 "parse.y"
{
  if( yymsp[-1].minor.yy174 && yymsp[-1].minor.yy174->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2746 "parse.c"
        break;
      case 188: /* expr ::= ID LP STAR RP */
#line 680 "parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2754 "parse.c"
        break;
      case 189: /* term ::= CTIME_KW */
#line 684 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->op = TK_CONST_FUNC;  
    yygotominor.yy172->span = yymsp[0].minor.yy0;
  }
}
#line 2767 "parse.c"
        break;
      case 190: /* expr ::= expr AND expr */
      case 191: /* expr ::= expr OR expr */
      case 192: /* expr ::= expr LT|GT|GE|LE expr */
      case 193: /* expr ::= expr EQ|NE expr */
      case 194: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 195: /* expr ::= expr PLUS|MINUS expr */
      case 196: /* expr ::= expr STAR|SLASH|REM expr */
      case 197: /* expr ::= expr CONCAT expr */
#line 693 "parse.y"
{yygotominor.yy172 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy172,yymsp[0].minor.yy172,0);}
#line 2779 "parse.c"
        break;
      case 198: /* likeop ::= LIKE_KW */
      case 200: /* likeop ::= MATCH */
#line 705 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2785 "parse.c"
        break;
      case 199: /* likeop ::= NOT LIKE_KW */
      case 201: /* likeop ::= NOT MATCH */
#line 706 "parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2791 "parse.c"
        break;
      case 204: /* expr ::= expr likeop expr escape */
#line 713 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2807 "parse.c"
        break;
      case 205: /* expr ::= expr ISNULL|NOTNULL */
#line 726 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2815 "parse.c"
        break;
      case 206: /* expr ::= expr IS NULL */
#line 730 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2823 "parse.c"
        break;
      case 207: /* expr ::= expr NOT NULL */
#line 734 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2831 "parse.c"
        break;
      case 208: /* expr ::= expr IS NOT NULL */
#line 738 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2839 "parse.c"
        break;
      case 209: /* expr ::= NOT expr */
      case 210: /* expr ::= BITNOT expr */
#line 742 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2848 "parse.c"
        break;
      case 211: /* expr ::= MINUS expr */
#line 750 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2856 "parse.c"
        break;
      case 212: /* expr ::= PLUS expr */
#line 754 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2864 "parse.c"
        break;
      case 215: /* expr ::= expr between_op expr AND expr */
#line 761 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2880 "parse.c"
        break;
      case 218: /* expr ::= expr in_op LP exprlist RP */
#line 777 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
      sqlite3ExprSetHeight(pParse, yygotominor.yy172);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2895 "parse.c"
        break;
      case 219: /* expr ::= LP select RP */
#line 788 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(pParse, yygotominor.yy172);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2909 "parse.c"
        break;
      case 220: /* expr ::= expr in_op LP select RP */
#line 798 "parse.y"
{
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSetHeight(pParse, yygotominor.yy172);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2924 "parse.c"
        break;
      case 221: /* expr ::= expr in_op nm dbnm */
#line 809 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy172 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy172);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 2940 "parse.c"
        break;
      case 222: /* expr ::= EXISTS LP select RP */
#line 821 "parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy172);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy219);
    }
  }
#line 2954 "parse.c"
        break;
      case 223: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 834 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
    sqlite3ExprSetHeight(pParse, yygotominor.yy172);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2968 "parse.c"
        break;
      case 224: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 846 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2976 "parse.c"
        break;
      case 225: /* case_exprlist ::= WHEN expr THEN expr */
#line 850 "parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2984 "parse.c"
        break;
      case 234: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 879 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2993 "parse.c"
        break;
      case 235: /* uniqueflag ::= UNIQUE */
      case 283: /* raisetype ::= ABORT */
#line 886 "parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2999 "parse.c"
        break;
      case 236: /* uniqueflag ::= */
#line 887 "parse.y"
{yygotominor.yy46 = OE_None;}
#line 3004 "parse.c"
        break;
      case 239: /* idxlist ::= idxlist COMMA idxitem collate sortorder */
#line 897 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3018 "parse.c"
        break;
      case 240: /* idxlist ::= idxitem collate sortorder */
#line 907 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy174, "index");
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 3032 "parse.c"
        break;
      case 242: /* collate ::= */
#line 920 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3037 "parse.c"
        break;
      case 244: /* cmd ::= DROP INDEX ifexists fullname */
#line 926 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 3042 "parse.c"
        break;
      case 245: /* cmd ::= VACUUM */
      case 246: /* cmd ::= VACUUM nm */
#line 932 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3048 "parse.c"
        break;
      case 247: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 248: /* cmd ::= PRAGMA nm dbnm EQ ON */
      case 249: /* cmd ::= PRAGMA nm dbnm EQ DELETE */
#line 941 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3055 "parse.c"
        break;
      case 250: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 944 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);
}
#line 3062 "parse.c"
        break;
      case 251: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 947 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3067 "parse.c"
        break;
      case 252: /* cmd ::= PRAGMA nm dbnm */
#line 948 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3072 "parse.c"
        break;
      case 260: /* cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END */
#line 963 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 3082 "parse.c"
        break;
      case 261: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 972 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[0].minor.yy172, yymsp[-10].minor.yy46, yymsp[-8].minor.yy46);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3090 "parse.c"
        break;
      case 262: /* trigger_time ::= BEFORE */
      case 265: /* trigger_time ::= */
#line 978 "parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 3096 "parse.c"
        break;
      case 263: /* trigger_time ::= AFTER */
#line 979 "parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 3101 "parse.c"
        break;
      case 264: /* trigger_time ::= INSTEAD OF */
#line 980 "parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 3106 "parse.c"
        break;
      case 266: /* trigger_event ::= DELETE|INSERT */
      case 267: /* trigger_event ::= UPDATE */
#line 985 "parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 3112 "parse.c"
        break;
      case 268: /* trigger_event ::= UPDATE OF inscollist */
#line 987 "parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 3117 "parse.c"
        break;
      case 271: /* when_clause ::= */
      case 288: /* key_opt ::= */
#line 994 "parse.y"
{ yygotominor.yy172 = 0; }
#line 3123 "parse.c"
        break;
      case 272: /* when_clause ::= WHEN expr */
      case 289: /* key_opt ::= KEY expr */
#line 995 "parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3129 "parse.c"
        break;
      case 273: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 999 "parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3142 "parse.c"
        break;
      case 274: /* trigger_cmd_list ::= */
#line 1008 "parse.y"
{ yygotominor.yy243 = 0; }
#line 3147 "parse.c"
        break;
      case 275: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1014 "parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3152 "parse.c"
        break;
      case 276: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1019 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3157 "parse.c"
        break;
      case 277: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1022 "parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3162 "parse.c"
        break;
      case 278: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1026 "parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy172);}
#line 3167 "parse.c"
        break;
      case 279: /* trigger_cmd ::= select */
#line 1029 "parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy219); }
#line 3172 "parse.c"
        break;
      case 280: /* expr ::= RAISE LP IGNORE RP */
#line 1032 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3183 "parse.c"
        break;
      case 281: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1039 "parse.y"
{
  yygotominor.yy172 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3194 "parse.c"
        break;
      case 282: /* raisetype ::= ROLLBACK */
#line 1049 "parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3199 "parse.c"
        break;
      case 284: /* raisetype ::= FAIL */
#line 1051 "parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3204 "parse.c"
        break;
      case 285: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1056 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373,yymsp[-1].minor.yy46);
}
#line 3211 "parse.c"
        break;
      case 286: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1063 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy172);
}
#line 3218 "parse.c"
        break;
      case 287: /* cmd ::= DETACH database_kw_opt expr */
#line 1066 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3225 "parse.c"
        break;
      case 292: /* cmd ::= REINDEX */
#line 1081 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3230 "parse.c"
        break;
      case 293: /* cmd ::= REINDEX nm dbnm */
#line 1082 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3235 "parse.c"
        break;
      case 294: /* cmd ::= ANALYZE */
#line 1087 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3240 "parse.c"
        break;
      case 295: /* cmd ::= ANALYZE nm dbnm */
#line 1088 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3245 "parse.c"
        break;
      case 296: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1093 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy0);
}
#line 3252 "parse.c"
        break;
      case 297: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1096 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3259 "parse.c"
        break;
      case 298: /* add_column_fullname ::= fullname */
#line 1099 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3266 "parse.c"
        break;
      case 301: /* cmd ::= create_vtab */
#line 1108 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3271 "parse.c"
        break;
      case 302: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1109 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3276 "parse.c"
        break;
      case 303: /* create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm */
#line 1110 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3283 "parse.c"
        break;
      case 306: /* vtabarg ::= */
#line 1115 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3288 "parse.c"
        break;
      case 308: /* vtabargtoken ::= ANY */
      case 309: /* vtabargtoken ::= lp anylist RP */
      case 310: /* lp ::= LP */
      case 312: /* anylist ::= anylist ANY */
#line 1117 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3296 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3361 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
