/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

/*************/
/* constants */
/*************/

enum {HF_CURVATURE, HF_LAST};

/**************/
/* structures */
/**************/

struct spatial_pak
{
gint type;       /* GDIS reference */
gint method;     /* openGL drawing */
GSList *data;    /* vertices */
};

/**************/
/* prototypes */
/**************/

void fn_make_spatial(gint, gdouble *, gdouble *, struct model_pak *);
void compute_plane(gdouble *, GList *); 
void new_spatial_point(gint, struct core_pak *, struct model_pak *);
void delete_spatial(gint, struct model_pak *);
void delete_vector_at(gdouble *, struct model_pak *);

void spatial_delete_type(gint, struct model_pak *);

