/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "gdis.h"
#include "coords.h"
#include "edit.h"
#include "file.h"
#include "matrix.h"
#include "opengl.h"
#include "dialog.h"
#include "interface.h"

extern struct sysenv_pak sysenv;

extern GtkWidget *window;

/******************************************/
/* save the current OpenGL canvas to file */
/******************************************/
void image_export(gchar *name)
{
GdkPixbuf *pixbuf;
GError *error;
GSList *list;
struct canvas_pak *canvas;

dialog_destroy_type(FILE_SELECT);

/* FIXME - all GTK stuff (ie closing the file dialog/raising windows */
/* to the foreground etc.) will be done only AFTER this routine ends */
/* ie returns to the control of gtk_main_loop - so there is no way */
/* of preventing the dialog from getting in the way */
/* probably have to set a flag to do it after the next redraw_canvas() */
/*
gdk_window_show((canvas->glarea)->window);
gdk_window_show(window->window);
*/

/* get the drawable */
list = sysenv.canvas_list;
canvas = (struct canvas_pak *) list->data;

pixbuf = gdk_pixbuf_get_from_drawable(NULL, (canvas->glarea)->window, NULL,
                                      0, 0, 0, 0,
                                      canvas->width, canvas->height);

gdk_pixbuf_save(pixbuf, name, "jpeg", &error, "quality", "80", NULL);
}

/*************************************************/
/* add a filename to active model's picture list */
/*************************************************/
void image_import(const gchar *name)
{
gchar *picture;
struct model_pak *model;

/* checks */
/* TODO - check file validity */
g_assert(name != NULL);

dialog_destroy_type(FILE_SELECT);

model = sysenv.active_model;
if (!model)
  return;

picture = g_strdup(name);

model->picture_list = g_slist_append(model->picture_list, picture);
model->picture_active = picture;
model->graph_active = NULL;

/* updates */
tree_model_add(model);
redraw_canvas(SINGLE);
}

/***********************************/
/* get a filename for image export */
/***********************************/
void image_export_dialog(void)
{
if (sysenv.active_model)
  file_dialog("Export image", NULL, FILE_SAVE, 
             (gpointer) image_export, PICTURE);
}

/*******************************************/
/* get a file dialog for picture selection */
/*******************************************/
void image_import_dialog(void)
{
if (sysenv.active_model)
  file_dialog("Import picture", NULL, FILE_LOAD, 
             (gpointer) image_import, PICTURE);
}

