/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "gdis.h"
#include "coords.h"
#include "matrix.h"
#include <GL/gl.h>

/* externals */
extern struct sysenv_pak sysenv;


void glo_draw_sphere(struct point_pak *p, gdouble *x, gdouble rad)
{
gint i, j, n, jump;
gdouble vec[3];

g_return_if_fail(p->num_points != 0);

/*
printf("     depth = %d\n", p->type);
printf("num points = %d\n", p->num_points);
*/

/* distance (in points) between hexagonal segments */
jump = 3 * pow(4, p->type);

/* part 1 */
glBegin(GL_TRIANGLE_FAN);
vec[0] = *(p->x[0]+2);
vec[1] = *(p->x[1]+2);
vec[2] = *(p->x[2]+2);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);
for (i=6 ; i-- ; )
  {
  vec[0] = *(p->x[0]+i*jump+1);
  vec[1] = *(p->x[1]+i*jump+1);
  vec[2] = *(p->x[2]+i*jump+1);

  glNormal3dv(vec);
  VEC3MUL(vec, rad);
  ARR3ADD(vec, x);
  glVertex3dv(vec);
  }
vec[0] = *(p->x[0]+5*jump+1);
vec[1] = *(p->x[1]+5*jump+1);
vec[2] = *(p->x[2]+5*jump+1);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);
glEnd();


/* part 2 */
glBegin(GL_TRIANGLE_STRIP);
n=0;

/*
while (n<p->type)
*/
while (n<1)
  {
  for (i=6 ; i-- ; )
    {
 
vec[0] = *(p->x[0]+i*jump+0);
vec[1] = *(p->x[1]+i*jump+0);
vec[2] = *(p->x[2]+i*jump+0);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

vec[0] = *(p->x[0]+i*jump+9);
vec[1] = *(p->x[1]+i*jump+9);
vec[2] = *(p->x[2]+i*jump+9);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

vec[0] = *(p->x[0]+i*jump+1);
vec[1] = *(p->x[1]+i*jump+1);
vec[2] = *(p->x[2]+i*jump+1);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

vec[0] = *(p->x[0]+i*jump+4);
vec[1] = *(p->x[1]+i*jump+4);
vec[2] = *(p->x[2]+i*jump+4);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

    }
  n++;
  }

vec[0] = *(p->x[0]+5*jump+0);
vec[1] = *(p->x[1]+5*jump+0);
vec[2] = *(p->x[2]+5*jump+0);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

vec[0] = *(p->x[0]+5*jump+9);
vec[1] = *(p->x[1]+5*jump+9);
vec[2] = *(p->x[2]+5*jump+9);
glNormal3dv(vec);
VEC3MUL(vec, rad);
ARR3ADD(vec, x);
glVertex3dv(vec);

glEnd();

}


