X-UIDL: Q@O!!?5T"!_iS"!i/o"!
X-Mozilla-Status: 0001
X-Mozilla-Status2: 00000000
Return-Path: <andrew@power.curtin.edu.au>
Received: from power.curtin.edu.au (titanium.chemistry.curtin.edu.au [134.7.118.81])
	by power.curtin.edu.au (8.12.8/8.12.5) with ESMTP id h841TLHw029957
	for <sean@power.curtin.edu.au>; Thu, 4 Sep 2003 09:29:21 +0800
Date: Thu, 4 Sep 2003 09:22:49 +0800
Mime-Version: 1.0 (Apple Message framework v552)
Content-Type: text/plain; delsp=yes; charset=US-ASCII; format=flowed
Subject: can you see me when you get in?
From: Andrew Rohl <andrew@power.curtin.edu.au>
To: Sean Fleming <sean@power.curtin.edu.au>
Content-Transfer-Encoding: 7bit
Message-Id: <4C4632DB-DE76-11D7-8650-000393074138@power.curtin.edu.au>
X-Mailer: Apple Mail (2.552)
X-UIDL: Q@O!!?5T"!_iS"!i/o"!

/*
Copyright (C) 1993 by David H. Gay and Andrew L. Rohl

dgay@ricx.royal-institution.ac.uk
andrew@ricx.royal-institution.ac.uk

Modified 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  
USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "gdis.h"
#include "coords.h"
#include "table.h"
#include "matrix.h"
#include "vector.h"
#include "surface.h"
#include "interface.h"

TABLE_TYPEDEF(vector) vector_table;
typedef gchar boolean;

/****************************************/
/* uses marvin code to create a surface */
/****************************************/
#define DEBUG_GENSURF 0
gint generate_surface(struct model_pak *src, struct model_pak *dest)
{
vector normal;
vector lattice_vector[3];    /* lattice vectors */
vector t_mat[3];             /* transformation matrix */
vector work_lat[3];          /* transformed lattice vectors */
vector rec_work_lat[3];      /* reciprocal transformed lattice vectors  
*/
vector s[3];                 /* space we are trying to fill */
vector rec_s[2];             /* reciprocal of s[0] and s[1] */
vector tempvec;
gdouble inv_denom;
gdouble shift, depth, depth_1, depth_2, depth_min;
gint c, i, j, h, k, l, n;
vector_table surf_vecs;
vector a, *v_a, *v_b;
gdouble gcd, cd, x;
boolean s2_found = FALSE;
gint la, ma, lb, mb, lc, mc; /* limits of lattice to fill piped */
gint ia, ib, ic, id;
gdouble z1_max, z1_min, z2_max, z2_min;
gdouble tempfloat;
gint region;
GSList *clist, *mlist;
struct core_pak *core;
struct shel_pak *shel;
struct mol_pak *mol;
gint flag, xlat[3];
gdouble tmat[9], norm[3], va[3];
gdouble temp[9], lpm[9];
gdouble sign, vec[3], vec2[3], dr[3], dn[3];
gint GCD(gint, gint);
void *our_alloc(void *, size_t, char *);
gint vector_compare(const void *, const void *);

/* NB: we now APPEND - so ensure we have no old crap in the lists */
g_assert(dest->cores == NULL);
g_assert(dest->shels == NULL);

/* find surface normal from the miller index and lattice vectors*/
V_ZERO(normal);

/* setup */
h = dest->surface.miller[0];
k = dest->surface.miller[1];
l = dest->surface.miller[2];

/* acquire lattice vectors */
V_X(lattice_vector[0]) = src->latmat[0];
V_Y(lattice_vector[0]) = src->latmat[3];
V_Z(lattice_vector[0]) = src->latmat[6];
V_X(lattice_vector[1]) = src->latmat[1];
V_Y(lattice_vector[1]) = src->latmat[4];
V_Z(lattice_vector[1]) = src->latmat[7];
V_X(lattice_vector[2]) = src->latmat[2];
V_Y(lattice_vector[2]) = src->latmat[5];
V_Z(lattice_vector[2]) = src->latmat[8];

V_CROSS(tempvec, lattice_vector[1], lattice_vector[2]);
V_QADD(normal, normal, +h*, tempvec);
V_CROSS(tempvec, lattice_vector[2], lattice_vector[0]);
V_QADD(normal, normal, +k*, tempvec);
V_CROSS(tempvec, lattice_vector[0], lattice_vector[1]);
V_QADD(normal, normal, +l*, tempvec);

/* set up table of surface vectors */
TABLE_INIT(surf_vecs);

c = (float) GCD(h, k);
cd = c ? c : 1.0;
V_2_ASSIGN(a, = k/cd * ,lattice_vector[0], - h/cd *, lattice_vector[1]);
if (V_MAGSQ(a) > EPSILON)
   {
   /* add a to table */
   TABLE_ADD_RECORD(surf_vecs, a);
   }

c = (float) GCD(h, l);
cd = c ? c : 1.0;
V_2_ASSIGN(a, = l/cd * ,lattice_vector[0], - h/cd *, lattice_vector[2]);
if (V_MAGSQ(a) > EPSILON)
   {
   /* add a to table */
   TABLE_ADD_RECORD(surf_vecs, a);
   }

c = (float) GCD(k, l);
cd = c ? c : 1.0;
V_2_ASSIGN(a, = l/cd * ,lattice_vector[1], - k/cd *, lattice_vector[2]);
if (V_MAGSQ(a) > EPSILON)
   {
   /* add a to table */
   TABLE_ADD_RECORD(surf_vecs, a);
   }

/* find number of entries in table */
n = TABLE_N(surf_vecs);

v_a = TABLE_R_ADRS(surf_vecs, 0);
/* loop over vectors from 0 to n-1 in table and store pointer in v_a */
TABLE_WHILE(surf_vecs, TABLE_INDEX(surf_vecs,v_a) < n-1, v_a)
   {
   v_b = v_a + 1;
   /* loop from v_a +1 to n and store pointer in v_b */
   TABLE_WHILE(surf_vecs, TABLE_INDEX(surf_vecs,v_b) < n, v_b)
     {
     V_2_ASSIGN(a, = , *v_a, + , *v_b);
     if (V_MAGSQ(a) > EPSILON)
       /* add a to table but don't loop v_a or v_b over the new surfvec  
*/
       TABLE_ADD_RECORD(surf_vecs,a);
     V_2_ASSIGN(a, = , *v_a, - , *v_b);
     if (V_MAGSQ(a) > EPSILON)
       /* add a to table but don't loop v_a or v_b over the new surfvec  
*/
       TABLE_ADD_RECORD(surf_vecs,a);
     }
   }
/* sort table */
TABLE_SORT(surf_vecs,vector_compare);

/* debug */
/*
TABLE_FOREACH(surf_vecs, v_a)
   {
   printf("vec %f %f %f\n",V_X(*v_a),V_Y(*v_a),V_Z(*v_a));
   }
*/

/* set v_a to first (shortest now sorted) vector */
v_a = TABLE_R_ADRS(surf_vecs,0);

v_b = v_a + 1;
/* loop over remaining vectors */
TABLE_WHILEEACH(surf_vecs, v_b)
   {
   V_CROSS(a,*v_a,*v_b);
   x = V_MAGSQ(a);
   if (x > EPSILON)
     {
     s2_found = TRUE;
     break;
     }
   }

if (!s2_found)
   {
   show_text(ERROR, "Failed to find surface vectors.\n");
   return(1);
   }

/* calculate transformation matrix */
V_SCALER(t_mat[2], (1.0/V_MAG(normal)), normal);
V_SCALER(t_mat[0], (1.0/V_MAG(*v_a)), *v_a);
V_CROSS(t_mat[1], t_mat[2], t_mat[0]);

/* CURRENT - converting... */
ARR3SET(norm, normal.element);
ARR3SET(va, v_a->element);
normalize(norm, 3);
normalize(va, 3);
ARR3SET(&tmat[6], norm);
ARR3SET(&tmat[0], va);
crossprod(&tmat[3], norm, va);

/* calculate transformed lattice vectors */
for (j = 0; j < 3; j++)
   for (i = 0; i < 3; i++)
     V_E(work_lat[j], i) = V_DOT(t_mat[i], lattice_vector[j]);

/* calculate reciprocal transformed lattice vectors */
V_CROSS(tempvec, work_lat[1], work_lat[2]);
inv_denom = 1.0 / V_DOT(tempvec, work_lat[0]);
V_CROSS(tempvec, work_lat[1], work_lat[2]);
V_SCALER(rec_work_lat[0], inv_denom, tempvec);
V_CROSS(tempvec, work_lat[2], work_lat[0]);
V_SCALER(rec_work_lat[1], inv_denom, tempvec);
V_CROSS(tempvec, work_lat[0], work_lat[1]);
V_SCALER(rec_work_lat[2], inv_denom, tempvec);


/* calculate transformed surface vectors */
for (i = 0; i < 3; i++)
   V_E(s[0], i) = V_DOT(t_mat[i], *v_a);
for (i = 0; i < 3; i++)
   V_E(s[1], i) = V_DOT(t_mat[i], *v_b);

/* return transformed surface vectors data in dest->latmat */
   /* NB: latmat[0..8] is a 3x3 matrix so, */
   /*
     | a b 0 |
     | c d 0 |
     | 0 0 0 |

     goes into latmat rows first ie a,b,0,c,d,0,0,0,0
   */

/* set s[2] = to depths */
/* depth = 1.0e10; */

/* surface specification */
gcd = GCD(GCD(h, k), GCD(k, l));
VEC3SET(vec, h, k, l);
vecmat(src->rlatmat, vec);

/* calculate the Dhkl */
/* NB: we want the correct dspacing wrt hkl, ie DON'T remove the GCD */
dest->surface.dspacing = 1.0/VEC3MAG(vec);

/* actual cut depth */
/* NB: done wrt the FULL depth (ie remove the gcd) */
depth = gcd/VEC3MAG(vec);
shift = dest->surface.shift * depth;
dest->surface.depth = depth;

#if DEBUG_GENSURF
printf("\n----------------------------\n");
printf("    hkl: %d %d %d\n", h, k, l);
printf("    gcd: %f \n", gcd);
printf("  shift: %f (zcut = %f)\n", dest->surface.shift, shift);
printf("regions: %d %d\n", dest->surface.region[0],  
dest->surface.region[1]);
printf("   Dhkl: %f\n", dest->surface.dspacing);
printf("  depth: %f\n", depth);
printf("----------------------------\n");
#endif

/* NB: depth_1 is region[0], but depth_2 is region[0]+region[1] */
depth_1 = dest->surface.region[0] * depth;
depth_2 = depth_1 + dest->surface.region[1] * depth;

V_ZERO(s[2]);
V_Z(s[2]) = -(depth_2);

/* transfer surface vectors */
VEC3SET(&dest->latmat[0], V_X(s[0]), V_X(s[1]), 0.0);
VEC3SET(&dest->latmat[3], V_Y(s[0]), V_Y(s[1]), 0.0);
VEC3SET(&dest->latmat[6], 0.0, 0.0, 1.0);

/* calculate reciprocal of two surface vectors */
inv_denom = 1.0 / (V_X(s[0])*V_Y(s[1]) - V_Y(s[0])*V_X(s[1]));
V_X(rec_s[0]) =  V_Y(s[1])*inv_denom;
V_Y(rec_s[0]) = -V_X(s[1])*inv_denom;
V_Z(rec_s[0]) =  0.0;
V_X(rec_s[1]) = -V_Y(s[0])*inv_denom;
V_Y(rec_s[1]) =  V_X(s[0])*inv_denom;
V_Z(rec_s[1]) =  0.0;

/* calculate extents of translations of transformed cell */
la = ma = lb = mb = lc = mc = 0.0;

#define INT_EPS 0.0001
x = V_DOT(rec_work_lat[0], s[0]);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], s[0]);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], s[0]);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

x = V_DOT(rec_work_lat[0], s[1]);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], s[1]);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], s[1]);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

x = V_DOT(rec_work_lat[0], s[2]);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], s[2]);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], s[2]);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

V_QADD(tempvec, s[0],+, s[1]);
x = V_DOT(rec_work_lat[0], tempvec);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], tempvec);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], tempvec);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

V_QADD(tempvec, s[0],+, s[2]);
x = V_DOT(rec_work_lat[0], tempvec);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], tempvec);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x;
x = V_DOT(rec_work_lat[2], tempvec);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

V_QADD(tempvec, s[1],+, s[2]);
x = V_DOT(rec_work_lat[0], tempvec);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], tempvec);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], tempvec);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;

V_QADD(tempvec, s[0],+, s[1]);
V_QADD(tempvec, tempvec,+, s[2]);
x = V_DOT(rec_work_lat[0], tempvec);
if (x > ma) ma = x + INT_EPS;
if (x < la) la = x - INT_EPS;
x = V_DOT(rec_work_lat[1], tempvec);
if (x > mb) mb = x + INT_EPS;
if (x < lb) lb = x - INT_EPS;
x = V_DOT(rec_work_lat[2], tempvec);
if (x > mc) mc = x + INT_EPS;
if (x < lc) lc = x - INT_EPS;
#undef INT_EPS

#define LATBUF 2
ma += LATBUF;
mb += LATBUF;
mc += LATBUF;
la -= LATBUF;
lb -= LATBUF;
lc -= LATBUF;

z2_min = z1_min = 0.00;
z2_max = V_Z(s[2]);
z1_max = depth_1 * (z2_max < 0 ? -1.0: +1.0);

if (z2_max < z2_min)
   {
   tempfloat = z2_max;
   z2_max = z2_min;
   z2_min = tempfloat;
   }
if (z1_max < z1_min)
   {
   tempfloat = z1_max;
   z1_max = z1_min;
   z1_min = tempfloat;
   }

/* display name */
g_free(dest->basename);
dest->basename = g_strdup_printf("%s_%-1d%-1d%-1d_%6.4f",
                  g_strstrip(src->basename), h, k, l,  
dest->surface.shift);

/* store the work lattice */
for (i=0 ; i<3 ; i++)
   {
   dest->surface.work_lat[3*i+0] = V_E(work_lat[0], i);
   dest->surface.work_lat[3*i+1] = V_E(work_lat[1], i);
   dest->surface.work_lat[3*i+2] = V_E(work_lat[2], i);
   }

#if DEBUG_GENSURF
P3MAT(" src lat: ", src->latmat);
P3MAT("work lat: ", dest->surface.work_lat);
#endif

/* construct the depth vector */
/* compute the surface normal */
VEC3SET(vec, dest->latmat[0], dest->latmat[3], dest->latmat[6]);
VEC3SET(vec2, dest->latmat[1], dest->latmat[4], dest->latmat[7]);
crossprod(dn, vec, vec2);
/* search for a vector with the smallest */
/* orthogonal component to the surface vectors??? */
flag=0;
/* testing flag avoids the need of setting this to some large number */
depth_min=0;
for (i=0 ; i<3 ; i++)
   {
/* ignore zero indices, which yield 0 orthogonal component */
   if (dest->surface.miller[i])
     {
/* dotproduct of vector with normal */
     ARR3SET(vec, dn);
     vec[0] *= dest->surface.work_lat[i];
     vec[1] *= dest->surface.work_lat[i+3];
     vec[2] *= dest->surface.work_lat[i+6];
     depth = fabs(vec[0] + vec[1] + vec[2]);

#if DEBUG_GENSURF
printf("[i=%d, depth=%f]", i, depth);
#endif

    if (flag)
      {
      if (depth > depth_min)
        continue;
      }
    else
      flag++;

     depth_min = depth;

/* ensure the depth vector is pointing in the +ve z direction */
     if (dest->surface.work_lat[i+6] < 0.0)
       sign = -1.0;
     else
       sign = 1.0;

     dest->latmat[2] = sign*dest->surface.work_lat[i];
     dest->latmat[5] = sign*dest->surface.work_lat[i+3];
     dest->latmat[8] = sign*dest->surface.work_lat[i+6];
     }
   }
#if DEBUG_GENSURF
printf(" : Minimum = %f\n", depth_min);
#endif

g_assert(flag != 0);

/* generate lattice matrix inverse */
memcpy(dest->ilatmat, dest->latmat, 9*sizeof(gdouble));
invmat(dest->ilatmat);

/* locate the position of the new cell's repeat vectors */
/* in terms of the lattice space of the source model */
/* this gives us the lattice point matrix (lpm) which */
/* is used to determine how many source unit cells */
/* will be required to fill out the new surface cell */
memcpy(lpm, dest->latmat, 9*sizeof(gdouble));
memcpy(temp, tmat, 9*sizeof(gdouble));
invmat(temp);
matmat(temp, lpm);
matmat(src->ilatmat, lpm);

#if DEBUG_GENSURF
P3MAT("tmat: ", tmat);
P3MAT("dest latmat: ", dest->latmat);
P3MAT("dest ilatmat: ", dest->ilatmat);
P3MAT("lpm: ", lpm);
#endif

/* setup repeats required to fill the new cell */
ma=mb=mc=1;

/* a direction repeat */
for (i=0 ; i<3 ; i++)
   {
/* NB: add tolerance, since precision can be a problem */
   ia = (gint) (FRACTION_TOLERANCE + fabs(lpm[i]));
   if (ia > ma)
     ma = ia;
   }
/* b direction repeat */
for (i=3 ; i<6 ; i++)
   {
/* NB: add tolerance, since precision can be a problem */
   ib = (gint) (FRACTION_TOLERANCE + fabs(lpm[i]));
   if (ib > mb)
     mb = ib;
   }
/* c direction repeat */
for (i=6 ; i<9 ; i++)
   {
/* NB: add tolerance, since precision can be a problem */
   ic = (gint) (FRACTION_TOLERANCE + fabs(lpm[i]));
   if (ic > mc)
     mc = ic;
   }

#if DEBUG_GENSURF
printf("ma=%d, mb=%d, mc=%d\n", ma, mb, mc);
#endif

/* required depth */
for (id=0 ; id<dest->surface.region[0]+dest->surface.region[1] ; id++)
   {
/* set current region */
   if (id < dest->surface.region[0])
     region = REGION1A;
   else
     region = REGION2A;

/* full loop required to cover one cell in the transformed coordinates  
*/
for (ic=0 ; ic<mc ; ic++)
   {
   for (ib=0 ; ib<mb ; ib++)
     {
     for (ia=0 ; ia<ma ; ia++)
       {
/* current source cell translation */
       VEC3SET(vec, ia, ib, ic);

/* loop over all molecules */
       for (mlist=src->moles ; mlist ; mlist=g_slist_next(mlist))
         {
         mol = (struct mol_pak *) mlist->data;

/* transformation pipline... */
/* TODO - combine the steps below into one 4D matrix mult */
         ARR3SET(va, mol->centroid);
/* add cell offset */
         ARR3ADD(va, vec);
/* get cartesian */
         vecmat(src->latmat, va);
/* transform */
         vecmat(tmat, va);
/* convert to fractional */
         vecmat(dest->ilatmat, va);
/* incorporate the shift */
         va[2] += dest->surface.shift;
/* calculate translation required to bring the */
/* molecule within the required surface cell */
         VEC3SET(xlat, 0.0, 0.0, 0.0);
         fractional_clamp(va, xlat, 3);

/* shunt cell down, then subtract region offset */
/* NB: z is reversed for surfaces */
         xlat[2] -= 1+id;

/*
printf("xlat [%d %d %d]\n", xlat[0], xlat[1], xlat[2]);
P3VEC("mol 2: ", va);
*/

/* loop over all atoms in molecule */
         for (clist=mol->cores ; clist ; clist=g_slist_next(clist))
           {
/* dup_core() will duplicate an attached shell as well */
           core = dup_core(clist->data);
           dest->cores = g_slist_prepend(dest->cores, core);

/* store in case need to xlat an assoc. shell */
           ARR3SET(dr, core->x);

/* transformation pipline... */
/* TODO - combine the steps below into one 4D matrix mult */

/* add cell offset */
           ARR3ADD(core->x, vec);
/* get cartesian */
           vecmat(src->latmat, core->x);
/* transform */
           vecmat(tmat, core->x);
/* convert to fractional */
           vecmat(dest->ilatmat, core->x);
/* incorporate the shift */
           core->x[2] += dest->surface.shift;
/* add required (centroid based - see above) fractional translation */
           ARR3ADD(core->x, xlat);
/* convert to cartesian */
           vecmat(dest->latmat, core->x);

/* init flags */
           core->primary = TRUE;
           core->orig = TRUE;
           core->region = region;

/* shell */
           if (core->shell)
             {
             dest->shels = g_slist_prepend(dest->shels, core->shell);
             shel = core->shell;

/* NEW - core-shell links are lost if "split" by the pbc */
/* NEW - solution is to translate the shell to be close to the core */
             ARR3SUB(dr, shel->x);
             for (i=3; i-- ; )
               {
               while (dr[i] > 0.5)
                 {
                 shel->x[i] += 1.0;
                 dr[i] -= 1.0;
                 }
               while (dr[i] < -0.5)
                 {
                 shel->x[i] -= 1.0;
                 dr[i] += 1.0;
                 }
               }

/* transformation pipline... */
/* TODO - combine the steps below into one 4D matrix mult */

/* add cell offset */
             ARR3ADD(shel->x, vec);
/* get cartesian */
             vecmat(src->latmat, shel->x);
/* transform */
             vecmat(tmat, shel->x);
/* convert to fractional */
             vecmat(dest->ilatmat, shel->x);
/* incorporate the shift */
             shel->x[2] += dest->surface.shift;
/* add required (centroid based - see above) fractional translation */
             ARR3ADD(shel->x, xlat);

/* convert to cartesian */
             vecmat(dest->latmat, shel->x);

/* init flags */
             shel->primary = TRUE;
             shel->orig = TRUE;
             shel->region = region;
             }
           }
         }
       }
     }
   }
   }

/* adjust depth translation vector to account for region sizes */
dest->latmat[2] *= dest->surface.region[0]+dest->surface.region[1];
dest->latmat[5] *= dest->surface.region[0]+dest->surface.region[1];
dest->latmat[8] *= dest->surface.region[0]+dest->surface.region[1];

/* surface cell init */
dest->periodic = 2;
dest->fractional = FALSE;
dest->axes_type = CARTESIAN;
dest->sginfo.spacenum = 1;
dest->construct_pbc = TRUE;

/* surface cell type */
if (src->surface.true_cell)
   dest->surface.true_cell = TRUE;
else
   {
   dest->surface.true_cell = FALSE;

/* want to force c to be // to z */
/* NB: vectors are in columns */
   dest->latmat[2] = 0.0;
   dest->latmat[5] = 0.0;
   }

/* free surface vectors */
TABLE_FREE(surf_vecs);

#if DEBUG_GENSURF
printf("gensurf cores: %d\n", g_slist_length(dest->cores));
printf("gensurf shels: %d\n", g_slist_length(dest->shels));
#endif

/* build mode follows source structure */
dest->build_molecules = src->build_molecules;

return(0);
}

/ 
************************************************************************ 
******
  * GCD
  *      Greatest common denominator
   
************************************************************************ 
******/
gint GCD(gint p, gint q)
{
#if defined(__MWERKS__)  /* fix for compiler bug! */
   gint  i;

   if (q == 0) {
     i = abs(p);
     return(i);
   }
#else
   if (q == 0)
     return(abs(p));
#endif
   else
     return(GCD(q, p%q));
}

/ 
************************************************************************ 
******
  * vector_compare
  *      compare two vectors returning their difference as an integer.   
This
  *      routine is to be used in conjuction with SORT().
   
************************************************************************ 
******/
int vector_compare (const void *x, const void *y)
{
int i;
vector  *a, *b;
double  diff;

a = (vector *) x;
b = (vector *) y;
diff = V_MAGSQ(*a) - V_MAGSQ(*b);
if (diff < -EPSILON)
   return(-1);
else if (diff > EPSILON)
   return(1);
else
   {
/* magnitude of a & b is the same, so sort based on element magnitudes  
*/
   for (i=0 ; i<3 ; i++)
     {
     diff = V_E(*a,i) - V_E(*b,i);
     if (diff < -EPSILON)
       return(1);
     else if (diff > EPSILON)
       return(-1);
     }
   }
/* a & b are identical */
return(0);
}


void *our_alloc(void *ptr, size_t size, gchar *err_msg)
{
void  *space;

if (size == 0)                    /* asks for ZERO elements */
   return NULL;

space = NULL;

/* FIXME - mgo: add 10 faces, calc valid shifts (all planes) falls over  
here */
if (ptr == NULL)
   space = g_malloc(size);
else
   space = g_realloc(ptr, size);

/* redundant - g_malloc functions fall over if memory allocation fails  
*/
if (space == NULL)
   {
   fprintf(stderr, "Cannot malloc memory %s\n", err_msg);
   exit(1);
   }
return space;
}


