from ContainerTarget import ContainerTarget
from DisplayTarget import DisplayTarget
from utils.datatypes import *

import gtk



#
# Class for aligning targets.
#
class TargetAlignment(ContainerTarget):

    def __init__(self, parent, display):

        self.__alignment = (0.0, 0.0)

        
        ContainerTarget.__init__(self, parent, display)
        self.__align = gtk.Alignment(0.5, 1, 0, 0)
        self.__align.show()
        self.add(self.__align)

        self._set_property_type("align-x", TYPE_FLOAT)
        self._set_property_type("align-y", TYPE_FLOAT)



    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.__align.add(self._get_child())
        self._init_children()



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "align-x"):
            ax, ay = self.__alignment
            self.__align.set(value, ay, 0, 0)
            self.__alignment = (value, ay)
                
        elif (key == "align-y"):
            ax, ay = self.__alignment
            self.__align.set(ax, value, 0, 0)
            self.__alignment = (ax, value)

        else:
            ContainerTarget.set_config(self, key, value)



    def handle_action(self, action, px, py, path, args):

        DisplayTarget.handle_action(self, action, px, py, path[:], args)

        if (self.get_index() != -1): path.append(self.get_index())

        bw, bn, be, bs = self.get_border_size()
        child = self._get_child()
        px -= bw; py -= bn

        align_x, align_y = self.__alignment
        x, y, w, h = self.get_geometry()
        cx, cy, cw, ch = child.get_geometry()
        cx = (w - cw) * align_x
        cy = (h - ch) * align_y
        
        if (cx <= px <= cx + cw and cy <= py <= cy + ch):
            child.handle_action(action, px - cx, py - cy, path[:], args)
            child.notify_handle_action(1, path[:])
        else:
            child.notify_handle_action(0, path[:])
