#!/usr/bin/env python
# -*- coding: UTF-8 -*-
"""
    Modul:          Seti/__init__.py
    Description:    seti@home sensor for gDesklets
    Version:        V0.2
    Copyright:      2003 by Fritz Cizmarov <fritz at boa3d de>
    Created         21. Sep. 2003
    Last modified:  27. Sep. 2003
    License:        
    Exports:        Classes and Functions to export
"""
from time import time
import os
from sensor.Sensor import Sensor
from utils.datatypes import *
from utils import i18n 
from sah import Seti_Data, OK, NOT_RUNNING, CONNECTING

_ = i18n.Translator("setiathome")

class Seti(Sensor):
    
    def __init__(self, logo = "gfx/seti_%s.png", i1 = "!", i2 = "2", i3 = "3"):
        Sensor.__init__(self)
        self._set_config_type("seti_path", TYPE_STRING, "")
        self._set_config_type("interval", TYPE_INT, 10)
        self._set_config_type("font", TYPE_STRING, "Sans 9")
        self._set_config_type("fcolor", TYPE_STRING, "Black")
        self.sah = Seti_Data("")
        self.sah.clear_all()
        self.path = self.sah.path
        self.interval = -1
        self.font = "Sans 9"
        self.fcolor = "Black"
        self.logo = logo
        self.icons = [i1, i2, i3]
        self.ci = 0
        self.first_time = True
        self.to_send = [] # name-value-pairs to send
        self.sah.set_notify("user_info.sah", "nresults", self.do_notify)
        self.sah.set_notify("state.sah", "bs_power", self.do_notify)
        self.sah.set_notify("state.sah", "bg_score", self.do_notify)
        self.sah.set_notify("state.sah", "prog", self.do_notify)
        self._add_timer(1000, self.do_timer)
        
        
    def get_configurator(self):
        self._set_config("seti_path", self.path)
        cfg = self._new_configurator()
        cfg.set_name(_("SETI@home"))
        cfg.add_title(_("SETI@Home Desklet\nSettings"))
        cfg.add_entry(_("SETI@home path:"), "seti_path",  _("Path to SETI@Home data."))
        cfg.add_spin(_("Update every (s):"), "interval",
                     _("Updates the display every x milliseconds"),
                     1, 3600)
        cfg.add_font_selector(_("Font:"), "font", 
                              _("The font which is used to display the labels"))
        cfg.add_color_selector(_("Text color:"), "fcolor",
                               _("The Color of the labels"))
        return cfg
    
    
    def __update_config(self):
        path = os.path.expanduser(self._get_config("seti_path"))
        font = self._get_config("font")
        fcolor = self._get_config("fcolor")

        if (self.font, self.fcolor) != (font, fcolor):
            if self.font != font:
                self.to_send.append(("font", font))
                self.font = font
            if self.fcolor != fcolor:
                self.to_send.append(("fcolor", fcolor))
                self.fcolor = fcolor

        if (self.path != path) and os.path.exists(path):
            self.sah.new_path(path)
            self.path = path


    def do_notify(self, name, value):
        print name, value
        if name == "nresults":
            value = "%d" % (value + 1)
        elif name == "bs_power":
            value = "%.2f" % value
        elif name == "bg_score":
            value = "%.2f" % value
        elif name == "prog":
            percent = value * 100.0
            if percent > 100.0:
                percent = 100.0
            elif percent < 0.0:
                percent = 0.0
            self.to_send.append(("percent", "%2.2f%%" % percent))
            self.to_send.append(("gauge", round(percent+0.5)))
        else:
            return
        self.to_send.append((name, value))
    
    
    def do_timer(self):
        output = self._new_output()
        if self.first_time:
            output.set("cpu", "00:00:00")
            output.set("bs_power", "0.00")
            output.set("bg_score", "0.00")
            output.set("percent", "00.00%")
            output.set("gauge", 0.0)
            output.set("nresults", "0")
            output.set("font", self.font)
            output.set("fcolor", self.fcolor)
            output.set("icon", self.logo % self.icons[1])
            self.ci = 1
            self.first_time = False
        else:
            self.interval -= 1
            if self.interval < 0:
                self.interval = self._get_config("interval")-1
                self.to_send = []
                self.__update_config()
                self.sah.update_all()
                for key, value in self.to_send:
                    output.set(key, value)

            if self.sah.status == OK:
                if self.ci != 0:
                    self.ci = 0
                    output.set("icon", self.logo % self.icons[0])
            elif self.sah.status == NOT_RUNNING:
                if self.ci != 1:
                    self.ci = 1
                    output.set("icon", self.logo % self.icons[1])
            elif self.sah.status == CONNECTING:
                self.ci = (self.ci % 2) + 1 
                output.set("icon", self.logo % self.icons[self.ci])
                
            t = self.sah.real_cpu_time()
            if t:
                cpu = "%02d:%02d:%02d" % (t/3600, t/60%60, t%60)
            else:
                if self.interval % 2:
                    cpu = "00:00:00"
                else:
                    cpu = "~~:~~:~~"
            output.set("cpu", cpu)
        self._send_output(output)
        return 1


def new_sensor(args): return apply(Seti, args)

if __name__=="__main__":
    pass
    
