#!/usr/bin/env python2.5
# -*- Mode: python; coding: utf-8 -*-

import pygtk, gtk, gtk.glade, pango, gobject
import gettext
import dbus
from glob import glob
import os, stat, time
import subprocess



# TODO: es fehlt noch:
# TODO: * passwort/keyfiles


TYPE_TRUECRYPT = 1
TYPE_LUKS = 2


SUPPORTED_FS = ['ntfs', 'ext2', 'ext3', 'vfat']
DEFAULT_FS = 'ext3'

class CreateUI:

	logtext = ''
	c_path = None
	should_move = False

	def get_next_page(self, current_page):
		if current_page == 4 and not self.is_file(self.c_path): # skip file size question if it's not a file
			if self.get_type() == TYPE_TRUECRYPT:
				return 7
			elif self.get_type() == TYPE_LUKS:
				return 6
		if current_page == 5 and self.get_type() == TYPE_TRUECRYPT:
			return 7
		if current_page == 6:
			return 8
		return current_page+1

	def destroy(self, widget):
		widget.destroy()

	def __init__(self, quit=None, parent=None):
		gettext.install('gdecrypt')
		self.tree = gtk.glade.XML("createui.glade", "assistant1")
		self.ass = self.tree.get_widget("assistant1")
		if parent != None:
			self.ass.set_parent(parent)
		if quit == None:
			quit = self.destroy
		self.tree.signal_autoconnect({'assistant1_close_cb':quit,'assistant1_cancel_cb':quit, 'assistant1_destroy_cb':quit, 
				'assistant1_prepare_cb':self.prepare, "comboboxentry1_changed_cb":self.comboboxentry1_changed_cb,
				'tc_usekeyfilebutton_toggled_cb':self.tc_usekeyfilebutton_toggled_cb, 'luks_usekeyfilebutton_toggled_cb':self.luks_usekeyfilebutton_toggled_cb,
				'luks_usepassbutton_toggled_cb':self.luks_usepassbutton_toggled_cb, 'pass1_changed_cb':self.pass_changed_cb, 'pass2_changed_cb':self.pass_changed_cb,
				'keyfile_file_set_cb':self.pass_changed_cb})


		self.ass.set_forward_page_func(self.get_next_page)

		self.type_text = """Please choose the type of encryption the container should use.

Note that Truecrypt has cross-platform support while LUKS has better Linux-only support and can easily be integrated in the initramfs for encrypting system-partitions."""

		self.tree.get_widget("radiobutton1").set_active(True)
		self.bold_tag = self.tree.get_widget('textview1').get_buffer().create_tag("b")
		self.bold_tag.set_property('weight',pango.WEIGHT_BOLD)

		# initialize cipher ComboBoxes
		for cbname in ['encbox', 'hashbox']:
			b = self.tree.get_widget(cbname)
			b.set_model(gtk.ListStore(gobject.TYPE_STRING))
			bcell = gtk.CellRendererText()
			b.pack_start(bcell)
			b.add_attribute(bcell,'text',0)
		self.tree.get_widget('encbox').connect_after('changed', self.encbox_changed_cb)

		# set comboboxentry up
		cbe1 = self.tree.get_widget("comboboxentry1")
		self.partitionmodel = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gtk.gdk.Pixbuf)
		cbe1.set_model(self.partitionmodel)

		pbcell = gtk.CellRendererPixbuf()
		cell = gtk.CellRendererText()
		cell.set_property('xalign', 1)
		cell.set_property('xpad', 15)
		cbe1.pack_end(cell, True)
		cbe1.pack_end(pbcell, False)
		cbe1.add_attribute(cell, 'text', 1)
		cbe1.add_attribute(pbcell, 'pixbuf', 2)
		cbe1.set_text_column(0)
		self.partitionmodel.append(("", _("Select container file"), gtk.icon_theme_get_default().load_icon("gtk-open",24,0)))
		

		# fill comboboxentry
		self.bus = dbus.SystemBus()
		self.hal_manager = self.bus.get_object('org.freedesktop.Hal', '/org/freedesktop/Hal/Manager')
		self.hal_man_iface = dbus.Interface(self.hal_manager, dbus_interface="org.freedesktop.Hal.Manager")
		volume_udi_list = self.hal_man_iface.FindDeviceByCapability ('volume')
		for udi in volume_udi_list:
			volume = self.bus.get_object ('org.freedesktop.Hal', udi)
			volume_iface = dbus.Interface(volume, 'org.freedesktop.Hal.Device')
			if volume_iface.GetProperty("volume.is_mounted"): # ignore mounted volumes
				continue
			device_file = volume_iface.GetProperty ('block.device')
			size = volume_iface.GetProperty('volume.size')
			label = volume_iface.GetProperty('volume.label')
			if label:
				self.partitionmodel.prepend(("%s" % device_file, "%.2f GiB — %s"%((size/(1024*1024*1024.0)),label), None))
			else:
				self.partitionmodel.prepend(("%s" % device_file, "%.2f GiB"%(size/(1024*1024*1024.0)), None))


		self.fsbox = self.tree.get_widget('fsbox')
		self.fsbox.clear()
		self.fsbox.set_model(gtk.ListStore(gobject.TYPE_STRING))
		fscell = gtk.CellRendererText()
		self.fsbox.pack_start(fscell)
		self.fsbox.add_attribute(fscell,'text',0)
		self.fsbox.append_text("None")
		self.fsbox.set_active(0)
		for fs in glob('/sbin/mkfs.*'):
			fs_str = '.'.join(fs.split(".")[1:])
			if fs_str in SUPPORTED_FS:
				self.fsbox.append_text(fs_str)
				if fs_str == DEFAULT_FS:
					self.fsbox.set_active(len(self.fsbox.get_model())-1)
		self.ass.set_page_complete ( self.fsbox.get_parent(), True)

		self.tree.get_widget('luks_usekeyfilebutton').set_active(False)
		self.tree.get_widget('luks_usepassbutton').set_active(True)
		self.tree.get_widget('tc_usekeyfilebutton').set_active(False)



		self.ass.set_page_complete( self.tree.get_widget("label1"), True)
		self.ass.show_all();

	def prepare(self, widget, page):
		if page == self.tree.get_widget("typeselbox"):
			self.c_path = os.path.abspath(self.tree.get_widget("comboboxentry1").child.get_text())
			while os.path.islink(self.c_path):
				self.c_path = os.readlink(self.c_path)
			if not self.is_file(self.c_path): 
				self.tree.get_widget("radiobutton2").set_sensitive(True)
				self.tree.get_widget("label3").set_markup(self.type_text)
			else:
				self.tree.get_widget("radiobutton2").set_sensitive(False)
				self.tree.get_widget("radiobutton1").set_active(True)
				self.tree.get_widget("radiobutton2").set_active(False)
				self.tree.get_widget("label3").set_markup(self.type_text+'\n\n'+_("<b>%s is not a block device, LUKS will not be available!</b>")%self.c_path)
			widget.set_page_complete(page, True)
		elif page == self.tree.get_widget('methbox'):
			dtype = self.get_type()
			eb = self.tree.get_widget('encbox')
			hb = self.tree.get_widget('hashbox')
			eb.get_model().clear()
			hb.get_model().clear()
			if dtype == TYPE_TRUECRYPT:
				self.tree.get_widget('e_label').set_text(_("Encryption method:"))
				self.tree.get_widget('h_label').set_text(_("Hash method:"))

				for i in ['AES', 'Blowfish', 'CAST5', 'Serpent', 'Triple', 'Twofish', 'AES-Twofish', 'AES-Twofish-Serpent', 'Serpent-AES', 'Serpent-Twofish-AES', 'Twofish-Serpent']:
					eb.append_text(i)
				for i in ['RIPEMD-160', 'SHA-1', 'Whirlpool']:
					hb.append_text(i)

			elif dtype == TYPE_LUKS:
				self.tree.get_widget('e_label').set_text(_("Encryption method:"))
				self.tree.get_widget('h_label').set_text(_("Key length:"))
				for i in [ x+'-'+y for y in ['lrw-benbi','xts-plain','cbc-essiv:sha256'] for x in ['aes','serpent'] ]:
					eb.append_text(i)
				for i in ['256','320','384']:
					hb.append_text(i)
				

			eb.set_active(0)
			hb.set_active(0)
			widget.set_page_complete(page, True)
				
		elif page == self.tree.get_widget('sizebox'):
			checked_mount_point = os.path.abspath(self.c_path)
			while not os.path.ismount(checked_mount_point):
				checked_mount_point = os.path.dirname(checked_mount_point)

			# mountpoints and devices could contain spaces, so we can't just split
			# we remove the mountpoint from the end of the output, then we split and
			# take the free space, which is the second field from the end now
			free_space_kb = int(os.popen("df -P '%s'"%checked_mount_point).readlines()[-1][:-len(checked_mount_point)-1].split()[-2])
			free_space_mb = free_space_kb/1000.0
			self.tree.get_widget('sizebutton').get_adjustment().upper=free_space_mb
			widget.set_page_complete(page, True)

		elif page == self.tree.get_widget('summbox'):
			eb = self.tree.get_widget('encbox')
			hb = self.tree.get_widget('hashbox')
			tw = self.tree.get_widget('textview1')
		
			if self.is_file(self.c_path):
				size = self.tree.get_widget('sizebutton').get_value()
			else:
				udis = self.hal_man_iface.FindDeviceStringMatch('block.device', self.c_path)
				assert len(udis) == 1, 'Invalid number of results when searching for block.device = %s; udis = %s'%(self.c_path, udis)
				dbus_hal_volume = self.bus.get_object ('org.freedesktop.Hal', udis[0])
				size = dbus.Interface(dbus_hal_volume,
						'org.freedesktop.Hal.Device').GetProperty(
								'volume.size')/(1000*1000.0)
				

			str_type = "undefined"
			dtype = self.get_type()
			if dtype == TYPE_TRUECRYPT:
				str_type = "Truecrypt"
			elif dtype == TYPE_LUKS:
				str_type = "LUKS"

			tb = tw.get_buffer()
			tb.set_text("\n")
			
			self.tree.get_widget('label4').set_markup(self.tree.get_widget('label4').get_text()+'\n'+_('<b>Any data previously on %s will be destroyed!</b>')%self.c_path)
			tb.insert_with_tags(tb.get_end_iter(),self.c_path, self.bold_tag)
			tb.insert(tb.get_end_iter()," will be encrypted using ")
			tb.insert_with_tags(tb.get_end_iter(),str_type,self.bold_tag)
			if dtype == TYPE_TRUECRYPT:
				if self.tree.get_widget('tc_usekeyfilebutton').get_active():
					tb.insert_with_tags(tb.get_end_iter(), ' '+_("(with password and keyfile: %s)")%self.tree.get_widget('tc_keyfile').get_filename(), self.bold_tag)
				else:
					tb.insert_with_tags(tb.get_end_iter(), ' '+_("(with password and without keyfile)"), self.bold_tag)
				tb.insert(tb.get_end_iter(),'\n'+_("Encryption method:")+" ")
				tb.insert_with_tags(tb.get_end_iter(),eb.get_model().get_value(eb.get_active_iter(), 0),self.bold_tag)
				tb.insert(tb.get_end_iter(),'\n'+_("Hash method:")+" ")
				tb.insert_with_tags(tb.get_end_iter(),hb.get_model().get_value(hb.get_active_iter(), 0),self.bold_tag)
			elif dtype == TYPE_LUKS:
				if self.tree.get_widget('luks_usekeyfilebutton').get_active():
					tb.insert_with_tags(tb.get_end_iter(), ' '+_("(with keyfile: %s)")%self.tree.get_widget('luks_keyfile').get_filename(), self.bold_tag)
				else:
					tb.insert_with_tags(tb.get_end_iter(), ' '+_("(with password)"), self.bold_tag)
				tb.insert(tb.get_end_iter(),'\n'+_("Encryption method:")+" ")
				tb.insert_with_tags(tb.get_end_iter(),eb.get_model().get_value(eb.get_active_iter(), 0),self.bold_tag)
				tb.insert(tb.get_end_iter(),'\n'+_("Key length:")+" ")
				tb.insert_with_tags(tb.get_end_iter(),hb.get_model().get_value(hb.get_active_iter(), 0),self.bold_tag)
			tb.insert(tb.get_end_iter(), '\n'+_("Filesystem:")+" ")
			tb.insert_with_tags(tb.get_end_iter(), self.fsbox.get_model().get_value(self.fsbox.get_active_iter(),0), self.bold_tag)
			tb.insert(tb.get_end_iter(), '\n'+_("Size:")+" ")
			tb.insert_with_tags(tb.get_end_iter(), '%.2f MB'%size, self.bold_tag)
			widget.set_page_complete(page, True)
		elif page == self.tree.get_widget('progressbox'):
			self.encrypt(widget,page)
		elif page == self.tree.get_widget('byebox'):
			tw = self.tree.get_widget('textview2')
			tb = tw.get_buffer()
			tb.set_text(self.logtext)
			

	def comboboxentry1_changed_cb(self, widget):
		if widget.get_active() < len(widget.get_model()) -1:
			self.ass.set_page_complete( widget.get_parent(), len(widget.child.get_text()) > 0 )
			return

		dlg = gtk.FileChooserDialog(title=_("Select container file"), action=gtk.FILE_CHOOSER_ACTION_SAVE, buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
		dlg.set_do_overwrite_confirmation(True)

		if dlg.run() == gtk.RESPONSE_OK:
			widget.child.set_text(dlg.get_filename())
		else:
			widget.set_active(-1)
		self.ass.set_page_complete( widget.get_parent(), len(widget.child.get_text()) > 0 )

		dlg.destroy()

	def encbox_changed_cb(self, widget):
		if self.get_type() == TYPE_LUKS:
			ai = widget.get_active_iter()
			if not ai:
				return
			text = widget.get_model().get_value(ai, 0).split("-")
			ciph = text[0]
			meth = text[1]
			hb = self.tree.get_widget('hashbox')
			hb.get_model().clear()
			csizes = [0]
			msizes = [0]
			results = []
			if ciph == "aes":
				csizes = [128,192,256]
			elif ciph == "serpent":
				csizes = range(0,256+8,8)[1:]
			if meth == 'lrw':
				msizes = [128]
			elif meth == 'xts':
				results = [256,384,512]

			if len(results) == 0:
				for csize in csizes:
					for msize in msizes:
						results.append(csize+msize)
			for i in sorted(results,reverse=True):
				hb.append_text(str(i))
			hb.set_active(0)

	def get_type(self):
		assert (self.tree.get_widget("radiobutton1").get_active() and not self.tree.get_widget("radiobutton2").get_active()) or (not self.tree.get_widget("radiobutton1").get_active() and self.tree.get_widget("radiobutton2").get_active()), "Invalid type selection, this is a bug!"
		
		if self.tree.get_widget("radiobutton1").get_active() and not self.tree.get_widget("radiobutton2").get_active():
			return TYPE_TRUECRYPT
		elif not self.tree.get_widget("radiobutton1").get_active() and self.tree.get_widget("radiobutton2").get_active():
			return TYPE_LUKS

	def is_file(self, path):
		''' returns true if path doesn't exist or if it is not a block device 
		used for determining if path will be a truecrypt-file '''
		return not os.access(path, os.F_OK) or not stat.S_ISBLK(os.stat(path)[stat.ST_MODE])

	def tc_usekeyfilebutton_toggled_cb(self, widget):
		self.tree.get_widget('tc_keyfile').set_sensitive(widget.get_active())
		self.pass_changed_cb(widget)

	def luks_usekeyfilebutton_toggled_cb(self, widget):
		self.tree.get_widget('luks_keyfile').set_sensitive(widget.get_active())
		self.pass_changed_cb(widget)

	def luks_usepassbutton_toggled_cb(self, widget):
		self.tree.get_widget('luks_pass1').set_sensitive(widget.get_active())
		self.tree.get_widget('luks_pass2').set_sensitive(widget.get_active())
		self.pass_changed_cb(widget)

	def pass_changed_cb(self, widget):
		dtype = self.get_type()
		if dtype == TYPE_TRUECRYPT:
			p1 = self.tree.get_widget('tc_pass1').get_text()
			p2 = self.tree.get_widget('tc_pass2').get_text()
			use_kf = self.tree.get_widget('tc_usekeyfilebutton').get_active()
			kf = self.tree.get_widget('tc_keyfile').get_filename()
			self.ass.set_page_complete( self.tree.get_widget('tc_pw_box') , (len(p1) > 0 and p1 == p2) and (not use_kf or (kf != None and os.access(kf, os.R_OK))))
		elif dtype == TYPE_LUKS:
			use_pass = self.tree.get_widget('luks_usepassbutton').get_active()
			p1 = self.tree.get_widget('luks_pass1').get_text()
			p2 = self.tree.get_widget('luks_pass2').get_text()
			use_kf = self.tree.get_widget('luks_usekeyfilebutton').get_active()
			kf = self.tree.get_widget('luks_keyfile').get_filename()
			self.ass.set_page_complete( self.tree.get_widget('luks_pw_box') , (use_pass and len(p1) > 0 and p1 == p2) or (use_kf and kf != None and os.access(kf, os.R_OK)))

	def pulse_luks_enc_progress_bar(self, p):
		if p.poll() == None: # True if not yet terminated
			self.tree.get_widget('progressbar1').pulse()
			return True
		else:
			self.logtext += _('Encryption:')+'\n%s\n\n\n'%p.stderr.read()
			if p.returncode == 0:
				decrypt_p = None
				if self.tree.get_widget('luks_usekeyfilebutton').get_active():
					decrypt_p = subprocess.Popen(('cryptsetup','--key-file', self.tree.get_widget('luks_keyfile').get_filename(), 'luksOpen',self.c_path, os.path.basename(self.c_path)), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE) 
				else:
					decrypt_p = subprocess.Popen(('cryptsetup','luksOpen',self.c_path, os.path.basename(self.c_path)), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE) 
					decrypt_p.stdin.write(self.tree.get_widget('luks_pass1').get_text()+'\n')
				gobject.timeout_add(200, self.pulse_luks_dec_progress_bar, decrypt_p)
			else:
				self.tree.get_widget('progressbar1').set_fraction(0)
				self.tree.get_widget('progressbar1').set_text('Failed: %d'%p.returncode)
				self.ass.set_page_complete( self.tree.get_widget('progressbox'), True)
			return False

	def pulse_luks_dec_progress_bar(self, p):
		if p.poll() == None: # True if not yet terminated
			self.tree.get_widget('progressbar1').pulse()
			return True
		else:
			self.logtext += _('Preparation:')+'\n' + p.stderr.read()
			if p.returncode == 0:
				fsp = subprocess.Popen(("mkfs."+self.fsbox.get_model().get_value(self.fsbox.get_active_iter(),0),'/dev/mapper/'+os.path.basename(self.c_path)), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
				gobject.timeout_add(200, self.pulse_fs_progress_bar, fsp, ('cryptsetup','luksClose', os.path.basename(self.c_path)))
			else:
				self.tree.get_widget('progressbar1').set_fraction(0)
				self.tree.get_widget('progressbar1').set_text('Failed: %d'%p.returncode)
				self.ass.set_page_complete( self.tree.get_widget('progressbox'), True)
			return False

	def pulse_tc_enc_progress_bar(self, p):
		if p.poll() == None: # True if not yet terminated
			self.tree.get_widget('progressbar1').pulse()
			return True
		else:
			self.logtext += _('Encryption:')+'\n%s\n\n\n'%p.stderr.read()
			if p.returncode == 0:
				# set the uid and gid to the user if self.c_path is a TC-container
				# and if SUDO_ env-vars are available
				sudo_uid = os.getenv('SUDO_UID') or ''
				sudo_gid = os.getenv('SUDO_GID') or 'root'
				if self.get_type() == TYPE_TRUECRYPT and self.is_file(self.c_path) and sudo_uid != '':
					chownp = subprocess.Popen(('chown',sudo_uid+':'+sudo_gid, self.c_path))
					chownp = subprocess.Popen(('chmod','u=rw,g=rw,o=', self.c_path))

				# open the container
				if self.tree.get_widget('tc_usekeyfilebutton').get_active():
					decrypt_p = subprocess.Popen(('truecrypt', '--keyfile',self.tree.get_widget('tc_keyfile').get_filename(),self.c_path), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE) 
				else:
					decrypt_p = subprocess.Popen(('truecrypt', self.c_path), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE) 
				decrypt_p.stdin.write(self.tree.get_widget('tc_pass1').get_text()+'\n')

				gobject.timeout_add(200, self.pulse_tc_dec_progress_bar, decrypt_p)
			else:
				self.tree.get_widget('progressbar1').set_fraction(0)
				self.tree.get_widget('progressbar1').set_text('Failed: %d'%p.returncode)
				self.ass.set_page_complete( self.tree.get_widget('progressbox'), True)
			return False

	def pulse_tc_dec_progress_bar(self, p):
		if p.poll() == None: # True if not yet terminated
			self.tree.get_widget('progressbar1').pulse()
			return True
		else:
			self.logtext += _('Preparation:')+'\n' + p.stderr.read()
			if p.returncode == 0:
				N = -1
				for line in subprocess.Popen(('truecrypt','-l'), stdout=subprocess.PIPE).communicate()[0].splitlines():
					if line.endswith(self.c_path):
						N = line[len('/dev/mapper/truecrypt'):].split()[0]
				fsp = subprocess.Popen(("mkfs."+self.fsbox.get_model().get_value(self.fsbox.get_active_iter(),0), '/dev/mapper/truecrypt'+N), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
				gobject.timeout_add(200, self.pulse_fs_progress_bar, fsp, ('truecrypt','-d', N))
			else:
				self.tree.get_widget('progressbar1').set_fraction(0)
				self.tree.get_widget('progressbar1').set_text('Failed: %d'%p.returncode)
				self.ass.set_page_complete( self.tree.get_widget('progressbox'), True)
			return False

	def pulse_fs_progress_bar(self, p, close_args):
		if p.poll() == None: # True if not yet terminated
			self.tree.get_widget('progressbar1').pulse()
			return True
		else:
			self.logtext += '\n'+p.stderr.read()+'\n\n'+_('Finished')
			if p.returncode == 0:
				closep = subprocess.Popen(close_args, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
				self.tree.get_widget('progressbar1').set_fraction(1)
			else:
				self.tree.get_widget('progressbar1').set_fraction(0)
				self.tree.get_widget('progressbar1').set_text('Failed: %d'%p.returncode)
			self.ass.set_page_complete( self.tree.get_widget('progressbox'), True)
			return False

	def encrypt(self, widget=None, page=None):
		dtype = self.get_type()
		eb = self.tree.get_widget('encbox')
		hb = self.tree.get_widget('hashbox')
		if dtype == TYPE_LUKS:
			cipher = eb.get_model().get_value(eb.get_active_iter(), 0)
			keysize = hb.get_model().get_value(hb.get_active_iter(), 0)
			if self.tree.get_widget('luks_usekeyfilebutton').get_active():
				encp = subprocess.Popen(("cryptsetup","--cipher",cipher,"--key-size", keysize, "luksFormat", self.c_path, self.tree.get_widget('luks_keyfile').get_filename()), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
			else:
				encp = subprocess.Popen(("cryptsetup","--cipher",cipher,"--key-size", keysize, "luksFormat", self.c_path), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
			gobject.timeout_add(200, self.pulse_luks_enc_progress_bar, encp)
			if not self.tree.get_widget('luks_usekeyfilebutton').get_active():
				encp.stdin.write(self.tree.get_widget('luks_pass1').get_text()+'\n')
		if dtype == TYPE_TRUECRYPT:
			kf = ''
			size_t = ()
			if self.tree.get_widget('tc_usekeyfilebutton').get_active():
				kf = self.tree.get_widget('tc_keyfile').get_filename()
			if self.is_file(self.c_path):
				size_t = ('--size', '%dk'%int(self.tree.get_widget('sizebutton').get_value()*1000))
			encp = subprocess.Popen(('truecrypt', '--keyfile', kf, '--encryption', 'AES', '--hash', 'RIPEMD-160', '--quick', '--type', 'Normal', '--filesystem', 'none', '--random-source', '/dev/urandom', '--disable-progress', '--display-password', '--overwrite')+size_t + ('--create', self.c_path), stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
			gobject.timeout_add(200, self.pulse_tc_enc_progress_bar, encp)
			encp.stdin.write(self.tree.get_widget('tc_pass1').get_text()+'\n')

if __name__ == '__main__':
	cg = CreateUI(quit=gtk.main_quit)
	gtk.main()
