/*!

\page gdcmraw Extract Data Element Value Field.

\section synopsis SYNOPSIS

\verbatim
gdcmraw [options] file-in file-out
\endverbatim

\section description DESCRIPTION

The \b gdcmraw tool is mostly used for development purpose. It is used to extract a specific binary field from a DICOM DataSet.

\section parameters PARAMETERS

\verbatim
file-in   DICOM input filename

file-out  output filename
\endverbatim

\section options OPTIONS

\subsection parameters parameters
\verbatim
  -i --input     Input filename
  -o --output    Output filename
  -t --tag       Specify tag to extract value from.
\endverbatim

\subsection options options
\verbatim
  -S --split-frags  Split fragments into multiple files.
  -p --pattern      Specify trailing file pattern (see split-frags).
  -P --pixel-data   Pixel Data trailing 0.
\endverbatim

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

  -v   --version
         print version information and exit

  -V   --verbose
         verbose mode (warning+error).

  -W   --warning
         warning mode, print warning information

  -E   --error
         error mode, print error information

  -D   --debug
         debug mode, print debug information
\endverbatim

\section usage Typical usage

\subsection copy_attribute Copy Attribute Value to file

This will extract the value at Tag (0025,101b):

\verbatim
$ gdcmraw -i GE_MR_0025xx1bProtocolDataBlock.dcm -t 25,101b -o pdb.raw
\endverbatim

\subsection extract_pixeldata Extract Pixel Data

If you do not specify any tag, the Pixel Data element is the default one. So for instance to grab the Pixel Data from an image:

\verbatim
$ gdcmraw -i test.acr -o test.raw
\endverbatim

You can then for example compute the md5sum of this pixel data (very useful):

\verbatim
$ md5sum test.raw
f845c8f283d39a0204c325654493ba53  test.raw
\endverbatim

\subsection encapsulated_syntax Encapsulated Syntax

When the Pixel Data is encapsulated, multiple fragments can be used to store a single slice image:

\verbatim
$ gdcmdump D_CLUNIE_CT1_J2KR.dcm
\endverbatim

\verbatim
\&...
(7fe0,0010) OB                                                    # u/l,1 Pixel Data
  (fffe,e000) ?? []                           # 0,1 Item
  (fffe,e000) ?? ff\\4f\\ff\\51\\00\\29\\00\\00\\00\\00\\02\\00\\00\\00\\02\\00\\00\\00\\00\\00\\00\\00\\00\\00\\00\\00\\02\\00\\00\\00\\02\\00         # 65536,1 Item
  (fffe,e000) ?? 2c\\b7\\ee\\68\\de\\e3\\93\\2d\\b3\\b8\\ba\\90\\7b\\42\\3e\\f8\\42\\16\\64\\88\\46\\30\\37\\d4\\50\\95\\9b\\b6\\a5\\c7\\38\\9b         # 65536,1 Item
  (fffe,e000) ?? 48\\3c\\03\\e8\\c4\\3f\\44\\e1\\8a\\5c\\73\\3b\\02\\0a\\ad\\a5\\8f\\e4\\0c\\81\\76\\a2\\d7\\1b\\7f\\b7\\cd\\bc\\30\\c6\\6a\\6a         # 43308,1 Item
(fffe,e0dd) 0
\endverbatim

In order to create a J2K image out of it, we need to extract each fragments and concatenate them:

\verbatim
$ gdcmraw -i D_CLUNIE_CT1_J2KR.dcm -o D_CLUNIE_CT1_J2KR.j2k
\endverbatim

This is a valid J2K file, using the Kakadu software package:

\verbatim
$ kdu_expand -i D_CLUNIE_CT1_J2KR.j2k -o D_CLUNIE_CT1_J2KR.tiff -record D_CLUNIE_CT1_J2KR.txt
\endverbatim

\verbatim
$ cat D_CLUNIE_CT1_J2KR.txt
\endverbatim

\verbatim
Sprofile=PROFILE2
Scap=no
Sextensions=0
Ssize={512,512}
Sorigin={0,0}
Stiles={512,512}
Stile_origin={0,0}
Scomponents=1
Ssigned=yes
Sprecision=16
Ssampling={1,1}
Sdims={512,512}
Cycc=no
Cmct=0
Clayers=1
Cuse_sop=no
Cuse_eph=no
Corder=LRCP
Calign_blk_last={no,no}
Clevels=5
Cads=0
Cdfs=0
Cdecomp=B(-:-:-)
Creversible=yes
Ckernels=W5X3
Catk=0
Cuse_precincts=no
Cblk={64,64}
Cmodes=0
Qguard=1
Qabs_ranges=18,19,19,20,19,19,20,19,19,20,19,19,20,19,19,20

>> New attributes for tile 0:
\endverbatim

\subsection extract_fragments Extract fragments as single file

Sometimes each fragments is in fact a single slice, so we would not need to concatenate them:


\verbatim
$ gdcmdump 00191113.dcm
\endverbatim

\verbatim
\&...
(7fe0,0010) OB                                                    # u/l,1 Pixel Data
  (fffe,e000) ?? 00\\00\\00\\00\\6b\\38\\01\\00\\10\\77\\02\\00\\37\\b6\\03\\00\\a7\\f4\\04\\00         # 20,1 Item
  (fffe,e000) ?? ff\\d8\\ff\\c3\\00\\0b\\08\\02\\00\\02\\00\\01\\00\\11\\00\\ff\\c4\\00\\1b\\00\\01\\01\\01\\01\\01\\01\\01\\01\\00\\00\\00\\00         # 79970,1 Item
  (fffe,e000) ?? ff\\d8\\ff\\c3\\00\\0b\\08\\02\\00\\02\\00\\01\\00\\11\\00\\ff\\c4\\00\\1b\\00\\01\\01\\01\\01\\01\\01\\01\\01\\00\\00\\00\\00         # 81564,1 Item
  (fffe,e000) ?? ff\\d8\\ff\\c3\\00\\0b\\08\\02\\00\\02\\00\\01\\00\\11\\00\\ff\\c4\\00\\1b\\00\\01\\01\\01\\01\\01\\01\\01\\01\\00\\00\\00\\00         # 81694,1 Item
  (fffe,e000) ?? ff\\d8\\ff\\c3\\00\\0b\\08\\02\\00\\02\\00\\01\\00\\11\\00\\ff\\c4\\00\\1b\\00\\01\\01\\01\\01\\01\\01\\01\\01\\00\\00\\00\\00         # 81511 (81512),1 Item
(fffe,e0dd) 0
\endverbatim

Let's try to extract those 4 individual Lossless jpeg individually:

\verbatim
$ gdcmraw --split-frags -i 00191113.dcm -o jpeg --pattern %02d.ljpeg
\endverbatim

This will output 4 files:

\verbatim
-rw-r--r--  1 mathieu mathieu   81512 2008-08-08 22:10 jpeg03.ljpeg
-rw-r--r--  1 mathieu mathieu   81694 2008-08-08 22:10 jpeg02.ljpeg
-rw-r--r--  1 mathieu mathieu   81564 2008-08-08 22:10 jpeg01.ljpeg
-rw-r--r--  1 mathieu mathieu   79970 2008-08-08 22:10 jpeg00.ljpeg
\endverbatim

\section footnote  Footnote about JPEG files

It is a common misunderstanding to interchange 'JPEG 8bits lossy' with simply JPEG file. The JPEG specification is much broader than simply the common lossy 8bits file (as found on internet).

You can have

\li JPEG Lossy 8bits
\li JPEG Lossy 12bits
\li JPEG Lossless 2-16bits

Those are what is defined in ITU-T T.81, ISO/IEC IS 10918-1.

\section see_also SEE ALSO

<b>gdcmdump</b>(1), <b>gdcmraw</b>(1)

\section copyright COPYRIGHT

Copyright (c) 2006-2010 Mathieu Malaterre

*/
