
// GENERATED FILE DO NOT EDIT
// $ xsltproc DefaultDicts.xsl DICOMV3.xml > gdcmDefaultDicts.cxx

/*=========================================================================

  Program: GDCM (Grassroots DICOM). A DICOM library
  Module:  $URL: https://gdcm.svn.sourceforge.net/svnroot/gdcm/trunk/Source/DataDictionary/DefaultDicts.xsl $

  Copyright (c) 2006-2010 Mathieu Malaterre
  All rights reserved.
  See Copyright.txt or http://gdcm.sourceforge.net/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef __gdcmDefaultDicts_cxx
#define __gdcmDefaultDicts_cxx

#include "gdcmDicts.h"
#include "gdcmVR.h"
#include "gdcmDict.h"
#include "gdcmDictEntry.h"

namespace gdcm {
typedef struct
{
  uint16_t group;
  uint16_t element;
  VR::VRType vr;
  VM::VMType vm;
  const char *name;
  bool ret;
} DICT_ENTRY;

static const DICT_ENTRY DICOMV3DataDict [] = {
  {0x0000,0x0000,VR::UL,VM::VM1,"Command Group Length",false },
  {0x0000,0x0001,VR::UL,VM::VM1,"Length to End",true },
  {0x0000,0x0002,VR::UI,VM::VM1,"Affected SOP Class UID",false },
  {0x0000,0x0003,VR::UI,VM::VM1,"Requested SOP Class UID",false },
  {0x0000,0x0010,VR::CS,VM::VM1,"Recognition Code",true },
  {0x0000,0x0100,VR::US,VM::VM1,"Command Field",false },
  {0x0000,0x0110,VR::US,VM::VM1,"Message ID",false },
  {0x0000,0x0120,VR::US,VM::VM1,"Message ID Being Responded To",false },
  {0x0000,0x0200,VR::AE,VM::VM1,"Initiator",true },
  {0x0000,0x0300,VR::AE,VM::VM1,"Receiver",true },
  {0x0000,0x0400,VR::AE,VM::VM1,"Find Location",true },
  {0x0000,0x0600,VR::AE,VM::VM1,"Move Destination",false },
  {0x0000,0x0700,VR::US,VM::VM1,"Priority",false },
  {0x0000,0x0800,VR::US,VM::VM1,"Data Set Type",false },
  {0x0000,0x0850,VR::US,VM::VM1,"Number of Matches",true },
  {0x0000,0x0860,VR::US,VM::VM1,"Response Sequence Number",true },
  {0x0000,0x0900,VR::US,VM::VM1,"Status",false },
  {0x0000,0x0901,VR::AT,VM::VM1_n,"Offending Element",false },
  {0x0000,0x0902,VR::LO,VM::VM1,"Error Comment",false },
  {0x0000,0x0903,VR::US,VM::VM1,"Error ID",false },
  {0x0000,0x1000,VR::UI,VM::VM1,"Affected SOP Instance UID",false },
  {0x0000,0x1001,VR::UI,VM::VM1,"Requested SOP Instance UID",false },
  {0x0000,0x1002,VR::US,VM::VM1,"Event Type ID",false },
  {0x0000,0x1005,VR::AT,VM::VM1_n,"Attribute Identifier List",false },
  {0x0000,0x1008,VR::US,VM::VM1,"Action Type ID",false },
  {0x0000,0x1020,VR::US,VM::VM1,"Number of Remaining Sub-operations",false },
  {0x0000,0x1021,VR::US,VM::VM1,"Number of Completed Sub-operations",false },
  {0x0000,0x1022,VR::US,VM::VM1,"Number of Failed Sub-operations",false },
  {0x0000,0x1023,VR::US,VM::VM1,"Number of Warning Sub-operations",false },
  {0x0000,0x1030,VR::AE,VM::VM1,"Move Originator Application Entity Title",false },
  {0x0000,0x1031,VR::US,VM::VM1,"Move Originator Message ID",false },
  {0x0000,0x4000,VR::AT,VM::VM1,"DIALOG Receiver",true },
  {0x0000,0x4010,VR::AT,VM::VM1,"Terminal Type",true },
  {0x0000,0x5010,VR::SH,VM::VM1,"Message Set ID",true },
  {0x0000,0x5020,VR::SH,VM::VM1,"End Message ID",true },
  {0x0000,0x5110,VR::AT,VM::VM1,"Display Format",true },
  {0x0000,0x5120,VR::AT,VM::VM1,"Page Position ID",true },
  {0x0000,0x5130,VR::CS,VM::VM1,"Text Format ID",true },
  {0x0000,0x5140,VR::CS,VM::VM1,"Normal/Reverse",true },
  {0x0000,0x5150,VR::CS,VM::VM1,"Add Gray Scale",true },
  {0x0000,0x5160,VR::CS,VM::VM1,"Borders",true },
  {0x0000,0x5170,VR::IS,VM::VM1,"Copies",true },
  {0x0000,0x5180,VR::CS,VM::VM1,"Magnification Type",true },
  {0x0000,0x5190,VR::CS,VM::VM1,"Erase",true },
  {0x0000,0x51a0,VR::CS,VM::VM1,"Print",true },
  {0x0000,0x51b0,VR::US,VM::VM1_n,"Overlays",true },
  {0x0002,0x0000,VR::UL,VM::VM1,"File Meta Information Group Length",false },
  {0x0002,0x0001,VR::OB,VM::VM1,"File Meta Information Version",false },
  {0x0002,0x0002,VR::UI,VM::VM1,"Media Storage SOP Class UID",false },
  {0x0002,0x0003,VR::UI,VM::VM1,"Media Storage SOP Instance UID",false },
  {0x0002,0x0010,VR::UI,VM::VM1,"Transfer Syntax UID",false },
  {0x0002,0x0012,VR::UI,VM::VM1,"Implementation Class UID",false },
  {0x0002,0x0013,VR::SH,VM::VM1,"Implementation Version Name",false },
  {0x0002,0x0016,VR::AE,VM::VM1,"Source Application Entity Title",false },
  {0x0002,0x0100,VR::UI,VM::VM1,"Private Information Creator UID",false },
  {0x0002,0x0102,VR::OB,VM::VM1,"Private Information",false },
  {0x0004,0x1130,VR::CS,VM::VM1,"File-set ID",false },
  {0x0004,0x1141,VR::CS,VM::VM1_8,"File-set Descriptor File ID",false },
  {0x0004,0x1142,VR::CS,VM::VM1,"Specific Character Set of File-set Descriptor File",false },
  {0x0004,0x1200,VR::UL,VM::VM1,"Offset of the First Directory Record of the Root Directory Entity",false },
  {0x0004,0x1202,VR::UL,VM::VM1,"Offset of the Last Directory Record of the Root Directory Entity",false },
  {0x0004,0x1212,VR::US,VM::VM1,"File-set Consistency Flag",false },
  {0x0004,0x1220,VR::SQ,VM::VM1,"Directory Record Sequence",false },
  {0x0004,0x1400,VR::UL,VM::VM1,"Offset of the Next Directory Record",false },
  {0x0004,0x1410,VR::US,VM::VM1,"Record In-use Flag",false },
  {0x0004,0x1420,VR::UL,VM::VM1,"Offset of Referenced Lower-Level Directory Entity",false },
  {0x0004,0x1430,VR::CS,VM::VM1,"Directory Record Type",false },
  {0x0004,0x1432,VR::UI,VM::VM1,"Private Record UID",false },
  {0x0004,0x1500,VR::CS,VM::VM1_8,"Referenced File ID",false },
  {0x0004,0x1504,VR::UL,VM::VM1,"MRDR Directory Record Offset",true },
  {0x0004,0x1510,VR::UI,VM::VM1,"Referenced SOP Class UID in File",false },
  {0x0004,0x1511,VR::UI,VM::VM1,"Referenced SOP Instance UID in File",false },
  {0x0004,0x1512,VR::UI,VM::VM1,"Referenced Transfer Syntax UID in File",false },
  {0x0004,0x151a,VR::UI,VM::VM1_n,"Referenced Related General SOP Class UID in File",false },
  {0x0004,0x1600,VR::UL,VM::VM1,"Number of References",true },
  {0x0008,0x0001,VR::UL,VM::VM1,"Length to End",true },
  {0x0008,0x0005,VR::CS,VM::VM1_n,"Specific Character Set",false },
  {0x0008,0x0006,VR::SQ,VM::VM1,"Language Code Sequence",false },
  {0x0008,0x0008,VR::CS,VM::VM2_n,"Image Type",false },
  {0x0008,0x0010,VR::CS,VM::VM1,"Recognition Code",true },
  {0x0008,0x0012,VR::DA,VM::VM1,"Instance Creation Date",false },
  {0x0008,0x0013,VR::TM,VM::VM1,"Instance Creation Time",false },
  {0x0008,0x0014,VR::UI,VM::VM1,"Instance Creator UID",false },
  {0x0008,0x0016,VR::UI,VM::VM1,"SOP Class UID",false },
  {0x0008,0x0018,VR::UI,VM::VM1,"SOP Instance UID",false },
  {0x0008,0x001a,VR::UI,VM::VM1_n,"Related General SOP Class UID",false },
  {0x0008,0x001b,VR::UI,VM::VM1,"Original Specialized SOP Class UID",false },
  {0x0008,0x0020,VR::DA,VM::VM1,"Study Date",false },
  {0x0008,0x0021,VR::DA,VM::VM1,"Series Date",false },
  {0x0008,0x0022,VR::DA,VM::VM1,"Acquisition Date",false },
  {0x0008,0x0023,VR::DA,VM::VM1,"Content Date",false },
  {0x0008,0x0024,VR::DA,VM::VM1,"Overlay Date",true },
  {0x0008,0x0025,VR::DA,VM::VM1,"Curve Date",true },
  {0x0008,0x002a,VR::DT,VM::VM1,"Acquisition DateTime",false },
  {0x0008,0x0030,VR::TM,VM::VM1,"Study Time",false },
  {0x0008,0x0031,VR::TM,VM::VM1,"Series Time",false },
  {0x0008,0x0032,VR::TM,VM::VM1,"Acquisition Time",false },
  {0x0008,0x0033,VR::TM,VM::VM1,"Content Time",false },
  {0x0008,0x0034,VR::TM,VM::VM1,"Overlay Time",true },
  {0x0008,0x0035,VR::TM,VM::VM1,"Curve Time",true },
  {0x0008,0x0040,VR::US,VM::VM1,"Data Set Type",true },
  {0x0008,0x0041,VR::LO,VM::VM1,"Data Set Subtype",true },
  {0x0008,0x0042,VR::CS,VM::VM1,"Nuclear Medicine Series Type",true },
  {0x0008,0x0050,VR::SH,VM::VM1,"Accession Number",false },
  {0x0008,0x0051,VR::SQ,VM::VM1,"Issuer of Accession Number Sequence",false },
  {0x0008,0x0052,VR::CS,VM::VM1,"Query/Retrieve Level",false },
  {0x0008,0x0054,VR::AE,VM::VM1_n,"Retrieve AE Title",false },
  {0x0008,0x0056,VR::CS,VM::VM1,"Instance Availability",false },
  {0x0008,0x0058,VR::UI,VM::VM1_n,"Failed SOP Instance UID List",false },
  {0x0008,0x0060,VR::CS,VM::VM1,"Modality",false },
  {0x0008,0x0061,VR::CS,VM::VM1_n,"Modalities in Study",false },
  {0x0008,0x0062,VR::UI,VM::VM1_n,"SOP Classes in Study",false },
  {0x0008,0x0064,VR::CS,VM::VM1,"Conversion Type",false },
  {0x0008,0x0068,VR::CS,VM::VM1,"Presentation Intent Type",false },
  {0x0008,0x0070,VR::LO,VM::VM1,"Manufacturer",false },
  {0x0008,0x0080,VR::LO,VM::VM1,"Institution Name",false },
  {0x0008,0x0081,VR::ST,VM::VM1,"Institution Address",false },
  {0x0008,0x0082,VR::SQ,VM::VM1,"Institution Code Sequence",false },
  {0x0008,0x0090,VR::PN,VM::VM1,"Referring Physician's Name",false },
  {0x0008,0x0092,VR::ST,VM::VM1,"Referring Physician's Address",false },
  {0x0008,0x0094,VR::SH,VM::VM1_n,"Referring Physician's Telephone Numbers",false },
  {0x0008,0x0096,VR::SQ,VM::VM1,"Referring Physician Identification Sequence",false },
  {0x0008,0x0100,VR::SH,VM::VM1,"Code Value",false },
  {0x0008,0x0102,VR::SH,VM::VM1,"Coding Scheme Designator",false },
  {0x0008,0x0103,VR::SH,VM::VM1,"Coding Scheme Version",false },
  {0x0008,0x0104,VR::LO,VM::VM1,"Code Meaning",false },
  {0x0008,0x0105,VR::CS,VM::VM1,"Mapping Resource",false },
  {0x0008,0x0106,VR::DT,VM::VM1,"Context Group Version",false },
  {0x0008,0x0107,VR::DT,VM::VM1,"Context Group Local Version",false },
  {0x0008,0x010b,VR::CS,VM::VM1,"Context Group Extension Flag",false },
  {0x0008,0x010c,VR::UI,VM::VM1,"Coding Scheme UID",false },
  {0x0008,0x010d,VR::UI,VM::VM1,"Context Group Extension Creator UID",false },
  {0x0008,0x010f,VR::CS,VM::VM1,"Context Identifier",false },
  {0x0008,0x0110,VR::SQ,VM::VM1,"Coding Scheme Identification Sequence",false },
  {0x0008,0x0112,VR::LO,VM::VM1,"Coding Scheme Registry",false },
  {0x0008,0x0114,VR::ST,VM::VM1,"Coding Scheme External ID",false },
  {0x0008,0x0115,VR::ST,VM::VM1,"Coding Scheme Name",false },
  {0x0008,0x0116,VR::ST,VM::VM1,"Coding Scheme Responsible Organization",false },
  {0x0008,0x0117,VR::UI,VM::VM1,"Context UID",false },
  {0x0008,0x0201,VR::SH,VM::VM1,"Timezone Offset From UTC",false },
  {0x0008,0x1000,VR::AE,VM::VM1,"Network ID",true },
  {0x0008,0x1010,VR::SH,VM::VM1,"Station Name",false },
  {0x0008,0x1030,VR::LO,VM::VM1,"Study Description",false },
  {0x0008,0x1032,VR::SQ,VM::VM1,"Procedure Code Sequence",false },
  {0x0008,0x103e,VR::LO,VM::VM1,"Series Description",false },
  {0x0008,0x103f,VR::SQ,VM::VM1,"Series Description Code Sequence",false },
  {0x0008,0x1040,VR::LO,VM::VM1,"Institutional Department Name",false },
  {0x0008,0x1048,VR::PN,VM::VM1_n,"Physician(s) of Record",false },
  {0x0008,0x1049,VR::SQ,VM::VM1,"Physician(s) of Record Identification Sequence",false },
  {0x0008,0x1050,VR::PN,VM::VM1_n,"Performing Physician's Name",false },
  {0x0008,0x1052,VR::SQ,VM::VM1,"Performing Physician Identification Sequence",false },
  {0x0008,0x1060,VR::PN,VM::VM1_n,"Name of Physician(s) Reading Study",false },
  {0x0008,0x1062,VR::SQ,VM::VM1,"Physician(s) Reading Study Identification Sequence",false },
  {0x0008,0x1070,VR::PN,VM::VM1_n,"Operators' Name",false },
  {0x0008,0x1072,VR::SQ,VM::VM1,"Operator Identification Sequence",false },
  {0x0008,0x1080,VR::LO,VM::VM1_n,"Admitting Diagnoses Description",false },
  {0x0008,0x1084,VR::SQ,VM::VM1,"Admitting Diagnoses Code Sequence",false },
  {0x0008,0x1090,VR::LO,VM::VM1,"Manufacturer's Model Name",false },
  {0x0008,0x1100,VR::SQ,VM::VM1,"Referenced Results Sequence",true },
  {0x0008,0x1110,VR::SQ,VM::VM1,"Referenced Study Sequence",false },
  {0x0008,0x1111,VR::SQ,VM::VM1,"Referenced Performed Procedure Step Sequence",false },
  {0x0008,0x1115,VR::SQ,VM::VM1,"Referenced Series Sequence",false },
  {0x0008,0x1120,VR::SQ,VM::VM1,"Referenced Patient Sequence",false },
  {0x0008,0x1125,VR::SQ,VM::VM1,"Referenced Visit Sequence",false },
  {0x0008,0x1130,VR::SQ,VM::VM1,"Referenced Overlay Sequence",true },
  {0x0008,0x1134,VR::SQ,VM::VM1,"Referenced Stereometric Instance Sequence",false },
  {0x0008,0x113a,VR::SQ,VM::VM1,"Referenced Waveform Sequence",false },
  {0x0008,0x1140,VR::SQ,VM::VM1,"Referenced Image Sequence",false },
  {0x0008,0x1145,VR::SQ,VM::VM1,"Referenced Curve Sequence",true },
  {0x0008,0x114a,VR::SQ,VM::VM1,"Referenced Instance Sequence",false },
  {0x0008,0x114b,VR::SQ,VM::VM1,"Referenced Real World Value Mapping Instance Sequence",false },
  {0x0008,0x1150,VR::UI,VM::VM1,"Referenced SOP Class UID",false },
  {0x0008,0x1155,VR::UI,VM::VM1,"Referenced SOP Instance UID",false },
  {0x0008,0x115a,VR::UI,VM::VM1_n,"SOP Classes Supported",false },
  {0x0008,0x1160,VR::IS,VM::VM1_n,"Referenced Frame Number",false },
  {0x0008,0x1161,VR::UL,VM::VM1_n,"Simple Frame List",false },
  {0x0008,0x1162,VR::UL,VM::VM3_3n,"Calculated Frame List",false },
  {0x0008,0x1163,VR::FD,VM::VM2,"Time Range",false },
  {0x0008,0x1164,VR::SQ,VM::VM1,"Frame Extraction Sequence",false },
  {0x0008,0x1167,VR::UI,VM::VM1,"Multi-Frame Source SOP Instance UID",false },
  {0x0008,0x1195,VR::UI,VM::VM1,"Transaction UID",false },
  {0x0008,0x1197,VR::US,VM::VM1,"Failure Reason",false },
  {0x0008,0x1198,VR::SQ,VM::VM1,"Failed SOP Sequence",false },
  {0x0008,0x1199,VR::SQ,VM::VM1,"Referenced SOP Sequence",false },
  {0x0008,0x1200,VR::SQ,VM::VM1,"Studies Containing Other Referenced Instances Sequence",false },
  {0x0008,0x1250,VR::SQ,VM::VM1,"Related Series Sequence",false },
  {0x0008,0x2110,VR::CS,VM::VM1,"Lossy Image Compression (Retired)",true },
  {0x0008,0x2111,VR::ST,VM::VM1,"Derivation Description",false },
  {0x0008,0x2112,VR::SQ,VM::VM1,"Source Image Sequence",false },
  {0x0008,0x2120,VR::SH,VM::VM1,"Stage Name",false },
  {0x0008,0x2122,VR::IS,VM::VM1,"Stage Number",false },
  {0x0008,0x2124,VR::IS,VM::VM1,"Number of Stages",false },
  {0x0008,0x2127,VR::SH,VM::VM1,"View Name",false },
  {0x0008,0x2128,VR::IS,VM::VM1,"View Number",false },
  {0x0008,0x2129,VR::IS,VM::VM1,"Number of Event Timers",false },
  {0x0008,0x212a,VR::IS,VM::VM1,"Number of Views in Stage",false },
  {0x0008,0x2130,VR::DS,VM::VM1_n,"Event Elapsed Time(s)",false },
  {0x0008,0x2132,VR::LO,VM::VM1_n,"Event Timer Name(s)",false },
  {0x0008,0x2133,VR::SQ,VM::VM1,"Event Timer Sequence",false },
  {0x0008,0x2134,VR::FD,VM::VM1,"Event Time Offset",false },
  {0x0008,0x2135,VR::SQ,VM::VM1,"Event Code Sequence",false },
  {0x0008,0x2142,VR::IS,VM::VM1,"Start Trim",false },
  {0x0008,0x2143,VR::IS,VM::VM1,"Stop Trim",false },
  {0x0008,0x2144,VR::IS,VM::VM1,"Recommended Display Frame Rate",false },
  {0x0008,0x2200,VR::CS,VM::VM1,"Transducer Position",true },
  {0x0008,0x2204,VR::CS,VM::VM1,"Transducer Orientation",true },
  {0x0008,0x2208,VR::CS,VM::VM1,"Anatomic Structure",true },
  {0x0008,0x2218,VR::SQ,VM::VM1,"Anatomic Region Sequence",false },
  {0x0008,0x2220,VR::SQ,VM::VM1,"Anatomic Region Modifier Sequence",false },
  {0x0008,0x2228,VR::SQ,VM::VM1,"Primary Anatomic Structure Sequence",false },
  {0x0008,0x2229,VR::SQ,VM::VM1,"Anatomic Structure, Space or Region Sequence",false },
  {0x0008,0x2230,VR::SQ,VM::VM1,"Primary Anatomic Structure Modifier Sequence",false },
  {0x0008,0x2240,VR::SQ,VM::VM1,"Transducer Position Sequence",true },
  {0x0008,0x2242,VR::SQ,VM::VM1,"Transducer Position Modifier Sequence",true },
  {0x0008,0x2244,VR::SQ,VM::VM1,"Transducer Orientation Sequence",true },
  {0x0008,0x2246,VR::SQ,VM::VM1,"Transducer Orientation Modifier Sequence",true },
  {0x0008,0x2251,VR::SQ,VM::VM1,"Anatomic Structure Space Or Region Code Sequence (Trial)",true },
  {0x0008,0x2253,VR::SQ,VM::VM1,"Anatomic Portal Of Entrance Code Sequence (Trial)",true },
  {0x0008,0x2255,VR::SQ,VM::VM1,"Anatomic Approach Direction Code Sequence (Trial)",true },
  {0x0008,0x2256,VR::ST,VM::VM1,"Anatomic Perspective Description (Trial)",true },
  {0x0008,0x2257,VR::SQ,VM::VM1,"Anatomic Perspective Code Sequence (Trial)",true },
  {0x0008,0x2258,VR::ST,VM::VM1,"Anatomic Location Of Examining Instrument Description (Trial)",true },
  {0x0008,0x2259,VR::SQ,VM::VM1,"Anatomic Location Of Examining Instrument Code Sequence (Trial)",true },
  {0x0008,0x225a,VR::SQ,VM::VM1,"Anatomic Structure Space Or Region Modifier Code Sequence (Trial)",true },
  {0x0008,0x225c,VR::SQ,VM::VM1,"OnAxis Background Anatomic Structure Code Sequence (Trial)",true },
  {0x0008,0x3001,VR::SQ,VM::VM1,"Alternate Representation Sequence",false },
  {0x0008,0x3010,VR::UI,VM::VM1,"Irradiation Event UID",false },
  {0x0008,0x4000,VR::LT,VM::VM1,"Identifying Comments",true },
  {0x0008,0x9007,VR::CS,VM::VM4,"Frame Type",false },
  {0x0008,0x9092,VR::SQ,VM::VM1,"Referenced Image Evidence Sequence",false },
  {0x0008,0x9121,VR::SQ,VM::VM1,"Referenced Raw Data Sequence",false },
  {0x0008,0x9123,VR::UI,VM::VM1,"Creator-Version UID",false },
  {0x0008,0x9124,VR::SQ,VM::VM1,"Derivation Image Sequence",false },
  {0x0008,0x9154,VR::SQ,VM::VM1,"Source Image Evidence Sequence",false },
  {0x0008,0x9205,VR::CS,VM::VM1,"Pixel Presentation",false },
  {0x0008,0x9206,VR::CS,VM::VM1,"Volumetric Properties",false },
  {0x0008,0x9207,VR::CS,VM::VM1,"Volume Based Calculation Technique",false },
  {0x0008,0x9208,VR::CS,VM::VM1,"Complex Image Component",false },
  {0x0008,0x9209,VR::CS,VM::VM1,"Acquisition Contrast",false },
  {0x0008,0x9215,VR::SQ,VM::VM1,"Derivation Code Sequence",false },
  {0x0008,0x9237,VR::SQ,VM::VM1,"Referenced Presentation State Sequence",false },
  {0x0008,0x9410,VR::SQ,VM::VM1,"Referenced Other Plane Sequence",false },
  {0x0008,0x9458,VR::SQ,VM::VM1,"Frame Display Sequence",false },
  {0x0008,0x9459,VR::FL,VM::VM1,"Recommended Display Frame Rate in Float",false },
  {0x0008,0x9460,VR::CS,VM::VM1,"Skip Frame Range Flag",false },
  {0x0010,0x0010,VR::PN,VM::VM1,"Patient's Name",false },
  {0x0010,0x0020,VR::LO,VM::VM1,"Patient ID",false },
  {0x0010,0x0021,VR::LO,VM::VM1,"Issuer of Patient ID",false },
  {0x0010,0x0022,VR::CS,VM::VM1,"Type of Patient ID",false },
  {0x0010,0x0024,VR::SQ,VM::VM1,"Issuer of Patient ID Qualifiers Sequence",false },
  {0x0010,0x0030,VR::DA,VM::VM1,"Patient's Birth Date",false },
  {0x0010,0x0032,VR::TM,VM::VM1,"Patient's Birth Time",false },
  {0x0010,0x0040,VR::CS,VM::VM1,"Patient's Sex",false },
  {0x0010,0x0050,VR::SQ,VM::VM1,"Patient's Insurance Plan Code Sequence",false },
  {0x0010,0x0101,VR::SQ,VM::VM1,"Patient's Primary Language Code Sequence",false },
  {0x0010,0x0102,VR::SQ,VM::VM1,"Patient's Primary Language Modifier Code Sequence",false },
  {0x0010,0x1000,VR::LO,VM::VM1_n,"Other Patient IDs",false },
  {0x0010,0x1001,VR::PN,VM::VM1_n,"Other Patient Names",false },
  {0x0010,0x1002,VR::SQ,VM::VM1,"Other Patient IDs Sequence",false },
  {0x0010,0x1005,VR::PN,VM::VM1,"Patient's Birth Name",false },
  {0x0010,0x1010,VR::AS,VM::VM1,"Patient's Age",false },
  {0x0010,0x1020,VR::DS,VM::VM1,"Patient's Size",false },
  {0x0010,0x1030,VR::DS,VM::VM1,"Patient's Weight",false },
  {0x0010,0x1040,VR::LO,VM::VM1,"Patient's Address",false },
  {0x0010,0x1050,VR::LO,VM::VM1_n,"Insurance Plan Identification",true },
  {0x0010,0x1060,VR::PN,VM::VM1,"Patient's Mother's Birth Name",false },
  {0x0010,0x1080,VR::LO,VM::VM1,"Military Rank",false },
  {0x0010,0x1081,VR::LO,VM::VM1,"Branch of Service",false },
  {0x0010,0x1090,VR::LO,VM::VM1,"Medical Record Locator",false },
  {0x0010,0x2000,VR::LO,VM::VM1_n,"Medical Alerts",false },
  {0x0010,0x2110,VR::LO,VM::VM1_n,"Allergies",false },
  {0x0010,0x2150,VR::LO,VM::VM1,"Country of Residence",false },
  {0x0010,0x2152,VR::LO,VM::VM1,"Region of Residence",false },
  {0x0010,0x2154,VR::SH,VM::VM1_n,"Patient's Telephone Numbers",false },
  {0x0010,0x2160,VR::SH,VM::VM1,"Ethnic Group",false },
  {0x0010,0x2180,VR::SH,VM::VM1,"Occupation",false },
  {0x0010,0x21a0,VR::CS,VM::VM1,"Smoking Status",false },
  {0x0010,0x21b0,VR::LT,VM::VM1,"Additional Patient History",false },
  {0x0010,0x21c0,VR::US,VM::VM1,"Pregnancy Status",false },
  {0x0010,0x21d0,VR::DA,VM::VM1,"Last Menstrual Date",false },
  {0x0010,0x21f0,VR::LO,VM::VM1,"Patient's Religious Preference",false },
  {0x0010,0x2201,VR::LO,VM::VM1,"Patient Species Description",false },
  {0x0010,0x2202,VR::SQ,VM::VM1,"Patient Species Code Sequence",false },
  {0x0010,0x2203,VR::CS,VM::VM1,"Patient's Sex Neutered",false },
  {0x0010,0x2210,VR::CS,VM::VM1,"Anatomical Orientation Type",false },
  {0x0010,0x2292,VR::LO,VM::VM1,"Patient Breed Description",false },
  {0x0010,0x2293,VR::SQ,VM::VM1,"Patient Breed Code Sequence",false },
  {0x0010,0x2294,VR::SQ,VM::VM1,"Breed Registration Sequence",false },
  {0x0010,0x2295,VR::LO,VM::VM1,"Breed Registration Number",false },
  {0x0010,0x2296,VR::SQ,VM::VM1,"Breed Registry Code Sequence",false },
  {0x0010,0x2297,VR::PN,VM::VM1,"Responsible Person",false },
  {0x0010,0x2298,VR::CS,VM::VM1,"Responsible Person Role",false },
  {0x0010,0x2299,VR::LO,VM::VM1,"Responsible Organization",false },
  {0x0010,0x4000,VR::LT,VM::VM1,"Patient Comments",false },
  {0x0010,0x9431,VR::FL,VM::VM1,"Examined Body Thickness",false },
  {0x0012,0x0010,VR::LO,VM::VM1,"Clinical Trial Sponsor Name",false },
  {0x0012,0x0020,VR::LO,VM::VM1,"Clinical Trial Protocol ID",false },
  {0x0012,0x0021,VR::LO,VM::VM1,"Clinical Trial Protocol Name",false },
  {0x0012,0x0030,VR::LO,VM::VM1,"Clinical Trial Site ID",false },
  {0x0012,0x0031,VR::LO,VM::VM1,"Clinical Trial Site Name",false },
  {0x0012,0x0040,VR::LO,VM::VM1,"Clinical Trial Subject ID",false },
  {0x0012,0x0042,VR::LO,VM::VM1,"Clinical Trial Subject Reading ID",false },
  {0x0012,0x0050,VR::LO,VM::VM1,"Clinical Trial Time Point ID",false },
  {0x0012,0x0051,VR::ST,VM::VM1,"Clinical Trial Time Point Description",false },
  {0x0012,0x0060,VR::LO,VM::VM1,"Clinical Trial Coordinating Center Name",false },
  {0x0012,0x0062,VR::CS,VM::VM1,"Patient Identity Removed",false },
  {0x0012,0x0063,VR::LO,VM::VM1_n,"De-identification Method",false },
  {0x0012,0x0064,VR::SQ,VM::VM1,"De-identification Method Code Sequence",false },
  {0x0012,0x0071,VR::LO,VM::VM1,"Clinical Trial Series ID",false },
  {0x0012,0x0072,VR::LO,VM::VM1,"Clinical Trial Series Description",false },
  {0x0012,0x0081,VR::LO,VM::VM1,"Clinical Trial Protocol Ethics Committee Name",false },
  {0x0012,0x0082,VR::LO,VM::VM1,"Clinical Trial Protocol Ethics Committee Approval Number",false },
  {0x0012,0x0083,VR::SQ,VM::VM1,"Consent for Clinical Trial Use Sequence",false },
  {0x0012,0x0084,VR::CS,VM::VM1,"Distribution Type",false },
  {0x0012,0x0085,VR::CS,VM::VM1,"Consent for Distribution Flag",false },
  {0x0018,0x0010,VR::LO,VM::VM1,"Contrast/Bolus Agent",false },
  {0x0018,0x0012,VR::SQ,VM::VM1,"Contrast/Bolus Agent Sequence",false },
  {0x0018,0x0014,VR::SQ,VM::VM1,"Contrast/Bolus Administration Route Sequence",false },
  {0x0018,0x0015,VR::CS,VM::VM1,"Body Part Examined",false },
  {0x0018,0x0020,VR::CS,VM::VM1_n,"Scanning Sequence",false },
  {0x0018,0x0021,VR::CS,VM::VM1_n,"Sequence Variant",false },
  {0x0018,0x0022,VR::CS,VM::VM1_n,"Scan Options",false },
  {0x0018,0x0023,VR::CS,VM::VM1,"MR Acquisition Type",false },
  {0x0018,0x0024,VR::SH,VM::VM1,"Sequence Name",false },
  {0x0018,0x0025,VR::CS,VM::VM1,"Angio Flag",false },
  {0x0018,0x0026,VR::SQ,VM::VM1,"Intervention Drug Information Sequence",false },
  {0x0018,0x0027,VR::TM,VM::VM1,"Intervention Drug Stop Time",false },
  {0x0018,0x0028,VR::DS,VM::VM1,"Intervention Drug Dose",false },
  {0x0018,0x0029,VR::SQ,VM::VM1,"Intervention Drug Code Sequence",false },
  {0x0018,0x002a,VR::SQ,VM::VM1,"Additional Drug Sequence",false },
  {0x0018,0x0030,VR::LO,VM::VM1_n,"Radionuclide",true },
  {0x0018,0x0031,VR::LO,VM::VM1,"Radiopharmaceutical",false },
  {0x0018,0x0032,VR::DS,VM::VM1,"Energy Window Centerline",true },
  {0x0018,0x0033,VR::DS,VM::VM1_n,"Energy Window Total Width",true },
  {0x0018,0x0034,VR::LO,VM::VM1,"Intervention Drug Name",false },
  {0x0018,0x0035,VR::TM,VM::VM1,"Intervention Drug Start Time",false },
  {0x0018,0x0036,VR::SQ,VM::VM1,"Intervention Sequence",false },
  {0x0018,0x0037,VR::CS,VM::VM1,"Therapy Type",true },
  {0x0018,0x0038,VR::CS,VM::VM1,"Intervention Status",false },
  {0x0018,0x0039,VR::CS,VM::VM1,"Therapy Description",true },
  {0x0018,0x003a,VR::ST,VM::VM1,"Intervention Description",false },
  {0x0018,0x0040,VR::IS,VM::VM1,"Cine Rate",false },
  {0x0018,0x0042,VR::CS,VM::VM1,"Initial Cine Run State",false },
  {0x0018,0x0050,VR::DS,VM::VM1,"Slice Thickness",false },
  {0x0018,0x0060,VR::DS,VM::VM1,"KVP",false },
  {0x0018,0x0070,VR::IS,VM::VM1,"Counts Accumulated",false },
  {0x0018,0x0071,VR::CS,VM::VM1,"Acquisition Termination Condition",false },
  {0x0018,0x0072,VR::DS,VM::VM1,"Effective Duration",false },
  {0x0018,0x0073,VR::CS,VM::VM1,"Acquisition Start Condition",false },
  {0x0018,0x0074,VR::IS,VM::VM1,"Acquisition Start Condition Data",false },
  {0x0018,0x0075,VR::IS,VM::VM1,"Acquisition Termination Condition Data",false },
  {0x0018,0x0080,VR::DS,VM::VM1,"Repetition Time",false },
  {0x0018,0x0081,VR::DS,VM::VM1,"Echo Time",false },
  {0x0018,0x0082,VR::DS,VM::VM1,"Inversion Time",false },
  {0x0018,0x0083,VR::DS,VM::VM1,"Number of Averages",false },
  {0x0018,0x0084,VR::DS,VM::VM1,"Imaging Frequency",false },
  {0x0018,0x0085,VR::SH,VM::VM1,"Imaged Nucleus",false },
  {0x0018,0x0086,VR::IS,VM::VM1_n,"Echo Number(s)",false },
  {0x0018,0x0087,VR::DS,VM::VM1,"Magnetic Field Strength",false },
  {0x0018,0x0088,VR::DS,VM::VM1,"Spacing Between Slices",false },
  {0x0018,0x0089,VR::IS,VM::VM1,"Number of Phase Encoding Steps",false },
  {0x0018,0x0090,VR::DS,VM::VM1,"Data Collection Diameter",false },
  {0x0018,0x0091,VR::IS,VM::VM1,"Echo Train Length",false },
  {0x0018,0x0093,VR::DS,VM::VM1,"Percent Sampling",false },
  {0x0018,0x0094,VR::DS,VM::VM1,"Percent Phase Field of View",false },
  {0x0018,0x0095,VR::DS,VM::VM1,"Pixel Bandwidth",false },
  {0x0018,0x1000,VR::LO,VM::VM1,"Device Serial Number",false },
  {0x0018,0x1002,VR::UI,VM::VM1,"Device UID",false },
  {0x0018,0x1003,VR::LO,VM::VM1,"Device ID",false },
  {0x0018,0x1004,VR::LO,VM::VM1,"Plate ID",false },
  {0x0018,0x1005,VR::LO,VM::VM1,"Generator ID",false },
  {0x0018,0x1006,VR::LO,VM::VM1,"Grid ID",false },
  {0x0018,0x1007,VR::LO,VM::VM1,"Cassette ID",false },
  {0x0018,0x1008,VR::LO,VM::VM1,"Gantry ID",false },
  {0x0018,0x1010,VR::LO,VM::VM1,"Secondary Capture Device ID",false },
  {0x0018,0x1011,VR::LO,VM::VM1,"Hardcopy Creation Device ID",true },
  {0x0018,0x1012,VR::DA,VM::VM1,"Date of Secondary Capture",false },
  {0x0018,0x1014,VR::TM,VM::VM1,"Time of Secondary Capture",false },
  {0x0018,0x1016,VR::LO,VM::VM1,"Secondary Capture Device Manufacturer",false },
  {0x0018,0x1017,VR::LO,VM::VM1,"Hardcopy Device Manufacturer",true },
  {0x0018,0x1018,VR::LO,VM::VM1,"Secondary Capture Device Manufacturer's Model Name",false },
  {0x0018,0x1019,VR::LO,VM::VM1_n,"Secondary Capture Device Software Versions",false },
  {0x0018,0x101a,VR::LO,VM::VM1_n,"Hardcopy Device Software Version",true },
  {0x0018,0x101b,VR::LO,VM::VM1,"Hardcopy Device Manufacturer's Model Name",true },
  {0x0018,0x1020,VR::LO,VM::VM1_n,"Software Version(s)",false },
  {0x0018,0x1022,VR::SH,VM::VM1,"Video Image Format Acquired",false },
  {0x0018,0x1023,VR::LO,VM::VM1,"Digital Image Format Acquired",false },
  {0x0018,0x1030,VR::LO,VM::VM1,"Protocol Name",false },
  {0x0018,0x1040,VR::LO,VM::VM1,"Contrast/Bolus Route",false },
  {0x0018,0x1041,VR::DS,VM::VM1,"Contrast/Bolus Volume",false },
  {0x0018,0x1042,VR::TM,VM::VM1,"Contrast/Bolus Start Time",false },
  {0x0018,0x1043,VR::TM,VM::VM1,"Contrast/Bolus Stop Time",false },
  {0x0018,0x1044,VR::DS,VM::VM1,"Contrast/Bolus Total Dose",false },
  {0x0018,0x1045,VR::IS,VM::VM1,"Syringe Counts",false },
  {0x0018,0x1046,VR::DS,VM::VM1_n,"Contrast Flow Rate",false },
  {0x0018,0x1047,VR::DS,VM::VM1_n,"Contrast Flow Duration",false },
  {0x0018,0x1048,VR::CS,VM::VM1,"Contrast/Bolus Ingredient",false },
  {0x0018,0x1049,VR::DS,VM::VM1,"Contrast/Bolus Ingredient Concentration",false },
  {0x0018,0x1050,VR::DS,VM::VM1,"Spatial Resolution",false },
  {0x0018,0x1060,VR::DS,VM::VM1,"Trigger Time",false },
  {0x0018,0x1061,VR::LO,VM::VM1,"Trigger Source or Type",false },
  {0x0018,0x1062,VR::IS,VM::VM1,"Nominal Interval",false },
  {0x0018,0x1063,VR::DS,VM::VM1,"Frame Time",false },
  {0x0018,0x1064,VR::LO,VM::VM1,"Cardiac Framing Type",false },
  {0x0018,0x1065,VR::DS,VM::VM1_n,"Frame Time Vector",false },
  {0x0018,0x1066,VR::DS,VM::VM1,"Frame Delay",false },
  {0x0018,0x1067,VR::DS,VM::VM1,"Image Trigger Delay",false },
  {0x0018,0x1068,VR::DS,VM::VM1,"Multiplex Group Time Offset",false },
  {0x0018,0x1069,VR::DS,VM::VM1,"Trigger Time Offset",false },
  {0x0018,0x106a,VR::CS,VM::VM1,"Synchronization Trigger",false },
  {0x0018,0x106c,VR::US,VM::VM2,"Synchronization Channel",false },
  {0x0018,0x106e,VR::UL,VM::VM1,"Trigger Sample Position",false },
  {0x0018,0x1070,VR::LO,VM::VM1,"Radiopharmaceutical Route",false },
  {0x0018,0x1071,VR::DS,VM::VM1,"Radiopharmaceutical Volume",false },
  {0x0018,0x1072,VR::TM,VM::VM1,"Radiopharmaceutical Start Time",false },
  {0x0018,0x1073,VR::TM,VM::VM1,"Radiopharmaceutical Stop Time",false },
  {0x0018,0x1074,VR::DS,VM::VM1,"Radionuclide Total Dose",false },
  {0x0018,0x1075,VR::DS,VM::VM1,"Radionuclide Half Life",false },
  {0x0018,0x1076,VR::DS,VM::VM1,"Radionuclide Positron Fraction",false },
  {0x0018,0x1077,VR::DS,VM::VM1,"Radiopharmaceutical Specific Activity",false },
  {0x0018,0x1078,VR::DT,VM::VM1,"Radiopharmaceutical Start DateTime",false },
  {0x0018,0x1079,VR::DT,VM::VM1,"Radiopharmaceutical Stop DateTime",false },
  {0x0018,0x1080,VR::CS,VM::VM1,"Beat Rejection Flag",false },
  {0x0018,0x1081,VR::IS,VM::VM1,"Low R-R Value",false },
  {0x0018,0x1082,VR::IS,VM::VM1,"High R-R Value",false },
  {0x0018,0x1083,VR::IS,VM::VM1,"Intervals Acquired",false },
  {0x0018,0x1084,VR::IS,VM::VM1,"Intervals Rejected",false },
  {0x0018,0x1085,VR::LO,VM::VM1,"PVC Rejection",false },
  {0x0018,0x1086,VR::IS,VM::VM1,"Skip Beats",false },
  {0x0018,0x1088,VR::IS,VM::VM1,"Heart Rate",false },
  {0x0018,0x1090,VR::IS,VM::VM1,"Cardiac Number of Images",false },
  {0x0018,0x1094,VR::IS,VM::VM1,"Trigger Window",false },
  {0x0018,0x1100,VR::DS,VM::VM1,"Reconstruction Diameter",false },
  {0x0018,0x1110,VR::DS,VM::VM1,"Distance Source to Detector",false },
  {0x0018,0x1111,VR::DS,VM::VM1,"Distance Source to Patient",false },
  {0x0018,0x1114,VR::DS,VM::VM1,"Estimated Radiographic Magnification Factor",false },
  {0x0018,0x1120,VR::DS,VM::VM1,"Gantry/Detector Tilt",false },
  {0x0018,0x1121,VR::DS,VM::VM1,"Gantry/Detector Slew",false },
  {0x0018,0x1130,VR::DS,VM::VM1,"Table Height",false },
  {0x0018,0x1131,VR::DS,VM::VM1,"Table Traverse",false },
  {0x0018,0x1134,VR::CS,VM::VM1,"Table Motion",false },
  {0x0018,0x1135,VR::DS,VM::VM1_n,"Table Vertical Increment",false },
  {0x0018,0x1136,VR::DS,VM::VM1_n,"Table Lateral Increment",false },
  {0x0018,0x1137,VR::DS,VM::VM1_n,"Table Longitudinal Increment",false },
  {0x0018,0x1138,VR::DS,VM::VM1,"Table Angle",false },
  {0x0018,0x113a,VR::CS,VM::VM1,"Table Type",false },
  {0x0018,0x1140,VR::CS,VM::VM1,"Rotation Direction",false },
  {0x0018,0x1141,VR::DS,VM::VM1,"Angular Position",true },
  {0x0018,0x1142,VR::DS,VM::VM1_n,"Radial Position",false },
  {0x0018,0x1143,VR::DS,VM::VM1,"Scan Arc",false },
  {0x0018,0x1144,VR::DS,VM::VM1,"Angular Step",false },
  {0x0018,0x1145,VR::DS,VM::VM1,"Center of Rotation Offset",false },
  {0x0018,0x1146,VR::DS,VM::VM1_n,"Rotation Offset",true },
  {0x0018,0x1147,VR::CS,VM::VM1,"Field of View Shape",false },
  {0x0018,0x1149,VR::IS,VM::VM1_2,"Field of View Dimension(s)",false },
  {0x0018,0x1150,VR::IS,VM::VM1,"Exposure Time",false },
  {0x0018,0x1151,VR::IS,VM::VM1,"X-Ray Tube Current",false },
  {0x0018,0x1152,VR::IS,VM::VM1,"Exposure",false },
  {0x0018,0x1153,VR::IS,VM::VM1,"Exposure in µAs",false },
  {0x0018,0x1154,VR::DS,VM::VM1,"Average Pulse Width",false },
  {0x0018,0x1155,VR::CS,VM::VM1,"Radiation Setting",false },
  {0x0018,0x1156,VR::CS,VM::VM1,"Rectification Type",false },
  {0x0018,0x115a,VR::CS,VM::VM1,"Radiation Mode",false },
  {0x0018,0x115e,VR::DS,VM::VM1,"Image and Fluoroscopy Area Dose Product",false },
  {0x0018,0x1160,VR::SH,VM::VM1,"Filter Type",false },
  {0x0018,0x1161,VR::LO,VM::VM1_n,"Type of Filters",false },
  {0x0018,0x1162,VR::DS,VM::VM1,"Intensifier Size",false },
  {0x0018,0x1164,VR::DS,VM::VM2,"Imager Pixel Spacing",false },
  {0x0018,0x1166,VR::CS,VM::VM1_n,"Grid",false },
  {0x0018,0x1170,VR::IS,VM::VM1,"Generator Power",false },
  {0x0018,0x1180,VR::SH,VM::VM1,"Collimator/grid Name",false },
  {0x0018,0x1181,VR::CS,VM::VM1,"Collimator Type",false },
  {0x0018,0x1182,VR::IS,VM::VM1_2,"Focal Distance",false },
  {0x0018,0x1183,VR::DS,VM::VM1_2,"X Focus Center",false },
  {0x0018,0x1184,VR::DS,VM::VM1_2,"Y Focus Center",false },
  {0x0018,0x1190,VR::DS,VM::VM1_n,"Focal Spot(s)",false },
  {0x0018,0x1191,VR::CS,VM::VM1,"Anode Target Material",false },
  {0x0018,0x11a0,VR::DS,VM::VM1,"Body Part Thickness",false },
  {0x0018,0x11a2,VR::DS,VM::VM1,"Compression Force",false },
  {0x0018,0x1200,VR::DA,VM::VM1_n,"Date of Last Calibration",false },
  {0x0018,0x1201,VR::TM,VM::VM1_n,"Time of Last Calibration",false },
  {0x0018,0x1210,VR::SH,VM::VM1_n,"Convolution Kernel",false },
  {0x0018,0x1240,VR::IS,VM::VM1_n,"Upper/Lower Pixel Values",true },
  {0x0018,0x1242,VR::IS,VM::VM1,"Actual Frame Duration",false },
  {0x0018,0x1243,VR::IS,VM::VM1,"Count Rate",false },
  {0x0018,0x1244,VR::US,VM::VM1,"Preferred Playback Sequencing",false },
  {0x0018,0x1250,VR::SH,VM::VM1,"Receive Coil Name",false },
  {0x0018,0x1251,VR::SH,VM::VM1,"Transmit Coil Name",false },
  {0x0018,0x1260,VR::SH,VM::VM1,"Plate Type",false },
  {0x0018,0x1261,VR::LO,VM::VM1,"Phosphor Type",false },
  {0x0018,0x1300,VR::DS,VM::VM1,"Scan Velocity",false },
  {0x0018,0x1301,VR::CS,VM::VM1_n,"Whole Body Technique",false },
  {0x0018,0x1302,VR::IS,VM::VM1,"Scan Length",false },
  {0x0018,0x1310,VR::US,VM::VM4,"Acquisition Matrix",false },
  {0x0018,0x1312,VR::CS,VM::VM1,"In-plane Phase Encoding Direction",false },
  {0x0018,0x1314,VR::DS,VM::VM1,"Flip Angle",false },
  {0x0018,0x1315,VR::CS,VM::VM1,"Variable Flip Angle Flag",false },
  {0x0018,0x1316,VR::DS,VM::VM1,"SAR",false },
  {0x0018,0x1318,VR::DS,VM::VM1,"dB/dt",false },
  {0x0018,0x1400,VR::LO,VM::VM1,"Acquisition Device Processing Description",false },
  {0x0018,0x1401,VR::LO,VM::VM1,"Acquisition Device Processing Code",false },
  {0x0018,0x1402,VR::CS,VM::VM1,"Cassette Orientation",false },
  {0x0018,0x1403,VR::CS,VM::VM1,"Cassette Size",false },
  {0x0018,0x1404,VR::US,VM::VM1,"Exposures on Plate",false },
  {0x0018,0x1405,VR::IS,VM::VM1,"Relative X-Ray Exposure",false },
  {0x0018,0x1450,VR::DS,VM::VM1,"Column Angulation",false },
  {0x0018,0x1460,VR::DS,VM::VM1,"Tomo Layer Height",false },
  {0x0018,0x1470,VR::DS,VM::VM1,"Tomo Angle",false },
  {0x0018,0x1480,VR::DS,VM::VM1,"Tomo Time",false },
  {0x0018,0x1490,VR::CS,VM::VM1,"Tomo Type",false },
  {0x0018,0x1491,VR::CS,VM::VM1,"Tomo Class",false },
  {0x0018,0x1495,VR::IS,VM::VM1,"Number of Tomosynthesis Source Images",false },
  {0x0018,0x1500,VR::CS,VM::VM1,"Positioner Motion",false },
  {0x0018,0x1508,VR::CS,VM::VM1,"Positioner Type",false },
  {0x0018,0x1510,VR::DS,VM::VM1,"Positioner Primary Angle",false },
  {0x0018,0x1511,VR::DS,VM::VM1,"Positioner Secondary Angle",false },
  {0x0018,0x1520,VR::DS,VM::VM1_n,"Positioner Primary Angle Increment",false },
  {0x0018,0x1521,VR::DS,VM::VM1_n,"Positioner Secondary Angle Increment",false },
  {0x0018,0x1530,VR::DS,VM::VM1,"Detector Primary Angle",false },
  {0x0018,0x1531,VR::DS,VM::VM1,"Detector Secondary Angle",false },
  {0x0018,0x1600,VR::CS,VM::VM1_3,"Shutter Shape",false },
  {0x0018,0x1602,VR::IS,VM::VM1,"Shutter Left Vertical Edge",false },
  {0x0018,0x1604,VR::IS,VM::VM1,"Shutter Right Vertical Edge",false },
  {0x0018,0x1606,VR::IS,VM::VM1,"Shutter Upper Horizontal Edge",false },
  {0x0018,0x1608,VR::IS,VM::VM1,"Shutter Lower Horizontal Edge",false },
  {0x0018,0x1610,VR::IS,VM::VM2,"Center of Circular Shutter",false },
  {0x0018,0x1612,VR::IS,VM::VM1,"Radius of Circular Shutter",false },
  {0x0018,0x1620,VR::IS,VM::VM2_2n,"Vertices of the Polygonal Shutter",false },
  {0x0018,0x1622,VR::US,VM::VM1,"Shutter Presentation Value",false },
  {0x0018,0x1623,VR::US,VM::VM1,"Shutter Overlay Group",false },
  {0x0018,0x1624,VR::US,VM::VM3,"Shutter Presentation Color CIELab Value",false },
  {0x0018,0x1700,VR::CS,VM::VM1_3,"Collimator Shape",false },
  {0x0018,0x1702,VR::IS,VM::VM1,"Collimator Left Vertical Edge",false },
  {0x0018,0x1704,VR::IS,VM::VM1,"Collimator Right Vertical Edge",false },
  {0x0018,0x1706,VR::IS,VM::VM1,"Collimator Upper Horizontal Edge",false },
  {0x0018,0x1708,VR::IS,VM::VM1,"Collimator Lower Horizontal Edge",false },
  {0x0018,0x1710,VR::IS,VM::VM2,"Center of Circular Collimator",false },
  {0x0018,0x1712,VR::IS,VM::VM1,"Radius of Circular Collimator",false },
  {0x0018,0x1720,VR::IS,VM::VM2_2n,"Vertices of the Polygonal Collimator",false },
  {0x0018,0x1800,VR::CS,VM::VM1,"Acquisition Time Synchronized",false },
  {0x0018,0x1801,VR::SH,VM::VM1,"Time Source",false },
  {0x0018,0x1802,VR::CS,VM::VM1,"Time Distribution Protocol",false },
  {0x0018,0x1803,VR::LO,VM::VM1,"NTP Source Address",false },
  {0x0018,0x2001,VR::IS,VM::VM1_n,"Page Number Vector",false },
  {0x0018,0x2002,VR::SH,VM::VM1_n,"Frame Label Vector",false },
  {0x0018,0x2003,VR::DS,VM::VM1_n,"Frame Primary Angle Vector",false },
  {0x0018,0x2004,VR::DS,VM::VM1_n,"Frame Secondary Angle Vector",false },
  {0x0018,0x2005,VR::DS,VM::VM1_n,"Slice Location Vector",false },
  {0x0018,0x2006,VR::SH,VM::VM1_n,"Display Window Label Vector",false },
  {0x0018,0x2010,VR::DS,VM::VM2,"Nominal Scanned Pixel Spacing",false },
  {0x0018,0x2020,VR::CS,VM::VM1,"Digitizing Device Transport Direction",false },
  {0x0018,0x2030,VR::DS,VM::VM1,"Rotation of Scanned Film",false },
  {0x0018,0x3100,VR::CS,VM::VM1,"IVUS Acquisition",false },
  {0x0018,0x3101,VR::DS,VM::VM1,"IVUS Pullback Rate",false },
  {0x0018,0x3102,VR::DS,VM::VM1,"IVUS Gated Rate",false },
  {0x0018,0x3103,VR::IS,VM::VM1,"IVUS Pullback Start Frame Number",false },
  {0x0018,0x3104,VR::IS,VM::VM1,"IVUS Pullback Stop Frame Number",false },
  {0x0018,0x3105,VR::IS,VM::VM1_n,"Lesion Number",false },
  {0x0018,0x4000,VR::LT,VM::VM1,"Acquisition Comments",true },
  {0x0018,0x5000,VR::SH,VM::VM1_n,"Output Power",false },
  {0x0018,0x5010,VR::LO,VM::VM1_n,"Transducer Data",false },
  {0x0018,0x5012,VR::DS,VM::VM1,"Focus Depth",false },
  {0x0018,0x5020,VR::LO,VM::VM1,"Processing Function",false },
  {0x0018,0x5021,VR::LO,VM::VM1,"Postprocessing Function",true },
  {0x0018,0x5022,VR::DS,VM::VM1,"Mechanical Index",false },
  {0x0018,0x5024,VR::DS,VM::VM1,"Bone Thermal Index",false },
  {0x0018,0x5026,VR::DS,VM::VM1,"Cranial Thermal Index",false },
  {0x0018,0x5027,VR::DS,VM::VM1,"Soft Tissue Thermal Index",false },
  {0x0018,0x5028,VR::DS,VM::VM1,"Soft Tissue-focus Thermal Index",false },
  {0x0018,0x5029,VR::DS,VM::VM1,"Soft Tissue-surface Thermal Index",false },
  {0x0018,0x5030,VR::DS,VM::VM1,"Dynamic Range",true },
  {0x0018,0x5040,VR::DS,VM::VM1,"Total Gain",true },
  {0x0018,0x5050,VR::IS,VM::VM1,"Depth of Scan Field",false },
  {0x0018,0x5100,VR::CS,VM::VM1,"Patient Position",false },
  {0x0018,0x5101,VR::CS,VM::VM1,"View Position",false },
  {0x0018,0x5104,VR::SQ,VM::VM1,"Projection Eponymous Name Code Sequence",false },
  {0x0018,0x5210,VR::DS,VM::VM6,"Image Transformation Matrix",true },
  {0x0018,0x5212,VR::DS,VM::VM3,"Image Translation Vector",true },
  {0x0018,0x6000,VR::DS,VM::VM1,"Sensitivity",false },
  {0x0018,0x6011,VR::SQ,VM::VM1,"Sequence of Ultrasound Regions",false },
  {0x0018,0x6012,VR::US,VM::VM1,"Region Spatial Format",false },
  {0x0018,0x6014,VR::US,VM::VM1,"Region Data Type",false },
  {0x0018,0x6016,VR::UL,VM::VM1,"Region Flags",false },
  {0x0018,0x6018,VR::UL,VM::VM1,"Region Location Min X0",false },
  {0x0018,0x601a,VR::UL,VM::VM1,"Region Location Min Y0",false },
  {0x0018,0x601c,VR::UL,VM::VM1,"Region Location Max X1",false },
  {0x0018,0x601e,VR::UL,VM::VM1,"Region Location Max Y1",false },
  {0x0018,0x6020,VR::SL,VM::VM1,"Reference Pixel X0",false },
  {0x0018,0x6022,VR::SL,VM::VM1,"Reference Pixel Y0",false },
  {0x0018,0x6024,VR::US,VM::VM1,"Physical Units X Direction",false },
  {0x0018,0x6026,VR::US,VM::VM1,"Physical Units Y Direction",false },
  {0x0018,0x6028,VR::FD,VM::VM1,"Reference Pixel Physical Value X",false },
  {0x0018,0x602a,VR::FD,VM::VM1,"Reference Pixel Physical Value Y",false },
  {0x0018,0x602c,VR::FD,VM::VM1,"Physical Delta X",false },
  {0x0018,0x602e,VR::FD,VM::VM1,"Physical Delta Y",false },
  {0x0018,0x6030,VR::UL,VM::VM1,"Transducer Frequency",false },
  {0x0018,0x6031,VR::CS,VM::VM1,"Transducer Type",false },
  {0x0018,0x6032,VR::UL,VM::VM1,"Pulse Repetition Frequency",false },
  {0x0018,0x6034,VR::FD,VM::VM1,"Doppler Correction Angle",false },
  {0x0018,0x6036,VR::FD,VM::VM1,"Steering Angle",false },
  {0x0018,0x6038,VR::UL,VM::VM1,"Doppler Sample Volume X Position (Retired)",true },
  {0x0018,0x6039,VR::SL,VM::VM1,"Doppler Sample Volume X Position",false },
  {0x0018,0x603a,VR::UL,VM::VM1,"Doppler Sample Volume Y Position (Retired)",true },
  {0x0018,0x603b,VR::SL,VM::VM1,"Doppler Sample Volume Y Position",false },
  {0x0018,0x603c,VR::UL,VM::VM1,"TMLine Position X0 (Retired)",true },
  {0x0018,0x603d,VR::SL,VM::VM1,"TM-Line Position X0",false },
  {0x0018,0x603e,VR::UL,VM::VM1,"TM-Line Position Y0 (Retired)",true },
  {0x0018,0x603f,VR::SL,VM::VM1,"TM-Line Position Y0",false },
  {0x0018,0x6040,VR::UL,VM::VM1,"TM-Line Position X1 (Retired)",true },
  {0x0018,0x6041,VR::SL,VM::VM1,"TM-Line Position X1",false },
  {0x0018,0x6042,VR::UL,VM::VM1,"TM-Line Position Y1 (Retired)",true },
  {0x0018,0x6043,VR::SL,VM::VM1,"TM-Line Position Y1",false },
  {0x0018,0x6044,VR::US,VM::VM1,"Pixel Component Organization",false },
  {0x0018,0x6046,VR::UL,VM::VM1,"Pixel Component Mask",false },
  {0x0018,0x6048,VR::UL,VM::VM1,"Pixel Component Range Start",false },
  {0x0018,0x604a,VR::UL,VM::VM1,"Pixel Component Range Stop",false },
  {0x0018,0x604c,VR::US,VM::VM1,"Pixel Component Physical Units",false },
  {0x0018,0x604e,VR::US,VM::VM1,"Pixel Component Data Type",false },
  {0x0018,0x6050,VR::UL,VM::VM1,"Number of Table Break Points",false },
  {0x0018,0x6052,VR::UL,VM::VM1_n,"Table of X Break Points",false },
  {0x0018,0x6054,VR::FD,VM::VM1_n,"Table of Y Break Points",false },
  {0x0018,0x6056,VR::UL,VM::VM1,"Number of Table Entries",false },
  {0x0018,0x6058,VR::UL,VM::VM1_n,"Table of Pixel Values",false },
  {0x0018,0x605a,VR::FL,VM::VM1_n,"Table of Parameter Values",false },
  {0x0018,0x6060,VR::FL,VM::VM1_n,"R Wave Time Vector",false },
  {0x0018,0x7000,VR::CS,VM::VM1,"Detector Conditions Nominal Flag",false },
  {0x0018,0x7001,VR::DS,VM::VM1,"Detector Temperature",false },
  {0x0018,0x7004,VR::CS,VM::VM1,"Detector Type",false },
  {0x0018,0x7005,VR::CS,VM::VM1,"Detector Configuration",false },
  {0x0018,0x7006,VR::LT,VM::VM1,"Detector Description",false },
  {0x0018,0x7008,VR::LT,VM::VM1,"Detector Mode",false },
  {0x0018,0x700a,VR::SH,VM::VM1,"Detector ID",false },
  {0x0018,0x700c,VR::DA,VM::VM1,"Date of Last Detector Calibration",false },
  {0x0018,0x700e,VR::TM,VM::VM1,"Time of Last Detector Calibration",false },
  {0x0018,0x7010,VR::IS,VM::VM1,"Exposures on Detector Since Last Calibration",false },
  {0x0018,0x7011,VR::IS,VM::VM1,"Exposures on Detector Since Manufactured",false },
  {0x0018,0x7012,VR::DS,VM::VM1,"Detector Time Since Last Exposure",false },
  {0x0018,0x7014,VR::DS,VM::VM1,"Detector Active Time",false },
  {0x0018,0x7016,VR::DS,VM::VM1,"Detector Activation Offset From Exposure",false },
  {0x0018,0x701a,VR::DS,VM::VM2,"Detector Binning",false },
  {0x0018,0x7020,VR::DS,VM::VM2,"Detector Element Physical Size",false },
  {0x0018,0x7022,VR::DS,VM::VM2,"Detector Element Spacing",false },
  {0x0018,0x7024,VR::CS,VM::VM1,"Detector Active Shape",false },
  {0x0018,0x7026,VR::DS,VM::VM1_2,"Detector Active Dimension(s)",false },
  {0x0018,0x7028,VR::DS,VM::VM2,"Detector Active Origin",false },
  {0x0018,0x702a,VR::LO,VM::VM1,"Detector Manufacturer Name",false },
  {0x0018,0x702b,VR::LO,VM::VM1,"Detector Manufacturer's Model Name",false },
  {0x0018,0x7030,VR::DS,VM::VM2,"Field of View Origin",false },
  {0x0018,0x7032,VR::DS,VM::VM1,"Field of View Rotation",false },
  {0x0018,0x7034,VR::CS,VM::VM1,"Field of View Horizontal Flip",false },
  {0x0018,0x7040,VR::LT,VM::VM1,"Grid Absorbing Material",false },
  {0x0018,0x7041,VR::LT,VM::VM1,"Grid Spacing Material",false },
  {0x0018,0x7042,VR::DS,VM::VM1,"Grid Thickness",false },
  {0x0018,0x7044,VR::DS,VM::VM1,"Grid Pitch",false },
  {0x0018,0x7046,VR::IS,VM::VM2,"Grid Aspect Ratio",false },
  {0x0018,0x7048,VR::DS,VM::VM1,"Grid Period",false },
  {0x0018,0x704c,VR::DS,VM::VM1,"Grid Focal Distance",false },
  {0x0018,0x7050,VR::CS,VM::VM1_n,"Filter Material",false },
  {0x0018,0x7052,VR::DS,VM::VM1_n,"Filter Thickness Minimum",false },
  {0x0018,0x7054,VR::DS,VM::VM1_n,"Filter Thickness Maximum",false },
  {0x0018,0x7056,VR::FL,VM::VM1_n,"Filter Beam Path Length Minimum",false },
  {0x0018,0x7058,VR::FL,VM::VM1_n,"Filter Beam Path Length Maximum",false },
  {0x0018,0x7060,VR::CS,VM::VM1,"Exposure Control Mode",false },
  {0x0018,0x7062,VR::LT,VM::VM1,"Exposure Control Mode Description",false },
  {0x0018,0x7064,VR::CS,VM::VM1,"Exposure Status",false },
  {0x0018,0x7065,VR::DS,VM::VM1,"Phototimer Setting",false },
  {0x0018,0x8150,VR::DS,VM::VM1,"Exposure Time in µS",false },
  {0x0018,0x8151,VR::DS,VM::VM1,"X-Ray Tube Current in µA",false },
  {0x0018,0x9004,VR::CS,VM::VM1,"Content Qualification",false },
  {0x0018,0x9005,VR::SH,VM::VM1,"Pulse Sequence Name",false },
  {0x0018,0x9006,VR::SQ,VM::VM1,"MR Imaging Modifier Sequence",false },
  {0x0018,0x9008,VR::CS,VM::VM1,"Echo Pulse Sequence",false },
  {0x0018,0x9009,VR::CS,VM::VM1,"Inversion Recovery",false },
  {0x0018,0x9010,VR::CS,VM::VM1,"Flow Compensation",false },
  {0x0018,0x9011,VR::CS,VM::VM1,"Multiple Spin Echo",false },
  {0x0018,0x9012,VR::CS,VM::VM1,"Multi-planar Excitation",false },
  {0x0018,0x9014,VR::CS,VM::VM1,"Phase Contrast",false },
  {0x0018,0x9015,VR::CS,VM::VM1,"Time of Flight Contrast",false },
  {0x0018,0x9016,VR::CS,VM::VM1,"Spoiling",false },
  {0x0018,0x9017,VR::CS,VM::VM1,"Steady State Pulse Sequence",false },
  {0x0018,0x9018,VR::CS,VM::VM1,"Echo Planar Pulse Sequence",false },
  {0x0018,0x9019,VR::FD,VM::VM1,"Tag Angle First Axis",false },
  {0x0018,0x9020,VR::CS,VM::VM1,"Magnetization Transfer",false },
  {0x0018,0x9021,VR::CS,VM::VM1,"T2 Preparation",false },
  {0x0018,0x9022,VR::CS,VM::VM1,"Blood Signal Nulling",false },
  {0x0018,0x9024,VR::CS,VM::VM1,"Saturation Recovery",false },
  {0x0018,0x9025,VR::CS,VM::VM1,"Spectrally Selected Suppression",false },
  {0x0018,0x9026,VR::CS,VM::VM1,"Spectrally Selected Excitation",false },
  {0x0018,0x9027,VR::CS,VM::VM1,"Spatial Pre-saturation",false },
  {0x0018,0x9028,VR::CS,VM::VM1,"Tagging",false },
  {0x0018,0x9029,VR::CS,VM::VM1,"Oversampling Phase",false },
  {0x0018,0x9030,VR::FD,VM::VM1,"Tag Spacing First Dimension",false },
  {0x0018,0x9032,VR::CS,VM::VM1,"Geometry of k-Space Traversal",false },
  {0x0018,0x9033,VR::CS,VM::VM1,"Segmented k-Space Traversal",false },
  {0x0018,0x9034,VR::CS,VM::VM1,"Rectilinear Phase Encode Reordering",false },
  {0x0018,0x9035,VR::FD,VM::VM1,"Tag Thickness",false },
  {0x0018,0x9036,VR::CS,VM::VM1,"Partial Fourier Direction",false },
  {0x0018,0x9037,VR::CS,VM::VM1,"Cardiac Synchronization Technique",false },
  {0x0018,0x9041,VR::LO,VM::VM1,"Receive Coil Manufacturer Name",false },
  {0x0018,0x9042,VR::SQ,VM::VM1,"MR Receive Coil Sequence",false },
  {0x0018,0x9043,VR::CS,VM::VM1,"Receive Coil Type",false },
  {0x0018,0x9044,VR::CS,VM::VM1,"Quadrature Receive Coil",false },
  {0x0018,0x9045,VR::SQ,VM::VM1,"Multi-Coil Definition Sequence",false },
  {0x0018,0x9046,VR::LO,VM::VM1,"Multi-Coil Configuration",false },
  {0x0018,0x9047,VR::SH,VM::VM1,"Multi-Coil Element Name",false },
  {0x0018,0x9048,VR::CS,VM::VM1,"Multi-Coil Element Used",false },
  {0x0018,0x9049,VR::SQ,VM::VM1,"MR Transmit Coil Sequence",false },
  {0x0018,0x9050,VR::LO,VM::VM1,"Transmit Coil Manufacturer Name",false },
  {0x0018,0x9051,VR::CS,VM::VM1,"Transmit Coil Type",false },
  {0x0018,0x9052,VR::FD,VM::VM1_2,"Spectral Width",false },
  {0x0018,0x9053,VR::FD,VM::VM1_2,"Chemical Shift Reference",false },
  {0x0018,0x9054,VR::CS,VM::VM1,"Volume Localization Technique",false },
  {0x0018,0x9058,VR::US,VM::VM1,"MR Acquisition Frequency Encoding Steps",false },
  {0x0018,0x9059,VR::CS,VM::VM1,"De-coupling",false },
  {0x0018,0x9060,VR::CS,VM::VM1_2,"De-coupled Nucleus",false },
  {0x0018,0x9061,VR::FD,VM::VM1_2,"De-coupling Frequency",false },
  {0x0018,0x9062,VR::CS,VM::VM1,"De-coupling Method",false },
  {0x0018,0x9063,VR::FD,VM::VM1_2,"De-coupling Chemical Shift Reference",false },
  {0x0018,0x9064,VR::CS,VM::VM1,"k-space Filtering",false },
  {0x0018,0x9065,VR::CS,VM::VM1_2,"Time Domain Filtering",false },
  {0x0018,0x9066,VR::US,VM::VM1_2,"Number of Zero fills",false },
  {0x0018,0x9067,VR::CS,VM::VM1,"Baseline Correction",false },
  {0x0018,0x9069,VR::FD,VM::VM1,"Parallel Reduction Factor In-plane",false },
  {0x0018,0x9070,VR::FD,VM::VM1,"Cardiac R-R Interval Specified",false },
  {0x0018,0x9073,VR::FD,VM::VM1,"Acquisition Duration",false },
  {0x0018,0x9074,VR::DT,VM::VM1,"Frame Acquisition DateTime",false },
  {0x0018,0x9075,VR::CS,VM::VM1,"Diffusion Directionality",false },
  {0x0018,0x9076,VR::SQ,VM::VM1,"Diffusion Gradient Direction Sequence",false },
  {0x0018,0x9077,VR::CS,VM::VM1,"Parallel Acquisition",false },
  {0x0018,0x9078,VR::CS,VM::VM1,"Parallel Acquisition Technique",false },
  {0x0018,0x9079,VR::FD,VM::VM1_n,"Inversion Times",false },
  {0x0018,0x9080,VR::ST,VM::VM1,"Metabolite Map Description",false },
  {0x0018,0x9081,VR::CS,VM::VM1,"Partial Fourier",false },
  {0x0018,0x9082,VR::FD,VM::VM1,"Effective Echo Time",false },
  {0x0018,0x9083,VR::SQ,VM::VM1,"Metabolite Map Code Sequence",false },
  {0x0018,0x9084,VR::SQ,VM::VM1,"Chemical Shift Sequence",false },
  {0x0018,0x9085,VR::CS,VM::VM1,"Cardiac Signal Source",false },
  {0x0018,0x9087,VR::FD,VM::VM1,"Diffusion b-value",false },
  {0x0018,0x9089,VR::FD,VM::VM3,"Diffusion Gradient Orientation",false },
  {0x0018,0x9090,VR::FD,VM::VM3,"Velocity Encoding Direction",false },
  {0x0018,0x9091,VR::FD,VM::VM1,"Velocity Encoding Minimum Value",false },
  {0x0018,0x9093,VR::US,VM::VM1,"Number of k-Space Trajectories",false },
  {0x0018,0x9094,VR::CS,VM::VM1,"Coverage of k-Space",false },
  {0x0018,0x9095,VR::UL,VM::VM1,"Spectroscopy Acquisition Phase Rows",false },
  {0x0018,0x9096,VR::FD,VM::VM1,"Parallel Reduction Factor In-plane (Retired)",true },
  {0x0018,0x9098,VR::FD,VM::VM1_2,"Transmitter Frequency",false },
  {0x0018,0x9100,VR::CS,VM::VM1_2,"Resonant Nucleus",false },
  {0x0018,0x9101,VR::CS,VM::VM1,"Frequency Correction",false },
  {0x0018,0x9103,VR::SQ,VM::VM1,"MR Spectroscopy FOV/Geometry Sequence",false },
  {0x0018,0x9104,VR::FD,VM::VM1,"Slab Thickness",false },
  {0x0018,0x9105,VR::FD,VM::VM3,"Slab Orientation",false },
  {0x0018,0x9106,VR::FD,VM::VM3,"Mid Slab Position",false },
  {0x0018,0x9107,VR::SQ,VM::VM1,"MR Spatial Saturation Sequence",false },
  {0x0018,0x9112,VR::SQ,VM::VM1,"MR Timing and Related Parameters Sequence",false },
  {0x0018,0x9114,VR::SQ,VM::VM1,"MR Echo Sequence",false },
  {0x0018,0x9115,VR::SQ,VM::VM1,"MR Modifier Sequence",false },
  {0x0018,0x9117,VR::SQ,VM::VM1,"MR Diffusion Sequence",false },
  {0x0018,0x9118,VR::SQ,VM::VM1,"Cardiac Synchronization Sequence",false },
  {0x0018,0x9119,VR::SQ,VM::VM1,"MR Averages Sequence",false },
  {0x0018,0x9125,VR::SQ,VM::VM1,"MR FOV/Geometry Sequence",false },
  {0x0018,0x9126,VR::SQ,VM::VM1,"Volume Localization Sequence",false },
  {0x0018,0x9127,VR::UL,VM::VM1,"Spectroscopy Acquisition Data Columns",false },
  {0x0018,0x9147,VR::CS,VM::VM1,"Diffusion Anisotropy Type",false },
  {0x0018,0x9151,VR::DT,VM::VM1,"Frame Reference DateTime",false },
  {0x0018,0x9152,VR::SQ,VM::VM1,"MR Metabolite Map Sequence",false },
  {0x0018,0x9155,VR::FD,VM::VM1,"Parallel Reduction Factor out-of-plane",false },
  {0x0018,0x9159,VR::UL,VM::VM1,"Spectroscopy Acquisition Out-of-plane Phase Steps",false },
  {0x0018,0x9166,VR::CS,VM::VM1,"Bulk Motion Status",true },
  {0x0018,0x9168,VR::FD,VM::VM1,"Parallel Reduction Factor Second In-plane",false },
  {0x0018,0x9169,VR::CS,VM::VM1,"Cardiac Beat Rejection Technique",false },
  {0x0018,0x9170,VR::CS,VM::VM1,"Respiratory Motion Compensation Technique",false },
  {0x0018,0x9171,VR::CS,VM::VM1,"Respiratory Signal Source",false },
  {0x0018,0x9172,VR::CS,VM::VM1,"Bulk Motion Compensation Technique",false },
  {0x0018,0x9173,VR::CS,VM::VM1,"Bulk Motion Signal Source",false },
  {0x0018,0x9174,VR::CS,VM::VM1,"Applicable Safety Standard Agency",false },
  {0x0018,0x9175,VR::LO,VM::VM1,"Applicable Safety Standard Description",false },
  {0x0018,0x9176,VR::SQ,VM::VM1,"Operating Mode Sequence",false },
  {0x0018,0x9177,VR::CS,VM::VM1,"Operating Mode Type",false },
  {0x0018,0x9178,VR::CS,VM::VM1,"Operating Mode",false },
  {0x0018,0x9179,VR::CS,VM::VM1,"Specific Absorption Rate Definition",false },
  {0x0018,0x9180,VR::CS,VM::VM1,"Gradient Output Type",false },
  {0x0018,0x9181,VR::FD,VM::VM1,"Specific Absorption Rate Value",false },
  {0x0018,0x9182,VR::FD,VM::VM1,"Gradient Output",false },
  {0x0018,0x9183,VR::CS,VM::VM1,"Flow Compensation Direction",false },
  {0x0018,0x9184,VR::FD,VM::VM1,"Tagging Delay",false },
  {0x0018,0x9185,VR::ST,VM::VM1,"Respiratory Motion Compensation Technique Description",false },
  {0x0018,0x9186,VR::SH,VM::VM1,"Respiratory Signal Source ID",false },
  {0x0018,0x9195,VR::FD,VM::VM1,"Chemical Shift Minimum Integration Limit in Hz",true },
  {0x0018,0x9196,VR::FD,VM::VM1,"Chemical Shift Maximum Integration Limit in Hz",true },
  {0x0018,0x9197,VR::SQ,VM::VM1,"MR Velocity Encoding Sequence",false },
  {0x0018,0x9198,VR::CS,VM::VM1,"First Order Phase Correction",false },
  {0x0018,0x9199,VR::CS,VM::VM1,"Water Referenced Phase Correction",false },
  {0x0018,0x9200,VR::CS,VM::VM1,"MR Spectroscopy Acquisition Type",false },
  {0x0018,0x9214,VR::CS,VM::VM1,"Respiratory Cycle Position",false },
  {0x0018,0x9217,VR::FD,VM::VM1,"Velocity Encoding Maximum Value",false },
  {0x0018,0x9218,VR::FD,VM::VM1,"Tag Spacing Second Dimension",false },
  {0x0018,0x9219,VR::SS,VM::VM1,"Tag Angle Second Axis",false },
  {0x0018,0x9220,VR::FD,VM::VM1,"Frame Acquisition Duration",false },
  {0x0018,0x9226,VR::SQ,VM::VM1,"MR Image Frame Type Sequence",false },
  {0x0018,0x9227,VR::SQ,VM::VM1,"MR Spectroscopy Frame Type Sequence",false },
  {0x0018,0x9231,VR::US,VM::VM1,"MR Acquisition Phase Encoding Steps in-plane",false },
  {0x0018,0x9232,VR::US,VM::VM1,"MR Acquisition Phase Encoding Steps out-of-plane",false },
  {0x0018,0x9234,VR::UL,VM::VM1,"Spectroscopy Acquisition Phase Columns",false },
  {0x0018,0x9236,VR::CS,VM::VM1,"Cardiac Cycle Position",false },
  {0x0018,0x9239,VR::SQ,VM::VM1,"Specific Absorption Rate Sequence",false },
  {0x0018,0x9240,VR::US,VM::VM1,"RF Echo Train Length",false },
  {0x0018,0x9241,VR::US,VM::VM1,"Gradient Echo Train Length",false },
  {0x0018,0x9295,VR::FD,VM::VM1,"Chemical Shift Minimum Integration Limit in ppm",false },
  {0x0018,0x9296,VR::FD,VM::VM1,"Chemical Shift Maximum Integration Limit in ppm",false },
  {0x0018,0x9301,VR::SQ,VM::VM1,"CT Acquisition Type Sequence",false },
  {0x0018,0x9302,VR::CS,VM::VM1,"Acquisition Type",false },
  {0x0018,0x9303,VR::FD,VM::VM1,"Tube Angle",false },
  {0x0018,0x9304,VR::SQ,VM::VM1,"CT Acquisition Details Sequence",false },
  {0x0018,0x9305,VR::FD,VM::VM1,"Revolution Time",false },
  {0x0018,0x9306,VR::FD,VM::VM1,"Single Collimation Width",false },
  {0x0018,0x9307,VR::FD,VM::VM1,"Total Collimation Width",false },
  {0x0018,0x9308,VR::SQ,VM::VM1,"CT Table Dynamics Sequence",false },
  {0x0018,0x9309,VR::FD,VM::VM1,"Table Speed",false },
  {0x0018,0x9310,VR::FD,VM::VM1,"Table Feed per Rotation",false },
  {0x0018,0x9311,VR::FD,VM::VM1,"Spiral Pitch Factor",false },
  {0x0018,0x9312,VR::SQ,VM::VM1,"CT Geometry Sequence",false },
  {0x0018,0x9313,VR::FD,VM::VM3,"Data Collection Center (Patient)",false },
  {0x0018,0x9314,VR::SQ,VM::VM1,"CT Reconstruction Sequence",false },
  {0x0018,0x9315,VR::CS,VM::VM1,"Reconstruction Algorithm",false },
  {0x0018,0x9316,VR::CS,VM::VM1,"Convolution Kernel Group",false },
  {0x0018,0x9317,VR::FD,VM::VM2,"Reconstruction Field of View",false },
  {0x0018,0x9318,VR::FD,VM::VM3,"Reconstruction Target Center (Patient)",false },
  {0x0018,0x9319,VR::FD,VM::VM1,"Reconstruction Angle",false },
  {0x0018,0x9320,VR::SH,VM::VM1,"Image Filter",false },
  {0x0018,0x9321,VR::SQ,VM::VM1,"CT Exposure Sequence",false },
  {0x0018,0x9322,VR::FD,VM::VM2,"Reconstruction Pixel Spacing",false },
  {0x0018,0x9323,VR::CS,VM::VM1,"Exposure Modulation Type",false },
  {0x0018,0x9324,VR::FD,VM::VM1,"Estimated Dose Saving",false },
  {0x0018,0x9325,VR::SQ,VM::VM1,"CT X-Ray Details Sequence",false },
  {0x0018,0x9326,VR::SQ,VM::VM1,"CT Position Sequence",false },
  {0x0018,0x9327,VR::FD,VM::VM1,"Table Position",false },
  {0x0018,0x9328,VR::FD,VM::VM1,"Exposure Time in ms",false },
  {0x0018,0x9329,VR::SQ,VM::VM1,"CT Image Frame Type Sequence",false },
  {0x0018,0x9330,VR::FD,VM::VM1,"X-Ray Tube Current in mA",false },
  {0x0018,0x9332,VR::FD,VM::VM1,"Exposure in mAs",false },
  {0x0018,0x9333,VR::CS,VM::VM1,"Constant Volume Flag",false },
  {0x0018,0x9334,VR::CS,VM::VM1,"Fluoroscopy Flag",false },
  {0x0018,0x9335,VR::FD,VM::VM1,"Distance Source to Data Collection Center",false },
  {0x0018,0x9337,VR::US,VM::VM1,"Contrast/Bolus Agent Number",false },
  {0x0018,0x9338,VR::SQ,VM::VM1,"Contrast/Bolus Ingredient Code Sequence",false },
  {0x0018,0x9340,VR::SQ,VM::VM1,"Contrast Administration Profile Sequence",false },
  {0x0018,0x9341,VR::SQ,VM::VM1,"Contrast/Bolus Usage Sequence",false },
  {0x0018,0x9342,VR::CS,VM::VM1,"Contrast/Bolus Agent Administered",false },
  {0x0018,0x9343,VR::CS,VM::VM1,"Contrast/Bolus Agent Detected",false },
  {0x0018,0x9344,VR::CS,VM::VM1,"Contrast/Bolus Agent Phase",false },
  {0x0018,0x9345,VR::FD,VM::VM1,"CTDIvol",false },
  {0x0018,0x9346,VR::SQ,VM::VM1,"CTDI Phantom Type Code Sequence",false },
  {0x0018,0x9351,VR::FL,VM::VM1,"Calcium Scoring Mass Factor Patient",false },
  {0x0018,0x9352,VR::FL,VM::VM3,"Calcium Scoring Mass Factor Device",false },
  {0x0018,0x9353,VR::FL,VM::VM1,"Energy Weighting Factor",false },
  {0x0018,0x9360,VR::SQ,VM::VM1,"CT Additional X-Ray Source Sequence",false },
  {0x0018,0x9401,VR::SQ,VM::VM1,"Projection Pixel Calibration Sequence",false },
  {0x0018,0x9402,VR::FL,VM::VM1,"Distance Source to Isocenter",false },
  {0x0018,0x9403,VR::FL,VM::VM1,"Distance Object to Table Top",false },
  {0x0018,0x9404,VR::FL,VM::VM2,"Object Pixel Spacing in Center of Beam",false },
  {0x0018,0x9405,VR::SQ,VM::VM1,"Positioner Position Sequence",false },
  {0x0018,0x9406,VR::SQ,VM::VM1,"Table Position Sequence",false },
  {0x0018,0x9407,VR::SQ,VM::VM1,"Collimator Shape Sequence",false },
  {0x0018,0x9412,VR::SQ,VM::VM1,"XA/XRF Frame Characteristics Sequence",false },
  {0x0018,0x9417,VR::SQ,VM::VM1,"Frame Acquisition Sequence",false },
  {0x0018,0x9420,VR::CS,VM::VM1,"X-Ray Receptor Type",false },
  {0x0018,0x9423,VR::LO,VM::VM1,"Acquisition Protocol Name",false },
  {0x0018,0x9424,VR::LT,VM::VM1,"Acquisition Protocol Description",false },
  {0x0018,0x9425,VR::CS,VM::VM1,"Contrast/Bolus Ingredient Opaque",false },
  {0x0018,0x9426,VR::FL,VM::VM1,"Distance Receptor Plane to Detector Housing",false },
  {0x0018,0x9427,VR::CS,VM::VM1,"Intensifier Active Shape",false },
  {0x0018,0x9428,VR::FL,VM::VM1_2,"Intensifier Active Dimension(s)",false },
  {0x0018,0x9429,VR::FL,VM::VM2,"Physical Detector Size",false },
  {0x0018,0x9430,VR::US,VM::VM2,"Position of Isocenter Projection",false },
  {0x0018,0x9432,VR::SQ,VM::VM1,"Field of View Sequence",false },
  {0x0018,0x9433,VR::LO,VM::VM1,"Field of View Description",false },
  {0x0018,0x9434,VR::SQ,VM::VM1,"Exposure Control Sensing Regions Sequence",false },
  {0x0018,0x9435,VR::CS,VM::VM1,"Exposure Control Sensing Region Shape",false },
  {0x0018,0x9436,VR::SS,VM::VM1,"Exposure Control Sensing Region Left Vertical Edge",false },
  {0x0018,0x9437,VR::SS,VM::VM1,"Exposure Control Sensing Region Right Vertical Edge",false },
  {0x0018,0x9438,VR::SS,VM::VM1,"Exposure Control Sensing Region Upper Horizontal Edge",false },
  {0x0018,0x9439,VR::SS,VM::VM1,"Exposure Control Sensing Region Lower Horizontal Edge",false },
  {0x0018,0x9440,VR::SS,VM::VM2,"Center of Circular Exposure Control Sensing Region",false },
  {0x0018,0x9441,VR::US,VM::VM1,"Radius of Circular Exposure Control Sensing Region",false },
  {0x0018,0x9442,VR::SS,VM::VM2_n,"Vertices of the Polygonal Exposure Control Sensing Region",false },
  {0x0018,0x9445,VR::INVALID,VM::VM0,"",true },
  {0x0018,0x9447,VR::FL,VM::VM1,"Column Angulation (Patient)",false },
  {0x0018,0x9449,VR::FL,VM::VM1,"Beam Angle",false },
  {0x0018,0x9451,VR::SQ,VM::VM1,"Frame Detector Parameters Sequence",false },
  {0x0018,0x9452,VR::FL,VM::VM1,"Calculated Anatomy Thickness",false },
  {0x0018,0x9455,VR::SQ,VM::VM1,"Calibration Sequence",false },
  {0x0018,0x9456,VR::SQ,VM::VM1,"Object Thickness Sequence",false },
  {0x0018,0x9457,VR::CS,VM::VM1,"Plane Identification",false },
  {0x0018,0x9461,VR::FL,VM::VM1_2,"Field of View Dimension(s) in Float",false },
  {0x0018,0x9462,VR::SQ,VM::VM1,"Isocenter Reference System Sequence",false },
  {0x0018,0x9463,VR::FL,VM::VM1,"Positioner Isocenter Primary Angle",false },
  {0x0018,0x9464,VR::FL,VM::VM1,"Positioner Isocenter Secondary Angle",false },
  {0x0018,0x9465,VR::FL,VM::VM1,"Positioner Isocenter Detector Rotation Angle",false },
  {0x0018,0x9466,VR::FL,VM::VM1,"Table X Position to Isocenter",false },
  {0x0018,0x9467,VR::FL,VM::VM1,"Table Y Position to Isocenter",false },
  {0x0018,0x9468,VR::FL,VM::VM1,"Table Z Position to Isocenter",false },
  {0x0018,0x9469,VR::FL,VM::VM1,"Table Horizontal Rotation Angle",false },
  {0x0018,0x9470,VR::FL,VM::VM1,"Table Head Tilt Angle",false },
  {0x0018,0x9471,VR::FL,VM::VM1,"Table Cradle Tilt Angle",false },
  {0x0018,0x9472,VR::SQ,VM::VM1,"Frame Display Shutter Sequence",false },
  {0x0018,0x9473,VR::FL,VM::VM1,"Acquired Image Area Dose Product",false },
  {0x0018,0x9474,VR::CS,VM::VM1,"C-arm Positioner Tabletop Relationship",false },
  {0x0018,0x9476,VR::SQ,VM::VM1,"X-Ray Geometry Sequence",false },
  {0x0018,0x9477,VR::SQ,VM::VM1,"Irradiation Event Identification Sequence",false },
  {0x0018,0x9504,VR::SQ,VM::VM1,"X-Ray 3D Frame Type Sequence",false },
  {0x0018,0x9506,VR::SQ,VM::VM1,"Contributing Sources Sequence",false },
  {0x0018,0x9507,VR::SQ,VM::VM1,"X-Ray 3D Acquisition Sequence",false },
  {0x0018,0x9508,VR::FL,VM::VM1,"Primary Positioner Scan Arc",false },
  {0x0018,0x9509,VR::FL,VM::VM1,"Secondary Positioner Scan Arc",false },
  {0x0018,0x9510,VR::FL,VM::VM1,"Primary Positioner Scan Start Angle",false },
  {0x0018,0x9511,VR::FL,VM::VM1,"Secondary Positioner Scan Start Angle",false },
  {0x0018,0x9514,VR::FL,VM::VM1,"Primary Positioner Increment",false },
  {0x0018,0x9515,VR::FL,VM::VM1,"Secondary Positioner Increment",false },
  {0x0018,0x9516,VR::DT,VM::VM1,"Start Acquisition DateTime",false },
  {0x0018,0x9517,VR::DT,VM::VM1,"End Acquisition DateTime",false },
  {0x0018,0x9524,VR::LO,VM::VM1,"Application Name",false },
  {0x0018,0x9525,VR::LO,VM::VM1,"Application Version",false },
  {0x0018,0x9526,VR::LO,VM::VM1,"Application Manufacturer",false },
  {0x0018,0x9527,VR::CS,VM::VM1,"Algorithm Type",false },
  {0x0018,0x9528,VR::LO,VM::VM1,"Algorithm Description",false },
  {0x0018,0x9530,VR::SQ,VM::VM1,"X-Ray 3D Reconstruction Sequence",false },
  {0x0018,0x9531,VR::LO,VM::VM1,"Reconstruction Description",false },
  {0x0018,0x9538,VR::SQ,VM::VM1,"Per Projection Acquisition Sequence",false },
  {0x0018,0x9601,VR::SQ,VM::VM1,"Diffusion b-matrix Sequence",false },
  {0x0018,0x9602,VR::FD,VM::VM1,"Diffusion b-value XX",false },
  {0x0018,0x9603,VR::FD,VM::VM1,"Diffusion b-value XY",false },
  {0x0018,0x9604,VR::FD,VM::VM1,"Diffusion b-value XZ",false },
  {0x0018,0x9605,VR::FD,VM::VM1,"Diffusion b-value YY",false },
  {0x0018,0x9606,VR::FD,VM::VM1,"Diffusion b-value YZ",false },
  {0x0018,0x9607,VR::FD,VM::VM1,"Diffusion b-value ZZ",false },
  {0x0018,0x9701,VR::DT,VM::VM1,"Decay Correction DateTime",false },
  {0x0018,0x9715,VR::FD,VM::VM1,"Start Density Threshold",false },
  {0x0018,0x9716,VR::FD,VM::VM1,"Start Relative Density Difference Threshold",false },
  {0x0018,0x9717,VR::FD,VM::VM1,"Start Cardiac Trigger Count Threshold",false },
  {0x0018,0x9718,VR::FD,VM::VM1,"Start Respiratory Trigger Count Threshold",false },
  {0x0018,0x9719,VR::FD,VM::VM1,"Termination Counts Threshold",false },
  {0x0018,0x9720,VR::FD,VM::VM1,"Termination Density Threshold",false },
  {0x0018,0x9721,VR::FD,VM::VM1,"Termination Relative Density Threshold",false },
  {0x0018,0x9722,VR::FD,VM::VM1,"Termination Time Threshold",false },
  {0x0018,0x9723,VR::FD,VM::VM1,"Termination Cardiac Trigger Count Threshold",false },
  {0x0018,0x9724,VR::FD,VM::VM1,"Termination Respiratory Trigger Count Threshold",false },
  {0x0018,0x9725,VR::CS,VM::VM1,"Detector Geometry",false },
  {0x0018,0x9726,VR::FD,VM::VM1,"Transverse Detector Separation",false },
  {0x0018,0x9727,VR::FD,VM::VM1,"Axial Detector Dimension",false },
  {0x0018,0x9729,VR::US,VM::VM1,"Radiopharmaceutical Agent Number",false },
  {0x0018,0x9732,VR::SQ,VM::VM1,"PET Frame Acquisition Sequence",false },
  {0x0018,0x9733,VR::SQ,VM::VM1,"PET Detector Motion Details Sequence",false },
  {0x0018,0x9734,VR::SQ,VM::VM1,"PET Table Dynamics Sequence",false },
  {0x0018,0x9735,VR::SQ,VM::VM1,"PET Position Sequence",false },
  {0x0018,0x9736,VR::SQ,VM::VM1,"PET Frame Correction Factors Sequence",false },
  {0x0018,0x9737,VR::SQ,VM::VM1,"Radiopharmaceutical Usage Sequence",false },
  {0x0018,0x9738,VR::CS,VM::VM1,"Attenuation Correction Source",false },
  {0x0018,0x9739,VR::US,VM::VM1,"Number of Iterations",false },
  {0x0018,0x9740,VR::US,VM::VM1,"Number of Subsets",false },
  {0x0018,0x9749,VR::SQ,VM::VM1,"PET Reconstruction Sequence",false },
  {0x0018,0x9751,VR::SQ,VM::VM1,"PET Frame Type Sequence",false },
  {0x0018,0x9755,VR::CS,VM::VM1,"Time of Flight Information Used",false },
  {0x0018,0x9756,VR::CS,VM::VM1,"Reconstruction Type",false },
  {0x0018,0x9758,VR::CS,VM::VM1,"Decay Corrected",false },
  {0x0018,0x9759,VR::CS,VM::VM1,"Attenuation Corrected",false },
  {0x0018,0x9760,VR::CS,VM::VM1,"Scatter Corrected",false },
  {0x0018,0x9761,VR::CS,VM::VM1,"Dead Time Corrected",false },
  {0x0018,0x9762,VR::CS,VM::VM1,"Gantry Motion Corrected",false },
  {0x0018,0x9763,VR::CS,VM::VM1,"Patient Motion Corrected",false },
  {0x0018,0x9764,VR::CS,VM::VM1,"Count Loss Normalization Corrected",false },
  {0x0018,0x9765,VR::CS,VM::VM1,"Randoms Corrected",false },
  {0x0018,0x9766,VR::CS,VM::VM1,"Non-uniform Radial Sampling Corrected",false },
  {0x0018,0x9767,VR::CS,VM::VM1,"Sensitivity Calibrated",false },
  {0x0018,0x9768,VR::CS,VM::VM1,"Detector Normalization Correction",false },
  {0x0018,0x9769,VR::CS,VM::VM1,"Iterative Reconstruction Method",false },
  {0x0018,0x9770,VR::CS,VM::VM1,"Attenuation Correction Temporal Relationship",false },
  {0x0018,0x9771,VR::SQ,VM::VM1,"Patient Physiological State Sequence",false },
  {0x0018,0x9772,VR::SQ,VM::VM1,"Patient Physiological State Code Sequence",false },
  {0x0018,0x9801,VR::FD,VM::VM1_n,"Depth(s) of Focus",false },
  {0x0018,0x9803,VR::SQ,VM::VM1,"Excluded Intervals Sequence",false },
  {0x0018,0x9804,VR::DT,VM::VM1,"Exclusion Start Datetime",false },
  {0x0018,0x9805,VR::FD,VM::VM1,"Exclusion Duration",false },
  {0x0018,0x9806,VR::SQ,VM::VM1,"US Image Description Sequence",false },
  {0x0018,0x9807,VR::SQ,VM::VM1,"Image Data Type Sequence",false },
  {0x0018,0x9808,VR::CS,VM::VM1,"Data Type",false },
  {0x0018,0x9809,VR::SQ,VM::VM1,"Transducer Scan Pattern Code Sequence",false },
  {0x0018,0x980b,VR::CS,VM::VM1,"Aliased Data Type",false },
  {0x0018,0x980c,VR::CS,VM::VM1,"Position Measuring Device Used",false },
  {0x0018,0x980d,VR::SQ,VM::VM1,"Transducer Geometry Code Sequence",false },
  {0x0018,0x980e,VR::SQ,VM::VM1,"Transducer Beam Steering Code Sequence",false },
  {0x0018,0x980f,VR::SQ,VM::VM1,"Transducer Application Code Sequence",false },
  {0x0018,0xa001,VR::SQ,VM::VM1,"Contributing Equipment Sequence",false },
  {0x0018,0xa002,VR::DT,VM::VM1,"Contribution Date Time",false },
  {0x0018,0xa003,VR::ST,VM::VM1,"Contribution Description",false },
  {0x0020,0x000d,VR::UI,VM::VM1,"Study Instance UID",false },
  {0x0020,0x000e,VR::UI,VM::VM1,"Series Instance UID",false },
  {0x0020,0x0010,VR::SH,VM::VM1,"Study ID",false },
  {0x0020,0x0011,VR::IS,VM::VM1,"Series Number",false },
  {0x0020,0x0012,VR::IS,VM::VM1,"Acquisition Number",false },
  {0x0020,0x0013,VR::IS,VM::VM1,"Instance Number",false },
  {0x0020,0x0014,VR::IS,VM::VM1,"Isotope Number",true },
  {0x0020,0x0015,VR::IS,VM::VM1,"Phase Number",true },
  {0x0020,0x0016,VR::IS,VM::VM1,"Interval Number",true },
  {0x0020,0x0017,VR::IS,VM::VM1,"Time Slot Number",true },
  {0x0020,0x0018,VR::IS,VM::VM1,"Angle Number",true },
  {0x0020,0x0019,VR::IS,VM::VM1,"Item Number",false },
  {0x0020,0x0020,VR::CS,VM::VM2,"Patient Orientation",false },
  {0x0020,0x0022,VR::IS,VM::VM1,"Overlay Number",true },
  {0x0020,0x0024,VR::IS,VM::VM1,"Curve Number",true },
  {0x0020,0x0026,VR::IS,VM::VM1,"LUT Number",true },
  {0x0020,0x0030,VR::DS,VM::VM3,"Image Position",true },
  {0x0020,0x0032,VR::DS,VM::VM3,"Image Position (Patient)",false },
  {0x0020,0x0035,VR::DS,VM::VM6,"Image Orientation",true },
  {0x0020,0x0037,VR::DS,VM::VM6,"Image Orientation (Patient)",false },
  {0x0020,0x0050,VR::DS,VM::VM1,"Location",true },
  {0x0020,0x0052,VR::UI,VM::VM1,"Frame of Reference UID",false },
  {0x0020,0x0060,VR::CS,VM::VM1,"Laterality",false },
  {0x0020,0x0062,VR::CS,VM::VM1,"Image Laterality",false },
  {0x0020,0x0070,VR::LO,VM::VM1,"Image Geometry Type",true },
  {0x0020,0x0080,VR::CS,VM::VM1_n,"Masking Image",true },
  {0x0020,0x0100,VR::IS,VM::VM1,"Temporal Position Identifier",false },
  {0x0020,0x0105,VR::IS,VM::VM1,"Number of Temporal Positions",false },
  {0x0020,0x0110,VR::DS,VM::VM1,"Temporal Resolution",false },
  {0x0020,0x0200,VR::UI,VM::VM1,"Synchronization Frame of Reference UID",false },
  {0x0020,0x0242,VR::UI,VM::VM1,"SOP Instance UID of Concatenation Source",false },
  {0x0020,0x1000,VR::IS,VM::VM1,"Series in Study",true },
  {0x0020,0x1001,VR::IS,VM::VM1,"Acquisitions in Series",true },
  {0x0020,0x1002,VR::IS,VM::VM1,"Images in Acquisition",false },
  {0x0020,0x1003,VR::IS,VM::VM1,"Images in Series",true },
  {0x0020,0x1004,VR::IS,VM::VM1,"Acquisitions in Study",true },
  {0x0020,0x1005,VR::IS,VM::VM1,"Images in Study",true },
  {0x0020,0x1020,VR::CS,VM::VM1_n,"Reference",true },
  {0x0020,0x1040,VR::LO,VM::VM1,"Position Reference Indicator",false },
  {0x0020,0x1041,VR::DS,VM::VM1,"Slice Location",false },
  {0x0020,0x1070,VR::IS,VM::VM1_n,"Other Study Numbers",true },
  {0x0020,0x1200,VR::IS,VM::VM1,"Number of Patient Related Studies",false },
  {0x0020,0x1202,VR::IS,VM::VM1,"Number of Patient Related Series",false },
  {0x0020,0x1204,VR::IS,VM::VM1,"Number of Patient Related Instances",false },
  {0x0020,0x1206,VR::IS,VM::VM1,"Number of Study Related Series",false },
  {0x0020,0x1208,VR::IS,VM::VM1,"Number of Study Related Instances",false },
  {0x0020,0x1209,VR::IS,VM::VM1,"Number of Series Related Instances",false },
  {0x0020,0x3100,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3101,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3102,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3103,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3104,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3105,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3106,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3107,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3108,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3109,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x310f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3110,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3111,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3112,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3113,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3114,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3115,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3116,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3117,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3118,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3119,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x311f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3120,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3121,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3122,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3123,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3124,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3125,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3126,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3127,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3128,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3129,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x312f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3130,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3131,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3132,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3133,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3134,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3135,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3136,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3137,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3138,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3139,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x313f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3140,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3141,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3142,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3143,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3144,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3145,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3146,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3147,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3148,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3149,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x314f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3150,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3151,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3152,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3153,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3154,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3155,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3156,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3157,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3158,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3159,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x315f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3160,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3161,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3162,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3163,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3164,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3165,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3166,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3167,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3168,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3169,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x316f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3170,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3171,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3172,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3173,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3174,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3175,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3176,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3177,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3178,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3179,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x317f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3180,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3181,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3182,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3183,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3184,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3185,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3186,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3187,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3188,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3189,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x318f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3190,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3191,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3192,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3193,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3194,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3195,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3196,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3197,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3198,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3199,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319a,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319b,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319c,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319d,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319e,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x319f,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31a9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31aa,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ab,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ac,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ad,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ae,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31af,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31b9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ba,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31bb,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31bc,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31bd,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31be,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31bf,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31c9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ca,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31cb,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31cc,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31cd,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ce,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31cf,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31d9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31da,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31db,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31dc,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31dd,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31de,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31df,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31e9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ea,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31eb,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ec,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ed,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ee,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ef,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f0,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f1,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f2,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f3,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f4,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f5,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f6,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f7,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f8,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31f9,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31fa,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31fb,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31fc,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31fd,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31fe,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x31ff,VR::CS,VM::VM1_n,"Source Image IDs",true },
  {0x0020,0x3401,VR::CS,VM::VM1,"Modifying Device ID",true },
  {0x0020,0x3402,VR::CS,VM::VM1,"Modified Image ID",true },
  {0x0020,0x3403,VR::DA,VM::VM1,"Modified Image Date",true },
  {0x0020,0x3404,VR::LO,VM::VM1,"Modifying Device Manufacturer",true },
  {0x0020,0x3405,VR::TM,VM::VM1,"Modified Image Time",true },
  {0x0020,0x3406,VR::LO,VM::VM1,"Modified Image Description",true },
  {0x0020,0x4000,VR::LT,VM::VM1,"Image Comments",false },
  {0x0020,0x5000,VR::AT,VM::VM1_n,"Original Image Identification",true },
  {0x0020,0x5002,VR::CS,VM::VM1_n,"Original Image Identification Nomenclature",true },
  {0x0020,0x9056,VR::SH,VM::VM1,"Stack ID",false },
  {0x0020,0x9057,VR::UL,VM::VM1,"In-Stack Position Number",false },
  {0x0020,0x9071,VR::SQ,VM::VM1,"Frame Anatomy Sequence",false },
  {0x0020,0x9072,VR::CS,VM::VM1,"Frame Laterality",false },
  {0x0020,0x9111,VR::SQ,VM::VM1,"Frame Content Sequence",false },
  {0x0020,0x9113,VR::SQ,VM::VM1,"Plane Position Sequence",false },
  {0x0020,0x9116,VR::SQ,VM::VM1,"Plane Orientation Sequence",false },
  {0x0020,0x9128,VR::UL,VM::VM1,"Temporal Position Index",false },
  {0x0020,0x9153,VR::FD,VM::VM1,"Nominal Cardiac Trigger Delay Time",false },
  {0x0020,0x9156,VR::US,VM::VM1,"Frame Acquisition Number",false },
  {0x0020,0x9157,VR::UL,VM::VM1_n,"Dimension Index Values",false },
  {0x0020,0x9158,VR::LT,VM::VM1,"Frame Comments",false },
  {0x0020,0x9161,VR::UI,VM::VM1,"Concatenation UID",false },
  {0x0020,0x9162,VR::US,VM::VM1,"In-concatenation Number",false },
  {0x0020,0x9163,VR::US,VM::VM1,"In-concatenation Total Number",false },
  {0x0020,0x9164,VR::UI,VM::VM1,"Dimension Organization UID",false },
  {0x0020,0x9165,VR::AT,VM::VM1,"Dimension Index Pointer",false },
  {0x0020,0x9167,VR::AT,VM::VM1,"Functional Group Pointer",false },
  {0x0020,0x9213,VR::LO,VM::VM1,"Dimension Index Private Creator",false },
  {0x0020,0x9221,VR::SQ,VM::VM1,"Dimension Organization Sequence",false },
  {0x0020,0x9222,VR::SQ,VM::VM1,"Dimension Index Sequence",false },
  {0x0020,0x9228,VR::UL,VM::VM1,"Concatenation Frame Offset Number",false },
  {0x0020,0x9238,VR::LO,VM::VM1,"Functional Group Private Creator",false },
  {0x0020,0x9241,VR::FL,VM::VM1,"Nominal Percentage of Cardiac Phase",false },
  {0x0020,0x9245,VR::FL,VM::VM1,"Nominal Percentage of Respiratory Phase",false },
  {0x0020,0x9246,VR::FL,VM::VM1,"Starting Respiratory Amplitude",false },
  {0x0020,0x9247,VR::CS,VM::VM1,"Starting Respiratory Phase",false },
  {0x0020,0x9248,VR::FL,VM::VM1,"Ending Respiratory Amplitude",false },
  {0x0020,0x9249,VR::CS,VM::VM1,"Ending Respiratory Phase",false },
  {0x0020,0x9250,VR::CS,VM::VM1,"Respiratory Trigger Type",false },
  {0x0020,0x9251,VR::FD,VM::VM1,"R - R Interval Time Nominal",false },
  {0x0020,0x9252,VR::FD,VM::VM1,"Actual Cardiac Trigger Delay Time",false },
  {0x0020,0x9253,VR::SQ,VM::VM1,"Respiratory Synchronization Sequence",false },
  {0x0020,0x9254,VR::FD,VM::VM1,"Respiratory Interval Time",false },
  {0x0020,0x9255,VR::FD,VM::VM1,"Nominal Respiratory Trigger Delay Time",false },
  {0x0020,0x9256,VR::FD,VM::VM1,"Respiratory Trigger Delay Threshold",false },
  {0x0020,0x9257,VR::FD,VM::VM1,"Actual Respiratory Trigger Delay Time",false },
  {0x0020,0x9301,VR::FD,VM::VM3,"Image Position (Volume)",false },
  {0x0020,0x9302,VR::FD,VM::VM6,"Image Orientation (Volume)",false },
  {0x0020,0x9307,VR::CS,VM::VM1,"Ultrasound Acquisition Geometry",false },
  {0x0020,0x9308,VR::FD,VM::VM3,"Apex Position",false },
  {0x0020,0x9309,VR::FD,VM::VM16,"Volume to Transducer Mapping Matrix",false },
  {0x0020,0x930a,VR::FD,VM::VM16,"Volume to Table Mapping Matrix",false },
  {0x0020,0x930c,VR::CS,VM::VM1,"Patient Frame of Reference Source",false },
  {0x0020,0x930d,VR::FD,VM::VM1,"Temporal Position Time Offset",false },
  {0x0020,0x930e,VR::SQ,VM::VM1,"Plane Position (Volume) Sequence",false },
  {0x0020,0x930f,VR::SQ,VM::VM1,"Plane Orientation (Volume) Sequence",false },
  {0x0020,0x9310,VR::SQ,VM::VM1,"Temporal Position Sequence",false },
  {0x0020,0x9311,VR::CS,VM::VM1,"Dimension Organization Type",false },
  {0x0020,0x9312,VR::UI,VM::VM1,"Volume Frame of Reference UID",false },
  {0x0020,0x9313,VR::UI,VM::VM1,"Table Frame of Reference UID",false },
  {0x0020,0x9421,VR::LO,VM::VM1,"Dimension Description Label",false },
  {0x0020,0x9450,VR::SQ,VM::VM1,"Patient Orientation in Frame Sequence",false },
  {0x0020,0x9453,VR::LO,VM::VM1,"Frame Label",false },
  {0x0020,0x9518,VR::US,VM::VM1_n,"Acquisition Index",false },
  {0x0020,0x9529,VR::SQ,VM::VM1,"Contributing SOP Instances Reference Sequence",false },
  {0x0020,0x9536,VR::US,VM::VM1,"Reconstruction Index",false },
  {0x0022,0x0001,VR::US,VM::VM1,"Light Path Filter Pass-Through Wavelength",false },
  {0x0022,0x0002,VR::US,VM::VM2,"Light Path Filter Pass Band",false },
  {0x0022,0x0003,VR::US,VM::VM1,"Image Path Filter Pass-Through Wavelength",false },
  {0x0022,0x0004,VR::US,VM::VM2,"Image Path Filter Pass Band",false },
  {0x0022,0x0005,VR::CS,VM::VM1,"Patient Eye Movement Commanded",false },
  {0x0022,0x0006,VR::SQ,VM::VM1,"Patient Eye Movement Command Code Sequence",false },
  {0x0022,0x0007,VR::FL,VM::VM1,"Spherical Lens Power",false },
  {0x0022,0x0008,VR::FL,VM::VM1,"Cylinder Lens Power",false },
  {0x0022,0x0009,VR::FL,VM::VM1,"Cylinder Axis",false },
  {0x0022,0x000a,VR::FL,VM::VM1,"Emmetropic Magnification",false },
  {0x0022,0x000b,VR::FL,VM::VM1,"Intra Ocular Pressure",false },
  {0x0022,0x000c,VR::FL,VM::VM1,"Horizontal Field of View",false },
  {0x0022,0x000d,VR::CS,VM::VM1,"Pupil Dilated",false },
  {0x0022,0x000e,VR::FL,VM::VM1,"Degree of Dilation",false },
  {0x0022,0x0010,VR::FL,VM::VM1,"Stereo Baseline Angle",false },
  {0x0022,0x0011,VR::FL,VM::VM1,"Stereo Baseline Displacement",false },
  {0x0022,0x0012,VR::FL,VM::VM1,"Stereo Horizontal Pixel Offset",false },
  {0x0022,0x0013,VR::FL,VM::VM1,"Stereo Vertical Pixel Offset",false },
  {0x0022,0x0014,VR::FL,VM::VM1,"Stereo Rotation",false },
  {0x0022,0x0015,VR::SQ,VM::VM1,"Acquisition Device Type Code Sequence",false },
  {0x0022,0x0016,VR::SQ,VM::VM1,"Illumination Type Code Sequence",false },
  {0x0022,0x0017,VR::SQ,VM::VM1,"Light Path Filter Type Stack Code Sequence",false },
  {0x0022,0x0018,VR::SQ,VM::VM1,"Image Path Filter Type Stack Code Sequence",false },
  {0x0022,0x0019,VR::SQ,VM::VM1,"Lenses Code Sequence",false },
  {0x0022,0x001a,VR::SQ,VM::VM1,"Channel Description Code Sequence",false },
  {0x0022,0x001b,VR::SQ,VM::VM1,"Refractive State Sequence",false },
  {0x0022,0x001c,VR::SQ,VM::VM1,"Mydriatic Agent Code Sequence",false },
  {0x0022,0x001d,VR::SQ,VM::VM1,"Relative Image Position Code Sequence",false },
  {0x0022,0x0020,VR::SQ,VM::VM1,"Stereo Pairs Sequence",false },
  {0x0022,0x0021,VR::SQ,VM::VM1,"Left Image Sequence",false },
  {0x0022,0x0022,VR::SQ,VM::VM1,"Right Image Sequence",false },
  {0x0022,0x0030,VR::FL,VM::VM1,"Axial Length of the Eye",false },
  {0x0022,0x0031,VR::SQ,VM::VM1,"Ophthalmic Frame Location Sequence",false },
  {0x0022,0x0032,VR::FL,VM::VM2_2n,"Reference Coordinates",false },
  {0x0022,0x0035,VR::FL,VM::VM1,"Depth Spatial Resolution",false },
  {0x0022,0x0036,VR::FL,VM::VM1,"Maximum Depth Distortion",false },
  {0x0022,0x0037,VR::FL,VM::VM1,"Along-scan Spatial Resolution",false },
  {0x0022,0x0038,VR::FL,VM::VM1,"Maximum Along-scan Distortion",false },
  {0x0022,0x0039,VR::CS,VM::VM1,"Ophthalmic Image Orientation",false },
  {0x0022,0x0041,VR::FL,VM::VM1,"Depth of Transverse Image",false },
  {0x0022,0x0042,VR::SQ,VM::VM1,"Mydriatic Agent Concentration Units Sequence",false },
  {0x0022,0x0048,VR::FL,VM::VM1,"Across-scan Spatial Resolution",false },
  {0x0022,0x0049,VR::FL,VM::VM1,"Maximum Across-scan Distortion",false },
  {0x0022,0x004e,VR::DS,VM::VM1,"Mydriatic Agent Concentration",false },
  {0x0022,0x0055,VR::FL,VM::VM1,"Illumination Wave Length",false },
  {0x0022,0x0056,VR::FL,VM::VM1,"Illumination Power",false },
  {0x0022,0x0057,VR::FL,VM::VM1,"Illumination Bandwidth",false },
  {0x0022,0x0058,VR::SQ,VM::VM1,"Mydriatic Agent Sequence",false },
  {0x0028,0x0002,VR::US,VM::VM1,"Samples per Pixel",false },
  {0x0028,0x0003,VR::US,VM::VM1,"Samples per Pixel Used",false },
  {0x0028,0x0004,VR::CS,VM::VM1,"Photometric Interpretation",false },
  {0x0028,0x0005,VR::US,VM::VM1,"Image Dimensions",true },
  {0x0028,0x0006,VR::US,VM::VM1,"Planar Configuration",false },
  {0x0028,0x0008,VR::IS,VM::VM1,"Number of Frames",false },
  {0x0028,0x0009,VR::AT,VM::VM1_n,"Frame Increment Pointer",false },
  {0x0028,0x000a,VR::AT,VM::VM1_n,"Frame Dimension Pointer",false },
  {0x0028,0x0010,VR::US,VM::VM1,"Rows",false },
  {0x0028,0x0011,VR::US,VM::VM1,"Columns",false },
  {0x0028,0x0012,VR::US,VM::VM1,"Planes",true },
  {0x0028,0x0014,VR::US,VM::VM1,"Ultrasound Color Data Present",false },
  {0x0028,0x0020,VR::INVALID,VM::VM0,"",true },
  {0x0028,0x0030,VR::DS,VM::VM2,"Pixel Spacing",false },
  {0x0028,0x0031,VR::DS,VM::VM2,"Zoom Factor",false },
  {0x0028,0x0032,VR::DS,VM::VM2,"Zoom Center",false },
  {0x0028,0x0034,VR::IS,VM::VM2,"Pixel Aspect Ratio",false },
  {0x0028,0x0040,VR::CS,VM::VM1,"Image Format",true },
  {0x0028,0x0050,VR::LO,VM::VM1_n,"Manipulated Image",true },
  {0x0028,0x0051,VR::CS,VM::VM1_n,"Corrected Image",false },
  {0x0028,0x005f,VR::LO,VM::VM1,"Compression Recognition Code",true },
  {0x0028,0x0060,VR::CS,VM::VM1,"Compression Code",true },
  {0x0028,0x0061,VR::SH,VM::VM1,"Compression Originator",true },
  {0x0028,0x0062,VR::LO,VM::VM1,"Compression Label",true },
  {0x0028,0x0063,VR::SH,VM::VM1,"Compression Description",true },
  {0x0028,0x0065,VR::CS,VM::VM1_n,"Compression Sequence",true },
  {0x0028,0x0066,VR::AT,VM::VM1_n,"Compression Step Pointers",true },
  {0x0028,0x0068,VR::US,VM::VM1,"Repeat Interval",true },
  {0x0028,0x0069,VR::US,VM::VM1,"Bits Grouped",true },
  {0x0028,0x0070,VR::US,VM::VM1_n,"Perimeter Table",true },
  {0x0028,0x0071,VR::US_SS,VM::VM1,"Perimeter Value",true },
  {0x0028,0x0080,VR::US,VM::VM1,"Predictor Rows",true },
  {0x0028,0x0081,VR::US,VM::VM1,"Predictor Columns",true },
  {0x0028,0x0082,VR::US,VM::VM1_n,"Predictor Constants",true },
  {0x0028,0x0090,VR::CS,VM::VM1,"Blocked Pixels",true },
  {0x0028,0x0091,VR::US,VM::VM1,"Block Rows",true },
  {0x0028,0x0092,VR::US,VM::VM1,"Block Columns",true },
  {0x0028,0x0093,VR::US,VM::VM1,"Row Overlap",true },
  {0x0028,0x0094,VR::US,VM::VM1,"Column Overlap",true },
  {0x0028,0x0100,VR::US,VM::VM1,"Bits Allocated",false },
  {0x0028,0x0101,VR::US,VM::VM1,"Bits Stored",false },
  {0x0028,0x0102,VR::US,VM::VM1,"High Bit",false },
  {0x0028,0x0103,VR::US,VM::VM1,"Pixel Representation",false },
  {0x0028,0x0104,VR::US_SS,VM::VM1,"Smallest Valid Pixel Value",true },
  {0x0028,0x0105,VR::US_SS,VM::VM1,"Largest Valid Pixel Value",true },
  {0x0028,0x0106,VR::US_SS,VM::VM1,"Smallest Image Pixel Value",false },
  {0x0028,0x0107,VR::US_SS,VM::VM1,"Largest Image Pixel Value",false },
  {0x0028,0x0108,VR::US_SS,VM::VM1,"Smallest Pixel Value in Series",false },
  {0x0028,0x0109,VR::US_SS,VM::VM1,"Largest Pixel Value in Series",false },
  {0x0028,0x0110,VR::US_SS,VM::VM1,"Smallest Image Pixel Value in Plane",true },
  {0x0028,0x0111,VR::US_SS,VM::VM1,"Largest Image Pixel Value in Plane",true },
  {0x0028,0x0120,VR::US_SS,VM::VM1,"Pixel Padding Value",false },
  {0x0028,0x0121,VR::US_SS,VM::VM1,"Pixel Padding Range Limit",false },
  {0x0028,0x0200,VR::US,VM::VM1,"Image Location",true },
  {0x0028,0x0300,VR::CS,VM::VM1,"Quality Control Image",false },
  {0x0028,0x0301,VR::CS,VM::VM1,"Burned In Annotation",false },
  {0x0028,0x0400,VR::LO,VM::VM1,"Transform Label",true },
  {0x0028,0x0401,VR::LO,VM::VM1,"Transform Version Number",true },
  {0x0028,0x0402,VR::US,VM::VM1,"Number of Transform Steps",true },
  {0x0028,0x0403,VR::LO,VM::VM1_n,"Sequence of Compressed Data",true },
  {0x0028,0x0404,VR::AT,VM::VM1_n,"Details of Coefficients",true },
  {0x0028,0x0700,VR::LO,VM::VM1,"DCT Label",true },
  {0x0028,0x0701,VR::CS,VM::VM1_n,"Data Block Description",true },
  {0x0028,0x0702,VR::AT,VM::VM1_n,"Data Block",true },
  {0x0028,0x0710,VR::US,VM::VM1,"Normalization Factor Format",true },
  {0x0028,0x0720,VR::US,VM::VM1,"Zonal Map Number Format",true },
  {0x0028,0x0721,VR::AT,VM::VM1_n,"Zonal Map Location",true },
  {0x0028,0x0722,VR::US,VM::VM1,"Zonal Map Format",true },
  {0x0028,0x0730,VR::US,VM::VM1,"Adaptive Map Format",true },
  {0x0028,0x0740,VR::US,VM::VM1,"Code Number Format",true },
  {0x0028,0x0a02,VR::CS,VM::VM1,"Pixel Spacing Calibration Type",false },
  {0x0028,0x0a04,VR::LO,VM::VM1,"Pixel Spacing Calibration Description",false },
  {0x0028,0x1040,VR::CS,VM::VM1,"Pixel Intensity Relationship",false },
  {0x0028,0x1041,VR::SS,VM::VM1,"Pixel Intensity Relationship Sign",false },
  {0x0028,0x1050,VR::DS,VM::VM1_n,"Window Center",false },
  {0x0028,0x1051,VR::DS,VM::VM1_n,"Window Width",false },
  {0x0028,0x1052,VR::DS,VM::VM1,"Rescale Intercept",false },
  {0x0028,0x1053,VR::DS,VM::VM1,"Rescale Slope",false },
  {0x0028,0x1054,VR::LO,VM::VM1,"Rescale Type",false },
  {0x0028,0x1055,VR::LO,VM::VM1_n,"Window Center & Width Explanation",false },
  {0x0028,0x1056,VR::CS,VM::VM1,"VOI LUT Function",false },
  {0x0028,0x1080,VR::CS,VM::VM1,"Gray Scale",true },
  {0x0028,0x1090,VR::CS,VM::VM1,"Recommended Viewing Mode",false },
  {0x0028,0x1100,VR::US_SS,VM::VM3,"Gray Lookup Table Descriptor",true },
  {0x0028,0x1101,VR::US_SS,VM::VM3,"Red Palette Color Lookup Table Descriptor",false },
  {0x0028,0x1102,VR::US_SS,VM::VM3,"Green Palette Color Lookup Table Descriptor",false },
  {0x0028,0x1103,VR::US_SS,VM::VM3,"Blue Palette Color Lookup Table Descriptor",false },
  {0x0028,0x1104,VR::US,VM::VM3,"Alpha Palette Color Lookup Table Descriptor",false },
  {0x0028,0x1111,VR::US_SS,VM::VM4,"Large Red Palette Color Lookup Table Descriptor",true },
  {0x0028,0x1112,VR::US_SS,VM::VM4,"Large Green Palette Color Lookup Table Descriptor",true },
  {0x0028,0x1113,VR::US_SS,VM::VM4,"Large Blue Palette Color Lookup Table Descriptor",true },
  {0x0028,0x1199,VR::UI,VM::VM1,"Palette Color Lookup Table UID",false },
  {0x0028,0x1200,VR::US_SS_OW,VM::VM1_n,"Gray Lookup Table Data",true },
  {0x0028,0x1201,VR::OW,VM::VM1,"Red Palette Color Lookup Table Data",false },
  {0x0028,0x1202,VR::OW,VM::VM1,"Green Palette Color Lookup Table Data",false },
  {0x0028,0x1203,VR::OW,VM::VM1,"Blue Palette Color Lookup Table Data",false },
  {0x0028,0x1204,VR::OW,VM::VM1,"Alpha Palette Color Lookup Table Data",false },
  {0x0028,0x1211,VR::OW,VM::VM1,"Large Red Palette Color Lookup Table Data",true },
  {0x0028,0x1212,VR::OW,VM::VM1,"Large Green Palette Color Lookup Table Data",true },
  {0x0028,0x1213,VR::OW,VM::VM1,"Large Blue Palette Color Lookup Table Data",true },
  {0x0028,0x1214,VR::UI,VM::VM1,"Large Palette Color Lookup Table UID",true },
  {0x0028,0x1221,VR::OW,VM::VM1,"Segmented Red Palette Color Lookup Table Data",false },
  {0x0028,0x1222,VR::OW,VM::VM1,"Segmented Green Palette Color Lookup Table Data",false },
  {0x0028,0x1223,VR::OW,VM::VM1,"Segmented Blue Palette Color Lookup Table Data",false },
  {0x0028,0x1300,VR::CS,VM::VM1,"Breast Implant Present",false },
  {0x0028,0x1350,VR::CS,VM::VM1,"Partial View",false },
  {0x0028,0x1351,VR::ST,VM::VM1,"Partial View Description",false },
  {0x0028,0x1352,VR::SQ,VM::VM1,"Partial View Code Sequence",false },
  {0x0028,0x135a,VR::CS,VM::VM1,"Spatial Locations Preserved",false },
  {0x0028,0x1401,VR::SQ,VM::VM1,"Data Frame Assignment Sequence",false },
  {0x0028,0x1402,VR::CS,VM::VM1,"Data Path Assignment",false },
  {0x0028,0x1403,VR::US,VM::VM1,"Bits Mapped to Color Lookup Table",false },
  {0x0028,0x1404,VR::SQ,VM::VM1,"Blending LUT 1 Sequence",false },
  {0x0028,0x1405,VR::CS,VM::VM1,"Blending LUT 1 Transfer Function",false },
  {0x0028,0x1406,VR::FD,VM::VM1,"Blending Weight Constant",false },
  {0x0028,0x1407,VR::US,VM::VM3,"Blending Lookup Table Descriptor",false },
  {0x0028,0x1408,VR::OW,VM::VM1,"Blending Lookup Table Data",false },
  {0x0028,0x140b,VR::SQ,VM::VM1,"Enhanced Palette Color Lookup Table Sequence",false },
  {0x0028,0x140c,VR::SQ,VM::VM1,"Blending LUT 2 Sequence",false },
  {0x0028,0x140d,VR::CS,VM::VM1,"Blending LUT 2 Transfer Function",false },
  {0x0028,0x140e,VR::CS,VM::VM1,"Data Path ID",false },
  {0x0028,0x140f,VR::CS,VM::VM1,"RGB LUT Transfer Function",false },
  {0x0028,0x1410,VR::CS,VM::VM1,"Alpha LUT Transfer Function",false },
  {0x0028,0x2000,VR::OB,VM::VM1,"ICC Profile",false },
  {0x0028,0x2110,VR::CS,VM::VM1,"Lossy Image Compression",false },
  {0x0028,0x2112,VR::DS,VM::VM1_n,"Lossy Image Compression Ratio",false },
  {0x0028,0x2114,VR::CS,VM::VM1_n,"Lossy Image Compression Method",false },
  {0x0028,0x3000,VR::SQ,VM::VM1,"Modality LUT Sequence",false },
  {0x0028,0x3002,VR::US_SS,VM::VM3,"LUT Descriptor",false },
  {0x0028,0x3003,VR::LO,VM::VM1,"LUT Explanation",false },
  {0x0028,0x3004,VR::LO,VM::VM1,"Modality LUT Type",false },
  {0x0028,0x3006,VR::US_SS_OW,VM::VM1_n,"LUT Data",false },
  {0x0028,0x3010,VR::SQ,VM::VM1,"VOI LUT Sequence",false },
  {0x0028,0x3110,VR::SQ,VM::VM1,"Softcopy VOI LUT Sequence",false },
  {0x0028,0x4000,VR::LT,VM::VM1,"Image Presentation Comments",true },
  {0x0028,0x5000,VR::SQ,VM::VM1,"Bi-Plane Acquisition Sequence",true },
  {0x0028,0x6010,VR::US,VM::VM1,"Representative Frame Number",false },
  {0x0028,0x6020,VR::US,VM::VM1_n,"Frame Numbers of Interest (FOI)",false },
  {0x0028,0x6022,VR::LO,VM::VM1_n,"Frame of Interest Description",false },
  {0x0028,0x6023,VR::CS,VM::VM1_n,"Frame of Interest Type",false },
  {0x0028,0x6030,VR::US,VM::VM1_n,"Mask Pointer(s)",true },
  {0x0028,0x6040,VR::US,VM::VM1_n,"R Wave Pointer",false },
  {0x0028,0x6100,VR::SQ,VM::VM1,"Mask Subtraction Sequence",false },
  {0x0028,0x6101,VR::CS,VM::VM1,"Mask Operation",false },
  {0x0028,0x6102,VR::US,VM::VM2_2n,"Applicable Frame Range",false },
  {0x0028,0x6110,VR::US,VM::VM1_n,"Mask Frame Numbers",false },
  {0x0028,0x6112,VR::US,VM::VM1,"Contrast Frame Averaging",false },
  {0x0028,0x6114,VR::FL,VM::VM2,"Mask Sub-pixel Shift",false },
  {0x0028,0x6120,VR::SS,VM::VM1,"TID Offset",false },
  {0x0028,0x6190,VR::ST,VM::VM1,"Mask Operation Explanation",false },
  {0x0028,0x7fe0,VR::UT,VM::VM1,"Pixel Data Provider URL",false },
  {0x0028,0x9001,VR::UL,VM::VM1,"Data Point Rows",false },
  {0x0028,0x9002,VR::UL,VM::VM1,"Data Point Columns",false },
  {0x0028,0x9003,VR::CS,VM::VM1,"Signal Domain Columns",false },
  {0x0028,0x9099,VR::US,VM::VM1,"Largest Monochrome Pixel Value",true },
  {0x0028,0x9108,VR::CS,VM::VM1,"Data Representation",false },
  {0x0028,0x9110,VR::SQ,VM::VM1,"Pixel Measures Sequence",false },
  {0x0028,0x9132,VR::SQ,VM::VM1,"Frame VOI LUT Sequence",false },
  {0x0028,0x9145,VR::SQ,VM::VM1,"Pixel Value Transformation Sequence",false },
  {0x0028,0x9235,VR::CS,VM::VM1,"Signal Domain Rows",false },
  {0x0028,0x9411,VR::FL,VM::VM1,"Display Filter Percentage",false },
  {0x0028,0x9415,VR::SQ,VM::VM1,"Frame Pixel Shift Sequence",false },
  {0x0028,0x9416,VR::US,VM::VM1,"Subtraction Item ID",false },
  {0x0028,0x9422,VR::SQ,VM::VM1,"Pixel Intensity Relationship LUT Sequence",false },
  {0x0028,0x9443,VR::SQ,VM::VM1,"Frame Pixel Data Properties Sequence",false },
  {0x0028,0x9444,VR::CS,VM::VM1,"Geometrical Properties",false },
  {0x0028,0x9445,VR::FL,VM::VM1,"Geometric Maximum Distortion",false },
  {0x0028,0x9446,VR::CS,VM::VM1_n,"Image Processing Applied",false },
  {0x0028,0x9454,VR::CS,VM::VM1,"Mask Selection Mode",false },
  {0x0028,0x9474,VR::CS,VM::VM1,"LUT Function",false },
  {0x0028,0x9478,VR::FL,VM::VM1,"Mask Visibility Percentage",false },
  {0x0028,0x9501,VR::SQ,VM::VM1,"Pixel Shift Sequence",false },
  {0x0028,0x9502,VR::SQ,VM::VM1,"Region Pixel Shift Sequence",false },
  {0x0028,0x9503,VR::SS,VM::VM2_2n,"Vertices of the Region",false },
  {0x0028,0x9505,VR::SQ,VM::VM1,"Multi-frame Presentation Sequence",false },
  {0x0028,0x9506,VR::US,VM::VM2_2n,"Pixel Shift Frame Range",false },
  {0x0028,0x9507,VR::US,VM::VM2_2n,"LUT Frame Range",false },
  {0x0028,0x9520,VR::DS,VM::VM16,"Image to Equipment Mapping Matrix",false },
  {0x0028,0x9537,VR::CS,VM::VM1,"Equipment Coordinate System Identification",false },
  {0x0032,0x000a,VR::CS,VM::VM1,"Study Status ID",true },
  {0x0032,0x000c,VR::CS,VM::VM1,"Study Priority ID",true },
  {0x0032,0x0012,VR::LO,VM::VM1,"Study ID Issuer",true },
  {0x0032,0x0032,VR::DA,VM::VM1,"Study Verified Date",true },
  {0x0032,0x0033,VR::TM,VM::VM1,"Study Verified Time",true },
  {0x0032,0x0034,VR::DA,VM::VM1,"Study Read Date",true },
  {0x0032,0x0035,VR::TM,VM::VM1,"Study Read Time",true },
  {0x0032,0x1000,VR::DA,VM::VM1,"Scheduled Study Start Date",true },
  {0x0032,0x1001,VR::TM,VM::VM1,"Scheduled Study Start Time",true },
  {0x0032,0x1010,VR::DA,VM::VM1,"Scheduled Study Stop Date",true },
  {0x0032,0x1011,VR::TM,VM::VM1,"Scheduled Study Stop Time",true },
  {0x0032,0x1020,VR::LO,VM::VM1,"Scheduled Study Location",true },
  {0x0032,0x1021,VR::AE,VM::VM1_n,"Scheduled Study Location AE Title",true },
  {0x0032,0x1030,VR::LO,VM::VM1,"Reason for Study",true },
  {0x0032,0x1031,VR::SQ,VM::VM1,"Requesting Physician Identification Sequence",false },
  {0x0032,0x1032,VR::PN,VM::VM1,"Requesting Physician",false },
  {0x0032,0x1033,VR::LO,VM::VM1,"Requesting Service",false },
  {0x0032,0x1034,VR::SQ,VM::VM1,"Requesting Service Code Sequence",false },
  {0x0032,0x1040,VR::DA,VM::VM1,"Study Arrival Date",true },
  {0x0032,0x1041,VR::TM,VM::VM1,"Study Arrival Time",true },
  {0x0032,0x1050,VR::DA,VM::VM1,"Study Completion Date",true },
  {0x0032,0x1051,VR::TM,VM::VM1,"Study Completion Time",true },
  {0x0032,0x1055,VR::CS,VM::VM1,"Study Component Status ID",true },
  {0x0032,0x1060,VR::LO,VM::VM1,"Requested Procedure Description",false },
  {0x0032,0x1064,VR::SQ,VM::VM1,"Requested Procedure Code Sequence",false },
  {0x0032,0x1070,VR::LO,VM::VM1,"Requested Contrast Agent",false },
  {0x0032,0x4000,VR::LT,VM::VM1,"Study Comments",true },
  {0x0038,0x0004,VR::SQ,VM::VM1,"Referenced Patient Alias Sequence",false },
  {0x0038,0x0008,VR::CS,VM::VM1,"Visit Status ID",false },
  {0x0038,0x0010,VR::LO,VM::VM1,"Admission ID",false },
  {0x0038,0x0011,VR::LO,VM::VM1,"Issuer of Admission ID",true },
  {0x0038,0x0014,VR::SQ,VM::VM1,"Issuer of Admission ID Sequence",false },
  {0x0038,0x0016,VR::LO,VM::VM1,"Route of Admissions",false },
  {0x0038,0x001a,VR::DA,VM::VM1,"Scheduled Admission Date",true },
  {0x0038,0x001b,VR::TM,VM::VM1,"Scheduled Admission Time",true },
  {0x0038,0x001c,VR::DA,VM::VM1,"Scheduled Discharge Date",true },
  {0x0038,0x001d,VR::TM,VM::VM1,"Scheduled Discharge Time",true },
  {0x0038,0x001e,VR::LO,VM::VM1,"Scheduled Patient Institution Residence",true },
  {0x0038,0x0020,VR::DA,VM::VM1,"Admitting Date",false },
  {0x0038,0x0021,VR::TM,VM::VM1,"Admitting Time",false },
  {0x0038,0x0030,VR::DA,VM::VM1,"Discharge Date",true },
  {0x0038,0x0032,VR::TM,VM::VM1,"Discharge Time",true },
  {0x0038,0x0040,VR::LO,VM::VM1,"Discharge Diagnosis Description",true },
  {0x0038,0x0044,VR::SQ,VM::VM1,"Discharge Diagnosis Code Sequence",true },
  {0x0038,0x0050,VR::LO,VM::VM1,"Special Needs",false },
  {0x0038,0x0060,VR::LO,VM::VM1,"Service Episode ID",false },
  {0x0038,0x0061,VR::LO,VM::VM1,"Issuer of Service Episode ID",true },
  {0x0038,0x0062,VR::LO,VM::VM1,"Service Episode Description",false },
  {0x0038,0x0064,VR::SQ,VM::VM1,"Issuer of Service Episode ID Sequence",false },
  {0x0038,0x0100,VR::SQ,VM::VM1,"Pertinent Documents Sequence",false },
  {0x0038,0x0300,VR::LO,VM::VM1,"Current Patient Location",false },
  {0x0038,0x0400,VR::LO,VM::VM1,"Patient's Institution Residence",false },
  {0x0038,0x0500,VR::LO,VM::VM1,"Patient State",false },
  {0x0038,0x0502,VR::SQ,VM::VM1,"Patient Clinical Trial Participation Sequence",false },
  {0x0038,0x4000,VR::LT,VM::VM1,"Visit Comments",false },
  {0x003a,0x0004,VR::CS,VM::VM1,"Waveform Originality",false },
  {0x003a,0x0005,VR::US,VM::VM1,"Number of Waveform Channels",false },
  {0x003a,0x0010,VR::UL,VM::VM1,"Number of Waveform Samples",false },
  {0x003a,0x001a,VR::DS,VM::VM1,"Sampling Frequency",false },
  {0x003a,0x0020,VR::SH,VM::VM1,"Multiplex Group Label",false },
  {0x003a,0x0200,VR::SQ,VM::VM1,"Channel Definition Sequence",false },
  {0x003a,0x0202,VR::IS,VM::VM1,"Waveform Channel Number",false },
  {0x003a,0x0203,VR::SH,VM::VM1,"Channel Label",false },
  {0x003a,0x0205,VR::CS,VM::VM1_n,"Channel Status",false },
  {0x003a,0x0208,VR::SQ,VM::VM1,"Channel Source Sequence",false },
  {0x003a,0x0209,VR::SQ,VM::VM1,"Channel Source Modifiers Sequence",false },
  {0x003a,0x020a,VR::SQ,VM::VM1,"Source Waveform Sequence",false },
  {0x003a,0x020c,VR::LO,VM::VM1,"Channel Derivation Description",false },
  {0x003a,0x0210,VR::DS,VM::VM1,"Channel Sensitivity",false },
  {0x003a,0x0211,VR::SQ,VM::VM1,"Channel Sensitivity Units Sequence",false },
  {0x003a,0x0212,VR::DS,VM::VM1,"Channel Sensitivity Correction Factor",false },
  {0x003a,0x0213,VR::DS,VM::VM1,"Channel Baseline",false },
  {0x003a,0x0214,VR::DS,VM::VM1,"Channel Time Skew",false },
  {0x003a,0x0215,VR::DS,VM::VM1,"Channel Sample Skew",false },
  {0x003a,0x0218,VR::DS,VM::VM1,"Channel Offset",false },
  {0x003a,0x021a,VR::US,VM::VM1,"Waveform Bits Stored",false },
  {0x003a,0x0220,VR::DS,VM::VM1,"Filter Low Frequency",false },
  {0x003a,0x0221,VR::DS,VM::VM1,"Filter High Frequency",false },
  {0x003a,0x0222,VR::DS,VM::VM1,"Notch Filter Frequency",false },
  {0x003a,0x0223,VR::DS,VM::VM1,"Notch Filter Bandwidth",false },
  {0x003a,0x0230,VR::FL,VM::VM1,"Waveform Data Display Scale",false },
  {0x003a,0x0231,VR::US,VM::VM3,"Waveform Display Background CIELab Value",false },
  {0x003a,0x0240,VR::SQ,VM::VM1,"Waveform Presentation Group Sequence",false },
  {0x003a,0x0241,VR::US,VM::VM1,"Presentation Group Number",false },
  {0x003a,0x0242,VR::SQ,VM::VM1,"Channel Display Sequence",false },
  {0x003a,0x0244,VR::US,VM::VM3,"Channel Recommended Display CIELab Value",false },
  {0x003a,0x0245,VR::FL,VM::VM1,"Channel Position",false },
  {0x003a,0x0246,VR::CS,VM::VM1,"Display Shading Flag",false },
  {0x003a,0x0247,VR::FL,VM::VM1,"Fractional Channel Display Scale",false },
  {0x003a,0x0248,VR::FL,VM::VM1,"Absolute Channel Display Scale",false },
  {0x003a,0x0300,VR::SQ,VM::VM1,"Multiplexed Audio Channels Description Code Sequence",false },
  {0x003a,0x0301,VR::IS,VM::VM1,"Channel Identification Code",false },
  {0x003a,0x0302,VR::CS,VM::VM1,"Channel Mode",false },
  {0x0040,0x0001,VR::AE,VM::VM1_n,"Scheduled Station AE Title",false },
  {0x0040,0x0002,VR::DA,VM::VM1,"Scheduled Procedure Step Start Date",false },
  {0x0040,0x0003,VR::TM,VM::VM1,"Scheduled Procedure Step Start Time",false },
  {0x0040,0x0004,VR::DA,VM::VM1,"Scheduled Procedure Step End Date",false },
  {0x0040,0x0005,VR::TM,VM::VM1,"Scheduled Procedure Step End Time",false },
  {0x0040,0x0006,VR::PN,VM::VM1,"Scheduled Performing Physician's Name",false },
  {0x0040,0x0007,VR::LO,VM::VM1,"Scheduled Procedure Step Description",false },
  {0x0040,0x0008,VR::SQ,VM::VM1,"Scheduled Protocol Code Sequence",false },
  {0x0040,0x0009,VR::SH,VM::VM1,"Scheduled Procedure Step ID",false },
  {0x0040,0x000a,VR::SQ,VM::VM1,"Stage Code Sequence",false },
  {0x0040,0x000b,VR::SQ,VM::VM1,"Scheduled Performing Physician Identification Sequence",false },
  {0x0040,0x0010,VR::SH,VM::VM1_n,"Scheduled Station Name",false },
  {0x0040,0x0011,VR::SH,VM::VM1,"Scheduled Procedure Step Location",false },
  {0x0040,0x0012,VR::LO,VM::VM1,"Pre-Medication",false },
  {0x0040,0x0020,VR::CS,VM::VM1,"Scheduled Procedure Step Status",false },
  {0x0040,0x0026,VR::SQ,VM::VM1,"Order Placer Identifier Sequence",false },
  {0x0040,0x0027,VR::SQ,VM::VM1,"Order Filler Identifier Sequence",false },
  {0x0040,0x0031,VR::UT,VM::VM1,"Local Namespace Entity ID",false },
  {0x0040,0x0032,VR::UT,VM::VM1,"Universal Entity ID",false },
  {0x0040,0x0033,VR::CS,VM::VM1,"Universal Entity ID Type",false },
  {0x0040,0x0035,VR::CS,VM::VM1,"Identifier Type Code",false },
  {0x0040,0x0036,VR::SQ,VM::VM1,"Assigning Facility Sequence",false },
  {0x0040,0x0039,VR::SQ,VM::VM1,"Assigning Jurisdiction Code Sequence",false },
  {0x0040,0x003a,VR::SQ,VM::VM1,"Assigning Agency or Department Code Sequence",false },
  {0x0040,0x0100,VR::SQ,VM::VM1,"Scheduled Procedure Step Sequence",false },
  {0x0040,0x0220,VR::SQ,VM::VM1,"Referenced Non-Image Composite SOP Instance Sequence",false },
  {0x0040,0x0241,VR::AE,VM::VM1,"Performed Station AE Title",false },
  {0x0040,0x0242,VR::SH,VM::VM1,"Performed Station Name",false },
  {0x0040,0x0243,VR::SH,VM::VM1,"Performed Location",false },
  {0x0040,0x0244,VR::DA,VM::VM1,"Performed Procedure Step Start Date",false },
  {0x0040,0x0245,VR::TM,VM::VM1,"Performed Procedure Step Start Time",false },
  {0x0040,0x0250,VR::DA,VM::VM1,"Performed Procedure Step End Date",false },
  {0x0040,0x0251,VR::TM,VM::VM1,"Performed Procedure Step End Time",false },
  {0x0040,0x0252,VR::CS,VM::VM1,"Performed Procedure Step Status",false },
  {0x0040,0x0253,VR::SH,VM::VM1,"Performed Procedure Step ID",false },
  {0x0040,0x0254,VR::LO,VM::VM1,"Performed Procedure Step Description",false },
  {0x0040,0x0255,VR::LO,VM::VM1,"Performed Procedure Type Description",false },
  {0x0040,0x0260,VR::SQ,VM::VM1,"Performed Protocol Code Sequence",false },
  {0x0040,0x0261,VR::CS,VM::VM1,"Performed Protocol Type",false },
  {0x0040,0x0270,VR::SQ,VM::VM1,"Scheduled Step Attributes Sequence",false },
  {0x0040,0x0275,VR::SQ,VM::VM1,"Request Attributes Sequence",false },
  {0x0040,0x0280,VR::ST,VM::VM1,"Comments on the Performed Procedure Step",false },
  {0x0040,0x0281,VR::SQ,VM::VM1,"Performed Procedure Step Discontinuation Reason Code Sequence",false },
  {0x0040,0x0293,VR::SQ,VM::VM1,"Quantity Sequence",false },
  {0x0040,0x0294,VR::DS,VM::VM1,"Quantity",false },
  {0x0040,0x0295,VR::SQ,VM::VM1,"Measuring Units Sequence",false },
  {0x0040,0x0296,VR::SQ,VM::VM1,"Billing Item Sequence",false },
  {0x0040,0x0300,VR::US,VM::VM1,"Total Time of Fluoroscopy",false },
  {0x0040,0x0301,VR::US,VM::VM1,"Total Number of Exposures",false },
  {0x0040,0x0302,VR::US,VM::VM1,"Entrance Dose",false },
  {0x0040,0x0303,VR::US,VM::VM1_2,"Exposed Area",false },
  {0x0040,0x0306,VR::DS,VM::VM1,"Distance Source to Entrance",false },
  {0x0040,0x0307,VR::DS,VM::VM1,"Distance Source to Support",true },
  {0x0040,0x030e,VR::SQ,VM::VM1,"Exposure Dose Sequence",false },
  {0x0040,0x0310,VR::ST,VM::VM1,"Comments on Radiation Dose",false },
  {0x0040,0x0312,VR::DS,VM::VM1,"X-Ray Output",false },
  {0x0040,0x0314,VR::DS,VM::VM1,"Half Value Layer",false },
  {0x0040,0x0316,VR::DS,VM::VM1,"Organ Dose",false },
  {0x0040,0x0318,VR::CS,VM::VM1,"Organ Exposed",false },
  {0x0040,0x0320,VR::SQ,VM::VM1,"Billing Procedure Step Sequence",false },
  {0x0040,0x0321,VR::SQ,VM::VM1,"Film Consumption Sequence",false },
  {0x0040,0x0324,VR::SQ,VM::VM1,"Billing Supplies and Devices Sequence",false },
  {0x0040,0x0330,VR::SQ,VM::VM1,"Referenced Procedure Step Sequence",true },
  {0x0040,0x0340,VR::SQ,VM::VM1,"Performed Series Sequence",false },
  {0x0040,0x0400,VR::LT,VM::VM1,"Comments on the Scheduled Procedure Step",false },
  {0x0040,0x0440,VR::SQ,VM::VM1,"Protocol Context Sequence",false },
  {0x0040,0x0441,VR::SQ,VM::VM1,"Content Item Modifier Sequence",false },
  {0x0040,0x0500,VR::SQ,VM::VM1,"Scheduled Specimen Sequence",false },
  {0x0040,0x050a,VR::LO,VM::VM1,"Specimen Accession Number",true },
  {0x0040,0x0512,VR::LO,VM::VM1,"Container Identifier",false },
  {0x0040,0x0513,VR::SQ,VM::VM1,"Issuer of the Container Identifier Sequence",false },
  {0x0040,0x0515,VR::SQ,VM::VM1,"Alternate Container Identifier Sequence",false },
  {0x0040,0x0518,VR::SQ,VM::VM1,"Container Type Code Sequence",false },
  {0x0040,0x051a,VR::LO,VM::VM1,"Container Description",false },
  {0x0040,0x0520,VR::SQ,VM::VM1,"Container Component Sequence",false },
  {0x0040,0x0550,VR::SQ,VM::VM1,"Specimen Sequence",true },
  {0x0040,0x0551,VR::LO,VM::VM1,"Specimen Identifier",false },
  {0x0040,0x0552,VR::SQ,VM::VM1,"Specimen Description Sequence - Trial",true },
  {0x0040,0x0553,VR::ST,VM::VM1,"Specimen Description - Trial",true },
  {0x0040,0x0554,VR::UI,VM::VM1,"Specimen UID",false },
  {0x0040,0x0555,VR::SQ,VM::VM1,"Acquisition Context Sequence",false },
  {0x0040,0x0556,VR::ST,VM::VM1,"Acquisition Context Description",false },
  {0x0040,0x0560,VR::SQ,VM::VM1,"Specimen Description Sequence",false },
  {0x0040,0x0562,VR::SQ,VM::VM1,"Issuer of the Specimen Identifier Sequence",false },
  {0x0040,0x059a,VR::SQ,VM::VM1,"Specimen Type Code Sequence",false },
  {0x0040,0x0600,VR::LO,VM::VM1,"Specimen Short Description",false },
  {0x0040,0x0602,VR::UT,VM::VM1,"Specimen Detailed Description",false },
  {0x0040,0x0610,VR::SQ,VM::VM1,"Specimen Preparation Sequence",false },
  {0x0040,0x0612,VR::SQ,VM::VM1,"Specimen Preparation Step Content Item Sequence",false },
  {0x0040,0x0620,VR::SQ,VM::VM1,"Specimen Localization Content Item Sequence",false },
  {0x0040,0x06fa,VR::LO,VM::VM1,"Slide Identifier",true },
  {0x0040,0x071a,VR::SQ,VM::VM1,"Image Center Point Coordinates Sequence",false },
  {0x0040,0x072a,VR::DS,VM::VM1,"X offset in Slide Coordinate System",false },
  {0x0040,0x073a,VR::DS,VM::VM1,"Y offset in Slide Coordinate System",false },
  {0x0040,0x074a,VR::DS,VM::VM1,"Z offset in Slide Coordinate System",false },
  {0x0040,0x08d8,VR::SQ,VM::VM1,"Pixel Spacing Sequence",false },
  {0x0040,0x08da,VR::SQ,VM::VM1,"Coordinate System Axis Code Sequence",false },
  {0x0040,0x08ea,VR::SQ,VM::VM1,"Measurement Units Code Sequence",false },
  {0x0040,0x09f8,VR::SQ,VM::VM1,"Vital Stain Code Sequence - Trial",true },
  {0x0040,0x1001,VR::SH,VM::VM1,"Requested Procedure ID",false },
  {0x0040,0x1002,VR::LO,VM::VM1,"Reason for the Requested Procedure",false },
  {0x0040,0x1003,VR::SH,VM::VM1,"Requested Procedure Priority",false },
  {0x0040,0x1004,VR::LO,VM::VM1,"Patient Transport Arrangements",false },
  {0x0040,0x1005,VR::LO,VM::VM1,"Requested Procedure Location",false },
  {0x0040,0x1006,VR::SH,VM::VM1,"Placer Order Number / Procedure",true },
  {0x0040,0x1007,VR::SH,VM::VM1,"Filler Order Number / Procedure",true },
  {0x0040,0x1008,VR::LO,VM::VM1,"Confidentiality Code",false },
  {0x0040,0x1009,VR::SH,VM::VM1,"Reporting Priority",false },
  {0x0040,0x100a,VR::SQ,VM::VM1,"Reason for Requested Procedure Code Sequence",false },
  {0x0040,0x1010,VR::PN,VM::VM1_n,"Names of Intended Recipients of Results",false },
  {0x0040,0x1011,VR::SQ,VM::VM1,"Intended Recipients of Results Identification Sequence",false },
  {0x0040,0x1012,VR::SQ,VM::VM1,"Reason For Performed Procedure Code Sequence",false },
  {0x0040,0x1101,VR::SQ,VM::VM1,"Person Identification Code Sequence",false },
  {0x0040,0x1102,VR::ST,VM::VM1,"Person's Address",false },
  {0x0040,0x1103,VR::LO,VM::VM1_n,"Person's Telephone Numbers",false },
  {0x0040,0x1400,VR::LT,VM::VM1,"Requested Procedure Comments",false },
  {0x0040,0x2001,VR::LO,VM::VM1,"Reason for the Imaging Service Request",true },
  {0x0040,0x2004,VR::DA,VM::VM1,"Issue Date of Imaging Service Request",false },
  {0x0040,0x2005,VR::TM,VM::VM1,"Issue Time of Imaging Service Request",false },
  {0x0040,0x2006,VR::SH,VM::VM1,"Placer Order Number / Imaging Service Request (Retired)",true },
  {0x0040,0x2007,VR::SH,VM::VM1,"Filler Order Number / Imaging Service Request (Retired)",true },
  {0x0040,0x2008,VR::PN,VM::VM1,"Order Entered By",false },
  {0x0040,0x2009,VR::SH,VM::VM1,"Order Enterer's Location",false },
  {0x0040,0x2010,VR::SH,VM::VM1,"Order Callback Phone Number",false },
  {0x0040,0x2016,VR::LO,VM::VM1,"Placer Order Number / Imaging Service Request",false },
  {0x0040,0x2017,VR::LO,VM::VM1,"Filler Order Number / Imaging Service Request",false },
  {0x0040,0x2400,VR::LT,VM::VM1,"Imaging Service Request Comments",false },
  {0x0040,0x3001,VR::LO,VM::VM1,"Confidentiality Constraint on Patient Data Description",false },
  {0x0040,0x4001,VR::CS,VM::VM1,"General Purpose Scheduled Procedure Step Status",false },
  {0x0040,0x4002,VR::CS,VM::VM1,"General Purpose Performed Procedure Step Status",false },
  {0x0040,0x4003,VR::CS,VM::VM1,"General Purpose Scheduled Procedure Step Priority",false },
  {0x0040,0x4004,VR::SQ,VM::VM1,"Scheduled Processing Applications Code Sequence",false },
  {0x0040,0x4005,VR::DT,VM::VM1,"Scheduled Procedure Step Start DateTime",false },
  {0x0040,0x4006,VR::CS,VM::VM1,"Multiple Copies Flag",false },
  {0x0040,0x4007,VR::SQ,VM::VM1,"Performed Processing Applications Code Sequence",false },
  {0x0040,0x4009,VR::SQ,VM::VM1,"Human Performer Code Sequence",false },
  {0x0040,0x4010,VR::DT,VM::VM1,"Scheduled Procedure Step Modification Date Time",false },
  {0x0040,0x4011,VR::DT,VM::VM1,"Expected Completion Date Time",false },
  {0x0040,0x4015,VR::SQ,VM::VM1,"Resulting General Purpose Performed Procedure Steps Sequence",false },
  {0x0040,0x4016,VR::SQ,VM::VM1,"Referenced General Purpose Scheduled Procedure Step Sequence",false },
  {0x0040,0x4018,VR::SQ,VM::VM1,"Scheduled Workitem Code Sequence",false },
  {0x0040,0x4019,VR::SQ,VM::VM1,"Performed Workitem Code Sequence",false },
  {0x0040,0x4020,VR::CS,VM::VM1,"Input Availability Flag",false },
  {0x0040,0x4021,VR::SQ,VM::VM1,"Input Information Sequence",false },
  {0x0040,0x4022,VR::SQ,VM::VM1,"Relevant Information Sequence",false },
  {0x0040,0x4023,VR::UI,VM::VM1,"Referenced General Purpose Scheduled Procedure Step Transaction UID",false },
  {0x0040,0x4025,VR::SQ,VM::VM1,"Scheduled Station Name Code Sequence",false },
  {0x0040,0x4026,VR::SQ,VM::VM1,"Scheduled Station Class Code Sequence",false },
  {0x0040,0x4027,VR::SQ,VM::VM1,"Scheduled Station Geographic Location Code Sequence",false },
  {0x0040,0x4028,VR::SQ,VM::VM1,"Performed Station Name Code Sequence",false },
  {0x0040,0x4029,VR::SQ,VM::VM1,"Performed Station Class Code Sequence",false },
  {0x0040,0x4030,VR::SQ,VM::VM1,"Performed Station Geographic Location Code Sequence",false },
  {0x0040,0x4031,VR::SQ,VM::VM1,"Requested Subsequent Workitem Code Sequence",false },
  {0x0040,0x4032,VR::SQ,VM::VM1,"Non-DICOM Output Code Sequence",false },
  {0x0040,0x4033,VR::SQ,VM::VM1,"Output Information Sequence",false },
  {0x0040,0x4034,VR::SQ,VM::VM1,"Scheduled Human Performers Sequence",false },
  {0x0040,0x4035,VR::SQ,VM::VM1,"Actual Human Performers Sequence",false },
  {0x0040,0x4036,VR::LO,VM::VM1,"Human Performer's Organization",false },
  {0x0040,0x4037,VR::PN,VM::VM1,"Human Performer's Name",false },
  {0x0040,0x4040,VR::CS,VM::VM1,"Raw Data Handling",false },
  {0x0040,0x8302,VR::DS,VM::VM1,"Entrance Dose in mGy",false },
  {0x0040,0x9094,VR::SQ,VM::VM1,"Referenced Image Real World Value Mapping Sequence",false },
  {0x0040,0x9096,VR::SQ,VM::VM1,"Real World Value Mapping Sequence",false },
  {0x0040,0x9098,VR::SQ,VM::VM1,"Pixel Value Mapping Code Sequence",false },
  {0x0040,0x9210,VR::SH,VM::VM1,"LUT Label",false },
  {0x0040,0x9211,VR::US_SS,VM::VM1,"Real World Value Last Value Mapped",false },
  {0x0040,0x9212,VR::FD,VM::VM1_n,"Real World Value LUT Data",false },
  {0x0040,0x9216,VR::US_SS,VM::VM1,"Real World Value First Value Mapped",false },
  {0x0040,0x9224,VR::FD,VM::VM1,"Real World Value Intercept",false },
  {0x0040,0x9225,VR::FD,VM::VM1,"Real World Value Slope",false },
  {0x0040,0xa010,VR::CS,VM::VM1,"Relationship Type",false },
  {0x0040,0xa027,VR::LO,VM::VM1,"Verifying Organization",false },
  {0x0040,0xa030,VR::DT,VM::VM1,"Verification Date Time",false },
  {0x0040,0xa032,VR::DT,VM::VM1,"Observation Date Time",false },
  {0x0040,0xa040,VR::CS,VM::VM1,"Value Type",false },
  {0x0040,0xa043,VR::SQ,VM::VM1,"Concept Name Code Sequence",false },
  {0x0040,0xa050,VR::CS,VM::VM1,"Continuity Of Content",false },
  {0x0040,0xa073,VR::SQ,VM::VM1,"Verifying Observer Sequence",false },
  {0x0040,0xa075,VR::PN,VM::VM1,"Verifying Observer Name",false },
  {0x0040,0xa078,VR::SQ,VM::VM1,"Author Observer Sequence",false },
  {0x0040,0xa07a,VR::SQ,VM::VM1,"Participant Sequence",false },
  {0x0040,0xa07c,VR::SQ,VM::VM1,"Custodial Organization Sequence",false },
  {0x0040,0xa080,VR::CS,VM::VM1,"Participation Type",false },
  {0x0040,0xa082,VR::DT,VM::VM1,"Participation DateTime",false },
  {0x0040,0xa084,VR::CS,VM::VM1,"Observer Type",false },
  {0x0040,0xa088,VR::SQ,VM::VM1,"Verifying Observer Identification Code Sequence",false },
  {0x0040,0xa090,VR::SQ,VM::VM1,"Equivalent CDA Document Sequence",true },
  {0x0040,0xa0b0,VR::US,VM::VM2_2n,"Referenced Waveform Channels",false },
  {0x0040,0xa120,VR::DT,VM::VM1,"DateTime",false },
  {0x0040,0xa121,VR::DA,VM::VM1,"Date",false },
  {0x0040,0xa122,VR::TM,VM::VM1,"Time",false },
  {0x0040,0xa123,VR::PN,VM::VM1,"Person Name",false },
  {0x0040,0xa124,VR::UI,VM::VM1,"UID",false },
  {0x0040,0xa125,VR::CS,VM::VM2,"Report Status ID",true },
  {0x0040,0xa130,VR::CS,VM::VM1,"Temporal Range Type",false },
  {0x0040,0xa132,VR::UL,VM::VM1_n,"Referenced Sample Positions",false },
  {0x0040,0xa136,VR::US,VM::VM1_n,"Referenced Frame Numbers",false },
  {0x0040,0xa138,VR::DS,VM::VM1_n,"Referenced Time Offsets",false },
  {0x0040,0xa13a,VR::DT,VM::VM1_n,"Referenced DateTime",false },
  {0x0040,0xa160,VR::UT,VM::VM1,"Text Value",false },
  {0x0040,0xa168,VR::SQ,VM::VM1,"Concept Code Sequence",false },
  {0x0040,0xa170,VR::SQ,VM::VM1,"Purpose of Reference Code Sequence",false },
  {0x0040,0xa180,VR::US,VM::VM1,"Annotation Group Number",false },
  {0x0040,0xa195,VR::SQ,VM::VM1,"Modifier Code Sequence",false },
  {0x0040,0xa300,VR::SQ,VM::VM1,"Measured Value Sequence",false },
  {0x0040,0xa301,VR::SQ,VM::VM1,"Numeric Value Qualifier Code Sequence",false },
  {0x0040,0xa30a,VR::DS,VM::VM1_n,"Numeric Value",false },
  {0x0040,0xa353,VR::ST,VM::VM1,"Address - Trial",true },
  {0x0040,0xa354,VR::LO,VM::VM1,"Telephone Number - Trial",true },
  {0x0040,0xa360,VR::SQ,VM::VM1,"Predecessor Documents Sequence",false },
  {0x0040,0xa370,VR::SQ,VM::VM1,"Referenced Request Sequence",false },
  {0x0040,0xa372,VR::SQ,VM::VM1,"Performed Procedure Code Sequence",false },
  {0x0040,0xa375,VR::SQ,VM::VM1,"Current Requested Procedure Evidence Sequence",false },
  {0x0040,0xa385,VR::SQ,VM::VM1,"Pertinent Other Evidence Sequence",false },
  {0x0040,0xa390,VR::SQ,VM::VM1,"HL7 Structured Document Reference Sequence",false },
  {0x0040,0xa491,VR::CS,VM::VM1,"Completion Flag",false },
  {0x0040,0xa492,VR::LO,VM::VM1,"Completion Flag Description",false },
  {0x0040,0xa493,VR::CS,VM::VM1,"Verification Flag",false },
  {0x0040,0xa494,VR::CS,VM::VM1,"Archive Requested",false },
  {0x0040,0xa496,VR::CS,VM::VM1,"Preliminary Flag",false },
  {0x0040,0xa504,VR::SQ,VM::VM1,"Content Template Sequence",false },
  {0x0040,0xa525,VR::SQ,VM::VM1,"Identical Documents Sequence",false },
  {0x0040,0xa730,VR::SQ,VM::VM1,"Content Sequence",false },
  {0x0040,0xb020,VR::SQ,VM::VM1,"Waveform Annotation Sequence",false },
  {0x0040,0xdb00,VR::CS,VM::VM1,"Template Identifier",false },
  {0x0040,0xdb06,VR::DT,VM::VM1,"Template Version",true },
  {0x0040,0xdb07,VR::DT,VM::VM1,"Template Local Version",true },
  {0x0040,0xdb0b,VR::CS,VM::VM1,"Template Extension Flag",true },
  {0x0040,0xdb0c,VR::UI,VM::VM1,"Template Extension Organization UID",true },
  {0x0040,0xdb0d,VR::UI,VM::VM1,"Template Extension Creator UID",true },
  {0x0040,0xdb73,VR::UL,VM::VM1_n,"Referenced Content Item Identifier",false },
  {0x0040,0xe001,VR::ST,VM::VM1,"HL7 Instance Identifier",false },
  {0x0040,0xe004,VR::DT,VM::VM1,"HL7 Document Effective Time",false },
  {0x0040,0xe006,VR::SQ,VM::VM1,"HL7 Document Type Code Sequence",false },
  {0x0040,0xe010,VR::UT,VM::VM1,"Retrieve URI",false },
  {0x0040,0xe011,VR::UI,VM::VM1,"Retrieve Location UID",false },
  {0x0042,0x0010,VR::ST,VM::VM1,"Document Title",false },
  {0x0042,0x0011,VR::OB,VM::VM1,"Encapsulated Document",false },
  {0x0042,0x0012,VR::LO,VM::VM1,"MIME Type of Encapsulated Document",false },
  {0x0042,0x0013,VR::SQ,VM::VM1,"Source Instance Sequence",false },
  {0x0042,0x0014,VR::LO,VM::VM1_n,"List of MIME Types",false },
  {0x0044,0x0001,VR::ST,VM::VM1,"Product Package Identifier",false },
  {0x0044,0x0002,VR::CS,VM::VM1,"Substance Administration Approval",false },
  {0x0044,0x0003,VR::LT,VM::VM1,"Approval Status Further Description",false },
  {0x0044,0x0004,VR::DT,VM::VM1,"Approval Status DateTime",false },
  {0x0044,0x0007,VR::SQ,VM::VM1,"Product Type Code Sequence",false },
  {0x0044,0x0008,VR::LO,VM::VM1_n,"Product Name",false },
  {0x0044,0x0009,VR::LT,VM::VM1,"Product Description",false },
  {0x0044,0x000a,VR::LO,VM::VM1,"Product Lot Identifier",false },
  {0x0044,0x000b,VR::DT,VM::VM1,"Product Expiration DateTime",false },
  {0x0044,0x0010,VR::DT,VM::VM1,"Substance Administration DateTime",false },
  {0x0044,0x0011,VR::LO,VM::VM1,"Substance Administration Notes",false },
  {0x0044,0x0012,VR::LO,VM::VM1,"Substance Administration Device ID",false },
  {0x0044,0x0013,VR::SQ,VM::VM1,"Product Parameter Sequence",false },
  {0x0044,0x0019,VR::SQ,VM::VM1,"Substance Administration Parameter Sequence",false },
  {0x0046,0x0012,VR::LO,VM::VM1,"Lens Description",false },
  {0x0046,0x0014,VR::SQ,VM::VM1,"Right Lens Sequence",false },
  {0x0046,0x0015,VR::SQ,VM::VM1,"Left Lens Sequence",false },
  {0x0046,0x0016,VR::SQ,VM::VM1,"Unspecified Laterality Lens Sequence",false },
  {0x0046,0x0018,VR::SQ,VM::VM1,"Cylinder Sequence",false },
  {0x0046,0x0028,VR::SQ,VM::VM1,"Prism Sequence",false },
  {0x0046,0x0030,VR::FD,VM::VM1,"Horizontal Prism Power",false },
  {0x0046,0x0032,VR::CS,VM::VM1,"Horizontal Prism Base",false },
  {0x0046,0x0034,VR::FD,VM::VM1,"Vertical Prism Power",false },
  {0x0046,0x0036,VR::CS,VM::VM1,"Vertical Prism Base",false },
  {0x0046,0x0038,VR::CS,VM::VM1,"Lens Segment Type",false },
  {0x0046,0x0040,VR::FD,VM::VM1,"Optical Transmittance",false },
  {0x0046,0x0042,VR::FD,VM::VM1,"Channel Width",false },
  {0x0046,0x0044,VR::FD,VM::VM1,"Pupil Size",false },
  {0x0046,0x0046,VR::FD,VM::VM1,"Corneal Size",false },
  {0x0046,0x0050,VR::SQ,VM::VM1,"Autorefraction Right Eye Sequence",false },
  {0x0046,0x0052,VR::SQ,VM::VM1,"Autorefraction Left Eye Sequence",false },
  {0x0046,0x0060,VR::FD,VM::VM1,"Distance Pupillary Distance",false },
  {0x0046,0x0062,VR::FD,VM::VM1,"Near Pupillary Distance",false },
  {0x0046,0x0063,VR::FD,VM::VM1,"Intermediate Pupillary Distance",false },
  {0x0046,0x0064,VR::FD,VM::VM1,"Other Pupillary Distance",false },
  {0x0046,0x0070,VR::SQ,VM::VM1,"Keratometry Right Eye Sequence",false },
  {0x0046,0x0071,VR::SQ,VM::VM1,"Keratometry Left Eye Sequence",false },
  {0x0046,0x0074,VR::SQ,VM::VM1,"Steep Keratometric Axis Sequence",false },
  {0x0046,0x0075,VR::FD,VM::VM1,"Radius of Curvature",false },
  {0x0046,0x0076,VR::FD,VM::VM1,"Keratometric Power",false },
  {0x0046,0x0077,VR::FD,VM::VM1,"Keratometric Axis",false },
  {0x0046,0x0080,VR::SQ,VM::VM1,"Flat Keratometric Axis Sequence",false },
  {0x0046,0x0092,VR::CS,VM::VM1,"Background Color",false },
  {0x0046,0x0094,VR::CS,VM::VM1,"Optotype",false },
  {0x0046,0x0095,VR::CS,VM::VM1,"Optotype Presentation",false },
  {0x0046,0x0097,VR::SQ,VM::VM1,"Subjective Refraction Right Eye Sequence",false },
  {0x0046,0x0098,VR::SQ,VM::VM1,"Subjective Refraction Left Eye Sequence",false },
  {0x0046,0x0100,VR::SQ,VM::VM1,"Add Near Sequence",false },
  {0x0046,0x0101,VR::SQ,VM::VM1,"Add Intermediate Sequence",false },
  {0x0046,0x0102,VR::SQ,VM::VM1,"Add Other Sequence",false },
  {0x0046,0x0104,VR::FD,VM::VM1,"Add Power",false },
  {0x0046,0x0106,VR::FD,VM::VM1,"Viewing Distance",false },
  {0x0046,0x0121,VR::SQ,VM::VM1,"Visual Acuity Type Code Sequence",false },
  {0x0046,0x0122,VR::SQ,VM::VM1,"Visual Acuity Right Eye Sequence",false },
  {0x0046,0x0123,VR::SQ,VM::VM1,"Visual Acuity Left Eye Sequence",false },
  {0x0046,0x0124,VR::SQ,VM::VM1,"Visual Acuity Both Eyes Open Sequence",false },
  {0x0046,0x0125,VR::CS,VM::VM1,"Viewing Distance Type",false },
  {0x0046,0x0135,VR::SS,VM::VM2,"Visual Acuity Modifiers",false },
  {0x0046,0x0137,VR::FD,VM::VM1,"Decimal Visual Acuity",false },
  {0x0046,0x0139,VR::LO,VM::VM1,"Optotype Detailed Definition",false },
  {0x0046,0x0145,VR::SQ,VM::VM1,"Referenced Refractive Measurements Sequence",false },
  {0x0046,0x0146,VR::FD,VM::VM1,"Sphere Power",false },
  {0x0046,0x0147,VR::FD,VM::VM1,"Cylinder Power",false },
  {0x0050,0x0004,VR::CS,VM::VM1,"Calibration Image",false },
  {0x0050,0x0010,VR::SQ,VM::VM1,"Device Sequence",false },
  {0x0050,0x0012,VR::SQ,VM::VM1,"Container Component Type Code Sequence",false },
  {0x0050,0x0013,VR::FD,VM::VM1,"Container Component Thickness",false },
  {0x0050,0x0014,VR::DS,VM::VM1,"Device Length",false },
  {0x0050,0x0015,VR::FD,VM::VM1,"Container Component Width",false },
  {0x0050,0x0016,VR::DS,VM::VM1,"Device Diameter",false },
  {0x0050,0x0017,VR::CS,VM::VM1,"Device Diameter Units",false },
  {0x0050,0x0018,VR::DS,VM::VM1,"Device Volume",false },
  {0x0050,0x0019,VR::DS,VM::VM1,"Inter-Marker Distance",false },
  {0x0050,0x001a,VR::CS,VM::VM1,"Container Component Material",false },
  {0x0050,0x001b,VR::LO,VM::VM1,"Container Component ID",false },
  {0x0050,0x001c,VR::FD,VM::VM1,"Container Component Length",false },
  {0x0050,0x001d,VR::FD,VM::VM1,"Container Component Diameter",false },
  {0x0050,0x001e,VR::LO,VM::VM1,"Container Component Description",false },
  {0x0050,0x0020,VR::LO,VM::VM1,"Device Description",false },
  {0x0054,0x0010,VR::US,VM::VM1_n,"Energy Window Vector",false },
  {0x0054,0x0011,VR::US,VM::VM1,"Number of Energy Windows",false },
  {0x0054,0x0012,VR::SQ,VM::VM1,"Energy Window Information Sequence",false },
  {0x0054,0x0013,VR::SQ,VM::VM1,"Energy Window Range Sequence",false },
  {0x0054,0x0014,VR::DS,VM::VM1,"Energy Window Lower Limit",false },
  {0x0054,0x0015,VR::DS,VM::VM1,"Energy Window Upper Limit",false },
  {0x0054,0x0016,VR::SQ,VM::VM1,"Radiopharmaceutical Information Sequence",false },
  {0x0054,0x0017,VR::IS,VM::VM1,"Residual Syringe Counts",false },
  {0x0054,0x0018,VR::SH,VM::VM1,"Energy Window Name",false },
  {0x0054,0x0020,VR::US,VM::VM1_n,"Detector Vector",false },
  {0x0054,0x0021,VR::US,VM::VM1,"Number of Detectors",false },
  {0x0054,0x0022,VR::SQ,VM::VM1,"Detector Information Sequence",false },
  {0x0054,0x0030,VR::US,VM::VM1_n,"Phase Vector",false },
  {0x0054,0x0031,VR::US,VM::VM1,"Number of Phases",false },
  {0x0054,0x0032,VR::SQ,VM::VM1,"Phase Information Sequence",false },
  {0x0054,0x0033,VR::US,VM::VM1,"Number of Frames in Phase",false },
  {0x0054,0x0036,VR::IS,VM::VM1,"Phase Delay",false },
  {0x0054,0x0038,VR::IS,VM::VM1,"Pause Between Frames",false },
  {0x0054,0x0039,VR::CS,VM::VM1,"Phase Description",false },
  {0x0054,0x0050,VR::US,VM::VM1_n,"Rotation Vector",false },
  {0x0054,0x0051,VR::US,VM::VM1,"Number of Rotations",false },
  {0x0054,0x0052,VR::SQ,VM::VM1,"Rotation Information Sequence",false },
  {0x0054,0x0053,VR::US,VM::VM1,"Number of Frames in Rotation",false },
  {0x0054,0x0060,VR::US,VM::VM1_n,"R-R Interval Vector",false },
  {0x0054,0x0061,VR::US,VM::VM1,"Number of R-R Intervals",false },
  {0x0054,0x0062,VR::SQ,VM::VM1,"Gated Information Sequence",false },
  {0x0054,0x0063,VR::SQ,VM::VM1,"Data Information Sequence",false },
  {0x0054,0x0070,VR::US,VM::VM1_n,"Time Slot Vector",false },
  {0x0054,0x0071,VR::US,VM::VM1,"Number of Time Slots",false },
  {0x0054,0x0072,VR::SQ,VM::VM1,"Time Slot Information Sequence",false },
  {0x0054,0x0073,VR::DS,VM::VM1,"Time Slot Time",false },
  {0x0054,0x0080,VR::US,VM::VM1_n,"Slice Vector",false },
  {0x0054,0x0081,VR::US,VM::VM1,"Number of Slices",false },
  {0x0054,0x0090,VR::US,VM::VM1_n,"Angular View Vector",false },
  {0x0054,0x0100,VR::US,VM::VM1_n,"Time Slice Vector",false },
  {0x0054,0x0101,VR::US,VM::VM1,"Number of Time Slices",false },
  {0x0054,0x0200,VR::DS,VM::VM1,"Start Angle",false },
  {0x0054,0x0202,VR::CS,VM::VM1,"Type of Detector Motion",false },
  {0x0054,0x0210,VR::IS,VM::VM1_n,"Trigger Vector",false },
  {0x0054,0x0211,VR::US,VM::VM1,"Number of Triggers in Phase",false },
  {0x0054,0x0220,VR::SQ,VM::VM1,"View Code Sequence",false },
  {0x0054,0x0222,VR::SQ,VM::VM1,"View Modifier Code Sequence",false },
  {0x0054,0x0300,VR::SQ,VM::VM1,"Radionuclide Code Sequence",false },
  {0x0054,0x0302,VR::SQ,VM::VM1,"Administration Route Code Sequence",false },
  {0x0054,0x0304,VR::SQ,VM::VM1,"Radiopharmaceutical Code Sequence",false },
  {0x0054,0x0306,VR::SQ,VM::VM1,"Calibration Data Sequence",false },
  {0x0054,0x0308,VR::US,VM::VM1,"Energy Window Number",false },
  {0x0054,0x0400,VR::SH,VM::VM1,"Image ID",false },
  {0x0054,0x0410,VR::SQ,VM::VM1,"Patient Orientation Code Sequence",false },
  {0x0054,0x0412,VR::SQ,VM::VM1,"Patient Orientation Modifier Code Sequence",false },
  {0x0054,0x0414,VR::SQ,VM::VM1,"Patient Gantry Relationship Code Sequence",false },
  {0x0054,0x0500,VR::CS,VM::VM1,"Slice Progression Direction",false },
  {0x0054,0x1000,VR::CS,VM::VM2,"Series Type",false },
  {0x0054,0x1001,VR::CS,VM::VM1,"Units",false },
  {0x0054,0x1002,VR::CS,VM::VM1,"Counts Source",false },
  {0x0054,0x1004,VR::CS,VM::VM1,"Reprojection Method",false },
  {0x0054,0x1100,VR::CS,VM::VM1,"Randoms Correction Method",false },
  {0x0054,0x1101,VR::LO,VM::VM1,"Attenuation Correction Method",false },
  {0x0054,0x1102,VR::CS,VM::VM1,"Decay Correction",false },
  {0x0054,0x1103,VR::LO,VM::VM1,"Reconstruction Method",false },
  {0x0054,0x1104,VR::LO,VM::VM1,"Detector Lines of Response Used",false },
  {0x0054,0x1105,VR::LO,VM::VM1,"Scatter Correction Method",false },
  {0x0054,0x1200,VR::DS,VM::VM1,"Axial Acceptance",false },
  {0x0054,0x1201,VR::IS,VM::VM2,"Axial Mash",false },
  {0x0054,0x1202,VR::IS,VM::VM1,"Transverse Mash",false },
  {0x0054,0x1203,VR::DS,VM::VM2,"Detector Element Size",false },
  {0x0054,0x1210,VR::DS,VM::VM1,"Coincidence Window Width",false },
  {0x0054,0x1220,VR::CS,VM::VM1_n,"Secondary Counts Type",false },
  {0x0054,0x1300,VR::DS,VM::VM1,"Frame Reference Time",false },
  {0x0054,0x1310,VR::IS,VM::VM1,"Primary (Prompts) Counts Accumulated",false },
  {0x0054,0x1311,VR::IS,VM::VM1_n,"Secondary Counts Accumulated",false },
  {0x0054,0x1320,VR::DS,VM::VM1,"Slice Sensitivity Factor",false },
  {0x0054,0x1321,VR::DS,VM::VM1,"Decay Factor",false },
  {0x0054,0x1322,VR::DS,VM::VM1,"Dose Calibration Factor",false },
  {0x0054,0x1323,VR::DS,VM::VM1,"Scatter Fraction Factor",false },
  {0x0054,0x1324,VR::DS,VM::VM1,"Dead Time Factor",false },
  {0x0054,0x1330,VR::US,VM::VM1,"Image Index",false },
  {0x0054,0x1400,VR::CS,VM::VM1_n,"Counts Included",true },
  {0x0054,0x1401,VR::CS,VM::VM1,"Dead Time Correction Flag",true },
  {0x0060,0x3000,VR::SQ,VM::VM1,"Histogram Sequence",false },
  {0x0060,0x3002,VR::US,VM::VM1,"Histogram Number of Bins",false },
  {0x0060,0x3004,VR::US_SS,VM::VM1,"Histogram First Bin Value",false },
  {0x0060,0x3006,VR::US_SS,VM::VM1,"Histogram Last Bin Value",false },
  {0x0060,0x3008,VR::US,VM::VM1,"Histogram Bin Width",false },
  {0x0060,0x3010,VR::LO,VM::VM1,"Histogram Explanation",false },
  {0x0060,0x3020,VR::UL,VM::VM1_n,"Histogram Data",false },
  {0x0062,0x0001,VR::CS,VM::VM1,"Segmentation Type",false },
  {0x0062,0x0002,VR::SQ,VM::VM1,"Segment Sequence",false },
  {0x0062,0x0003,VR::SQ,VM::VM1,"Segmented Property Category Code Sequence",false },
  {0x0062,0x0004,VR::US,VM::VM1,"Segment Number",false },
  {0x0062,0x0005,VR::LO,VM::VM1,"Segment Label",false },
  {0x0062,0x0006,VR::ST,VM::VM1,"Segment Description",false },
  {0x0062,0x0008,VR::CS,VM::VM1,"Segment Algorithm Type",false },
  {0x0062,0x0009,VR::LO,VM::VM1,"Segment Algorithm Name",false },
  {0x0062,0x000a,VR::SQ,VM::VM1,"Segment Identification Sequence",false },
  {0x0062,0x000b,VR::US,VM::VM1_n,"Referenced Segment Number",false },
  {0x0062,0x000c,VR::US,VM::VM1,"Recommended Display Grayscale Value",false },
  {0x0062,0x000d,VR::US,VM::VM3,"Recommended Display CIELab Value",false },
  {0x0062,0x000e,VR::US,VM::VM1,"Maximum Fractional Value",false },
  {0x0062,0x000f,VR::SQ,VM::VM1,"Segmented Property Type Code Sequence",false },
  {0x0062,0x0010,VR::CS,VM::VM1,"Segmentation Fractional Type",false },
  {0x0064,0x0002,VR::SQ,VM::VM1,"Deformable Registration Sequence",false },
  {0x0064,0x0003,VR::UI,VM::VM1,"Source Frame of Reference UID",false },
  {0x0064,0x0005,VR::SQ,VM::VM1,"Deformable Registration Grid Sequence",false },
  {0x0064,0x0007,VR::UL,VM::VM3,"Grid Dimensions",false },
  {0x0064,0x0008,VR::FD,VM::VM3,"Grid Resolution",false },
  {0x0064,0x0009,VR::OF,VM::VM1,"Vector Grid Data",false },
  {0x0064,0x000f,VR::SQ,VM::VM1,"Pre Deformation Matrix Registration Sequence",false },
  {0x0064,0x0010,VR::SQ,VM::VM1,"Post Deformation Matrix Registration Sequence",false },
  {0x0066,0x0001,VR::UL,VM::VM1,"Number of Surfaces",false },
  {0x0066,0x0002,VR::SQ,VM::VM1,"Surface Sequence",false },
  {0x0066,0x0003,VR::UL,VM::VM1,"Surface Number",false },
  {0x0066,0x0004,VR::LT,VM::VM1,"Surface Comments",false },
  {0x0066,0x0009,VR::CS,VM::VM1,"Surface Processing",false },
  {0x0066,0x000a,VR::FL,VM::VM1,"Surface Processing Ratio",false },
  {0x0066,0x000b,VR::LO,VM::VM1,"Surface Processing Description",false },
  {0x0066,0x000c,VR::FL,VM::VM1,"Recommended Presentation Opacity",false },
  {0x0066,0x000d,VR::CS,VM::VM1,"Recommended Presentation Type",false },
  {0x0066,0x000e,VR::CS,VM::VM1,"Finite Volume",false },
  {0x0066,0x0010,VR::CS,VM::VM1,"Manifold",false },
  {0x0066,0x0011,VR::SQ,VM::VM1,"Surface Points Sequence",false },
  {0x0066,0x0012,VR::SQ,VM::VM1,"Surface Points Normals Sequence",false },
  {0x0066,0x0013,VR::SQ,VM::VM1,"Surface Mesh Primitives Sequence",false },
  {0x0066,0x0015,VR::UL,VM::VM1,"Number of Surface Points",false },
  {0x0066,0x0016,VR::OF,VM::VM1,"Point Coordinates Data",false },
  {0x0066,0x0017,VR::FL,VM::VM3,"Point Position Accuracy",false },
  {0x0066,0x0018,VR::FL,VM::VM1,"Mean Point Distance",false },
  {0x0066,0x0019,VR::FL,VM::VM1,"Maximum Point Distance",false },
  {0x0066,0x001a,VR::FL,VM::VM6,"Points Bounding Box Coordinates",false },
  {0x0066,0x001b,VR::FL,VM::VM3,"Axis of Rotation",false },
  {0x0066,0x001c,VR::FL,VM::VM3,"Center of Rotation",false },
  {0x0066,0x001e,VR::UL,VM::VM1,"Number of Vectors",false },
  {0x0066,0x001f,VR::US,VM::VM1,"Vector Dimensionality",false },
  {0x0066,0x0020,VR::FL,VM::VM1_n,"Vector Accuracy",false },
  {0x0066,0x0021,VR::OF,VM::VM1,"Vector Coordinate Data",false },
  {0x0066,0x0023,VR::OW,VM::VM1,"Triangle Point Index List",false },
  {0x0066,0x0024,VR::OW,VM::VM1,"Edge Point Index List",false },
  {0x0066,0x0025,VR::OW,VM::VM1,"Vertex Point Index List",false },
  {0x0066,0x0026,VR::SQ,VM::VM1,"Triangle Strip Sequence",false },
  {0x0066,0x0027,VR::SQ,VM::VM1,"Triangle Fan Sequence",false },
  {0x0066,0x0028,VR::SQ,VM::VM1,"Line Sequence",false },
  {0x0066,0x0029,VR::OW,VM::VM1,"Primitive Point Index List",false },
  {0x0066,0x002a,VR::UL,VM::VM1,"Surface Count",false },
  {0x0066,0x002b,VR::SQ,VM::VM1,"Referenced Surface Sequence",false },
  {0x0066,0x002c,VR::UL,VM::VM1,"Referenced Surface Number",false },
  {0x0066,0x002d,VR::SQ,VM::VM1,"Segment Surface Generation Algorithm Identification Sequence",false },
  {0x0066,0x002e,VR::SQ,VM::VM1,"Segment Surface Source Instance Sequence",false },
  {0x0066,0x002f,VR::SQ,VM::VM1,"Algorithm Family Code Sequence",false },
  {0x0066,0x0030,VR::SQ,VM::VM1,"Algorithm Name Code Sequence",false },
  {0x0066,0x0031,VR::LO,VM::VM1,"Algorithm Version",false },
  {0x0066,0x0032,VR::LT,VM::VM1,"Algorithm Parameters",false },
  {0x0066,0x0034,VR::SQ,VM::VM1,"Facet Sequence",false },
  {0x0066,0x0035,VR::SQ,VM::VM1,"Surface Processing Algorithm Identification Sequence",false },
  {0x0066,0x0036,VR::LO,VM::VM1,"Algorithm Name",false },
  {0x0070,0x0001,VR::SQ,VM::VM1,"Graphic Annotation Sequence",false },
  {0x0070,0x0002,VR::CS,VM::VM1,"Graphic Layer",false },
  {0x0070,0x0003,VR::CS,VM::VM1,"Bounding Box Annotation Units",false },
  {0x0070,0x0004,VR::CS,VM::VM1,"Anchor Point Annotation Units",false },
  {0x0070,0x0005,VR::CS,VM::VM1,"Graphic Annotation Units",false },
  {0x0070,0x0006,VR::ST,VM::VM1,"Unformatted Text Value",false },
  {0x0070,0x0008,VR::SQ,VM::VM1,"Text Object Sequence",false },
  {0x0070,0x0009,VR::SQ,VM::VM1,"Graphic Object Sequence",false },
  {0x0070,0x0010,VR::FL,VM::VM2,"Bounding Box Top Left Hand Corner",false },
  {0x0070,0x0011,VR::FL,VM::VM2,"Bounding Box Bottom Right Hand Corner",false },
  {0x0070,0x0012,VR::CS,VM::VM1,"Bounding Box Text Horizontal Justification",false },
  {0x0070,0x0014,VR::FL,VM::VM2,"Anchor Point",false },
  {0x0070,0x0015,VR::CS,VM::VM1,"Anchor Point Visibility",false },
  {0x0070,0x0020,VR::US,VM::VM1,"Graphic Dimensions",false },
  {0x0070,0x0021,VR::US,VM::VM1,"Number of Graphic Points",false },
  {0x0070,0x0022,VR::FL,VM::VM2_n,"Graphic Data",false },
  {0x0070,0x0023,VR::CS,VM::VM1,"Graphic Type",false },
  {0x0070,0x0024,VR::CS,VM::VM1,"Graphic Filled",false },
  {0x0070,0x0040,VR::IS,VM::VM1,"Image Rotation (Retired)",true },
  {0x0070,0x0041,VR::CS,VM::VM1,"Image Horizontal Flip",false },
  {0x0070,0x0042,VR::US,VM::VM1,"Image Rotation",false },
  {0x0070,0x0050,VR::US,VM::VM2,"Displayed Area Top Left Hand Corner (Trial)",true },
  {0x0070,0x0051,VR::US,VM::VM2,"Displayed Area Bottom Right Hand Corner (Trial)",true },
  {0x0070,0x0052,VR::SL,VM::VM2,"Displayed Area Top Left Hand Corner",false },
  {0x0070,0x0053,VR::SL,VM::VM2,"Displayed Area Bottom Right Hand Corner",false },
  {0x0070,0x005a,VR::SQ,VM::VM1,"Displayed Area Selection Sequence",false },
  {0x0070,0x0060,VR::SQ,VM::VM1,"Graphic Layer Sequence",false },
  {0x0070,0x0062,VR::IS,VM::VM1,"Graphic Layer Order",false },
  {0x0070,0x0066,VR::US,VM::VM1,"Graphic Layer Recommended Display Grayscale Value",false },
  {0x0070,0x0067,VR::US,VM::VM3,"Graphic Layer Recommended Display RGB Value",true },
  {0x0070,0x0068,VR::LO,VM::VM1,"Graphic Layer Description",false },
  {0x0070,0x0080,VR::CS,VM::VM1,"Content Label",false },
  {0x0070,0x0081,VR::LO,VM::VM1,"Content Description",false },
  {0x0070,0x0082,VR::DA,VM::VM1,"Presentation Creation Date",false },
  {0x0070,0x0083,VR::TM,VM::VM1,"Presentation Creation Time",false },
  {0x0070,0x0084,VR::PN,VM::VM1,"Content Creator's Name",false },
  {0x0070,0x0086,VR::SQ,VM::VM1,"Content Creator's Identification Code Sequence",false },
  {0x0070,0x0087,VR::SQ,VM::VM1,"Alternate Content Description Sequence",false },
  {0x0070,0x0100,VR::CS,VM::VM1,"Presentation Size Mode",false },
  {0x0070,0x0101,VR::DS,VM::VM2,"Presentation Pixel Spacing",false },
  {0x0070,0x0102,VR::IS,VM::VM2,"Presentation Pixel Aspect Ratio",false },
  {0x0070,0x0103,VR::FL,VM::VM1,"Presentation Pixel Magnification Ratio",false },
  {0x0070,0x0306,VR::CS,VM::VM1,"Shape Type",false },
  {0x0070,0x0308,VR::SQ,VM::VM1,"Registration Sequence",false },
  {0x0070,0x0309,VR::SQ,VM::VM1,"Matrix Registration Sequence",false },
  {0x0070,0x030a,VR::SQ,VM::VM1,"Matrix Sequence",false },
  {0x0070,0x030c,VR::CS,VM::VM1,"Frame of Reference Transformation Matrix Type",false },
  {0x0070,0x030d,VR::SQ,VM::VM1,"Registration Type Code Sequence",false },
  {0x0070,0x030f,VR::ST,VM::VM1,"Fiducial Description",false },
  {0x0070,0x0310,VR::SH,VM::VM1,"Fiducial Identifier",false },
  {0x0070,0x0311,VR::SQ,VM::VM1,"Fiducial Identifier Code Sequence",false },
  {0x0070,0x0312,VR::FD,VM::VM1,"Contour Uncertainty Radius",false },
  {0x0070,0x0314,VR::SQ,VM::VM1,"Used Fiducials Sequence",false },
  {0x0070,0x0318,VR::SQ,VM::VM1,"Graphic Coordinates Data Sequence",false },
  {0x0070,0x031a,VR::UI,VM::VM1,"Fiducial UID",false },
  {0x0070,0x031c,VR::SQ,VM::VM1,"Fiducial Set Sequence",false },
  {0x0070,0x031e,VR::SQ,VM::VM1,"Fiducial Sequence",false },
  {0x0070,0x0401,VR::US,VM::VM3,"Graphic Layer Recommended Display CIELab Value",false },
  {0x0070,0x0402,VR::SQ,VM::VM1,"Blending Sequence",false },
  {0x0070,0x0403,VR::FL,VM::VM1,"Relative Opacity",false },
  {0x0070,0x0404,VR::SQ,VM::VM1,"Referenced Spatial Registration Sequence",false },
  {0x0070,0x0405,VR::CS,VM::VM1,"Blending Position",false },
  {0x0072,0x0002,VR::SH,VM::VM1,"Hanging Protocol Name",false },
  {0x0072,0x0004,VR::LO,VM::VM1,"Hanging Protocol Description",false },
  {0x0072,0x0006,VR::CS,VM::VM1,"Hanging Protocol Level",false },
  {0x0072,0x0008,VR::LO,VM::VM1,"Hanging Protocol Creator",false },
  {0x0072,0x000a,VR::DT,VM::VM1,"Hanging Protocol Creation DateTime",false },
  {0x0072,0x000c,VR::SQ,VM::VM1,"Hanging Protocol Definition Sequence",false },
  {0x0072,0x000e,VR::SQ,VM::VM1,"Hanging Protocol User Identification Code Sequence",false },
  {0x0072,0x0010,VR::LO,VM::VM1,"Hanging Protocol User Group Name",false },
  {0x0072,0x0012,VR::SQ,VM::VM1,"Source Hanging Protocol Sequence",false },
  {0x0072,0x0014,VR::US,VM::VM1,"Number of Priors Referenced",false },
  {0x0072,0x0020,VR::SQ,VM::VM1,"Image Sets Sequence",false },
  {0x0072,0x0022,VR::SQ,VM::VM1,"Image Set Selector Sequence",false },
  {0x0072,0x0024,VR::CS,VM::VM1,"Image Set Selector Usage Flag",false },
  {0x0072,0x0026,VR::AT,VM::VM1,"Selector Attribute",false },
  {0x0072,0x0028,VR::US,VM::VM1,"Selector Value Number",false },
  {0x0072,0x0030,VR::SQ,VM::VM1,"Time Based Image Sets Sequence",false },
  {0x0072,0x0032,VR::US,VM::VM1,"Image Set Number",false },
  {0x0072,0x0034,VR::CS,VM::VM1,"Image Set Selector Category",false },
  {0x0072,0x0038,VR::US,VM::VM2,"Relative Time",false },
  {0x0072,0x003a,VR::CS,VM::VM1,"Relative Time Units",false },
  {0x0072,0x003c,VR::SS,VM::VM2,"Abstract Prior Value",false },
  {0x0072,0x003e,VR::SQ,VM::VM1,"Abstract Prior Code Sequence",false },
  {0x0072,0x0040,VR::LO,VM::VM1,"Image Set Label",false },
  {0x0072,0x0050,VR::CS,VM::VM1,"Selector Attribute VR",false },
  {0x0072,0x0052,VR::AT,VM::VM1,"Selector Sequence Pointer",false },
  {0x0072,0x0054,VR::LO,VM::VM1,"Selector Sequence Pointer Private Creator",false },
  {0x0072,0x0056,VR::LO,VM::VM1,"Selector Attribute Private Creator",false },
  {0x0072,0x0060,VR::AT,VM::VM1_n,"Selector AT Value",false },
  {0x0072,0x0062,VR::CS,VM::VM1_n,"Selector CS Value",false },
  {0x0072,0x0064,VR::IS,VM::VM1_n,"Selector IS Value",false },
  {0x0072,0x0066,VR::LO,VM::VM1_n,"Selector LO Value",false },
  {0x0072,0x0068,VR::LT,VM::VM1,"Selector LT Value",false },
  {0x0072,0x006a,VR::PN,VM::VM1_n,"Selector PN Value",false },
  {0x0072,0x006c,VR::SH,VM::VM1_n,"Selector SH Value",false },
  {0x0072,0x006e,VR::ST,VM::VM1,"Selector ST Value",false },
  {0x0072,0x0070,VR::UT,VM::VM1,"Selector UT Value",false },
  {0x0072,0x0072,VR::DS,VM::VM1_n,"Selector DS Value",false },
  {0x0072,0x0074,VR::FD,VM::VM1_n,"Selector FD Value",false },
  {0x0072,0x0076,VR::FL,VM::VM1_n,"Selector FL Value",false },
  {0x0072,0x0078,VR::UL,VM::VM1_n,"Selector UL Value",false },
  {0x0072,0x007a,VR::US,VM::VM1_n,"Selector US Value",false },
  {0x0072,0x007c,VR::SL,VM::VM1_n,"Selector SL Value",false },
  {0x0072,0x007e,VR::SS,VM::VM1_n,"Selector SS Value",false },
  {0x0072,0x0080,VR::SQ,VM::VM1,"Selector Code Sequence Value",false },
  {0x0072,0x0100,VR::US,VM::VM1,"Number of Screens",false },
  {0x0072,0x0102,VR::SQ,VM::VM1,"Nominal Screen Definition Sequence",false },
  {0x0072,0x0104,VR::US,VM::VM1,"Number of Vertical Pixels",false },
  {0x0072,0x0106,VR::US,VM::VM1,"Number of Horizontal Pixels",false },
  {0x0072,0x0108,VR::FD,VM::VM4,"Display Environment Spatial Position",false },
  {0x0072,0x010a,VR::US,VM::VM1,"Screen Minimum Grayscale Bit Depth",false },
  {0x0072,0x010c,VR::US,VM::VM1,"Screen Minimum Color Bit Depth",false },
  {0x0072,0x010e,VR::US,VM::VM1,"Application Maximum Repaint Time",false },
  {0x0072,0x0200,VR::SQ,VM::VM1,"Display Sets Sequence",false },
  {0x0072,0x0202,VR::US,VM::VM1,"Display Set Number",false },
  {0x0072,0x0203,VR::LO,VM::VM1,"Display Set Label",false },
  {0x0072,0x0204,VR::US,VM::VM1,"Display Set Presentation Group",false },
  {0x0072,0x0206,VR::LO,VM::VM1,"Display Set Presentation Group Description",false },
  {0x0072,0x0208,VR::CS,VM::VM1,"Partial Data Display Handling",false },
  {0x0072,0x0210,VR::SQ,VM::VM1,"Synchronized Scrolling Sequence",false },
  {0x0072,0x0212,VR::US,VM::VM2_n,"Display Set Scrolling Group",false },
  {0x0072,0x0214,VR::SQ,VM::VM1,"Navigation Indicator Sequence",false },
  {0x0072,0x0216,VR::US,VM::VM1,"Navigation Display Set",false },
  {0x0072,0x0218,VR::US,VM::VM1_n,"Reference Display Sets",false },
  {0x0072,0x0300,VR::SQ,VM::VM1,"Image Boxes Sequence",false },
  {0x0072,0x0302,VR::US,VM::VM1,"Image Box Number",false },
  {0x0072,0x0304,VR::CS,VM::VM1,"Image Box Layout Type",false },
  {0x0072,0x0306,VR::US,VM::VM1,"Image Box Tile Horizontal Dimension",false },
  {0x0072,0x0308,VR::US,VM::VM1,"Image Box Tile Vertical Dimension",false },
  {0x0072,0x0310,VR::CS,VM::VM1,"Image Box Scroll Direction",false },
  {0x0072,0x0312,VR::CS,VM::VM1,"Image Box Small Scroll Type",false },
  {0x0072,0x0314,VR::US,VM::VM1,"Image Box Small Scroll Amount",false },
  {0x0072,0x0316,VR::CS,VM::VM1,"Image Box Large Scroll Type",false },
  {0x0072,0x0318,VR::US,VM::VM1,"Image Box Large Scroll Amount",false },
  {0x0072,0x0320,VR::US,VM::VM1,"Image Box Overlap Priority",false },
  {0x0072,0x0330,VR::FD,VM::VM1,"Cine Relative to Real-Time",false },
  {0x0072,0x0400,VR::SQ,VM::VM1,"Filter Operations Sequence",false },
  {0x0072,0x0402,VR::CS,VM::VM1,"Filter-by Category",false },
  {0x0072,0x0404,VR::CS,VM::VM1,"Filter-by Attribute Presence",false },
  {0x0072,0x0406,VR::CS,VM::VM1,"Filter-by Operator",false },
  {0x0072,0x0420,VR::US,VM::VM3,"Structured Display Background CIELab Value",false },
  {0x0072,0x0421,VR::US,VM::VM3,"Empty Image Box CIELab Value",false },
  {0x0072,0x0422,VR::SQ,VM::VM1,"Structured Display Image Box Sequence",false },
  {0x0072,0x0424,VR::SQ,VM::VM1,"Structured Display Text Box Sequence",false },
  {0x0072,0x0427,VR::SQ,VM::VM1,"Referenced First Frame Sequence",false },
  {0x0072,0x0430,VR::SQ,VM::VM1,"Image Box Synchronization Sequence",false },
  {0x0072,0x0432,VR::US,VM::VM2_n,"Synchronized Image Box List",false },
  {0x0072,0x0434,VR::CS,VM::VM1,"Type of Synchronization",false },
  {0x0072,0x0500,VR::CS,VM::VM1,"Blending Operation Type",false },
  {0x0072,0x0510,VR::CS,VM::VM1,"Reformatting Operation Type",false },
  {0x0072,0x0512,VR::FD,VM::VM1,"Reformatting Thickness",false },
  {0x0072,0x0514,VR::FD,VM::VM1,"Reformatting Interval",false },
  {0x0072,0x0516,VR::CS,VM::VM1,"Reformatting Operation Initial View Direction",false },
  {0x0072,0x0520,VR::CS,VM::VM1_n,"3D Rendering Type",false },
  {0x0072,0x0600,VR::SQ,VM::VM1,"Sorting Operations Sequence",false },
  {0x0072,0x0602,VR::CS,VM::VM1,"Sort-by Category",false },
  {0x0072,0x0604,VR::CS,VM::VM1,"Sorting Direction",false },
  {0x0072,0x0700,VR::CS,VM::VM2,"Display Set Patient Orientation",false },
  {0x0072,0x0702,VR::CS,VM::VM1,"VOI Type",false },
  {0x0072,0x0704,VR::CS,VM::VM1,"Pseudo-Color Type",false },
  {0x0072,0x0706,VR::CS,VM::VM1,"Show Grayscale Inverted",false },
  {0x0072,0x0710,VR::CS,VM::VM1,"Show Image True Size Flag",false },
  {0x0072,0x0712,VR::CS,VM::VM1,"Show Graphic Annotation Flag",false },
  {0x0072,0x0714,VR::CS,VM::VM1,"Show Patient Demographics Flag",false },
  {0x0072,0x0716,VR::CS,VM::VM1,"Show Acquisition Techniques Flag",false },
  {0x0072,0x0717,VR::CS,VM::VM1,"Display Set Horizontal Justification",false },
  {0x0072,0x0718,VR::CS,VM::VM1,"Display Set Vertical Justification",false },
  {0x0074,0x1000,VR::CS,VM::VM1,"Unified Procedure Step State",false },
  {0x0074,0x1002,VR::SQ,VM::VM1,"Unified Procedure Step Progress Information Sequence",false },
  {0x0074,0x1004,VR::DS,VM::VM1,"Unified Procedure Step Progress",false },
  {0x0074,0x1006,VR::ST,VM::VM1,"Unified Procedure Step Progress Description",false },
  {0x0074,0x1008,VR::SQ,VM::VM1,"Unified Procedure Step Communications URI Sequence",false },
  {0x0074,0x100a,VR::ST,VM::VM1,"Contact URI",false },
  {0x0074,0x100c,VR::LO,VM::VM1,"Contact Display Name",false },
  {0x0074,0x100e,VR::SQ,VM::VM1,"Unified Procedure Step Discontinuation Reason Code Sequence",false },
  {0x0074,0x1020,VR::SQ,VM::VM1,"Beam Task Sequence",false },
  {0x0074,0x1022,VR::CS,VM::VM1,"Beam Task Type",false },
  {0x0074,0x1024,VR::IS,VM::VM1,"Beam Order Index",false },
  {0x0074,0x1030,VR::SQ,VM::VM1,"Delivery Verification Image Sequence",false },
  {0x0074,0x1032,VR::CS,VM::VM1,"Verification Image Timing",false },
  {0x0074,0x1034,VR::CS,VM::VM1,"Double Exposure Flag",false },
  {0x0074,0x1036,VR::CS,VM::VM1,"Double Exposure Ordering",false },
  {0x0074,0x1038,VR::DS,VM::VM1,"Double Exposure Meterset",false },
  {0x0074,0x103a,VR::DS,VM::VM4,"Double Exposure Field Delta",false },
  {0x0074,0x1040,VR::SQ,VM::VM1,"Related Reference RT Image Sequence",false },
  {0x0074,0x1042,VR::SQ,VM::VM1,"General Machine Verification Sequence",false },
  {0x0074,0x1044,VR::SQ,VM::VM1,"Conventional Machine Verification Sequence",false },
  {0x0074,0x1046,VR::SQ,VM::VM1,"Ion Machine Verification Sequence",false },
  {0x0074,0x1048,VR::SQ,VM::VM1,"Failed Attributes Sequence",false },
  {0x0074,0x104a,VR::SQ,VM::VM1,"Overridden Attributes Sequence",false },
  {0x0074,0x104c,VR::SQ,VM::VM1,"Conventional Control Point Verification Sequence",false },
  {0x0074,0x104e,VR::SQ,VM::VM1,"Ion Control Point Verification Sequence",false },
  {0x0074,0x1050,VR::SQ,VM::VM1,"Attribute Occurrence Sequence",false },
  {0x0074,0x1052,VR::AT,VM::VM1,"Attribute Occurrence Pointer",false },
  {0x0074,0x1054,VR::UL,VM::VM1,"Attribute Item Selector",false },
  {0x0074,0x1056,VR::LO,VM::VM1,"Attribute Occurrence Private Creator",false },
  {0x0074,0x1200,VR::CS,VM::VM1,"Scheduled Procedure Step Priority",false },
  {0x0074,0x1202,VR::LO,VM::VM1,"Worklist Label",false },
  {0x0074,0x1204,VR::LO,VM::VM1,"Procedure Step Label",false },
  {0x0074,0x1210,VR::SQ,VM::VM1,"Scheduled Processing Parameters Sequence",false },
  {0x0074,0x1212,VR::SQ,VM::VM1,"Performed Processing Parameters Sequence",false },
  {0x0074,0x1216,VR::SQ,VM::VM1,"Unified Procedure Step Performed Procedure Sequence",false },
  {0x0074,0x1220,VR::SQ,VM::VM1,"Related Procedure Step Sequence",false },
  {0x0074,0x1222,VR::LO,VM::VM1,"Procedure Step Relationship Type",false },
  {0x0074,0x1230,VR::LO,VM::VM1,"Deletion Lock",false },
  {0x0074,0x1234,VR::AE,VM::VM1,"Receiving AE",false },
  {0x0074,0x1236,VR::AE,VM::VM1,"Requesting AE",false },
  {0x0074,0x1238,VR::LT,VM::VM1,"Reason for Cancellation",false },
  {0x0074,0x1242,VR::CS,VM::VM1,"SCP Status",false },
  {0x0074,0x1244,VR::CS,VM::VM1,"Subscription List Status",false },
  {0x0074,0x1246,VR::CS,VM::VM1,"Unified Procedure Step List Status",false },
  {0x0088,0x0130,VR::SH,VM::VM1,"Storage Media File-set ID",false },
  {0x0088,0x0140,VR::UI,VM::VM1,"Storage Media File-set UID",false },
  {0x0088,0x0200,VR::SQ,VM::VM1,"Icon Image Sequence",false },
  {0x0088,0x0904,VR::LO,VM::VM1,"Topic Title",true },
  {0x0088,0x0906,VR::ST,VM::VM1,"Topic Subject",true },
  {0x0088,0x0910,VR::LO,VM::VM1,"Topic Author",true },
  {0x0088,0x0912,VR::LO,VM::VM1_32,"Topic Keywords",true },
  {0x0100,0x0410,VR::CS,VM::VM1,"SOP Instance Status",false },
  {0x0100,0x0420,VR::DT,VM::VM1,"SOP Authorization DateTime",false },
  {0x0100,0x0424,VR::LT,VM::VM1,"SOP Authorization Comment",false },
  {0x0100,0x0426,VR::LO,VM::VM1,"Authorization Equipment Certification Number",false },
  {0x0400,0x0005,VR::US,VM::VM1,"MAC ID Number",false },
  {0x0400,0x0010,VR::UI,VM::VM1,"MAC Calculation Transfer Syntax UID",false },
  {0x0400,0x0015,VR::CS,VM::VM1,"MAC Algorithm",false },
  {0x0400,0x0020,VR::AT,VM::VM1_n,"Data Elements Signed",false },
  {0x0400,0x0100,VR::UI,VM::VM1,"Digital Signature UID",false },
  {0x0400,0x0105,VR::DT,VM::VM1,"Digital Signature DateTime",false },
  {0x0400,0x0110,VR::CS,VM::VM1,"Certificate Type",false },
  {0x0400,0x0115,VR::OB,VM::VM1,"Certificate of Signer",false },
  {0x0400,0x0120,VR::OB,VM::VM1,"Signature",false },
  {0x0400,0x0305,VR::CS,VM::VM1,"Certified Timestamp Type",false },
  {0x0400,0x0310,VR::OB,VM::VM1,"Certified Timestamp",false },
  {0x0400,0x0401,VR::SQ,VM::VM1,"Digital Signature Purpose Code Sequence",false },
  {0x0400,0x0402,VR::SQ,VM::VM1,"Referenced Digital Signature Sequence",false },
  {0x0400,0x0403,VR::SQ,VM::VM1,"Referenced SOP Instance MAC Sequence",false },
  {0x0400,0x0404,VR::OB,VM::VM1,"MAC",false },
  {0x0400,0x0500,VR::SQ,VM::VM1,"Encrypted Attributes Sequence",false },
  {0x0400,0x0510,VR::UI,VM::VM1,"Encrypted Content Transfer Syntax UID",false },
  {0x0400,0x0520,VR::OB,VM::VM1,"Encrypted Content",false },
  {0x0400,0x0550,VR::SQ,VM::VM1,"Modified Attributes Sequence",false },
  {0x0400,0x0561,VR::SQ,VM::VM1,"Original Attributes Sequence",false },
  {0x0400,0x0562,VR::DT,VM::VM1,"Attribute Modification DateTime",false },
  {0x0400,0x0563,VR::LO,VM::VM1,"Modifying System",false },
  {0x0400,0x0564,VR::LO,VM::VM1,"Source of Previous Values",false },
  {0x0400,0x0565,VR::CS,VM::VM1,"Reason for the Attribute Modification",false },
//  {0x1010,0x0000,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0001,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0002,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0003,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0004,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0005,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0006,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0007,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0008,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0009,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x000f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0010,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0011,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0012,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0013,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0014,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0015,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0016,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0017,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0018,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0019,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x001f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0020,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0021,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0022,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0023,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0024,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0025,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0026,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0027,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0028,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0029,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x002f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0030,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0031,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0032,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0033,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0034,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0035,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0036,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0037,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0038,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0039,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x003f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0040,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0041,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0042,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0043,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0044,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0045,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0046,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0047,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0048,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0049,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x004f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0050,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0051,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0052,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0053,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0054,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0055,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0056,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0057,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0058,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0059,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x005f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0060,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0061,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0062,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0063,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0064,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0065,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0066,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0067,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0068,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0069,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x006f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0070,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0071,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0072,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0073,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0074,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0075,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0076,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0077,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0078,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0079,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x007f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0080,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0081,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0082,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0083,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0084,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0085,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0086,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0087,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0088,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0089,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x008f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0090,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0091,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0092,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0093,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0094,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0095,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0096,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0097,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0098,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x0099,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009a,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009b,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009c,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009d,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009e,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x009f,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00a9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00aa,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ab,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ac,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ad,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ae,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00af,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00b9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ba,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00bb,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00bc,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00bd,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00be,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00bf,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00c9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ca,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00cb,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00cc,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00cd,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ce,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00cf,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00d9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00da,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00db,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00dc,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00dd,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00de,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00df,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00e9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ea,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00eb,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ec,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ed,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ee,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ef,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f0,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f1,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f2,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f3,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f4,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f5,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f6,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f7,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f8,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00f9,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00fa,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00fb,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00fc,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00fd,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00fe,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x1010,0x00ff,VR::US,VM::VM1_n,"Zonal Map",true },
  {0x2000,0x0010,VR::IS,VM::VM1,"Number of Copies",false },
  {0x2000,0x001e,VR::SQ,VM::VM1,"Printer Configuration Sequence",false },
  {0x2000,0x0020,VR::CS,VM::VM1,"Print Priority",false },
  {0x2000,0x0030,VR::CS,VM::VM1,"Medium Type",false },
  {0x2000,0x0040,VR::CS,VM::VM1,"Film Destination",false },
  {0x2000,0x0050,VR::LO,VM::VM1,"Film Session Label",false },
  {0x2000,0x0060,VR::IS,VM::VM1,"Memory Allocation",false },
  {0x2000,0x0061,VR::IS,VM::VM1,"Maximum Memory Allocation",false },
  {0x2000,0x0062,VR::CS,VM::VM1,"Color Image Printing Flag",true },
  {0x2000,0x0063,VR::CS,VM::VM1,"Collation Flag",true },
  {0x2000,0x0065,VR::CS,VM::VM1,"Annotation Flag",true },
  {0x2000,0x0067,VR::CS,VM::VM1,"Image Overlay Flag",true },
  {0x2000,0x0069,VR::CS,VM::VM1,"Presentation LUT Flag",true },
  {0x2000,0x006a,VR::CS,VM::VM1,"Image Box Presentation LUT Flag",true },
  {0x2000,0x00a0,VR::US,VM::VM1,"Memory Bit Depth",false },
  {0x2000,0x00a1,VR::US,VM::VM1,"Printing Bit Depth",false },
  {0x2000,0x00a2,VR::SQ,VM::VM1,"Media Installed Sequence",false },
  {0x2000,0x00a4,VR::SQ,VM::VM1,"Other Media Available Sequence",false },
  {0x2000,0x00a8,VR::SQ,VM::VM1,"Supported Image Display Formats Sequence",false },
  {0x2000,0x0500,VR::SQ,VM::VM1,"Referenced Film Box Sequence",false },
  {0x2000,0x0510,VR::SQ,VM::VM1,"Referenced Stored Print Sequence",true },
  {0x2010,0x0010,VR::ST,VM::VM1,"Image Display Format",false },
  {0x2010,0x0030,VR::CS,VM::VM1,"Annotation Display Format ID",false },
  {0x2010,0x0040,VR::CS,VM::VM1,"Film Orientation",false },
  {0x2010,0x0050,VR::CS,VM::VM1,"Film Size ID",false },
  {0x2010,0x0052,VR::CS,VM::VM1,"Printer Resolution ID",false },
  {0x2010,0x0054,VR::CS,VM::VM1,"Default Printer Resolution ID",false },
  {0x2010,0x0060,VR::CS,VM::VM1,"Magnification Type",false },
  {0x2010,0x0080,VR::CS,VM::VM1,"Smoothing Type",false },
  {0x2010,0x00a6,VR::CS,VM::VM1,"Default Magnification Type",false },
  {0x2010,0x00a7,VR::CS,VM::VM1_n,"Other Magnification Types Available",false },
  {0x2010,0x00a8,VR::CS,VM::VM1,"Default Smoothing Type",false },
  {0x2010,0x00a9,VR::CS,VM::VM1_n,"Other Smoothing Types Available",false },
  {0x2010,0x0100,VR::CS,VM::VM1,"Border Density",false },
  {0x2010,0x0110,VR::CS,VM::VM1,"Empty Image Density",false },
  {0x2010,0x0120,VR::US,VM::VM1,"Min Density",false },
  {0x2010,0x0130,VR::US,VM::VM1,"Max Density",false },
  {0x2010,0x0140,VR::CS,VM::VM1,"Trim",false },
  {0x2010,0x0150,VR::ST,VM::VM1,"Configuration Information",false },
  {0x2010,0x0152,VR::LT,VM::VM1,"Configuration Information Description",false },
  {0x2010,0x0154,VR::IS,VM::VM1,"Maximum Collated Films",false },
  {0x2010,0x015e,VR::US,VM::VM1,"Illumination",false },
  {0x2010,0x0160,VR::US,VM::VM1,"Reflected Ambient Light",false },
  {0x2010,0x0376,VR::DS,VM::VM2,"Printer Pixel Spacing",false },
  {0x2010,0x0500,VR::SQ,VM::VM1,"Referenced Film Session Sequence",false },
  {0x2010,0x0510,VR::SQ,VM::VM1,"Referenced Image Box Sequence",false },
  {0x2010,0x0520,VR::SQ,VM::VM1,"Referenced Basic Annotation Box Sequence",false },
  {0x2020,0x0010,VR::US,VM::VM1,"Image Box Position",false },
  {0x2020,0x0020,VR::CS,VM::VM1,"Polarity",false },
  {0x2020,0x0030,VR::DS,VM::VM1,"Requested Image Size",false },
  {0x2020,0x0040,VR::CS,VM::VM1,"Requested Decimate/Crop Behavior",false },
  {0x2020,0x0050,VR::CS,VM::VM1,"Requested Resolution ID",false },
  {0x2020,0x00a0,VR::CS,VM::VM1,"Requested Image Size Flag",false },
  {0x2020,0x00a2,VR::CS,VM::VM1,"Decimate/Crop Result",false },
  {0x2020,0x0110,VR::SQ,VM::VM1,"Basic Grayscale Image Sequence",false },
  {0x2020,0x0111,VR::SQ,VM::VM1,"Basic Color Image Sequence",false },
  {0x2020,0x0130,VR::SQ,VM::VM1,"Referenced Image Overlay Box Sequence",true },
  {0x2020,0x0140,VR::SQ,VM::VM1,"Referenced VOI LUT Box Sequence",true },
  {0x2030,0x0010,VR::US,VM::VM1,"Annotation Position",false },
  {0x2030,0x0020,VR::LO,VM::VM1,"Text String",false },
  {0x2040,0x0010,VR::SQ,VM::VM1,"Referenced Overlay Plane Sequence",true },
  {0x2040,0x0011,VR::US,VM::VM1_99,"Referenced Overlay Plane Groups",true },
  {0x2040,0x0020,VR::SQ,VM::VM1,"Overlay Pixel Data Sequence",true },
  {0x2040,0x0060,VR::CS,VM::VM1,"Overlay Magnification Type",true },
  {0x2040,0x0070,VR::CS,VM::VM1,"Overlay Smoothing Type",true },
  {0x2040,0x0072,VR::CS,VM::VM1,"Overlay or Image Magnification",true },
  {0x2040,0x0074,VR::US,VM::VM1,"Magnify to Number of Columns",true },
  {0x2040,0x0080,VR::CS,VM::VM1,"Overlay Foreground Density",true },
  {0x2040,0x0082,VR::CS,VM::VM1,"Overlay Background Density",true },
  {0x2040,0x0090,VR::CS,VM::VM1,"Overlay Mode",true },
  {0x2040,0x0100,VR::CS,VM::VM1,"Threshold Density",true },
  {0x2040,0x0500,VR::SQ,VM::VM1,"Referenced Image Box Sequence (Retired)",true },
  {0x2050,0x0010,VR::SQ,VM::VM1,"Presentation LUT Sequence",false },
  {0x2050,0x0020,VR::CS,VM::VM1,"Presentation LUT Shape",false },
  {0x2050,0x0500,VR::SQ,VM::VM1,"Referenced Presentation LUT Sequence",false },
  {0x2100,0x0010,VR::SH,VM::VM1,"Print Job ID",true },
  {0x2100,0x0020,VR::CS,VM::VM1,"Execution Status",false },
  {0x2100,0x0030,VR::CS,VM::VM1,"Execution Status Info",false },
  {0x2100,0x0040,VR::DA,VM::VM1,"Creation Date",false },
  {0x2100,0x0050,VR::TM,VM::VM1,"Creation Time",false },
  {0x2100,0x0070,VR::AE,VM::VM1,"Originator",false },
  {0x2100,0x0140,VR::AE,VM::VM1,"Destination AE",true },
  {0x2100,0x0160,VR::SH,VM::VM1,"Owner ID",false },
  {0x2100,0x0170,VR::IS,VM::VM1,"Number of Films",false },
  {0x2100,0x0500,VR::SQ,VM::VM1,"Referenced Print Job Sequence (Pull Stored Print)",true },
  {0x2110,0x0010,VR::CS,VM::VM1,"Printer Status",false },
  {0x2110,0x0020,VR::CS,VM::VM1,"Printer Status Info",false },
  {0x2110,0x0030,VR::LO,VM::VM1,"Printer Name",false },
  {0x2110,0x0099,VR::SH,VM::VM1,"Print Queue ID",true },
  {0x2120,0x0010,VR::CS,VM::VM1,"Queue Status",true },
  {0x2120,0x0050,VR::SQ,VM::VM1,"Print Job Description Sequence",true },
  {0x2120,0x0070,VR::SQ,VM::VM1,"Referenced Print Job Sequence",true },
  {0x2130,0x0010,VR::SQ,VM::VM1,"Print Management Capabilities Sequence",true },
  {0x2130,0x0015,VR::SQ,VM::VM1,"Printer Characteristics Sequence",true },
  {0x2130,0x0030,VR::SQ,VM::VM1,"Film Box Content Sequence",true },
  {0x2130,0x0040,VR::SQ,VM::VM1,"Image Box Content Sequence",true },
  {0x2130,0x0050,VR::SQ,VM::VM1,"Annotation Content Sequence",true },
  {0x2130,0x0060,VR::SQ,VM::VM1,"Image Overlay Box Content Sequence",true },
  {0x2130,0x0080,VR::SQ,VM::VM1,"Presentation LUT Content Sequence",true },
  {0x2130,0x00a0,VR::SQ,VM::VM1,"Proposed Study Sequence",true },
  {0x2130,0x00c0,VR::SQ,VM::VM1,"Original Image Sequence",true },
  {0x2200,0x0001,VR::CS,VM::VM1,"Label Using Information Extracted From Instances",false },
  {0x2200,0x0002,VR::UT,VM::VM1,"Label Text",false },
  {0x2200,0x0003,VR::CS,VM::VM1,"Label Style Selection",false },
  {0x2200,0x0004,VR::LT,VM::VM1,"Media Disposition",false },
  {0x2200,0x0005,VR::LT,VM::VM1,"Barcode Value",false },
  {0x2200,0x0006,VR::CS,VM::VM1,"Barcode Symbology",false },
  {0x2200,0x0007,VR::CS,VM::VM1,"Allow Media Splitting",false },
  {0x2200,0x0008,VR::CS,VM::VM1,"Include Non-DICOM Objects",false },
  {0x2200,0x0009,VR::CS,VM::VM1,"Include Display Application",false },
  {0x2200,0x000a,VR::CS,VM::VM1,"Preserve Composite Instances After Media Creation",false },
  {0x2200,0x000b,VR::US,VM::VM1,"Total Number of Pieces of Media Created",false },
  {0x2200,0x000c,VR::LO,VM::VM1,"Requested Media Application Profile",false },
  {0x2200,0x000d,VR::SQ,VM::VM1,"Referenced Storage Media Sequence",false },
  {0x2200,0x000e,VR::AT,VM::VM1_n,"Failure Attributes",false },
  {0x2200,0x000f,VR::CS,VM::VM1,"Allow Lossy Compression",false },
  {0x2200,0x0020,VR::CS,VM::VM1,"Request Priority",false },
  {0x3002,0x0002,VR::SH,VM::VM1,"RT Image Label",false },
  {0x3002,0x0003,VR::LO,VM::VM1,"RT Image Name",false },
  {0x3002,0x0004,VR::ST,VM::VM1,"RT Image Description",false },
  {0x3002,0x000a,VR::CS,VM::VM1,"Reported Values Origin",false },
  {0x3002,0x000c,VR::CS,VM::VM1,"RT Image Plane",false },
  {0x3002,0x000d,VR::DS,VM::VM3,"X-Ray Image Receptor Translation",false },
  {0x3002,0x000e,VR::DS,VM::VM1,"X-Ray Image Receptor Angle",false },
  {0x3002,0x0010,VR::DS,VM::VM6,"RT Image Orientation",false },
  {0x3002,0x0011,VR::DS,VM::VM2,"Image Plane Pixel Spacing",false },
  {0x3002,0x0012,VR::DS,VM::VM2,"RT Image Position",false },
  {0x3002,0x0020,VR::SH,VM::VM1,"Radiation Machine Name",false },
  {0x3002,0x0022,VR::DS,VM::VM1,"Radiation Machine SAD",false },
  {0x3002,0x0024,VR::DS,VM::VM1,"Radiation Machine SSD",false },
  {0x3002,0x0026,VR::DS,VM::VM1,"RT Image SID",false },
  {0x3002,0x0028,VR::DS,VM::VM1,"Source to Reference Object Distance",false },
  {0x3002,0x0029,VR::IS,VM::VM1,"Fraction Number",false },
  {0x3002,0x0030,VR::SQ,VM::VM1,"Exposure Sequence",false },
  {0x3002,0x0032,VR::DS,VM::VM1,"Meterset Exposure",false },
  {0x3002,0x0034,VR::DS,VM::VM4,"Diaphragm Position",false },
  {0x3002,0x0040,VR::SQ,VM::VM1,"Fluence Map Sequence",false },
  {0x3002,0x0041,VR::CS,VM::VM1,"Fluence Data Source",false },
  {0x3002,0x0042,VR::DS,VM::VM1,"Fluence Data Scale",false },
  {0x3002,0x0050,VR::SQ,VM::VM1,"Primary Fluence Mode Sequence",false },
  {0x3002,0x0051,VR::CS,VM::VM1,"Fluence Mode",false },
  {0x3002,0x0052,VR::SH,VM::VM1,"Fluence Mode ID",false },
  {0x3004,0x0001,VR::CS,VM::VM1,"DVH Type",false },
  {0x3004,0x0002,VR::CS,VM::VM1,"Dose Units",false },
  {0x3004,0x0004,VR::CS,VM::VM1,"Dose Type",false },
  {0x3004,0x0006,VR::LO,VM::VM1,"Dose Comment",false },
  {0x3004,0x0008,VR::DS,VM::VM3,"Normalization Point",false },
  {0x3004,0x000a,VR::CS,VM::VM1,"Dose Summation Type",false },
  {0x3004,0x000c,VR::DS,VM::VM2_n,"Grid Frame Offset Vector",false },
  {0x3004,0x000e,VR::DS,VM::VM1,"Dose Grid Scaling",false },
  {0x3004,0x0010,VR::SQ,VM::VM1,"RT Dose ROI Sequence",false },
  {0x3004,0x0012,VR::DS,VM::VM1,"Dose Value",false },
  {0x3004,0x0014,VR::CS,VM::VM1_3,"Tissue Heterogeneity Correction",false },
  {0x3004,0x0040,VR::DS,VM::VM3,"DVH Normalization Point",false },
  {0x3004,0x0042,VR::DS,VM::VM1,"DVH Normalization Dose Value",false },
  {0x3004,0x0050,VR::SQ,VM::VM1,"DVH Sequence",false },
  {0x3004,0x0052,VR::DS,VM::VM1,"DVH Dose Scaling",false },
  {0x3004,0x0054,VR::CS,VM::VM1,"DVH Volume Units",false },
  {0x3004,0x0056,VR::IS,VM::VM1,"DVH Number of Bins",false },
  {0x3004,0x0058,VR::DS,VM::VM2_2n,"DVH Data",false },
  {0x3004,0x0060,VR::SQ,VM::VM1,"DVH Referenced ROI Sequence",false },
  {0x3004,0x0062,VR::CS,VM::VM1,"DVH ROI Contribution Type",false },
  {0x3004,0x0070,VR::DS,VM::VM1,"DVH Minimum Dose",false },
  {0x3004,0x0072,VR::DS,VM::VM1,"DVH Maximum Dose",false },
  {0x3004,0x0074,VR::DS,VM::VM1,"DVH Mean Dose",false },
  {0x3006,0x0002,VR::SH,VM::VM1,"Structure Set Label",false },
  {0x3006,0x0004,VR::LO,VM::VM1,"Structure Set Name",false },
  {0x3006,0x0006,VR::ST,VM::VM1,"Structure Set Description",false },
  {0x3006,0x0008,VR::DA,VM::VM1,"Structure Set Date",false },
  {0x3006,0x0009,VR::TM,VM::VM1,"Structure Set Time",false },
  {0x3006,0x0010,VR::SQ,VM::VM1,"Referenced Frame of Reference Sequence",false },
  {0x3006,0x0012,VR::SQ,VM::VM1,"RT Referenced Study Sequence",false },
  {0x3006,0x0014,VR::SQ,VM::VM1,"RT Referenced Series Sequence",false },
  {0x3006,0x0016,VR::SQ,VM::VM1,"Contour Image Sequence",false },
  {0x3006,0x0020,VR::SQ,VM::VM1,"Structure Set ROI Sequence",false },
  {0x3006,0x0022,VR::IS,VM::VM1,"ROI Number",false },
  {0x3006,0x0024,VR::UI,VM::VM1,"Referenced Frame of Reference UID",false },
  {0x3006,0x0026,VR::LO,VM::VM1,"ROI Name",false },
  {0x3006,0x0028,VR::ST,VM::VM1,"ROI Description",false },
  {0x3006,0x002a,VR::IS,VM::VM3,"ROI Display Color",false },
  {0x3006,0x002c,VR::DS,VM::VM1,"ROI Volume",false },
  {0x3006,0x0030,VR::SQ,VM::VM1,"RT Related ROI Sequence",false },
  {0x3006,0x0033,VR::CS,VM::VM1,"RT ROI Relationship",false },
  {0x3006,0x0036,VR::CS,VM::VM1,"ROI Generation Algorithm",false },
  {0x3006,0x0038,VR::LO,VM::VM1,"ROI Generation Description",false },
  {0x3006,0x0039,VR::SQ,VM::VM1,"ROI Contour Sequence",false },
  {0x3006,0x0040,VR::SQ,VM::VM1,"Contour Sequence",false },
  {0x3006,0x0042,VR::CS,VM::VM1,"Contour Geometric Type",false },
  {0x3006,0x0044,VR::DS,VM::VM1,"Contour Slab Thickness",false },
  {0x3006,0x0045,VR::DS,VM::VM3,"Contour Offset Vector",false },
  {0x3006,0x0046,VR::IS,VM::VM1,"Number of Contour Points",false },
  {0x3006,0x0048,VR::IS,VM::VM1,"Contour Number",false },
  {0x3006,0x0049,VR::IS,VM::VM1_n,"Attached Contours",false },
  {0x3006,0x0050,VR::DS,VM::VM3_3n,"Contour Data",false },
  {0x3006,0x0080,VR::SQ,VM::VM1,"RT ROI Observations Sequence",false },
  {0x3006,0x0082,VR::IS,VM::VM1,"Observation Number",false },
  {0x3006,0x0084,VR::IS,VM::VM1,"Referenced ROI Number",false },
  {0x3006,0x0085,VR::SH,VM::VM1,"ROI Observation Label",false },
  {0x3006,0x0086,VR::SQ,VM::VM1,"RT ROI Identification Code Sequence",false },
  {0x3006,0x0088,VR::ST,VM::VM1,"ROI Observation Description",false },
  {0x3006,0x00a0,VR::SQ,VM::VM1,"Related RT ROI Observations Sequence",false },
  {0x3006,0x00a4,VR::CS,VM::VM1,"RT ROI Interpreted Type",false },
  {0x3006,0x00a6,VR::PN,VM::VM1,"ROI Interpreter",false },
  {0x3006,0x00b0,VR::SQ,VM::VM1,"ROI Physical Properties Sequence",false },
  {0x3006,0x00b2,VR::CS,VM::VM1,"ROI Physical Property",false },
  {0x3006,0x00b4,VR::DS,VM::VM1,"ROI Physical Property Value",false },
  {0x3006,0x00b6,VR::SQ,VM::VM1,"ROI Elemental Composition Sequence",false },
  {0x3006,0x00b7,VR::US,VM::VM1,"ROI Elemental Composition Atomic Number",false },
  {0x3006,0x00b8,VR::FL,VM::VM1,"ROI Elemental Composition Atomic Mass Fraction",false },
  {0x3006,0x00c0,VR::SQ,VM::VM1,"Frame of Reference Relationship Sequence",false },
  {0x3006,0x00c2,VR::UI,VM::VM1,"Related Frame of Reference UID",false },
  {0x3006,0x00c4,VR::CS,VM::VM1,"Frame of Reference Transformation Type",false },
  {0x3006,0x00c6,VR::DS,VM::VM16,"Frame of Reference Transformation Matrix",false },
  {0x3006,0x00c8,VR::LO,VM::VM1,"Frame of Reference Transformation Comment",false },
  {0x3008,0x0010,VR::SQ,VM::VM1,"Measured Dose Reference Sequence",false },
  {0x3008,0x0012,VR::ST,VM::VM1,"Measured Dose Description",false },
  {0x3008,0x0014,VR::CS,VM::VM1,"Measured Dose Type",false },
  {0x3008,0x0016,VR::DS,VM::VM1,"Measured Dose Value",false },
  {0x3008,0x0020,VR::SQ,VM::VM1,"Treatment Session Beam Sequence",false },
  {0x3008,0x0021,VR::SQ,VM::VM1,"Treatment Session Ion Beam Sequence",false },
  {0x3008,0x0022,VR::IS,VM::VM1,"Current Fraction Number",false },
  {0x3008,0x0024,VR::DA,VM::VM1,"Treatment Control Point Date",false },
  {0x3008,0x0025,VR::TM,VM::VM1,"Treatment Control Point Time",false },
  {0x3008,0x002a,VR::CS,VM::VM1,"Treatment Termination Status",false },
  {0x3008,0x002b,VR::SH,VM::VM1,"Treatment Termination Code",false },
  {0x3008,0x002c,VR::CS,VM::VM1,"Treatment Verification Status",false },
  {0x3008,0x0030,VR::SQ,VM::VM1,"Referenced Treatment Record Sequence",false },
  {0x3008,0x0032,VR::DS,VM::VM1,"Specified Primary Meterset",false },
  {0x3008,0x0033,VR::DS,VM::VM1,"Specified Secondary Meterset",false },
  {0x3008,0x0036,VR::DS,VM::VM1,"Delivered Primary Meterset",false },
  {0x3008,0x0037,VR::DS,VM::VM1,"Delivered Secondary Meterset",false },
  {0x3008,0x003a,VR::DS,VM::VM1,"Specified Treatment Time",false },
  {0x3008,0x003b,VR::DS,VM::VM1,"Delivered Treatment Time",false },
  {0x3008,0x0040,VR::SQ,VM::VM1,"Control Point Delivery Sequence",false },
  {0x3008,0x0041,VR::SQ,VM::VM1,"Ion Control Point Delivery Sequence",false },
  {0x3008,0x0042,VR::DS,VM::VM1,"Specified Meterset",false },
  {0x3008,0x0044,VR::DS,VM::VM1,"Delivered Meterset",false },
  {0x3008,0x0045,VR::FL,VM::VM1,"Meterset Rate Set",false },
  {0x3008,0x0046,VR::FL,VM::VM1,"Meterset Rate Delivered",false },
  {0x3008,0x0047,VR::FL,VM::VM1_n,"Scan Spot Metersets Delivered",false },
  {0x3008,0x0048,VR::DS,VM::VM1,"Dose Rate Delivered",false },
  {0x3008,0x0050,VR::SQ,VM::VM1,"Treatment Summary Calculated Dose Reference Sequence",false },
  {0x3008,0x0052,VR::DS,VM::VM1,"Cumulative Dose to Dose Reference",false },
  {0x3008,0x0054,VR::DA,VM::VM1,"First Treatment Date",false },
  {0x3008,0x0056,VR::DA,VM::VM1,"Most Recent Treatment Date",false },
  {0x3008,0x005a,VR::IS,VM::VM1,"Number of Fractions Delivered",false },
  {0x3008,0x0060,VR::SQ,VM::VM1,"Override Sequence",false },
  {0x3008,0x0061,VR::AT,VM::VM1,"Parameter Sequence Pointer",false },
  {0x3008,0x0062,VR::AT,VM::VM1,"Override Parameter Pointer",false },
  {0x3008,0x0063,VR::IS,VM::VM1,"Parameter Item Index",false },
  {0x3008,0x0064,VR::IS,VM::VM1,"Measured Dose Reference Number",false },
  {0x3008,0x0065,VR::AT,VM::VM1,"Parameter Pointer",false },
  {0x3008,0x0066,VR::ST,VM::VM1,"Override Reason",false },
  {0x3008,0x0068,VR::SQ,VM::VM1,"Corrected Parameter Sequence",false },
  {0x3008,0x006a,VR::FL,VM::VM1,"Correction Value",false },
  {0x3008,0x0070,VR::SQ,VM::VM1,"Calculated Dose Reference Sequence",false },
  {0x3008,0x0072,VR::IS,VM::VM1,"Calculated Dose Reference Number",false },
  {0x3008,0x0074,VR::ST,VM::VM1,"Calculated Dose Reference Description",false },
  {0x3008,0x0076,VR::DS,VM::VM1,"Calculated Dose Reference Dose Value",false },
  {0x3008,0x0078,VR::DS,VM::VM1,"Start Meterset",false },
  {0x3008,0x007a,VR::DS,VM::VM1,"End Meterset",false },
  {0x3008,0x0080,VR::SQ,VM::VM1,"Referenced Measured Dose Reference Sequence",false },
  {0x3008,0x0082,VR::IS,VM::VM1,"Referenced Measured Dose Reference Number",false },
  {0x3008,0x0090,VR::SQ,VM::VM1,"Referenced Calculated Dose Reference Sequence",false },
  {0x3008,0x0092,VR::IS,VM::VM1,"Referenced Calculated Dose Reference Number",false },
  {0x3008,0x00a0,VR::SQ,VM::VM1,"Beam Limiting Device Leaf Pairs Sequence",false },
  {0x3008,0x00b0,VR::SQ,VM::VM1,"Recorded Wedge Sequence",false },
  {0x3008,0x00c0,VR::SQ,VM::VM1,"Recorded Compensator Sequence",false },
  {0x3008,0x00d0,VR::SQ,VM::VM1,"Recorded Block Sequence",false },
  {0x3008,0x00e0,VR::SQ,VM::VM1,"Treatment Summary Measured Dose Reference Sequence",false },
  {0x3008,0x00f0,VR::SQ,VM::VM1,"Recorded Snout Sequence",false },
  {0x3008,0x00f2,VR::SQ,VM::VM1,"Recorded Range Shifter Sequence",false },
  {0x3008,0x00f4,VR::SQ,VM::VM1,"Recorded Lateral Spreading Device Sequence",false },
  {0x3008,0x00f6,VR::SQ,VM::VM1,"Recorded Range Modulator Sequence",false },
  {0x3008,0x0100,VR::SQ,VM::VM1,"Recorded Source Sequence",false },
  {0x3008,0x0105,VR::LO,VM::VM1,"Source Serial Number",false },
  {0x3008,0x0110,VR::SQ,VM::VM1,"Treatment Session Application Setup Sequence",false },
  {0x3008,0x0116,VR::CS,VM::VM1,"Application Setup Check",false },
  {0x3008,0x0120,VR::SQ,VM::VM1,"Recorded Brachy Accessory Device Sequence",false },
  {0x3008,0x0122,VR::IS,VM::VM1,"Referenced Brachy Accessory Device Number",false },
  {0x3008,0x0130,VR::SQ,VM::VM1,"Recorded Channel Sequence",false },
  {0x3008,0x0132,VR::DS,VM::VM1,"Specified Channel Total Time",false },
  {0x3008,0x0134,VR::DS,VM::VM1,"Delivered Channel Total Time",false },
  {0x3008,0x0136,VR::IS,VM::VM1,"Specified Number of Pulses",false },
  {0x3008,0x0138,VR::IS,VM::VM1,"Delivered Number of Pulses",false },
  {0x3008,0x013a,VR::DS,VM::VM1,"Specified Pulse Repetition Interval",false },
  {0x3008,0x013c,VR::DS,VM::VM1,"Delivered Pulse Repetition Interval",false },
  {0x3008,0x0140,VR::SQ,VM::VM1,"Recorded Source Applicator Sequence",false },
  {0x3008,0x0142,VR::IS,VM::VM1,"Referenced Source Applicator Number",false },
  {0x3008,0x0150,VR::SQ,VM::VM1,"Recorded Channel Shield Sequence",false },
  {0x3008,0x0152,VR::IS,VM::VM1,"Referenced Channel Shield Number",false },
  {0x3008,0x0160,VR::SQ,VM::VM1,"Brachy Control Point Delivered Sequence",false },
  {0x3008,0x0162,VR::DA,VM::VM1,"Safe Position Exit Date",false },
  {0x3008,0x0164,VR::TM,VM::VM1,"Safe Position Exit Time",false },
  {0x3008,0x0166,VR::DA,VM::VM1,"Safe Position Return Date",false },
  {0x3008,0x0168,VR::TM,VM::VM1,"Safe Position Return Time",false },
  {0x3008,0x0200,VR::CS,VM::VM1,"Current Treatment Status",false },
  {0x3008,0x0202,VR::ST,VM::VM1,"Treatment Status Comment",false },
  {0x3008,0x0220,VR::SQ,VM::VM1,"Fraction Group Summary Sequence",false },
  {0x3008,0x0223,VR::IS,VM::VM1,"Referenced Fraction Number",false },
  {0x3008,0x0224,VR::CS,VM::VM1,"Fraction Group Type",false },
  {0x3008,0x0230,VR::CS,VM::VM1,"Beam Stopper Position",false },
  {0x3008,0x0240,VR::SQ,VM::VM1,"Fraction Status Summary Sequence",false },
  {0x3008,0x0250,VR::DA,VM::VM1,"Treatment Date",false },
  {0x3008,0x0251,VR::TM,VM::VM1,"Treatment Time",false },
  {0x300a,0x0002,VR::SH,VM::VM1,"RT Plan Label",false },
  {0x300a,0x0003,VR::LO,VM::VM1,"RT Plan Name",false },
  {0x300a,0x0004,VR::ST,VM::VM1,"RT Plan Description",false },
  {0x300a,0x0006,VR::DA,VM::VM1,"RT Plan Date",false },
  {0x300a,0x0007,VR::TM,VM::VM1,"RT Plan Time",false },
  {0x300a,0x0009,VR::LO,VM::VM1_n,"Treatment Protocols",false },
  {0x300a,0x000a,VR::CS,VM::VM1,"Plan Intent",false },
  {0x300a,0x000b,VR::LO,VM::VM1_n,"Treatment Sites",false },
  {0x300a,0x000c,VR::CS,VM::VM1,"RT Plan Geometry",false },
  {0x300a,0x000e,VR::ST,VM::VM1,"Prescription Description",false },
  {0x300a,0x0010,VR::SQ,VM::VM1,"Dose Reference Sequence",false },
  {0x300a,0x0012,VR::IS,VM::VM1,"Dose Reference Number",false },
  {0x300a,0x0013,VR::UI,VM::VM1,"Dose Reference UID",false },
  {0x300a,0x0014,VR::CS,VM::VM1,"Dose Reference Structure Type",false },
  {0x300a,0x0015,VR::CS,VM::VM1,"Nominal Beam Energy Unit",false },
  {0x300a,0x0016,VR::LO,VM::VM1,"Dose Reference Description",false },
  {0x300a,0x0018,VR::DS,VM::VM3,"Dose Reference Point Coordinates",false },
  {0x300a,0x001a,VR::DS,VM::VM1,"Nominal Prior Dose",false },
  {0x300a,0x0020,VR::CS,VM::VM1,"Dose Reference Type",false },
  {0x300a,0x0021,VR::DS,VM::VM1,"Constraint Weight",false },
  {0x300a,0x0022,VR::DS,VM::VM1,"Delivery Warning Dose",false },
  {0x300a,0x0023,VR::DS,VM::VM1,"Delivery Maximum Dose",false },
  {0x300a,0x0025,VR::DS,VM::VM1,"Target Minimum Dose",false },
  {0x300a,0x0026,VR::DS,VM::VM1,"Target Prescription Dose",false },
  {0x300a,0x0027,VR::DS,VM::VM1,"Target Maximum Dose",false },
  {0x300a,0x0028,VR::DS,VM::VM1,"Target Underdose Volume Fraction",false },
  {0x300a,0x002a,VR::DS,VM::VM1,"Organ at Risk Full-volume Dose",false },
  {0x300a,0x002b,VR::DS,VM::VM1,"Organ at Risk Limit Dose",false },
  {0x300a,0x002c,VR::DS,VM::VM1,"Organ at Risk Maximum Dose",false },
  {0x300a,0x002d,VR::DS,VM::VM1,"Organ at Risk Overdose Volume Fraction",false },
  {0x300a,0x0040,VR::SQ,VM::VM1,"Tolerance Table Sequence",false },
  {0x300a,0x0042,VR::IS,VM::VM1,"Tolerance Table Number",false },
  {0x300a,0x0043,VR::SH,VM::VM1,"Tolerance Table Label",false },
  {0x300a,0x0044,VR::DS,VM::VM1,"Gantry Angle Tolerance",false },
  {0x300a,0x0046,VR::DS,VM::VM1,"Beam Limiting Device Angle Tolerance",false },
  {0x300a,0x0048,VR::SQ,VM::VM1,"Beam Limiting Device Tolerance Sequence",false },
  {0x300a,0x004a,VR::DS,VM::VM1,"Beam Limiting Device Position Tolerance",false },
  {0x300a,0x004b,VR::FL,VM::VM1,"Snout Position Tolerance",false },
  {0x300a,0x004c,VR::DS,VM::VM1,"Patient Support Angle Tolerance",false },
  {0x300a,0x004e,VR::DS,VM::VM1,"Table Top Eccentric Angle Tolerance",false },
  {0x300a,0x004f,VR::FL,VM::VM1,"Table Top Pitch Angle Tolerance",false },
  {0x300a,0x0050,VR::FL,VM::VM1,"Table Top Roll Angle Tolerance",false },
  {0x300a,0x0051,VR::DS,VM::VM1,"Table Top Vertical Position Tolerance",false },
  {0x300a,0x0052,VR::DS,VM::VM1,"Table Top Longitudinal Position Tolerance",false },
  {0x300a,0x0053,VR::DS,VM::VM1,"Table Top Lateral Position Tolerance",false },
  {0x300a,0x0055,VR::CS,VM::VM1,"RT Plan Relationship",false },
  {0x300a,0x0070,VR::SQ,VM::VM1,"Fraction Group Sequence",false },
  {0x300a,0x0071,VR::IS,VM::VM1,"Fraction Group Number",false },
  {0x300a,0x0072,VR::LO,VM::VM1,"Fraction Group Description",false },
  {0x300a,0x0078,VR::IS,VM::VM1,"Number of Fractions Planned",false },
  {0x300a,0x0079,VR::IS,VM::VM1,"Number of Fraction Pattern Digits Per Day",false },
  {0x300a,0x007a,VR::IS,VM::VM1,"Repeat Fraction Cycle Length",false },
  {0x300a,0x007b,VR::LT,VM::VM1,"Fraction Pattern",false },
  {0x300a,0x0080,VR::IS,VM::VM1,"Number of Beams",false },
  {0x300a,0x0082,VR::DS,VM::VM3,"Beam Dose Specification Point",false },
  {0x300a,0x0084,VR::DS,VM::VM1,"Beam Dose",false },
  {0x300a,0x0086,VR::DS,VM::VM1,"Beam Meterset",false },
  {0x300a,0x0088,VR::FL,VM::VM1,"Beam Dose Point Depth",false },
  {0x300a,0x0089,VR::FL,VM::VM1,"Beam Dose Point Equivalent Depth",false },
  {0x300a,0x008a,VR::FL,VM::VM1,"Beam Dose Point SSD",false },
  {0x300a,0x00a0,VR::IS,VM::VM1,"Number of Brachy Application Setups",false },
  {0x300a,0x00a2,VR::DS,VM::VM3,"Brachy Application Setup Dose Specification Point",false },
  {0x300a,0x00a4,VR::DS,VM::VM1,"Brachy Application Setup Dose",false },
  {0x300a,0x00b0,VR::SQ,VM::VM1,"Beam Sequence",false },
  {0x300a,0x00b2,VR::SH,VM::VM1,"Treatment Machine Name",false },
  {0x300a,0x00b3,VR::CS,VM::VM1,"Primary Dosimeter Unit",false },
  {0x300a,0x00b4,VR::DS,VM::VM1,"Source-Axis Distance",false },
  {0x300a,0x00b6,VR::SQ,VM::VM1,"Beam Limiting Device Sequence",false },
  {0x300a,0x00b8,VR::CS,VM::VM1,"RT Beam Limiting Device Type",false },
  {0x300a,0x00ba,VR::DS,VM::VM1,"Source to Beam Limiting Device Distance",false },
  {0x300a,0x00bb,VR::FL,VM::VM1,"Isocenter to Beam Limiting Device Distance",false },
  {0x300a,0x00bc,VR::IS,VM::VM1,"Number of Leaf/Jaw Pairs",false },
  {0x300a,0x00be,VR::DS,VM::VM3_n,"Leaf Position Boundaries",false },
  {0x300a,0x00c0,VR::IS,VM::VM1,"Beam Number",false },
  {0x300a,0x00c2,VR::LO,VM::VM1,"Beam Name",false },
  {0x300a,0x00c3,VR::ST,VM::VM1,"Beam Description",false },
  {0x300a,0x00c4,VR::CS,VM::VM1,"Beam Type",false },
  {0x300a,0x00c6,VR::CS,VM::VM1,"Radiation Type",false },
  {0x300a,0x00c7,VR::CS,VM::VM1,"High-Dose Technique Type",false },
  {0x300a,0x00c8,VR::IS,VM::VM1,"Reference Image Number",false },
  {0x300a,0x00ca,VR::SQ,VM::VM1,"Planned Verification Image Sequence",false },
  {0x300a,0x00cc,VR::LO,VM::VM1_n,"Imaging Device-Specific Acquisition Parameters",false },
  {0x300a,0x00ce,VR::CS,VM::VM1,"Treatment Delivery Type",false },
  {0x300a,0x00d0,VR::IS,VM::VM1,"Number of Wedges",false },
  {0x300a,0x00d1,VR::SQ,VM::VM1,"Wedge Sequence",false },
  {0x300a,0x00d2,VR::IS,VM::VM1,"Wedge Number",false },
  {0x300a,0x00d3,VR::CS,VM::VM1,"Wedge Type",false },
  {0x300a,0x00d4,VR::SH,VM::VM1,"Wedge ID",false },
  {0x300a,0x00d5,VR::IS,VM::VM1,"Wedge Angle",false },
  {0x300a,0x00d6,VR::DS,VM::VM1,"Wedge Factor",false },
  {0x300a,0x00d7,VR::FL,VM::VM1,"Total Wedge Tray Water-Equivalent Thickness",false },
  {0x300a,0x00d8,VR::DS,VM::VM1,"Wedge Orientation",false },
  {0x300a,0x00d9,VR::FL,VM::VM1,"Isocenter to Wedge Tray Distance",false },
  {0x300a,0x00da,VR::DS,VM::VM1,"Source to Wedge Tray Distance",false },
  {0x300a,0x00db,VR::FL,VM::VM1,"Wedge Thin Edge Position",false },
  {0x300a,0x00dc,VR::SH,VM::VM1,"Bolus ID",false },
  {0x300a,0x00dd,VR::ST,VM::VM1,"Bolus Description",false },
  {0x300a,0x00e0,VR::IS,VM::VM1,"Number of Compensators",false },
  {0x300a,0x00e1,VR::SH,VM::VM1,"Material ID",false },
  {0x300a,0x00e2,VR::DS,VM::VM1,"Total Compensator Tray Factor",false },
  {0x300a,0x00e3,VR::SQ,VM::VM1,"Compensator Sequence",false },
  {0x300a,0x00e4,VR::IS,VM::VM1,"Compensator Number",false },
  {0x300a,0x00e5,VR::SH,VM::VM1,"Compensator ID",false },
  {0x300a,0x00e6,VR::DS,VM::VM1,"Source to Compensator Tray Distance",false },
  {0x300a,0x00e7,VR::IS,VM::VM1,"Compensator Rows",false },
  {0x300a,0x00e8,VR::IS,VM::VM1,"Compensator Columns",false },
  {0x300a,0x00e9,VR::DS,VM::VM2,"Compensator Pixel Spacing",false },
  {0x300a,0x00ea,VR::DS,VM::VM2,"Compensator Position",false },
  {0x300a,0x00eb,VR::DS,VM::VM1_n,"Compensator Transmission Data",false },
  {0x300a,0x00ec,VR::DS,VM::VM1_n,"Compensator Thickness Data",false },
  {0x300a,0x00ed,VR::IS,VM::VM1,"Number of Boli",false },
  {0x300a,0x00ee,VR::CS,VM::VM1,"Compensator Type",false },
  {0x300a,0x00f0,VR::IS,VM::VM1,"Number of Blocks",false },
  {0x300a,0x00f2,VR::DS,VM::VM1,"Total Block Tray Factor",false },
  {0x300a,0x00f3,VR::FL,VM::VM1,"Total Block Tray Water-Equivalent Thickness",false },
  {0x300a,0x00f4,VR::SQ,VM::VM1,"Block Sequence",false },
  {0x300a,0x00f5,VR::SH,VM::VM1,"Block Tray ID",false },
  {0x300a,0x00f6,VR::DS,VM::VM1,"Source to Block Tray Distance",false },
  {0x300a,0x00f7,VR::FL,VM::VM1,"Isocenter to Block Tray Distance",false },
  {0x300a,0x00f8,VR::CS,VM::VM1,"Block Type",false },
  {0x300a,0x00f9,VR::LO,VM::VM1,"Accessory Code",false },
  {0x300a,0x00fa,VR::CS,VM::VM1,"Block Divergence",false },
  {0x300a,0x00fb,VR::CS,VM::VM1,"Block Mounting Position",false },
  {0x300a,0x00fc,VR::IS,VM::VM1,"Block Number",false },
  {0x300a,0x00fe,VR::LO,VM::VM1,"Block Name",false },
  {0x300a,0x0100,VR::DS,VM::VM1,"Block Thickness",false },
  {0x300a,0x0102,VR::DS,VM::VM1,"Block Transmission",false },
  {0x300a,0x0104,VR::IS,VM::VM1,"Block Number of Points",false },
  {0x300a,0x0106,VR::DS,VM::VM2_2n,"Block Data",false },
  {0x300a,0x0107,VR::SQ,VM::VM1,"Applicator Sequence",false },
  {0x300a,0x0108,VR::SH,VM::VM1,"Applicator ID",false },
  {0x300a,0x0109,VR::CS,VM::VM1,"Applicator Type",false },
  {0x300a,0x010a,VR::LO,VM::VM1,"Applicator Description",false },
  {0x300a,0x010c,VR::DS,VM::VM1,"Cumulative Dose Reference Coefficient",false },
  {0x300a,0x010e,VR::DS,VM::VM1,"Final Cumulative Meterset Weight",false },
  {0x300a,0x0110,VR::IS,VM::VM1,"Number of Control Points",false },
  {0x300a,0x0111,VR::SQ,VM::VM1,"Control Point Sequence",false },
  {0x300a,0x0112,VR::IS,VM::VM1,"Control Point Index",false },
  {0x300a,0x0114,VR::DS,VM::VM1,"Nominal Beam Energy",false },
  {0x300a,0x0115,VR::DS,VM::VM1,"Dose Rate Set",false },
  {0x300a,0x0116,VR::SQ,VM::VM1,"Wedge Position Sequence",false },
  {0x300a,0x0118,VR::CS,VM::VM1,"Wedge Position",false },
  {0x300a,0x011a,VR::SQ,VM::VM1,"Beam Limiting Device Position Sequence",false },
  {0x300a,0x011c,VR::DS,VM::VM2_2n,"Leaf/Jaw Positions",false },
  {0x300a,0x011e,VR::DS,VM::VM1,"Gantry Angle",false },
  {0x300a,0x011f,VR::CS,VM::VM1,"Gantry Rotation Direction",false },
  {0x300a,0x0120,VR::DS,VM::VM1,"Beam Limiting Device Angle",false },
  {0x300a,0x0121,VR::CS,VM::VM1,"Beam Limiting Device Rotation Direction",false },
  {0x300a,0x0122,VR::DS,VM::VM1,"Patient Support Angle",false },
  {0x300a,0x0123,VR::CS,VM::VM1,"Patient Support Rotation Direction",false },
  {0x300a,0x0124,VR::DS,VM::VM1,"Table Top Eccentric Axis Distance",false },
  {0x300a,0x0125,VR::DS,VM::VM1,"Table Top Eccentric Angle",false },
  {0x300a,0x0126,VR::CS,VM::VM1,"Table Top Eccentric Rotation Direction",false },
  {0x300a,0x0128,VR::DS,VM::VM1,"Table Top Vertical Position",false },
  {0x300a,0x0129,VR::DS,VM::VM1,"Table Top Longitudinal Position",false },
  {0x300a,0x012a,VR::DS,VM::VM1,"Table Top Lateral Position",false },
  {0x300a,0x012c,VR::DS,VM::VM3,"Isocenter Position",false },
  {0x300a,0x012e,VR::DS,VM::VM3,"Surface Entry Point",false },
  {0x300a,0x0130,VR::DS,VM::VM1,"Source to Surface Distance",false },
  {0x300a,0x0134,VR::DS,VM::VM1,"Cumulative Meterset Weight",false },
  {0x300a,0x0140,VR::FL,VM::VM1,"Table Top Pitch Angle",false },
  {0x300a,0x0142,VR::CS,VM::VM1,"Table Top Pitch Rotation Direction",false },
  {0x300a,0x0144,VR::FL,VM::VM1,"Table Top Roll Angle",false },
  {0x300a,0x0146,VR::CS,VM::VM1,"Table Top Roll Rotation Direction",false },
  {0x300a,0x0148,VR::FL,VM::VM1,"Head Fixation Angle",false },
  {0x300a,0x014a,VR::FL,VM::VM1,"Gantry Pitch Angle",false },
  {0x300a,0x014c,VR::CS,VM::VM1,"Gantry Pitch Rotation Direction",false },
  {0x300a,0x014e,VR::FL,VM::VM1,"Gantry Pitch Angle Tolerance",false },
  {0x300a,0x0180,VR::SQ,VM::VM1,"Patient Setup Sequence",false },
  {0x300a,0x0182,VR::IS,VM::VM1,"Patient Setup Number",false },
  {0x300a,0x0183,VR::LO,VM::VM1,"Patient Setup Label",false },
  {0x300a,0x0184,VR::LO,VM::VM1,"Patient Additional Position",false },
  {0x300a,0x0190,VR::SQ,VM::VM1,"Fixation Device Sequence",false },
  {0x300a,0x0192,VR::CS,VM::VM1,"Fixation Device Type",false },
  {0x300a,0x0194,VR::SH,VM::VM1,"Fixation Device Label",false },
  {0x300a,0x0196,VR::ST,VM::VM1,"Fixation Device Description",false },
  {0x300a,0x0198,VR::SH,VM::VM1,"Fixation Device Position",false },
  {0x300a,0x0199,VR::FL,VM::VM1,"Fixation Device Pitch Angle",false },
  {0x300a,0x019a,VR::FL,VM::VM1,"Fixation Device Roll Angle",false },
  {0x300a,0x01a0,VR::SQ,VM::VM1,"Shielding Device Sequence",false },
  {0x300a,0x01a2,VR::CS,VM::VM1,"Shielding Device Type",false },
  {0x300a,0x01a4,VR::SH,VM::VM1,"Shielding Device Label",false },
  {0x300a,0x01a6,VR::ST,VM::VM1,"Shielding Device Description",false },
  {0x300a,0x01a8,VR::SH,VM::VM1,"Shielding Device Position",false },
  {0x300a,0x01b0,VR::CS,VM::VM1,"Setup Technique",false },
  {0x300a,0x01b2,VR::ST,VM::VM1,"Setup Technique Description",false },
  {0x300a,0x01b4,VR::SQ,VM::VM1,"Setup Device Sequence",false },
  {0x300a,0x01b6,VR::CS,VM::VM1,"Setup Device Type",false },
  {0x300a,0x01b8,VR::SH,VM::VM1,"Setup Device Label",false },
  {0x300a,0x01ba,VR::ST,VM::VM1,"Setup Device Description",false },
  {0x300a,0x01bc,VR::DS,VM::VM1,"Setup Device Parameter",false },
  {0x300a,0x01d0,VR::ST,VM::VM1,"Setup Reference Description",false },
  {0x300a,0x01d2,VR::DS,VM::VM1,"Table Top Vertical Setup Displacement",false },
  {0x300a,0x01d4,VR::DS,VM::VM1,"Table Top Longitudinal Setup Displacement",false },
  {0x300a,0x01d6,VR::DS,VM::VM1,"Table Top Lateral Setup Displacement",false },
  {0x300a,0x0200,VR::CS,VM::VM1,"Brachy Treatment Technique",false },
  {0x300a,0x0202,VR::CS,VM::VM1,"Brachy Treatment Type",false },
  {0x300a,0x0206,VR::SQ,VM::VM1,"Treatment Machine Sequence",false },
  {0x300a,0x0210,VR::SQ,VM::VM1,"Source Sequence",false },
  {0x300a,0x0212,VR::IS,VM::VM1,"Source Number",false },
  {0x300a,0x0214,VR::CS,VM::VM1,"Source Type",false },
  {0x300a,0x0216,VR::LO,VM::VM1,"Source Manufacturer",false },
  {0x300a,0x0218,VR::DS,VM::VM1,"Active Source Diameter",false },
  {0x300a,0x021a,VR::DS,VM::VM1,"Active Source Length",false },
  {0x300a,0x0222,VR::DS,VM::VM1,"Source Encapsulation Nominal Thickness",false },
  {0x300a,0x0224,VR::DS,VM::VM1,"Source Encapsulation Nominal Transmission",false },
  {0x300a,0x0226,VR::LO,VM::VM1,"Source Isotope Name",false },
  {0x300a,0x0228,VR::DS,VM::VM1,"Source Isotope Half Life",false },
  {0x300a,0x0229,VR::CS,VM::VM1,"Source Strength Units",false },
  {0x300a,0x022a,VR::DS,VM::VM1,"Reference Air Kerma Rate",false },
  {0x300a,0x022b,VR::DS,VM::VM1,"Source Strength",false },
  {0x300a,0x022c,VR::DA,VM::VM1,"Source Strength Reference Date",false },
  {0x300a,0x022e,VR::TM,VM::VM1,"Source Strength Reference Time",false },
  {0x300a,0x0230,VR::SQ,VM::VM1,"Application Setup Sequence",false },
  {0x300a,0x0232,VR::CS,VM::VM1,"Application Setup Type",false },
  {0x300a,0x0234,VR::IS,VM::VM1,"Application Setup Number",false },
  {0x300a,0x0236,VR::LO,VM::VM1,"Application Setup Name",false },
  {0x300a,0x0238,VR::LO,VM::VM1,"Application Setup Manufacturer",false },
  {0x300a,0x0240,VR::IS,VM::VM1,"Template Number",false },
  {0x300a,0x0242,VR::SH,VM::VM1,"Template Type",false },
  {0x300a,0x0244,VR::LO,VM::VM1,"Template Name",false },
  {0x300a,0x0250,VR::DS,VM::VM1,"Total Reference Air Kerma",false },
  {0x300a,0x0260,VR::SQ,VM::VM1,"Brachy Accessory Device Sequence",false },
  {0x300a,0x0262,VR::IS,VM::VM1,"Brachy Accessory Device Number",false },
  {0x300a,0x0263,VR::SH,VM::VM1,"Brachy Accessory Device ID",false },
  {0x300a,0x0264,VR::CS,VM::VM1,"Brachy Accessory Device Type",false },
  {0x300a,0x0266,VR::LO,VM::VM1,"Brachy Accessory Device Name",false },
  {0x300a,0x026a,VR::DS,VM::VM1,"Brachy Accessory Device Nominal Thickness",false },
  {0x300a,0x026c,VR::DS,VM::VM1,"Brachy Accessory Device Nominal Transmission",false },
  {0x300a,0x0280,VR::SQ,VM::VM1,"Channel Sequence",false },
  {0x300a,0x0282,VR::IS,VM::VM1,"Channel Number",false },
  {0x300a,0x0284,VR::DS,VM::VM1,"Channel Length",false },
  {0x300a,0x0286,VR::DS,VM::VM1,"Channel Total Time",false },
  {0x300a,0x0288,VR::CS,VM::VM1,"Source Movement Type",false },
  {0x300a,0x028a,VR::IS,VM::VM1,"Number of Pulses",false },
  {0x300a,0x028c,VR::DS,VM::VM1,"Pulse Repetition Interval",false },
  {0x300a,0x0290,VR::IS,VM::VM1,"Source Applicator Number",false },
  {0x300a,0x0291,VR::SH,VM::VM1,"Source Applicator ID",false },
  {0x300a,0x0292,VR::CS,VM::VM1,"Source Applicator Type",false },
  {0x300a,0x0294,VR::LO,VM::VM1,"Source Applicator Name",false },
  {0x300a,0x0296,VR::DS,VM::VM1,"Source Applicator Length",false },
  {0x300a,0x0298,VR::LO,VM::VM1,"Source Applicator Manufacturer",false },
  {0x300a,0x029c,VR::DS,VM::VM1,"Source Applicator Wall Nominal Thickness",false },
  {0x300a,0x029e,VR::DS,VM::VM1,"Source Applicator Wall Nominal Transmission",false },
  {0x300a,0x02a0,VR::DS,VM::VM1,"Source Applicator Step Size",false },
  {0x300a,0x02a2,VR::IS,VM::VM1,"Transfer Tube Number",false },
  {0x300a,0x02a4,VR::DS,VM::VM1,"Transfer Tube Length",false },
  {0x300a,0x02b0,VR::SQ,VM::VM1,"Channel Shield Sequence",false },
  {0x300a,0x02b2,VR::IS,VM::VM1,"Channel Shield Number",false },
  {0x300a,0x02b3,VR::SH,VM::VM1,"Channel Shield ID",false },
  {0x300a,0x02b4,VR::LO,VM::VM1,"Channel Shield Name",false },
  {0x300a,0x02b8,VR::DS,VM::VM1,"Channel Shield Nominal Thickness",false },
  {0x300a,0x02ba,VR::DS,VM::VM1,"Channel Shield Nominal Transmission",false },
  {0x300a,0x02c8,VR::DS,VM::VM1,"Final Cumulative Time Weight",false },
  {0x300a,0x02d0,VR::SQ,VM::VM1,"Brachy Control Point Sequence",false },
  {0x300a,0x02d2,VR::DS,VM::VM1,"Control Point Relative Position",false },
  {0x300a,0x02d4,VR::DS,VM::VM3,"Control Point 3D Position",false },
  {0x300a,0x02d6,VR::DS,VM::VM1,"Cumulative Time Weight",false },
  {0x300a,0x02e0,VR::CS,VM::VM1,"Compensator Divergence",false },
  {0x300a,0x02e1,VR::CS,VM::VM1,"Compensator Mounting Position",false },
  {0x300a,0x02e2,VR::DS,VM::VM1_n,"Source to Compensator Distance",false },
  {0x300a,0x02e3,VR::FL,VM::VM1,"Total Compensator Tray Water-Equivalent Thickness",false },
  {0x300a,0x02e4,VR::FL,VM::VM1,"Isocenter to Compensator Tray Distance",false },
  {0x300a,0x02e5,VR::FL,VM::VM1,"Compensator Column Offset",false },
  {0x300a,0x02e6,VR::FL,VM::VM1_n,"Isocenter to Compensator Distances",false },
  {0x300a,0x02e7,VR::FL,VM::VM1,"Compensator Relative Stopping Power Ratio",false },
  {0x300a,0x02e8,VR::FL,VM::VM1,"Compensator Milling Tool Diameter",false },
  {0x300a,0x02ea,VR::SQ,VM::VM1,"Ion Range Compensator Sequence",false },
  {0x300a,0x02eb,VR::LT,VM::VM1,"Compensator Description",false },
  {0x300a,0x0302,VR::IS,VM::VM1,"Radiation Mass Number",false },
  {0x300a,0x0304,VR::IS,VM::VM1,"Radiation Atomic Number",false },
  {0x300a,0x0306,VR::SS,VM::VM1,"Radiation Charge State",false },
  {0x300a,0x0308,VR::CS,VM::VM1,"Scan Mode",false },
  {0x300a,0x030a,VR::FL,VM::VM2,"Virtual Source-Axis Distances",false },
  {0x300a,0x030c,VR::SQ,VM::VM1,"Snout Sequence",false },
  {0x300a,0x030d,VR::FL,VM::VM1,"Snout Position",false },
  {0x300a,0x030f,VR::SH,VM::VM1,"Snout ID",false },
  {0x300a,0x0312,VR::IS,VM::VM1,"Number of Range Shifters",false },
  {0x300a,0x0314,VR::SQ,VM::VM1,"Range Shifter Sequence",false },
  {0x300a,0x0316,VR::IS,VM::VM1,"Range Shifter Number",false },
  {0x300a,0x0318,VR::SH,VM::VM1,"Range Shifter ID",false },
  {0x300a,0x0320,VR::CS,VM::VM1,"Range Shifter Type",false },
  {0x300a,0x0322,VR::LO,VM::VM1,"Range Shifter Description",false },
  {0x300a,0x0330,VR::IS,VM::VM1,"Number of Lateral Spreading Devices",false },
  {0x300a,0x0332,VR::SQ,VM::VM1,"Lateral Spreading Device Sequence",false },
  {0x300a,0x0334,VR::IS,VM::VM1,"Lateral Spreading Device Number",false },
  {0x300a,0x0336,VR::SH,VM::VM1,"Lateral Spreading Device ID",false },
  {0x300a,0x0338,VR::CS,VM::VM1,"Lateral Spreading Device Type",false },
  {0x300a,0x033a,VR::LO,VM::VM1,"Lateral Spreading Device Description",false },
  {0x300a,0x033c,VR::FL,VM::VM1,"Lateral Spreading Device Water Equivalent Thickness",false },
  {0x300a,0x0340,VR::IS,VM::VM1,"Number of Range Modulators",false },
  {0x300a,0x0342,VR::SQ,VM::VM1,"Range Modulator Sequence",false },
  {0x300a,0x0344,VR::IS,VM::VM1,"Range Modulator Number",false },
  {0x300a,0x0346,VR::SH,VM::VM1,"Range Modulator ID",false },
  {0x300a,0x0348,VR::CS,VM::VM1,"Range Modulator Type",false },
  {0x300a,0x034a,VR::LO,VM::VM1,"Range Modulator Description",false },
  {0x300a,0x034c,VR::SH,VM::VM1,"Beam Current Modulation ID",false },
  {0x300a,0x0350,VR::CS,VM::VM1,"Patient Support Type",false },
  {0x300a,0x0352,VR::SH,VM::VM1,"Patient Support ID",false },
  {0x300a,0x0354,VR::LO,VM::VM1,"Patient Support Accessory Code",false },
  {0x300a,0x0356,VR::FL,VM::VM1,"Fixation Light Azimuthal Angle",false },
  {0x300a,0x0358,VR::FL,VM::VM1,"Fixation Light Polar Angle",false },
  {0x300a,0x035a,VR::FL,VM::VM1,"Meterset Rate",false },
  {0x300a,0x0360,VR::SQ,VM::VM1,"Range Shifter Settings Sequence",false },
  {0x300a,0x0362,VR::LO,VM::VM1,"Range Shifter Setting",false },
  {0x300a,0x0364,VR::FL,VM::VM1,"Isocenter to Range Shifter Distance",false },
  {0x300a,0x0366,VR::FL,VM::VM1,"Range Shifter Water Equivalent Thickness",false },
  {0x300a,0x0370,VR::SQ,VM::VM1,"Lateral Spreading Device Settings Sequence",false },
  {0x300a,0x0372,VR::LO,VM::VM1,"Lateral Spreading Device Setting",false },
  {0x300a,0x0374,VR::FL,VM::VM1,"Isocenter to Lateral Spreading Device Distance",false },
  {0x300a,0x0380,VR::SQ,VM::VM1,"Range Modulator Settings Sequence",false },
  {0x300a,0x0382,VR::FL,VM::VM1,"Range Modulator Gating Start Value",false },
  {0x300a,0x0384,VR::FL,VM::VM1,"Range Modulator Gating Stop Value",false },
  {0x300a,0x0386,VR::FL,VM::VM1,"Range Modulator Gating Start Water Equivalent Thickness",false },
  {0x300a,0x0388,VR::FL,VM::VM1,"Range Modulator Gating Stop Water Equivalent Thickness",false },
  {0x300a,0x038a,VR::FL,VM::VM1,"Isocenter to Range Modulator Distance",false },
  {0x300a,0x0390,VR::SH,VM::VM1,"Scan Spot Tune ID",false },
  {0x300a,0x0392,VR::IS,VM::VM1,"Number of Scan Spot Positions",false },
  {0x300a,0x0394,VR::FL,VM::VM1_n,"Scan Spot Position Map",false },
  {0x300a,0x0396,VR::FL,VM::VM1_n,"Scan Spot Meterset Weights",false },
  {0x300a,0x0398,VR::FL,VM::VM2,"Scanning Spot Size",false },
  {0x300a,0x039a,VR::IS,VM::VM1,"Number of Paintings",false },
  {0x300a,0x03a0,VR::SQ,VM::VM1,"Ion Tolerance Table Sequence",false },
  {0x300a,0x03a2,VR::SQ,VM::VM1,"Ion Beam Sequence",false },
  {0x300a,0x03a4,VR::SQ,VM::VM1,"Ion Beam Limiting Device Sequence",false },
  {0x300a,0x03a6,VR::SQ,VM::VM1,"Ion Block Sequence",false },
  {0x300a,0x03a8,VR::SQ,VM::VM1,"Ion Control Point Sequence",false },
  {0x300a,0x03aa,VR::SQ,VM::VM1,"Ion Wedge Sequence",false },
  {0x300a,0x03ac,VR::SQ,VM::VM1,"Ion Wedge Position Sequence",false },
  {0x300a,0x0401,VR::SQ,VM::VM1,"Referenced Setup Image Sequence",false },
  {0x300a,0x0402,VR::ST,VM::VM1,"Setup Image Comment",false },
  {0x300a,0x0410,VR::SQ,VM::VM1,"Motion Synchronization Sequence",false },
  {0x300a,0x0412,VR::FL,VM::VM3,"Control Point Orientation",false },
  {0x300a,0x0420,VR::SQ,VM::VM1,"General Accessory Sequence",false },
  {0x300a,0x0421,VR::SH,VM::VM1,"General Accessory ID",false },
  {0x300a,0x0422,VR::ST,VM::VM1,"General Accessory Description",false },
  {0x300a,0x0423,VR::CS,VM::VM1,"General Accessory Type",false },
  {0x300a,0x0424,VR::IS,VM::VM1,"General Accessory Number",false },
  {0x300c,0x0002,VR::SQ,VM::VM1,"Referenced RT Plan Sequence",false },
  {0x300c,0x0004,VR::SQ,VM::VM1,"Referenced Beam Sequence",false },
  {0x300c,0x0006,VR::IS,VM::VM1,"Referenced Beam Number",false },
  {0x300c,0x0007,VR::IS,VM::VM1,"Referenced Reference Image Number",false },
  {0x300c,0x0008,VR::DS,VM::VM1,"Start Cumulative Meterset Weight",false },
  {0x300c,0x0009,VR::DS,VM::VM1,"End Cumulative Meterset Weight",false },
  {0x300c,0x000a,VR::SQ,VM::VM1,"Referenced Brachy Application Setup Sequence",false },
  {0x300c,0x000c,VR::IS,VM::VM1,"Referenced Brachy Application Setup Number",false },
  {0x300c,0x000e,VR::IS,VM::VM1,"Referenced Source Number",false },
  {0x300c,0x0020,VR::SQ,VM::VM1,"Referenced Fraction Group Sequence",false },
  {0x300c,0x0022,VR::IS,VM::VM1,"Referenced Fraction Group Number",false },
  {0x300c,0x0040,VR::SQ,VM::VM1,"Referenced Verification Image Sequence",false },
  {0x300c,0x0042,VR::SQ,VM::VM1,"Referenced Reference Image Sequence",false },
  {0x300c,0x0050,VR::SQ,VM::VM1,"Referenced Dose Reference Sequence",false },
  {0x300c,0x0051,VR::IS,VM::VM1,"Referenced Dose Reference Number",false },
  {0x300c,0x0055,VR::SQ,VM::VM1,"Brachy Referenced Dose Reference Sequence",false },
  {0x300c,0x0060,VR::SQ,VM::VM1,"Referenced Structure Set Sequence",false },
  {0x300c,0x006a,VR::IS,VM::VM1,"Referenced Patient Setup Number",false },
  {0x300c,0x0080,VR::SQ,VM::VM1,"Referenced Dose Sequence",false },
  {0x300c,0x00a0,VR::IS,VM::VM1,"Referenced Tolerance Table Number",false },
  {0x300c,0x00b0,VR::SQ,VM::VM1,"Referenced Bolus Sequence",false },
  {0x300c,0x00c0,VR::IS,VM::VM1,"Referenced Wedge Number",false },
  {0x300c,0x00d0,VR::IS,VM::VM1,"Referenced Compensator Number",false },
  {0x300c,0x00e0,VR::IS,VM::VM1,"Referenced Block Number",false },
  {0x300c,0x00f0,VR::IS,VM::VM1,"Referenced Control Point Index",false },
  {0x300c,0x00f2,VR::SQ,VM::VM1,"Referenced Control Point Sequence",false },
  {0x300c,0x00f4,VR::IS,VM::VM1,"Referenced Start Control Point Index",false },
  {0x300c,0x00f6,VR::IS,VM::VM1,"Referenced Stop Control Point Index",false },
  {0x300c,0x0100,VR::IS,VM::VM1,"Referenced Range Shifter Number",false },
  {0x300c,0x0102,VR::IS,VM::VM1,"Referenced Lateral Spreading Device Number",false },
  {0x300c,0x0104,VR::IS,VM::VM1,"Referenced Range Modulator Number",false },
  {0x300e,0x0002,VR::CS,VM::VM1,"Approval Status",false },
  {0x300e,0x0004,VR::DA,VM::VM1,"Review Date",false },
  {0x300e,0x0005,VR::TM,VM::VM1,"Review Time",false },
  {0x300e,0x0008,VR::PN,VM::VM1,"Reviewer Name",false },
  {0x4000,0x0010,VR::LT,VM::VM1,"Arbitrary",true },
  {0x4000,0x4000,VR::LT,VM::VM1,"Text Comments",true },
  {0x4008,0x0040,VR::SH,VM::VM1,"Results ID",true },
  {0x4008,0x0042,VR::LO,VM::VM1,"Results ID Issuer",true },
  {0x4008,0x0050,VR::SQ,VM::VM1,"Referenced Interpretation Sequence",true },
  {0x4008,0x0100,VR::DA,VM::VM1,"Interpretation Recorded Date",true },
  {0x4008,0x0101,VR::TM,VM::VM1,"Interpretation Recorded Time",true },
  {0x4008,0x0102,VR::PN,VM::VM1,"Interpretation Recorder",true },
  {0x4008,0x0103,VR::LO,VM::VM1,"Reference to Recorded Sound",true },
  {0x4008,0x0108,VR::DA,VM::VM1,"Interpretation Transcription Date",true },
  {0x4008,0x0109,VR::TM,VM::VM1,"Interpretation Transcription Time",true },
  {0x4008,0x010a,VR::PN,VM::VM1,"Interpretation Transcriber",true },
  {0x4008,0x010b,VR::ST,VM::VM1,"Interpretation Text",true },
  {0x4008,0x010c,VR::PN,VM::VM1,"Interpretation Author",true },
  {0x4008,0x0111,VR::SQ,VM::VM1,"Interpretation Approver Sequence",true },
  {0x4008,0x0112,VR::DA,VM::VM1,"Interpretation Approval Date",true },
  {0x4008,0x0113,VR::TM,VM::VM1,"Interpretation Approval Time",true },
  {0x4008,0x0114,VR::PN,VM::VM1,"Physician Approving Interpretation",true },
  {0x4008,0x0115,VR::LT,VM::VM1,"Interpretation Diagnosis Description",true },
  {0x4008,0x0117,VR::SQ,VM::VM1,"Interpretation Diagnosis Code Sequence",true },
  {0x4008,0x0118,VR::SQ,VM::VM1,"Results Distribution List Sequence",true },
  {0x4008,0x0119,VR::PN,VM::VM1,"Distribution Name",true },
  {0x4008,0x011a,VR::LO,VM::VM1,"Distribution Address",true },
  {0x4008,0x0200,VR::SH,VM::VM1,"Interpretation ID",true },
  {0x4008,0x0202,VR::LO,VM::VM1,"Interpretation ID Issuer",true },
  {0x4008,0x0210,VR::CS,VM::VM1,"Interpretation Type ID",true },
  {0x4008,0x0212,VR::CS,VM::VM1,"Interpretation Status ID",true },
  {0x4008,0x0300,VR::ST,VM::VM1,"Impressions",true },
  {0x4008,0x4000,VR::ST,VM::VM1,"Results Comments",true },
  {0x4ffe,0x0001,VR::SQ,VM::VM1,"MAC Parameters Sequence",false },
  {0x5000,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5002,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5004,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5006,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5008,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x500a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x500c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x500e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5010,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5012,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5014,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5016,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5018,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x501a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x501c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x501e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5020,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5022,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5024,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5026,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5028,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x502a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x502c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x502e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5030,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5032,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5034,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5036,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5038,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x503a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x503c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x503e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5040,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5042,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5044,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5046,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5048,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x504a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x504c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x504e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5050,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5052,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5054,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5056,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5058,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x505a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x505c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x505e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5060,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5062,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5064,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5066,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5068,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x506a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x506c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x506e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5070,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5072,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5074,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5076,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5078,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x507a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x507c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x507e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5080,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5082,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5084,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5086,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5088,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x508a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x508c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x508e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5090,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5092,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5094,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5096,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5098,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x509a,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x509c,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x509e,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50a0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50a2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50a4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50a6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50a8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50aa,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ac,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ae,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50b0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50b2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50b4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50b6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50b8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ba,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50bc,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50be,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50c0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50c2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50c4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50c6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50c8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ca,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50cc,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ce,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50d0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50d2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50d4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50d6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50d8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50da,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50dc,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50de,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50e0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50e2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50e4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50e6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50e8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ea,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ec,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50ee,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50f0,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50f2,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50f4,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50f6,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50f8,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50fa,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50fc,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x50fe,0x0005,VR::US,VM::VM1,"Curve Dimensions",true },
  {0x5000,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5002,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5004,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5006,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5008,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x500a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x500c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x500e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5010,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5012,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5014,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5016,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5018,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x501a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x501c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x501e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5020,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5022,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5024,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5026,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5028,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x502a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x502c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x502e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5030,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5032,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5034,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5036,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5038,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x503a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x503c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x503e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5040,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5042,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5044,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5046,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5048,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x504a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x504c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x504e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5050,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5052,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5054,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5056,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5058,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x505a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x505c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x505e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5060,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5062,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5064,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5066,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5068,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x506a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x506c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x506e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5070,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5072,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5074,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5076,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5078,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x507a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x507c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x507e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5080,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5082,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5084,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5086,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5088,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x508a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x508c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x508e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5090,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5092,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5094,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5096,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5098,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x509a,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x509c,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x509e,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50a0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50a2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50a4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50a6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50a8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50aa,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ac,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ae,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50b0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50b2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50b4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50b6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50b8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ba,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50bc,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50be,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50c0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50c2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50c4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50c6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50c8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ca,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50cc,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ce,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50d0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50d2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50d4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50d6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50d8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50da,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50dc,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50de,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50e0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50e2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50e4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50e6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50e8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ea,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ec,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50ee,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50f0,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50f2,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50f4,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50f6,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50f8,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50fa,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50fc,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x50fe,0x0010,VR::US,VM::VM1,"Number of Points",true },
  {0x5000,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5002,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5004,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5006,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5008,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x500a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x500c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x500e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5010,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5012,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5014,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5016,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5018,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x501a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x501c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x501e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5020,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5022,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5024,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5026,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5028,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x502a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x502c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x502e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5030,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5032,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5034,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5036,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5038,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x503a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x503c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x503e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5040,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5042,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5044,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5046,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5048,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x504a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x504c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x504e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5050,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5052,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5054,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5056,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5058,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x505a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x505c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x505e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5060,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5062,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5064,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5066,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5068,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x506a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x506c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x506e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5070,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5072,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5074,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5076,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5078,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x507a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x507c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x507e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5080,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5082,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5084,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5086,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5088,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x508a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x508c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x508e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5090,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5092,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5094,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5096,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5098,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x509a,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x509c,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x509e,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50a0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50a2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50a4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50a6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50a8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50aa,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ac,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ae,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50b0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50b2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50b4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50b6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50b8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ba,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50bc,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50be,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50c0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50c2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50c4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50c6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50c8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ca,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50cc,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ce,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50d0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50d2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50d4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50d6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50d8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50da,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50dc,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50de,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50e0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50e2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50e4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50e6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50e8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ea,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ec,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50ee,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50f0,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50f2,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50f4,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50f6,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50f8,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50fa,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50fc,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x50fe,0x0020,VR::CS,VM::VM1,"Type of Data",true },
  {0x5000,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5002,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5004,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5006,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5008,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x500a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x500c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x500e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5010,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5012,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5014,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5016,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5018,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x501a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x501c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x501e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5020,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5022,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5024,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5026,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5028,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x502a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x502c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x502e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5030,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5032,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5034,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5036,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5038,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x503a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x503c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x503e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5040,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5042,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5044,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5046,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5048,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x504a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x504c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x504e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5050,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5052,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5054,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5056,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5058,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x505a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x505c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x505e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5060,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5062,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5064,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5066,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5068,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x506a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x506c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x506e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5070,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5072,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5074,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5076,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5078,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x507a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x507c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x507e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5080,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5082,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5084,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5086,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5088,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x508a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x508c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x508e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5090,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5092,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5094,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5096,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5098,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x509a,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x509c,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x509e,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50a0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50a2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50a4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50a6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50a8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50aa,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ac,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ae,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50b0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50b2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50b4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50b6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50b8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ba,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50bc,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50be,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50c0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50c2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50c4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50c6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50c8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ca,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50cc,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ce,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50d0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50d2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50d4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50d6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50d8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50da,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50dc,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50de,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50e0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50e2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50e4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50e6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50e8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ea,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ec,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50ee,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50f0,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50f2,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50f4,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50f6,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50f8,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50fa,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50fc,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x50fe,0x0022,VR::LO,VM::VM1,"Curve Description",true },
  {0x5000,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5002,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5004,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5006,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5008,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x500a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x500c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x500e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5010,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5012,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5014,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5016,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5018,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x501a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x501c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x501e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5020,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5022,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5024,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5026,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5028,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x502a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x502c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x502e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5030,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5032,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5034,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5036,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5038,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x503a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x503c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x503e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5040,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5042,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5044,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5046,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5048,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x504a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x504c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x504e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5050,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5052,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5054,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5056,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5058,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x505a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x505c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x505e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5060,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5062,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5064,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5066,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5068,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x506a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x506c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x506e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5070,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5072,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5074,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5076,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5078,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x507a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x507c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x507e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5080,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5082,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5084,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5086,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5088,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x508a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x508c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x508e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5090,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5092,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5094,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5096,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5098,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x509a,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x509c,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x509e,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50a0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50a2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50a4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50a6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50a8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50aa,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ac,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ae,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50b0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50b2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50b4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50b6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50b8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ba,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50bc,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50be,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50c0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50c2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50c4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50c6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50c8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ca,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50cc,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ce,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50d0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50d2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50d4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50d6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50d8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50da,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50dc,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50de,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50e0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50e2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50e4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50e6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50e8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ea,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ec,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50ee,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50f0,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50f2,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50f4,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50f6,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50f8,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50fa,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50fc,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x50fe,0x0030,VR::SH,VM::VM1_n,"Axis Units",true },
  {0x5000,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5002,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5004,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5006,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5008,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x500a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x500c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x500e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5010,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5012,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5014,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5016,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5018,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x501a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x501c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x501e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5020,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5022,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5024,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5026,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5028,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x502a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x502c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x502e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5030,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5032,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5034,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5036,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5038,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x503a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x503c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x503e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5040,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5042,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5044,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5046,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5048,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x504a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x504c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x504e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5050,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5052,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5054,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5056,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5058,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x505a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x505c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x505e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5060,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5062,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5064,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5066,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5068,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x506a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x506c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x506e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5070,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5072,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5074,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5076,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5078,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x507a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x507c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x507e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5080,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5082,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5084,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5086,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5088,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x508a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x508c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x508e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5090,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5092,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5094,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5096,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5098,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x509a,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x509c,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x509e,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50a0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50a2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50a4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50a6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50a8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50aa,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ac,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ae,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50b0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50b2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50b4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50b6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50b8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ba,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50bc,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50be,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50c0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50c2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50c4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50c6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50c8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ca,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50cc,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ce,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50d0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50d2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50d4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50d6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50d8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50da,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50dc,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50de,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50e0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50e2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50e4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50e6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50e8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ea,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ec,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50ee,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50f0,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50f2,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50f4,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50f6,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50f8,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50fa,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50fc,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x50fe,0x0040,VR::SH,VM::VM1_n,"Axis Labels",true },
  {0x5000,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5002,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5004,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5006,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5008,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x500a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x500c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x500e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5010,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5012,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5014,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5016,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5018,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x501a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x501c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x501e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5020,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5022,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5024,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5026,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5028,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x502a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x502c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x502e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5030,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5032,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5034,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5036,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5038,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x503a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x503c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x503e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5040,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5042,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5044,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5046,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5048,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x504a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x504c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x504e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5050,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5052,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5054,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5056,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5058,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x505a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x505c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x505e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5060,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5062,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5064,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5066,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5068,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x506a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x506c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x506e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5070,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5072,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5074,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5076,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5078,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x507a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x507c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x507e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5080,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5082,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5084,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5086,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5088,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x508a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x508c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x508e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5090,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5092,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5094,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5096,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5098,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x509a,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x509c,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x509e,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50a0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50a2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50a4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50a6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50a8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50aa,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ac,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ae,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50b0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50b2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50b4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50b6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50b8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ba,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50bc,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50be,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50c0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50c2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50c4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50c6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50c8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ca,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50cc,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ce,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50d0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50d2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50d4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50d6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50d8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50da,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50dc,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50de,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50e0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50e2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50e4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50e6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50e8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ea,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ec,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50ee,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50f0,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50f2,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50f4,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50f6,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50f8,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50fa,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50fc,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x50fe,0x0103,VR::US,VM::VM1,"Data Value Representation",true },
  {0x5000,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5002,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5004,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5006,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5008,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x500a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x500c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x500e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5010,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5012,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5014,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5016,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5018,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x501a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x501c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x501e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5020,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5022,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5024,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5026,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5028,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x502a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x502c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x502e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5030,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5032,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5034,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5036,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5038,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x503a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x503c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x503e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5040,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5042,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5044,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5046,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5048,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x504a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x504c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x504e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5050,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5052,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5054,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5056,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5058,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x505a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x505c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x505e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5060,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5062,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5064,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5066,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5068,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x506a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x506c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x506e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5070,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5072,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5074,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5076,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5078,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x507a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x507c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x507e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5080,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5082,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5084,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5086,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5088,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x508a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x508c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x508e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5090,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5092,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5094,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5096,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5098,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x509a,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x509c,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x509e,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50a0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50a2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50a4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50a6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50a8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50aa,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ac,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ae,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50b0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50b2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50b4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50b6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50b8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ba,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50bc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50be,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50c0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50c2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50c4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50c6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50c8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ca,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50cc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ce,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50d0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50d2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50d4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50d6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50d8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50da,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50dc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50de,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50e0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50e2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50e4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50e6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50e8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ea,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ec,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50ee,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50f0,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50f2,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50f4,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50f6,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50f8,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50fa,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50fc,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x50fe,0x0104,VR::US,VM::VM1_n,"Minimum Coordinate Value",true },
  {0x5000,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5002,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5004,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5006,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5008,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x500a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x500c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x500e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5010,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5012,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5014,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5016,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5018,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x501a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x501c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x501e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5020,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5022,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5024,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5026,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5028,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x502a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x502c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x502e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5030,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5032,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5034,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5036,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5038,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x503a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x503c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x503e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5040,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5042,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5044,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5046,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5048,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x504a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x504c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x504e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5050,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5052,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5054,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5056,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5058,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x505a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x505c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x505e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5060,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5062,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5064,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5066,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5068,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x506a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x506c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x506e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5070,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5072,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5074,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5076,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5078,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x507a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x507c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x507e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5080,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5082,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5084,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5086,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5088,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x508a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x508c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x508e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5090,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5092,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5094,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5096,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5098,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x509a,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x509c,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x509e,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50a0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50a2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50a4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50a6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50a8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50aa,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ac,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ae,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50b0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50b2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50b4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50b6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50b8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ba,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50bc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50be,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50c0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50c2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50c4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50c6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50c8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ca,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50cc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ce,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50d0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50d2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50d4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50d6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50d8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50da,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50dc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50de,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50e0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50e2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50e4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50e6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50e8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ea,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ec,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50ee,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50f0,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50f2,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50f4,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50f6,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50f8,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50fa,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50fc,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x50fe,0x0105,VR::US,VM::VM1_n,"Maximum Coordinate Value",true },
  {0x5000,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5002,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5004,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5006,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5008,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x500a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x500c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x500e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5010,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5012,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5014,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5016,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5018,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x501a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x501c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x501e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5020,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5022,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5024,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5026,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5028,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x502a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x502c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x502e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5030,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5032,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5034,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5036,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5038,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x503a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x503c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x503e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5040,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5042,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5044,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5046,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5048,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x504a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x504c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x504e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5050,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5052,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5054,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5056,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5058,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x505a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x505c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x505e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5060,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5062,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5064,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5066,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5068,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x506a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x506c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x506e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5070,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5072,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5074,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5076,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5078,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x507a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x507c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x507e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5080,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5082,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5084,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5086,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5088,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x508a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x508c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x508e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5090,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5092,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5094,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5096,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5098,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x509a,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x509c,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x509e,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50a0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50a2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50a4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50a6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50a8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50aa,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ac,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ae,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50b0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50b2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50b4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50b6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50b8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ba,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50bc,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50be,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50c0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50c2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50c4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50c6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50c8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ca,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50cc,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ce,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50d0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50d2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50d4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50d6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50d8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50da,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50dc,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50de,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50e0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50e2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50e4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50e6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50e8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ea,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ec,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50ee,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50f0,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50f2,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50f4,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50f6,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50f8,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50fa,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50fc,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x50fe,0x0106,VR::SH,VM::VM1_n,"Curve Range",true },
  {0x5000,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5002,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5004,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5006,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5008,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x500a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x500c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x500e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5010,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5012,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5014,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5016,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5018,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x501a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x501c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x501e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5020,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5022,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5024,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5026,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5028,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x502a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x502c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x502e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5030,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5032,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5034,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5036,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5038,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x503a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x503c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x503e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5040,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5042,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5044,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5046,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5048,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x504a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x504c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x504e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5050,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5052,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5054,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5056,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5058,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x505a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x505c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x505e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5060,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5062,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5064,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5066,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5068,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x506a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x506c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x506e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5070,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5072,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5074,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5076,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5078,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x507a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x507c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x507e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5080,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5082,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5084,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5086,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5088,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x508a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x508c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x508e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5090,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5092,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5094,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5096,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5098,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x509a,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x509c,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x509e,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50a0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50a2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50a4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50a6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50a8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50aa,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ac,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ae,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50b0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50b2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50b4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50b6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50b8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ba,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50bc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50be,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50c0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50c2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50c4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50c6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50c8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ca,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50cc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ce,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50d0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50d2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50d4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50d6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50d8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50da,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50dc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50de,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50e0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50e2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50e4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50e6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50e8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ea,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ec,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50ee,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50f0,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50f2,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50f4,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50f6,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50f8,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50fa,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50fc,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x50fe,0x0110,VR::US,VM::VM1_n,"Curve Data Descriptor",true },
  {0x5000,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5002,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5004,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5006,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5008,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x500a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x500c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x500e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5010,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5012,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5014,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5016,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5018,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x501a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x501c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x501e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5020,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5022,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5024,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5026,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5028,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x502a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x502c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x502e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5030,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5032,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5034,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5036,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5038,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x503a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x503c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x503e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5040,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5042,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5044,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5046,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5048,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x504a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x504c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x504e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5050,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5052,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5054,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5056,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5058,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x505a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x505c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x505e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5060,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5062,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5064,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5066,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5068,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x506a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x506c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x506e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5070,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5072,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5074,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5076,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5078,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x507a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x507c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x507e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5080,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5082,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5084,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5086,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5088,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x508a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x508c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x508e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5090,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5092,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5094,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5096,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5098,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x509a,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x509c,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x509e,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50a0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50a2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50a4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50a6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50a8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50aa,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ac,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ae,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50b0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50b2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50b4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50b6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50b8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ba,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50bc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50be,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50c0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50c2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50c4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50c6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50c8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ca,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50cc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ce,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50d0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50d2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50d4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50d6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50d8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50da,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50dc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50de,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50e0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50e2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50e4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50e6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50e8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ea,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ec,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50ee,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50f0,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50f2,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50f4,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50f6,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50f8,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50fa,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50fc,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x50fe,0x0112,VR::US,VM::VM1_n,"Coordinate Start Value",true },
  {0x5000,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5002,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5004,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5006,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5008,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x500a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x500c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x500e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5010,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5012,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5014,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5016,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5018,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x501a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x501c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x501e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5020,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5022,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5024,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5026,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5028,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x502a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x502c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x502e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5030,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5032,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5034,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5036,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5038,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x503a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x503c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x503e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5040,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5042,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5044,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5046,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5048,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x504a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x504c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x504e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5050,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5052,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5054,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5056,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5058,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x505a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x505c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x505e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5060,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5062,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5064,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5066,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5068,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x506a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x506c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x506e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5070,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5072,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5074,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5076,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5078,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x507a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x507c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x507e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5080,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5082,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5084,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5086,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5088,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x508a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x508c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x508e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5090,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5092,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5094,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5096,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5098,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x509a,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x509c,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x509e,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50a0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50a2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50a4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50a6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50a8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50aa,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ac,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ae,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50b0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50b2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50b4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50b6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50b8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ba,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50bc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50be,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50c0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50c2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50c4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50c6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50c8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ca,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50cc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ce,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50d0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50d2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50d4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50d6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50d8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50da,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50dc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50de,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50e0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50e2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50e4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50e6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50e8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ea,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ec,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50ee,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50f0,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50f2,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50f4,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50f6,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50f8,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50fa,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50fc,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x50fe,0x0114,VR::US,VM::VM1_n,"Coordinate Step Value",true },
  {0x5000,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5002,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5004,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5006,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5008,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x500a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x500c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x500e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5010,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5012,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5014,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5016,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5018,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x501a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x501c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x501e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5020,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5022,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5024,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5026,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5028,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x502a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x502c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x502e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5030,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5032,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5034,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5036,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5038,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x503a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x503c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x503e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5040,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5042,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5044,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5046,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5048,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x504a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x504c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x504e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5050,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5052,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5054,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5056,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5058,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x505a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x505c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x505e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5060,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5062,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5064,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5066,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5068,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x506a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x506c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x506e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5070,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5072,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5074,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5076,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5078,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x507a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x507c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x507e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5080,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5082,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5084,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5086,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5088,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x508a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x508c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x508e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5090,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5092,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5094,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5096,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5098,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x509a,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x509c,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x509e,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50a0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50a2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50a4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50a6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50a8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50aa,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ac,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ae,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50b0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50b2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50b4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50b6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50b8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ba,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50bc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50be,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50c0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50c2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50c4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50c6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50c8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ca,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50cc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ce,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50d0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50d2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50d4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50d6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50d8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50da,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50dc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50de,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50e0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50e2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50e4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50e6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50e8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ea,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ec,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50ee,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50f0,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50f2,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50f4,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50f6,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50f8,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50fa,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50fc,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x50fe,0x1001,VR::CS,VM::VM1,"Curve Activation Layer",true },
  {0x5000,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5002,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5004,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5006,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5008,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x500a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x500c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x500e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5010,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5012,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5014,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5016,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5018,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x501a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x501c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x501e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5020,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5022,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5024,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5026,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5028,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x502a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x502c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x502e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5030,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5032,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5034,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5036,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5038,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x503a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x503c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x503e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5040,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5042,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5044,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5046,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5048,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x504a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x504c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x504e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5050,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5052,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5054,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5056,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5058,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x505a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x505c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x505e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5060,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5062,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5064,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5066,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5068,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x506a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x506c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x506e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5070,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5072,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5074,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5076,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5078,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x507a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x507c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x507e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5080,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5082,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5084,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5086,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5088,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x508a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x508c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x508e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5090,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5092,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5094,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5096,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5098,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x509a,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x509c,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x509e,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50a0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50a2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50a4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50a6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50a8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50aa,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ac,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ae,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50b0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50b2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50b4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50b6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50b8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ba,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50bc,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50be,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50c0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50c2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50c4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50c6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50c8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ca,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50cc,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ce,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50d0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50d2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50d4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50d6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50d8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50da,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50dc,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50de,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50e0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50e2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50e4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50e6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50e8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ea,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ec,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50ee,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50f0,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50f2,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50f4,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50f6,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50f8,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50fa,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50fc,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x50fe,0x2000,VR::US,VM::VM1,"Audio Type",true },
  {0x5000,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5002,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5004,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5006,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5008,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x500a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x500c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x500e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5010,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5012,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5014,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5016,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5018,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x501a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x501c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x501e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5020,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5022,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5024,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5026,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5028,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x502a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x502c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x502e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5030,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5032,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5034,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5036,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5038,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x503a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x503c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x503e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5040,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5042,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5044,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5046,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5048,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x504a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x504c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x504e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5050,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5052,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5054,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5056,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5058,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x505a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x505c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x505e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5060,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5062,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5064,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5066,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5068,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x506a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x506c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x506e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5070,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5072,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5074,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5076,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5078,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x507a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x507c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x507e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5080,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5082,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5084,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5086,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5088,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x508a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x508c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x508e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5090,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5092,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5094,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5096,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5098,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x509a,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x509c,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x509e,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50a0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50a2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50a4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50a6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50a8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50aa,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ac,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ae,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50b0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50b2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50b4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50b6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50b8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ba,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50bc,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50be,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50c0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50c2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50c4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50c6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50c8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ca,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50cc,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ce,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50d0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50d2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50d4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50d6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50d8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50da,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50dc,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50de,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50e0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50e2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50e4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50e6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50e8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ea,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ec,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50ee,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50f0,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50f2,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50f4,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50f6,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50f8,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50fa,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50fc,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x50fe,0x2002,VR::US,VM::VM1,"Audio Sample Format",true },
  {0x5000,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5002,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5004,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5006,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5008,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x500a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x500c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x500e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5010,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5012,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5014,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5016,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5018,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x501a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x501c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x501e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5020,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5022,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5024,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5026,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5028,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x502a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x502c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x502e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5030,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5032,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5034,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5036,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5038,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x503a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x503c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x503e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5040,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5042,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5044,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5046,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5048,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x504a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x504c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x504e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5050,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5052,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5054,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5056,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5058,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x505a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x505c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x505e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5060,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5062,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5064,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5066,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5068,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x506a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x506c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x506e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5070,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5072,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5074,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5076,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5078,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x507a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x507c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x507e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5080,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5082,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5084,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5086,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5088,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x508a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x508c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x508e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5090,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5092,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5094,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5096,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5098,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x509a,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x509c,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x509e,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50a0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50a2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50a4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50a6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50a8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50aa,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ac,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ae,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50b0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50b2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50b4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50b6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50b8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ba,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50bc,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50be,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50c0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50c2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50c4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50c6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50c8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ca,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50cc,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ce,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50d0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50d2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50d4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50d6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50d8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50da,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50dc,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50de,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50e0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50e2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50e4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50e6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50e8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ea,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ec,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50ee,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50f0,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50f2,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50f4,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50f6,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50f8,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50fa,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50fc,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x50fe,0x2004,VR::US,VM::VM1,"Number of Channels",true },
  {0x5000,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5002,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5004,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5006,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5008,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x500a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x500c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x500e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5010,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5012,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5014,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5016,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5018,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x501a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x501c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x501e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5020,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5022,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5024,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5026,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5028,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x502a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x502c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x502e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5030,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5032,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5034,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5036,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5038,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x503a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x503c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x503e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5040,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5042,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5044,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5046,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5048,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x504a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x504c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x504e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5050,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5052,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5054,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5056,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5058,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x505a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x505c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x505e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5060,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5062,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5064,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5066,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5068,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x506a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x506c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x506e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5070,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5072,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5074,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5076,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5078,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x507a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x507c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x507e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5080,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5082,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5084,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5086,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5088,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x508a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x508c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x508e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5090,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5092,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5094,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5096,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5098,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x509a,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x509c,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x509e,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50a0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50a2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50a4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50a6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50a8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50aa,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ac,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ae,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50b0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50b2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50b4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50b6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50b8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ba,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50bc,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50be,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50c0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50c2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50c4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50c6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50c8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ca,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50cc,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ce,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50d0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50d2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50d4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50d6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50d8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50da,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50dc,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50de,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50e0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50e2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50e4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50e6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50e8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ea,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ec,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50ee,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50f0,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50f2,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50f4,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50f6,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50f8,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50fa,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50fc,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x50fe,0x2006,VR::UL,VM::VM1,"Number of Samples",true },
  {0x5000,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5002,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5004,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5006,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5008,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x500a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x500c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x500e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5010,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5012,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5014,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5016,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5018,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x501a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x501c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x501e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5020,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5022,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5024,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5026,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5028,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x502a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x502c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x502e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5030,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5032,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5034,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5036,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5038,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x503a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x503c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x503e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5040,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5042,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5044,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5046,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5048,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x504a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x504c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x504e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5050,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5052,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5054,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5056,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5058,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x505a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x505c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x505e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5060,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5062,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5064,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5066,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5068,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x506a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x506c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x506e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5070,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5072,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5074,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5076,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5078,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x507a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x507c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x507e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5080,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5082,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5084,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5086,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5088,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x508a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x508c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x508e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5090,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5092,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5094,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5096,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5098,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x509a,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x509c,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x509e,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50a0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50a2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50a4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50a6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50a8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50aa,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ac,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ae,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50b0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50b2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50b4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50b6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50b8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ba,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50bc,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50be,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50c0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50c2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50c4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50c6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50c8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ca,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50cc,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ce,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50d0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50d2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50d4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50d6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50d8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50da,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50dc,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50de,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50e0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50e2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50e4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50e6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50e8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ea,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ec,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50ee,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50f0,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50f2,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50f4,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50f6,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50f8,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50fa,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50fc,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x50fe,0x2008,VR::UL,VM::VM1,"Sample Rate",true },
  {0x5000,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5002,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5004,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5006,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5008,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x500a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x500c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x500e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5010,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5012,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5014,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5016,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5018,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x501a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x501c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x501e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5020,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5022,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5024,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5026,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5028,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x502a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x502c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x502e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5030,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5032,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5034,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5036,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5038,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x503a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x503c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x503e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5040,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5042,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5044,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5046,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5048,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x504a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x504c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x504e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5050,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5052,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5054,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5056,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5058,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x505a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x505c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x505e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5060,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5062,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5064,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5066,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5068,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x506a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x506c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x506e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5070,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5072,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5074,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5076,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5078,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x507a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x507c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x507e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5080,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5082,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5084,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5086,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5088,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x508a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x508c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x508e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5090,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5092,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5094,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5096,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5098,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x509a,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x509c,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x509e,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50a0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50a2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50a4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50a6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50a8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50aa,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ac,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ae,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50b0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50b2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50b4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50b6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50b8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ba,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50bc,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50be,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50c0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50c2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50c4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50c6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50c8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ca,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50cc,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ce,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50d0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50d2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50d4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50d6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50d8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50da,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50dc,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50de,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50e0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50e2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50e4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50e6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50e8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ea,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ec,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50ee,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50f0,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50f2,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50f4,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50f6,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50f8,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50fa,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50fc,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x50fe,0x200a,VR::UL,VM::VM1,"Total Time",true },
  {0x5000,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5002,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5004,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5006,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5008,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x500a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x500c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x500e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5010,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5012,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5014,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5016,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5018,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x501a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x501c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x501e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5020,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5022,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5024,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5026,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5028,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x502a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x502c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x502e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5030,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5032,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5034,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5036,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5038,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x503a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x503c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x503e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5040,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5042,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5044,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5046,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5048,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x504a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x504c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x504e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5050,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5052,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5054,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5056,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5058,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x505a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x505c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x505e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5060,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5062,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5064,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5066,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5068,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x506a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x506c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x506e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5070,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5072,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5074,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5076,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5078,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x507a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x507c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x507e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5080,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5082,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5084,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5086,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5088,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x508a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x508c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x508e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5090,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5092,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5094,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5096,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5098,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x509a,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x509c,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x509e,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50a0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50a2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50a4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50a6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50a8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50aa,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ac,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ae,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50b0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50b2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50b4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50b6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50b8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ba,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50bc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50be,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50c0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50c2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50c4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50c6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50c8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ca,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50cc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ce,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50d0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50d2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50d4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50d6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50d8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50da,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50dc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50de,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50e0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50e2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50e4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50e6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50e8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ea,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ec,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50ee,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50f0,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50f2,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50f4,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50f6,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50f8,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50fa,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50fc,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x50fe,0x200c,VR::OB_OW,VM::VM1,"Audio Sample Data",true },
  {0x5000,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5002,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5004,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5006,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5008,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x500a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x500c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x500e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5010,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5012,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5014,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5016,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5018,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x501a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x501c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x501e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5020,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5022,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5024,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5026,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5028,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x502a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x502c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x502e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5030,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5032,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5034,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5036,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5038,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x503a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x503c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x503e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5040,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5042,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5044,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5046,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5048,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x504a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x504c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x504e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5050,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5052,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5054,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5056,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5058,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x505a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x505c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x505e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5060,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5062,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5064,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5066,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5068,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x506a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x506c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x506e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5070,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5072,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5074,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5076,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5078,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x507a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x507c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x507e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5080,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5082,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5084,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5086,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5088,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x508a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x508c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x508e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5090,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5092,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5094,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5096,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5098,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x509a,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x509c,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x509e,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50a0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50a2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50a4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50a6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50a8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50aa,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ac,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ae,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50b0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50b2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50b4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50b6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50b8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ba,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50bc,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50be,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50c0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50c2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50c4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50c6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50c8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ca,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50cc,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ce,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50d0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50d2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50d4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50d6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50d8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50da,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50dc,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50de,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50e0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50e2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50e4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50e6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50e8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ea,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ec,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50ee,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50f0,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50f2,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50f4,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50f6,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50f8,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50fa,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50fc,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x50fe,0x200e,VR::LT,VM::VM1,"Audio Comments",true },
  {0x5000,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5002,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5004,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5006,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5008,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x500a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x500c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x500e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5010,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5012,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5014,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5016,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5018,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x501a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x501c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x501e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5020,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5022,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5024,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5026,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5028,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x502a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x502c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x502e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5030,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5032,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5034,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5036,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5038,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x503a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x503c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x503e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5040,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5042,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5044,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5046,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5048,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x504a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x504c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x504e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5050,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5052,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5054,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5056,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5058,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x505a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x505c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x505e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5060,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5062,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5064,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5066,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5068,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x506a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x506c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x506e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5070,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5072,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5074,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5076,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5078,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x507a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x507c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x507e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5080,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5082,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5084,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5086,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5088,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x508a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x508c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x508e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5090,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5092,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5094,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5096,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5098,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x509a,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x509c,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x509e,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50a0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50a2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50a4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50a6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50a8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50aa,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ac,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ae,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50b0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50b2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50b4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50b6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50b8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ba,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50bc,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50be,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50c0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50c2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50c4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50c6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50c8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ca,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50cc,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ce,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50d0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50d2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50d4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50d6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50d8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50da,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50dc,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50de,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50e0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50e2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50e4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50e6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50e8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ea,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ec,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50ee,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50f0,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50f2,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50f4,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50f6,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50f8,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50fa,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50fc,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x50fe,0x2500,VR::LO,VM::VM1,"Curve Label",true },
  {0x5000,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5002,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5004,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5006,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5008,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x500a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x500c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x500e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5010,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5012,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5014,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5016,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5018,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x501a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x501c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x501e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5020,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5022,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5024,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5026,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5028,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x502a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x502c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x502e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5030,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5032,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5034,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5036,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5038,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x503a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x503c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x503e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5040,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5042,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5044,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5046,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5048,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x504a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x504c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x504e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5050,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5052,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5054,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5056,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5058,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x505a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x505c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x505e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5060,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5062,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5064,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5066,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5068,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x506a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x506c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x506e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5070,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5072,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5074,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5076,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5078,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x507a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x507c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x507e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5080,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5082,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5084,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5086,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5088,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x508a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x508c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x508e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5090,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5092,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5094,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5096,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5098,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x509a,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x509c,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x509e,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50a0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50a2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50a4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50a6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50a8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50aa,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ac,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ae,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50b0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50b2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50b4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50b6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50b8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ba,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50bc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50be,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50c0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50c2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50c4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50c6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50c8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ca,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50cc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ce,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50d0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50d2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50d4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50d6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50d8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50da,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50dc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50de,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50e0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50e2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50e4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50e6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50e8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ea,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ec,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50ee,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50f0,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50f2,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50f4,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50f6,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50f8,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50fa,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50fc,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x50fe,0x2600,VR::SQ,VM::VM1,"Curve Referenced Overlay Sequence",true },
  {0x5000,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5002,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5004,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5006,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5008,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x500a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x500c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x500e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5010,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5012,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5014,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5016,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5018,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x501a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x501c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x501e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5020,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5022,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5024,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5026,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5028,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x502a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x502c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x502e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5030,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5032,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5034,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5036,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5038,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x503a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x503c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x503e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5040,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5042,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5044,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5046,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5048,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x504a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x504c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x504e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5050,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5052,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5054,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5056,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5058,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x505a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x505c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x505e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5060,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5062,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5064,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5066,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5068,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x506a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x506c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x506e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5070,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5072,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5074,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5076,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5078,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x507a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x507c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x507e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5080,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5082,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5084,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5086,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5088,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x508a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x508c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x508e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5090,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5092,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5094,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5096,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5098,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x509a,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x509c,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x509e,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50a0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50a2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50a4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50a6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50a8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50aa,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ac,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ae,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50b0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50b2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50b4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50b6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50b8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ba,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50bc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50be,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50c0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50c2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50c4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50c6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50c8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ca,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50cc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ce,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50d0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50d2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50d4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50d6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50d8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50da,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50dc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50de,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50e0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50e2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50e4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50e6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50e8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ea,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ec,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50ee,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50f0,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50f2,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50f4,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50f6,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50f8,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50fa,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50fc,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x50fe,0x2610,VR::US,VM::VM1,"Curve Referenced Overlay Group",true },
  {0x5000,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5002,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5004,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5006,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5008,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x500a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x500c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x500e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5010,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5012,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5014,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5016,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5018,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x501a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x501c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x501e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5020,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5022,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5024,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5026,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5028,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x502a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x502c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x502e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5030,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5032,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5034,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5036,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5038,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x503a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x503c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x503e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5040,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5042,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5044,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5046,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5048,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x504a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x504c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x504e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5050,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5052,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5054,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5056,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5058,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x505a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x505c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x505e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5060,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5062,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5064,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5066,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5068,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x506a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x506c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x506e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5070,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5072,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5074,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5076,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5078,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x507a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x507c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x507e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5080,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5082,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5084,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5086,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5088,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x508a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x508c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x508e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5090,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5092,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5094,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5096,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5098,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x509a,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x509c,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x509e,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50a0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50a2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50a4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50a6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50a8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50aa,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ac,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ae,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50b0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50b2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50b4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50b6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50b8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ba,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50bc,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50be,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50c0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50c2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50c4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50c6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50c8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ca,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50cc,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ce,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50d0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50d2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50d4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50d6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50d8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50da,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50dc,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50de,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50e0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50e2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50e4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50e6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50e8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ea,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ec,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50ee,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50f0,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50f2,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50f4,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50f6,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50f8,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50fa,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50fc,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x50fe,0x3000,VR::OB_OW,VM::VM1,"Curve Data",true },
  {0x5200,0x9229,VR::SQ,VM::VM1,"Shared Functional Groups Sequence",false },
  {0x5200,0x9230,VR::SQ,VM::VM1,"Per-frame Functional Groups Sequence",false },
  {0x5400,0x0100,VR::SQ,VM::VM1,"Waveform Sequence",false },
  {0x5400,0x0110,VR::OB_OW,VM::VM1,"Channel Minimum Value",false },
  {0x5400,0x0112,VR::OB_OW,VM::VM1,"Channel Maximum Value",false },
  {0x5400,0x1004,VR::US,VM::VM1,"Waveform Bits Allocated",false },
  {0x5400,0x1006,VR::CS,VM::VM1,"Waveform Sample Interpretation",false },
  {0x5400,0x100a,VR::OB_OW,VM::VM1,"Waveform Padding Value",false },
  {0x5400,0x1010,VR::OB_OW,VM::VM1,"Waveform Data",false },
  {0x5600,0x0010,VR::OF,VM::VM1,"First Order Phase Correction Angle",false },
  {0x5600,0x0020,VR::OF,VM::VM1,"Spectroscopy Data",false },
  {0x6000,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6002,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6004,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6006,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6008,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x600a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x600c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x600e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6010,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6012,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6014,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6016,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6018,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x601a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x601c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x601e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6020,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6022,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6024,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6026,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6028,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x602a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x602c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x602e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6030,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6032,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6034,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6036,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6038,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x603a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x603c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x603e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6040,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6042,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6044,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6046,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6048,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x604a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x604c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x604e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6050,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6052,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6054,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6056,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6058,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x605a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x605c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x605e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6060,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6062,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6064,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6066,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6068,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x606a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x606c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x606e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6070,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6072,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6074,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6076,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6078,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x607a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x607c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x607e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6080,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6082,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6084,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6086,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6088,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x608a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x608c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x608e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6090,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6092,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6094,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6096,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6098,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x609a,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x609c,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x609e,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60a0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60a2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60a4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60a6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60a8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60aa,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ac,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ae,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60b0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60b2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60b4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60b6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60b8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ba,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60bc,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60be,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60c0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60c2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60c4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60c6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60c8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ca,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60cc,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ce,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60d0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60d2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60d4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60d6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60d8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60da,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60dc,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60de,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60e0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60e2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60e4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60e6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60e8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ea,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ec,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60ee,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60f0,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60f2,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60f4,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60f6,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60f8,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60fa,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60fc,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x60fe,0x0010,VR::US,VM::VM1,"Overlay Rows",false },
  {0x6000,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6002,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6004,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6006,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6008,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x600a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x600c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x600e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6010,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6012,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6014,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6016,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6018,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x601a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x601c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x601e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6020,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6022,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6024,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6026,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6028,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x602a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x602c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x602e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6030,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6032,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6034,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6036,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6038,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x603a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x603c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x603e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6040,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6042,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6044,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6046,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6048,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x604a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x604c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x604e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6050,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6052,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6054,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6056,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6058,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x605a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x605c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x605e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6060,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6062,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6064,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6066,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6068,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x606a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x606c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x606e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6070,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6072,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6074,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6076,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6078,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x607a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x607c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x607e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6080,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6082,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6084,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6086,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6088,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x608a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x608c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x608e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6090,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6092,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6094,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6096,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6098,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x609a,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x609c,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x609e,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60a0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60a2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60a4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60a6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60a8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60aa,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ac,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ae,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60b0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60b2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60b4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60b6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60b8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ba,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60bc,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60be,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60c0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60c2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60c4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60c6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60c8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ca,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60cc,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ce,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60d0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60d2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60d4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60d6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60d8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60da,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60dc,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60de,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60e0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60e2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60e4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60e6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60e8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ea,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ec,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60ee,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60f0,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60f2,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60f4,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60f6,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60f8,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60fa,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60fc,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x60fe,0x0011,VR::US,VM::VM1,"Overlay Columns",false },
  {0x6000,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6002,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6004,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6006,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6008,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x600a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x600c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x600e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6010,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6012,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6014,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6016,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6018,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x601a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x601c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x601e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6020,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6022,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6024,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6026,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6028,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x602a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x602c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x602e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6030,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6032,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6034,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6036,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6038,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x603a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x603c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x603e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6040,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6042,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6044,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6046,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6048,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x604a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x604c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x604e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6050,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6052,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6054,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6056,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6058,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x605a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x605c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x605e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6060,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6062,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6064,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6066,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6068,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x606a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x606c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x606e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6070,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6072,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6074,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6076,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6078,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x607a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x607c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x607e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6080,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6082,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6084,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6086,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6088,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x608a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x608c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x608e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6090,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6092,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6094,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6096,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6098,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x609a,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x609c,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x609e,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60a0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60a2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60a4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60a6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60a8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60aa,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ac,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ae,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60b0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60b2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60b4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60b6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60b8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ba,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60bc,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60be,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60c0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60c2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60c4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60c6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60c8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ca,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60cc,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ce,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60d0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60d2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60d4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60d6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60d8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60da,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60dc,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60de,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60e0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60e2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60e4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60e6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60e8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ea,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ec,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60ee,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60f0,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60f2,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60f4,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60f6,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60f8,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60fa,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60fc,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x60fe,0x0012,VR::US,VM::VM1,"Overlay Planes",true },
  {0x6000,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6002,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6004,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6006,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6008,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x600a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x600c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x600e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6010,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6012,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6014,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6016,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6018,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x601a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x601c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x601e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6020,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6022,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6024,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6026,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6028,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x602a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x602c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x602e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6030,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6032,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6034,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6036,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6038,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x603a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x603c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x603e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6040,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6042,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6044,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6046,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6048,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x604a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x604c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x604e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6050,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6052,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6054,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6056,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6058,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x605a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x605c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x605e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6060,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6062,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6064,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6066,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6068,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x606a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x606c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x606e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6070,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6072,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6074,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6076,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6078,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x607a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x607c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x607e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6080,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6082,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6084,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6086,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6088,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x608a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x608c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x608e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6090,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6092,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6094,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6096,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6098,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x609a,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x609c,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x609e,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60a0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60a2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60a4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60a6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60a8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60aa,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ac,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ae,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60b0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60b2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60b4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60b6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60b8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ba,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60bc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60be,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60c0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60c2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60c4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60c6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60c8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ca,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60cc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ce,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60d0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60d2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60d4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60d6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60d8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60da,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60dc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60de,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60e0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60e2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60e4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60e6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60e8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ea,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ec,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60ee,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60f0,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60f2,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60f4,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60f6,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60f8,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60fa,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60fc,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x60fe,0x0015,VR::IS,VM::VM1,"Number of Frames in Overlay",false },
  {0x6000,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6002,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6004,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6006,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6008,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x600a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x600c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x600e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6010,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6012,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6014,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6016,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6018,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x601a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x601c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x601e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6020,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6022,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6024,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6026,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6028,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x602a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x602c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x602e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6030,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6032,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6034,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6036,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6038,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x603a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x603c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x603e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6040,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6042,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6044,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6046,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6048,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x604a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x604c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x604e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6050,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6052,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6054,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6056,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6058,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x605a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x605c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x605e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6060,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6062,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6064,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6066,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6068,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x606a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x606c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x606e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6070,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6072,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6074,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6076,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6078,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x607a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x607c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x607e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6080,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6082,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6084,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6086,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6088,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x608a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x608c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x608e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6090,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6092,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6094,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6096,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6098,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x609a,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x609c,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x609e,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60a0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60a2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60a4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60a6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60a8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60aa,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ac,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ae,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60b0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60b2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60b4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60b6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60b8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ba,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60bc,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60be,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60c0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60c2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60c4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60c6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60c8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ca,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60cc,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ce,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60d0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60d2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60d4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60d6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60d8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60da,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60dc,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60de,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60e0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60e2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60e4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60e6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60e8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ea,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ec,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60ee,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60f0,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60f2,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60f4,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60f6,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60f8,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60fa,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60fc,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x60fe,0x0022,VR::LO,VM::VM1,"Overlay Description",false },
  {0x6000,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6002,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6004,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6006,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6008,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x600a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x600c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x600e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6010,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6012,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6014,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6016,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6018,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x601a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x601c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x601e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6020,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6022,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6024,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6026,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6028,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x602a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x602c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x602e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6030,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6032,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6034,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6036,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6038,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x603a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x603c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x603e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6040,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6042,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6044,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6046,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6048,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x604a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x604c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x604e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6050,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6052,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6054,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6056,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6058,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x605a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x605c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x605e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6060,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6062,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6064,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6066,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6068,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x606a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x606c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x606e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6070,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6072,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6074,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6076,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6078,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x607a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x607c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x607e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6080,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6082,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6084,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6086,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6088,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x608a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x608c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x608e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6090,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6092,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6094,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6096,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6098,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x609a,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x609c,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x609e,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60a0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60a2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60a4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60a6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60a8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60aa,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ac,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ae,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60b0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60b2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60b4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60b6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60b8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ba,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60bc,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60be,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60c0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60c2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60c4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60c6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60c8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ca,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60cc,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ce,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60d0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60d2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60d4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60d6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60d8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60da,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60dc,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60de,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60e0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60e2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60e4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60e6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60e8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ea,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ec,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60ee,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60f0,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60f2,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60f4,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60f6,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60f8,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60fa,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60fc,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x60fe,0x0040,VR::CS,VM::VM1,"Overlay Type",false },
  {0x6000,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6002,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6004,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6006,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6008,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x600a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x600c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x600e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6010,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6012,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6014,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6016,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6018,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x601a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x601c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x601e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6020,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6022,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6024,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6026,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6028,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x602a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x602c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x602e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6030,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6032,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6034,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6036,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6038,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x603a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x603c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x603e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6040,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6042,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6044,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6046,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6048,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x604a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x604c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x604e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6050,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6052,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6054,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6056,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6058,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x605a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x605c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x605e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6060,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6062,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6064,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6066,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6068,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x606a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x606c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x606e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6070,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6072,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6074,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6076,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6078,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x607a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x607c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x607e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6080,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6082,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6084,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6086,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6088,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x608a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x608c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x608e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6090,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6092,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6094,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6096,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6098,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x609a,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x609c,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x609e,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60a0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60a2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60a4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60a6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60a8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60aa,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ac,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ae,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60b0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60b2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60b4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60b6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60b8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ba,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60bc,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60be,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60c0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60c2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60c4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60c6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60c8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ca,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60cc,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ce,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60d0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60d2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60d4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60d6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60d8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60da,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60dc,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60de,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60e0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60e2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60e4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60e6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60e8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ea,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ec,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60ee,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60f0,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60f2,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60f4,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60f6,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60f8,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60fa,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60fc,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x60fe,0x0045,VR::LO,VM::VM1,"Overlay Subtype",false },
  {0x6000,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6002,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6004,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6006,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6008,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x600a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x600c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x600e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6010,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6012,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6014,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6016,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6018,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x601a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x601c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x601e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6020,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6022,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6024,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6026,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6028,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x602a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x602c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x602e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6030,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6032,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6034,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6036,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6038,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x603a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x603c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x603e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6040,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6042,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6044,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6046,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6048,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x604a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x604c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x604e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6050,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6052,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6054,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6056,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6058,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x605a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x605c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x605e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6060,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6062,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6064,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6066,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6068,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x606a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x606c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x606e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6070,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6072,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6074,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6076,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6078,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x607a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x607c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x607e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6080,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6082,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6084,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6086,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6088,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x608a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x608c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x608e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6090,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6092,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6094,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6096,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6098,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x609a,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x609c,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x609e,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60a0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60a2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60a4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60a6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60a8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60aa,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ac,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ae,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60b0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60b2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60b4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60b6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60b8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ba,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60bc,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60be,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60c0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60c2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60c4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60c6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60c8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ca,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60cc,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ce,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60d0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60d2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60d4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60d6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60d8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60da,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60dc,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60de,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60e0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60e2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60e4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60e6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60e8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ea,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ec,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60ee,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60f0,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60f2,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60f4,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60f6,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60f8,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60fa,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60fc,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x60fe,0x0050,VR::SS,VM::VM2,"Overlay Origin",false },
  {0x6000,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6002,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6004,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6006,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6008,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x600a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x600c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x600e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6010,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6012,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6014,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6016,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6018,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x601a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x601c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x601e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6020,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6022,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6024,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6026,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6028,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x602a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x602c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x602e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6030,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6032,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6034,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6036,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6038,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x603a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x603c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x603e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6040,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6042,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6044,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6046,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6048,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x604a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x604c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x604e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6050,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6052,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6054,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6056,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6058,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x605a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x605c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x605e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6060,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6062,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6064,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6066,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6068,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x606a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x606c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x606e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6070,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6072,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6074,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6076,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6078,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x607a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x607c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x607e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6080,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6082,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6084,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6086,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6088,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x608a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x608c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x608e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6090,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6092,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6094,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6096,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6098,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x609a,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x609c,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x609e,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60a0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60a2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60a4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60a6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60a8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60aa,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ac,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ae,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60b0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60b2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60b4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60b6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60b8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ba,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60bc,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60be,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60c0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60c2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60c4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60c6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60c8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ca,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60cc,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ce,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60d0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60d2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60d4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60d6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60d8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60da,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60dc,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60de,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60e0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60e2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60e4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60e6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60e8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ea,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ec,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60ee,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60f0,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60f2,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60f4,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60f6,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60f8,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60fa,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60fc,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x60fe,0x0051,VR::US,VM::VM1,"Image Frame Origin",false },
  {0x6000,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6002,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6004,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6006,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6008,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x600a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x600c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x600e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6010,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6012,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6014,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6016,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6018,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x601a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x601c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x601e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6020,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6022,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6024,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6026,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6028,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x602a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x602c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x602e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6030,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6032,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6034,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6036,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6038,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x603a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x603c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x603e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6040,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6042,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6044,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6046,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6048,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x604a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x604c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x604e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6050,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6052,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6054,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6056,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6058,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x605a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x605c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x605e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6060,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6062,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6064,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6066,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6068,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x606a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x606c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x606e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6070,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6072,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6074,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6076,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6078,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x607a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x607c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x607e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6080,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6082,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6084,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6086,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6088,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x608a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x608c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x608e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6090,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6092,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6094,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6096,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6098,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x609a,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x609c,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x609e,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60a0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60a2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60a4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60a6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60a8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60aa,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ac,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ae,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60b0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60b2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60b4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60b6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60b8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ba,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60bc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60be,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60c0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60c2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60c4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60c6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60c8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ca,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60cc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ce,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60d0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60d2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60d4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60d6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60d8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60da,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60dc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60de,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60e0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60e2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60e4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60e6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60e8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ea,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ec,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60ee,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60f0,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60f2,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60f4,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60f6,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60f8,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60fa,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60fc,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x60fe,0x0052,VR::US,VM::VM1,"Overlay Plane Origin",true },
  {0x6000,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6002,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6004,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6006,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6008,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x600a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x600c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x600e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6010,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6012,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6014,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6016,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6018,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x601a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x601c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x601e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6020,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6022,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6024,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6026,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6028,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x602a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x602c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x602e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6030,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6032,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6034,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6036,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6038,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x603a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x603c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x603e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6040,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6042,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6044,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6046,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6048,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x604a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x604c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x604e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6050,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6052,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6054,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6056,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6058,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x605a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x605c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x605e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6060,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6062,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6064,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6066,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6068,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x606a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x606c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x606e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6070,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6072,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6074,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6076,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6078,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x607a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x607c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x607e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6080,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6082,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6084,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6086,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6088,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x608a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x608c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x608e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6090,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6092,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6094,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6096,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6098,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x609a,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x609c,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x609e,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60a0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60a2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60a4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60a6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60a8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60aa,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ac,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ae,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60b0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60b2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60b4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60b6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60b8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ba,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60bc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60be,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60c0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60c2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60c4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60c6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60c8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ca,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60cc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ce,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60d0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60d2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60d4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60d6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60d8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60da,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60dc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60de,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60e0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60e2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60e4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60e6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60e8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ea,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ec,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60ee,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60f0,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60f2,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60f4,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60f6,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60f8,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60fa,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60fc,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x60fe,0x0060,VR::CS,VM::VM1,"Overlay Compression Code",true },
  {0x6000,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6002,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6004,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6006,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6008,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x600a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x600c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x600e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6010,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6012,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6014,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6016,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6018,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x601a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x601c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x601e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6020,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6022,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6024,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6026,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6028,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x602a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x602c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x602e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6030,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6032,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6034,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6036,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6038,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x603a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x603c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x603e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6040,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6042,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6044,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6046,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6048,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x604a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x604c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x604e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6050,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6052,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6054,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6056,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6058,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x605a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x605c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x605e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6060,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6062,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6064,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6066,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6068,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x606a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x606c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x606e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6070,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6072,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6074,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6076,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6078,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x607a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x607c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x607e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6080,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6082,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6084,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6086,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6088,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x608a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x608c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x608e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6090,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6092,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6094,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6096,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6098,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x609a,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x609c,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x609e,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60a0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60a2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60a4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60a6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60a8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60aa,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ac,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ae,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60b0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60b2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60b4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60b6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60b8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ba,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60bc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60be,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60c0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60c2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60c4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60c6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60c8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ca,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60cc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ce,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60d0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60d2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60d4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60d6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60d8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60da,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60dc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60de,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60e0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60e2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60e4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60e6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60e8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ea,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ec,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60ee,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60f0,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60f2,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60f4,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60f6,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60f8,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60fa,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60fc,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x60fe,0x0061,VR::SH,VM::VM1,"Overlay Compression Originator",true },
  {0x6000,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6002,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6004,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6006,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6008,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x600a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x600c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x600e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6010,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6012,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6014,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6016,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6018,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x601a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x601c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x601e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6020,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6022,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6024,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6026,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6028,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x602a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x602c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x602e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6030,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6032,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6034,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6036,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6038,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x603a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x603c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x603e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6040,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6042,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6044,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6046,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6048,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x604a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x604c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x604e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6050,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6052,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6054,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6056,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6058,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x605a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x605c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x605e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6060,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6062,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6064,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6066,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6068,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x606a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x606c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x606e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6070,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6072,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6074,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6076,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6078,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x607a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x607c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x607e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6080,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6082,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6084,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6086,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6088,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x608a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x608c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x608e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6090,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6092,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6094,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6096,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6098,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x609a,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x609c,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x609e,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60a0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60a2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60a4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60a6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60a8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60aa,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ac,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ae,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60b0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60b2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60b4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60b6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60b8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ba,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60bc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60be,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60c0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60c2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60c4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60c6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60c8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ca,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60cc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ce,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60d0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60d2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60d4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60d6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60d8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60da,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60dc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60de,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60e0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60e2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60e4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60e6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60e8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ea,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ec,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60ee,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60f0,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60f2,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60f4,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60f6,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60f8,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60fa,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60fc,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x60fe,0x0062,VR::SH,VM::VM1,"Overlay Compression Label",true },
  {0x6000,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6002,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6004,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6006,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6008,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x600a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x600c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x600e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6010,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6012,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6014,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6016,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6018,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x601a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x601c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x601e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6020,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6022,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6024,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6026,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6028,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x602a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x602c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x602e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6030,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6032,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6034,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6036,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6038,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x603a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x603c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x603e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6040,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6042,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6044,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6046,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6048,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x604a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x604c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x604e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6050,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6052,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6054,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6056,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6058,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x605a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x605c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x605e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6060,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6062,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6064,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6066,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6068,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x606a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x606c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x606e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6070,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6072,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6074,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6076,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6078,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x607a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x607c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x607e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6080,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6082,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6084,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6086,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6088,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x608a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x608c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x608e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6090,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6092,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6094,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6096,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6098,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x609a,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x609c,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x609e,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60a0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60a2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60a4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60a6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60a8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60aa,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ac,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ae,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60b0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60b2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60b4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60b6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60b8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ba,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60bc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60be,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60c0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60c2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60c4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60c6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60c8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ca,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60cc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ce,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60d0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60d2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60d4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60d6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60d8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60da,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60dc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60de,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60e0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60e2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60e4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60e6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60e8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ea,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ec,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60ee,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60f0,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60f2,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60f4,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60f6,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60f8,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60fa,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60fc,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x60fe,0x0063,VR::CS,VM::VM1,"Overlay Compression Description",true },
  {0x6000,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6002,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6004,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6006,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6008,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x600a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x600c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x600e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6010,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6012,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6014,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6016,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6018,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x601a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x601c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x601e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6020,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6022,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6024,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6026,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6028,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x602a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x602c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x602e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6030,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6032,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6034,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6036,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6038,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x603a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x603c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x603e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6040,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6042,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6044,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6046,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6048,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x604a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x604c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x604e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6050,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6052,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6054,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6056,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6058,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x605a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x605c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x605e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6060,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6062,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6064,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6066,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6068,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x606a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x606c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x606e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6070,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6072,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6074,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6076,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6078,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x607a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x607c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x607e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6080,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6082,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6084,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6086,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6088,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x608a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x608c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x608e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6090,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6092,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6094,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6096,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6098,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x609a,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x609c,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x609e,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60a0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60a2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60a4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60a6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60a8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60aa,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ac,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ae,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60b0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60b2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60b4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60b6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60b8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ba,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60bc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60be,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60c0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60c2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60c4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60c6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60c8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ca,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60cc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ce,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60d0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60d2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60d4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60d6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60d8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60da,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60dc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60de,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60e0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60e2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60e4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60e6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60e8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ea,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ec,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60ee,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60f0,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60f2,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60f4,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60f6,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60f8,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60fa,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60fc,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x60fe,0x0066,VR::AT,VM::VM1_n,"Overlay Compression Step Pointers",true },
  {0x6000,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6002,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6004,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6006,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6008,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x600a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x600c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x600e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6010,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6012,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6014,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6016,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6018,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x601a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x601c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x601e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6020,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6022,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6024,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6026,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6028,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x602a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x602c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x602e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6030,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6032,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6034,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6036,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6038,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x603a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x603c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x603e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6040,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6042,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6044,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6046,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6048,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x604a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x604c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x604e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6050,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6052,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6054,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6056,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6058,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x605a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x605c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x605e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6060,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6062,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6064,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6066,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6068,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x606a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x606c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x606e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6070,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6072,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6074,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6076,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6078,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x607a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x607c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x607e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6080,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6082,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6084,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6086,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6088,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x608a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x608c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x608e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6090,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6092,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6094,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6096,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6098,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x609a,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x609c,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x609e,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60a0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60a2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60a4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60a6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60a8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60aa,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ac,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ae,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60b0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60b2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60b4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60b6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60b8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ba,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60bc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60be,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60c0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60c2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60c4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60c6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60c8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ca,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60cc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ce,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60d0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60d2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60d4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60d6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60d8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60da,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60dc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60de,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60e0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60e2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60e4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60e6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60e8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ea,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ec,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60ee,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60f0,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60f2,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60f4,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60f6,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60f8,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60fa,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60fc,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x60fe,0x0068,VR::US,VM::VM1,"Overlay Repeat Interval",true },
  {0x6000,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6002,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6004,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6006,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6008,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x600a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x600c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x600e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6010,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6012,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6014,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6016,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6018,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x601a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x601c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x601e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6020,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6022,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6024,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6026,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6028,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x602a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x602c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x602e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6030,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6032,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6034,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6036,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6038,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x603a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x603c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x603e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6040,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6042,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6044,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6046,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6048,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x604a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x604c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x604e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6050,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6052,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6054,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6056,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6058,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x605a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x605c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x605e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6060,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6062,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6064,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6066,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6068,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x606a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x606c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x606e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6070,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6072,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6074,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6076,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6078,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x607a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x607c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x607e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6080,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6082,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6084,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6086,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6088,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x608a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x608c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x608e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6090,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6092,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6094,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6096,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6098,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x609a,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x609c,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x609e,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60a0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60a2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60a4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60a6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60a8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60aa,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ac,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ae,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60b0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60b2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60b4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60b6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60b8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ba,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60bc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60be,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60c0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60c2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60c4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60c6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60c8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ca,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60cc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ce,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60d0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60d2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60d4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60d6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60d8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60da,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60dc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60de,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60e0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60e2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60e4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60e6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60e8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ea,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ec,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60ee,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60f0,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60f2,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60f4,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60f6,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60f8,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60fa,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60fc,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x60fe,0x0069,VR::US,VM::VM1,"Overlay Bits Grouped",true },
  {0x6000,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6002,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6004,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6006,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6008,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x600a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x600c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x600e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6010,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6012,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6014,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6016,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6018,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x601a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x601c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x601e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6020,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6022,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6024,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6026,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6028,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x602a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x602c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x602e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6030,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6032,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6034,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6036,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6038,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x603a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x603c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x603e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6040,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6042,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6044,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6046,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6048,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x604a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x604c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x604e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6050,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6052,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6054,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6056,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6058,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x605a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x605c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x605e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6060,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6062,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6064,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6066,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6068,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x606a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x606c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x606e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6070,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6072,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6074,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6076,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6078,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x607a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x607c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x607e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6080,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6082,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6084,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6086,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6088,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x608a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x608c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x608e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6090,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6092,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6094,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6096,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6098,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x609a,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x609c,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x609e,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60a0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60a2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60a4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60a6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60a8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60aa,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ac,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ae,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60b0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60b2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60b4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60b6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60b8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ba,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60bc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60be,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60c0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60c2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60c4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60c6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60c8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ca,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60cc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ce,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60d0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60d2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60d4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60d6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60d8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60da,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60dc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60de,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60e0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60e2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60e4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60e6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60e8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ea,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ec,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60ee,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60f0,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60f2,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60f4,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60f6,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60f8,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60fa,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60fc,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x60fe,0x0100,VR::US,VM::VM1,"Overlay Bits Allocated",false },
  {0x6000,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6002,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6004,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6006,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6008,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x600a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x600c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x600e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6010,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6012,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6014,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6016,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6018,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x601a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x601c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x601e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6020,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6022,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6024,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6026,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6028,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x602a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x602c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x602e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6030,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6032,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6034,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6036,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6038,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x603a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x603c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x603e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6040,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6042,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6044,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6046,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6048,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x604a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x604c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x604e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6050,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6052,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6054,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6056,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6058,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x605a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x605c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x605e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6060,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6062,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6064,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6066,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6068,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x606a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x606c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x606e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6070,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6072,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6074,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6076,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6078,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x607a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x607c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x607e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6080,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6082,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6084,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6086,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6088,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x608a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x608c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x608e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6090,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6092,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6094,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6096,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6098,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x609a,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x609c,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x609e,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60a0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60a2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60a4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60a6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60a8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60aa,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ac,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ae,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60b0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60b2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60b4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60b6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60b8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ba,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60bc,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60be,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60c0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60c2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60c4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60c6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60c8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ca,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60cc,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ce,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60d0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60d2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60d4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60d6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60d8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60da,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60dc,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60de,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60e0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60e2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60e4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60e6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60e8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ea,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ec,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60ee,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60f0,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60f2,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60f4,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60f6,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60f8,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60fa,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60fc,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x60fe,0x0102,VR::US,VM::VM1,"Overlay Bit Position",false },
  {0x6000,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6002,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6004,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6006,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6008,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x600a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x600c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x600e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6010,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6012,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6014,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6016,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6018,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x601a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x601c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x601e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6020,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6022,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6024,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6026,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6028,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x602a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x602c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x602e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6030,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6032,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6034,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6036,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6038,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x603a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x603c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x603e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6040,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6042,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6044,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6046,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6048,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x604a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x604c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x604e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6050,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6052,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6054,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6056,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6058,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x605a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x605c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x605e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6060,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6062,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6064,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6066,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6068,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x606a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x606c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x606e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6070,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6072,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6074,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6076,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6078,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x607a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x607c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x607e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6080,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6082,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6084,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6086,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6088,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x608a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x608c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x608e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6090,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6092,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6094,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6096,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6098,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x609a,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x609c,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x609e,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60a0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60a2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60a4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60a6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60a8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60aa,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ac,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ae,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60b0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60b2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60b4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60b6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60b8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ba,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60bc,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60be,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60c0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60c2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60c4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60c6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60c8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ca,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60cc,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ce,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60d0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60d2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60d4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60d6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60d8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60da,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60dc,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60de,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60e0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60e2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60e4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60e6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60e8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ea,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ec,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60ee,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60f0,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60f2,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60f4,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60f6,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60f8,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60fa,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60fc,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x60fe,0x0110,VR::CS,VM::VM1,"Overlay Format",true },
  {0x6000,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6002,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6004,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6006,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6008,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x600a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x600c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x600e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6010,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6012,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6014,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6016,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6018,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x601a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x601c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x601e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6020,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6022,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6024,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6026,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6028,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x602a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x602c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x602e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6030,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6032,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6034,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6036,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6038,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x603a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x603c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x603e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6040,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6042,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6044,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6046,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6048,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x604a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x604c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x604e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6050,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6052,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6054,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6056,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6058,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x605a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x605c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x605e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6060,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6062,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6064,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6066,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6068,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x606a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x606c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x606e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6070,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6072,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6074,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6076,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6078,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x607a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x607c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x607e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6080,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6082,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6084,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6086,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6088,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x608a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x608c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x608e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6090,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6092,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6094,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6096,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6098,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x609a,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x609c,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x609e,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60a0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60a2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60a4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60a6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60a8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60aa,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ac,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ae,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60b0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60b2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60b4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60b6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60b8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ba,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60bc,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60be,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60c0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60c2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60c4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60c6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60c8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ca,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60cc,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ce,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60d0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60d2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60d4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60d6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60d8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60da,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60dc,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60de,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60e0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60e2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60e4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60e6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60e8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ea,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ec,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60ee,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60f0,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60f2,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60f4,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60f6,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60f8,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60fa,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60fc,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x60fe,0x0200,VR::US,VM::VM1,"Overlay Location",true },
  {0x6000,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6002,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6004,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6006,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6008,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x600a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x600c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x600e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6010,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6012,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6014,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6016,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6018,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x601a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x601c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x601e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6020,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6022,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6024,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6026,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6028,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x602a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x602c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x602e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6030,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6032,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6034,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6036,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6038,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x603a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x603c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x603e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6040,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6042,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6044,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6046,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6048,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x604a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x604c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x604e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6050,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6052,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6054,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6056,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6058,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x605a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x605c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x605e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6060,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6062,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6064,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6066,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6068,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x606a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x606c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x606e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6070,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6072,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6074,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6076,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6078,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x607a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x607c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x607e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6080,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6082,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6084,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6086,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6088,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x608a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x608c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x608e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6090,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6092,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6094,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6096,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6098,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x609a,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x609c,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x609e,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60a0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60a2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60a4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60a6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60a8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60aa,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ac,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ae,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60b0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60b2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60b4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60b6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60b8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ba,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60bc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60be,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60c0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60c2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60c4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60c6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60c8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ca,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60cc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ce,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60d0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60d2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60d4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60d6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60d8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60da,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60dc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60de,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60e0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60e2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60e4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60e6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60e8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ea,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ec,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60ee,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60f0,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60f2,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60f4,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60f6,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60f8,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60fa,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60fc,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x60fe,0x0800,VR::CS,VM::VM1_n,"Overlay Code Label",true },
  {0x6000,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6002,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6004,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6006,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6008,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x600a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x600c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x600e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6010,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6012,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6014,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6016,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6018,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x601a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x601c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x601e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6020,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6022,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6024,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6026,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6028,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x602a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x602c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x602e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6030,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6032,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6034,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6036,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6038,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x603a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x603c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x603e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6040,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6042,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6044,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6046,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6048,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x604a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x604c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x604e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6050,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6052,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6054,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6056,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6058,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x605a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x605c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x605e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6060,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6062,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6064,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6066,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6068,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x606a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x606c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x606e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6070,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6072,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6074,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6076,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6078,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x607a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x607c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x607e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6080,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6082,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6084,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6086,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6088,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x608a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x608c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x608e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6090,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6092,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6094,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6096,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6098,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x609a,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x609c,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x609e,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60a0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60a2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60a4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60a6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60a8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60aa,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ac,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ae,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60b0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60b2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60b4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60b6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60b8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ba,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60bc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60be,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60c0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60c2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60c4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60c6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60c8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ca,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60cc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ce,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60d0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60d2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60d4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60d6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60d8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60da,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60dc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60de,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60e0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60e2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60e4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60e6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60e8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ea,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ec,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60ee,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60f0,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60f2,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60f4,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60f6,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60f8,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60fa,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60fc,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x60fe,0x0802,VR::US,VM::VM1,"Overlay Number of Tables",true },
  {0x6000,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6002,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6004,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6006,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6008,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x600a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x600c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x600e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6010,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6012,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6014,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6016,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6018,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x601a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x601c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x601e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6020,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6022,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6024,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6026,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6028,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x602a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x602c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x602e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6030,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6032,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6034,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6036,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6038,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x603a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x603c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x603e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6040,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6042,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6044,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6046,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6048,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x604a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x604c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x604e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6050,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6052,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6054,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6056,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6058,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x605a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x605c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x605e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6060,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6062,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6064,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6066,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6068,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x606a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x606c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x606e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6070,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6072,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6074,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6076,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6078,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x607a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x607c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x607e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6080,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6082,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6084,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6086,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6088,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x608a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x608c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x608e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6090,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6092,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6094,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6096,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6098,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x609a,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x609c,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x609e,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60a0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60a2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60a4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60a6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60a8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60aa,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ac,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ae,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60b0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60b2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60b4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60b6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60b8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ba,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60bc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60be,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60c0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60c2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60c4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60c6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60c8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ca,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60cc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ce,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60d0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60d2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60d4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60d6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60d8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60da,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60dc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60de,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60e0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60e2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60e4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60e6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60e8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ea,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ec,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60ee,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60f0,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60f2,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60f4,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60f6,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60f8,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60fa,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60fc,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x60fe,0x0803,VR::AT,VM::VM1_n,"Overlay Code Table Location",true },
  {0x6000,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6002,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6004,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6006,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6008,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x600a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x600c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x600e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6010,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6012,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6014,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6016,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6018,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x601a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x601c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x601e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6020,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6022,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6024,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6026,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6028,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x602a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x602c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x602e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6030,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6032,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6034,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6036,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6038,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x603a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x603c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x603e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6040,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6042,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6044,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6046,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6048,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x604a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x604c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x604e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6050,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6052,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6054,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6056,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6058,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x605a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x605c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x605e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6060,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6062,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6064,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6066,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6068,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x606a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x606c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x606e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6070,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6072,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6074,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6076,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6078,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x607a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x607c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x607e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6080,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6082,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6084,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6086,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6088,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x608a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x608c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x608e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6090,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6092,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6094,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6096,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6098,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x609a,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x609c,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x609e,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60a0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60a2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60a4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60a6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60a8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60aa,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ac,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ae,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60b0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60b2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60b4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60b6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60b8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ba,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60bc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60be,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60c0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60c2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60c4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60c6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60c8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ca,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60cc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ce,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60d0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60d2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60d4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60d6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60d8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60da,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60dc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60de,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60e0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60e2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60e4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60e6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60e8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ea,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ec,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60ee,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60f0,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60f2,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60f4,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60f6,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60f8,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60fa,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60fc,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x60fe,0x0804,VR::US,VM::VM1,"Overlay Bits For Code Word",true },
  {0x6000,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6002,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6004,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6006,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6008,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x600a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x600c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x600e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6010,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6012,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6014,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6016,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6018,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x601a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x601c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x601e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6020,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6022,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6024,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6026,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6028,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x602a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x602c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x602e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6030,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6032,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6034,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6036,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6038,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x603a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x603c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x603e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6040,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6042,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6044,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6046,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6048,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x604a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x604c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x604e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6050,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6052,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6054,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6056,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6058,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x605a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x605c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x605e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6060,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6062,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6064,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6066,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6068,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x606a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x606c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x606e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6070,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6072,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6074,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6076,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6078,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x607a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x607c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x607e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6080,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6082,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6084,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6086,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6088,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x608a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x608c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x608e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6090,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6092,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6094,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6096,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6098,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x609a,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x609c,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x609e,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60a0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60a2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60a4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60a6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60a8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60aa,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ac,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ae,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60b0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60b2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60b4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60b6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60b8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ba,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60bc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60be,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60c0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60c2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60c4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60c6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60c8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ca,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60cc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ce,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60d0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60d2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60d4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60d6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60d8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60da,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60dc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60de,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60e0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60e2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60e4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60e6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60e8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ea,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ec,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60ee,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60f0,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60f2,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60f4,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60f6,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60f8,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60fa,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60fc,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x60fe,0x1001,VR::CS,VM::VM1,"Overlay Activation Layer",false },
  {0x6000,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6002,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6004,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6006,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6008,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x600a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x600c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x600e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6010,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6012,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6014,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6016,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6018,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x601a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x601c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x601e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6020,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6022,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6024,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6026,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6028,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x602a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x602c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x602e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6030,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6032,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6034,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6036,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6038,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x603a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x603c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x603e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6040,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6042,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6044,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6046,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6048,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x604a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x604c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x604e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6050,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6052,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6054,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6056,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6058,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x605a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x605c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x605e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6060,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6062,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6064,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6066,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6068,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x606a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x606c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x606e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6070,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6072,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6074,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6076,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6078,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x607a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x607c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x607e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6080,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6082,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6084,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6086,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6088,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x608a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x608c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x608e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6090,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6092,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6094,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6096,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6098,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x609a,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x609c,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x609e,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60a0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60a2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60a4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60a6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60a8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60aa,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ac,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ae,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60b0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60b2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60b4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60b6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60b8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ba,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60bc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60be,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60c0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60c2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60c4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60c6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60c8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ca,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60cc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ce,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60d0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60d2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60d4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60d6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60d8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60da,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60dc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60de,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60e0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60e2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60e4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60e6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60e8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ea,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ec,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60ee,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60f0,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60f2,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60f4,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60f6,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60f8,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60fa,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60fc,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x60fe,0x1100,VR::US,VM::VM1,"Overlay Descriptor - Gray",true },
  {0x6000,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6002,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6004,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6006,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6008,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x600a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x600c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x600e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6010,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6012,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6014,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6016,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6018,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x601a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x601c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x601e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6020,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6022,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6024,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6026,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6028,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x602a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x602c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x602e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6030,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6032,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6034,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6036,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6038,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x603a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x603c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x603e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6040,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6042,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6044,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6046,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6048,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x604a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x604c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x604e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6050,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6052,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6054,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6056,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6058,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x605a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x605c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x605e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6060,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6062,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6064,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6066,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6068,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x606a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x606c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x606e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6070,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6072,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6074,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6076,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6078,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x607a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x607c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x607e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6080,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6082,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6084,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6086,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6088,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x608a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x608c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x608e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6090,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6092,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6094,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6096,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6098,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x609a,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x609c,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x609e,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60a0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60a2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60a4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60a6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60a8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60aa,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ac,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ae,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60b0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60b2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60b4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60b6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60b8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ba,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60bc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60be,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60c0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60c2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60c4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60c6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60c8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ca,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60cc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ce,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60d0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60d2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60d4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60d6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60d8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60da,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60dc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60de,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60e0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60e2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60e4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60e6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60e8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ea,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ec,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60ee,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60f0,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60f2,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60f4,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60f6,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60f8,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60fa,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60fc,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x60fe,0x1101,VR::US,VM::VM1,"Overlay Descriptor - Red",true },
  {0x6000,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6002,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6004,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6006,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6008,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x600a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x600c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x600e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6010,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6012,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6014,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6016,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6018,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x601a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x601c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x601e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6020,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6022,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6024,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6026,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6028,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x602a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x602c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x602e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6030,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6032,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6034,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6036,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6038,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x603a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x603c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x603e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6040,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6042,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6044,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6046,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6048,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x604a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x604c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x604e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6050,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6052,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6054,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6056,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6058,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x605a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x605c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x605e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6060,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6062,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6064,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6066,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6068,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x606a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x606c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x606e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6070,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6072,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6074,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6076,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6078,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x607a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x607c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x607e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6080,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6082,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6084,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6086,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6088,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x608a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x608c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x608e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6090,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6092,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6094,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6096,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6098,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x609a,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x609c,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x609e,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60a0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60a2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60a4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60a6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60a8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60aa,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ac,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ae,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60b0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60b2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60b4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60b6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60b8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ba,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60bc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60be,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60c0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60c2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60c4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60c6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60c8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ca,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60cc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ce,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60d0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60d2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60d4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60d6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60d8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60da,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60dc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60de,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60e0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60e2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60e4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60e6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60e8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ea,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ec,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60ee,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60f0,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60f2,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60f4,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60f6,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60f8,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60fa,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60fc,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x60fe,0x1102,VR::US,VM::VM1,"Overlay Descriptor - Green",true },
  {0x6000,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6002,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6004,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6006,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6008,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x600a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x600c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x600e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6010,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6012,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6014,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6016,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6018,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x601a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x601c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x601e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6020,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6022,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6024,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6026,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6028,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x602a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x602c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x602e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6030,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6032,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6034,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6036,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6038,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x603a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x603c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x603e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6040,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6042,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6044,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6046,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6048,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x604a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x604c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x604e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6050,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6052,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6054,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6056,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6058,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x605a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x605c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x605e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6060,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6062,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6064,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6066,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6068,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x606a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x606c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x606e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6070,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6072,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6074,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6076,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6078,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x607a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x607c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x607e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6080,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6082,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6084,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6086,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6088,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x608a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x608c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x608e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6090,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6092,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6094,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6096,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6098,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x609a,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x609c,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x609e,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60a0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60a2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60a4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60a6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60a8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60aa,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ac,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ae,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60b0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60b2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60b4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60b6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60b8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ba,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60bc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60be,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60c0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60c2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60c4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60c6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60c8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ca,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60cc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ce,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60d0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60d2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60d4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60d6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60d8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60da,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60dc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60de,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60e0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60e2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60e4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60e6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60e8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ea,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ec,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60ee,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60f0,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60f2,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60f4,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60f6,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60f8,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60fa,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60fc,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x60fe,0x1103,VR::US,VM::VM1,"Overlay Descriptor - Blue",true },
  {0x6000,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6002,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6004,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6006,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6008,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x600a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x600c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x600e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6010,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6012,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6014,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6016,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6018,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x601a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x601c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x601e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6020,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6022,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6024,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6026,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6028,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x602a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x602c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x602e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6030,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6032,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6034,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6036,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6038,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x603a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x603c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x603e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6040,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6042,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6044,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6046,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6048,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x604a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x604c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x604e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6050,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6052,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6054,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6056,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6058,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x605a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x605c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x605e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6060,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6062,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6064,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6066,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6068,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x606a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x606c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x606e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6070,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6072,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6074,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6076,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6078,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x607a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x607c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x607e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6080,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6082,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6084,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6086,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6088,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x608a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x608c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x608e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6090,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6092,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6094,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6096,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6098,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x609a,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x609c,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x609e,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60a0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60a2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60a4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60a6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60a8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60aa,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ac,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ae,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60b0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60b2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60b4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60b6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60b8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ba,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60bc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60be,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60c0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60c2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60c4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60c6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60c8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ca,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60cc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ce,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60d0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60d2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60d4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60d6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60d8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60da,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60dc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60de,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60e0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60e2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60e4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60e6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60e8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ea,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ec,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60ee,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60f0,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60f2,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60f4,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60f6,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60f8,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60fa,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60fc,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x60fe,0x1200,VR::US,VM::VM1_n,"Overlays - Gray",true },
  {0x6000,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6002,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6004,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6006,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6008,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x600a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x600c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x600e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6010,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6012,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6014,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6016,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6018,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x601a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x601c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x601e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6020,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6022,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6024,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6026,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6028,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x602a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x602c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x602e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6030,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6032,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6034,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6036,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6038,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x603a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x603c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x603e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6040,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6042,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6044,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6046,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6048,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x604a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x604c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x604e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6050,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6052,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6054,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6056,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6058,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x605a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x605c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x605e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6060,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6062,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6064,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6066,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6068,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x606a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x606c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x606e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6070,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6072,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6074,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6076,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6078,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x607a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x607c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x607e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6080,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6082,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6084,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6086,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6088,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x608a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x608c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x608e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6090,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6092,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6094,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6096,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6098,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x609a,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x609c,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x609e,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60a0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60a2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60a4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60a6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60a8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60aa,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ac,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ae,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60b0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60b2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60b4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60b6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60b8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ba,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60bc,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60be,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60c0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60c2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60c4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60c6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60c8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ca,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60cc,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ce,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60d0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60d2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60d4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60d6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60d8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60da,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60dc,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60de,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60e0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60e2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60e4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60e6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60e8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ea,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ec,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60ee,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60f0,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60f2,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60f4,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60f6,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60f8,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60fa,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60fc,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x60fe,0x1201,VR::US,VM::VM1_n,"Overlays - Red",true },
  {0x6000,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6002,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6004,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6006,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6008,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x600a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x600c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x600e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6010,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6012,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6014,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6016,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6018,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x601a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x601c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x601e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6020,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6022,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6024,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6026,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6028,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x602a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x602c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x602e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6030,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6032,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6034,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6036,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6038,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x603a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x603c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x603e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6040,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6042,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6044,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6046,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6048,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x604a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x604c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x604e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6050,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6052,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6054,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6056,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6058,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x605a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x605c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x605e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6060,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6062,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6064,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6066,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6068,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x606a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x606c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x606e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6070,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6072,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6074,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6076,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6078,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x607a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x607c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x607e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6080,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6082,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6084,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6086,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6088,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x608a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x608c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x608e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6090,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6092,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6094,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6096,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6098,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x609a,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x609c,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x609e,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60a0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60a2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60a4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60a6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60a8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60aa,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ac,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ae,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60b0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60b2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60b4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60b6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60b8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ba,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60bc,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60be,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60c0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60c2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60c4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60c6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60c8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ca,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60cc,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ce,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60d0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60d2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60d4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60d6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60d8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60da,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60dc,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60de,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60e0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60e2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60e4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60e6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60e8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ea,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ec,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60ee,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60f0,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60f2,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60f4,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60f6,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60f8,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60fa,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60fc,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x60fe,0x1202,VR::US,VM::VM1_n,"Overlays - Green",true },
  {0x6000,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6002,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6004,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6006,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6008,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x600a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x600c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x600e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6010,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6012,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6014,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6016,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6018,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x601a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x601c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x601e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6020,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6022,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6024,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6026,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6028,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x602a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x602c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x602e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6030,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6032,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6034,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6036,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6038,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x603a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x603c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x603e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6040,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6042,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6044,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6046,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6048,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x604a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x604c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x604e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6050,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6052,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6054,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6056,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6058,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x605a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x605c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x605e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6060,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6062,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6064,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6066,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6068,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x606a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x606c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x606e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6070,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6072,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6074,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6076,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6078,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x607a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x607c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x607e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6080,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6082,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6084,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6086,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6088,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x608a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x608c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x608e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6090,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6092,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6094,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6096,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6098,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x609a,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x609c,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x609e,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60a0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60a2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60a4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60a6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60a8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60aa,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ac,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ae,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60b0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60b2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60b4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60b6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60b8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ba,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60bc,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60be,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60c0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60c2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60c4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60c6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60c8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ca,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60cc,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ce,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60d0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60d2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60d4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60d6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60d8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60da,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60dc,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60de,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60e0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60e2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60e4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60e6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60e8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ea,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ec,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60ee,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60f0,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60f2,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60f4,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60f6,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60f8,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60fa,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60fc,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x60fe,0x1203,VR::US,VM::VM1_n,"Overlays - Blue",true },
  {0x6000,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6002,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6004,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6006,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6008,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x600a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x600c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x600e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6010,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6012,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6014,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6016,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6018,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x601a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x601c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x601e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6020,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6022,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6024,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6026,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6028,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x602a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x602c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x602e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6030,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6032,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6034,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6036,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6038,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x603a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x603c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x603e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6040,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6042,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6044,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6046,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6048,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x604a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x604c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x604e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6050,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6052,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6054,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6056,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6058,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x605a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x605c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x605e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6060,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6062,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6064,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6066,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6068,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x606a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x606c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x606e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6070,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6072,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6074,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6076,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6078,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x607a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x607c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x607e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6080,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6082,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6084,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6086,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6088,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x608a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x608c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x608e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6090,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6092,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6094,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6096,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6098,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x609a,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x609c,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x609e,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60a0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60a2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60a4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60a6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60a8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60aa,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ac,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ae,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60b0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60b2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60b4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60b6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60b8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ba,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60bc,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60be,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60c0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60c2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60c4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60c6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60c8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ca,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60cc,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ce,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60d0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60d2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60d4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60d6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60d8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60da,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60dc,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60de,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60e0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60e2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60e4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60e6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60e8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ea,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ec,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60ee,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60f0,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60f2,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60f4,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60f6,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60f8,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60fa,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60fc,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x60fe,0x1301,VR::IS,VM::VM1,"ROI Area",false },
  {0x6000,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6002,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6004,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6006,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6008,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x600a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x600c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x600e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6010,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6012,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6014,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6016,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6018,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x601a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x601c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x601e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6020,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6022,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6024,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6026,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6028,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x602a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x602c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x602e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6030,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6032,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6034,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6036,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6038,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x603a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x603c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x603e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6040,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6042,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6044,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6046,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6048,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x604a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x604c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x604e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6050,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6052,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6054,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6056,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6058,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x605a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x605c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x605e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6060,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6062,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6064,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6066,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6068,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x606a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x606c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x606e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6070,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6072,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6074,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6076,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6078,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x607a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x607c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x607e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6080,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6082,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6084,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6086,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6088,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x608a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x608c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x608e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6090,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6092,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6094,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6096,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6098,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x609a,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x609c,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x609e,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60a0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60a2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60a4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60a6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60a8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60aa,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ac,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ae,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60b0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60b2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60b4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60b6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60b8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ba,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60bc,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60be,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60c0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60c2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60c4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60c6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60c8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ca,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60cc,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ce,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60d0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60d2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60d4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60d6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60d8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60da,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60dc,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60de,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60e0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60e2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60e4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60e6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60e8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ea,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ec,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60ee,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60f0,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60f2,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60f4,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60f6,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60f8,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60fa,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60fc,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x60fe,0x1302,VR::DS,VM::VM1,"ROI Mean",false },
  {0x6000,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6002,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6004,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6006,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6008,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x600a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x600c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x600e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6010,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6012,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6014,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6016,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6018,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x601a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x601c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x601e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6020,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6022,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6024,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6026,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6028,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x602a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x602c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x602e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6030,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6032,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6034,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6036,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6038,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x603a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x603c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x603e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6040,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6042,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6044,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6046,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6048,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x604a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x604c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x604e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6050,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6052,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6054,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6056,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6058,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x605a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x605c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x605e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6060,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6062,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6064,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6066,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6068,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x606a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x606c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x606e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6070,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6072,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6074,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6076,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6078,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x607a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x607c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x607e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6080,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6082,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6084,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6086,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6088,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x608a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x608c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x608e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6090,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6092,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6094,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6096,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6098,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x609a,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x609c,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x609e,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60a0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60a2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60a4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60a6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60a8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60aa,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ac,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ae,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60b0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60b2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60b4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60b6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60b8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ba,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60bc,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60be,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60c0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60c2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60c4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60c6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60c8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ca,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60cc,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ce,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60d0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60d2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60d4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60d6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60d8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60da,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60dc,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60de,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60e0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60e2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60e4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60e6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60e8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ea,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ec,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60ee,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60f0,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60f2,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60f4,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60f6,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60f8,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60fa,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60fc,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x60fe,0x1303,VR::DS,VM::VM1,"ROI Standard Deviation",false },
  {0x6000,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6002,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6004,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6006,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6008,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x600a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x600c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x600e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6010,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6012,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6014,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6016,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6018,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x601a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x601c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x601e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6020,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6022,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6024,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6026,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6028,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x602a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x602c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x602e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6030,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6032,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6034,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6036,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6038,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x603a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x603c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x603e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6040,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6042,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6044,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6046,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6048,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x604a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x604c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x604e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6050,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6052,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6054,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6056,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6058,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x605a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x605c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x605e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6060,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6062,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6064,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6066,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6068,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x606a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x606c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x606e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6070,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6072,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6074,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6076,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6078,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x607a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x607c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x607e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6080,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6082,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6084,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6086,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6088,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x608a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x608c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x608e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6090,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6092,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6094,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6096,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6098,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x609a,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x609c,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x609e,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60a0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60a2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60a4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60a6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60a8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60aa,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ac,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ae,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60b0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60b2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60b4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60b6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60b8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ba,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60bc,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60be,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60c0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60c2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60c4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60c6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60c8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ca,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60cc,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ce,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60d0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60d2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60d4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60d6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60d8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60da,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60dc,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60de,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60e0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60e2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60e4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60e6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60e8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ea,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ec,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60ee,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60f0,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60f2,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60f4,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60f6,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60f8,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60fa,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60fc,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x60fe,0x1500,VR::LO,VM::VM1,"Overlay Label",false },
  {0x6000,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6002,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6004,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6006,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6008,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x600a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x600c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x600e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6010,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6012,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6014,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6016,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6018,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x601a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x601c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x601e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6020,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6022,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6024,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6026,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6028,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x602a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x602c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x602e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6030,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6032,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6034,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6036,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6038,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x603a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x603c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x603e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6040,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6042,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6044,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6046,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6048,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x604a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x604c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x604e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6050,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6052,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6054,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6056,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6058,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x605a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x605c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x605e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6060,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6062,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6064,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6066,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6068,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x606a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x606c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x606e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6070,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6072,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6074,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6076,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6078,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x607a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x607c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x607e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6080,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6082,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6084,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6086,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6088,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x608a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x608c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x608e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6090,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6092,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6094,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6096,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6098,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x609a,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x609c,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x609e,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60a0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60a2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60a4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60a6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60a8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60aa,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ac,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ae,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60b0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60b2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60b4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60b6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60b8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ba,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60bc,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60be,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60c0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60c2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60c4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60c6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60c8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ca,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60cc,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ce,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60d0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60d2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60d4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60d6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60d8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60da,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60dc,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60de,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60e0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60e2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60e4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60e6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60e8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ea,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ec,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60ee,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60f0,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60f2,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60f4,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60f6,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60f8,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60fa,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60fc,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x60fe,0x3000,VR::OB_OW,VM::VM1,"Overlay Data",false },
  {0x6000,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6002,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6004,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6006,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6008,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x600a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x600c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x600e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6010,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6012,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6014,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6016,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6018,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x601a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x601c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x601e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6020,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6022,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6024,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6026,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6028,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x602a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x602c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x602e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6030,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6032,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6034,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6036,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6038,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x603a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x603c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x603e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6040,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6042,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6044,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6046,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6048,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x604a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x604c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x604e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6050,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6052,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6054,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6056,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6058,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x605a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x605c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x605e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6060,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6062,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6064,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6066,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6068,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x606a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x606c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x606e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6070,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6072,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6074,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6076,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6078,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x607a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x607c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x607e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6080,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6082,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6084,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6086,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6088,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x608a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x608c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x608e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6090,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6092,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6094,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6096,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x6098,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x609a,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x609c,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x609e,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60a0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60a2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60a4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60a6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60a8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60aa,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ac,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ae,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60b0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60b2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60b4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60b6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60b8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ba,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60bc,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60be,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60c0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60c2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60c4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60c6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60c8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ca,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60cc,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ce,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60d0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60d2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60d4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60d6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60d8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60da,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60dc,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60de,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60e0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60e2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60e4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60e6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60e8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ea,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ec,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60ee,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60f0,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60f2,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60f4,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60f6,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60f8,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60fa,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60fc,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x60fe,0x4000,VR::LT,VM::VM1,"Overlay Comments",true },
  {0x7fe0,0x0010,VR::OB_OW,VM::VM1,"Pixel Data",false },
  {0x7fe0,0x0020,VR::OW,VM::VM1,"Coefficients SDVN",true },
  {0x7fe0,0x0030,VR::OW,VM::VM1,"Coefficients SDHN",true },
  {0x7fe0,0x0040,VR::OW,VM::VM1,"Coefficients SDDN",true },
  {0x7f00,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f02,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f04,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f06,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f08,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f0a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f0c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f0e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f10,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f12,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f14,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f16,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f18,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f1a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f1c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f1e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f20,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f22,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f24,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f26,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f28,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f2a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f2c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f2e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f30,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f32,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f34,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f36,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f38,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f3a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f3c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f3e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f40,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f42,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f44,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f46,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f48,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f4a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f4c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f4e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f50,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f52,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f54,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f56,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f58,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f5a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f5c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f5e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f60,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f62,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f64,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f66,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f68,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f6a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f6c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f6e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f70,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f72,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f74,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f76,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f78,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f7a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f7c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f7e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f80,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f82,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f84,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f86,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f88,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f8a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f8c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f8e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f90,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f92,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f94,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f96,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f98,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f9a,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f9c,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f9e,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fa0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fa2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fa4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fa6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fa8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7faa,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fac,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fae,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fb0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fb2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fb4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fb6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fb8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fba,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fbc,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fbe,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fc0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fc2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fc4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fc6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fc8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fca,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fcc,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fce,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fd0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fd2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fd4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fd6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fd8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fda,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fdc,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fde,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
//  {0x7fe0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fe2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fe4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fe6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fe8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fea,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fec,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7fee,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ff0,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ff2,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ff4,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ff6,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ff8,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ffa,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ffc,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7ffe,0x0010,VR::OB_OW,VM::VM1,"Variable Pixel Data",true },
  {0x7f00,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f02,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f04,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f06,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f08,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f0a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f0c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f0e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f10,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f12,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f14,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f16,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f18,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f1a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f1c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f1e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f20,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f22,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f24,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f26,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f28,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f2a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f2c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f2e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f30,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f32,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f34,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f36,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f38,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f3a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f3c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f3e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f40,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f42,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f44,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f46,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f48,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f4a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f4c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f4e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f50,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f52,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f54,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f56,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f58,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f5a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f5c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f5e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f60,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f62,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f64,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f66,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f68,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f6a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f6c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f6e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f70,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f72,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f74,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f76,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f78,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f7a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f7c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f7e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f80,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f82,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f84,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f86,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f88,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f8a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f8c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f8e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f90,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f92,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f94,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f96,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f98,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f9a,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f9c,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f9e,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fa0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fa2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fa4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fa6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fa8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7faa,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fac,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fae,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fb0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fb2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fb4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fb6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fb8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fba,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fbc,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fbe,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fc0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fc2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fc4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fc6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fc8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fca,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fcc,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fce,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fd0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fd2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fd4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fd6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fd8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fda,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fdc,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fde,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fe0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fe2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fe4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fe6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fe8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fea,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fec,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7fee,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ff0,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ff2,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ff4,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ff6,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ff8,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ffa,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ffc,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7ffe,0x0011,VR::US,VM::VM1,"Variable Next Data Group",true },
  {0x7f00,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f02,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f04,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f06,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f08,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f0a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f0c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f0e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f10,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f12,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f14,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f16,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f18,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f1a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f1c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f1e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f20,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f22,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f24,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f26,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f28,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f2a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f2c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f2e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f30,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f32,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f34,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f36,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f38,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f3a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f3c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f3e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f40,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f42,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f44,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f46,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f48,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f4a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f4c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f4e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f50,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f52,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f54,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f56,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f58,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f5a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f5c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f5e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f60,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f62,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f64,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f66,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f68,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f6a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f6c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f6e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f70,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f72,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f74,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f76,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f78,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f7a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f7c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f7e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f80,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f82,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f84,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f86,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f88,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f8a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f8c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f8e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f90,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f92,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f94,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f96,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f98,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f9a,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f9c,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f9e,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fa0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fa2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fa4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fa6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fa8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7faa,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fac,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fae,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fb0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fb2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fb4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fb6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fb8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fba,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fbc,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fbe,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fc0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fc2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fc4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fc6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fc8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fca,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fcc,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fce,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fd0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fd2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fd4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fd6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fd8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fda,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fdc,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fde,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
//  {0x7fe0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fe2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fe4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fe6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fe8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fea,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fec,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7fee,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ff0,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ff2,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ff4,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ff6,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ff8,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ffa,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ffc,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7ffe,0x0020,VR::OW,VM::VM1,"Variable Coefficients SDVN",true },
  {0x7f00,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f02,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f04,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f06,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f08,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f0a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f0c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f0e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f10,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f12,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f14,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f16,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f18,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f1a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f1c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f1e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f20,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f22,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f24,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f26,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f28,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f2a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f2c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f2e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f30,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f32,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f34,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f36,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f38,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f3a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f3c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f3e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f40,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f42,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f44,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f46,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f48,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f4a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f4c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f4e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f50,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f52,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f54,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f56,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f58,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f5a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f5c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f5e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f60,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f62,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f64,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f66,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f68,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f6a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f6c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f6e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f70,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f72,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f74,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f76,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f78,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f7a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f7c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f7e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f80,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f82,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f84,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f86,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f88,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f8a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f8c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f8e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f90,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f92,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f94,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f96,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f98,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f9a,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f9c,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f9e,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fa0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fa2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fa4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fa6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fa8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7faa,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fac,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fae,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fb0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fb2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fb4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fb6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fb8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fba,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fbc,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fbe,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fc0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fc2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fc4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fc6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fc8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fca,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fcc,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fce,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fd0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fd2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fd4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fd6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fd8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fda,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fdc,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fde,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
//  {0x7fe0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fe2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fe4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fe6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fe8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fea,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fec,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7fee,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ff0,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ff2,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ff4,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ff6,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ff8,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ffa,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ffc,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7ffe,0x0030,VR::OW,VM::VM1,"Variable Coefficients SDHN",true },
  {0x7f00,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f02,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f04,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f06,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f08,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f0a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f0c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f0e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f10,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f12,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f14,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f16,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f18,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f1a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f1c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f1e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f20,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f22,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f24,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f26,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f28,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f2a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f2c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f2e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f30,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f32,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f34,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f36,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f38,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f3a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f3c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f3e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f40,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f42,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f44,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f46,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f48,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f4a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f4c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f4e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f50,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f52,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f54,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f56,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f58,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f5a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f5c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f5e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f60,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f62,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f64,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f66,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f68,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f6a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f6c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f6e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f70,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f72,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f74,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f76,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f78,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f7a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f7c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f7e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f80,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f82,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f84,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f86,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f88,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f8a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f8c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f8e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f90,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f92,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f94,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f96,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f98,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f9a,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f9c,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7f9e,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fa0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fa2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fa4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fa6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fa8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7faa,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fac,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fae,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fb0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fb2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fb4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fb6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fb8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fba,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fbc,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fbe,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fc0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fc2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fc4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fc6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fc8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fca,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fcc,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fce,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fd0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fd2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fd4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fd6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fd8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fda,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fdc,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fde,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
//  {0x7fe0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fe2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fe4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fe6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fe8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fea,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fec,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7fee,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ff0,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ff2,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ff4,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ff6,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ff8,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ffa,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ffc,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0x7ffe,0x0040,VR::OW,VM::VM1,"Variable Coefficients SDDN",true },
  {0xfffa,0xfffa,VR::SQ,VM::VM1,"Digital Signatures Sequence",false },
  {0xfffc,0xfffc,VR::OB,VM::VM1,"Data Set Trailing Padding",false },
  {0xfffe,0xe000,VR::INVALID,VM::VM1,"Item",false },
  {0xfffe,0xe00d,VR::INVALID,VM::VM1,"Item Delimitation Item",false },
  {0xfffe,0xe0dd,VR::INVALID,VM::VM1,"Sequence Delimitation Item",false },
//  {0x0004,0x0000,VR::UL,VM::VM1,"Group Length 0004",true },
//  {0x0008,0x0000,VR::UL,VM::VM1,"Group Length 0008",true },
//  {0x0010,0x0000,VR::UL,VM::VM1,"Group Length 0010",true },
//  {0x0012,0x0000,VR::UL,VM::VM1,"Group Length 0012",true },
//  {0x0018,0x0000,VR::UL,VM::VM1,"Group Length 0018",true },
//  {0x0020,0x0000,VR::UL,VM::VM1,"Group Length 0020",true },
//  {0x0022,0x0000,VR::UL,VM::VM1,"Group Length 0022",true },
//  {0x0028,0x0000,VR::UL,VM::VM1,"Group Length 0028",true },
//  {0x0032,0x0000,VR::UL,VM::VM1,"Group Length 0032",true },
//  {0x0038,0x0000,VR::UL,VM::VM1,"Group Length 0038",true },
//  {0x003a,0x0000,VR::UL,VM::VM1,"Group Length 003a",true },
//  {0x0040,0x0000,VR::UL,VM::VM1,"Group Length 0040",true },
//  {0x0042,0x0000,VR::UL,VM::VM1,"Group Length 0042",true },
//  {0x0044,0x0000,VR::UL,VM::VM1,"Group Length 0044",true },
//  {0x0046,0x0000,VR::UL,VM::VM1,"Group Length 0046",true },
//  {0x0050,0x0000,VR::UL,VM::VM1,"Group Length 0050",true },
//  {0x0054,0x0000,VR::UL,VM::VM1,"Group Length 0054",true },
//  {0x0060,0x0000,VR::UL,VM::VM1,"Group Length 0060",true },
//  {0x0062,0x0000,VR::UL,VM::VM1,"Group Length 0062",true },
//  {0x0064,0x0000,VR::UL,VM::VM1,"Group Length 0064",true },
//  {0x0066,0x0000,VR::UL,VM::VM1,"Group Length 0066",true },
//  {0x0070,0x0000,VR::UL,VM::VM1,"Group Length 0070",true },
//  {0x0072,0x0000,VR::UL,VM::VM1,"Group Length 0072",true },
//  {0x0074,0x0000,VR::UL,VM::VM1,"Group Length 0074",true },
//  {0x0088,0x0000,VR::UL,VM::VM1,"Group Length 0088",true },
//  {0x0100,0x0000,VR::UL,VM::VM1,"Group Length 0100",true },
//  {0x0400,0x0000,VR::UL,VM::VM1,"Group Length 0400",true },
//  {0x1000,0x0000,VR::UL,VM::VM1,"Group Length 1000",true },
//  {0x1010,0x0000,VR::UL,VM::VM1,"Group Length 1010",true },
//  {0x2000,0x0000,VR::UL,VM::VM1,"Group Length 2000",true },
//  {0x2010,0x0000,VR::UL,VM::VM1,"Group Length 2010",true },
//  {0x2020,0x0000,VR::UL,VM::VM1,"Group Length 2020",true },
//  {0x2030,0x0000,VR::UL,VM::VM1,"Group Length 2030",true },
//  {0x2040,0x0000,VR::UL,VM::VM1,"Group Length 2040",true },
//  {0x2050,0x0000,VR::UL,VM::VM1,"Group Length 2050",true },
//  {0x2100,0x0000,VR::UL,VM::VM1,"Group Length 2100",true },
//  {0x2110,0x0000,VR::UL,VM::VM1,"Group Length 2110",true },
//  {0x2120,0x0000,VR::UL,VM::VM1,"Group Length 2120",true },
//  {0x2130,0x0000,VR::UL,VM::VM1,"Group Length 2130",true },
//  {0x2200,0x0000,VR::UL,VM::VM1,"Group Length 2200",true },
//  {0x3002,0x0000,VR::UL,VM::VM1,"Group Length 3002",true },
//  {0x3004,0x0000,VR::UL,VM::VM1,"Group Length 3004",true },
//  {0x3006,0x0000,VR::UL,VM::VM1,"Group Length 3006",true },
//  {0x3008,0x0000,VR::UL,VM::VM1,"Group Length 3008",true },
//  {0x300a,0x0000,VR::UL,VM::VM1,"Group Length 300a",true },
//  {0x300c,0x0000,VR::UL,VM::VM1,"Group Length 300c",true },
//  {0x300e,0x0000,VR::UL,VM::VM1,"Group Length 300e",true },
//  {0x4000,0x0000,VR::UL,VM::VM1,"Group Length 4000",true },
//  {0x4008,0x0000,VR::UL,VM::VM1,"Group Length 4008",true },
//  {0x4ffe,0x0000,VR::UL,VM::VM1,"Group Length 4ffe",true },
//  {0x5200,0x0000,VR::UL,VM::VM1,"Group Length 5200",true },
//  {0x5400,0x0000,VR::UL,VM::VM1,"Group Length 5400",true },
//  {0x5600,0x0000,VR::UL,VM::VM1,"Group Length 5600",true },
//  {0x7fe0,0x0000,VR::UL,VM::VM1,"Group Length 7fe0",true },
//  {0xfffa,0x0000,VR::UL,VM::VM1,"Group Length fffa",true },
//  {0xfffc,0x0000,VR::UL,VM::VM1,"Group Length fffc",true },
//  {0xfffe,0x0000,VR::UL,VM::VM1,"Group Length fffe",true },

 // FIXME: need a dummy element
  {0xffff,0xffff,VR::INVALID,VM::VM0,"",true }, // dummy
  {0xffff,0xffff,VR::INVALID,VM::VM0,0,true } // Gard
};

void Dict::LoadDefault()
{
   unsigned int i = 0;
   DICT_ENTRY n = DICOMV3DataDict[i];
   while( n.name != 0 )
   {
      Tag t(n.group, n.element);
      DictEntry e( n.name, n.vr, n.vm, n.ret );
      AddDictEntry( t, e );
      n = DICOMV3DataDict[++i];
   }
}

/*
void PrivateDict::LoadDefault()
{
  // TODO
}
*/

} // end namespace gdcm
#endif // __gdcmDefaultDicts_cxx
